(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    509891,      13404]
NotebookOptionsPosition[    477833,      12319]
NotebookOutlinePosition[    479060,      12359]
CellTagsIndexPosition[    478796,      12350]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["B splines", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.5868091277947607`*^9, 3.586809129160986*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "BSplineCurve", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5862810127748833`*^9, 3.586281018963665*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"BSplineCurve\\\", \\\"[\\\", \
RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\
\"}], \\\"]\\\"}]\) is a graphics primitive which represents a non-uniform \
rational B-spline curve with control points \
\!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"i\\\", \
\\\"TI\\\"]]\).\"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BSplineCurve"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.586283246977421*^9},
 CellTags->"Info3586261646-2376400"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "BSplineCurve", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Protected", ",", "ReadProtected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "BSplineCurve", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"SplineClosed", "\[Rule]", "False"}], ",", 
           RowBox[{"SplineDegree", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"SplineKnots", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"SplineWeights", "\[Rule]", "Automatic"}]}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[BSplineCurve],
  Editable->False]], "Print",
 CellChangeTimes->{3.5862832470977173`*^9},
 CellTags->"Info3586261646-2376400"]
}, Closed]]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellID->21035271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}]}]}], "]"}], ",", "Green", 
    ",", 
    RowBox[{"Line", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "pts", "]"}]}], "}"}], "]"}]], "Input",
 CellID->145180654],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 0}, {0, 2}, {2, 3}, {4, 0}, {6, 3}, {8, 2}, {8, 0}},
    SplineKnots->{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2}], 
   {RGBColor[0, 1, 0], 
    LineBox[{{0, 0}, {0, 2}, {2, 3}, {4, 0}, {6, 3}, {8, 2}, {8, 0}}]}, 
   {RGBColor[1, 0, 0], 
    PointBox[{{0, 0}, {0, 2}, {2, 3}, {4, 0}, {6, 3}, {8, 2}, {8, 
     0}}]}}]], "Output",
 CellChangeTimes->{3.586281071388303*^9, 3.586283247251747*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellID->784820924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", 
    ",", "4", ",", "4", ",", "4"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586281279672728*^9, 3.586281288201722*^9}, {
  3.586281349391514*^9, 3.586281367221912*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", 
   ",", "4", ",", "4", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{{3.5862812901159363`*^9, 3.58628129364151*^9}, {
   3.5862813515190372`*^9, 3.58628136778093*^9}, 3.58628169540061*^9, 
   3.5862832473947697`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "pts", "]"}]], "Input",
 CellChangeTimes->{{3.586281697743753*^9, 3.5862817015964413`*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{3.586281702167342*^9, 3.586283247398218*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "k", "]"}]], "Input",
 CellChangeTimes->{{3.586281721037437*^9, 3.58628172250653*^9}}],

Cell[BoxData["11"], "Output",
 CellChangeTimes->{3.586281723150681*^9, 3.586283247401614*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.58628171272519*^9, 3.586283247428521*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "pts", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
  3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
  3.5862812859544287`*^9}},
 CellID->640709794],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 0}, {0, 2}, {2, 3}, {4, 0}, {6, 3}, {8, 2}, {8, 0}},
    SplineKnots->{0, 0, 0, 0, 1, 2, 3, 4, 4, 4, 4}], 
   {RGBColor[1, 0, 0], 
    PointBox[{{0, 0}, {0, 2}, {2, 3}, {4, 0}, {6, 3}, {8, 2}, {8, 
     0}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586283247455233*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "1.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.75", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.1", ",", "0.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.5", ",", ".5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.9", ",", ".5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.3", ",", ".9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586281459678256*^9, 3.586281514048004*^9}, {
  3.586281561191247*^9, 3.586281638718054*^9}},
 CellID->926501700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "1.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3`", ",", "0.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586281639833309*^9, 3.586281794780718*^9, 
  3.586282982285369*^9, 3.58628324765536*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "pts", "]"}]], "Input",
 CellChangeTimes->{{3.58628165797115*^9, 3.586281659956924*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.586281660583235*^9, 3.586281795628015*^9, 
  3.586283247660452*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", 
    RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3", ",", "4", ",", "5",
     ",", "6", ",", "6.5", ",", "7", ",", "7", ",", "7"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", 
   FractionBox["1", "2"], ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", 
   ",", "6", ",", "6.5`", ",", "7", ",", "7", ",", "7"}], "}"}]], "Output",
 CellChangeTimes->{3.5862818872421503`*^9, 3.586283247976412*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "pts", "]"}], "-", "order"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "pts", "]"}], "-", "order", "+", "1"}], ",", 
       RowBox[{"{", "order", "}"}]}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586281279672728*^9, 3.586281288201722*^9}, {
  3.586281349391514*^9, 3.586281367221912*^9}, {3.586281772386187*^9, 
  3.586281829400879*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", 
   ",", "5", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5862812901159363`*^9, 3.58628129364151*^9}, {
   3.5862813515190372`*^9, 3.58628136778093*^9}, {3.58628178927712*^9, 
   3.586281797456189*^9}, 3.586281830246014*^9, 3.5862819104711027`*^9, 
   3.586282985445656*^9, 3.586283247981927*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curve", "=", 
  RowBox[{"BSplineCurve", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586283996060409*^9, 3.586283998382266*^9}}],

Cell[BoxData[
 RowBox[{"BSplineCurve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2`", ",", "1.3`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.75`", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.1`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.9`", ",", "0.5`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3`", ",", "0.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"SplineKnots", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", 
      "4", ",", "5", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7"}], 
     "}"}]}]}], "]"}]], "Output",
 CellChangeTimes->{{3.586283975554245*^9, 3.586283999604568*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "curve", "]"}]], "Input",
 CellChangeTimes->{{3.586284242927195*^9, 3.5862842470430813`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"BSplineCurve", "[", 
    RowBox[{
     RowBox[{"List", "[", 
      RowBox[{
       RowBox[{"List", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"0.2`", ",", "1.3`"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"1.5`", ",", "2"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"1.75`", ",", "2"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"2", ",", "2"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"2.1`", ",", "0.5`"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"2.5`", ",", "0.5`"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"2.9`", ",", "0.5`"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"3.3`", ",", "0.9`"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"4", ",", "2"}], "]"}]}], "]"}], ",", 
     RowBox[{"Rule", "[", 
      RowBox[{"SplineKnots", ",", 
       RowBox[{"List", "[", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", 
         "4", ",", "5", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7"}], 
        "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{3.58628424884768*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curve", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5862840009472427`*^9, 3.5862840282035*^9}}],

Cell[BoxData[
 RowBox[{"SplineKnots", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", 
    ",", "5", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7"}], 
   "}"}]}]], "Output",
 CellChangeTimes->{{3.5862840040044613`*^9, 3.5862840289098053`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "pts", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
  3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
  3.5862812859544287`*^9}},
 CellID->310147503],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 1}, {0.2, 1.3}, {1.5, 2}, {1.75, 2}, {2, 2}, {2.1, 
     0.5}, {2.5, 0.5}, {2.9, 0.5}, {3.3, 0.9}, {4, 2}},
    SplineKnots->{0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 7, 7}], 
   {RGBColor[1, 0, 0], 
    PointBox[{{0, 1}, {0.2, 1.3}, {1.5, 2}, {1.75, 2}, {2, 2}, {2.1, 0.5}, {
      2.5, 0.5}, {2.9, 0.5}, {3.3, 0.9}, {4, 2}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "1.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"1.75", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.1", ",", "0.5"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"2.5", ",", ".5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.9", ",", ".5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.3", ",", ".9"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586281459678256*^9, 3.586281514048004*^9}, {
  3.586281561191247*^9, 3.586281638718054*^9}, {3.586285468079494*^9, 
  3.586285477355423*^9}},
 CellID->202989881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "1.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3`", ",", "0.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586281639833309*^9, 3.586281794780718*^9, 
  3.586282982285369*^9, 3.58628324765536*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - fit a quadratic", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"alpha", "[", 
   RowBox[{"P0_", ",", "P3_", ",", "T0_", ",", "T3_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"16", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"T0", "+", "T3"}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{"T0", "+", "T3"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"b", "=", 
      RowBox[{"12", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"P3", "-", "P0"}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{"T0", "+", "T3"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{
       RowBox[{"-", "36"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"P3", "-", "P0"}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{"P3", "-", "P0"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"disc", "=", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<a= \>\"", ",", "a", ",", "\"\< b= \>\"", ",", " ", "b", ",", " ", 
       "\"\< c= \>\"", ",", " ", "c", ",", " ", "\"\< disc= \>\"", ",", " ", 
       "disc"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.586526186609445*^9, 3.586526326012541*^9}, {
  3.586526396795863*^9, 3.586526397106889*^9}, {3.586526472321742*^9, 
  3.586526524813134*^9}, {3.5865269681557627`*^9, 3.586526974729698*^9}, {
  3.586527414785507*^9, 3.586527424577322*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Q", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"T", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.707107", ",", "0.707107"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.447214", ",", "0.894427"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"CV", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.191413", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.364651", ",", "0.114651"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.713448", ",", "0.463448"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.865004", ",", "0.730008"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"U", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "0.403872", ",", "0.403872", ",", 
    "1", ",", "1", ",", "1", ",", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.586526106276647*^9, 3.586526124566341*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707107`", ",", "0.707107`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.447214`", ",", "0.894427`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811510393*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.191413`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.364651`", ",", "0.114651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.713448`", ",", "0.463448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.865004`", ",", "0.730008`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811511594*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.403872`", ",", "0.403872`", ",", 
   "1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.5865328115125017`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Q1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"T1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.959722134072835", ",", "0.280950930538918"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.749678175815866", ",", "0.66180256323574"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.306994221445843", ",", "0.951711378517069"}], "}"}]}], 
   "}"}]}], "\n", 
 RowBox[{"CV1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.180343409312779", ",", "0.0527940816035624"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.359126393657023", ",", "0.125639285259194"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.727961869426204", ",", "0.451240684833979"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.906649307821086", ",", "0.710603947133938"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"U1", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0.380018414821714", ",", 
    "0.380018414821714", ",", "1", ",", "1", ",", "1"}], 
   "}"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.586546160626336*^9, 3.586546160627181*^9}, {
  3.586547311096607*^9, 3.5865473141448097`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586547316001281*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.959722134072835`", ",", "0.280950930538918`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.749678175815866`", ",", "0.66180256323574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.306994221445843`", ",", "0.951711378517069`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586547316002839*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.180343409312779`", ",", "0.0527940816035624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.359126393657023`", ",", "0.125639285259194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.727961869426204`", ",", "0.451240684833979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.906649307821086`", ",", "0.710603947133938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5865473160048018`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.380018414821714`", ",", 
   "0.380018414821714`", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.5865473160065603`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Q", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0`20", ",", "0`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5`20", ",", "0.25`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1`20", ",", "1`20"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"T", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.959722134072835`20", ",", "0.280950930538918`20"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0.749678175815866`20", ",", "0.66180256323574`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.306994221445843`20", ",", "0.951711378517069`20"}], "}"}]}], 
   "}"}]}], "\n", 
 RowBox[{"CV", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0`20", ",", "0`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.180343409312779`20", ",", "0.0527940816035624`20"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0.359126393657023`20", ",", "0.125639285259194`20"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0.727961869426204`20", ",", "0.451240684833979`20"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0.906649307821086`20", ",", "0.710603947133938`20"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"1`20", ",", "1`20"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"U", "=", 
  RowBox[{"{", 
   RowBox[{
   "0`20", ",", "0`20", ",", "0`20", ",", "0.380018414821714`20", ",", 
    "0.380018414821714`20", ",", "1`20", ",", "1`20", ",", "1`20"}], 
   "}"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.5865472476154947`*^9, 3.586547247616477*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`20.", ",", "0.25`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "1.`20."}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586549353511928*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.959722134072835`20.", ",", "0.280950930538918`20."}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.749678175815866`20.", ",", "0.66180256323574`20."}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.306994221445843`20.", ",", 
     "0.9517113785170689999999999999999999999999999999999999999999`20."}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58654935351917*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1803434093127789999999999999999999999999999999999999999999`20.", ",", 
     "0.0527940816035623999999999999999999999999999999999999999999`20."}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.359126393657023`20.", ",", "0.125639285259194`20."}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7279618694262040000000000000000000000000000000000000000001`20.", ",", 
     "0.4512406848339789999999999999999999999999999999999999999999`20."}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9066493078210859999999999999999999999999999999999999999999`20.", ",", 
     "0.710603947133938`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "1.`20."}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5865493535202208`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "1.`20.", ",", "1.`20.", ",", "1.`20."}], "}"}]], "Output",
 CellChangeTimes->{3.5865493535210953`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2.", "]"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "5.", "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586547680626912*^9, 3.586547768141899*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7071067811865475`", ",", "0.7071067811865475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4472135954999579`", ",", "0.8944271909999159`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5865464473317223`*^9, 3.586547249846683*^9, 3.586547317628751*^9, {
   3.586547759309441*^9, 3.586547768728492*^9}, 3.586547939556041*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aa", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"alpha", "[", 
     RowBox[{
      RowBox[{"Q", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"Q", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"T", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"T", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "20"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586526353595037*^9, 3.58652636680968*^9}, {
  3.5865270005814657`*^9, 3.586527001299728*^9}, {3.586546458531838*^9, 
  3.586546462283779*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a= \"\>", "\[InvisibleSpace]", "12.585786437626904`", 
   "\[InvisibleSpace]", "\<\" b= \"\>", "\[InvisibleSpace]", 
   "12.363961030678926`", "\[InvisibleSpace]", "\<\" c= \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "11.25`19.69897000433602"}], 
   "\[InvisibleSpace]", "\<\" disc= \"\>", "\[InvisibleSpace]", 
   "719.2279220613577`"}],
  SequenceForm[
  "a= ", 12.585786437626904`, " b= ", 12.363961030678926`, 
   " c= ", -11.25`19.69897000433602, " disc= ", 719.2279220613577],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.586526530272545*^9, {3.5865269797598953`*^9, 3.586527002464349*^9}, 
   3.586527296205244*^9, {3.5865274196453543`*^9, 3.5865274347778597`*^9}, 
   3.58652749549962*^9, 3.586532811516898*^9, {3.5865464495710087`*^9, 
   3.586546463437852*^9}, 3.586547274827668*^9, 3.58654742371772*^9, 
   3.586547775456325*^9, 3.5865479449884872`*^9}],

Cell[BoxData["0.5742376167381336`"], "Output",
 CellChangeTimes->{
  3.586526368699325*^9, 3.5865264014341393`*^9, 3.586526530309929*^9, {
   3.586526979779542*^9, 3.586527002483478*^9}, 3.586527296238443*^9, {
   3.586527419717494*^9, 3.58652743480581*^9}, 3.5865274955008993`*^9, 
   3.586532811517809*^9, {3.5865464495916033`*^9, 3.586546463460408*^9}, 
   3.586547274848837*^9, 3.586547423824046*^9, 3.586547775641633*^9, 
   3.586547945079729*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pk1", "=", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"aa", "/", "3"}], 
    RowBox[{"T", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5865269921910152`*^9, 3.586527008360087*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.19141253891271118`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.586527011052788*^9, 3.586527297543738*^9, 
  3.586527495507894*^9, 3.5865328115223083`*^9, 3.586547286620604*^9, 
  3.586547424922757*^9, 3.5865477795630293`*^9, 3.586547949451497*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pk2", "=", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"aa", "/", "3"}], 
    RowBox[{"T", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.586527013210849*^9, 3.586527024538179*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.36465089573068804`", ",", "0.11465089573068804`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5865270256375723`*^9, 3.586527298757901*^9, 
  3.5865274957221403`*^9, 3.5865328115266647`*^9, 3.586547290767275*^9, 
  3.586547425930812*^9, 3.586547781861018*^9, 3.586547951348695*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uk1", "=", 
  RowBox[{"0", "+", 
   RowBox[{"3", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Pk1", "-", "Pk2"}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{"Pk1", "-", "Pk2"}], ")"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.586527287330463*^9, 3.586527293289044*^9}}],

Cell[BoxData["0.6232232388828067`"], "Output",
 CellChangeTimes->{
  3.586527300800745*^9, 3.586527495731344*^9, 3.58653281153063*^9, {
   3.586547398273286*^9, 3.586547427076323*^9}, 3.5865477847390957`*^9, 
   3.586547982227689*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aa", "=", 
  RowBox[{"alpha", "[", 
   RowBox[{
    RowBox[{"Q", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"Q", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"T", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"T", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586526353595037*^9, 3.58652636680968*^9}, {
  3.5865270005814657`*^9, 3.586527001299728*^9}, {3.58652710993018*^9, 
  3.586527114873283*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a= \"\>", "\[InvisibleSpace]", "12.102633403898974`", 
   "\[InvisibleSpace]", "\<\" b= \"\>", "\[InvisibleSpace]", 
   "21.339728009797202`", "\[InvisibleSpace]", "\<\" c= \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "29.25`19.381549592483875"}], 
   "\[InvisibleSpace]", "\<\" disc= \"\>", "\[InvisibleSpace]", 
   "1871.392099788303`"}],
  SequenceForm[
  "a= ", 12.102633403898974`, " b= ", 21.339728009797202`, 
   " c= ", -29.25`19.381549592483875, " disc= ", 1871.392099788303],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.586526530272545*^9, {3.5865269797598953`*^9, 3.586527002464349*^9}, 
   3.586527116442008*^9, 3.586527303018194*^9, 3.5865274957380047`*^9, 
   3.5865328115342712`*^9, {3.5865474088827543`*^9, 3.586547428260571*^9}, 
   3.586547786046269*^9, 3.5865479844092073`*^9}],

Cell[BoxData["0.9055823201665127`"], "Output",
 CellChangeTimes->{
  3.586526368699325*^9, 3.5865264014341393`*^9, 3.586526530309929*^9, {
   3.586526979779542*^9, 3.586527002483478*^9}, 3.586527116522174*^9, 
   3.586527303041581*^9, 3.586527495739366*^9, 3.5865328115350847`*^9, {
   3.5865474089011087`*^9, 3.58654742828402*^9}, 3.5865477860705357`*^9, 
   3.586547984428731*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pk11", "=", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"aa", "/", "3"}], 
    RowBox[{"T", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5865269921910152`*^9, 3.586527008360087*^9}, {
   3.5865271339671383`*^9, 3.5865271359501657`*^9}, 3.5865478191518583`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7134477998374628`", ",", "0.46344779983746276`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.586527011052788*^9, {3.586527122651718*^9, 3.586527141958638*^9}, 
   3.586527304648752*^9, 3.5865274957461443`*^9, 3.586532811714703*^9, {
   3.586547416781679*^9, 3.586547429440702*^9}, 3.586547787794013*^9, 
   3.586547832035851*^9, 3.586547986308391*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pk21", "=", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"aa", "/", "3"}], 
    RowBox[{"T", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.586527013210849*^9, 3.586527024538179*^9}, {
   3.586527138433124*^9, 3.58652714000663*^9}, 3.58654782097692*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.86500375819238`", ",", "0.7300075163847599`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5865270256375723`*^9, {3.586527124164097*^9, 3.586527143671748*^9}, 
   3.586527305989105*^9, 3.586527495752655*^9, 3.586532811721209*^9, {
   3.586547418173933*^9, 3.586547430466503*^9}, 3.5865477889358*^9, 
   3.5865478333186893`*^9, 3.586547988055725*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uk2", "=", 
  RowBox[{"uk1", "+", 
   RowBox[{"3", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Pk11", "-", "Pk21"}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{"Pk11", "-", "Pk21"}], ")"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.586527225093711*^9, 3.586527278930656*^9}, {
  3.586547822777647*^9, 3.5865478267680902`*^9}}],

Cell[BoxData["1.5431197651225113`"], "Output",
 CellChangeTimes->{3.586527308995224*^9, 3.586527495759014*^9, 
  3.586532811727807*^9, 3.586547432236644*^9, 3.5865477900813017`*^9, 
  3.586547834394587*^9, 3.586547997154687*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uk1", "/", "uk2"}]], "Input",
 CellChangeTimes->{{3.586527313250353*^9, 3.586527316344019*^9}}],

Cell[BoxData["0.40387224178502296`"], "Output",
 CellChangeTimes->{3.5865273173707123`*^9, 3.5865274959366913`*^9, 
  3.5865328117313128`*^9, 3.58654743557377*^9, 3.586547791273147*^9, 
  3.586547837196579*^9, 3.586547998915571*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"[", "2", "]"}], "]"}], ".", 
  RowBox[{"T", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586526432320733*^9, 3.5865264452846317`*^9}}],

Cell[BoxData["0.9999999999999998`"], "Output",
 CellChangeTimes->{{3.5865264388454*^9, 3.5865264461162567`*^9}, 
   3.5865274959440193`*^9, 3.586532811734667*^9, 3.58654745059347*^9, 
   3.586547803668887*^9, 3.5865478399526033`*^9, 3.5865480003130093`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CV", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Q", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "Pk1", ",", "Pk2", ",", "Pk11", ",",
     "Pk21", ",", 
    RowBox[{"Q", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5865478425378227`*^9, 3.5865478733226*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.19141253891271118`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.36465089573068804`", ",", "0.11465089573068804`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7134477998374628`", ",", "0.46344779983746276`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.86500375819238`", ",", "0.7300075163847599`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "1.`20."}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586547874510611*^9, 3.5865480070442343`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{{3.586547882107627*^9, 3.586547885002822*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.40387224178502296`", ",", 
   "0.40387224178502296`", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.586547885496572*^9, 3.586548014457406*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"U", "=", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", 
    RowBox[{"uk1", "/", "uk2"}], ",", 
    RowBox[{"uk1", "/", "uk2"}], ",", "1", ",", "1", ",", "1"}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.58654788944125*^9, 3.586547905406527*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.40387224178502296`", ",", 
   "0.40387224178502296`", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.5865479063075*^9, 3.586548018973291*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.586285520299695*^9, 3.5862855228023567`*^9}, {
  3.58652516407553*^9, 3.5865251643997717`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1803434093127789999999999999999999999999999999999999999999`20.", ",", 
     "0.0527940816035623999999999999999999999999999999999999999999`20."}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.359126393657023`20.", ",", "0.125639285259194`20."}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7279618694262040000000000000000000000000000000000000000001`20.", ",", 
     "0.4512406848339789999999999999999999999999999999999999999999`20."}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9066493078210859999999999999999999999999999999999999999999`20.", ",", 
     "0.710603947133938`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "1.`20."}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586285536177774*^9, 3.5865252023895693`*^9, 
  3.586526142320653*^9, 3.586527495951768*^9, 3.5865328117386923`*^9, 
  3.586547456480462*^9, 3.58654790765177*^9, 3.586548022287084*^9, 
  3.586549364653852*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "pts", "]"}]], "Input",
 CellChangeTimes->{{3.58628165797115*^9, 3.586281659956924*^9}}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{3.586281660583235*^9, 3.586281795628015*^9, 
  3.586283247660452*^9, 3.586285538707103*^9, 3.586525203556143*^9, 
  3.5865261423287277`*^9, 3.586527495958412*^9, 3.586532811928479*^9, 
  3.5865475000676317`*^9, 3.586547908873931*^9, 3.58654802395954*^9, 
  3.5865493662008867`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.586547501467462*^9, 
  3.586547909957402*^9, 3.586548025091651*^9, 3.586549367504609*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", "U"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "1.`20.", ",", "1.`20.", ",", "1.`20."}], "}"}]], "Output",
 CellChangeTimes->{
  3.5862818872421503`*^9, 3.586283247976412*^9, 3.5862855627411947`*^9, {
   3.586525205834783*^9, 3.586525226876495*^9}, 3.586526142341413*^9, 
   3.5865274960456743`*^9, 3.586532811936988*^9, 3.586532855305749*^9, 
   3.586547502654204*^9, 3.586547911024736*^9, 3.586548026179552*^9, 
   3.586549369987873*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", "U", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "0.3800184148217139999999999999999999999999999999999999999999`20.", ",", 
   "1.`20.", ",", "1.`20.", ",", "1.`20.", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.586541840318301*^9, 3.5865430352061996`*^9, 
  3.586546204777543*^9, 3.586547532792371*^9, 3.58654791214146*^9, 
  3.586548027403001*^9, 3.586549371149438*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, {
   3.586547505726269*^9, 3.586547535380576*^9}, 3.5865479133319073`*^9, 
   3.586548028580172*^9, 3.586549372333817*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.5865462074170094`*^9, 3.586547564137911*^9, 3.586547914497857*^9, 
  3.586548029727995*^9, 3.5865493735014772`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586546210977779*^9, 3.5865475660106583`*^9, 3.586547915768013*^9, 
  3.5865480308160563`*^9, 3.586549374616913*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14137005934761665`", ",", "0.04640478109589416`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586546212593562*^9, 3.586547567320633*^9, 3.586547916886053*^9, 
  3.5865480322016172`*^9, 3.586549375625969*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49929066648883985`", ",", "0.2493738129893353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49929066648883985`", ",", "0.2493738129893353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9, 3.5865462157956448`*^9, 3.58654756846005*^9, 
  3.586547918355942*^9, 3.586548033301526*^9, 3.586549376779729*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fg", "=", 
      RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"fg", "-", 
       RowBox[{"Q", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"fg", "-", 
       RowBox[{"Q", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586548523455798*^9, 3.5865486773031387`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586548575661632*^9, 3.5865485790585337`*^9}}],

Cell[BoxData["0.3125`"], "Output",
 CellChangeTimes->{{3.586548579657422*^9, 3.586548679837819*^9}, 
   3.5865493868316107`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"U", "[", 
  RowBox[{"[", "4", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586548882966405*^9, 3.586548885268894*^9}}],

Cell[BoxData["0.3800184148217139999999999999999999999999999999999999999999`20.\
"], "Output",
 CellChangeTimes->{3.586548885945424*^9, 3.586549388054963*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "+", "0.000641"}], "]"}]], "Input",
 CellChangeTimes->{{3.5865491637139*^9, 3.586549175465026*^9}, {
  3.586549222622403*^9, 3.586549313595395*^9}, {3.5865494238413363`*^9, 
  3.586549453637949*^9}, {3.586549534391082*^9, 3.586549534573743*^9}, {
  3.5865496101258307`*^9, 3.586549610323576*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.49999977677883584`", ",", "0.2500001288331264`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.586549176382094*^9, {3.5865492318951178`*^9, 3.586549314717412*^9}, 
   3.58654938970971*^9, {3.5865494286618547`*^9, 3.5865494540796623`*^9}, 
   3.586549535200491*^9, 3.586549610779531*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9},
 CellID->943442095],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 0}, {0.19141253891271118`, 0.}, {0.36465089573068804`,
      0.11465089573068804`}, {0.7134477998374628, 0.46344779983746276`}, {
     0.86500375819238, 0.7300075163847599}, {1., 1.}},
    SplineKnots->{
     0, 0, 0, 0, 0.40387224178502296`, 0.40387224178502296`, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], PointBox[{{0, 0}, {0.5, 0.25}, {1., 1.}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, 3.5865475370983973`*^9, 3.586548137678146*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - fit a quadratic  - 11 points\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Q", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.1", ",", "0.01"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "0.04"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.3", ",", "0.09"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.6", ",", "0.36"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.7", ",", "0.49"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.8", ",", "0.64"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.9", ",", "0.81"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"CV", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.0335482449754428", ",", "0.000244050445605944"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.0670903649055555", ",", "0.00348078075972047"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.134185008249399", ",", "0.0167718637070582"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.167605153930736", ",", "0.0271529429351637"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.234680164839113", ",", "0.0537533623636735"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.267946977766875", ",", "0.0709088351508517"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.334984341402675", ",", "0.110837093737986"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.368127888669724", ",", "0.134657207372213"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.435119774824192", ",", "0.187925139984643"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.468193727338976", ",", "0.218352361126358"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.535139488036816", ",", "0.284964229837487"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.568188690567024", ",", "0.321982614769324"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.635092310700528", ",", "0.401938477802914"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.668144610016793", ",", "0.445552949257058"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.735011920471819", ",", "0.538851280949289"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.768081466038377", ",", "0.589073686416038"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.834918427872055", ",", "0.695712671822877"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.868010871339467", ",", "0.752555295681504"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.934823397167685", ",", "0.872534362060673"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.968231319588658", ",", "0.935859791288493"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"U", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0.0682515405522959", ",", 
    "0.0682515405522959", ",", "0.139130828313668", ",", "0.139130828313668", 
    ",", "0.214940910903466", ",", "0.214940910903466", ",", 
    "0.297608024650848", ",", "0.297608024650848", ",", "0.388631401685792", 
    ",", "0.388631401685792", ",", "0.489140911864926", ",", 
    "0.489140911864926", ",", "0.599977780756827", ",", "0.599977780756827", 
    ",", "0.721769168608119", ",", "0.721769168608119", ",", 
    "0.854986970557487", ",", "0.854986970557487", ",", "1", ",", "1", ",", 
    "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.586543025781378*^9, 3.5865430257818813`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "0.01`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.04`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", "0.09`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6`", ",", "0.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7`", ",", "0.49`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.64`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", "0.81`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029275394*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0335482449754428`", ",", "0.000244050445605944`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0670903649055555`", ",", "0.00348078075972047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.134185008249399`", ",", "0.0167718637070582`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.167605153930736`", ",", "0.0271529429351637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.234680164839113`", ",", "0.0537533623636735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.267946977766875`", ",", "0.0709088351508517`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.334984341402675`", ",", "0.110837093737986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.368127888669724`", ",", "0.134657207372213`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.435119774824192`", ",", "0.187925139984643`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.468193727338976`", ",", "0.218352361126358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.535139488036816`", ",", "0.284964229837487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.568188690567024`", ",", "0.321982614769324`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.635092310700528`", ",", "0.401938477802914`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.668144610016793`", ",", "0.445552949257058`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.735011920471819`", ",", "0.538851280949289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.768081466038377`", ",", "0.589073686416038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.834918427872055`", ",", "0.695712671822877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.868010871339467`", ",", "0.752555295681504`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.934823397167685`", ",", "0.872534362060673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.968231319588658`", ",", "0.935859791288493`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029277646*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.0682515405522959`", ",", 
   "0.0682515405522959`", ",", "0.139130828313668`", ",", 
   "0.139130828313668`", ",", "0.214940910903466`", ",", "0.214940910903466`",
    ",", "0.297608024650848`", ",", "0.297608024650848`", ",", 
   "0.388631401685792`", ",", "0.388631401685792`", ",", "0.489140911864926`",
    ",", "0.489140911864926`", ",", "0.599977780756827`", ",", 
   "0.599977780756827`", ",", "0.721769168608119`", ",", "0.721769168608119`",
    ",", "0.854986970557487`", ",", "0.854986970557487`", ",", "1", ",", "1", 
   ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029279055*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0335482449754428`", ",", "0.000244050445605944`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0670903649055555`", ",", "0.00348078075972047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.134185008249399`", ",", "0.0167718637070582`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.167605153930736`", ",", "0.0271529429351637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.234680164839113`", ",", "0.0537533623636735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.267946977766875`", ",", "0.0709088351508517`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.334984341402675`", ",", "0.110837093737986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.368127888669724`", ",", "0.134657207372213`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.435119774824192`", ",", "0.187925139984643`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.468193727338976`", ",", "0.218352361126358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.535139488036816`", ",", "0.284964229837487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.568188690567024`", ",", "0.321982614769324`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.635092310700528`", ",", "0.401938477802914`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.668144610016793`", ",", "0.445552949257058`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.735011920471819`", ",", "0.538851280949289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.768081466038377`", ",", "0.589073686416038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.834918427872055`", ",", "0.695712671822877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.868010871339467`", ",", "0.752555295681504`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.934823397167685`", ",", "0.872534362060673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.968231319588658`", ",", "0.935859791288493`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5865418137588053`*^9, 3.5865430316715193`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["11"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", "U", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.0682515405522959`", ",", 
   "0.0682515405522959`", ",", "0.139130828313668`", ",", 
   "0.139130828313668`", ",", "0.214940910903466`", ",", "0.214940910903466`",
    ",", "0.297608024650848`", ",", "0.297608024650848`", ",", 
   "0.388631401685792`", ",", "0.388631401685792`", ",", "0.489140911864926`",
    ",", "0.489140911864926`", ",", "0.599977780756827`", ",", 
   "0.599977780756827`", ",", "0.721769168608119`", ",", "0.721769168608119`",
    ",", "0.854986970557487`", ",", "0.854986970557487`", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.586541840318301*^9, 3.5865430352061996`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14545503419198236`", ",", "0.02117016491543679`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10000408235069416`", ",", "0.010000808691409523`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.10000408235069416`", ",", "0.010000808691409523`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.20001533463020005`", ",", "0.04000608136457342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.20001533463020005`", ",", "0.04000608136457342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3000153648363907`", ",", "0.09000915148101454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3000153648363907`", ",", "0.09000915148101454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.40001233926882723`", ",", "0.1600098114469993`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.40001233926882723`", ",", "0.1600098114469993`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5000087816908677`", ",", "0.2500087378921839`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5000087816908677`", ",", "0.2500087378921839`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000058909297006`", ",", "0.3600070401925529`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000058909297006`", ",", "0.3600070401925529`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000038666084779`", ",", "0.49000539498475215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000038666084779`", ",", "0.49000539498475215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8000025365999932`", ",", "0.6400040471685468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8000025365999932`", ",", "0.6400040471685468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9000009199943705`", ",", "0.810001652086406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9000009199943705`", ",", "0.810001652086406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.9999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.9999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.9999999999999999`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}},
 CellID->371110108],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 0}, {0.0335482449754428, 0.000244050445605944}, {
     0.0670903649055555, 0.00348078075972047}, {0.134185008249399, 
     0.0167718637070582}, {0.167605153930736, 0.0271529429351637}, {
     0.234680164839113, 0.0537533623636735}, {0.267946977766875, 
     0.0709088351508517}, {0.334984341402675, 0.110837093737986}, {
     0.368127888669724, 0.134657207372213}, {0.435119774824192, 
     0.187925139984643}, {0.468193727338976, 0.218352361126358}, {
     0.535139488036816, 0.284964229837487}, {0.568188690567024, 
     0.321982614769324}, {0.635092310700528, 0.401938477802914}, {
     0.668144610016793, 0.445552949257058}, {0.735011920471819, 
     0.538851280949289}, {0.768081466038377, 0.589073686416038}, {
     0.834918427872055, 0.695712671822877}, {0.868010871339467, 
     0.752555295681504}, {0.934823397167685, 0.872534362060673}, {
     0.968231319588658, 0.935859791288493}, {1, 1}},
    SplineKnots->{
     0, 0, 0, 0, 0.0682515405522959, 0.0682515405522959, 0.139130828313668, 
      0.139130828313668, 0.214940910903466, 0.214940910903466, 
      0.297608024650848, 0.297608024650848, 0.388631401685792, 
      0.388631401685792, 0.489140911864926, 0.489140911864926, 
      0.599977780756827, 0.599977780756827, 0.721769168608119, 
      0.721769168608119, 0.854986970557487, 0.854986970557487, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], 
    PointBox[{{0, 0}, {0.1, 0.01}, {0.2, 0.04}, {0.3, 0.09}, {0.4, 0.16}, {
      0.5, 0.25}, {0.6, 0.36}, {0.7, 0.49}, {0.8, 0.64}, {0.9, 0.81}, {1, 
      1}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{{3.5865421722850103`*^9, 3.5865421740253563`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.0682515`", ",", "0.0682515`", ",", 
   "0.139131`", ",", "0.139131`", ",", "0.214941`", ",", "0.214941`", ",", 
   "0.297608`", ",", "0.297608`", ",", "0.388631`", ",", "0.388631`", ",", 
   "0.489141`", ",", "0.489141`", ",", "0.599978`", ",", "0.599978`", ",", 
   "0.721769`", ",", "0.721769`", ",", "0.854987`", ",", "0.854987`", ",", 
   "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.586542175094131*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pU", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"U", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3", ",", 
      RowBox[{
       RowBox[{"Length", "[", "U", "]"}], "-", "1"}], ",", "2"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.58654217736132*^9, 3.586542230129209*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.0682515`", ",", "0.139131`", ",", "0.214941`", ",", 
   "0.297608`", ",", "0.388631`", ",", "0.489141`", ",", "0.599978`", ",", 
   "0.721769`", ",", "0.854987`", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.586542210077826*^9, 3.586542231715576*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.586542221077653*^9, 3.586542253287551*^9}}],

Cell[BoxData["11"], "Output",
 CellChangeTimes->{{3.5865422477462597`*^9, 3.586542253767851*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586542348043715*^9, 3.586542351061006*^9}}],

Cell[BoxData["22"], "Output",
 CellChangeTimes->{3.586542352255085*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.586542367044938*^9, 3.586542368572855*^9}}],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{3.586542369818921*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"BSplineBasis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "k"}], "}"}], ",", 
       RowBox[{"j", "-", "1"}], ",", 
       RowBox[{"pU", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "pU", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "Q", "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.586542162387398*^9, {3.586542259682562*^9, 3.5865422857515697`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.586542289103711*^9, 3.586542291782723*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "0.`", "0.`", "0.`", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0.5094443366323823`", "0.4905556633676175`", "0.`", "0.`", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0.5168059063532154`", "0.48319409364678456`", 
      "0.`", "0.`", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0.5216340541529686`", 
      "0.47836594584703146`", "0.`", "0.`", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0.5240543497034948`", 
      "0.4759456502965052`", "0.`"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0.5247659672223585`"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.586542292471138*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"m", ".", "CV"}]], "Input",
 CellChangeTimes->{{3.586542316108842*^9, 3.5865423202224092`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - fit a quadratic  - 3 points\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
   3.586541747946124*^9, 3.5865417513765173`*^9}, 3.586546176914671*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Q", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"T", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.959722134072835", ",", "0.280950930538918"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.749678175815866", ",", "0.66180256323574"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.306994221445843", ",", "0.951711378517069"}], "}"}]}], 
   "}"}]}], "\n", 
 RowBox[{"CV", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.180343409312779", ",", "0.0527940816035624"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.359126393657023", ",", "0.125639285259194"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.727961869426204", ",", "0.451240684833979"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.906649307821086", ",", "0.710603947133938"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"U", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0.380018414821714", ",", 
    "0.380018414821714", ",", "1", ",", "1", ",", "1"}], 
   "}"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.586546160626336*^9, 3.586546160627181*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029275394*^9, 
   3.586546196655424*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.959722134072835`", ",", "0.280950930538918`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.749678175815866`", ",", "0.66180256323574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.306994221445843`", ",", "0.951711378517069`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029275394*^9, 
   3.5865461966565228`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.180343409312779`", ",", "0.0527940816035624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.359126393657023`", ",", "0.125639285259194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.727961869426204`", ",", "0.451240684833979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.906649307821086`", ",", "0.710603947133938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029275394*^9, 
   3.5865461966576357`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.380018414821714`", ",", 
   "0.380018414821714`", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.5865252003055468`*^9, 3.586525222990964*^9}, {
   3.586526129128079*^9, 3.5865261422124166`*^9}, 3.5865274954879923`*^9, 
   3.586532811509247*^9, 3.586541786150558*^9, 3.586543029275394*^9, 
   3.5865461966586*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.180343409312779`", ",", "0.0527940816035624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.359126393657023`", ",", "0.125639285259194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.727961869426204`", ",", "0.451240684833979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.906649307821086`", ",", "0.710603947133938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5865418137588053`*^9, 3.5865430316715193`*^9, 
  3.586546200804119*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9, 
  3.586546202594287*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586546203732106*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", "U", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.380018414821714`", ",", 
   "0.380018414821714`", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586541840318301*^9, 3.5865430352061996`*^9, 
  3.586546204777543*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9, 3.586546206066901*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.5865462074170094`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586546210977779*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14137005934761665`", ",", "0.04640478109589416`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586546212593562*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49929066648883985`", ",", "0.2493738129893353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49929066648883985`", ",", "0.2493738129893353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9, 3.5865462157956448`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}},
 CellID->106228517],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0, 0}, {0.180343409312779, 0.0527940816035624}, {
     0.359126393657023, 0.125639285259194}, {0.727961869426204, 
     0.451240684833979}, {0.906649307821086, 0.710603947133938}, {1, 1}},
    SplineKnots->{
     0, 0, 0, 0, 0.380018414821714, 0.380018414821714, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], PointBox[{{0, 0}, {0.5, 0.25}, {1, 1}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5865462312337637`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{{3.5865421722850103`*^9, 3.5865421740253563`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.0682515`", ",", "0.0682515`", ",", 
   "0.139131`", ",", "0.139131`", ",", "0.214941`", ",", "0.214941`", ",", 
   "0.297608`", ",", "0.297608`", ",", "0.388631`", ",", "0.388631`", ",", 
   "0.489141`", ",", "0.489141`", ",", "0.599978`", ",", "0.599978`", ",", 
   "0.721769`", ",", "0.721769`", ",", "0.854987`", ",", "0.854987`", ",", 
   "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.586542175094131*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pU", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"U", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3", ",", 
      RowBox[{
       RowBox[{"Length", "[", "U", "]"}], "-", "1"}], ",", "2"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.58654217736132*^9, 3.586542230129209*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.0682515`", ",", "0.139131`", ",", "0.214941`", ",", 
   "0.297608`", ",", "0.388631`", ",", "0.489141`", ",", "0.599978`", ",", 
   "0.721769`", ",", "0.854987`", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.586542210077826*^9, 3.586542231715576*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.586542221077653*^9, 3.586542253287551*^9}}],

Cell[BoxData["11"], "Output",
 CellChangeTimes->{{3.5865422477462597`*^9, 3.586542253767851*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586542348043715*^9, 3.586542351061006*^9}}],

Cell[BoxData["22"], "Output",
 CellChangeTimes->{3.586542352255085*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.586542367044938*^9, 3.586542368572855*^9}}],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{3.586542369818921*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"BSplineBasis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "k"}], "}"}], ",", 
       RowBox[{"j", "-", "1"}], ",", 
       RowBox[{"pU", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "pU", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "Q", "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.586542162387398*^9, {3.586542259682562*^9, 3.5865422857515697`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.586542289103711*^9, 3.586542291782723*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "0.`", "0.`", "0.`", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0.5094443366323823`", "0.4905556633676175`", "0.`", "0.`", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0.5168059063532154`", "0.48319409364678456`", 
      "0.`", "0.`", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0.5216340541529686`", 
      "0.47836594584703146`", "0.`", "0.`", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0.5240543497034948`", 
      "0.4759456502965052`", "0.`"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0.5247659672223585`"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.586542292471138*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"m", ".", "CV"}]], "Input",
 CellChangeTimes->{{3.586542316108842*^9, 3.5865423202224092`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["example -3d", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.5865286374211197`*^9, 3.586528637674397*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", 
      RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", 
      RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"-", "5"}], ",", "4"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "1.5", ",", "1.5", ",", "4", ",", 
    "4", ",", "4", ",", "4"}], "}"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.5865286534631042`*^9, 3.586528675826291*^9}, {
  3.586528910225329*^9, 3.586528911837532*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"-", "5"}], ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.586528668238558*^9, 3.586528677356876*^9}, 
   3.586528913396109*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1.5`", ",", "1.5`", ",", "4", ",", 
   "4", ",", "4", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{{3.586528668238558*^9, 3.586528677356876*^9}, 
   3.586528913397531*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "pts", "]"}]], "Input",
 CellChangeTimes->{{3.58628165797115*^9, 3.586281659956924*^9}}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{3.586281660583235*^9, 3.586281795628015*^9, 
  3.586283247660452*^9, 3.586285538707103*^9, 3.586525203556143*^9, 
  3.586528681897573*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.5865286833216867`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.586528689938919*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "BSplineCurve"}]], "Input",
 CellChangeTimes->{{3.586528768670864*^9, 3.58652877143542*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{\\\"BSplineCurve\\\", \\\"[\\\", \
RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\
\"}], \\\"]\\\"}]\\) is a graphics primitive which represents a non-uniform \
rational B-spline curve with control points \\!\\(\\*SubscriptBox[StyleBox[\\\
\"pt\\\", \\\"TI\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\\).\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BSplineCurve"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.5865287725070066`*^9},
 CellTags->"Info3586507172-3732742"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "pts", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
  3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
  3.5862812859544287`*^9}, {3.5865287481308537`*^9, 3.586528754841563*^9}, {
  3.586528833989675*^9, 3.5865288456370363`*^9}},
 CellID->1120323371],

Cell[BoxData[
 Graphics3DBox[{
   BSplineCurve3DBox[{{0, 0, 9}, {2, -1, 4}, {4, -2, 1}, {6, -3, 0}, {8, -4, 
    1}, {10, -5, 4}},
    SplineKnots->{0, 0, 0, 0, 1.5, 1.5, 4, 4, 4, 4}], 
   {RGBColor[1, 0, 0], 
    Point3DBox[{{0, 0, 9}, {2, -1, 4}, {4, -2, 1}, {6, -3, 0}, {8, -4, 1}, {
     10, -5, 4}}]}}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586528692039703*^9, 3.58652875610666*^9, {
   3.586528835467517*^9, 3.58652884663033*^9}, 3.586528916721367*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - blunt wedge ", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.035204", ",", "0.011263"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.034115499625", ",", "0.011162991225"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.033027103307", ",", "0.01106299201"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.031938915064", ",", "0.010963011912"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030851038834", ",", "0.010863060482"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.029763578436", ",", "0.010763147257"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.028676637531", ",", "0.010663281762"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.027590319579", ",", "0.010563473502"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.026504727805", ",", "0.010463731962"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.025419965157", ",", "0.010364066599"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.024336134266", ",", "0.010264486845"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02325333741", ",", "0.010165002095"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.022171676475", ",", "0.010065621711"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.021091252914", ",", "0.0099663550134"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.020012167713", ",", "0.0098672112814"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.018934521355", ",", "0.0097681997466"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.017858413776", ",", "0.0096693295912"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.016783944335", ",", "0.0095706099441"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.015711211778", ",", "0.0094720498775"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.014640314197", ",", "0.0093736584041"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.013571349", ",", "0.0092754444735"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.012504412877", ",", "0.0091774169692"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.01143960176", ",", "0.0090795847054"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.010377010797", ",", "0.0089819564239"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0093167343158", ",", "0.0088845407913"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0082587871663", ",", "0.0087873391722"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0072087316496", ",", "0.0086549329009"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0061861684931", ",", "0.0084028501359"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0052105866663", ",", "0.008034680023"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0042993195894", ",", "0.0075620020044"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0034664339596", ",", "0.0069995043816"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0027222192314", ",", "0.0063640061243"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0020729813082", ",", "0.0056733776927"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0015211387662", ",", "0.0049455210466"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0010655845148", ",", "0.0041974771846"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00070223197875", ",", "0.0034447281182"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00042467141078", ",", "0.0027007167537"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00022485516088", ",", "0.0019765856542"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.3751631949*^-05", ",", "0.0012811086291"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.1923024222*^-05", ",", "0.00062077742052"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.035204", ",", "0.011263"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.034841166541659", ",", "0.0112296637417501"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0344783330833257", ",", "0.0111963274834168"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0337527008523257", ",", "0.0111296581534168"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0333899020796602", ",", "0.0110963250817372"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0326643738926602", ",", "0.0110296653107372"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0323016444783485", ",", "0.0109963386111677"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0315762896540152", ",", "0.0109296947685011"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0312136642439903", ",", "0.0108963776254385"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030488552034657", ",", "0.0108297560737717"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030126065235337", ",", "0.0107964516652932"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0294012648010037", ",", "0.0107298587586266"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0290389511659938", ",", "0.0106965702604013"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0283145315469938", ",", "0.010630012342068"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.027952425563008", ",", "0.0105967429219131"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0272284556543413", ",", "0.0105302263219131"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0268665917296502", ",", "0.0104969791421797"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0261431402556502", ",", "0.0104305101745129"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.025781552706355", ",", "0.0103972883864309"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.025058688193355", ",", "0.0103308733474311"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0246974112296571", ",", "0.0102976800964373"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0239752019806571", ",", "0.0102313252617705"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0236142696953384", ",", "0.0101981636782783"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.022892783765005", ",", "0.0101318753002784"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0225322301199921", ",", "0.0100987485057532"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0218115352879921", ",", "0.0100325328118864"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.021451394101005", ",", "0.00999944391254578"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.020731557847005", ",", "0.00993330710267918"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0203718627799969", ",", "0.00990025919210081"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0196529522603302", ",", "0.00983420743650077"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0192937368076684", ",", "0.00980120359151414"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0185758188286684", ",", "0.00973524302811416"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0182171163023356", ",", "0.00970228630964149"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.017500257295669", ",", "0.00963642304214152"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0171421008153304", ",", "0.0096035164931649"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0164263668159971", ",", "0.00953775658859819"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0160687892970008", ",", "0.00950490323302442"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0153542459176675", ",", "0.0094392527196911"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.014997280057334", ",", "0.00940645556189287"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0142839924646673", ",", "0.00934092042722622"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0139276707323318", ",", "0.00930818245038317"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0132157036256652", ",", "0.0092427686387498"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0128600582513349", ",", "0.00921009280395001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0121494758380015", ",", "0.00914480621458338"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.011794538798999", ",", "0.00911219546001106"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0110854047723323", ",", "0.00904704194491104"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0107312077846655", ",", "0.00901449918441267"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0100235853032655", ",", "0.00894948454637931"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00967015980953563", ",", "0.0089170126688084"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00896407476679256", ",", "0.00885213928693625"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00861084856153853", ",", "0.00882569786057515"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00790795301820188", ",", "0.00874911419797601"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00755571275056279", ",", "0.00871935233663805"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00686337156006471", ",", "0.00859081441711926"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00652160838570346", ",", "0.00850708472639829"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00585405013829955", ",", "0.0082996476800415"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00552818935953399", ",", "0.00817639056509584"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00489791709189778", ",", "0.00789517057982041"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00459364167357192", ",", "0.00773692958444913"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00401117557905652", ",", "0.0073907463047917"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0037331998091674", ",", "0.00720246119190637"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00320668533297873", ",", "0.00680188631007398"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00295844687282388", ",", "0.00658921436716116"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00249342096490713", ",", "0.00614588069555697"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0022770168867802", ",", "0.00591482506188823"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00187637387642266", ",", "0.00544072048901121"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00169259284489244", ",", "0.00519728950284124"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00135674118233965", ",", "0.00470411456496969"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00120518867801033", ",", "0.00445402022692738"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.000932358691106949", ",", "0.00395265527284017"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.000811641889423999", ",", "0.00370108014183691"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.000598291779484351", ",", "0.00320119185850625"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.000506242626828893", ",", "0.0029526286659259"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0003475101909206", ",", "0.00246242399081151"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.000281416278225491", ",", "0.00222059002854573"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.000171568758961805", ",", "0.00174670838565589"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.000128393326586522", ",", "0.00151452446449967"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"6.12402063869982*^-05", ",", "0.00106204655269196"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"3.78159757063106*^-05", ",", "0.000841667891580644"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"7.06076474180386*^-06", ",", "0.000414212170456351"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"1.8804220541053*^-08", ",", "0.0002070992248588"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.0270843946815751", ",", 
     "0.0270843946815751", ",", "0.0541662001866317", ",", 
     "0.0541662001866317", ",", "0.0812428283077384", ",", 
     "0.0812428283077384", ",", "0.108311692824987", ",", "0.108311692824987",
      ",", "0.135370210486416", ",", "0.135370210486416", ",", 
     "0.162415801965761", ",", "0.162415801965761", ",", "0.189445892941575", 
     ",", "0.189445892941575", ",", "0.216457914936145", ",", 
     "0.216457914936145", ",", "0.243449306369937", ",", "0.243449306369937", 
     ",", "0.270417513541753", ",", "0.270417513541753", ",", 
     "0.297359991544203", ",", "0.297359991544203", ",", "0.32427420521692", 
     ",", "0.32427420521692", ",", "0.351157630177696", ",", 
     "0.351157630177696", ",", "0.378007753660484", ",", "0.378007753660484", 
     ",", "0.404822075418179", ",", "0.404822075418179", ",", 
     "0.431598108812353", ",", "0.431598108812353", ",", "0.458333381562313", 
     ",", "0.458333381562313", ",", "0.485025436641077", ",", 
     "0.485025436641077", ",", "0.511671833293358", ",", "0.511671833293358", 
     ",", "0.538270147783939", ",", "0.538270147783939", ",", 
     "0.564817974243397", ",", "0.564817974243397", ",", "0.591312925662316", 
     ",", "0.591312925662316", ",", "0.617752634539837", ",", 
     "0.617752634539837", ",", "0.644134753783209", ",", "0.644134753783209", 
     ",", "0.670464869609752", ",", "0.670464869609752", ",", 
     "0.69674153068215", ",", "0.69674153068215", ",", "0.722897396469965", 
     ",", "0.722897396469965", ",", "0.748794766418892", ",", 
     "0.748794766418892", ",", "0.77428852978878", ",", "0.77428852978878", 
     ",", "0.799245418049113", ",", "0.799245418049113", ",", 
     "0.823543788422371", ",", "0.823543788422371", ",", "0.847075747567084", 
     ",", "0.847075747567084", ",", "0.8697486731613", ",", "0.8697486731613",
      ",", "0.891486116611331", ",", "0.891486116611331", ",", 
     "0.91222812873196", ",", "0.91222812873196", ",", "0.931931037609897", 
     ",", "0.931931037609897", ",", "0.95056676067153", ",", 
     "0.95056676067153", ",", "0.968121741857199", ",", "0.968121741857199", 
     ",", "0.98459560720103", ",", "0.98459560720103", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5866274029292593`*^9, 3.5866274029300137`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586627192931541*^9, 3.586627194565254*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.035204`", ",", "0.011263`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.034841166541659`", ",", "0.0112296637417501`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0344783330833257`", ",", "0.0111963274834168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0337527008523257`", ",", "0.0111296581534168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0333899020796602`", ",", "0.0110963250817372`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0326643738926602`", ",", "0.0110296653107372`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0323016444783485`", ",", "0.0109963386111677`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0315762896540152`", ",", "0.0109296947685011`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0312136642439903`", ",", "0.0108963776254385`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.030488552034657`", ",", "0.0108297560737717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.030126065235337`", ",", "0.0107964516652932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0294012648010037`", ",", "0.0107298587586266`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0290389511659938`", ",", "0.0106965702604013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0283145315469938`", ",", "0.010630012342068`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.027952425563008`", ",", "0.0105967429219131`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0272284556543413`", ",", "0.0105302263219131`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0268665917296502`", ",", "0.0104969791421797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0261431402556502`", ",", "0.0104305101745129`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.025781552706355`", ",", "0.0103972883864309`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.025058688193355`", ",", "0.0103308733474311`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0246974112296571`", ",", "0.0102976800964373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0239752019806571`", ",", "0.0102313252617705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0236142696953384`", ",", "0.0101981636782783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.022892783765005`", ",", "0.0101318753002784`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0225322301199921`", ",", "0.0100987485057532`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0218115352879921`", ",", "0.0100325328118864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.021451394101005`", ",", "0.00999944391254578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.020731557847005`", ",", "0.00993330710267918`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0203718627799969`", ",", "0.00990025919210081`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0196529522603302`", ",", "0.00983420743650077`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0192937368076684`", ",", "0.00980120359151414`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0185758188286684`", ",", "0.00973524302811416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0182171163023356`", ",", "0.00970228630964149`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.017500257295669`", ",", "0.00963642304214152`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0171421008153304`", ",", "0.0096035164931649`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0164263668159971`", ",", "0.00953775658859819`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0160687892970008`", ",", "0.00950490323302442`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0153542459176675`", ",", "0.0094392527196911`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014997280057334`", ",", "0.00940645556189287`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0142839924646673`", ",", "0.00934092042722622`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0139276707323318`", ",", "0.00930818245038317`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0132157036256652`", ",", "0.0092427686387498`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0128600582513349`", ",", "0.00921009280395001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0121494758380015`", ",", "0.00914480621458338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011794538798999`", ",", "0.00911219546001106`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0110854047723323`", ",", "0.00904704194491104`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0107312077846655`", ",", "0.00901449918441267`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0100235853032655`", ",", "0.00894948454637931`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00967015980953563`", ",", "0.0089170126688084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00896407476679256`", ",", "0.00885213928693625`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00861084856153853`", ",", "0.00882569786057515`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00790795301820188`", ",", "0.00874911419797601`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00755571275056279`", ",", "0.00871935233663805`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00686337156006471`", ",", "0.00859081441711926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00652160838570346`", ",", "0.00850708472639829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00585405013829955`", ",", "0.0082996476800415`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00552818935953399`", ",", "0.00817639056509584`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00489791709189778`", ",", "0.00789517057982041`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00459364167357192`", ",", "0.00773692958444913`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00401117557905652`", ",", "0.0073907463047917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0037331998091674`", ",", "0.00720246119190637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00320668533297873`", ",", "0.00680188631007398`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00295844687282388`", ",", "0.00658921436716116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00249342096490713`", ",", "0.00614588069555697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0022770168867802`", ",", "0.00591482506188823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00187637387642266`", ",", "0.00544072048901121`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00169259284489244`", ",", "0.00519728950284124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00135674118233965`", ",", "0.00470411456496969`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00120518867801033`", ",", "0.00445402022692738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000932358691106949`", ",", "0.00395265527284017`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.000811641889423999`", ",", "0.00370108014183691`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.000598291779484351`", ",", "0.00320119185850625`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.000506242626828893`", ",", "0.0029526286659259`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0003475101909206`", ",", "0.00246242399081151`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000281416278225491`", ",", "0.00222059002854573`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.000171568758961805`", ",", "0.00174670838565589`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.000128393326586522`", ",", "0.00151452446449967`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0000612402063869982`", ",", "0.00106204655269196`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0000378159757063106`", ",", "0.000841667891580644`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"7.06076474180386`*^-6", ",", "0.000414212170456351`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.8804220541053`*^-8", ",", "0.0002070992248588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5866271951287746`*^9, 3.5866274123954563`*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", "CV"}], ";"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["41"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9, 
  3.586626300781831*^9, 3.586627094779155*^9, 3.586627423049467*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586626302592072*^9, 3.5866271052208967`*^9, 
  3.586627424120181*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", "U", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.0270843946815751`", ",", 
   "0.0270843946815751`", ",", "0.0541662001866317`", ",", 
   "0.0541662001866317`", ",", "0.0812428283077384`", ",", 
   "0.0812428283077384`", ",", "0.108311692824987`", ",", 
   "0.108311692824987`", ",", "0.135370210486416`", ",", "0.135370210486416`",
    ",", "0.162415801965761`", ",", "0.162415801965761`", ",", 
   "0.189445892941575`", ",", "0.189445892941575`", ",", "0.216457914936145`",
    ",", "0.216457914936145`", ",", "0.243449306369937`", ",", 
   "0.243449306369937`", ",", "0.270417513541753`", ",", "0.270417513541753`",
    ",", "0.297359991544203`", ",", "0.297359991544203`", ",", 
   "0.32427420521692`", ",", "0.32427420521692`", ",", "0.351157630177696`", 
   ",", "0.351157630177696`", ",", "0.378007753660484`", ",", 
   "0.378007753660484`", ",", "0.404822075418179`", ",", "0.404822075418179`",
    ",", "0.431598108812353`", ",", "0.431598108812353`", ",", 
   "0.458333381562313`", ",", "0.458333381562313`", ",", "0.485025436641077`",
    ",", "0.485025436641077`", ",", "0.511671833293358`", ",", 
   "0.511671833293358`", ",", "0.538270147783939`", ",", "0.538270147783939`",
    ",", "0.564817974243397`", ",", "0.564817974243397`", ",", 
   "0.591312925662316`", ",", "0.591312925662316`", ",", "0.617752634539837`",
    ",", "0.617752634539837`", ",", "0.644134753783209`", ",", 
   "0.644134753783209`", ",", "0.670464869609752`", ",", "0.670464869609752`",
    ",", "0.69674153068215`", ",", "0.69674153068215`", ",", 
   "0.722897396469965`", ",", "0.722897396469965`", ",", "0.748794766418892`",
    ",", "0.748794766418892`", ",", "0.77428852978878`", ",", 
   "0.77428852978878`", ",", "0.799245418049113`", ",", "0.799245418049113`", 
   ",", "0.823543788422371`", ",", "0.823543788422371`", ",", 
   "0.847075747567084`", ",", "0.847075747567084`", ",", "0.8697486731613`", 
   ",", "0.8697486731613`", ",", "0.891486116611331`", ",", 
   "0.891486116611331`", ",", "0.91222812873196`", ",", "0.91222812873196`", 
   ",", "0.931931037609897`", ",", "0.931931037609897`", ",", 
   "0.95056676067153`", ",", "0.95056676067153`", ",", "0.968121741857199`", 
   ",", "0.968121741857199`", ",", "0.98459560720103`", ",", 
   "0.98459560720103`", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586541840318301*^9, 3.5865430352061996`*^9, 
  3.586626304270815*^9, 3.586627106394911*^9, 3.586627425861223*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.5866263208142443`*^9, 3.586626324327716*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"82", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.58662632507953*^9, 3.5866271105956087`*^9, 
  3.586627428440529*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.586626333881082*^9, 3.586626335847445*^9}}],

Cell[BoxData[
 RowBox[{"{", "86", "}"}]], "Output",
 CellChangeTimes->{3.5866263370690928`*^9, 3.586627111775069*^9, 
  3.586627429428741*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9, 3.586626306277677*^9, 
   3.586627112880786*^9, 3.586627430463785*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.58662630800243*^9, 3.58662711420161*^9, 3.586627431843741*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.03520399999999999`", ",", "0.011262999999999999`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586627433618116*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.03118507918687729`", ",", "0.010893751299615553`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586627436222684*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.03520399999999999`", ",", "0.011262999999999999`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03520399999999999`", ",", "0.011262999999999999`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03520399999999999`", ",", "0.011262999999999999`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03411549962500003`", ",", "0.011162991225000026`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03411549962500003`", ",", "0.011162991225000026`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03302710330700001`", ",", "0.011062992010000031`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03302710330700001`", ",", "0.011062992010000031`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03193891506399996`", ",", "0.010963011912000005`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03193891506399996`", ",", "0.010963011912000005`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.030851038833999977`", ",", "0.010863060482`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.030851038833999977`", ",", "0.010863060482`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.029763578436`", ",", "0.010763147257000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.029763578436`", ",", "0.010763147257000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02867663753100004`", ",", "0.010663281761999995`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.02867663753100004`", ",", "0.010663281761999995`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.027590319578999996`", ",", "0.01056347350200002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.027590319578999996`", ",", "0.01056347350200002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.026504727805000045`", ",", "0.010463731961999994`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.026504727805000045`", ",", "0.010463731961999994`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.025419965157000013`", ",", "0.010364066598999962`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.025419965157000013`", ",", "0.010364066598999962`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.02433613426599998`", ",", "0.01026448684500001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02433613426599998`", ",", "0.01026448684500001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.023253337409999977`", ",", "0.010165002094999986`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.023253337409999977`", ",", "0.010165002094999986`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.022171676475000048`", ",", "0.010065621711000004`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.022171676475000048`", ",", "0.010065621711000004`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.021091252914000012`", ",", "0.009966355013400001`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.021091252914000012`", ",", "0.009966355013400001`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.020012167713000018`", ",", "0.009867211281400001`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.020012167713000018`", ",", "0.009867211281400001`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.018934521354999977`", ",", "0.0097681997466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.018934521354999977`", ",", "0.0097681997466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.017858413775999987`", ",", "0.0096693295912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.017858413775999987`", ",", "0.0096693295912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.016783944334999974`", ",", "0.0095706099441`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.016783944334999974`", ",", "0.0095706099441`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015711211778000007`", ",", "0.0094720498775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015711211778000007`", ",", "0.0094720498775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014640314196999989`", ",", "0.0093736584041`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014640314196999989`", ",", "0.0093736584041`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.013571349000000012`", ",", "0.0092754444735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.013571349000000012`", ",", "0.0092754444735`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012504412877000007`", ",", "0.009177416969200002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.012504412877000007`", ",", "0.009177416969200002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.011439601759999994`", ",", "0.009079584705400002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.011439601759999994`", ",", "0.009079584705400002`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.010377010797000001`", ",", "0.008981956423900005`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.010377010797000001`", ",", "0.008981956423900005`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.009316768992984184`", ",", "0.008884543977355611`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.009316768992984184`", ",", "0.008884543977355611`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.008259043677054389`", ",", "0.008787367120211984`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.008259043677054389`", ",", "0.008787367120211984`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.007208744639380962`", ",", "0.00865493531254247`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.007208744639380962`", ",", "0.00865493531254247`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.006186171718270295`", ",", "0.008402851138089404`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.006186171718270295`", ",", "0.008402851138089404`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.005210578265373742`", ",", "0.008034676274606682`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.005210578265373742`", ",", "0.008034676274606682`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.004299309443863643`", ",", "0.007561995974495286`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.004299309443863643`", ",", "0.007561995974495286`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0034664229549955885`", ",", "0.006999496009241201`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0034664229549955885`", ",", "0.006999496009241201`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0027222082380999376`", ",", "0.006363995643808491`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0027222082380999376`", ",", "0.006363995643808491`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.002072971037415594`", ",", "0.005673365538673276`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.002072971037415594`", ",", "0.005673365538673276`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.001521129740225005`", ",", "0.00494550779257999`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.001521129740225005`", ",", "0.00494550779257999`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0010655770391106742`", ",", "0.0041974634469288735`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0010655770391106742`", ",", "0.0041974634469288735`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0007022261591654924`", ",", "0.0034447144826686648`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0007022261591654924`", ",", "0.0034447144826686648`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.00042466718810161446`", ",", "0.0027007037130339613`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.00042466718810161446`", ",", "0.0027007037130339613`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.00022485236241945756`", ",", "0.001976573581655364`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.00022485236241945756`", ",", "0.001976573581655364`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.00009375002004248056`", ",", "0.0012810977680693617`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.00009375002004248056`", ",", "0.0012810977680693617`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.000021922472310334863`", ",", "0.0006207697496963759`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000021922472310334863`", ",", "0.0006207697496963759`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9, 3.586627437685069*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}},
 CellID->143768448],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{0.035204, 0.011263}, {0.034841166541659, 
     0.0112296637417501}, {0.0344783330833257, 0.0111963274834168}, {
     0.0337527008523257, 0.0111296581534168}, {0.0333899020796602, 
     0.0110963250817372}, {0.0326643738926602, 0.0110296653107372}, {
     0.0323016444783485, 0.0109963386111677}, {0.0315762896540152, 
     0.0109296947685011}, {0.0312136642439903, 0.0108963776254385}, {
     0.030488552034657, 0.0108297560737717}, {0.030126065235337, 
     0.0107964516652932}, {0.0294012648010037, 0.0107298587586266}, {
     0.0290389511659938, 0.0106965702604013}, {0.0283145315469938, 
     0.010630012342068}, {0.027952425563008, 0.0105967429219131}, {
     0.0272284556543413, 0.0105302263219131}, {0.0268665917296502, 
     0.0104969791421797}, {0.0261431402556502, 0.0104305101745129}, {
     0.025781552706355, 0.0103972883864309}, {0.025058688193355, 
     0.0103308733474311}, {0.0246974112296571, 0.0102976800964373}, {
     0.0239752019806571, 0.0102313252617705}, {0.0236142696953384, 
     0.0101981636782783}, {0.022892783765005, 0.0101318753002784}, {
     0.0225322301199921, 0.0100987485057532}, {0.0218115352879921, 
     0.0100325328118864}, {0.021451394101005, 0.00999944391254578}, {
     0.020731557847005, 0.00993330710267918}, {0.0203718627799969, 
     0.00990025919210081}, {0.0196529522603302, 0.00983420743650077}, {
     0.0192937368076684, 0.00980120359151414}, {0.0185758188286684, 
     0.00973524302811416}, {0.0182171163023356, 0.00970228630964149}, {
     0.017500257295669, 0.00963642304214152}, {0.0171421008153304, 
     0.0096035164931649}, {0.0164263668159971, 0.00953775658859819}, {
     0.0160687892970008, 0.00950490323302442}, {0.0153542459176675, 
     0.0094392527196911}, {0.014997280057334, 0.00940645556189287}, {
     0.0142839924646673, 0.00934092042722622}, {0.0139276707323318, 
     0.00930818245038317}, {0.0132157036256652, 0.0092427686387498}, {
     0.0128600582513349, 0.00921009280395001}, {0.0121494758380015, 
     0.00914480621458338}, {0.011794538798999, 0.00911219546001106}, {
     0.0110854047723323, 0.00904704194491104}, {0.0107312077846655, 
     0.00901449918441267}, {0.0100235853032655, 0.00894948454637931}, {
     0.00967015980953563, 0.0089170126688084}, {0.00896407476679256, 
     0.00885213928693625}, {0.00861084856153853, 0.00882569786057515}, {
     0.00790795301820188, 0.00874911419797601}, {0.00755571275056279, 
     0.00871935233663805}, {0.00686337156006471, 0.00859081441711926}, {
     0.00652160838570346, 0.00850708472639829}, {0.00585405013829955, 
     0.0082996476800415}, {0.00552818935953399, 0.00817639056509584}, {
     0.00489791709189778, 0.00789517057982041}, {0.00459364167357192, 
     0.00773692958444913}, {0.00401117557905652, 0.0073907463047917}, {
     0.0037331998091674, 0.00720246119190637}, {0.00320668533297873, 
     0.00680188631007398}, {0.00295844687282388, 0.00658921436716116}, {
     0.00249342096490713, 0.00614588069555697}, {0.0022770168867802, 
     0.00591482506188823}, {0.00187637387642266, 0.00544072048901121}, {
     0.00169259284489244, 0.00519728950284124}, {0.00135674118233965, 
     0.00470411456496969}, {0.00120518867801033, 0.00445402022692738}, {
     0.000932358691106949, 0.00395265527284017}, {0.000811641889423999, 
     0.00370108014183691}, {0.000598291779484351, 0.00320119185850625}, {
     0.000506242626828893, 0.0029526286659259}, {0.0003475101909206, 
     0.00246242399081151}, {0.000281416278225491, 0.00222059002854573}, {
     0.000171568758961805, 0.00174670838565589}, {0.000128393326586522, 
     0.00151452446449967}, {0.0000612402063869982, 0.00106204655269196}, {
     0.0000378159757063106, 0.000841667891580644}, {7.06076474180386*^-6, 
     0.000414212170456351}, {1.8804220541053*^-8, 0.0002070992248588}, {0, 0}},
    SplineKnots->{
     0, 0, 0, 0, 0.0270843946815751, 0.0270843946815751, 0.0541662001866317, 
      0.0541662001866317, 0.0812428283077384, 0.0812428283077384, 
      0.108311692824987, 0.108311692824987, 0.135370210486416, 
      0.135370210486416, 0.162415801965761, 0.162415801965761, 
      0.189445892941575, 0.189445892941575, 0.216457914936145, 
      0.216457914936145, 0.243449306369937, 0.243449306369937, 
      0.270417513541753, 0.270417513541753, 0.297359991544203, 
      0.297359991544203, 0.32427420521692, 0.32427420521692, 
      0.351157630177696, 0.351157630177696, 0.378007753660484, 
      0.378007753660484, 0.404822075418179, 0.404822075418179, 
      0.431598108812353, 0.431598108812353, 0.458333381562313, 
      0.458333381562313, 0.485025436641077, 0.485025436641077, 
      0.511671833293358, 0.511671833293358, 0.538270147783939, 
      0.538270147783939, 0.564817974243397, 0.564817974243397, 
      0.591312925662316, 0.591312925662316, 0.617752634539837, 
      0.617752634539837, 0.644134753783209, 0.644134753783209, 
      0.670464869609752, 0.670464869609752, 0.69674153068215, 
      0.69674153068215, 0.722897396469965, 0.722897396469965, 
      0.748794766418892, 0.748794766418892, 0.77428852978878, 
      0.77428852978878, 0.799245418049113, 0.799245418049113, 
      0.823543788422371, 0.823543788422371, 0.847075747567084, 
      0.847075747567084, 0.8697486731613, 0.8697486731613, 0.891486116611331, 
      0.891486116611331, 0.91222812873196, 0.91222812873196, 
      0.931931037609897, 0.931931037609897, 0.95056676067153, 
      0.95056676067153, 0.968121741857199, 0.968121741857199, 
      0.98459560720103, 0.98459560720103, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], 
    PointBox[{{0.035204, 0.011263}, {0.034115499625, 0.011162991225}, {
      0.033027103307, 0.01106299201}, {0.031938915064, 0.010963011912}, {
      0.030851038834, 0.010863060482}, {0.029763578436, 0.010763147257}, {
      0.028676637531, 0.010663281762}, {0.027590319579, 0.010563473502}, {
      0.026504727805, 0.010463731962}, {0.025419965157, 0.010364066599}, {
      0.024336134266, 0.010264486845}, {0.02325333741, 0.010165002095}, {
      0.022171676475, 0.010065621711}, {0.021091252914, 0.0099663550134}, {
      0.020012167713, 0.0098672112814}, {0.018934521355, 0.0097681997466}, {
      0.017858413776, 0.0096693295912}, {0.016783944335, 0.0095706099441}, {
      0.015711211778, 0.0094720498775}, {0.014640314197, 0.0093736584041}, {
      0.013571349, 0.0092754444735}, {0.012504412877, 0.0091774169692}, {
      0.01143960176, 0.0090795847054}, {0.010377010797, 0.0089819564239}, {
      0.0093167343158, 0.0088845407913}, {0.0082587871663, 0.0087873391722}, {
      0.0072087316496, 0.0086549329009}, {0.0061861684931, 0.0084028501359}, {
      0.0052105866663, 0.008034680023}, {0.0042993195894, 0.0075620020044}, {
      0.0034664339596, 0.0069995043816}, {0.0027222192314, 0.0063640061243}, {
      0.0020729813082, 0.0056733776927}, {0.0015211387662, 0.0049455210466}, {
      0.0010655845148, 0.0041974771846}, {0.00070223197875, 
      0.0034447281182}, {0.00042467141078, 0.0027007167537}, {
      0.00022485516088, 0.0019765856542}, {0.000093751631949, 
      0.0012811086291}, {0.000021923024222, 0.00062077742052}, {0, 0}}]}},
  ImageSize->{1026., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - circle", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.809016994374947", ",", "0.587785252292473"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.309016994374947", ",", "0.951056516295154"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.309016994374947"}], ",", "0.951056516295154"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.809016994374947"}], ",", "0.587785252292473"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1.22460635382238*^-16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.809016994374948"}], ",", 
       RowBox[{"-", "0.587785252292473"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.309016994374948"}], ",", 
       RowBox[{"-", "0.951056516295154"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.309016994374947", ",", 
       RowBox[{"-", "0.951056516295154"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.809016994374947", ",", 
       RowBox[{"-", "0.587785252292473"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2.44921270764475*^-16"}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0.209428042240883"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.932115709020624", ",", "0.418354407020924"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.685918279729271", ",", "0.757216097564022"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.508194898643076", ",", "0.886339692144046"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.109839090106819", ",", "1.01577334044626"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.109839090106819"}], ",", "1.01577334044626"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.508194898643076"}], ",", "0.886339692144047"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.685918279729271"}], ",", "0.757216097564022"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.932115709020624"}], ",", "0.418354407020925"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.209428042240883"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "0.209428042240883"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.932115709020624"}], ",", 
       RowBox[{"-", "0.418354407020924"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.685918279729271"}], ",", 
       RowBox[{"-", "0.757216097564022"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.508194898643076"}], ",", 
       RowBox[{"-", "0.886339692144046"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.109839090106819"}], ",", 
       RowBox[{"-", "1.01577334044626"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.109839090106819", ",", 
       RowBox[{"-", "1.01577334044626"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.508194898643076", ",", 
       RowBox[{"-", "0.886339692144047"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.685918279729271", ",", 
       RowBox[{"-", "0.757216097564022"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.932115709020624", ",", 
       RowBox[{"-", "0.418354407020925"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "0.209428042240883"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2.44921270764475*^-16"}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.1", ",", "0.1", ",", "0.2", ",", "0.2", 
     ",", "0.3", ",", "0.3", ",", "0.4", ",", "0.4", ",", "0.5", ",", "0.5", 
     ",", "0.6", ",", "0.6", ",", "0.7", ",", "0.7", ",", "0.8", ",", "0.8", 
     ",", "0.9", ",", "0.9", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586701542188034*^9, 3.5867015421886168`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", "CV"}], ";"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["11"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9, 
  3.586626300781831*^9, 3.586627094779155*^9, 3.586627423049467*^9, 
  3.586700717684812*^9, 3.586701555028276*^9, 3.586808645840746*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586626302592072*^9, 3.5866271052208967`*^9, 
  3.586627424120181*^9, 3.586700718813528*^9, 3.5867015550680237`*^9, 
  3.586808646001081*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.5866263208142443`*^9, 3.586626324327716*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.58662632507953*^9, 3.5866271105956087`*^9, 
  3.586627428440529*^9, 3.586700721185813*^9, 3.5867015550764837`*^9, 
  3.586808646077585*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.586626333881082*^9, 3.586626335847445*^9}}],

Cell[BoxData[
 RowBox[{"{", "26", "}"}]], "Output",
 CellChangeTimes->{3.5866263370690928`*^9, 3.586627111775069*^9, 
  3.586627429428741*^9, 3.586700722256385*^9, 3.586701555081559*^9, 
  3.586808646084186*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9, 3.586626306277677*^9, 
   3.586627112880786*^9, 3.586627430463785*^9, 3.5867007234735107`*^9, 
   3.586701555086636*^9, 3.58680864609093*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.58662630800243*^9, 3.58662711420161*^9, 3.586627431843741*^9, 
  3.58670072467605*^9, 3.5867015551279297`*^9, 3.586808646097722*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586627433618116*^9, 3.586700725804323*^9, 3.586701555133086*^9, 
  3.586808646104519*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8090169943749475`", ",", "0.587785252292473`"}], "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586627436222684*^9, 3.586700726899719*^9, 3.5867015551388083`*^9, 
  3.586808646188651*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8090169943749475`", ",", "0.587785252292473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8090169943749475`", ",", "0.587785252292473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30901699437494745`", ",", "0.951056516295153`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30901699437494745`", ",", "0.951056516295153`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.30901699437494745`"}], ",", "0.9510565162951536`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.30901699437494745`"}], ",", "0.9510565162951536`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749477`"}], ",", "0.5877852522924735`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749477`"}], ",", "0.5877852522924735`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749475`"}], ",", 
     RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749475`"}], ",", 
     RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.30901699437494756`"}], ",", 
     RowBox[{"-", "0.951056516295153`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.30901699437494756`"}], ",", 
     RowBox[{"-", "0.951056516295153`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30901699437494756`", ",", 
     RowBox[{"-", "0.9510565162951534`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30901699437494756`", ",", 
     RowBox[{"-", "0.9510565162951534`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8090169943749475`", ",", 
     RowBox[{"-", "0.5877852522924735`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8090169943749475`", ",", 
     RowBox[{"-", "0.5877852522924735`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.44921270764475`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.44921270764475`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.44921270764475`*^-16"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9, 3.586627437685069*^9, 3.586700728201809*^9, 
  3.586701555145372*^9, 3.586808646195175*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"PointSize", "\[Rule]", ".01"}], ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586808651338429*^9, 3.5868086618161507`*^9}},
 CellID->131055604],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{1, 0}, {1, 0.209428042240883}, {0.932115709020624, 
     0.418354407020924}, {0.685918279729271, 0.757216097564022}, {
     0.508194898643076, 0.886339692144046}, {0.109839090106819, 
     1.01577334044626}, {-0.109839090106819, 
     1.01577334044626}, {-0.508194898643076, 
     0.886339692144047}, {-0.685918279729271, 
     0.757216097564022}, {-0.932115709020624, 
     0.418354407020925}, {-1, 
      0.209428042240883}, {-1, -0.209428042240883}, {-0.932115709020624, \
-0.418354407020924}, {-0.685918279729271, -0.757216097564022}, \
{-0.508194898643076, -0.886339692144046}, {-0.109839090106819, \
-1.01577334044626}, {0.109839090106819, -1.01577334044626}, {
     0.508194898643076, -0.886339692144047}, {
     0.685918279729271, -0.757216097564022}, {
     0.932115709020624, -0.418354407020925}, {1, -0.209428042240883}, {
     1, -2.44921270764475*^-16}},
    SplineKnots->{
     0, 0, 0, 0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, 0.5, 0.6, 0.6, 
      0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], PointSize[0.01], 
    PointBox[{{1, 0}, {0.809016994374947, 0.587785252292473}, {
      0.309016994374947, 0.951056516295154}, {-0.309016994374947, 
      0.951056516295154}, {-0.809016994374947, 
      0.587785252292473}, {-1, 
       1.22460635382238*^-16}, {-0.809016994374948, -0.587785252292473}, \
{-0.309016994374948, -0.951056516295154}, {
      0.309016994374947, -0.951056516295154}, {
      0.809016994374947, -0.587785252292473}, {1, -2.44921270764475*^-16}}]}},
  ImageSize->{630., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, {3.5868086462414207`*^9, 3.58680866372412*^9}},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - NACA 0012 airfoil", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.97552826", ",", "0.00341331"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9045085", ",", "0.01277464"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.79389263", ",", "0.02590486"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6545085", ",", "0.04009273"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.05231025"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3454915", ",", "0.0591394"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.20610737", ",", "0.05745444"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0954915", ",", "0.04592861"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02447174", ",", "0.02586248"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02447174", ",", 
       RowBox[{"-", "0.02586248"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0954915", ",", 
       RowBox[{"-", "0.04592861"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.20610737", ",", 
       RowBox[{"-", "0.05745443"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3454915", ",", 
       RowBox[{"-", "0.0591394"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", 
       RowBox[{"-", "0.05231025"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6545085", ",", 
       RowBox[{"-", "0.04009273"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.79389263", ",", 
       RowBox[{"-", "0.02590486"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9045085", ",", 
       RowBox[{"-", "0.01277464"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.97552826", ",", 
       RowBox[{"-", "0.00341331"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.988846105093265"}], ",", "0.148940862230212"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.990925335749869"}], ",", "0.134413462752096"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.992247102838709"}], ",", "0.124280677935825"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.993978661304534"}], ",", "0.109573814715226"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.995937007701885"}], ",", "0.0900526328866412"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998107021037489"}], ",", "0.0615010126393842"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.999871342552268"}], ",", "0.0160405218969016"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998321071437296"}], ",", 
       RowBox[{"-", "0.0579226926540018"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.982080884649169"}], ",", 
       RowBox[{"-", "0.188459905568015"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.855545263915708"}], ",", 
       RowBox[{"-", "0.517728018742855"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.47564798393231*^-15"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.855545263915708", ",", 
       RowBox[{"-", "0.517728018742855"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.982080893076339", ",", 
       RowBox[{"-", "0.188459861653296"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998321071949862", ",", 
       RowBox[{"-", "0.0579226838197172"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.999871343127591", ",", "0.0160404860346679"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998107021037489", ",", "0.0615010126393842"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.995937007701885", ",", "0.0900526328866412"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.993978661304534", ",", "0.109573814715226"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.992247102838709", ",", "0.124280677935825"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.990925335749869", ",", "0.134413462752096"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.988846105093265", ",", "0.148940862230212"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.991855554413954", ",", "0.00122672349289204"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.983689830779599", ",", "0.00230623870975794"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951866806155466", ",", "0.00662285347441931"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.92820151518406", ",", "0.00980704857948127"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.867665216530999", ",", "0.0173893254284678"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.830800208239141", ",", "0.0218362574263233"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.747471613225466", ",", "0.0310222011351402"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.701020975911939", ",", "0.0358870715240571"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.603052935038787", ",", "0.0447453426307116"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.551567679744873", ",", "0.0491327705745206"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.448539662267855", ",", "0.0554811152625266"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.39704280250757", ",", "0.0583123838015202"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.299021193003271", ",", "0.0598849038915647"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.252505626152211", ",", "0.0601464716596312"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.169067625351801", ",", "0.0553053901535898"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.131928700648196", ",", "0.0529208562606275"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0711552595845606", ",", "0.0412585205580162"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0456723921605205", ",", "0.0386919258540818"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0137233090031812", ",", "0.0193581322824892"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.85389379146326*^-17", ",", "0.0125632522908546"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.85389379146326*^-17"}], ",", 
       RowBox[{"-", "0.0125632522908546"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0137233090031812", ",", 
       RowBox[{"-", "0.0193581322824892"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0456723921670146", ",", 
       RowBox[{"-", "0.0386919258580116"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0711552593682783", ",", 
       RowBox[{"-", "0.0412585216448047"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.131928700629712", ",", 
       RowBox[{"-", "0.0529208545677548"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.169067625669409", ",", 
       RowBox[{"-", "0.0553053805008908"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.252505626191503", ",", 
       RowBox[{"-", "0.0601464612499441"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.299021192961037", ",", 
       RowBox[{"-", "0.0598849022250699"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.397042802546729", ",", 
       RowBox[{"-", "0.0583123856503506"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.448539662258375", ",", 
       RowBox[{"-", "0.0554811152631107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.551567679744873", ",", 
       RowBox[{"-", "0.0491327705745206"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.603052935038787", ",", 
       RowBox[{"-", "0.0447453426307116"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.701020975911939", ",", 
       RowBox[{"-", "0.0358870715240571"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.747471613225466", ",", 
       RowBox[{"-", "0.0310222011351402"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.830800208239141", ",", 
       RowBox[{"-", "0.0218362574263233"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.867665216530999", ",", 
       RowBox[{"-", "0.0173893254284678"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.92820151518406", ",", 
       RowBox[{"-", "0.00980704857948127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951866806155466", ",", 
       RowBox[{"-", "0.00662285347441931"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.983689830779599", ",", 
       RowBox[{"-", "0.00230623870975794"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.991855554413954", ",", 
       RowBox[{"-", "0.00122672349289205"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U0", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.0119770773543089", ",", 
     "0.0119770773543089", ",", "0.0466988425530307", ",", 
     "0.0466988425530307", ",", "0.100692797439183", ",", "0.100692797439183",
      ",", "0.168606032620562", ",", "0.168606032620562", ",", 
     "0.243742012402349", ",", "0.243742012402349", ",", "0.318736613926045", 
     ",", "0.318736613926045", ",", "0.386375905388986", ",", 
     "0.386375905388986", ",", "0.440490762368947", ",", "0.440490762368947", 
     ",", "0.477732835508022", ",", "0.477732835508022", ",", 
     "0.500000000265769", ",", "0.500000000265769", ",", "0.522267165023515", 
     ",", "0.522267165023515", ",", "0.559509237998074", ",", 
     "0.559509237998074", ",", "0.61362409472413", ",", "0.61362409472413", 
     ",", "0.681263385997038", ",", "0.681263385997038", ",", 
     "0.756257987597651", ",", "0.756257987597651", ",", "0.831393967379438", 
     ",", "0.831393967379438", ",", "0.899307202560817", ",", 
     "0.899307202560817", ",", "0.953301157446969", ",", "0.953301157446969", 
     ",", "0.988022922645691", ",", "0.988022922645691", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586704091554535*^9, 3.5867040915552*^9}, {
  3.586879963682547*^9, 3.5868799704342003`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.97552826", ",", "0.00341331"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9045085", ",", "0.01277464"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.79389263", ",", "0.02590486"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6545085", ",", "0.04009273"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.05231025"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3454915", ",", "0.0591394"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.20610737", ",", "0.05745444"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0954915", ",", "0.04592861"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02447174", ",", "0.02586248"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02447174", ",", 
       RowBox[{"-", "0.02586248"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0954915", ",", 
       RowBox[{"-", "0.04592861"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.20610737", ",", 
       RowBox[{"-", "0.05745443"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3454915", ",", 
       RowBox[{"-", "0.0591394"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", 
       RowBox[{"-", "0.05231025"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6545085", ",", 
       RowBox[{"-", "0.04009273"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.79389263", ",", 
       RowBox[{"-", "0.02590486"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9045085", ",", 
       RowBox[{"-", "0.01277464"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.97552826", ",", 
       RowBox[{"-", "0.00341331"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.990143827871967"}], ",", "0.14005427564715"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.990677243789219"}], ",", "0.136229947655413"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.992071868402114"}], ",", "0.125671826298255"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.993873703922845"}], ",", "0.110521765506554"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.995885667490147"}], ",", "0.0906186365363352"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998108164388063"}], ",", "0.0614824542604716"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.99989370537774"}], ",", "0.0145800530168536"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998008833469837"}], ",", 
       RowBox[{"-", "0.063074307892957"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.97865605275382"}], ",", 
       RowBox[{"-", "0.20550506175837"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.802049260447501"}], ",", 
       RowBox[{"-", "0.597257887194147"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.00433234872006*^-15"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.802049260447502", ",", 
       RowBox[{"-", "0.597257887194147"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.978656060150629", ",", 
       RowBox[{"-", "0.205505026533293"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998008834586144", ",", 
       RowBox[{"-", "0.0630742902299137"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.999893705927671", ",", "0.0145800153027768"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998108164388063", ",", "0.0614824542604716"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.995885667490147", ",", "0.0906186365363352"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.993873703922845", ",", "0.110521765506555"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.992071868402114", ",", "0.125671826298255"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.990677243789219", ",", "0.136229947655413"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.990143827871967", ",", "0.140054275647151"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.991844960117522", ",", "0.00115351747035464"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.983687693211969", ",", "0.00229129052662154"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951872731524514", ",", "0.00666622756339394"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.928197329515204", ",", "0.00977383072109296"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.867671710321543", ",", "0.0174409820073716"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.830796323940363", ",", "0.0218010574827347"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.747476504423784", ",", "0.0310664737205453"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.701018588776194", ",", "0.0358606369318223"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.603055535363074", ",", "0.0447745902309051"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.551567791125575", ",", "0.0491337261799233"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.448539208110584", ",", "0.0554801827752603"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.397044351404164", ",", "0.0583876767892226"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.299018257754993", ",", "0.0598170543668122"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.252493006824245", ",", "0.0603860192012494"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.169068686830247", ",", "0.055113589670974"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.131811951537572", ",", "0.0535554331472312"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0710972963388319", ",", "0.0408061440265579"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0444638025337074", ",", "0.0407498661224848"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0144130861763366", ",", "0.018372154122277"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.76779090228796*^-17", ",", "0.0125411920684912"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.76779090228796*^-17"}], ",", 
       RowBox[{"-", "0.0125411920684912"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0144130861763366", ",", 
       RowBox[{"-", "0.018372154122277"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0444638025332488", ",", 
       RowBox[{"-", "0.0407498661221433"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0710972961550169", ",", 
       RowBox[{"-", "0.0408061449047037"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.131811951501071", ",", 
       RowBox[{"-", "0.0535554317746282"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.169068687105984", ",", 
       RowBox[{"-", "0.0551135803465401"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.252493006882289", ",", 
       RowBox[{"-", "0.0603860083806925"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.299018257723262", ",", 
       RowBox[{"-", "0.0598170526140205"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.397044351443098", ",", 
       RowBox[{"-", "0.0583876787335432"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.448539208100023", ",", 
       RowBox[{"-", "0.0554801827759109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.551567791125575", ",", 
       RowBox[{"-", "0.0491337261799233"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.603055535363074", ",", 
       RowBox[{"-", "0.0447745902309051"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.701018588776194", ",", 
       RowBox[{"-", "0.0358606369318223"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.747476504423784", ",", 
       RowBox[{"-", "0.0310664737205453"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.830796323940363", ",", 
       RowBox[{"-", "0.0218010574827347"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.867671710321543", ",", 
       RowBox[{"-", "0.0174409820073716"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.928197329515204", ",", 
       RowBox[{"-", "0.00977383072109296"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951872731524514", ",", 
       RowBox[{"-", "0.00666622756339394"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.983687693211969", ",", 
       RowBox[{"-", "0.00229129052662154"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.991844960117522", ",", 
       RowBox[{"-", "0.00115351747035464"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.0119296571203517", ",", 
     "0.0119296571203517", ",", "0.0465161116524674", ",", 
     "0.0465161116524674", ",", "0.10029981147066", ",", "0.10029981147066", 
     ",", "0.167948476366586", ",", "0.167948476366586", ",", 
     "0.24279198767731", ",", "0.24279198767731", ",", "0.317497793091204", 
     ",", "0.317497793091204", ",", "0.384891686072548", ",", 
     "0.384891686072548", ",", "0.438902860675406", ",", "0.438902860675406", 
     ",", "0.477479861311162", ",", "0.477479861311162", ",", 
     "0.500000000247901", ",", "0.500000000247901", ",", "0.52252013918464", 
     ",", "0.52252013918464", ",", "0.561097139557505", ",", 
     "0.561097139557505", ",", "0.615108314130953", ",", "0.615108314130953", 
     ",", "0.682502206821669", ",", "0.682502206821669", ",", 
     "0.75720801232269", ",", "0.75720801232269", ",", "0.832051523633414", 
     ",", "0.832051523633414", ",", "0.89970018852934", ",", 
     "0.89970018852934", ",", "0.953483888347533", ",", "0.953483888347533", 
     ",", "0.988070342879648", ",", "0.988070342879648", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586879948794424*^9, 3.586879960639494*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "-", "T0"}]], "Input",
 CellChangeTimes->{{3.586879996494055*^9, 3.586879997485429*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.001297722778701993`"}], ",", 
     RowBox[{"-", "0.00888658658306199`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0002480919606500098`", ",", "0.0018164849033169839`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.00017523443659495097`", ",", "0.0013911483624299836`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.00010495738168903035`", ",", "0.0009479507913280061`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.00005134021173802683`", ",", "0.0005660036496940024`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1433505739955052`*^-6"}], ",", 
     RowBox[{"-", "0.000018558378912597595`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.000022362825472077574`"}], ",", 
     RowBox[{"-", "0.001460468880048001`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0003122379674589393`", ",", 
     RowBox[{"-", "0.005151615238955194`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.003424831895349034`", ",", 
     RowBox[{"-", "0.017045156190354988`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05349600346820693`", ",", 
     RowBox[{"-", "0.07952986845129195`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.52868436478775`*^-15"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.05349600346820593`"}], ",", 
     RowBox[{"-", "0.07952986845129195`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.003424832925709942`"}], ",", 
     RowBox[{"-", "0.017045164879996993`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.00031223736371799315`"}], ",", 
     RowBox[{"-", "0.005151606410196505`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000022362800080055756`", ",", 
     RowBox[{"-", "0.0014604707318911`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1433505739955052`*^-6", ",", 
     RowBox[{"-", "0.000018558378912597595`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.00005134021173802683`"}], ",", 
     "0.0005660036496940024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.00010495738168903035`"}], ",", 
     "0.0009479507913290053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.00017523443659495097`"}], ",", 
     "0.0013911483624299836`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0002480919606500098`"}], ",", "0.0018164849033169839`"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.001297722778701993`", ",", 
     RowBox[{"-", "0.00888658658306099`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586879998104865*^9, 3.586880028404221*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", "CV"}], ";"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["21"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9, 
  3.586626300781831*^9, 3.586627094779155*^9, 3.586627423049467*^9, 
  3.586700717684812*^9, 3.586701555028276*^9, 3.586704096441888*^9, 
  3.586808695264406*^9, 3.5868800285359087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586626302592072*^9, 3.5866271052208967`*^9, 
  3.586627424120181*^9, 3.586700718813528*^9, 3.5867015550680237`*^9, 
  3.586704097729162*^9, 3.586808695581856*^9, 3.586880028694538*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.5866263208142443`*^9, 3.586626324327716*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"42", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.58662632507953*^9, 3.5866271105956087`*^9, 
  3.586627428440529*^9, 3.586700721185813*^9, 3.5867015550764837`*^9, 
  3.5867041009849567`*^9, 3.5868086955958548`*^9, 3.58688002875112*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.586626333881082*^9, 3.586626335847445*^9}}],

Cell[BoxData[
 RowBox[{"{", "46", "}"}]], "Output",
 CellChangeTimes->{3.5866263370690928`*^9, 3.586627111775069*^9, 
  3.586627429428741*^9, 3.586700722256385*^9, 3.586701555081559*^9, 
  3.586704101934599*^9, 3.586808695602462*^9, 3.586880028865664*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9, 3.586626306277677*^9, 
   3.586627112880786*^9, 3.586627430463785*^9, 3.5867007234735107`*^9, 
   3.586701555086636*^9, 3.5867041028544893`*^9, 3.58680869565364*^9, 
   3.586880029106884*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.58662630800243*^9, 3.58662711420161*^9, 3.586627431843741*^9, 
  3.58670072467605*^9, 3.5867015551279297`*^9, 3.586704103930251*^9, 
  3.586808695659758*^9, 3.586880029156602*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586627433618116*^9, 3.586700725804323*^9, 3.586701555133086*^9, 
  3.586704104983008*^9, 3.5868086956661263`*^9, 3.586880029332592*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7945102170622111`", ",", "0.025836158256040232`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586627436222684*^9, 3.586700726899719*^9, 3.5867015551388083`*^9, 
  3.586704106024227*^9, 3.586808695672874*^9, 3.586880029510337*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", "U"}]], "Input",
 CellChangeTimes->{{3.5865426049041147`*^9, 3.586542609233118*^9}, {
  3.586543119880416*^9, 3.586543122313751*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9755283357174281`", ",", "0.0034132995879497304`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9755283357174281`", ",", "0.0034132995879497304`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9045087143751718`", ",", "0.012774612843782594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9045087143751718`", ",", "0.012774612843782594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7938930801277632`", ",", "0.025904809944429733`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7938930801277632`", ",", "0.025904809944429733`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6545102825031892`", ",", "0.04009256780466586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6545102825031892`", ",", "0.04009256780466586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.500006064953268`", ",", "0.05230987640500777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.500006064953268`", ",", "0.05230987640500777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3455092787731827`", ",", "0.05913914075698828`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3455092787731827`", ",", "0.05913914075698828`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2061828337351564`", ",", "0.057459209319375114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2061828337351564`", ",", "0.057459209319375114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09639414754218825`", ",", "0.046118154261624425`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09639414754218825`", ",", "0.046118154261624425`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.025489649044120804`", ",", "0.02662048107927062`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.025489649044120804`", ",", "0.02662048107927062`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.622231866529366`*^-32"}], ",", 
     RowBox[{"-", "1.6479873021779667`*^-17"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.622231866529366`*^-32"}], ",", 
     RowBox[{"-", "1.6479873021779667`*^-17"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.025489649091612387`", ",", 
     RowBox[{"-", "0.02662048111463593`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.025489649091612387`", ",", 
     RowBox[{"-", "0.02662048111463593`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09639414732722335`", ",", 
     RowBox[{"-", "0.04611815418256261`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09639414732722335`", ",", 
     RowBox[{"-", "0.04611815418256261`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.20618283399167325`", ",", 
     RowBox[{"-", "0.057459199334246105`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.20618283399167325`", ",", 
     RowBox[{"-", "0.057459199334246105`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.345509278641059`", ",", 
     RowBox[{"-", "0.059139140759585596`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.345509278641059`", ",", 
     RowBox[{"-", "0.059139140759585596`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5000060649780225`", ",", 
     RowBox[{"-", "0.05230987640348295`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5000060649780225`", ",", 
     RowBox[{"-", "0.05230987640348295`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6545102825031892`", ",", 
     RowBox[{"-", "0.04009256780466586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6545102825031892`", ",", 
     RowBox[{"-", "0.04009256780466586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7938930801277629`", ",", 
     RowBox[{"-", "0.025904809944429744`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7938930801277629`", ",", 
     RowBox[{"-", "0.025904809944429744`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9045087143751721`", ",", 
     RowBox[{"-", "0.012774612843782548`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9045087143751721`", ",", 
     RowBox[{"-", "0.012774612843782548`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9755283357174278`", ",", 
     RowBox[{"-", "0.003413299587949765`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9755283357174278`", ",", 
     RowBox[{"-", "0.003413299587949765`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542609919832*^9, 3.586543044024419*^9, 
  3.586543123144166*^9, 3.586627437685069*^9, 3.586700728201809*^9, 
  3.586701555145372*^9, 3.586704107184689*^9, 3.586808695723461*^9, 
  3.586880029606969*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{3.586880176931307*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.990143827871967`"}], ",", "0.14005427564715`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.990677243789219`"}], ",", "0.136229947655413`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.992071868402114`"}], ",", "0.125671826298255`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.993873703922845`"}], ",", "0.110521765506554`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.995885667490147`"}], ",", "0.0906186365363352`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.998108164388063`"}], ",", "0.0614824542604716`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.99989370537774`"}], ",", "0.0145800530168536`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.998008833469837`"}], ",", 
     RowBox[{"-", "0.063074307892957`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.97865605275382`"}], ",", 
     RowBox[{"-", "0.20550506175837`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.802049260447501`"}], ",", 
     RowBox[{"-", "0.597257887194147`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.00433234872006`*^-15"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.802049260447502`", ",", 
     RowBox[{"-", "0.597257887194147`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.978656060150629`", ",", 
     RowBox[{"-", "0.205505026533293`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.998008834586144`", ",", 
     RowBox[{"-", "0.0630742902299137`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999893705927671`", ",", "0.0145800153027768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.998108164388063`", ",", "0.0614824542604716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.995885667490147`", ",", "0.0906186365363352`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.993873703922845`", ",", "0.110521765506555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.992071868402114`", ",", "0.125671826298255`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.990677243789219`", ",", "0.136229947655413`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.990143827871967`", ",", "0.140054275647151`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5868801778762407`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Arrow"}]], "Input",
 CellChangeTimes->{{3.586880067202841*^9, 3.586880068644657*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Arrow\\\", \\\"[\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \\\
\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}], \\\"]\\\"}]\\) is a graphics \
primitive which represents an arrow from \
\\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]\\) to \\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]\\).\\n\\!\\(\\*RowBox[{\\\"Arrow\\\", \
\\\"[\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \\\
\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}], \\\",\\\", \
StyleBox[\\\"s\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) represents an arrow with \
its ends set back from \\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]]\\) and \
\\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]\\) by a distance \\!\\(\\*StyleBox[\\\"s\\\", \\\"TI\\\"]\\). \
\\n\\!\\(\\*RowBox[{\\\"Arrow\\\", \\\"[\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \\\
\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"s\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"s\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}]}], \
\\\"]\\\"}]\\) sets back by \\!\\(\\*SubscriptBox[StyleBox[\\\"s\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]]\\) from \
\\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]\\) and \\!\\(\\*SubscriptBox[StyleBox[\\\"s\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]\\) from \
\\!\\(\\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]\\). \\n\\!\\(\\*RowBox[{\\\"Arrow\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"curve\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\\) represents an arrow following \
the specified \\!\\(\\*StyleBox[\\\"curve\\\", \\\"TI\\\"]\\).\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrow"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.5868800694376183`*^9},
 CellTags->"Info3586858469-1059658"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"PointSize", "\[Rule]", ".0075"}], ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586808699552023*^9, 3.586808724409588*^9}, {
   3.586880046332456*^9, 3.58688005598775*^9}, {3.5868802033448763`*^9, 
   3.586880210553362*^9}},
 CellID->1043598254],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{1, 0}, {0.991844960117522, 0.00115351747035464}, {
     0.983687693211969, 0.00229129052662154}, {0.951872731524514, 
     0.00666622756339394}, {0.928197329515204, 0.00977383072109296}, {
     0.867671710321543, 0.0174409820073716}, {0.830796323940363, 
     0.0218010574827347}, {0.747476504423784, 0.0310664737205453}, {
     0.701018588776194, 0.0358606369318223}, {0.603055535363074, 
     0.0447745902309051}, {0.551567791125575, 0.0491337261799233}, {
     0.448539208110584, 0.0554801827752603}, {0.397044351404164, 
     0.0583876767892226}, {0.299018257754993, 0.0598170543668122}, {
     0.252493006824245, 0.0603860192012494}, {0.169068686830247, 
     0.055113589670974}, {0.131811951537572, 0.0535554331472312}, {
     0.0710972963388319, 0.0408061440265579}, {0.0444638025337074, 
     0.0407498661224848}, {0.0144130861763366, 0.018372154122277}, {
     3.76779090228796*^-17, 
     0.0125411920684912}, {-3.76779090228796*^-17, -0.0125411920684912}, {
     0.0144130861763366, -0.018372154122277}, {
     0.0444638025332488, -0.0407498661221433}, {
     0.0710972961550169, -0.0408061449047037}, {
     0.131811951501071, -0.0535554317746282}, {
     0.169068687105984, -0.0551135803465401}, {
     0.252493006882289, -0.0603860083806925}, {
     0.299018257723262, -0.0598170526140205}, {
     0.397044351443098, -0.0583876787335432}, {
     0.448539208100023, -0.0554801827759109}, {
     0.551567791125575, -0.0491337261799233}, {
     0.603055535363074, -0.0447745902309051}, {
     0.701018588776194, -0.0358606369318223}, {
     0.747476504423784, -0.0310664737205453}, {
     0.830796323940363, -0.0218010574827347}, {
     0.867671710321543, -0.0174409820073716}, {
     0.928197329515204, -0.00977383072109296}, {
     0.951872731524514, -0.00666622756339394}, {
     0.983687693211969, -0.00229129052662154}, {
     0.991844960117522, -0.00115351747035464}, {1, 0}},
    SplineKnots->{
     0, 0, 0, 0, 0.0119296571203517, 0.0119296571203517, 0.0465161116524674, 
      0.0465161116524674, 0.10029981147066, 0.10029981147066, 
      0.167948476366586, 0.167948476366586, 0.24279198767731, 
      0.24279198767731, 0.317497793091204, 0.317497793091204, 
      0.384891686072548, 0.384891686072548, 0.438902860675406, 
      0.438902860675406, 0.477479861311162, 0.477479861311162, 
      0.500000000247901, 0.500000000247901, 0.52252013918464, 
      0.52252013918464, 0.561097139557505, 0.561097139557505, 
      0.615108314130953, 0.615108314130953, 0.682502206821669, 
      0.682502206821669, 0.75720801232269, 0.75720801232269, 
      0.832051523633414, 0.832051523633414, 0.89970018852934, 
      0.89970018852934, 0.953483888347533, 0.953483888347533, 
      0.988070342879648, 0.988070342879648, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], 
    PointBox[{{1, 0}, {0.991844960117522, 0.00115351747035464}, {
      0.983687693211969, 0.00229129052662154}, {0.951872731524514, 
      0.00666622756339394}, {0.928197329515204, 0.00977383072109296}, {
      0.867671710321543, 0.0174409820073716}, {0.830796323940363, 
      0.0218010574827347}, {0.747476504423784, 0.0310664737205453}, {
      0.701018588776194, 0.0358606369318223}, {0.603055535363074, 
      0.0447745902309051}, {0.551567791125575, 0.0491337261799233}, {
      0.448539208110584, 0.0554801827752603}, {0.397044351404164, 
      0.0583876767892226}, {0.299018257754993, 0.0598170543668122}, {
      0.252493006824245, 0.0603860192012494}, {0.169068686830247, 
      0.055113589670974}, {0.131811951537572, 0.0535554331472312}, {
      0.0710972963388319, 0.0408061440265579}, {0.0444638025337074, 
      0.0407498661224848}, {0.0144130861763366, 0.018372154122277}, {
      3.76779090228796*^-17, 
      0.0125411920684912}, {-3.76779090228796*^-17, -0.0125411920684912}, {
      0.0144130861763366, -0.018372154122277}, {
      0.0444638025332488, -0.0407498661221433}, {
      0.0710972961550169, -0.0408061449047037}, {
      0.131811951501071, -0.0535554317746282}, {
      0.169068687105984, -0.0551135803465401}, {
      0.252493006882289, -0.0603860083806925}, {
      0.299018257723262, -0.0598170526140205}, {
      0.397044351443098, -0.0583876787335432}, {
      0.448539208100023, -0.0554801827759109}, {
      0.551567791125575, -0.0491337261799233}, {
      0.603055535363074, -0.0447745902309051}, {
      0.701018588776194, -0.0358606369318223}, {
      0.747476504423784, -0.0310664737205453}, {
      0.830796323940363, -0.0218010574827347}, {
      0.867671710321543, -0.0174409820073716}, {
      0.928197329515204, -0.00977383072109296}, {
      0.951872731524514, -0.00666622756339394}, {
      0.983687693211969, -0.00229129052662154}, {
      0.991844960117522, -0.00115351747035464}, {1, 0}}]}, 
   {RGBColor[1, 0, 0], PointSize[0.0075], 
    PointBox[{{1, 0}, {0.97552826, 0.00341331}, {0.9045085, 0.01277464}, {
      0.79389263, 0.02590486}, {0.6545085, 0.04009273}, {0.5, 0.05231025}, {
      0.3454915, 0.0591394}, {0.20610737, 0.05745444}, {0.0954915, 
      0.04592861}, {0.02447174, 0.02586248}, {0, 0}, {
      0.02447174, -0.02586248}, {0.0954915, -0.04592861}, {
      0.20610737, -0.05745443}, {0.3454915, -0.0591394}, {0.5, -0.05231025}, {
      0.6545085, -0.04009273}, {0.79389263, -0.02590486}, {
      0.9045085, -0.01277464}, {0.97552826, -0.00341331}, {1, 0}}]}},
  ImageSize->{984., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, {3.586808695770399*^9, 
   3.586808724767109*^9}, {3.586880029774439*^9, 3.586880056593481*^9}, 
   3.5868802140286617`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - annulus", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.0674074935959337", ",", "0.00353267704639871"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0675", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674074935959333", ",", 
       RowBox[{"-", "0.00353267704639865"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.067130227937358", ",", 
       RowBox[{"-", "0.00705567127056653"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0666689629901714", ",", 
       RowBox[{"-", "0.0105593263902155"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0660249630495315", ",", 
       RowBox[{"-", "0.0140340391301986"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0651999932745117", ",", 
       RowBox[{"-", "0.01747028554442"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0641963148499225", ",", 
       RowBox[{"-", "0.0208586471203088"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0630166787885607", ",", 
       RowBox[{"-", "0.0241898365943076"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0616643183908752", ",", 
       RowBox[{"-", "0.0274547234076163"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0601429403827145", ",", 
       RowBox[{"-", "0.0306443587324192"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0584567147554493", ",", 
       RowBox[{"-", "0.0337499999999998"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0566102633363158", ",", 
       RowBox[{"-", "0.0367631348635141"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0546086471203086", ",", 
       RowBox[{"-", "0.0396755045297417"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0524573523983452", ",", 
       RowBox[{"-", "0.0424791263958638"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0501622757197238", ",", 
       RowBox[{"-", "0.0451663159292226"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0477297077300917", ",", 
       RowBox[{"-", "0.0477297077300917"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0451663159292227", ",", 
       RowBox[{"-", "0.0501622757197238"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0424791263958638", ",", 
       RowBox[{"-", "0.0524573523983452"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0396755045297417", ",", 
       RowBox[{"-", "0.0546086471203086"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0367631348635141", ",", 
       RowBox[{"-", "0.0566102633363158"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0337499999999998", ",", 
       RowBox[{"-", "0.0584567147554493"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0306443587324193", ",", 
       RowBox[{"-", "0.0601429403827145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0274547234076164", ",", 
       RowBox[{"-", "0.0616643183908752"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0241898365943077", ",", 
       RowBox[{"-", "0.0630166787885608"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0208586471203089", ",", 
       RowBox[{"-", "0.0641963148499225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0174702855444201", ",", 
       RowBox[{"-", "0.0651999932745118"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0140340391301987", ",", 
       RowBox[{"-", "0.0660249630495315"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0105593263902155", ",", 
       RowBox[{"-", "0.0666689629901714"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00705567127056659", ",", 
       RowBox[{"-", "0.0671302279373581"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00353267704639871", ",", 
       RowBox[{"-", "0.0674074935959334"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.87350135405495*^-17", ",", 
       RowBox[{"-", "0.0674999999999997"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00353267704639867"}], ",", 
       RowBox[{"-", "0.0674074935959334"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00705567127056656"}], ",", 
       RowBox[{"-", "0.0671302279373581"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0105593263902155"}], ",", 
       RowBox[{"-", "0.0666689629901715"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0140340391301987"}], ",", 
       RowBox[{"-", "0.0660249630495316"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0174702855444201"}], ",", 
       RowBox[{"-", "0.0651999932745118"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0208586471203088"}], ",", 
       RowBox[{"-", "0.0641963148499226"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0241898365943076"}], ",", 
       RowBox[{"-", "0.0630166787885608"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0274547234076164"}], ",", 
       RowBox[{"-", "0.0616643183908753"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0306443587324193"}], ",", 
       RowBox[{"-", "0.0601429403827146"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0337499999999998"}], ",", 
       RowBox[{"-", "0.0584567147554494"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0367631348635142"}], ",", 
       RowBox[{"-", "0.0566102633363159"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0396755045297418"}], ",", 
       RowBox[{"-", "0.0546086471203087"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0424791263958638"}], ",", 
       RowBox[{"-", "0.0524573523983453"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0451663159292227"}], ",", 
       RowBox[{"-", "0.0501622757197239"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0477297077300917"}], ",", 
       RowBox[{"-", "0.0477297077300918"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0501622757197239"}], ",", 
       RowBox[{"-", "0.0451663159292227"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0524573523983453"}], ",", 
       RowBox[{"-", "0.0424791263958638"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0546086471203087"}], ",", 
       RowBox[{"-", "0.0396755045297418"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0566102633363159"}], ",", 
       RowBox[{"-", "0.0367631348635142"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0584567147554494"}], ",", 
       RowBox[{"-", "0.0337499999999999"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0601429403827146"}], ",", 
       RowBox[{"-", "0.0306443587324193"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0616643183908753"}], ",", 
       RowBox[{"-", "0.0274547234076164"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0630166787885609"}], ",", 
       RowBox[{"-", "0.0241898365943077"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0641963148499226"}], ",", 
       RowBox[{"-", "0.0208586471203089"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0651999932745119"}], ",", 
       RowBox[{"-", "0.0174702855444201"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0660249630495316"}], ",", 
       RowBox[{"-", "0.0140340391301987"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0666689629901716"}], ",", 
       RowBox[{"-", "0.0105593263902156"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0671302279373582"}], ",", 
       RowBox[{"-", "0.00705567127056659"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674074935959335"}], ",", 
       RowBox[{"-", "0.0035326770463987"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674999999999998"}], ",", 
       RowBox[{"-", "8.5868812060852*^-18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674074935959335"}], ",", "0.00353267704639869"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0671302279373582"}], ",", "0.00705567127056658"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0666689629901716"}], ",", "0.0105593263902155"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0660249630495317"}], ",", "0.0140340391301987"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0651999932745119"}], ",", "0.0174702855444201"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0641963148499227"}], ",", "0.0208586471203089"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0630166787885609"}], ",", "0.0241898365943077"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0616643183908754"}], ",", "0.0274547234076164"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0601429403827147"}], ",", "0.0306443587324193"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0584567147554494"}], ",", "0.0337499999999999"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.056610263336316"}], ",", "0.0367631348635142"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0546086471203088"}], ",", "0.0396755045297418"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0524573523983454"}], ",", "0.0424791263958639"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.050162275719724"}], ",", "0.0451663159292228"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0477297077300918"}], ",", "0.0477297077300918"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0451663159292228"}], ",", "0.050162275719724"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0424791263958639"}], ",", "0.0524573523983454"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0396755045297418"}], ",", "0.0546086471203088"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0367631348635142"}], ",", "0.056610263336316"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0337499999999999"}], ",", "0.0584567147554495"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0306443587324193"}], ",", "0.0601429403827147"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0274547234076165"}], ",", "0.0616643183908754"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0241898365943077"}], ",", "0.063016678788561"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0208586471203089"}], ",", "0.0641963148499227"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0174702855444201"}], ",", "0.065199993274512"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0140340391301987"}], ",", "0.0660249630495318"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0105593263902156"}], ",", "0.0666689629901717"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0070556712705666"}], ",", "0.0671302279373583"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00353267704639871"}], ",", "0.0674074935959336"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.90312782094782*^-18"}], ",", "0.0674999999999999"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0035326770463987", ",", "0.0674074935959336"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00705567127056659", ",", "0.0671302279373583"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0105593263902156", ",", "0.0666689629901717"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0140340391301987", ",", "0.0660249630495318"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0174702855444201", ",", "0.065199993274512"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0208586471203089", ",", "0.0641963148499228"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0241898365943077", ",", "0.063016678788561"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0274547234076165", ",", "0.0616643183908755"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0306443587324194", ",", "0.0601429403827148"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.03375", ",", "0.0584567147554495"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0367631348635143", ",", "0.0566102633363161"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0396755045297419", ",", "0.0546086471203089"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.042479126395864", ",", "0.0524573523983455"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0451663159292229", ",", "0.0501622757197241"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0477297077300919", ",", "0.0477297077300919"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0501622757197241", ",", "0.0451663159292229"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0524573523983455", ",", "0.042479126395864"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0546086471203089", ",", "0.0396755045297419"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0566102633363161", ",", "0.0367631348635143"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0584567147554496", ",", "0.03375"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0601429403827148", ",", "0.0306443587324194"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0616643183908755", ",", "0.0274547234076165"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0630166787885611", ",", "0.0241898365943078"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0641963148499228", ",", "0.0208586471203089"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0651999932745121", ",", "0.0174702855444201"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0660249630495319", ",", "0.0140340391301988"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0666689629901718", ",", "0.0105593263902156"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0671302279373585", ",", "0.00705567127056661"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674074935959337", ",", "0.00353267704639871"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.0523359562429476", ",", 
       RowBox[{"-", "0.998629534754574"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6.30271224124592*^-14"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.052335956243007"}], ",", 
       RowBox[{"-", "0.998629534754571"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.104528463267652"}], ",", 
       RowBox[{"-", "0.994521895368273"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.15643446504023"}], ",", 
       RowBox[{"-", "0.987688340595138"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.207911690817758"}], ",", 
       RowBox[{"-", "0.978147600733806"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25881904510252"}], ",", 
       RowBox[{"-", "0.965925826289069"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.309016994374946"}], ",", 
       RowBox[{"-", "0.951056516295154"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.358367949545297"}], ",", 
       RowBox[{"-", "0.933580426497203"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.406736643075797"}], ",", 
       RowBox[{"-", "0.913545457642602"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.453990499739544"}], ",", 
       RowBox[{"-", "0.891006524188369"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.499999999999998"}], ",", 
       RowBox[{"-", "0.86602540378444"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.544639035015027"}], ",", 
       RowBox[{"-", "0.838670567945424"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.587785252292473"}], ",", 
       RowBox[{"-", "0.809016994374948"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.629320391049837"}], ",", 
       RowBox[{"-", "0.777145961456971"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.669130606358857"}], ",", 
       RowBox[{"-", "0.743144825477395"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.707106781186547"}], ",", 
       RowBox[{"-", "0.707106781186548"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.743144825477394"}], ",", 
       RowBox[{"-", "0.669130606358858"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.777145961456971"}], ",", 
       RowBox[{"-", "0.629320391049838"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.809016994374947"}], ",", 
       RowBox[{"-", "0.587785252292474"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.838670567945422"}], ",", 
       RowBox[{"-", "0.544639035015029"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.866025403784437"}], ",", 
       RowBox[{"-", "0.500000000000003"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.891006524188366"}], ",", 
       RowBox[{"-", "0.45399049973955"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9135454576426"}], ",", 
       RowBox[{"-", "0.406736643075802"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.933580426497201"}], ",", 
       RowBox[{"-", "0.358367949545303"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.951056516295153"}], ",", 
       RowBox[{"-", "0.309016994374949"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.965925826289069"}], ",", 
       RowBox[{"-", "0.25881904510252"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.978147600733806"}], ",", 
       RowBox[{"-", "0.207911690817758"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.987688340595138"}], ",", 
       RowBox[{"-", "0.156434465040232"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.994521895368273"}], ",", 
       RowBox[{"-", "0.104528463267654"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998629534754574"}], ",", 
       RowBox[{"-", "0.052335956242944"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1.96420273146138*^-15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.998629534754574"}], ",", "0.052335956242942"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.994521895368273"}], ",", "0.104528463267652"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.987688340595138"}], ",", "0.15643446504023"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.978147600733806"}], ",", "0.207911690817758"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.965925826289069"}], ",", "0.25881904510252"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.951056516295154"}], ",", "0.309016994374945"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.933580426497202"}], ",", "0.358367949545298"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.913545457642601"}], ",", "0.406736643075799"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.891006524188368"}], ",", "0.453990499739546"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.866025403784439"}], ",", "0.499999999999999"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.838670567945424"}], ",", "0.544639035015027"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.809016994374948"}], ",", "0.587785252292472"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.777145961456971"}], ",", "0.629320391049838"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.743144825477394"}], ",", "0.669130606358858"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.707106781186549"}], ",", "0.707106781186546"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.669130606358858"}], ",", "0.743144825477394"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.629320391049838"}], ",", "0.777145961456971"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.587785252292474"}], ",", "0.809016994374947"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.544639035015029"}], ",", "0.838670567945422"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.500000000000003"}], ",", "0.866025403784437"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.453990499739549"}], ",", "0.891006524188367"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.406736643075803"}], ",", "0.9135454576426"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.358367949545302"}], ",", "0.933580426497201"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.309016994374947"}], ",", "0.951056516295154"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25881904510252"}], ",", "0.965925826289069"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.20791169081776"}], ",", "0.978147600733806"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.156434465040232"}], ",", "0.987688340595137"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.104528463267654"}], ",", "0.994521895368273"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0523359562429459"}], ",", "0.998629534754574"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.96420273146138*^-15"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0523359562429439", ",", "0.998629534754574"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.104528463267654", ",", "0.994521895368273"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.15643446504023", ",", "0.987688340595138"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.207911690817758", ",", "0.978147600733806"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.258819045102519", ",", "0.965925826289069"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.309016994374947", ",", "0.951056516295154"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.358367949545299", ",", "0.933580426497202"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.406736643075798", ",", "0.913545457642602"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.453990499739546", ",", "0.891006524188368"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.499999999999999", ",", "0.866025403784439"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.544639035015026", ",", "0.838670567945425"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.587785252292473", ",", "0.809016994374948"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.629320391049837", ",", "0.777145961456971"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.669130606358856", ",", "0.743144825477396"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186548"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.743144825477394", ",", "0.669130606358858"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.77714596145697", ",", "0.629320391049838"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.809016994374946", ",", "0.587785252292475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.838670567945423", ",", "0.544639035015029"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.866025403784437", ",", "0.500000000000002"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.891006524188367", ",", "0.453990499739548"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9135454576426", ",", "0.406736643075802"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.933580426497202", ",", "0.358367949545301"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951056516295153", ",", "0.309016994374948"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.965925826289068", ",", "0.258819045102523"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.978147600733805", ",", "0.207911690817761"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.987688340595138", ",", "0.156434465040232"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.994521895368273", ",", "0.104528463267654"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998629534754574", ",", "0.0523359562429458"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.96420273146137*^-15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.998629534754574", ",", 
       RowBox[{"-", "0.0523359562429438"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.994521895368273", ",", 
       RowBox[{"-", "0.104528463267654"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.987688340595138", ",", 
       RowBox[{"-", "0.156434465040229"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.978147600733806", ",", 
       RowBox[{"-", "0.207911690817759"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.965925826289068", ",", 
       RowBox[{"-", "0.258819045102523"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.951056516295154", ",", 
       RowBox[{"-", "0.309016994374946"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.933580426497203", ",", 
       RowBox[{"-", "0.358367949545298"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.913545457642601", ",", 
       RowBox[{"-", "0.406736643075799"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.891006524188369", ",", 
       RowBox[{"-", "0.453990499739544"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.86602540378444", ",", 
       RowBox[{"-", "0.499999999999998"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.838670567945425", ",", 
       RowBox[{"-", "0.544639035015026"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.809016994374948", ",", 
       RowBox[{"-", "0.587785252292472"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.777145961456971", ",", 
       RowBox[{"-", "0.629320391049837"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.743144825477395", ",", 
       RowBox[{"-", "0.669130606358857"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", 
       RowBox[{"-", "0.707106781186547"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.669130606358859", ",", 
       RowBox[{"-", "0.743144825477393"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.629320391049838", ",", 
       RowBox[{"-", "0.77714596145697"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.587785252292473", ",", 
       RowBox[{"-", "0.809016994374947"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.544639035015028", ",", 
       RowBox[{"-", "0.838670567945423"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.500000000000001", ",", 
       RowBox[{"-", "0.866025403784438"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.453990499739548", ",", 
       RowBox[{"-", "0.891006524188367"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.406736643075801", ",", 
       RowBox[{"-", "0.9135454576426"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.358367949545301", ",", 
       RowBox[{"-", "0.933580426497202"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.309016994374948", ",", 
       RowBox[{"-", "0.951056516295153"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.258819045102522", ",", 
       RowBox[{"-", "0.965925826289068"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.207911690817761", ",", 
       RowBox[{"-", "0.978147600733805"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.156434465040233", ",", 
       RowBox[{"-", "0.987688340595137"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.10452846326765", ",", 
       RowBox[{"-", "0.994521895368274"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0523359562429476", ",", 
       RowBox[{"-", "0.998629534754574"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.0674074935959337", ",", "0.00353267704639871"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674691504416421", ",", "0.00235619434570327"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0675000000000001", ",", "0.00117809724202136"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674999999999999", ",", 
       RowBox[{"-", "0.00117809724202134"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674691504416417", ",", 
       RowBox[{"-", "0.00235619434570323"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0673458367502248", ",", 
       RowBox[{"-", "0.00470915974709408"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0672533726316464", ",", 
       RowBox[{"-", "0.00588402776850332"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0670070832430697", ",", 
       RowBox[{"-", "0.00822731477262974"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0668532580019923", ",", 
       RowBox[{"-", "0.0093957334801837"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0664846679783504", ",", 
       RowBox[{"-", "0.0117229193002473"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0662699032390679", ",", 
       RowBox[{"-", "0.0128816861394843"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0657800228599951", ",", 
       RowBox[{"-", "0.0151863921209129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0655049072777296", ",", 
       RowBox[{"-", "0.0163323309924717"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0648950792712938", ",", 
       RowBox[{"-", "0.0186082400963684"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0645603669187333", ",", 
       RowBox[{"-", "0.019738210061455"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0638322627811116", ",", 
       RowBox[{"-", "0.0219790841791625"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0634388710815489", ",", 
       RowBox[{"-", "0.0230899880686461"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0625944864955726", ",", 
       RowBox[{"-", "0.0252896851199691"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0621434937083118", ",", 
       RowBox[{"-", "0.0263784780235064"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0611851430734386", ",", 
       RowBox[{"-", "0.0285309687917262"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0606777853383615", ",", 
       RowBox[{"-", "0.0295946664036498"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0596080954270674", ",", 
       RowBox[{"-", "0.0316940510611885"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05904576337646", ",", 
       RowBox[{"-", "0.0327297378602809"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0578676661344386", ",", 
       RowBox[{"-", "0.0347702621397186"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0572519010813642", ",", 
       RowBox[{"-", "0.0357750993804531"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0559686255912674", ",", 
       RowBox[{"-", "0.0377511703465751"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0553011153049352", ",", 
       RowBox[{"-", "0.0387224038399201"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0539161789356821", ",", 
       RowBox[{"-", "0.0406286052195632"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0531987530153889", ",", 
       RowBox[{"-", "0.0415635728820233"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0517159517813016", ",", 
       RowBox[{"-", "0.0433946799097042"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0509505766416273", ",", 
       RowBox[{"-", "0.0442908190599053"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0493739747978204", ",", 
       RowBox[{"-", "0.04604181279854"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0485627482788222", ",", 
       RowBox[{"-", "0.0468966671813612"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0468966671813612", ",", 
       RowBox[{"-", "0.0485627482788221"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.04604181279854", ",", 
       RowBox[{"-", "0.0493739747978203"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0442908190599053", ",", 
       RowBox[{"-", "0.0509505766416272"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0433946799097043", ",", 
       RowBox[{"-", "0.0517159517813016"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0415635728820233", ",", 
       RowBox[{"-", "0.0531987530153888"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0406286052195633", ",", 
       RowBox[{"-", "0.053916178935682"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0387224038399202", ",", 
       RowBox[{"-", "0.0553011153049352"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0377511703465751", ",", 
       RowBox[{"-", "0.0559686255912674"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0357750993804532", ",", 
       RowBox[{"-", "0.0572519010813642"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0347702621397187", ",", 
       RowBox[{"-", "0.0578676661344386"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.032729737860281", ",", 
       RowBox[{"-", "0.0590457633764599"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0316940510611886", ",", 
       RowBox[{"-", "0.0596080954270674"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0295946664036499", ",", 
       RowBox[{"-", "0.0606777853383616"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0285309687917263", ",", 
       RowBox[{"-", "0.0611851430734386"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0263784780235065", ",", 
       RowBox[{"-", "0.0621434937083118"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0252896851199691", ",", 
       RowBox[{"-", "0.0625944864955726"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0230899880686462", ",", 
       RowBox[{"-", "0.0634388710815489"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0219790841791626", ",", 
       RowBox[{"-", "0.0638322627811117"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0197382100614551", ",", 
       RowBox[{"-", "0.0645603669187334"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0186082400963684", ",", 
       RowBox[{"-", "0.0648950792712939"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0163323309924717", ",", 
       RowBox[{"-", "0.0655049072777296"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.015186392120913", ",", 
       RowBox[{"-", "0.0657800228599951"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0128816861394844", ",", 
       RowBox[{"-", "0.0662699032390679"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0117229193002473", ",", 
       RowBox[{"-", "0.0664846679783505"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00939573348018377", ",", 
       RowBox[{"-", "0.0668532580019924"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0082273147726298", ",", 
       RowBox[{"-", "0.0670070832430698"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00588402776850338", ",", 
       RowBox[{"-", "0.0672533726316465"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00470915974709414", ",", 
       RowBox[{"-", "0.067345836750225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00235619434570328", ",", 
       RowBox[{"-", "0.0674691504416417"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00117809724202137", ",", 
       RowBox[{"-", "0.0674999999999997"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00117809724202134"}], ",", 
       RowBox[{"-", "0.0674999999999997"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00235619434570324"}], ",", 
       RowBox[{"-", "0.0674691504416418"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0047091597470941"}], ",", 
       RowBox[{"-", "0.067345836750225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00588402776850334"}], ",", 
       RowBox[{"-", "0.0672533726316465"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00822731477262977"}], ",", 
       RowBox[{"-", "0.0670070832430698"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00939573348018373"}], ",", 
       RowBox[{"-", "0.0668532580019924"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0117229193002473"}], ",", 
       RowBox[{"-", "0.0664846679783505"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0128816861394844"}], ",", 
       RowBox[{"-", "0.066269903239068"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.015186392120913"}], ",", 
       RowBox[{"-", "0.0657800228599952"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0163323309924717"}], ",", 
       RowBox[{"-", "0.0655049072777297"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0186082400963684"}], ",", 
       RowBox[{"-", "0.0648950792712939"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0197382100614551"}], ",", 
       RowBox[{"-", "0.0645603669187334"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0219790841791626"}], ",", 
       RowBox[{"-", "0.0638322627811117"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0230899880686462"}], ",", 
       RowBox[{"-", "0.063438871081549"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0252896851199691"}], ",", 
       RowBox[{"-", "0.0625944864955727"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0263784780235065"}], ",", 
       RowBox[{"-", "0.0621434937083119"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0285309687917263"}], ",", 
       RowBox[{"-", "0.0611851430734387"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0295946664036499"}], ",", 
       RowBox[{"-", "0.0606777853383616"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0316940510611886"}], ",", 
       RowBox[{"-", "0.0596080954270675"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.032729737860281"}], ",", 
       RowBox[{"-", "0.05904576337646"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0347702621397187"}], ",", 
       RowBox[{"-", "0.0578676661344387"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0357750993804532"}], ",", 
       RowBox[{"-", "0.0572519010813643"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0377511703465751"}], ",", 
       RowBox[{"-", "0.0559686255912675"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0387224038399202"}], ",", 
       RowBox[{"-", "0.0553011153049353"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0406286052195633"}], ",", 
       RowBox[{"-", "0.0539161789356821"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0415635728820233"}], ",", 
       RowBox[{"-", "0.0531987530153889"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0433946799097043"}], ",", 
       RowBox[{"-", "0.0517159517813017"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0442908190599054"}], ",", 
       RowBox[{"-", "0.0509505766416273"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0460418127985401"}], ",", 
       RowBox[{"-", "0.0493739747978204"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0468966671813613"}], ",", 
       RowBox[{"-", "0.0485627482788222"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0485627482788222"}], ",", 
       RowBox[{"-", "0.0468966671813613"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0493739747978204"}], ",", 
       RowBox[{"-", "0.0460418127985401"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0509505766416273"}], ",", 
       RowBox[{"-", "0.0442908190599054"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0517159517813017"}], ",", 
       RowBox[{"-", "0.0433946799097043"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0531987530153889"}], ",", 
       RowBox[{"-", "0.0415635728820234"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0539161789356821"}], ",", 
       RowBox[{"-", "0.0406286052195633"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0553011153049353"}], ",", 
       RowBox[{"-", "0.0387224038399202"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0559686255912675"}], ",", 
       RowBox[{"-", "0.0377511703465752"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0572519010813643"}], ",", 
       RowBox[{"-", "0.0357750993804532"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0578676661344387"}], ",", 
       RowBox[{"-", "0.0347702621397188"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0590457633764601"}], ",", 
       RowBox[{"-", "0.032729737860281"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0596080954270675"}], ",", 
       RowBox[{"-", "0.0316940510611887"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0606777853383617"}], ",", 
       RowBox[{"-", "0.0295946664036499"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0611851430734387"}], ",", 
       RowBox[{"-", "0.0285309687917263"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.062143493708312"}], ",", 
       RowBox[{"-", "0.0263784780235065"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0625944864955727"}], ",", 
       RowBox[{"-", "0.0252896851199692"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0634388710815491"}], ",", 
       RowBox[{"-", "0.0230899880686462"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0638322627811118"}], ",", 
       RowBox[{"-", "0.0219790841791626"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0645603669187335"}], ",", 
       RowBox[{"-", "0.0197382100614551"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.064895079271294"}], ",", 
       RowBox[{"-", "0.0186082400963684"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0655049072777297"}], ",", 
       RowBox[{"-", "0.0163323309924717"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0657800228599952"}], ",", 
       RowBox[{"-", "0.015186392120913"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.066269903239068"}], ",", 
       RowBox[{"-", "0.0128816861394844"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0664846679783506"}], ",", 
       RowBox[{"-", "0.0117229193002473"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0668532580019925"}], ",", 
       RowBox[{"-", "0.00939573348018377"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0670070832430699"}], ",", 
       RowBox[{"-", "0.00822731477262981"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0672533726316466"}], ",", 
       RowBox[{"-", "0.00588402776850338"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0673458367502251"}], ",", 
       RowBox[{"-", "0.00470915974709414"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674691504416419"}], ",", 
       RowBox[{"-", "0.00235619434570327"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674999999999998"}], ",", 
       RowBox[{"-", "0.00117809724202136"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674999999999998"}], ",", "0.00117809724202135"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0674691504416419"}], ",", "0.00235619434570325"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0673458367502252"}], ",", "0.00470915974709412"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0672533726316466"}], ",", "0.00588402776850336"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0670070832430699"}], ",", "0.00822731477262979"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0668532580019925"}], ",", "0.00939573348018376"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0664846679783506"}], ",", "0.0117229193002473"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0662699032390681"}], ",", "0.0128816861394844"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0657800228599953"}], ",", "0.015186392120913"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0655049072777298"}], ",", "0.0163323309924717"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.064895079271294"}], ",", "0.0186082400963684"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0645603669187335"}], ",", "0.0197382100614551"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0638322627811118"}], ",", "0.0219790841791626"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0634388710815491"}], ",", "0.0230899880686462"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0625944864955728"}], ",", "0.0252896851199692"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.062143493708312"}], ",", "0.0263784780235065"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0611851430734388"}], ",", "0.0285309687917263"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0606777853383617"}], ",", "0.02959466640365"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0596080954270676"}], ",", "0.0316940510611887"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0590457633764601"}], ",", "0.032729737860281"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0578676661344388"}], ",", "0.0347702621397188"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0572519010813643"}], ",", "0.0357750993804532"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0559686255912676"}], ",", "0.0377511703465752"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0553011153049354"}], ",", "0.0387224038399203"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0539161789356822"}], ",", "0.0406286052195634"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.053198753015389"}], ",", "0.0415635728820234"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0517159517813018"}], ",", "0.0433946799097044"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0509505766416274"}], ",", "0.0442908190599054"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0493739747978205"}], ",", "0.0460418127985402"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0485627482788223"}], ",", "0.0468966671813614"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0468966671813614"}], ",", "0.0485627482788223"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0460418127985402"}], ",", "0.0493739747978205"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0442908190599055"}], ",", "0.0509505766416274"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0433946799097044"}], ",", "0.0517159517813018"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0415635728820234"}], ",", "0.053198753015389"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0406286052195634"}], ",", "0.0539161789356822"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0387224038399203"}], ",", "0.0553011153049354"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0377511703465752"}], ",", "0.0559686255912676"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0357750993804533"}], ",", "0.0572519010813644"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0347702621397188"}], ",", "0.0578676661344388"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0327297378602811"}], ",", "0.0590457633764601"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0316940510611887"}], ",", "0.0596080954270676"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.02959466640365"}], ",", "0.0606777853383618"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0285309687917263"}], ",", "0.0611851430734388"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0263784780235066"}], ",", "0.0621434937083121"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0252896851199692"}], ",", "0.0625944864955728"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0230899880686462"}], ",", "0.0634388710815492"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0219790841791627"}], ",", "0.0638322627811119"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0197382100614552"}], ",", "0.0645603669187336"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0186082400963685"}], ",", "0.0648950792712941"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0163323309924718"}], ",", "0.0655049072777299"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.015186392120913"}], ",", "0.0657800228599954"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0128816861394844"}], ",", "0.0662699032390682"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0117229193002474"}], ",", "0.0664846679783507"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00939573348018378"}], ",", "0.0668532580019927"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00822731477262982"}], ",", "0.06700708324307"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00588402776850338"}], ",", "0.0672533726316467"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00470915974709414"}], ",", "0.0673458367502252"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00235619434570327"}], ",", "0.067469150441642"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.00117809724202136"}], ",", "0.0674999999999999"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00117809724202135", ",", "0.0674999999999999"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00235619434570326", ",", "0.067469150441642"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00470915974709413", ",", "0.0673458367502253"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00588402776850338", ",", "0.0672533726316467"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00822731477262981", ",", "0.06700708324307"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.00939573348018378", ",", "0.0668532580019927"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0117229193002473", ",", "0.0664846679783507"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0128816861394844", ",", "0.0662699032390682"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.015186392120913", ",", "0.0657800228599954"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0163323309924718", ",", "0.0655049072777299"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0186082400963685", ",", "0.0648950792712941"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0197382100614552", ",", "0.0645603669187336"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0219790841791627", ",", "0.0638322627811119"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0230899880686463", ",", "0.0634388710815492"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0252896851199692", ",", "0.0625944864955729"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0263784780235066", ",", "0.0621434937083121"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0285309687917264", ",", "0.0611851430734388"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.02959466640365", ",", "0.0606777853383618"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0316940510611887", ",", "0.0596080954270677"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0327297378602811", ",", "0.0590457633764602"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0347702621397188", ",", "0.0578676661344389"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0357750993804533", ",", "0.0572519010813644"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0377511703465753", ",", "0.0559686255912677"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0387224038399204", ",", "0.0553011153049355"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0406286052195634", ",", "0.0539161789356823"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0415635728820235", ",", "0.0531987530153891"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0433946799097045", ",", "0.0517159517813019"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0442908190599055", ",", "0.0509505766416275"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0460418127985403", ",", "0.0493739747978206"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0468966671813614", ",", "0.0485627482788224"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0485627482788224", ",", "0.0468966671813614"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0493739747978206", ",", "0.0460418127985403"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0509505766416275", ",", "0.0442908190599055"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0517159517813019", ",", "0.0433946799097045"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0531987530153891", ",", "0.0415635728820235"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0539161789356823", ",", "0.0406286052195634"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0553011153049355", ",", "0.0387224038399204"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0559686255912677", ",", "0.0377511703465753"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0572519010813645", ",", "0.0357750993804533"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0578676661344389", ",", "0.0347702621397189"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0590457633764603", ",", "0.0327297378602811"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0596080954270677", ",", "0.0316940510611888"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0606777853383619", ",", "0.02959466640365"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0611851430734389", ",", "0.0285309687917264"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0621434937083122", ",", "0.0263784780235066"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0625944864955729", ",", "0.0252896851199692"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0634388710815493", ",", "0.0230899880686463"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.063832262781112", ",", "0.0219790841791627"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0645603669187337", ",", "0.0197382100614552"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0648950792712942", ",", "0.0186082400963685"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.06550490727773", ",", "0.0163323309924718"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0657800228599955", ",", "0.0151863921209131"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0662699032390683", ",", "0.0128816861394844"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0664846679783508", ",", "0.0117229193002474"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0668532580019928", ",", "0.0093957334801838"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0670070832430701", ",", "0.00822731477262983"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0672533726316468", ",", "0.00588402776850339"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0673458367502254", ",", "0.00470915974709415"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0674074935959337", ",", "0.00353267704639871"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.00833333333333336", ",", 
     "0.00833333333333336", ",", "0.0166666666666666", ",", 
     "0.0166666666666666", ",", "0.0249999999999999", ",", 
     "0.0249999999999999", ",", "0.0333333333333332", ",", 
     "0.0333333333333332", ",", "0.0416666666666665", ",", 
     "0.0416666666666665", ",", "0.0499999999999998", ",", 
     "0.0499999999999998", ",", "0.0583333333333331", ",", 
     "0.0583333333333331", ",", "0.0666666666666664", ",", 
     "0.0666666666666664", ",", "0.0749999999999997", ",", 
     "0.0749999999999997", ",", "0.083333333333333", ",", "0.083333333333333",
      ",", "0.0916666666666662", ",", "0.0916666666666662", ",", 
     "0.0999999999999995", ",", "0.0999999999999995", ",", 
     "0.108333333333333", ",", "0.108333333333333", ",", "0.116666666666666", 
     ",", "0.116666666666666", ",", "0.124999999999999", ",", 
     "0.124999999999999", ",", "0.133333333333333", ",", "0.133333333333333", 
     ",", "0.141666666666666", ",", "0.141666666666666", ",", 
     "0.149999999999999", ",", "0.149999999999999", ",", "0.158333333333333", 
     ",", "0.158333333333333", ",", "0.166666666666666", ",", 
     "0.166666666666666", ",", "0.174999999999999", ",", "0.174999999999999", 
     ",", "0.183333333333332", ",", "0.183333333333332", ",", 
     "0.191666666666666", ",", "0.191666666666666", ",", "0.199999999999999", 
     ",", "0.199999999999999", ",", "0.208333333333332", ",", 
     "0.208333333333332", ",", "0.216666666666666", ",", "0.216666666666666", 
     ",", "0.224999999999999", ",", "0.224999999999999", ",", 
     "0.233333333333332", ",", "0.233333333333332", ",", "0.241666666666666", 
     ",", "0.241666666666666", ",", "0.249999999999999", ",", 
     "0.249999999999999", ",", "0.258333333333332", ",", "0.258333333333332", 
     ",", "0.266666666666666", ",", "0.266666666666666", ",", 
     "0.274999999999999", ",", "0.274999999999999", ",", "0.283333333333332", 
     ",", "0.283333333333332", ",", "0.291666666666666", ",", 
     "0.291666666666666", ",", "0.299999999999999", ",", "0.299999999999999", 
     ",", "0.308333333333332", ",", "0.308333333333332", ",", 
     "0.316666666666666", ",", "0.316666666666666", ",", "0.324999999999999", 
     ",", "0.324999999999999", ",", "0.333333333333332", ",", 
     "0.333333333333332", ",", "0.341666666666666", ",", "0.341666666666666", 
     ",", "0.349999999999999", ",", "0.349999999999999", ",", 
     "0.358333333333332", ",", "0.358333333333332", ",", "0.366666666666666", 
     ",", "0.366666666666666", ",", "0.374999999999999", ",", 
     "0.374999999999999", ",", "0.383333333333332", ",", "0.383333333333332", 
     ",", "0.391666666666666", ",", "0.391666666666666", ",", 
     "0.399999999999999", ",", "0.399999999999999", ",", "0.408333333333332", 
     ",", "0.408333333333332", ",", "0.416666666666666", ",", 
     "0.416666666666666", ",", "0.424999999999999", ",", "0.424999999999999", 
     ",", "0.433333333333332", ",", "0.433333333333332", ",", 
     "0.441666666666666", ",", "0.441666666666666", ",", "0.449999999999999", 
     ",", "0.449999999999999", ",", "0.458333333333332", ",", 
     "0.458333333333332", ",", "0.466666666666666", ",", "0.466666666666666", 
     ",", "0.474999999999999", ",", "0.474999999999999", ",", 
     "0.483333333333332", ",", "0.483333333333332", ",", "0.491666666666665", 
     ",", "0.491666666666665", ",", "0.499999999999999", ",", 
     "0.499999999999999", ",", "0.508333333333332", ",", "0.508333333333332", 
     ",", "0.516666666666665", ",", "0.516666666666665", ",", 
     "0.524999999999999", ",", "0.524999999999999", ",", "0.533333333333332", 
     ",", "0.533333333333332", ",", "0.541666666666666", ",", 
     "0.541666666666666", ",", "0.549999999999999", ",", "0.549999999999999", 
     ",", "0.558333333333332", ",", "0.558333333333332", ",", 
     "0.566666666666665", ",", "0.566666666666665", ",", "0.574999999999999", 
     ",", "0.574999999999999", ",", "0.583333333333332", ",", 
     "0.583333333333332", ",", "0.591666666666665", ",", "0.591666666666665", 
     ",", "0.599999999999999", ",", "0.599999999999999", ",", 
     "0.608333333333332", ",", "0.608333333333332", ",", "0.616666666666665", 
     ",", "0.616666666666665", ",", "0.624999999999999", ",", 
     "0.624999999999999", ",", "0.633333333333332", ",", "0.633333333333332", 
     ",", "0.641666666666665", ",", "0.641666666666665", ",", 
     "0.649999999999999", ",", "0.649999999999999", ",", "0.658333333333332", 
     ",", "0.658333333333332", ",", "0.666666666666666", ",", 
     "0.666666666666666", ",", "0.674999999999999", ",", "0.674999999999999", 
     ",", "0.683333333333332", ",", "0.683333333333332", ",", 
     "0.691666666666666", ",", "0.691666666666666", ",", "0.699999999999999", 
     ",", "0.699999999999999", ",", "0.708333333333332", ",", 
     "0.708333333333332", ",", "0.716666666666666", ",", "0.716666666666666", 
     ",", "0.724999999999999", ",", "0.724999999999999", ",", 
     "0.733333333333332", ",", "0.733333333333332", ",", "0.741666666666666", 
     ",", "0.741666666666666", ",", "0.749999999999999", ",", 
     "0.749999999999999", ",", "0.758333333333332", ",", "0.758333333333332", 
     ",", "0.766666666666666", ",", "0.766666666666666", ",", 
     "0.774999999999999", ",", "0.774999999999999", ",", "0.783333333333333", 
     ",", "0.783333333333333", ",", "0.791666666666666", ",", 
     "0.791666666666666", ",", "0.799999999999999", ",", "0.799999999999999", 
     ",", "0.808333333333333", ",", "0.808333333333333", ",", 
     "0.816666666666666", ",", "0.816666666666666", ",", "0.824999999999999", 
     ",", "0.824999999999999", ",", "0.833333333333333", ",", 
     "0.833333333333333", ",", "0.841666666666666", ",", "0.841666666666666", 
     ",", "0.85", ",", "0.85", ",", "0.858333333333333", ",", 
     "0.858333333333333", ",", "0.866666666666666", ",", "0.866666666666666", 
     ",", "0.874999999999999", ",", "0.874999999999999", ",", 
     "0.883333333333333", ",", "0.883333333333333", ",", "0.891666666666666", 
     ",", "0.891666666666666", ",", "0.9", ",", "0.9", ",", 
     "0.908333333333333", ",", "0.908333333333333", ",", "0.916666666666666", 
     ",", "0.916666666666666", ",", "0.925", ",", "0.925", ",", 
     "0.933333333333333", ",", "0.933333333333333", ",", "0.941666666666666", 
     ",", "0.941666666666666", ",", "0.95", ",", "0.95", ",", 
     "0.958333333333333", ",", "0.958333333333333", ",", "0.966666666666666", 
     ",", "0.966666666666666", ",", "0.975", ",", "0.975", ",", 
     "0.983333333333333", ",", "0.983333333333333", ",", "0.991666666666667", 
     ",", "0.991666666666667", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586707906313798*^9, 3.58670790631424*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", "CV"}], ";"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.58654185225243*^9, 3.586541855130949*^9}}],

Cell[BoxData["121"], "Output",
 CellChangeTimes->{3.586541856876045*^9, 3.586543032858363*^9, 
  3.586626300781831*^9, 3.586627094779155*^9, 3.586627423049467*^9, 
  3.586700717684812*^9, 3.586701555028276*^9, 3.586704096441888*^9, 
  3.586706977988926*^9, 3.58670784213584*^9, 3.5867079212575893`*^9, 
  3.58680874212881*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586626302592072*^9, 3.5866271052208967`*^9, 
  3.586627424120181*^9, 3.586700718813528*^9, 3.5867015550680237`*^9, 
  3.586704097729162*^9, 3.586706978378162*^9, 3.5867078432227*^9, 
  3.5867079213074102`*^9, 3.58680874322083*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.5866263208142443`*^9, 3.586626324327716*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"242", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.58662632507953*^9, 3.5866271105956087`*^9, 
  3.586627428440529*^9, 3.586700721185813*^9, 3.5867015550764837`*^9, 
  3.5867041009849567`*^9, 3.586706978391019*^9, 3.586707845116118*^9, 
  3.586707921314857*^9, 3.586808743275381*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.586626333881082*^9, 3.586626335847445*^9}}],

Cell[BoxData[
 RowBox[{"{", "246", "}"}]], "Output",
 CellChangeTimes->{3.5866263370690928`*^9, 3.586627111775069*^9, 
  3.586627429428741*^9, 3.586700722256385*^9, 3.586701555081559*^9, 
  3.586704101934599*^9, 3.58670697839461*^9, 3.586707846040646*^9, 
  3.586707921318595*^9, 3.5868087432800207`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.586281268165971*^9, 3.5862812701287527`*^9}, {
  3.586281313101166*^9, 3.586281320774119*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281270811432*^9, 3.58628132140816*^9, {3.586281353265336*^9, 
   3.5862813697264547`*^9}, 3.586281800499016*^9, 3.586281833787052*^9, 
   3.586281888739377*^9, 3.586282987870377*^9, 3.586283247985861*^9, 
   3.586285564393077*^9, {3.5865252071755037`*^9, 3.586525228155023*^9}, 
   3.5865261423477592`*^9, 3.586527496051359*^9, 3.5865328119404507`*^9, 
   3.586541842206522*^9, 3.586543036487014*^9, 3.586626306277677*^9, 
   3.586627112880786*^9, 3.586627430463785*^9, 3.5867007234735107`*^9, 
   3.586701555086636*^9, 3.5867041028544893`*^9, 3.5867069783981037`*^9, 
   3.5867078469960003`*^9, 3.5867079213225117`*^9, 3.586808743284696*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.586542572541441*^9, 3.586542585434044*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.58654258703892*^9, 3.586543038209257*^9, 
  3.58662630800243*^9, 3.58662711420161*^9, 3.586627431843741*^9, 
  3.58670072467605*^9, 3.5867015551279297`*^9, 3.586704103930251*^9, 
  3.586706978473783*^9, 3.5867078480505123`*^9, 3.586707921326404*^9, 
  3.586808743289667*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586542591022951*^9, 3.586542591576435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0674074935959337`", ",", "0.00353267704639871`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.58654259223214*^9, 3.586543039684025*^9, 
  3.586627433618116*^9, 3.586700725804323*^9, 3.586701555133086*^9, 
  3.586704104983008*^9, 3.586706978480756*^9, 3.5867078490479717`*^9, 
  3.58670792144318*^9, 3.586808743294475*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".1", "]"}]], "Input",
 CellChangeTimes->{{3.5865425947534657`*^9, 3.586542596516089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05661026333631569`", ",", 
   RowBox[{"-", "0.03676313486351426`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586542597045425*^9, 3.5865430407780037`*^9, 
  3.586627436222684*^9, 3.586700726899719*^9, 3.5867015551388083`*^9, 
  3.586704106024227*^9, 3.5867069784955463`*^9, 3.586707850131843*^9, 
  3.586707921447253*^9, 3.5868087434302483`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586707009530835*^9, 3.5867070528377237`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0674074935959337`", ",", "0.00353267704639871`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586707014130076*^9, 3.5867070532891607`*^9}, 
   3.586707851199587*^9, 3.586707921450976*^9, 3.586808743437462*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5867070165595503`*^9, 3.586707018603717*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0523359562429476`", ",", 
   RowBox[{"-", "0.998629534754574`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586707019370655*^9, 3.586707056902748*^9, 
  3.586707127240034*^9, 3.586707852205648*^9, 3.586707921454713*^9, 
  3.586808743444339*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586707071434284*^9, 3.5867070755456343`*^9}}],

Cell[BoxData["242"], "Output",
 CellChangeTimes->{3.586707076285346*^9, 3.5867078539399014`*^9, 
  3.586707921458362*^9, 3.586808743450965*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "T", "]"}]], "Input",
 CellChangeTimes->{{3.586707080237105*^9, 3.586707082018067*^9}}],

Cell[BoxData["121"], "Output",
 CellChangeTimes->{3.586707082676947*^9, 3.586707119775012*^9, 
  3.5867078553447447`*^9, 3.586707921507124*^9, 3.586808743457522*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", 
  RowBox[{"[", "121", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586707058716136*^9, 3.5867070627318*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0523359562429476`", ",", 
   RowBox[{"-", "0.998629534754574`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58670706377862*^9, 3.586707122118608*^9, 
  3.58670785651192*^9, 3.586707921512183*^9, 3.5868087434640923`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "Q", "]"}]], "Input",
 CellChangeTimes->{{3.586707023540099*^9, 3.586707026314493*^9}}],

Cell[BoxData["121"], "Output",
 CellChangeTimes->{3.586707026971964*^9, 3.58670792151609*^9, 
  3.586808744416559*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", "Green", ",", 
    "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}},
 CellID->1298760213],

Cell[BoxData[
 GraphicsBox[{BSplineCurveBox[CompressedData["
1:eJxdl31MlWUYxomG+EFyQMRqicPPprIyP0BNbqwQSRC/0qZDUwdzhRHYh0LN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    "],
    SplineKnots->{
     0, 0, 0, 0, 0.00833333333333336, 0.00833333333333336, 0.0166666666666666,
       0.0166666666666666, 0.0249999999999999, 0.0249999999999999, 
      0.0333333333333332, 0.0333333333333332, 0.0416666666666665, 
      0.0416666666666665, 0.0499999999999998, 0.0499999999999998, 
      0.0583333333333331, 0.0583333333333331, 0.0666666666666664, 
      0.0666666666666664, 0.0749999999999997, 0.0749999999999997, 
      0.083333333333333, 0.083333333333333, 0.0916666666666662, 
      0.0916666666666662, 0.0999999999999995, 0.0999999999999995, 
      0.108333333333333, 0.108333333333333, 0.116666666666666, 
      0.116666666666666, 0.124999999999999, 0.124999999999999, 
      0.133333333333333, 0.133333333333333, 0.141666666666666, 
      0.141666666666666, 0.149999999999999, 0.149999999999999, 
      0.158333333333333, 0.158333333333333, 0.166666666666666, 
      0.166666666666666, 0.174999999999999, 0.174999999999999, 
      0.183333333333332, 0.183333333333332, 0.191666666666666, 
      0.191666666666666, 0.199999999999999, 0.199999999999999, 
      0.208333333333332, 0.208333333333332, 0.216666666666666, 
      0.216666666666666, 0.224999999999999, 0.224999999999999, 
      0.233333333333332, 0.233333333333332, 0.241666666666666, 
      0.241666666666666, 0.249999999999999, 0.249999999999999, 
      0.258333333333332, 0.258333333333332, 0.266666666666666, 
      0.266666666666666, 0.274999999999999, 0.274999999999999, 
      0.283333333333332, 0.283333333333332, 0.291666666666666, 
      0.291666666666666, 0.299999999999999, 0.299999999999999, 
      0.308333333333332, 0.308333333333332, 0.316666666666666, 
      0.316666666666666, 0.324999999999999, 0.324999999999999, 
      0.333333333333332, 0.333333333333332, 0.341666666666666, 
      0.341666666666666, 0.349999999999999, 0.349999999999999, 
      0.358333333333332, 0.358333333333332, 0.366666666666666, 
      0.366666666666666, 0.374999999999999, 0.374999999999999, 
      0.383333333333332, 0.383333333333332, 0.391666666666666, 
      0.391666666666666, 0.399999999999999, 0.399999999999999, 
      0.408333333333332, 0.408333333333332, 0.416666666666666, 
      0.416666666666666, 0.424999999999999, 0.424999999999999, 
      0.433333333333332, 0.433333333333332, 0.441666666666666, 
      0.441666666666666, 0.449999999999999, 0.449999999999999, 
      0.458333333333332, 0.458333333333332, 0.466666666666666, 
      0.466666666666666, 0.474999999999999, 0.474999999999999, 
      0.483333333333332, 0.483333333333332, 0.491666666666665, 
      0.491666666666665, 0.499999999999999, 0.499999999999999, 
      0.508333333333332, 0.508333333333332, 0.516666666666665, 
      0.516666666666665, 0.524999999999999, 0.524999999999999, 
      0.533333333333332, 0.533333333333332, 0.541666666666666, 
      0.541666666666666, 0.549999999999999, 0.549999999999999, 
      0.558333333333332, 0.558333333333332, 0.566666666666665, 
      0.566666666666665, 0.574999999999999, 0.574999999999999, 
      0.583333333333332, 0.583333333333332, 0.591666666666665, 
      0.591666666666665, 0.599999999999999, 0.599999999999999, 
      0.608333333333332, 0.608333333333332, 0.616666666666665, 
      0.616666666666665, 0.624999999999999, 0.624999999999999, 
      0.633333333333332, 0.633333333333332, 0.641666666666665, 
      0.641666666666665, 0.649999999999999, 0.649999999999999, 
      0.658333333333332, 0.658333333333332, 0.666666666666666, 
      0.666666666666666, 0.674999999999999, 0.674999999999999, 
      0.683333333333332, 0.683333333333332, 0.691666666666666, 
      0.691666666666666, 0.699999999999999, 0.699999999999999, 
      0.708333333333332, 0.708333333333332, 0.716666666666666, 
      0.716666666666666, 0.724999999999999, 0.724999999999999, 
      0.733333333333332, 0.733333333333332, 0.741666666666666, 
      0.741666666666666, 0.749999999999999, 0.749999999999999, 
      0.758333333333332, 0.758333333333332, 0.766666666666666, 
      0.766666666666666, 0.774999999999999, 0.774999999999999, 
      0.783333333333333, 0.783333333333333, 0.791666666666666, 
      0.791666666666666, 0.799999999999999, 0.799999999999999, 
      0.808333333333333, 0.808333333333333, 0.816666666666666, 
      0.816666666666666, 0.824999999999999, 0.824999999999999, 
      0.833333333333333, 0.833333333333333, 0.841666666666666, 
      0.841666666666666, 0.85, 0.85, 0.858333333333333, 0.858333333333333, 
      0.866666666666666, 0.866666666666666, 0.874999999999999, 
      0.874999999999999, 0.883333333333333, 0.883333333333333, 
      0.891666666666666, 0.891666666666666, 0.9, 0.9, 0.908333333333333, 
      0.908333333333333, 0.916666666666666, 0.916666666666666, 0.925, 0.925, 
      0.933333333333333, 0.933333333333333, 0.941666666666666, 
      0.941666666666666, 0.95, 0.95, 0.958333333333333, 0.958333333333333, 
      0.966666666666666, 0.966666666666666, 0.975, 0.975, 0.983333333333333, 
      0.983333333333333, 0.991666666666667, 0.991666666666667, 1, 1, 1, 1}], 
   {RGBColor[1, 0, 0], 
    PointBox[{{0.0674074935959337, 0.00353267704639871}, {0.0675, 0}, {
      0.0674074935959333, -0.00353267704639865}, {
      0.067130227937358, -0.00705567127056653}, {
      0.0666689629901714, -0.0105593263902155}, {
      0.0660249630495315, -0.0140340391301986}, {
      0.0651999932745117, -0.01747028554442}, {
      0.0641963148499225, -0.0208586471203088}, {
      0.0630166787885607, -0.0241898365943076}, {
      0.0616643183908752, -0.0274547234076163}, {
      0.0601429403827145, -0.0306443587324192}, {
      0.0584567147554493, -0.0337499999999998}, {
      0.0566102633363158, -0.0367631348635141}, {
      0.0546086471203086, -0.0396755045297417}, {
      0.0524573523983452, -0.0424791263958638}, {
      0.0501622757197238, -0.0451663159292226}, {
      0.0477297077300917, -0.0477297077300917}, {
      0.0451663159292227, -0.0501622757197238}, {
      0.0424791263958638, -0.0524573523983452}, {
      0.0396755045297417, -0.0546086471203086}, {
      0.0367631348635141, -0.0566102633363158}, {
      0.0337499999999998, -0.0584567147554493}, {
      0.0306443587324193, -0.0601429403827145}, {
      0.0274547234076164, -0.0616643183908752}, {
      0.0241898365943077, -0.0630166787885608}, {
      0.0208586471203089, -0.0641963148499225}, {
      0.0174702855444201, -0.0651999932745118}, {
      0.0140340391301987, -0.0660249630495315}, {
      0.0105593263902155, -0.0666689629901714}, {
      0.00705567127056659, -0.0671302279373581}, {
      0.00353267704639871, -0.0674074935959334}, {
      1.87350135405495*^-17, -0.0674999999999997}, {-0.00353267704639867, \
-0.0674074935959334}, {-0.00705567127056656, -0.0671302279373581}, \
{-0.0105593263902155, -0.0666689629901715}, {-0.0140340391301987, \
-0.0660249630495316}, {-0.0174702855444201, -0.0651999932745118}, \
{-0.0208586471203088, -0.0641963148499226}, {-0.0241898365943076, \
-0.0630166787885608}, {-0.0274547234076164, -0.0616643183908753}, \
{-0.0306443587324193, -0.0601429403827146}, {-0.0337499999999998, \
-0.0584567147554494}, {-0.0367631348635142, -0.0566102633363159}, \
{-0.0396755045297418, -0.0546086471203087}, {-0.0424791263958638, \
-0.0524573523983453}, {-0.0451663159292227, -0.0501622757197239}, \
{-0.0477297077300917, -0.0477297077300918}, {-0.0501622757197239, \
-0.0451663159292227}, {-0.0524573523983453, -0.0424791263958638}, \
{-0.0546086471203087, -0.0396755045297418}, {-0.0566102633363159, \
-0.0367631348635142}, {-0.0584567147554494, -0.0337499999999999}, \
{-0.0601429403827146, -0.0306443587324193}, {-0.0616643183908753, \
-0.0274547234076164}, {-0.0630166787885609, -0.0241898365943077}, \
{-0.0641963148499226, -0.0208586471203089}, {-0.0651999932745119, \
-0.0174702855444201}, {-0.0660249630495316, -0.0140340391301987}, \
{-0.0666689629901716, -0.0105593263902156}, {-0.0671302279373582, \
-0.00705567127056659}, {-0.0674074935959335, -0.0035326770463987}, \
{-0.0674999999999998, -8.5868812060852*^-18}, {-0.0674074935959335, 
      0.00353267704639869}, {-0.0671302279373582, 
      0.00705567127056658}, {-0.0666689629901716, 
      0.0105593263902155}, {-0.0660249630495317, 
      0.0140340391301987}, {-0.0651999932745119, 
      0.0174702855444201}, {-0.0641963148499227, 
      0.0208586471203089}, {-0.0630166787885609, 
      0.0241898365943077}, {-0.0616643183908754, 
      0.0274547234076164}, {-0.0601429403827147, 
      0.0306443587324193}, {-0.0584567147554494, 
      0.0337499999999999}, {-0.056610263336316, 
      0.0367631348635142}, {-0.0546086471203088, 
      0.0396755045297418}, {-0.0524573523983454, 
      0.0424791263958639}, {-0.050162275719724, 
      0.0451663159292228}, {-0.0477297077300918, 
      0.0477297077300918}, {-0.0451663159292228, 
      0.050162275719724}, {-0.0424791263958639, 
      0.0524573523983454}, {-0.0396755045297418, 
      0.0546086471203088}, {-0.0367631348635142, 
      0.056610263336316}, {-0.0337499999999999, 
      0.0584567147554495}, {-0.0306443587324193, 
      0.0601429403827147}, {-0.0274547234076165, 
      0.0616643183908754}, {-0.0241898365943077, 
      0.063016678788561}, {-0.0208586471203089, 
      0.0641963148499227}, {-0.0174702855444201, 
      0.065199993274512}, {-0.0140340391301987, 
      0.0660249630495318}, {-0.0105593263902156, 
      0.0666689629901717}, {-0.0070556712705666, 
      0.0671302279373583}, {-0.00353267704639871, 
      0.0674074935959336}, {-3.90312782094782*^-18, 0.0674999999999999}, {
      0.0035326770463987, 0.0674074935959336}, {0.00705567127056659, 
      0.0671302279373583}, {0.0105593263902156, 0.0666689629901717}, {
      0.0140340391301987, 0.0660249630495318}, {0.0174702855444201, 
      0.065199993274512}, {0.0208586471203089, 0.0641963148499228}, {
      0.0241898365943077, 0.063016678788561}, {0.0274547234076165, 
      0.0616643183908755}, {0.0306443587324194, 0.0601429403827148}, {0.03375,
       0.0584567147554495}, {0.0367631348635143, 0.0566102633363161}, {
      0.0396755045297419, 0.0546086471203089}, {0.042479126395864, 
      0.0524573523983455}, {0.0451663159292229, 0.0501622757197241}, {
      0.0477297077300919, 0.0477297077300919}, {0.0501622757197241, 
      0.0451663159292229}, {0.0524573523983455, 0.042479126395864}, {
      0.0546086471203089, 0.0396755045297419}, {0.0566102633363161, 
      0.0367631348635143}, {0.0584567147554496, 0.03375}, {0.0601429403827148,
       0.0306443587324194}, {0.0616643183908755, 0.0274547234076165}, {
      0.0630166787885611, 0.0241898365943078}, {0.0641963148499228, 
      0.0208586471203089}, {0.0651999932745121, 0.0174702855444201}, {
      0.0660249630495319, 0.0140340391301988}, {0.0666689629901718, 
      0.0105593263902156}, {0.0671302279373585, 0.00705567127056661}, {
      0.0674074935959337, 0.00353267704639871}}]}},
  ImageSize->{706., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808744553668*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellChangeTimes->{3.58680815797908*^9}],

Cell[BoxData["v"], "Output",
 CellChangeTimes->{3.586808744560343*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - test of 5-point scheme\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.333333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.166666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.180651047756793", ",", 
     "0.180651047756793", ",", "0.270976571635189", ",", "0.270976571635189", 
     ",", "0.361302095513585", ",", "0.361302095513585", ",", 
     "0.616781257308151", ",", "0.616781257308151", ",", "0.872260419102717", 
     ",", "0.872260419102717", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586868500510531*^9, 3.586868500511224*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586876785609476*^9, 3.5868767876184683`*^9}}],

Cell[BoxData["14"], "Output",
 CellChangeTimes->{{3.586876788355008*^9, 3.5868767935134983`*^9}, 
   3.586876832026554*^9, 3.5868769559675503`*^9, 3.58687741086269*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.5868769499917517`*^9, 3.586876951255477*^9}}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{3.586876956895804*^9, 3.586877410917479*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.322824170196248"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.125282230716587"}], ",", 
       RowBox[{"-", "0.125282230716587"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.174298221547739", ",", 
     "0.174298221547739", ",", "0.261447332321608", ",", "0.261447332321608", 
     ",", "0.383762727974194", ",", "0.383762727974194", ",", 
     "0.383762727974194", ",", "0.630257636784516", ",", "0.630257636784516", 
     ",", "0.876752545594839", ",", "0.876752545594839", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.58687677998621*^9, 3.586876779990531*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.322824170196248"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.125282230716587"}], ",", 
       RowBox[{"-", "0.125282230716587"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.174298221547739", ",", 
     "0.174298221547739", ",", "0.261447332321608", ",", "0.261447332321608", 
     ",", "0.383762727974194", ",", "0.383762727974194", ",", 
     "0.383762727974194", ",", "0.630257636784516", ",", "0.630257636784516", 
     ",", "0.876752545594839", ",", "0.876752545594839", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.58687718025953*^9, 3.586877180260002*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.322824170196248"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.177175829803752"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.182732544669305", ",", 
     "0.182732544669305", ",", "0.274098817003958", ",", "0.274098817003958", 
     ",", "0.353942892604303", ",", "0.353942892604303", ",", 
     "0.353942892604303", ",", "0.612365735562582", ",", "0.612365735562582", 
     ",", "0.87078857852086", ",", "0.87078857852086", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.586877396286549*^9, 3.586877396287312*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.586876848912657*^9, 3.586876850322322*^9}}],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{3.586876850969067*^9, 3.586876960583672*^9, 
  3.5868771833647747`*^9, 3.586877411082738*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.5868768523034763`*^9, 3.5868768555136137`*^9}}],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{3.586876856246612*^9, 3.586876961634516*^9, 
  3.586877184296702*^9, 3.586877411092052*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9, 3.5868772114734573`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.833333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.322824170196248`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.177175829803752`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5868772122675047`*^9, 3.5868774111001596`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281796641926*^9, 3.586283247664104*^9, 3.586285540482194*^9, 
   3.586525204641143*^9, 3.586526142335073*^9, 3.586527496038389*^9, 
   3.5865328119334297`*^9, 3.5865418160677032`*^9, 3.5865430340674553`*^9, 
   3.586626302592072*^9, 3.5866271052208967`*^9, 3.586627424120181*^9, 
   3.586700718813528*^9, 3.5867015550680237`*^9, 3.586704097729162*^9, 
   3.586706978378162*^9, 3.5867078432227*^9, 3.5867079213074102`*^9, 
   3.586808224317224*^9, 3.586810420384132*^9, 3.586864019135633*^9, 
   3.5868644120769453`*^9, 3.586867274521298*^9, 3.586868216703465*^9, 
   3.586868527724132*^9, 3.5868748684429207`*^9, {3.586876808218535*^9, 
   3.586876858273356*^9}, 3.586876965509012*^9, 3.5868771861238527`*^9, 
   3.586877411107004*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, {3.5868768104901447`*^9, 3.586876860960597*^9}, 
   3.5868769673214197`*^9, 3.5868771882849827`*^9, 3.5868774112736588`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.5868646089756613`*^9, 3.5868646104613237`*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{
  3.58686461112786*^9, 3.5868672745755796`*^9, 3.586868216716403*^9, 
   3.586868527782716*^9, 3.586874868455041*^9, {3.586876812795732*^9, 
   3.586876832109372*^9}, 3.5868768630785027`*^9, 3.5868769681274347`*^9, 
   3.5868771886060762`*^9, 3.586877411280613*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586876891834058*^9, 3.586876892832652*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.833333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.322824170196248`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.177175829803752`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586876909226202*^9, 3.586876969553917*^9, 
  3.586877189453294*^9, 3.5868774112875957`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{3.586869397031418*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.182732544669305`", ",", 
   "0.182732544669305`", ",", "0.274098817003958`", ",", "0.274098817003958`",
    ",", "0.353942892604303`", ",", "0.353942892604303`", ",", 
   "0.353942892604303`", ",", "0.612365735562582`", ",", "0.612365735562582`",
    ",", "0.87078857852086`", ",", "0.87078857852086`", ",", "1", ",", "1", 
   ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.586869397675445*^9, 3.586874868459323*^9, {3.5868768139081573`*^9, 
   3.5868768321495333`*^9}, 3.586876864588814*^9, 3.586876970538651*^9, 
   3.5868771902676888`*^9, 3.586877411295053*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.5868769722389402`*^9, 3.586876977495442*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586876978117774*^9, 3.586877191019758*^9, 
  3.586877411345031*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".005"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}},
 CellID->1097886363],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-2, 
     0}, {-1.66666666666667, 0}, {-1.33333333333333, 0}, {-0.833333333333333, 
      0}, {-0.666666666666667, 0}, {-0.322824170196248, 
      0}, {-0.177175829803752, 0}, {0, 0}, {0.333333333333333, 
     0.333333333333333}, {0.666666666666667, 0.666666666666667}, {
     1.33333333333333, 1.33333333333333}, {1.66666666666667, 
     1.66666666666667}, {2.16666666666667, 2.16666666666667}, {
     2.33333333333333, 2.33333333333333}, {2.5, 2.5}},
    SplineKnots->{
     0, 0, 0, 0, 0.182732544669305, 0.182732544669305, 0.274098817003958, 
      0.274098817003958, 0.353942892604303, 0.353942892604303, 
      0.353942892604303, 0.612365735562582, 0.612365735562582, 
      0.87078857852086, 0.87078857852086, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.005], 
    PointBox[{{-2, 
      0}, {-1.66666666666667, 0}, {-1.33333333333333, 0}, {-0.833333333333333,
        0}, {-0.666666666666667, 0}, {-0.322824170196248, 
       0}, {-0.177175829803752, 0}, {0, 0}, {0.333333333333333, 
      0.333333333333333}, {0.666666666666667, 0.666666666666667}, {
      1.33333333333333, 1.33333333333333}, {1.66666666666667, 
      1.66666666666667}, {2.16666666666667, 2.16666666666667}, {
      2.33333333333333, 2.33333333333333}, {2.5, 2.5}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-2, 0}, {-1, 0}, {-0.5, 0}, {0, 0}, {1, 1}, {2, 2}, {2.5, 
       2.5}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9, 3.586874868826749*^9, 3.586876832363161*^9, 
  3.5868774116749353`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - test of 5-point scheme", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", 
    ",", "2", ",", "2", ",", "2"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586869478515704*^9, 3.586869479212916*^9}, {
  3.5868695234020967`*^9, 3.58686954086554*^9}, {3.586869658295916*^9, 
  3.586869663030076*^9}, {3.586871546829338*^9, 3.5868715518379498`*^9}, {
  3.586871695114541*^9, 3.5868717202653637`*^9}, {3.5868717918171997`*^9, 
  3.586871806691805*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", 
   ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{{3.586871696318088*^9, 3.5868717153129263`*^9}, {
  3.586871793001112*^9, 3.586871808181881*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586871638509266*^9, 3.586871645899143*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.58687165100966*^9, 3.5868716976288557`*^9, {3.586871794465509*^9, 
   3.586871809561943*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".8"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".2"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{".2", ",", ".2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{".8", ",", ".8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.586871580245841*^9, 3.586871635384782*^9}, {
  3.586871726630818*^9, 3.5868717281535378`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.586871652046673*^9, 3.5868716986139717`*^9, 3.586871728981811*^9, {
   3.5868717953612967`*^9, 3.586871810437522*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.58687175021275*^9, 3.586871755967142*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.5868717566664352`*^9, {3.5868717963518467`*^9, 3.5868718113091507`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"BSplineFunction", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"BSplineFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.586871861776247*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.586871862967366*^9, 3.586871863897827*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.5868718645949593`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.586871869046875*^9, 3.586871870689788*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`"}], "}"}]], "Output",
 CellChangeTimes->{3.586871871374701*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1.001", "]"}]], "Input",
 CellChangeTimes->{{3.58687187287891*^9, 3.58687189912904*^9}, {
  3.586871934562071*^9, 3.5868719350975657`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0006011991999999338`", ",", "0.0006011991999999338`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586871876338043*^9, 3.5868718998201*^9}, 
   3.586871935720705*^9}]
}, Open  ]],

Cell[BoxData["a"], "Input",
 CellChangeTimes->{3.586871944097768*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".005"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}},
 CellID->280088889],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-1, 0}, {-0.8, 0}, {-0.2, 0}, {0, 0}, {0.2, 0.2}, {0.8, 
     0.8}, {1, 1}},
    SplineKnots->{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2}], 
   {RGBColor[0, 1, 0], PointSize[0.005], 
    PointBox[{{-1, 0}, {-0.8, 0}, {-0.2, 0}, {0, 0}, {0.2, 0.2}, {0.8, 0.8}, {
      1, 1}}], 
    {RGBColor[1, 0, 0], PointBox[{{-1, 0}, {0, 0}, {1, 1}}]}}},
  ImageSize->{927., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586871653360463*^9, 3.5868716995979013`*^9, 
   3.5868717310847187`*^9, 3.586871812506158*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["example - test of 5-point scheme", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.333333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.166666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.180651047756793", ",", 
     "0.180651047756793", ",", "0.270976571635189", ",", "0.270976571635189", 
     ",", "0.361302095513585", ",", "0.361302095513585", ",", 
     "0.616781257308151", ",", "0.616781257308151", ",", "0.872260419102717", 
     ",", "0.872260419102717", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586868500510531*^9, 3.586868500511224*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CV", "[", 
  RowBox[{"[", "9", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586868504337666*^9, 3.586868510963333*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}]], "Output",
 CellChangeTimes->{{3.586868511604019*^9, 3.586868527697763*^9}, 
   3.5868748682487593`*^9, 3.586874996692883*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CV", "[", 
  RowBox[{"[", "8", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586868514737286*^9, 3.586868516332123*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}]], "Output",
 CellChangeTimes->{{3.586868516935863*^9, 3.586868527705414*^9}, 
   3.586874868262825*^9, 3.5868749967261343`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CV", "[", 
  RowBox[{"[", "7", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.586868519235776*^9, 3.586868522522481*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.166666666666667`"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.586868523043961*^9, 3.586868527712318*^9}, 
   3.586874868336341*^9, 3.586874996816017*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", "CV"}], ";"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586281796641926*^9, 3.586283247664104*^9, 
  3.586285540482194*^9, 3.586525204641143*^9, 3.586526142335073*^9, 
  3.586527496038389*^9, 3.5865328119334297`*^9, 3.5865418160677032`*^9, 
  3.5865430340674553`*^9, 3.586626302592072*^9, 3.5866271052208967`*^9, 
  3.586627424120181*^9, 3.586700718813528*^9, 3.5867015550680237`*^9, 
  3.586704097729162*^9, 3.586706978378162*^9, 3.5867078432227*^9, 
  3.5867079213074102`*^9, 3.586808224317224*^9, 3.586810420384132*^9, 
  3.586864019135633*^9, 3.5868644120769453`*^9, 3.586867274521298*^9, 
  3.586868216703465*^9, 3.586868527724132*^9, 3.5868748684429207`*^9, 
  3.5868749968246*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, 3.586874996831358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "2", 
   ",", "3", ",", "3", ",", "4", ",", "4", ",", "5", ",", "5", ",", "6", ",", 
   "6", ",", "6", ",", "6"}], "}"}]], "Input",
 CellChangeTimes->{{3.5868697960839777`*^9, 3.5868697964584303`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "2", 
   ",", "3", ",", "3", ",", "4", ",", "4", ",", "5", ",", "5", ",", "6", ",", 
   "6", ",", "6", ",", "6"}], "}"}]], "Output",
 CellChangeTimes->{3.5868697971951227`*^9, 3.586874868514944*^9, 
  3.5868749969061117`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "k", "]"}]], "Input",
 CellChangeTimes->{{3.586869496106762*^9, 3.586869497418082*^9}}],

Cell[BoxData["18"], "Output",
 CellChangeTimes->{3.586869498055913*^9, 3.586874868519692*^9, 
  3.5868749969115343`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.5868695000733633`*^9, 3.586869504394256*^9}}],

Cell[BoxData["14"], "Output",
 CellChangeTimes->{3.586869505056561*^9, 3.586874868523856*^9, 
  3.586874996915248*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["pts"], "Input",
 CellChangeTimes->{{3.586869807165287*^9, 3.5868698101553173`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.833333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.333333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.166666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586869811612681*^9, 3.586874868673069*^9, 
  3.586874996946569*^9, 3.586875060735425*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Insert"}]], "Input",
 CellChangeTimes->{{3.586875010284079*^9, 3.5868750193882847`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Insert\\\", \\\"[\\\", RowBox[{StyleBox[\
\\\"list\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"elem\\\", \\\"TI\\\"], \
\\\",\\\", StyleBox[\\\"n\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) inserts \
\\!\\(\\*StyleBox[\\\"elem\\\", \\\"TI\\\"]\\) at position \\!\\(\\*StyleBox[\
\\\"n\\\", \\\"TI\\\"]\\) in \\!\\(\\*StyleBox[\\\"list\\\", \\\"TI\\\"]\\). \
If \\!\\(\\*StyleBox[\\\"n\\\", \\\"TI\\\"]\\) is negative, the position is \
counted from the end. \\n\\!\\(\\*RowBox[{\\\"Insert\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"elem\\\", \
\\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\
\\\"], \\\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\\) inserts \
\\!\\(\\*StyleBox[\\\"elem\\\", \\\"TI\\\"]\\) at position \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \
\\\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]\\) in \
\\!\\(\\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\\). \
\\n\\!\\(\\*RowBox[{\\\"Insert\\\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"elem\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\\) inserts \
\\!\\(\\*StyleBox[\\\"elem\\\", \\\"TI\\\"]\\) at several positions. \"\>", 
   "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.586875020553319*^9},
 CellTags->"Info3586853420-3167396"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"Insert", "[", 
   RowBox[{"k", ",", 
    RowBox[{"k", "[", 
     RowBox[{"[", "9", "]"}], "]"}], ",", "10"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.58687508755733*^9, 3.586875094562801*^9}, {
  3.5868751409764214`*^9, 3.5868751489578867`*^9}, {3.586875200096064*^9, 
  3.586875202205512*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.180651047756793`", ",", 
   "0.180651047756793`", ",", "0.270976571635189`", ",", "0.270976571635189`",
    ",", "0.361302095513585`", ",", "0.361302095513585`", ",", 
   "0.361302095513585`", ",", "0.616781257308151`", ",", "0.616781257308151`",
    ",", "0.872260419102717`", ",", "0.872260419102717`", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.586875095268358*^9, 3.586875149654573*^9}, 
   3.586875202958541*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"Insert", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "8"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5868750420802307`*^9, 3.5868750651593847`*^9}, {
  3.586875151999012*^9, 3.586875152612896*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.833333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.333333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.166666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.586875050012361*^9, 3.586875065822774*^9}, 
   3.586875153344124*^9, {3.586875205755582*^9, 3.58687521508208*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".005"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}},
 CellID->1009384459],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-2, 
     0}, {-1.66666666666667, 0}, {-1.33333333333333, 0}, {-0.833333333333333, 
      0}, {-0.666666666666667, 0}, {-0.333333333333333, 
      0}, {-0.166666666666667, 0}, {0, 0}, {0.333333333333333, 
     0.333333333333333}, {0.666666666666667, 0.666666666666667}, {
     1.33333333333333, 1.33333333333333}, {1.66666666666667, 
     1.66666666666667}, {2.16666666666667, 2.16666666666667}, {
     2.33333333333333, 2.33333333333333}, {2.5, 2.5}},
    SplineKnots->{
     0, 0, 0, 0, 0.180651047756793, 0.180651047756793, 0.270976571635189, 
      0.270976571635189, 0.361302095513585, 0.361302095513585, 
      0.361302095513585, 0.616781257308151, 0.616781257308151, 
      0.872260419102717, 0.872260419102717, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.005], 
    PointBox[{{-2, 
      0}, {-1.66666666666667, 0}, {-1.33333333333333, 0}, {-0.833333333333333,
        0}, {-0.666666666666667, 0}, {-0.333333333333333, 
       0}, {-0.166666666666667, 0}, {0, 0}, {0.333333333333333, 
      0.333333333333333}, {0.666666666666667, 0.666666666666667}, {
      1.33333333333333, 1.33333333333333}, {1.66666666666667, 
      1.66666666666667}, {2.16666666666667, 2.16666666666667}, {
      2.33333333333333, 2.33333333333333}, {2.5, 2.5}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-2, 0}, {-1, 0}, {-0.5, 0}, {0, 0}, {1, 1}, {2, 2}, {2.5, 
       2.5}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586874996977736*^9, 3.586875154491508*^9, 3.586875216264542*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - test of 5-point scheme - no corner set\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}, {
  3.5868785138947153`*^9, 3.586878518710402*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.322824170196248"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.177175829803752"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.182732544669305", ",", 
     "0.182732544669305", ",", "0.274098817003958", ",", "0.274098817003958", 
     ",", "0.353942892604303", ",", "0.353942892604303", ",", 
     "0.353942892604303", ",", "0.612365735562582", ",", "0.612365735562582", 
     ",", "0.87078857852086", ",", "0.87078857852086", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586878136893477*^9, 3.586878136894092*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.928476690885259", ",", "0.371390676354104"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98058067569092", ",", 
       RowBox[{"-", "0.196116135138184"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98058067569092", ",", 
       RowBox[{"-", "0.196116135138184"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.67909592130412"}], ",", "0.128361631478353"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33891248041947"}], ",", "0.267782496083893"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.833333333333333"}], ",", "0.166666666666667"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.666666666666667"}], ",", "0.133333333333333"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.317091176239546"}], ",", "0.0634182352479093"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.182908823760454"}], ",", "0.0365817647520907"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586878378351716*^9, 3.586878378355914*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.844504979692121", ",", "0.535547700280012"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.972884355885492", ",", 
       RowBox[{"-", "0.231292088220223"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.954691343755438", ",", 
       RowBox[{"-", "0.297597779155753"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186548"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.69709246326258"}], ",", "0.192090560266857"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.34895472597342"}], ",", "0.38295998057369"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.824772294876231"}], ",", "0.258341624482978"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.671950933588126"}], ",", "0.153600795999983"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.322417459527071"}], ",", "0.0446437112819174"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.131529231316577"}], ",", 
       RowBox[{"-", "0.131529231316577"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.196493027116502", ",", 
     "0.196493027116502", ",", "0.288185066988348", ",", "0.288185066988348", 
     ",", "0.416742875291653", ",", "0.416742875291653", ",", 
     "0.650045725174991", ",", "0.650045725174991", ",", "0.88334857505833", 
     ",", "0.88334857505833", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586878450158731*^9, 3.5868784501593237`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586876785609476*^9, 3.5868767876184683`*^9}}],

Cell[BoxData["14"], "Output",
 CellChangeTimes->{{3.586876788355008*^9, 3.5868767935134983`*^9}, 
   3.586876832026554*^9, 3.5868769559675503`*^9, 3.58687741086269*^9, 
   3.586878142816079*^9, 3.58687838455157*^9, 3.586878455587227*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.5868769499917517`*^9, 3.586876951255477*^9}}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{3.586876956895804*^9, 3.586877410917479*^9, 
  3.586878142822865*^9, 3.586878384556574*^9, 3.586878455594799*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9, 3.5868772114734573`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.69709246326258`"}], ",", "0.192090560266857`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.34895472597342`"}], ",", "0.38295998057369`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.824772294876231`"}], ",", "0.258341624482978`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.671950933588126`"}], ",", "0.153600795999983`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.322417459527071`"}], ",", "0.0446437112819174`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.131529231316577`"}], ",", 
     RowBox[{"-", "0.131529231316577`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5868772122675047`*^9, 3.5868774111001596`*^9, 
  3.586878142830905*^9, 3.586878384562886*^9, 3.586878455601973*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281796641926*^9, 3.586283247664104*^9, 3.586285540482194*^9, 
   3.586525204641143*^9, 3.586526142335073*^9, 3.586527496038389*^9, 
   3.5865328119334297`*^9, 3.5865418160677032`*^9, 3.5865430340674553`*^9, 
   3.586626302592072*^9, 3.5866271052208967`*^9, 3.586627424120181*^9, 
   3.586700718813528*^9, 3.5867015550680237`*^9, 3.586704097729162*^9, 
   3.586706978378162*^9, 3.5867078432227*^9, 3.5867079213074102`*^9, 
   3.586808224317224*^9, 3.586810420384132*^9, 3.586864019135633*^9, 
   3.5868644120769453`*^9, 3.586867274521298*^9, 3.586868216703465*^9, 
   3.586868527724132*^9, 3.5868748684429207`*^9, {3.586876808218535*^9, 
   3.586876858273356*^9}, 3.586876965509012*^9, 3.5868771861238527`*^9, 
   3.586877411107004*^9, 3.586878142837738*^9, 3.5868783845681353`*^9, 
   3.586878455608789*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.844504979692121`", ",", "0.535547700280012`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.972884355885492`", ",", 
     RowBox[{"-", "0.231292088220223`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.954691343755438`", ",", 
     RowBox[{"-", "0.297597779155753`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, {3.5868768104901447`*^9, 3.586876860960597*^9}, 
   3.5868769673214197`*^9, 3.5868771882849827`*^9, 3.5868774112736588`*^9, 
   3.586878142850068*^9, 3.586878384613902*^9, 3.5868784556512117`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.5868646089756613`*^9, 3.5868646104613237`*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{
  3.58686461112786*^9, 3.5868672745755796`*^9, 3.586868216716403*^9, 
   3.586868527782716*^9, 3.586874868455041*^9, {3.586876812795732*^9, 
   3.586876832109372*^9}, 3.5868768630785027`*^9, 3.5868769681274347`*^9, 
   3.5868771886060762`*^9, 3.586877411280613*^9, 3.5868781428933067`*^9, 
   3.586878384617434*^9, 3.5868784556553698`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586876891834058*^9, 3.586876892832652*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.69709246326258`"}], ",", "0.192090560266857`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.34895472597342`"}], ",", "0.38295998057369`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.824772294876231`"}], ",", "0.258341624482978`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.671950933588126`"}], ",", "0.153600795999983`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.322417459527071`"}], ",", "0.0446437112819174`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.131529231316577`"}], ",", 
     RowBox[{"-", "0.131529231316577`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586876909226202*^9, 3.586876969553917*^9, 
  3.586877189453294*^9, 3.5868774112875957`*^9, 3.586878142897709*^9, 
  3.586878384621073*^9, 3.586878455659762*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{3.586869397031418*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.196493027116502`", ",", 
   "0.196493027116502`", ",", "0.288185066988348`", ",", "0.288185066988348`",
    ",", "0.416742875291653`", ",", "0.416742875291653`", ",", 
   "0.650045725174991`", ",", "0.650045725174991`", ",", "0.88334857505833`", 
   ",", "0.88334857505833`", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.586869397675445*^9, 3.586874868459323*^9, {3.5868768139081573`*^9, 
   3.5868768321495333`*^9}, 3.586876864588814*^9, 3.586876970538651*^9, 
   3.5868771902676888`*^9, 3.586877411295053*^9, 3.5868781429034986`*^9, 
   3.586878384626669*^9, 3.58687845566446*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.5868769722389402`*^9, 3.586876977495442*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586876978117774*^9, 3.586877191019758*^9, 
  3.586877411345031*^9, 3.586878142908986*^9, 3.5868783846313*^9, 
  3.586878455668736*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".005"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}},
 CellID->1369852157],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-2, 0}, {-1.69709246326258, 
     0.192090560266857}, {-1.34895472597342, 
     0.38295998057369}, {-0.824772294876231, 
     0.258341624482978}, {-0.671950933588126, 
     0.153600795999983}, {-0.322417459527071, 
     0.0446437112819174}, {-0.131529231316577, -0.131529231316577}, {
     0.333333333333333, 0.333333333333333}, {0.666666666666667, 
     0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
     1.66666666666667, 1.66666666666667}, {2.16666666666667, 
     2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}},
    SplineKnots->{
     0, 0, 0, 0, 0.196493027116502, 0.196493027116502, 0.288185066988348, 
      0.288185066988348, 0.416742875291653, 0.416742875291653, 
      0.650045725174991, 0.650045725174991, 0.88334857505833, 
      0.88334857505833, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.005], 
    PointBox[{{-2, 0}, {-1.69709246326258, 
      0.192090560266857}, {-1.34895472597342, 
      0.38295998057369}, {-0.824772294876231, 
      0.258341624482978}, {-0.671950933588126, 
      0.153600795999983}, {-0.322417459527071, 
      0.0446437112819174}, {-0.131529231316577, -0.131529231316577}, {
      0.333333333333333, 0.333333333333333}, {0.666666666666667, 
      0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
      1.66666666666667, 1.66666666666667}, {2.16666666666667, 
      2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-2, 0}, {-1, 0.3}, {-0.5, 0.1}, {0, 0}, {1, 1}, {2, 2}, {2.5, 
       2.5}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9, 3.58687814300249*^9, 
   3.5868783847937193`*^9, 3.586878455756534*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5`"}], ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9, 3.586874868826749*^9, 3.586876832363161*^9, 
  3.5868774116749353`*^9, 3.586878143010902*^9, 3.5868783848014*^9, 
  3.5868784557648773`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - test of 5-point scheme - corner set\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
  3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
  3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
  3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
  3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}, {
  3.5868785138947153`*^9, 3.58687853012568*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.908445641152575", ",", "0.418003010839501"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.989400395497483", ",", "0.145213144685405"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.99745754815076", ",", 
       RowBox[{"-", "0.0712631716742551"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186548"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.68277526380111"}], ",", "0.145964589224805"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.34549373703698"}], ",", "0.249292286264929"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66943816060417"}], ",", "0.348516176494476"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33325375988978"}], ",", "0.323809253783427"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.606736916226271"}], ",", "0.271903391072561"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.396439740970557"}], ",", "0.113445748741367"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.165482544484322", ",", 
     "0.165482544484322", ",", "0.323617317592562", ",", "0.323617317592562", 
     ",", "0.447141621415994", ",", "0.447141621415994", ",", 
     "0.447141621415994", ",", "0.668284972849596", ",", "0.668284972849596", 
     ",", "0.889428324283199", ",", "0.889428324283199", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586879066262567*^9, 3.5868790662632*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.908445641152575", ",", "0.418003010839501"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.989400395497483", ",", "0.145213144685405"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.99745754815076", ",", 
       RowBox[{"-", "0.0712631716742551"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186548"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.68277526380111"}], ",", "0.145964589224805"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.34549373703698"}], ",", "0.249292286264929"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.66943816060417"}], ",", "0.348516176494476"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.33325375988978"}], ",", "0.323809253783427"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.606736916226271"}], ",", "0.271903391072561"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.396439740970557"}], ",", "0.113445748741367"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.165482544484322", ",", 
     "0.165482544484322", ",", "0.323617317592562", ",", "0.323617317592562", 
     ",", "0.447141621415994", ",", "0.447141621415994", ",", 
     "0.447141621415994", ",", "0.668284972849596", ",", "0.668284972849596", 
     ",", "0.889428324283199", ",", "0.889428324283199", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.586879176209868*^9, 3.5868791762104*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586876785609476*^9, 3.5868767876184683`*^9}}],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{{3.586876788355008*^9, 3.5868767935134983`*^9}, 
   3.586876832026554*^9, 3.5868769559675503`*^9, 3.58687741086269*^9, 
   3.586878142816079*^9, 3.58687838455157*^9, 3.586878455587227*^9, 
   3.586878869123077*^9, 3.586879069266692*^9, 3.5868791807333612`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.5868769499917517`*^9, 3.586876951255477*^9}}],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{3.586876956895804*^9, 3.586877410917479*^9, 
  3.586878142822865*^9, 3.586878384556574*^9, 3.586878455594799*^9, 
  3.58687886917178*^9, 3.586879069319459*^9, 3.586879180782549*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9, 3.5868772114734573`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.68277526380111`"}], ",", "0.145964589224805`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.34549373703698`"}], ",", "0.249292286264929`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66943816060417`"}], ",", "0.348516176494476`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33325375988978`"}], ",", "0.323809253783427`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.606736916226271`"}], ",", "0.271903391072561`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.396439740970557`"}], ",", "0.113445748741367`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5868772122675047`*^9, 3.5868774111001596`*^9, 
  3.586878142830905*^9, 3.586878384562886*^9, 3.586878455601973*^9, 
  3.586878869179038*^9, 3.58687906932777*^9, 3.58687918078786*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281796641926*^9, 3.586283247664104*^9, 3.586285540482194*^9, 
   3.586525204641143*^9, 3.586526142335073*^9, 3.586527496038389*^9, 
   3.5865328119334297`*^9, 3.5865418160677032`*^9, 3.5865430340674553`*^9, 
   3.586626302592072*^9, 3.5866271052208967`*^9, 3.586627424120181*^9, 
   3.586700718813528*^9, 3.5867015550680237`*^9, 3.586704097729162*^9, 
   3.586706978378162*^9, 3.5867078432227*^9, 3.5867079213074102`*^9, 
   3.586808224317224*^9, 3.586810420384132*^9, 3.586864019135633*^9, 
   3.5868644120769453`*^9, 3.586867274521298*^9, 3.586868216703465*^9, 
   3.586868527724132*^9, 3.5868748684429207`*^9, {3.586876808218535*^9, 
   3.586876858273356*^9}, 3.586876965509012*^9, 3.5868771861238527`*^9, 
   3.586877411107004*^9, 3.586878142837738*^9, 3.5868783845681353`*^9, 
   3.586878455608789*^9, 3.586878869185775*^9, 3.5868790693346443`*^9, 
   3.586879180792405*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.908445641152575`", ",", "0.418003010839501`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989400395497483`", ",", "0.145213144685405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.99745754815076`", ",", 
     RowBox[{"-", "0.0712631716742551`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, {3.5868768104901447`*^9, 3.586876860960597*^9}, 
   3.5868769673214197`*^9, 3.5868771882849827`*^9, 3.5868774112736588`*^9, 
   3.586878142850068*^9, 3.586878384613902*^9, 3.5868784556512117`*^9, 
   3.586878869198194*^9, 3.58687906934734*^9, 3.586879180852545*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.5868646089756613`*^9, 3.5868646104613237`*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{
  3.58686461112786*^9, 3.5868672745755796`*^9, 3.586868216716403*^9, 
   3.586868527782716*^9, 3.586874868455041*^9, {3.586876812795732*^9, 
   3.586876832109372*^9}, 3.5868768630785027`*^9, 3.5868769681274347`*^9, 
   3.5868771886060762`*^9, 3.586877411280613*^9, 3.5868781428933067`*^9, 
   3.586878384617434*^9, 3.5868784556553698`*^9, 3.586878869204832*^9, 
   3.586879069354094*^9, 3.586879180857214*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586876891834058*^9, 3.586876892832652*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.68277526380111`"}], ",", "0.145964589224805`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.34549373703698`"}], ",", "0.249292286264929`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.66943816060417`"}], ",", "0.348516176494476`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.33325375988978`"}], ",", "0.323809253783427`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.606736916226271`"}], ",", "0.271903391072561`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.396439740970557`"}], ",", "0.113445748741367`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586876909226202*^9, 3.586876969553917*^9, 
  3.586877189453294*^9, 3.5868774112875957`*^9, 3.586878142897709*^9, 
  3.586878384621073*^9, 3.586878455659762*^9, 3.58687886927958*^9, 
  3.586879069406913*^9, 3.5868791808622704`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{3.586869397031418*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.165482544484322`", ",", 
   "0.165482544484322`", ",", "0.323617317592562`", ",", "0.323617317592562`",
    ",", "0.447141621415994`", ",", "0.447141621415994`", ",", 
   "0.447141621415994`", ",", "0.668284972849596`", ",", "0.668284972849596`",
    ",", "0.889428324283199`", ",", "0.889428324283199`", ",", "1", ",", "1", 
   ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.586869397675445*^9, 3.586874868459323*^9, {3.5868768139081573`*^9, 
   3.5868768321495333`*^9}, 3.586876864588814*^9, 3.586876970538651*^9, 
   3.5868771902676888`*^9, 3.586877411295053*^9, 3.5868781429034986`*^9, 
   3.586878384626669*^9, 3.58687845566446*^9, 3.586878869287533*^9, 
   3.586879069430333*^9, 3.586879180868188*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.5868769722389402`*^9, 3.586876977495442*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586876978117774*^9, 3.586877191019758*^9, 
  3.586877411345031*^9, 3.586878142908986*^9, 3.5868783846313*^9, 
  3.586878455668736*^9, 3.586878869294591*^9, 3.5868790694371758`*^9, 
  3.586879180962388*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{3.586879216556999*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.908445641152575`", ",", "0.418003010839501`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989400395497483`", ",", "0.145213144685405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.99745754815076`", ",", 
     RowBox[{"-", "0.0712631716742551`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586879217237865*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".005"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}},
 CellID->1620628713],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-3, 0}, {-2.68277526380111, 
     0.145964589224805}, {-2.34549373703698, 
     0.249292286264929}, {-1.66943816060417, 
     0.348516176494476}, {-1.33325375988978, 
     0.323809253783427}, {-0.606736916226271, 
     0.271903391072561}, {-0.396439740970557, 0.113445748741367}, {0, 0}, {
     0.333333333333333, 0.333333333333333}, {0.666666666666667, 
     0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
     1.66666666666667, 1.66666666666667}, {2.16666666666667, 
     2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}},
    SplineKnots->{
     0, 0, 0, 0, 0.165482544484322, 0.165482544484322, 0.323617317592562, 
      0.323617317592562, 0.447141621415994, 0.447141621415994, 
      0.447141621415994, 0.668284972849596, 0.668284972849596, 
      0.889428324283199, 0.889428324283199, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.005], 
    PointBox[{{-3, 0}, {-2.68277526380111, 
      0.145964589224805}, {-2.34549373703698, 
      0.249292286264929}, {-1.66943816060417, 
      0.348516176494476}, {-1.33325375988978, 
      0.323809253783427}, {-0.606736916226271, 
      0.271903391072561}, {-0.396439740970557, 0.113445748741367}, {0, 0}, {
      0.333333333333333, 0.333333333333333}, {0.666666666666667, 
      0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
      1.66666666666667, 1.66666666666667}, {2.16666666666667, 
      2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-3, 0}, {-2, 0.3}, {-1, 0.3}, {0, 0}, {1, 1}, {2, 2}, {2.5, 
       2.5}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9, 3.58687814300249*^9, 
   3.5868783847937193`*^9, 3.586878455756534*^9, 3.586878869436592*^9, 
   3.586879069495915*^9, 3.5868791810291233`*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9, 3.586874868826749*^9, 3.586876832363161*^9, 
  3.5868774116749353`*^9, 3.586878143010902*^9, 3.5868783848014*^9, 
  3.5868784557648773`*^9, 3.586878869444745*^9, 3.586879069503792*^9, 
  3.586879181173381*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - test of 3-point scheme - corner set\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
   3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
   3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
   3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
   3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}, {
   3.5868785138947153`*^9, 3.58687853012568*^9}, 3.5868793574449987`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.907226137831277", ",", "0.420643239379578"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.989854548681455", ",", "0.142084384978199"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.989854548681455", ",", 
       RowBox[{"-", "0.142084384978199"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186548"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.68315480680001"}], ",", "0.146908012117129"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.34570284368857"}], ",", "0.25037758224566"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6689288617341"}], ",", "0.347522172956828"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3310711382659"}], ",", "0.347522172956828"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.612106556657538"}], ",", "0.244321515309694"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.387893443342462"}], ",", "0.167035454070917"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.333333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.666666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.33333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.66666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.16666666666667", ",", "2.16666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.33333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.167557918258911", ",", 
     "0.167557918258911", ",", "0.327947084128554", ",", "0.327947084128554", 
     ",", "0.440532414793457", ",", "0.440532414793457", ",", 
     "0.440532414793457", ",", "0.664319448876074", ",", "0.664319448876074", 
     ",", "0.888106482958691", ",", "0.888106482958691", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.586879744779161*^9, 3.58687974477958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586876785609476*^9, 3.5868767876184683`*^9}}],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{{3.586876788355008*^9, 3.5868767935134983`*^9}, 
   3.586876832026554*^9, 3.5868769559675503`*^9, 3.58687741086269*^9, 
   3.586878142816079*^9, 3.58687838455157*^9, 3.586878455587227*^9, 
   3.586878869123077*^9, 3.586879069266692*^9, 3.5868791807333612`*^9, 
   3.5868794197667217`*^9, 3.5868797484360237`*^9, 3.587315577395688*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.5868769499917517`*^9, 3.586876951255477*^9}}],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{3.586876956895804*^9, 3.586877410917479*^9, 
  3.586878142822865*^9, 3.586878384556574*^9, 3.586878455594799*^9, 
  3.58687886917178*^9, 3.586879069319459*^9, 3.586879180782549*^9, 
  3.586879419771716*^9, 3.586879748508635*^9, 3.587315577439587*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9, 3.5868772114734573`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.68315480680001`"}], ",", "0.146908012117129`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.34570284368857`"}], ",", "0.25037758224566`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.6689288617341`"}], ",", "0.347522172956828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3310711382659`"}], ",", "0.347522172956828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.612106556657538`"}], ",", "0.244321515309694`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.387893443342462`"}], ",", "0.167035454070917`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5868772122675047`*^9, 3.5868774111001596`*^9, 
  3.586878142830905*^9, 3.586878384562886*^9, 3.586878455601973*^9, 
  3.586878869179038*^9, 3.58687906932777*^9, 3.58687918078786*^9, 
  3.586879419778132*^9, 3.586879748515833*^9, 3.5873155775026712`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281796641926*^9, 3.586283247664104*^9, 3.586285540482194*^9, 
   3.586525204641143*^9, 3.586526142335073*^9, 3.586527496038389*^9, 
   3.5865328119334297`*^9, 3.5865418160677032`*^9, 3.5865430340674553`*^9, 
   3.586626302592072*^9, 3.5866271052208967`*^9, 3.586627424120181*^9, 
   3.586700718813528*^9, 3.5867015550680237`*^9, 3.586704097729162*^9, 
   3.586706978378162*^9, 3.5867078432227*^9, 3.5867079213074102`*^9, 
   3.586808224317224*^9, 3.586810420384132*^9, 3.586864019135633*^9, 
   3.5868644120769453`*^9, 3.586867274521298*^9, 3.586868216703465*^9, 
   3.586868527724132*^9, 3.5868748684429207`*^9, {3.586876808218535*^9, 
   3.586876858273356*^9}, 3.586876965509012*^9, 3.5868771861238527`*^9, 
   3.586877411107004*^9, 3.586878142837738*^9, 3.5868783845681353`*^9, 
   3.586878455608789*^9, 3.586878869185775*^9, 3.5868790693346443`*^9, 
   3.586879180792405*^9, 3.586879419783606*^9, 3.586879748523509*^9, 
   3.587315577511174*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.907226137831277`", ",", "0.420643239379578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989854548681455`", ",", "0.142084384978199`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989854548681455`", ",", 
     RowBox[{"-", "0.142084384978199`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, {3.5868768104901447`*^9, 3.586876860960597*^9}, 
   3.5868769673214197`*^9, 3.5868771882849827`*^9, 3.5868774112736588`*^9, 
   3.586878142850068*^9, 3.586878384613902*^9, 3.5868784556512117`*^9, 
   3.586878869198194*^9, 3.58687906934734*^9, 3.586879180852545*^9, 
   3.586879419833178*^9, 3.586879748535696*^9, 3.587315577519547*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.5868646089756613`*^9, 3.5868646104613237`*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{
  3.58686461112786*^9, 3.5868672745755796`*^9, 3.586868216716403*^9, 
   3.586868527782716*^9, 3.586874868455041*^9, {3.586876812795732*^9, 
   3.586876832109372*^9}, 3.5868768630785027`*^9, 3.5868769681274347`*^9, 
   3.5868771886060762`*^9, 3.586877411280613*^9, 3.5868781428933067`*^9, 
   3.586878384617434*^9, 3.5868784556553698`*^9, 3.586878869204832*^9, 
   3.586879069354094*^9, 3.586879180857214*^9, 3.586879419837572*^9, 
   3.586879748606916*^9, 3.587315577525939*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586876891834058*^9, 3.586876892832652*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.68315480680001`"}], ",", "0.146908012117129`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.34570284368857`"}], ",", "0.25037758224566`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.6689288617341`"}], ",", "0.347522172956828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3310711382659`"}], ",", "0.347522172956828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.612106556657538`"}], ",", "0.244321515309694`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.387893443342462`"}], ",", "0.167035454070917`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.333333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.666666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.16666666666667`", ",", "2.16666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.33333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586876909226202*^9, 3.586876969553917*^9, 
  3.586877189453294*^9, 3.5868774112875957`*^9, 3.586878142897709*^9, 
  3.586878384621073*^9, 3.586878455659762*^9, 3.58687886927958*^9, 
  3.586879069406913*^9, 3.5868791808622704`*^9, 3.586879419843709*^9, 
  3.5868797486168423`*^9, 3.587315577567802*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{3.586869397031418*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.167557918258911`", ",", 
   "0.167557918258911`", ",", "0.327947084128554`", ",", "0.327947084128554`",
    ",", "0.440532414793457`", ",", "0.440532414793457`", ",", 
   "0.440532414793457`", ",", "0.664319448876074`", ",", "0.664319448876074`",
    ",", "0.888106482958691`", ",", "0.888106482958691`", ",", "1", ",", "1", 
   ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.586869397675445*^9, 3.586874868459323*^9, {3.5868768139081573`*^9, 
   3.5868768321495333`*^9}, 3.586876864588814*^9, 3.586876970538651*^9, 
   3.5868771902676888`*^9, 3.586877411295053*^9, 3.5868781429034986`*^9, 
   3.586878384626669*^9, 3.58687845566446*^9, 3.586878869287533*^9, 
   3.586879069430333*^9, 3.586879180868188*^9, 3.586879419851885*^9, 
   3.586879748624404*^9, 3.587315577572546*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.5868769722389402`*^9, 3.586876977495442*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586876978117774*^9, 3.586877191019758*^9, 
  3.586877411345031*^9, 3.586878142908986*^9, 3.5868783846313*^9, 
  3.586878455668736*^9, 3.586878869294591*^9, 3.5868790694371758`*^9, 
  3.586879180962388*^9, 3.586879419858942*^9, 3.58687974863013*^9, 
  3.5873155775769167`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{3.586879216556999*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.907226137831277`", ",", "0.420643239379578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989854548681455`", ",", "0.142084384978199`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.989854548681455`", ",", 
     RowBox[{"-", "0.142084384978199`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586879217237865*^9, 3.5868794199422493`*^9, 
  3.5868797487131042`*^9, 3.5873155775817432`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".01"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}, {
   3.58687976234692*^9, 3.58687977745163*^9}},
 CellID->1156784570],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-3, 0}, {-2.68315480680001, 
     0.146908012117129}, {-2.34570284368857, 
     0.25037758224566}, {-1.6689288617341, 
     0.347522172956828}, {-1.3310711382659, 
     0.347522172956828}, {-0.612106556657538, 
     0.244321515309694}, {-0.387893443342462, 0.167035454070917}, {0, 0}, {
     0.333333333333333, 0.333333333333333}, {0.666666666666667, 
     0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
     1.66666666666667, 1.66666666666667}, {2.16666666666667, 
     2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}},
    SplineKnots->{
     0, 0, 0, 0, 0.167557918258911, 0.167557918258911, 0.327947084128554, 
      0.327947084128554, 0.440532414793457, 0.440532414793457, 
      0.440532414793457, 0.664319448876074, 0.664319448876074, 
      0.888106482958691, 0.888106482958691, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.01], 
    PointBox[{{-3, 0}, {-2.68315480680001, 
      0.146908012117129}, {-2.34570284368857, 
      0.25037758224566}, {-1.6689288617341, 
      0.347522172956828}, {-1.3310711382659, 
      0.347522172956828}, {-0.612106556657538, 
      0.244321515309694}, {-0.387893443342462, 0.167035454070917}, {0, 0}, {
      0.333333333333333, 0.333333333333333}, {0.666666666666667, 
      0.666666666666667}, {1.33333333333333, 1.33333333333333}, {
      1.66666666666667, 1.66666666666667}, {2.16666666666667, 
      2.16666666666667}, {2.33333333333333, 2.33333333333333}, {2.5, 2.5}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-3, 0}, {-2, 0.3}, {-1, 0.3}, {0, 0}, {1, 1}, {2, 2}, {2.5, 
       2.5}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9, 3.58687814300249*^9, 
   3.5868783847937193`*^9, 3.586878455756534*^9, 3.586878869436592*^9, 
   3.586879069495915*^9, 3.5868791810291233`*^9, 3.586879420184026*^9, {
   3.586879748873714*^9, 3.586879777971246*^9}, 3.58731557766488*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9, 3.586874868826749*^9, 3.586876832363161*^9, 
  3.5868774116749353`*^9, 3.586878143010902*^9, 3.5868783848014*^9, 
  3.5868784557648773`*^9, 3.586878869444745*^9, 3.586879069503792*^9, 
  3.586879181173381*^9, 3.586879420192492*^9, 3.5868797488814793`*^9, 
  3.587315577675068*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
example - test 2 of 3-point scheme - corner set\
\>", "Subsection",
 CellChangeTimes->{{3.586525100291893*^9, 3.586525105863394*^9}, {
   3.586541747946124*^9, 3.5865417513765173`*^9}, {3.58662594402516*^9, 
   3.5866259490083857`*^9}, {3.586700674678631*^9, 3.5867006758854303`*^9}, {
   3.586704065087125*^9, 3.586704068326476*^9}, {3.586706973483066*^9, 
   3.5867069744719343`*^9}, {3.5868081889437532`*^9, 3.586808194526154*^9}, {
   3.5868785138947153`*^9, 3.58687853012568*^9}, 3.5868793574449987`*^9, {
   3.587315035670657*^9, 3.5873150361099863`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.2"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", 
       RowBox[{"-", "0.707106781186548"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", 
       RowBox[{"-", "0.707106781186547"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", 
       RowBox[{"-", "0.707106781186547"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186548", ",", "0.707106781186547"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.707106781186547", ",", "0.707106781186548"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.2"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.86666666666667"}], ",", "2.66666666666667"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.53333333333333"}], ",", "2.33333333333333"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.86666666666667"}], ",", "1.66666666666667"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.53333333333333"}], ",", "1.33333333333333"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.845648340392495"}], ",", "0.645648340392495"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.554351659607505"}], ",", "0.354351659607505"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.133333333333333"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0666666666666667"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0708703319215009", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.129129668078499", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.533333333333333", ",", "0.333333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.866666666666667", ",", "0.666666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.53333333333333", ",", "1.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.86666666666667", ",", "1.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.53333333333333", ",", "2.33333333333333"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.86666666666667", ",", "2.66666666666667"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0.162895682824115", ",", 
     "0.162895682824115", ",", "0.325791365648229", ",", "0.325791365648229", 
     ",", "0.468144280810837", ",", "0.468144280810837", ",", 
     "0.468144280810837", ",", "0.491181209201026", ",", "0.491181209201026", 
     ",", "0.511312951527656", ",", "0.511312951527656", ",", 
     "0.511312951527656", ",", "0.674208634351771", ",", "0.674208634351771", 
     ",", "0.837104317175885", ",", "0.837104317175885", ",", "1", ",", "1", 
     ",", "1"}], "}"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.587319394549952*^9, 3.587319394550487*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "CV", "]"}]], "Input",
 CellChangeTimes->{{3.586876785609476*^9, 3.5868767876184683`*^9}}],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{{3.586876788355008*^9, 3.5868767935134983`*^9}, 
   3.586876832026554*^9, 3.5868769559675503`*^9, 3.58687741086269*^9, 
   3.586878142816079*^9, 3.58687838455157*^9, 3.586878455587227*^9, 
   3.586878869123077*^9, 3.586879069266692*^9, 3.5868791807333612`*^9, 
   3.5868794197667217`*^9, 3.5868797484360237`*^9, 3.587315469472311*^9, 
   3.587315547459548*^9, 3.587315865915452*^9, 3.5873164736360817`*^9, 
   3.5873169672980947`*^9, 3.587317050266205*^9, 3.5873174547299137`*^9, 
   3.587317591303694*^9, 3.587318473780863*^9, 3.58731924168055*^9, 
   3.5873193032490892`*^9, 3.5873193977908697`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "U", "]"}]], "Input",
 CellChangeTimes->{{3.5868769499917517`*^9, 3.586876951255477*^9}}],

Cell[BoxData["22"], "Output",
 CellChangeTimes->{3.586876956895804*^9, 3.586877410917479*^9, 
  3.586878142822865*^9, 3.586878384556574*^9, 3.586878455594799*^9, 
  3.58687886917178*^9, 3.586879069319459*^9, 3.586879180782549*^9, 
  3.586879419771716*^9, 3.586879748508635*^9, 3.587315469521962*^9, 
  3.587315547505925*^9, 3.58731586596623*^9, 3.58731647368924*^9, 
  3.587316967347247*^9, 3.587317050353846*^9, 3.587317454867591*^9, 
  3.587317591345393*^9, 3.587318473784458*^9, 3.587319241749823*^9, 
  3.587319303321542*^9, 3.587319397839403*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", "CV"}]], "Input",
 CellChangeTimes->{{3.5865418082922297`*^9, 3.586541810746326*^9}, 
   3.586627420738859*^9, 3.5868772114734573`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.2`"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.86666666666667`"}], ",", "2.66666666666667`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.53333333333333`"}], ",", "2.33333333333333`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.86666666666667`"}], ",", "1.66666666666667`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.53333333333333`"}], ",", "1.33333333333333`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.845648340392495`"}], ",", "0.645648340392495`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.554351659607505`"}], ",", "0.354351659607505`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.133333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0708703319215009`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.129129668078499`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.533333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.866666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.53333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.86666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.86666666666667`", ",", "2.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2`", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5868772122675047`*^9, 3.5868774111001596`*^9, 
  3.586878142830905*^9, 3.586878384562886*^9, 3.586878455601973*^9, 
  3.586878869179038*^9, 3.58687906932777*^9, 3.58687918078786*^9, 
  3.586879419778132*^9, 3.586879748515833*^9, 3.587315469530156*^9, 
  3.58731554751162*^9, 3.5873158659719887`*^9, 3.587316473695258*^9, 
  3.587316967352632*^9, 3.587317050362378*^9, 3.58731745487259*^9, 
  3.5873175914293118`*^9, 3.587318473789063*^9, 3.587319241754624*^9, 
  3.587319303327053*^9, 3.587319397844545*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", "4"}]], "Input",
 CellChangeTimes->{{3.586281762937381*^9, 3.586281764898184*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.586281796641926*^9, 3.586283247664104*^9, 3.586285540482194*^9, 
   3.586525204641143*^9, 3.586526142335073*^9, 3.586527496038389*^9, 
   3.5865328119334297`*^9, 3.5865418160677032`*^9, 3.5865430340674553`*^9, 
   3.586626302592072*^9, 3.5866271052208967`*^9, 3.586627424120181*^9, 
   3.586700718813528*^9, 3.5867015550680237`*^9, 3.586704097729162*^9, 
   3.586706978378162*^9, 3.5867078432227*^9, 3.5867079213074102`*^9, 
   3.586808224317224*^9, 3.586810420384132*^9, 3.586864019135633*^9, 
   3.5868644120769453`*^9, 3.586867274521298*^9, 3.586868216703465*^9, 
   3.586868527724132*^9, 3.5868748684429207`*^9, {3.586876808218535*^9, 
   3.586876858273356*^9}, 3.586876965509012*^9, 3.5868771861238527`*^9, 
   3.586877411107004*^9, 3.586878142837738*^9, 3.5868783845681353`*^9, 
   3.586878455608789*^9, 3.586878869185775*^9, 3.5868790693346443`*^9, 
   3.586879180792405*^9, 3.586879419783606*^9, 3.586879748523509*^9, 
   3.587315469536697*^9, 3.587315547518215*^9, 3.58731586597716*^9, 
   3.587316473700019*^9, 3.587316967359008*^9, 3.5873170503696003`*^9, 
   3.587317454876243*^9, 3.587317591435169*^9, 3.587318473792653*^9, 
   3.587319241758687*^9, 3.587319303333547*^9, 3.587319397848372*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "U", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.586281875054612*^9, 3.586281886802696*^9}, {
   3.586285553484454*^9, 3.586285559749362*^9}, 3.586525194313278*^9, {
   3.586541823883449*^9, 3.5865418394783163`*^9}, 3.5867006882590017`*^9}],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{{3.586864594184272*^9, 3.586864614134263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", 
     RowBox[{"-", "0.707106781186548`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.586864595737678*^9, 3.586864614689238*^9}, 
   3.586867274533821*^9, 3.586868216711719*^9, 3.586868527775875*^9, 
   3.5868748684505157`*^9, {3.5868768104901447`*^9, 3.586876860960597*^9}, 
   3.5868769673214197`*^9, 3.5868771882849827`*^9, 3.5868774112736588`*^9, 
   3.586878142850068*^9, 3.586878384613902*^9, 3.5868784556512117`*^9, 
   3.586878869198194*^9, 3.58687906934734*^9, 3.586879180852545*^9, 
   3.586879419833178*^9, 3.586879748535696*^9, 3.5873154695487137`*^9, 
   3.587315547530533*^9, 3.5873158659870253`*^9, 3.587316473708992*^9, 
   3.5873169673654633`*^9, 3.587317050382025*^9, 3.5873174548826723`*^9, 
   3.587317591445429*^9, 3.5873184737991943`*^9, 3.587319241766013*^9, 
   3.587319303346407*^9, 3.587319397855596*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.5868646089756613`*^9, 3.5868646104613237`*^9}, 
   3.587316614495743*^9}],

Cell[BoxData["9"], "Output",
 CellChangeTimes->{
  3.58686461112786*^9, 3.5868672745755796`*^9, 3.586868216716403*^9, 
   3.586868527782716*^9, 3.586874868455041*^9, {3.586876812795732*^9, 
   3.586876832109372*^9}, 3.5868768630785027`*^9, 3.5868769681274347`*^9, 
   3.5868771886060762`*^9, 3.586877411280613*^9, 3.5868781428933067`*^9, 
   3.586878384617434*^9, 3.5868784556553698`*^9, 3.586878869204832*^9, 
   3.586879069354094*^9, 3.586879180857214*^9, 3.586879419837572*^9, 
   3.586879748606916*^9, 3.5873154696145678`*^9, 3.587315547536976*^9, 
   3.587315865992464*^9, 3.587316473713688*^9, 3.587316615474471*^9, 
   3.5873169673693743`*^9, 3.5873170504638*^9, 3.587317454886512*^9, 
   3.587317591451364*^9, 3.5873184739310513`*^9, 3.587319241900522*^9, 
   3.587319303737528*^9, 3.587319397859454*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CV"], "Input",
 CellChangeTimes->{{3.586876891834058*^9, 3.586876892832652*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.2`"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.86666666666667`"}], ",", "2.66666666666667`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.53333333333333`"}], ",", "2.33333333333333`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.86666666666667`"}], ",", "1.66666666666667`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.53333333333333`"}], ",", "1.33333333333333`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.845648340392495`"}], ",", "0.645648340392495`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.554351659607505`"}], ",", "0.354351659607505`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.133333333333333`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0666666666666667`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0708703319215009`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.129129668078499`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.533333333333333`", ",", "0.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.866666666666667`", ",", "0.666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.53333333333333`", ",", "1.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.86666666666667`", ",", "1.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53333333333333`", ",", "2.33333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.86666666666667`", ",", "2.66666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2`", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586876909226202*^9, 3.586876969553917*^9, 
  3.586877189453294*^9, 3.5868774112875957`*^9, 3.586878142897709*^9, 
  3.586878384621073*^9, 3.586878455659762*^9, 3.58687886927958*^9, 
  3.586879069406913*^9, 3.5868791808622704`*^9, 3.586879419843709*^9, 
  3.5868797486168423`*^9, 3.587315469621634*^9, 3.587315547706223*^9, 
  3.587315866060553*^9, 3.587316473877111*^9, 3.587316967521497*^9, 
  3.5873170504733353`*^9, 3.587317455075831*^9, 3.5873175915741167`*^9, 
  3.58731847393709*^9, 3.587319241905603*^9, 3.587319303743883*^9, 
  3.5873193980075693`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["U"], "Input",
 CellChangeTimes->{3.586869397031418*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0.162895682824115`", ",", 
   "0.162895682824115`", ",", "0.325791365648229`", ",", "0.325791365648229`",
    ",", "0.468144280810837`", ",", "0.468144280810837`", ",", 
   "0.468144280810837`", ",", "0.491181209201026`", ",", "0.491181209201026`",
    ",", "0.511312951527656`", ",", "0.511312951527656`", ",", 
   "0.511312951527656`", ",", "0.674208634351771`", ",", "0.674208634351771`",
    ",", "0.837104317175885`", ",", "0.837104317175885`", ",", "1", ",", "1", 
   ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.586869397675445*^9, 3.586874868459323*^9, {3.5868768139081573`*^9, 
   3.5868768321495333`*^9}, 3.586876864588814*^9, 3.586876970538651*^9, 
   3.5868771902676888`*^9, 3.586877411295053*^9, 3.5868781429034986`*^9, 
   3.586878384626669*^9, 3.58687845566446*^9, 3.586878869287533*^9, 
   3.586879069430333*^9, 3.586879180868188*^9, 3.586879419851885*^9, 
   3.586879748624404*^9, 3.58731546962957*^9, 3.587315547716199*^9, 
   3.587315866064763*^9, 3.587316473887541*^9, 3.5873169675319242`*^9, 
   3.587317050481205*^9, 3.5873174550814734`*^9, 3.587317591582666*^9, 
   3.587318473941544*^9, 3.5873192419111643`*^9, 3.587319303748836*^9, 
   3.587319398013661*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "k", "]"}], "-", 
  RowBox[{"Length", "[", "pts", "]"}]}]], "Input",
 CellChangeTimes->{{3.5868769722389402`*^9, 3.586876977495442*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.586876978117774*^9, 3.586877191019758*^9, 
  3.586877411345031*^9, 3.586878142908986*^9, 3.5868783846313*^9, 
  3.586878455668736*^9, 3.586878869294591*^9, 3.5868790694371758`*^9, 
  3.586879180962388*^9, 3.586879419858942*^9, 3.58687974863013*^9, 
  3.587315469636632*^9, 3.587315547723302*^9, 3.587315866068535*^9, 
  3.587316473894765*^9, 3.5873169675393047`*^9, 3.587317050488391*^9, 
  3.5873174550855627`*^9, 3.5873175915886927`*^9, 3.587318473945713*^9, 
  3.587319241914949*^9, 3.587319303978381*^9, 3.5873193980178347`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{3.586879216556999*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", 
     RowBox[{"-", "0.707106781186548`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.586879217237865*^9, 3.5868794199422493`*^9, 
  3.5868797487131042`*^9, 3.587315469643443*^9, 3.58731554773028*^9, 
  3.5873158660738907`*^9, 3.5873164739018517`*^9, 3.58731696754642*^9, 
  3.587317050649205*^9, 3.5873174550893373`*^9, 3.587317591594379*^9, 
  3.5873184739499702`*^9, 3.587319242046185*^9, 3.5873193039834023`*^9, 
  3.587319398021813*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Arrow"}]], "Input",
 CellChangeTimes->{{3.587316627691822*^9, 3.5873166284907417`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Arrow\\\", \\\"[\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \\\
\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}], \\\"]\\\"}]\) is a graphics \
primitive which represents an arrow from \!\(\*SubscriptBox[StyleBox[\\\"pt\\\
\", \\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]]\) to \
\!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]\).\\n\!\(\*RowBox[{\\\"Arrow\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\
\"], StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"s\\\", \\\"TI\\\"]}], \\\
\"]\\\"}]\) represents an arrow with its ends set back from \
\!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]\) and \!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]\) by a distance \!\(\*StyleBox[\\\"s\\\", \\\
\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Arrow\\\", \\\"[\\\", RowBox[{RowBox[{\\\"{\
\\\", RowBox[{SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\
\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"s\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"s\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) \
sets back by \!\(\*SubscriptBox[StyleBox[\\\"s\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]]\) from \
\!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]\) and \!\(\*SubscriptBox[StyleBox[\\\"s\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]]\) from \
\!\(\*SubscriptBox[StyleBox[\\\"pt\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]\). \\n\!\(\*RowBox[{\\\"Arrow\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"curve\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) represents an arrow following \
the specified \!\(\*StyleBox[\\\"curve\\\", \\\"TI\\\"]\).\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrow"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.587319398206171*^9},
 CellTags->"Info3587297798-3801113"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"#1", ",", 
       RowBox[{"#1", "+", 
        RowBox[{"0.2", "#2"}]}]}], "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"Q", ",", "T"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.587316668516177*^9, 3.587316732581798*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.2`"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.058578643762691`"}], ",", "2.8585786437626903`"}], 
       "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.2`"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0585786437626905`"}], ",", "1.8585786437626906`"}], 
       "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2`"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.0585786437626903`"}], ",", "0.8585786437626906`"}], 
       "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2`"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.2`", ",", "0.`"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.2`", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.3414213562373094`", ",", "0.14142135623730942`"}], "}"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.2`", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.3414213562373096`", ",", "1.1414213562373094`"}], "}"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2.2`", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.34142135623731`", ",", "2.1414213562373092`"}], "}"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3.2`", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.3414213562373094`", ",", "3.1414213562373097`"}], "}"}]}], 
     "}"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.587316718119234*^9, 3.587316733643841*^9}, 
   3.5873169679975653`*^9, 3.587317051119402*^9, 3.587317455524708*^9, 
   3.587317592187975*^9, 3.5873184744576397`*^9, 3.5873192426742697`*^9, 
   3.587319304496234*^9, 3.587319398519452*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".01"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}], ",", "Blue", ",", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"#1", ",", 
          RowBox[{"#1", "+", 
           RowBox[{"0.2", "#2"}]}]}], "}"}], "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "T"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}, {
   3.58687976234692*^9, 3.58687977745163*^9}, {3.587316744537133*^9, 
   3.587316748103191*^9}},
 CellID->1213197440],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-3.2, 3}, {-2.86666666666667, 
     2.66666666666667}, {-2.53333333333333, 
     2.33333333333333}, {-1.86666666666667, 
     1.66666666666667}, {-1.53333333333333, 
     1.33333333333333}, {-0.845648340392495, 
     0.645648340392495}, {-0.554351659607505, 
     0.354351659607505}, {-0.2, 0}, {-0.133333333333333, 
      0}, {-0.0666666666666667, 0}, {0.0708703319215009, 0}, {
     0.129129668078499, 0}, {0.2, 0}, {0.533333333333333, 
     0.333333333333333}, {0.866666666666667, 0.666666666666667}, {
     1.53333333333333, 1.33333333333333}, {1.86666666666667, 
     1.66666666666667}, {2.53333333333333, 2.33333333333333}, {
     2.86666666666667, 2.66666666666667}, {3.2, 3}},
    SplineKnots->{
     0, 0, 0, 0, 0.162895682824115, 0.162895682824115, 0.325791365648229, 
      0.325791365648229, 0.468144280810837, 0.468144280810837, 
      0.468144280810837, 0.491181209201026, 0.491181209201026, 
      0.511312951527656, 0.511312951527656, 0.511312951527656, 
      0.674208634351771, 0.674208634351771, 0.837104317175885, 
      0.837104317175885, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.01], 
    PointBox[{{-3.2, 3}, {-2.86666666666667, 
      2.66666666666667}, {-2.53333333333333, 
      2.33333333333333}, {-1.86666666666667, 
      1.66666666666667}, {-1.53333333333333, 
      1.33333333333333}, {-0.845648340392495, 
      0.645648340392495}, {-0.554351659607505, 
      0.354351659607505}, {-0.2, 0}, {-0.133333333333333, 
       0}, {-0.0666666666666667, 0}, {0.0708703319215009, 0}, {
      0.129129668078499, 0}, {0.2, 0}, {0.533333333333333, 
      0.333333333333333}, {0.866666666666667, 0.666666666666667}, {
      1.53333333333333, 1.33333333333333}, {1.86666666666667, 
      1.66666666666667}, {2.53333333333333, 2.33333333333333}, {
      2.86666666666667, 2.66666666666667}, {3.2, 3}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-3.2, 3}, {-2.2, 2}, {-1.2, 1}, {-0.2, 0}, {0, 0}, {0.2, 0}, {
       1.2, 1}, {2.2, 2}, {3.2, 3}}]}, 
    {RGBColor[0, 0, 1], 
     ArrowBox[{{-3.2, 3}, {-3.058578643762691, 2.8585786437626903`}}], 
     ArrowBox[{{-2.2, 2}, {-2.0585786437626905`, 1.8585786437626906`}}], 
     ArrowBox[{{-1.2, 1}, {-1.0585786437626903`, 0.8585786437626906}}], 
     ArrowBox[{{-0.2, 0}, {0., 0.}}], ArrowBox[{{0, 0}, {0.2, 0.}}], 
     ArrowBox[{{0.2, 0}, {0.3414213562373094, 0.14142135623730942`}}], 
     ArrowBox[{{1.2, 1}, {1.3414213562373096`, 1.1414213562373094`}}], 
     ArrowBox[{{2.2, 2}, {2.34142135623731, 2.1414213562373092`}}], 
     ArrowBox[{{3.2, 3}, {3.3414213562373094`, 3.1414213562373097`}}]}}},
  ImageSize->{506., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9, 3.58687814300249*^9, 
   3.5868783847937193`*^9, 3.586878455756534*^9, 3.586878869436592*^9, 
   3.586879069495915*^9, 3.5868791810291233`*^9, 3.586879420184026*^9, {
   3.586879748873714*^9, 3.586879777971246*^9}, 3.587315469800477*^9, 
   3.587315547825822*^9, 3.587315866208727*^9, 3.587316474122122*^9, 
   3.587316750092361*^9, 3.587316968213854*^9, 3.587317051246122*^9, 
   3.5873174558348217`*^9, 3.587317592323119*^9, 3.5873184747338877`*^9, 
   3.5873192428263474`*^9, 3.58731930462689*^9, 3.587319398734584*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["T"], "Input",
 CellChangeTimes->{3.587316785319363*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", 
     RowBox[{"-", "0.707106781186548`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", 
     RowBox[{"-", "0.707106781186547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186548`", ",", "0.707106781186547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.707106781186547`", ",", "0.707106781186548`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5873167866194677`*^9, 3.58731696822143*^9, 
  3.587317051507194*^9, 3.587317456058959*^9, 3.587317592586384*^9, 
  3.5873184747395573`*^9, 3.58731924283389*^9, 3.587319304867282*^9, 
  3.587319398740815*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BSplineCurve", "[", 
     RowBox[{"pts", ",", 
      RowBox[{"SplineKnots", "\[Rule]", "k"}]}], "]"}], ",", 
    RowBox[{"PointSize", "\[Rule]", ".01"}], ",", "Green", ",", 
    RowBox[{"Point", "[", "pts", "]"}], ",", "Red", ",", 
    RowBox[{"Point", "[", "Q", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.586281085643919*^9, 3.586281113186692*^9}, {
   3.586281248232779*^9, 3.5862812516312017`*^9}, {3.586281285411515*^9, 
   3.5862812859544287`*^9}, 3.586527514022748*^9, {3.586541881814122*^9, 
   3.586541895040698*^9}, {3.586864457718248*^9, 3.586864541822855*^9}, {
   3.586869568195086*^9, 3.586869578694957*^9}, {3.586869946400834*^9, 
   3.5868699570237923`*^9}, {3.586876917672286*^9, 3.5868769347349243`*^9}, {
   3.58687976234692*^9, 3.58687977745163*^9}, {3.587316744537133*^9, 
   3.587316748103191*^9}, {3.5873168195184317`*^9, 3.5873168255967083`*^9}, {
   3.587317614476432*^9, 3.587317620225398*^9}},
 CellID->1168255855],

Cell[BoxData[
 GraphicsBox[{
   BSplineCurveBox[{{-3.2, 3}, {-2.86666666666667, 
     2.66666666666667}, {-2.53333333333333, 
     2.33333333333333}, {-1.86666666666667, 
     1.66666666666667}, {-1.53333333333333, 
     1.33333333333333}, {-0.845648340392495, 
     0.645648340392495}, {-0.554351659607505, 
     0.354351659607505}, {-0.2, 0}, {-0.133333333333333, 
      0}, {-0.0666666666666667, 0}, {0.0708703319215009, 0}, {
     0.129129668078499, 0}, {0.2, 0}, {0.533333333333333, 
     0.333333333333333}, {0.866666666666667, 0.666666666666667}, {
     1.53333333333333, 1.33333333333333}, {1.86666666666667, 
     1.66666666666667}, {2.53333333333333, 2.33333333333333}, {
     2.86666666666667, 2.66666666666667}, {3.2, 3}},
    SplineKnots->{
     0, 0, 0, 0, 0.162895682824115, 0.162895682824115, 0.325791365648229, 
      0.325791365648229, 0.468144280810837, 0.468144280810837, 
      0.468144280810837, 0.491181209201026, 0.491181209201026, 
      0.511312951527656, 0.511312951527656, 0.511312951527656, 
      0.674208634351771, 0.674208634351771, 0.837104317175885, 
      0.837104317175885, 1, 1, 1, 1}], 
   {RGBColor[0, 1, 0], PointSize[0.01], 
    PointBox[{{-3.2, 3}, {-2.86666666666667, 
      2.66666666666667}, {-2.53333333333333, 
      2.33333333333333}, {-1.86666666666667, 
      1.66666666666667}, {-1.53333333333333, 
      1.33333333333333}, {-0.845648340392495, 
      0.645648340392495}, {-0.554351659607505, 
      0.354351659607505}, {-0.2, 0}, {-0.133333333333333, 
       0}, {-0.0666666666666667, 0}, {0.0708703319215009, 0}, {
      0.129129668078499, 0}, {0.2, 0}, {0.533333333333333, 
      0.333333333333333}, {0.866666666666667, 0.666666666666667}, {
      1.53333333333333, 1.33333333333333}, {1.86666666666667, 
      1.66666666666667}, {2.53333333333333, 2.33333333333333}, {
      2.86666666666667, 2.66666666666667}, {3.2, 3}}], 
    {RGBColor[1, 0, 0], 
     PointBox[{{-3.2, 3}, {-2.2, 2}, {-1.2, 1}, {-0.2, 0}, {0, 0}, {0.2, 0}, {
       1.2, 1}, {2.2, 2}, {3.2, 3}}]}}},
  ImageSize->{517., Automatic}]], "Output",
 CellChangeTimes->{{3.586281090823595*^9, 3.586281113868927*^9}, 
   3.586281252421377*^9, {3.586281354346138*^9, 3.586281370673305*^9}, 
   3.586281834817232*^9, 3.586281889554061*^9, 3.5862829888861923`*^9, 
   3.586283248108602*^9, 3.5862839864118137`*^9, 3.5862855786745443`*^9, 
   3.586525229465508*^9, 3.586526142394788*^9, {3.586527496097107*^9, 
   3.5865275156245003`*^9}, {3.586532812080112*^9, 3.586532872588888*^9}, 
   3.5865329139667797`*^9, {3.586541862481411*^9, 3.586541896919441*^9}, 
   3.5865431139371347`*^9, 3.5866274419786453`*^9, 3.586700729812666*^9, 
   3.5867015552978783`*^9, 3.586704108994218*^9, 3.58670697887405*^9, 
   3.586707921569446*^9, 3.586808252602353*^9, 3.586810422007454*^9, 
   3.586864019502495*^9, 3.5868644160050373`*^9, {3.5868644633393717`*^9, 
   3.586864542283299*^9}, 3.5868672746782846`*^9, 3.586868216781518*^9, 
   3.5868685278268137`*^9, {3.5868694377785482`*^9, 3.586869453859785*^9}, {
   3.586869544853587*^9, 3.5868695796585197`*^9}, 3.586869666383359*^9, 
   3.5868697997731543`*^9, 3.586869846397963*^9, {3.586869882625216*^9, 
   3.586869910537372*^9}, {3.586869946805019*^9, 3.586869957591443*^9}, 
   3.5868700085488586`*^9, 3.586874868819085*^9, 3.586874949633292*^9, 
   3.586876832196019*^9, 3.5868768724390993`*^9, {3.586876918629541*^9, 
   3.586876936616723*^9}, 3.586876980779665*^9, 3.5868771919708033`*^9, 
   3.586877240263167*^9, 3.58687741147994*^9, 3.58687814300249*^9, 
   3.5868783847937193`*^9, 3.586878455756534*^9, 3.586878869436592*^9, 
   3.586879069495915*^9, 3.5868791810291233`*^9, 3.586879420184026*^9, {
   3.586879748873714*^9, 3.586879777971246*^9}, 3.587315469800477*^9, 
   3.587315547825822*^9, 3.587315866208727*^9, 3.587316474122122*^9, 
   3.587316750092361*^9, 3.587316827438676*^9, 3.58731696843935*^9, 
   3.587317051726652*^9, 3.587317456278455*^9, {3.587317592828403*^9, 
   3.5873176206927977`*^9}, 3.587318474977174*^9, 3.587319243071253*^9, 
   3.587319305093031*^9, 3.587319398982587*^9},
 ImageSize->{184, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Q"], "Input",
 CellChangeTimes->{3.586808270832356*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.2`"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.2`"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2`"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2`"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2`", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2`", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2`", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.586808271473693*^9, 3.5868104222460337`*^9, 
  3.586864019510871*^9, 3.586867274821607*^9, 3.586868216918501*^9, 
  3.586868528024688*^9, 3.586874868826749*^9, 3.586876832363161*^9, 
  3.5868774116749353`*^9, 3.586878143010902*^9, 3.5868783848014*^9, 
  3.5868784557648773`*^9, 3.586878869444745*^9, 3.586879069503792*^9, 
  3.586879181173381*^9, 3.586879420192492*^9, 3.5868797488814793`*^9, 
  3.587315469807911*^9, 3.5873155480527887`*^9, 3.587315866218503*^9, 
  3.587316474370675*^9, 3.587316968766918*^9, 3.587317051977272*^9, 
  3.587317456283352*^9, 3.5873175930725737`*^9, 3.587318475217411*^9, 
  3.5873192433078537`*^9, 3.5873193053642*^9, 3.58731939918764*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1364, 824},
WindowMargins->{{Automatic, 160}, {Automatic, 5}},
ShowSelection->True,
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3586261646-2376400"->{
  Cell[924, 34, 850, 17, 46, "Print",
   CellTags->"Info3586261646-2376400"],
  Cell[1777, 53, 1274, 34, 53, "Print",
   CellTags->"Info3586261646-2376400"]},
 "Info3586507172-3732742"->{
  Cell[101066, 2913, 861, 17, 46, "Print",
   CellTags->"Info3586507172-3732742"]},
 "Info3586858469-1059658"->{
  Cell[207745, 5530, 2679, 43, 103, "Print",
   CellTags->"Info3586858469-1059658"]},
 "Info3586853420-3167396"->{
  Cell[354524, 9266, 2352, 38, 79, "Print",
   CellTags->"Info3586853420-3167396"]},
 "Info3587297798-3801113"->{
  Cell[451673, 11777, 2619, 42, 103, "Print",
   CellTags->"Info3587297798-3801113"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3586261646-2376400", 478156, 12330},
 {"Info3586507172-3732742", 478344, 12335},
 {"Info3586858469-1059658", 478457, 12338},
 {"Info3586853420-3167396", 478572, 12341},
 {"Info3587297798-3801113", 478686, 12344}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 148, 2, 38, "Subsection"],
Cell[CellGroupData[{
Cell[752, 28, 147, 2, 48, "Input"],
Cell[CellGroupData[{
Cell[924, 34, 850, 17, 46, "Print",
 CellTags->"Info3586261646-2376400"],
Cell[1777, 53, 1274, 34, 53, "Print",
 CellTags->"Info3586261646-2376400"]
}, Closed]]
}, Closed]],
Cell[3078, 91, 558, 19, 29, "Input",
 CellID->21035271],
Cell[CellGroupData[{
Cell[3661, 114, 518, 14, 29, "Input",
 CellID->145180654],
Cell[4182, 130, 524, 12, 159, "Output"]
}, Closed]],
Cell[4721, 145, 559, 19, 29, "Input",
 CellID->784820924],
Cell[CellGroupData[{
Cell[5305, 168, 310, 7, 29, "Input"],
Cell[5618, 177, 337, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[5992, 189, 129, 2, 29, "Input"],
Cell[6124, 193, 92, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6253, 199, 124, 2, 29, "Input"],
Cell[6380, 203, 93, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6510, 209, 234, 5, 29, "Input"],
Cell[6747, 216, 189, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6973, 224, 475, 12, 29, "Input",
 CellID->640709794],
Cell[7451, 238, 5514, 95, 159, 275, 6, "CachedBoxData", "BoxData", "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[13002, 338, 845, 26, 29, "Input",
 CellID->926501700],
Cell[13850, 366, 790, 24, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[14677, 395, 126, 2, 29, "Input"],
Cell[14806, 399, 118, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[14961, 406, 119, 2, 29, "Input"],
Cell[15083, 410, 92, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15212, 416, 314, 6, 29, "Input"],
Cell[15529, 424, 288, 5, 44, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15854, 434, 648, 16, 29, "Input"],
Cell[16505, 452, 464, 9, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[17006, 466, 234, 5, 29, "Input"],
Cell[17243, 473, 260, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[17540, 482, 225, 5, 29, "Input"],
Cell[17768, 489, 1081, 31, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[18886, 525, 133, 2, 29, "Input"],
Cell[19022, 529, 1367, 38, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[20426, 572, 147, 3, 29, "Input"],
Cell[20576, 577, 316, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[20929, 589, 475, 12, 29, "Input",
 CellID->310147503],
Cell[21407, 603, 737, 14, 159, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[22181, 622, 963, 27, 78, "Input",
 CellID->202989881],
Cell[23147, 651, 790, 24, 29, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23986, 681, 113, 1, 30, "Subsection"],
Cell[24102, 684, 2009, 54, 162, "Input"],
Cell[CellGroupData[{
Cell[26136, 742, 1262, 39, 84, "Input"],
Cell[27401, 783, 407, 11, 29, "Output"],
Cell[27811, 796, 432, 11, 29, "Output"],
Cell[28246, 809, 633, 17, 29, "Output"],
Cell[28882, 828, 348, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[29267, 840, 1476, 42, 120, "Input"],
Cell[30746, 884, 279, 9, 29, "Output"],
Cell[31028, 895, 376, 10, 29, "Output"],
Cell[31407, 907, 588, 15, 29, "Output"],
Cell[31998, 924, 218, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[32253, 934, 1544, 46, 120, "Input"],
Cell[33800, 982, 295, 9, 29, "Output"],
Cell[34098, 993, 457, 14, 29, "Output"],
Cell[34558, 1009, 883, 24, 48, "Output"],
Cell[35444, 1035, 333, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[35814, 1047, 449, 14, 29, "Input"],
Cell[36266, 1063, 468, 12, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[36771, 1080, 588, 16, 29, "Input"],
Cell[37362, 1098, 927, 18, 22, "Print"],
Cell[38292, 1118, 452, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[38781, 1130, 297, 9, 29, "Input"],
Cell[39081, 1141, 300, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[39418, 1151, 295, 9, 29, "Input"],
Cell[39716, 1162, 322, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[40075, 1173, 336, 10, 29, "Input"],
Cell[40414, 1185, 234, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[40685, 1194, 514, 14, 29, "Input"],
Cell[41202, 1210, 859, 17, 22, "Print"],
Cell[42064, 1229, 382, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[42483, 1240, 376, 10, 29, "Input"],
Cell[42862, 1252, 396, 8, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[43295, 1265, 366, 10, 29, "Input"],
Cell[43664, 1277, 390, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[44091, 1289, 393, 11, 29, "Input"],
Cell[44487, 1302, 228, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[44752, 1310, 119, 2, 29, "Input"],
Cell[44874, 1314, 232, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[45143, 1322, 221, 6, 29, "Input"],
Cell[45367, 1330, 257, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[45661, 1338, 330, 9, 29, "Input"],
Cell[45994, 1349, 613, 15, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[46644, 1369, 93, 1, 29, "Input"],
Cell[46740, 1372, 242, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[47019, 1382, 283, 7, 29, "Input"],
Cell[47305, 1391, 240, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[47582, 1401, 170, 3, 29, "Input"],
Cell[47755, 1406, 1069, 27, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[48861, 1438, 126, 2, 29, "Input"],
Cell[48990, 1442, 329, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[49356, 1452, 119, 2, 29, "Input"],
Cell[49478, 1456, 301, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[49816, 1465, 187, 3, 29, "Input"],
Cell[50006, 1470, 622, 12, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[50665, 1487, 392, 9, 29, "Input"],
Cell[51060, 1498, 490, 9, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[51587, 1512, 234, 5, 29, "Input"],
Cell[51824, 1519, 530, 8, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[52391, 1532, 224, 5, 29, "Input"],
Cell[52618, 1539, 406, 11, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[53061, 1555, 120, 2, 29, "Input"],
Cell[53184, 1559, 260, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[53481, 1569, 123, 2, 29, "Input"],
Cell[53607, 1573, 298, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[53942, 1584, 167, 3, 29, "Input"],
Cell[54112, 1589, 826, 21, 29, "Output"]
}, Closed]],
Cell[54953, 1613, 545, 17, 29, "Input"],
Cell[CellGroupData[{
Cell[55523, 1634, 122, 2, 29, "Input"],
Cell[55648, 1638, 128, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[55813, 1645, 143, 3, 29, "Input"],
Cell[55959, 1650, 157, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[56153, 1657, 399, 8, 29, "Input"],
Cell[56555, 1667, 329, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[56921, 1679, 497, 12, 29, "Input",
 CellID->943442095],
Cell[57421, 1693, 1004, 17, 374, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[58474, 1716, 185, 4, 30, "Subsection"],
Cell[CellGroupData[{
Cell[58684, 1724, 3550, 85, 192, "Input"],
Cell[62237, 1811, 979, 27, 29, "Output"],
Cell[63219, 1840, 2256, 49, 66, "Output"],
Cell[65478, 1891, 850, 14, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[66365, 1910, 120, 2, 29, "Input"],
Cell[66488, 1914, 2110, 47, 66, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[68635, 1966, 124, 2, 29, "Input"],
Cell[68762, 1970, 93, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[68892, 1976, 119, 2, 29, "Input"],
Cell[69014, 1980, 261, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[69312, 1989, 392, 9, 29, "Input"],
Cell[69707, 2000, 722, 12, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[70466, 2017, 234, 5, 29, "Input"],
Cell[70703, 2024, 456, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[71196, 2036, 224, 5, 29, "Input"],
Cell[71423, 2043, 286, 9, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[71746, 2057, 120, 2, 29, "Input"],
Cell[71869, 2061, 140, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[72046, 2069, 123, 2, 29, "Input"],
Cell[72172, 2073, 180, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[72389, 2082, 167, 3, 29, "Input"],
Cell[72559, 2087, 2351, 55, 66, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[74947, 2147, 547, 13, 29, "Input",
 CellID->371110108],
Cell[75497, 2162, 2205, 37, 374, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[77739, 2204, 97, 1, 29, "Input"],
Cell[77839, 2207, 504, 9, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[78380, 2221, 367, 11, 29, "Input"],
Cell[78750, 2234, 313, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[79100, 2245, 125, 2, 29, "Input"],
Cell[79228, 2249, 97, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[79362, 2255, 126, 2, 29, "Input"],
Cell[79491, 2259, 71, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[79599, 2265, 125, 2, 29, "Input"],
Cell[79727, 2269, 71, 1, 29, "Output"]
}, Closed]],
Cell[79813, 2273, 638, 19, 29, "Input"],
Cell[CellGroupData[{
Cell[80476, 2296, 125, 2, 29, "Input"],
Cell[80604, 2300, 1489, 31, 166, "Output"]
}, Closed]],
Cell[82108, 2334, 118, 2, 29, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[82263, 2341, 207, 4, 30, "Subsection"],
Cell[CellGroupData[{
Cell[82495, 2349, 1421, 41, 120, "Input"],
Cell[83919, 2392, 477, 12, 29, "Output"],
Cell[84399, 2406, 576, 13, 29, "Output"],
Cell[84978, 2421, 786, 18, 29, "Output"],
Cell[85767, 2441, 412, 8, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[86216, 2454, 120, 2, 29, "Input"],
Cell[86339, 2458, 637, 16, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[87013, 2479, 124, 2, 29, "Input"],
Cell[87140, 2483, 117, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[87294, 2490, 119, 2, 29, "Input"],
Cell[87416, 2494, 283, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[87736, 2503, 392, 9, 29, "Input"],
Cell[88131, 2514, 288, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[88456, 2526, 234, 5, 29, "Input"],
Cell[88693, 2533, 478, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[89208, 2545, 224, 5, 29, "Input"],
Cell[89435, 2552, 313, 10, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[89785, 2567, 120, 2, 29, "Input"],
Cell[89908, 2571, 165, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[90110, 2580, 123, 2, 29, "Input"],
Cell[90236, 2584, 205, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[90478, 2594, 167, 3, 29, "Input"],
Cell[90648, 2599, 736, 20, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[91421, 2624, 547, 13, 29, "Input",
 CellID->106228517],
Cell[91971, 2639, 1049, 18, 374, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[93057, 2662, 97, 1, 29, "Input"],
Cell[93157, 2665, 504, 9, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[93698, 2679, 367, 11, 29, "Input"],
Cell[94068, 2692, 313, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[94418, 2703, 125, 2, 29, "Input"],
Cell[94546, 2707, 97, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[94680, 2713, 126, 2, 29, "Input"],
Cell[94809, 2717, 71, 1, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[94917, 2723, 125, 2, 29, "Input"],
Cell[95045, 2727, 71, 1, 29, "Output"]
}, Closed]],
Cell[95131, 2731, 638, 19, 29, "Input"],
Cell[CellGroupData[{
Cell[95794, 2754, 125, 2, 29, "Input"],
Cell[95922, 2758, 1489, 31, 166, "Output"]
}, Closed]],
Cell[97426, 2792, 118, 2, 29, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[97581, 2799, 150, 2, 30, "Subsection"],
Cell[CellGroupData[{
Cell[97756, 2805, 913, 27, 66, "Input"],
Cell[98672, 2834, 665, 21, 29, "Output"],
Cell[99340, 2857, 258, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[99635, 2868, 126, 2, 29, "Input"],
Cell[99764, 2872, 186, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[99987, 2880, 119, 2, 29, "Input"],
Cell[100109, 2884, 163, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[100309, 2891, 234, 5, 29, "Input"],
Cell[100546, 2898, 360, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[100943, 2909, 120, 2, 29, "Input"],
Cell[101066, 2913, 861, 17, 46, "Print",
 CellTags->"Info3586507172-3732742"]
}, Closed]],
Cell[CellGroupData[{
Cell[101964, 2935, 577, 13, 29, "Input",
 CellID->1120323371],
Cell[102544, 2950, 6506, 111, 391, 319, 7, "CachedBoxData", "BoxData", \
"Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[109099, 3067, 211, 3, 30, "Subsection"],
Cell[109313, 3072, 14299, 301, 804, "Input"],
Cell[CellGroupData[{
Cell[123637, 3377, 94, 1, 29, "Input"],
Cell[123734, 3380, 7969, 176, 250, "Output"]
}, Closed]],
Cell[131718, 3559, 164, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[131907, 3567, 124, 2, 29, "Input"],
Cell[132034, 3571, 162, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[132233, 3578, 119, 2, 29, "Input"],
Cell[132355, 3582, 332, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[132724, 3592, 392, 9, 29, "Input"],
Cell[133119, 3603, 2498, 38, 102, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[135654, 3646, 129, 2, 29, "Input"],
Cell[135786, 3650, 164, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[135987, 3659, 125, 2, 29, "Input"],
Cell[136115, 3663, 142, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[136294, 3671, 234, 5, 29, "Input"],
Cell[136531, 3678, 526, 8, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[137094, 3691, 224, 5, 29, "Input"],
Cell[137321, 3698, 353, 10, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[137711, 3713, 120, 2, 29, "Input"],
Cell[137834, 3717, 203, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[138074, 3727, 123, 2, 29, "Input"],
Cell[138200, 3731, 206, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[138443, 3741, 167, 3, 29, "Input"],
Cell[138613, 3746, 8557, 235, 246, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[147207, 3986, 547, 13, 29, "Input",
 CellID->143768448],
Cell[147757, 4001, 7804, 116, 370, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[155610, 4123, 253, 3, 30, "Subsection"],
Cell[155866, 4128, 4357, 123, 210, "Input"],
Cell[160226, 4253, 164, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[160415, 4261, 124, 2, 29, "Input"],
Cell[160542, 4265, 231, 3, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[160810, 4273, 119, 2, 29, "Input"],
Cell[160932, 4277, 403, 6, 29, "Output"]
}, Closed]],
Cell[161350, 4286, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[161814, 4300, 129, 2, 29, "Input"],
Cell[161946, 4304, 235, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[162218, 4314, 125, 2, 29, "Input"],
Cell[162346, 4318, 211, 4, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[162594, 4327, 234, 5, 29, "Input"],
Cell[162831, 4334, 597, 9, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[163465, 4348, 224, 5, 29, "Input"],
Cell[163692, 4355, 423, 11, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[164152, 4371, 120, 2, 29, "Input"],
Cell[164275, 4375, 234, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[164546, 4385, 123, 2, 29, "Input"],
Cell[164672, 4389, 270, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[164979, 4399, 167, 3, 29, "Input"],
Cell[165149, 4404, 2775, 78, 70, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[167961, 4487, 646, 14, 29, "Input",
 CellID->131055604],
Cell[168610, 4503, 2348, 42, 654, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[171007, 4551, 313, 4, 30, "Subsection"],
Cell[171323, 4557, 10371, 260, 480, "Input"],
Cell[181697, 4819, 10305, 259, 480, "Input"],
Cell[CellGroupData[{
Cell[192027, 5082, 116, 2, 29, "Input"],
Cell[192146, 5086, 2732, 76, 92, "Output"]
}, Open  ]],
Cell[194893, 5165, 164, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[195082, 5173, 124, 2, 29, "Input"],
Cell[195209, 5177, 280, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195526, 5186, 119, 2, 29, "Input"],
Cell[195648, 5190, 447, 6, 29, "Output"]
}, Open  ]],
Cell[196110, 5199, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[196574, 5213, 129, 2, 29, "Input"],
Cell[196706, 5217, 282, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197025, 5227, 125, 2, 29, "Input"],
Cell[197153, 5231, 255, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197445, 5240, 234, 5, 29, "Input"],
Cell[197682, 5247, 647, 10, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198366, 5262, 224, 5, 29, "Input"],
Cell[198593, 5269, 470, 12, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199100, 5286, 120, 2, 29, "Input"],
Cell[199223, 5290, 280, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199540, 5300, 123, 2, 29, "Input"],
Cell[199666, 5304, 320, 6, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[200023, 5315, 167, 3, 29, "Input"],
Cell[200193, 5320, 4840, 122, 128, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205070, 5447, 69, 1, 29, "Input"],
Cell[205142, 5450, 2449, 71, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[207628, 5526, 114, 2, 29, "Input"],
Cell[207745, 5530, 2679, 43, 103, "Print",
 CellTags->"Info3586858469-1059658"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210461, 5578, 789, 16, 29, "Input",
 CellID->1043598254],
Cell[211253, 5596, 6234, 108, 168, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[217536, 5710, 354, 5, 30, "Subsection"],
Cell[217893, 5717, 65614, 1685, 3054, "Input"],
Cell[283510, 7404, 164, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[283699, 7412, 124, 2, 29, "Input"],
Cell[283826, 7416, 326, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[284189, 7426, 119, 2, 23, "Input"],
Cell[284311, 7430, 493, 7, 29, "Output"]
}, Closed]],
Cell[284819, 7440, 439, 10, 23, "Input"],
Cell[CellGroupData[{
Cell[285283, 7454, 129, 2, 29, "Input"],
Cell[285415, 7458, 329, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[285781, 7469, 125, 2, 23, "Input"],
Cell[285909, 7473, 304, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[286250, 7483, 234, 5, 23, "Input"],
Cell[286487, 7490, 698, 10, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[287222, 7505, 224, 5, 23, "Input"],
Cell[287449, 7512, 519, 13, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[288005, 7530, 120, 2, 23, "Input"],
Cell[288128, 7534, 362, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[288527, 7546, 123, 2, 23, "Input"],
Cell[288653, 7550, 387, 7, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[289077, 7562, 145, 3, 23, "Input"],
Cell[289225, 7567, 251, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[289513, 7577, 145, 3, 23, "Input"],
Cell[289661, 7582, 285, 6, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[289983, 7593, 128, 2, 23, "Input"],
Cell[290114, 7597, 143, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[290294, 7604, 125, 2, 23, "Input"],
Cell[290422, 7608, 165, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[290624, 7615, 143, 3, 23, "Input"],
Cell[290770, 7620, 260, 5, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[291067, 7630, 125, 2, 23, "Input"],
Cell[291195, 7634, 118, 2, 29, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[291350, 7641, 548, 13, 23, "Input",
 CellID->1298760213],
Cell[291901, 7656, 13833, 229, 720, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[305771, 7890, 68, 1, 23, "Input"],
Cell[305842, 7893, 70, 1, 29, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[305961, 7900, 425, 7, 30, "Subsection"],
Cell[306389, 7909, 3178, 90, 174, "Input"],
Cell[CellGroupData[{
Cell[309592, 8003, 128, 2, 29, "Input"],
Cell[309723, 8007, 168, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309928, 8014, 127, 2, 29, "Input"],
Cell[310058, 8018, 93, 1, 29, "Output"]
}, Open  ]],
Cell[310166, 8022, 3308, 93, 174, "Input"],
Cell[313477, 8117, 3308, 93, 174, "Input"],
Cell[316788, 8212, 3262, 92, 156, "Input"],
Cell[CellGroupData[{
Cell[320075, 8308, 125, 2, 29, "Input"],
Cell[320203, 8312, 142, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[320382, 8319, 130, 2, 29, "Input"],
Cell[320515, 8323, 140, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[320692, 8330, 170, 3, 29, "Input"],
Cell[320865, 8335, 1455, 40, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[322357, 8380, 119, 2, 29, "Input"],
Cell[322479, 8384, 791, 12, 29, "Output"]
}, Open  ]],
Cell[323285, 8399, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[323749, 8413, 93, 1, 29, "Input"],
Cell[323845, 8416, 893, 21, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[324775, 8442, 125, 2, 29, "Input"],
Cell[324903, 8446, 314, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325254, 8456, 94, 1, 29, "Input"],
Cell[325351, 8459, 1500, 41, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[326888, 8505, 69, 1, 29, "Input"],
Cell[326960, 8508, 646, 12, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327643, 8525, 185, 4, 29, "Input"],
Cell[327831, 8531, 117, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327985, 8538, 837, 16, 29, "Input",
 CellID->1097886363],
Cell[328825, 8556, 5810, 98, 305, 1462, 27, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[334672, 8659, 69, 1, 29, "Input"],
Cell[334744, 8662, 769, 23, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[335562, 8691, 417, 5, 30, "Subsection"],
Cell[CellGroupData[{
Cell[336004, 8700, 510, 10, 29, "Input"],
Cell[336517, 8712, 287, 6, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336841, 8723, 347, 11, 29, "Input"],
Cell[337191, 8736, 369, 12, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337597, 8753, 694, 22, 29, "Input"],
Cell[338294, 8777, 690, 22, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339021, 8804, 182, 4, 29, "Input"],
Cell[339206, 8810, 125, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339368, 8817, 158, 4, 29, "Input"],
Cell[339529, 8823, 265, 9, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339831, 8837, 120, 2, 29, "Input"],
Cell[339954, 8841, 140, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[340131, 8850, 120, 2, 29, "Input"],
Cell[340254, 8854, 119, 3, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[340410, 8862, 173, 3, 29, "Input"],
Cell[340586, 8867, 208, 5, 29, "Output"]
}, Open  ]],
Cell[340809, 8875, 69, 1, 29, "Input"],
Cell[CellGroupData[{
Cell[340903, 8880, 788, 16, 29, "Input",
 CellID->280088889],
Cell[341694, 8898, 1800, 30, 496, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[343531, 8933, 69, 1, 29, "Input"],
Cell[343603, 8936, 698, 22, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[344350, 8964, 417, 5, 30, "Subsection"],
Cell[344770, 8971, 3178, 90, 174, "Input"],
Cell[CellGroupData[{
Cell[347973, 9065, 144, 3, 29, "Input"],
Cell[348120, 9070, 223, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348380, 9079, 144, 3, 29, "Input"],
Cell[348527, 9084, 223, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348787, 9093, 144, 3, 29, "Input"],
Cell[348934, 9098, 223, 5, 29, "Output"]
}, Open  ]],
Cell[349172, 9106, 164, 4, 29, "Input"],
Cell[CellGroupData[{
Cell[349361, 9114, 119, 2, 29, "Input"],
Cell[349483, 9118, 681, 10, 29, "Output"]
}, Open  ]],
Cell[350179, 9131, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[350643, 9145, 93, 1, 29, "Input"],
Cell[350739, 9148, 791, 20, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[351567, 9173, 313, 6, 29, "Input"],
Cell[351883, 9181, 337, 7, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352257, 9193, 125, 2, 29, "Input"],
Cell[352385, 9197, 120, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352542, 9204, 128, 2, 29, "Input"],
Cell[352673, 9208, 118, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352828, 9215, 97, 1, 29, "Input"],
Cell[352928, 9218, 1439, 39, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354404, 9262, 117, 2, 29, "Input"],
Cell[354524, 9266, 2352, 38, 79, "Print",
 CellTags->"Info3586853420-3167396"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356913, 9309, 340, 8, 29, "Input"],
Cell[357256, 9319, 545, 10, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357838, 9334, 290, 7, 29, "Input"],
Cell[358131, 9343, 1524, 41, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359692, 9389, 789, 16, 29, "Input",
 CellID->1009384459],
Cell[360484, 9407, 2857, 48, 305, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[363390, 9461, 492, 8, 30, "Subsection"],
Cell[363885, 9471, 3268, 92, 174, "Input"],
Cell[367156, 9565, 3087, 90, 156, "Input"],
Cell[370246, 9657, 3473, 98, 192, "Input"],
Cell[CellGroupData[{
Cell[373744, 9759, 128, 2, 29, "Input"],
Cell[373875, 9763, 237, 3, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[374149, 9771, 127, 2, 29, "Input"],
Cell[374279, 9775, 162, 2, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[374478, 9782, 170, 3, 29, "Input"],
Cell[374651, 9787, 1608, 45, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[376296, 9837, 119, 2, 29, "Input"],
Cell[376418, 9841, 863, 13, 29, "Output"]
}, Open  ]],
Cell[377296, 9857, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[377760, 9871, 93, 1, 29, "Input"],
Cell[377856, 9874, 1109, 24, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379002, 9903, 125, 2, 29, "Input"],
Cell[379130, 9907, 388, 6, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379555, 9918, 94, 1, 29, "Input"],
Cell[379652, 9921, 1653, 46, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[381342, 9972, 69, 1, 29, "Input"],
Cell[381414, 9975, 686, 12, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382137, 9992, 185, 4, 29, "Input"],
Cell[382325, 9998, 184, 3, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382546, 10006, 837, 16, 29, "Input",
 CellID->1369852157],
Cell[383386, 10024, 3234, 55, 319, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[386657, 10084, 69, 1, 29, "Input"],
Cell[386729, 10087, 844, 24, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[387622, 10117, 488, 8, 30, "Subsection"],
Cell[388113, 10127, 3519, 99, 174, "Input"],
Cell[391635, 10228, 3513, 99, 156, "Input"],
Cell[CellGroupData[{
Cell[395173, 10331, 128, 2, 29, "Input"],
Cell[395304, 10335, 309, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395650, 10344, 127, 2, 29, "Input"],
Cell[395780, 10348, 230, 3, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396047, 10356, 170, 3, 29, "Input"],
Cell[396220, 10361, 1715, 48, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[397972, 10414, 119, 2, 29, "Input"],
Cell[398094, 10418, 935, 14, 29, "Output"]
}, Open  ]],
Cell[399044, 10435, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[399508, 10449, 93, 1, 29, "Input"],
Cell[399604, 10452, 1157, 24, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400798, 10481, 125, 2, 29, "Input"],
Cell[400926, 10485, 458, 7, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[401421, 10497, 94, 1, 29, "Input"],
Cell[401518, 10500, 1763, 49, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403318, 10554, 69, 1, 29, "Input"],
Cell[403390, 10557, 789, 14, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404216, 10576, 185, 4, 29, "Input"],
Cell[404404, 10582, 255, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404696, 10591, 69, 1, 29, "Input"],
Cell[404768, 10594, 770, 19, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405575, 10618, 837, 16, 29, "Input",
 CellID->1620628713],
Cell[406415, 10636, 3335, 56, 256, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[409787, 10697, 69, 1, 29, "Input"],
Cell[409859, 10700, 910, 25, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[410818, 10731, 517, 8, 30, "Subsection"],
Cell[411338, 10741, 3517, 99, 174, "Input"],
Cell[CellGroupData[{
Cell[414880, 10844, 128, 2, 29, "Input"],
Cell[415011, 10848, 383, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[415431, 10858, 127, 2, 29, "Input"],
Cell[415561, 10862, 299, 4, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[415897, 10871, 170, 3, 29, "Input"],
Cell[416070, 10876, 1783, 49, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417890, 10930, 119, 2, 29, "Input"],
Cell[418012, 10934, 1005, 15, 29, "Output"]
}, Open  ]],
Cell[419032, 10952, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[419496, 10966, 93, 1, 29, "Input"],
Cell[419592, 10969, 1227, 25, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[420856, 10999, 125, 2, 29, "Input"],
Cell[420984, 11003, 528, 8, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[421549, 11016, 94, 1, 29, "Input"],
Cell[421646, 11019, 1831, 50, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[423514, 11074, 69, 1, 29, "Input"],
Cell[423586, 11077, 859, 15, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[424482, 11097, 185, 4, 29, "Input"],
Cell[424670, 11103, 325, 5, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425032, 11113, 69, 1, 29, "Input"],
Cell[425104, 11116, 845, 20, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425986, 11141, 884, 17, 29, "Input",
 CellID->1156784570],
Cell[426873, 11160, 3421, 57, 256, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[430331, 11222, 69, 1, 29, "Input"],
Cell[430403, 11225, 981, 26, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[431433, 11257, 571, 9, 30, "Subsection"],
Cell[432007, 11268, 4442, 125, 210, "Input"],
Cell[CellGroupData[{
Cell[436474, 11397, 128, 2, 29, "Input"],
Cell[436605, 11401, 650, 9, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[437292, 11415, 127, 2, 29, "Input"],
Cell[437422, 11419, 551, 8, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438010, 11432, 170, 3, 29, "Input"],
Cell[438183, 11437, 2470, 66, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[440690, 11508, 119, 2, 29, "Input"],
Cell[440812, 11512, 1260, 18, 29, "Output"]
}, Open  ]],
Cell[442087, 11533, 439, 10, 29, "Input"],
Cell[CellGroupData[{
Cell[442551, 11547, 93, 1, 29, "Input"],
Cell[442647, 11550, 1655, 35, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[444339, 11590, 151, 3, 29, "Input"],
Cell[444493, 11595, 812, 12, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[445342, 11612, 94, 1, 29, "Input"],
Cell[445439, 11615, 2523, 67, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[447999, 11687, 69, 1, 29, "Input"],
Cell[448071, 11690, 1265, 21, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[449373, 11716, 185, 4, 29, "Input"],
Cell[449561, 11722, 582, 8, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450180, 11735, 69, 1, 29, "Input"],
Cell[450252, 11738, 1265, 30, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[451554, 11773, 116, 2, 29, "Input"],
Cell[451673, 11777, 2619, 42, 103, "Print",
 CellTags->"Info3587297798-3801113"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454329, 11824, 363, 11, 29, "Input"],
Cell[454695, 11837, 2648, 83, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457380, 11925, 1257, 28, 29, "Input",
 CellID->1213197440],
Cell[458640, 11955, 11218, 186, 268, 2668, 48, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[469895, 12146, 69, 1, 29, "Input"],
Cell[469967, 12149, 1117, 28, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[471121, 12182, 1034, 19, 29, "Input",
 CellID->1168255855],
Cell[472158, 12203, 4152, 70, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[476347, 12278, 69, 1, 29, "Input"],
Cell[476419, 12281, 1386, 34, 29, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
