// RUN: %clang_cc1 -triple x86_64-unknown-unknown -std=c++17 -ast-dump=json %s | FileCheck %s

struct A;
struct B;

struct A {
  int a;
  int b, c;
  int d : 12;
  int : 0;
  int e : 10;
  B *f;
};

struct C {
  struct {
    int a;
  } b;

  union {
    int c;
    float d;
  };

  struct {
    int e, f;
  };
};

struct D {
  int a;
  int b[10];
  int c[];
};

union E;

union F;

union E {
  int a;
  int b, c;
  int d : 12;
  int : 0;
  int e : 10;
  B *f;
};

union G {
  struct {
    int a;
  } b;

  union {
    int c;
    float d;
  };

  struct {
    int e, f;
  };
};

struct Base1 {};
struct Base2 {};
struct Base3 {};

struct Derived1 : Base1 {
};

struct Derived2 : private Base1 {
};

struct Derived3 : virtual Base1 {
};

struct Derived4 : Base1, virtual Base2, protected Base3 {
};

struct Derived5 : protected virtual Base1 {
};

template <typename... Bases>
struct Derived6 : virtual public Bases... {
};

// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py
// using --filters=CXXRecordDecl


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "name": "__NSConstantString_tag"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "name": "__va_list_tag"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 102,
// CHECK-NEXT:   "file": "{{.*}}",
// CHECK-NEXT:   "line": 3,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 95,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 102,
// CHECK-NEXT:    "col": 8,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "A",
// CHECK-NEXT:  "tagUsed": "struct"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 112,
// CHECK-NEXT:   "line": 4,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 105,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 112,
// CHECK-NEXT:    "col": 8,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isReferenced": true,
// CHECK-NEXT:  "name": "B",
// CHECK-NEXT:  "tagUsed": "struct"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 123,
// CHECK-NEXT:   "line": 6,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 116,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 195,
// CHECK-NEXT:    "line": 13,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "previousDecl": "0x{{.*}}",
// CHECK-NEXT:  "name": "A",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 123,
// CHECK-NEXT:     "line": 6,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 116,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 123,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "A",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 133,
// CHECK-NEXT:     "line": 7,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 129,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 133,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 142,
// CHECK-NEXT:     "line": 8,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 138,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 142,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 145,
// CHECK-NEXT:     "col": 10,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 138,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 145,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "c",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 154,
// CHECK-NEXT:     "line": 9,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 150,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 158,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 2
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "d",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 158,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 158,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "12",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 158,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 158,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "12"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 168,
// CHECK-NEXT:     "line": 10,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 164,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 170,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 170,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 170,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "0",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 170,
// CHECK-NEXT:          "col": 9,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 170,
// CHECK-NEXT:          "col": 9,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "0"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 179,
// CHECK-NEXT:     "line": 11,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 175,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 183,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 2
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "e",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 183,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 183,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "10",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 183,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 183,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "10"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 192,
// CHECK-NEXT:     "line": 12,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 189,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 192,
// CHECK-NEXT:      "col": 6,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "B *"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 206,
// CHECK-NEXT:   "line": 15,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 199,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 310,
// CHECK-NEXT:    "line": 28,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "C",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasVariantMembers": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 206,
// CHECK-NEXT:     "line": 15,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 199,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 206,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "C",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 212,
// CHECK-NEXT:     "line": 16,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 212,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 234,
// CHECK-NEXT:      "line": 18,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 229,
// CHECK-NEXT:       "line": 17,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 225,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 229,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "a",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 236,
// CHECK-NEXT:     "line": 18,
// CHECK-NEXT:     "col": 5,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 212,
// CHECK-NEXT:      "line": 16,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 236,
// CHECK-NEXT:      "line": 18,
// CHECK-NEXT:      "col": 5,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "struct (unnamed at {{.*}}:16:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 242,
// CHECK-NEXT:     "line": 20,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 242,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 276,
// CHECK-NEXT:      "line": 23,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "union",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasVariantMembers": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 258,
// CHECK-NEXT:       "line": 21,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 254,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 258,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "c",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 271,
// CHECK-NEXT:       "line": 22,
// CHECK-NEXT:       "col": 11,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 265,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 271,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "d",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "float"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 242,
// CHECK-NEXT:     "line": 20,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 242,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 242,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "C::(anonymous union at {{.*}}:20:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 258,
// CHECK-NEXT:     "line": 21,
// CHECK-NEXT:     "col": 9,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 258,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 258,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "c"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 271,
// CHECK-NEXT:     "line": 22,
// CHECK-NEXT:     "col": 11,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 271,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 271,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "d"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 282,
// CHECK-NEXT:     "line": 25,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 282,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 307,
// CHECK-NEXT:      "line": 27,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 299,
// CHECK-NEXT:       "line": 26,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 295,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 299,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "e",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 302,
// CHECK-NEXT:       "col": 12,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 295,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 302,
// CHECK-NEXT:        "col": 12,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "f",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 282,
// CHECK-NEXT:     "line": 25,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 282,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 282,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "C::(anonymous struct at {{.*}}:25:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 299,
// CHECK-NEXT:     "line": 26,
// CHECK-NEXT:     "col": 9,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 299,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 299,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "e"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 302,
// CHECK-NEXT:     "col": 12,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 302,
// CHECK-NEXT:      "col": 12,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 302,
// CHECK-NEXT:      "col": 12,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "f"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 321,
// CHECK-NEXT:   "line": 30,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 314,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 358,
// CHECK-NEXT:    "line": 34,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "D",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 321,
// CHECK-NEXT:     "line": 30,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 314,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 321,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "D",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 331,
// CHECK-NEXT:     "line": 31,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 327,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 331,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 340,
// CHECK-NEXT:     "line": 32,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 336,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 344,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int[10]"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 353,
// CHECK-NEXT:     "line": 33,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 349,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 355,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "c",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int[]"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 368,
// CHECK-NEXT:   "line": 36,
// CHECK-NEXT:   "col": 7,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 362,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 5
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 368,
// CHECK-NEXT:    "col": 7,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "E",
// CHECK-NEXT:  "tagUsed": "union"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 378,
// CHECK-NEXT:   "line": 38,
// CHECK-NEXT:   "col": 7,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 372,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 5
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 378,
// CHECK-NEXT:    "col": 7,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "F",
// CHECK-NEXT:  "tagUsed": "union"
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 388,
// CHECK-NEXT:   "line": 40,
// CHECK-NEXT:   "col": 7,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 382,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 5
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 460,
// CHECK-NEXT:    "line": 47,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "previousDecl": "0x{{.*}}",
// CHECK-NEXT:  "name": "E",
// CHECK-NEXT:  "tagUsed": "union",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasVariantMembers": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 388,
// CHECK-NEXT:     "line": 40,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 382,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 388,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "E",
// CHECK-NEXT:    "tagUsed": "union"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 398,
// CHECK-NEXT:     "line": 41,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 394,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 398,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 407,
// CHECK-NEXT:     "line": 42,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 403,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 407,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 410,
// CHECK-NEXT:     "col": 10,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 403,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 410,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "c",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 419,
// CHECK-NEXT:     "line": 43,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 415,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 423,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 2
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "d",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 423,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 423,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "12",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 423,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 423,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "12"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 433,
// CHECK-NEXT:     "line": 44,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 429,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 435,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 435,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 435,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "0",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 435,
// CHECK-NEXT:          "col": 9,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 435,
// CHECK-NEXT:          "col": 9,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "0"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 444,
// CHECK-NEXT:     "line": 45,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 440,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 448,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 2
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "e",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "isBitfield": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantExpr",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 448,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 448,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "10",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "IntegerLiteral",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 448,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 448,
// CHECK-NEXT:          "col": 11,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "prvalue",
// CHECK-NEXT:        "value": "10"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 457,
// CHECK-NEXT:     "line": 46,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 454,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 457,
// CHECK-NEXT:      "col": 6,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "B *"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 470,
// CHECK-NEXT:   "line": 49,
// CHECK-NEXT:   "col": 7,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 464,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 5
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 574,
// CHECK-NEXT:    "line": 62,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "G",
// CHECK-NEXT:  "tagUsed": "union",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasVariantMembers": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 470,
// CHECK-NEXT:     "line": 49,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 464,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 470,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "G",
// CHECK-NEXT:    "tagUsed": "union"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 476,
// CHECK-NEXT:     "line": 50,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 476,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 498,
// CHECK-NEXT:      "line": 52,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 493,
// CHECK-NEXT:       "line": 51,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 489,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 493,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "a",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 500,
// CHECK-NEXT:     "line": 52,
// CHECK-NEXT:     "col": 5,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 476,
// CHECK-NEXT:      "line": 50,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 500,
// CHECK-NEXT:      "line": 52,
// CHECK-NEXT:      "col": 5,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "struct (unnamed at {{.*}}:50:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 506,
// CHECK-NEXT:     "line": 54,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 506,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 540,
// CHECK-NEXT:      "line": 57,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "union",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasVariantMembers": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 522,
// CHECK-NEXT:       "line": 55,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 518,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 522,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "c",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 535,
// CHECK-NEXT:       "line": 56,
// CHECK-NEXT:       "col": 11,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 529,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 535,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "d",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "float"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 506,
// CHECK-NEXT:     "line": 54,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 506,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 506,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "G::(anonymous union at {{.*}}:54:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 522,
// CHECK-NEXT:     "line": 55,
// CHECK-NEXT:     "col": 9,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 522,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 522,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "c"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 535,
// CHECK-NEXT:     "line": 56,
// CHECK-NEXT:     "col": 11,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 535,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 535,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "d"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 546,
// CHECK-NEXT:     "line": 59,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 546,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 571,
// CHECK-NEXT:      "line": 61,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 563,
// CHECK-NEXT:       "line": 60,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 559,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 563,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "e",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 566,
// CHECK-NEXT:       "col": 12,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 559,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 566,
// CHECK-NEXT:        "col": 12,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "f",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 546,
// CHECK-NEXT:     "line": 59,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 6
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 546,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 546,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "G::(anonymous struct at {{.*}}:59:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 563,
// CHECK-NEXT:     "line": 60,
// CHECK-NEXT:     "col": 9,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 563,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 563,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "e"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 566,
// CHECK-NEXT:     "col": 12,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 566,
// CHECK-NEXT:      "col": 12,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 566,
// CHECK-NEXT:      "col": 12,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "f"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 585,
// CHECK-NEXT:   "line": 64,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 5
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 578,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 592,
// CHECK-NEXT:    "col": 15,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isReferenced": true,
// CHECK-NEXT:  "name": "Base1",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 585,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 578,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Base1",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 585,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base1aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1 &(const Base1 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 585,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 585,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 585,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Base1 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 585,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base1aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1 &(Base1 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 585,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 585,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 585,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Base1 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 585,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Base1",
// CHECK-NEXT:    "mangledName": "_ZN5Base1D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 602,
// CHECK-NEXT:   "line": 65,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 5
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 595,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 609,
// CHECK-NEXT:    "col": 15,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isReferenced": true,
// CHECK-NEXT:  "name": "Base2",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 602,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 595,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Base2",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 602,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base2aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base2 &(const Base2 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 602,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 602,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 602,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Base2 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 602,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base2aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base2 &(Base2 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 602,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 602,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 602,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Base2 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 602,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 602,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Base2",
// CHECK-NEXT:    "mangledName": "_ZN5Base2D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 619,
// CHECK-NEXT:   "line": 66,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 5
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 612,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 626,
// CHECK-NEXT:    "col": 15,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isReferenced": true,
// CHECK-NEXT:  "name": "Base3",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 619,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 612,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Base3",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 619,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base3aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base3 &(const Base3 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 619,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 619,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 619,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Base3 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 619,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN5Base3aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base3 &(Base3 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 619,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 619,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 619,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Base3 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 619,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Base3",
// CHECK-NEXT:    "mangledName": "_ZN5Base3D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 637,
// CHECK-NEXT:   "line": 68,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 630,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 656,
// CHECK-NEXT:    "line": 69,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived1",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "public",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "none"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 637,
// CHECK-NEXT:     "line": 68,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 630,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 637,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived1",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 667,
// CHECK-NEXT:   "line": 71,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 660,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 694,
// CHECK-NEXT:    "line": 72,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived2",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "private",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "private"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 667,
// CHECK-NEXT:     "line": 71,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 660,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 667,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived2",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 705,
// CHECK-NEXT:   "line": 74,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 698,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 732,
// CHECK-NEXT:    "line": 75,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived3",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "public",
// CHECK-NEXT:    "isVirtual": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "none"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 705,
// CHECK-NEXT:     "line": 74,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 698,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived3",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 705,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived3aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived3 &(const Derived3 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 705,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Derived3 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 705,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived3aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived3 &(Derived3 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 705,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Derived3 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 705,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 705,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Derived3",
// CHECK-NEXT:    "mangledName": "_ZN8Derived3D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 743,
// CHECK-NEXT:   "line": 77,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 736,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 794,
// CHECK-NEXT:    "line": 78,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived4",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "public",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "none"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "public",
// CHECK-NEXT:    "isVirtual": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base2"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "none"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "protected",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base3"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "protected"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 743,
// CHECK-NEXT:     "line": 77,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 736,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived4",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 743,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived4aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived4 &(const Derived4 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 743,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 743,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 743,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Derived4 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 743,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived4aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived4 &(Derived4 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 743,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 743,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 743,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Derived4 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 743,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 743,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Derived4",
// CHECK-NEXT:    "mangledName": "_ZN8Derived4D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 805,
// CHECK-NEXT:   "line": 80,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 798,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 842,
// CHECK-NEXT:    "line": 81,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived5",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "protected",
// CHECK-NEXT:    "isVirtual": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Base1"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "protected"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 805,
// CHECK-NEXT:     "line": 80,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 798,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived5",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 805,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived5aSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived5 &(const Derived5 &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 805,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 805,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 805,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const Derived5 &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 805,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN8Derived5aSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Derived5 &(Derived5 &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 805,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 8
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 805,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 805,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "Derived5 &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 805,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 805,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~Derived5",
// CHECK-NEXT:    "mangledName": "_ZN8Derived5D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 882,
// CHECK-NEXT:   "line": 84,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 875,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 919,
// CHECK-NEXT:    "line": 85,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "Derived6",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "bases": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "access": "public",
// CHECK-NEXT:    "isPackExpansion": true,
// CHECK-NEXT:    "isVirtual": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "Bases"
// CHECK-NEXT:    },
// CHECK-NEXT:    "writtenAccess": "public"
// CHECK-NEXT:   }
// CHECK-NEXT:  ],
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 882,
// CHECK-NEXT:     "line": 84,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 875,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 882,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "Derived6",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }
