#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("exits review mode")

    def run(self):
        if not self.env["runtime"]["CursorManager"].is_review_mode():
            self.env["runtime"]["OutputManager"].present_text(
                _("Not in Review Mode"), interrupt=True
            )
            return

        self.env["runtime"]["CursorManager"].clear_review_cursor()
        self.env["runtime"]["OutputManager"].present_text(
            _("Exiting Review Mode"), interrupt=True
        )

    def set_callback(self, callback):
        pass
