#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import mark_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("copies last presented text to the clipboard")

    def run(self):
        last_echo = self.env["runtime"]["OutputManager"].get_last_echo()
        if last_echo.rstrip() != "":
            last_echo = last_echo.rstrip()
        self.env["runtime"]["MemoryManager"].add_value_to_first_index(
            "clipboardHistory", last_echo
        )
        self.env["runtime"]["OutputManager"].present_text(
            last_echo, sound_icon="CopyToClipboard", interrupt=True
        )

    def set_callback(self, callback):
        pass
