#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cat Cafe Manager
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250406.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='cat-cafe-manager'
GAME_NAME='Cat Cafe Manager'

ARCHIVE_BASE_0_NAME='setup_cat_cafe_manager_1.2.490-windows_(64bit)_(64857).exe'
ARCHIVE_BASE_0_MD5='02c9bb4a7d0bb9e0827a72693655fa8b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.2.490-gog64857'
ARCHIVE_BASE_0_SIZE='609119'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/cat_cafe_manager'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
catcafe.exe'
CONTENT_GAME_DATA_FILES='
catcafe.pck'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Cat Cafe Manager'

APP_MAIN_EXE='catcafe.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Convert the shipped icon to standard sizes

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
convert"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

## Convert the shipped icon to standard sizes
icons_temporary_directory="${PLAYIT_WORKDIR}/icons"
mkdir --parents "$icons_temporary_directory"
icon_extract_png_from_file 'APP_MAIN_ICON' "$icons_temporary_directory"
icon_source="${PLAYIT_WORKDIR}/icons/catcafe.exe_14_GODOT_ICON-0.png"
icon_destination_128="${PLAYIT_WORKDIR}/icons/icon_128.png"
icon_destination_256="${PLAYIT_WORKDIR}/icons/icon_256.png"
convert "$icon_source" -resize 128x128 "$icon_destination_128"
convert "$icon_source" -resize 256x256 "$icon_destination_256"
rm "${PLAYIT_WORKDIR}/icons"/catcafe.exe_14_GODOT_ICON-?.png
icons_include_from_directory 'PKG_DATA' 'APP_MAIN' "$icons_temporary_directory"
rmdir "$icons_temporary_directory"

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
