/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "statusdialog.h"
#include <QVBoxLayout>
#include <QFile>
#include <QTextStream>

StatusDialog::StatusDialog(QWidget *parent) :
    QDialog(parent)
{
    this->setWindowFlags(Qt::Dialog);
    setWindowTitle(tr("About"));
    initUI();
    getActivationCode();
}

StatusDialog::~StatusDialog()
{

}

void StatusDialog::initUI()
{
    this->setFixedSize(450, 408);
    QVBoxLayout *vLyt = new QVBoxLayout(this);
    vLyt->setContentsMargins(24, 16, 24, 40);
    vLyt->setSpacing(8);

    mLogoLabel = new QLabel(this);

    // 版本号
    mVersionFrame = new QFrame(this);
    QHBoxLayout *mVersionLyt = new QHBoxLayout(mVersionFrame);
    mVersionLyt->setSpacing(16);
    mVersionFrame->setFixedHeight(36);
    mVersionFrame->setFrameShape(QFrame::NoFrame);
    mVersionLabel_1 = new QLabel(mVersionFrame);
    mVersionLabel_2 = new FixLabel(mVersionFrame);
    mVersionLabel_1->setFixedWidth(100);
    mVersionLyt->addWidget(mVersionLabel_1);
    mVersionLyt->addWidget(mVersionLabel_2);

    // 系统状态
    mStatusFrame = new QFrame(this);
    QHBoxLayout *mStatusLyt = new QHBoxLayout(mStatusFrame);
    mStatusLyt->setSpacing(16);
    mStatusFrame->setFixedHeight(36);
    mStatusFrame->setFrameShape(QFrame::NoFrame);
    mStatusLabel_1 = new FixLabel(mStatusFrame);
    mStatusLabel_2 = new QLabel(mStatusFrame);
    mStatusLabel_1->setFixedWidth(100);
    mStatusLyt->addWidget(mStatusLabel_1);
    mStatusLyt->addWidget(mStatusLabel_2);

    // 激活码
    mActivationFrame = new QFrame(this);
    QHBoxLayout *mActivationLyt = new QHBoxLayout(mActivationFrame);
    mActivationLyt->setSpacing(16);
    mActivationFrame->setFixedHeight(36);
    mActivationFrame->setFrameShape(QFrame::NoFrame);
    mActivationCodeLabel_1 = new FixLabel(tr("Activation Code"), mActivationFrame);
    mActivationCodeLabel_2 = new FixLabel(mActivationFrame);
    mActivationCodeLabel_1->setFixedWidth(100);
    mActivationLyt->addWidget(mActivationCodeLabel_1);
    mActivationLyt->addWidget(mActivationCodeLabel_2);

    // 序列号
    mSerialFrame = new QFrame(this);
    QHBoxLayout *mSerialLyt = new QHBoxLayout(mSerialFrame);
    mSerialLyt->setSpacing(16);
    mSerialFrame->setFixedHeight(36);
    mSerialFrame->setFrameShape(QFrame::NoFrame);
    mSerialLabel_1 = new QLabel(mSerialFrame);
    mSerialLabel_2 = new FixLabel(mSerialFrame);
    mSerialLabel_1->setFixedWidth(100);
    mSerialLyt->addWidget(mSerialLabel_1);
    mSerialLyt->addWidget(mSerialLabel_2);

    // 服务到期时间
    mTimeFrame = new QFrame(this);
    QHBoxLayout *mTimeLyt = new QHBoxLayout(mTimeFrame);
    mTimeLyt->setSpacing(16);
    mTimeFrame->setFixedHeight(36);
    mTimeFrame->setFrameShape(QFrame::NoFrame);
    mTimeLabel_1 = new FixLabel(mTimeFrame);
    mTimeLabel_2 = new QLabel(mTimeFrame);
    mTimeLabel_1->setFixedWidth(100);
    mTimeLyt->addWidget(mTimeLabel_1);
    mTimeLyt->addWidget(mTimeLabel_2);

    mExtentBtn = new QPushButton(this);
    mExtentBtn->setFixedHeight(40);

    vLyt->addWidget(mLogoLabel);
    vLyt->addSpacing(24);
    vLyt->addWidget(mVersionFrame);
    vLyt->addWidget(mStatusFrame);
    vLyt->addWidget(mActivationFrame);
    vLyt->addWidget(mSerialFrame);
    vLyt->addWidget(mTimeFrame);
    vLyt->addStretch();
    vLyt->addWidget(mExtentBtn);
}

void StatusDialog::getActivationCode()
{
    QString filePath = "/etc/.kyactivation";
    QFile file(filePath);
    if (file.exists()) {
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            mActivationFrame->hide();
            return;
        }
        QString str = file.readAll();
        file.close();
        mActivationCodeLabel_2->setText(str);
    } else {
        mActivationFrame->hide();
    }
}
