// Copyright (c) 2016-2020 Dr. Colin Hirsch and Daniel Frey
// Please see LICENSE for license or visit https://github.com/taocpp/PEGTL/

#ifndef TAO_JSON_PEGTL_INTERNAL_EOL_HPP
#define TAO_JSON_PEGTL_INTERNAL_EOL_HPP

#include "../config.hpp"

#include "enable_control.hpp"

#include "../type_list.hpp"

namespace TAO_JSON_PEGTL_NAMESPACE::internal
{
   struct eol
   {
      using rule_t = eol;
      using subs_t = empty_list;

      template< typename ParseInput >
      [[nodiscard]] static bool match( ParseInput& in ) noexcept( noexcept( ParseInput::eol_t::match( in ) ) )
      {
         return ParseInput::eol_t::match( in ).first;
      }
   };

   template<>
   inline constexpr bool enable_control< eol > = false;

}  // namespace TAO_JSON_PEGTL_NAMESPACE::internal

#endif
