function __fish_complete_magick
    complete -c $argv -o adjoin -d 'Join images into a single multi-image file'
    complete -c $argv -o affine -d 'Affine transform matrix [matrix]'
    complete -c $argv -o antialias -d 'Remove pixel-aliasing'
    complete -c $argv -o authenticate -d 'Decipher image with this password [password]'
    complete -c $argv -o background -d 'Background color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o bias -d 'Add bias when convolving an image [value]'
    complete -c $argv -o black-point-compensation -d 'Use black point compensation'
    complete -c $argv -o blue-primary -d 'Chromaticity blue primary point [point]'
    complete -c $argv -o bordercolor -d 'Border color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o caption -d 'Assign a caption to an image [string]'
    complete -c $argv -o colors -d 'Preferred number of colors in the image [value]'
    complete -c $argv -o colorspace -d 'Alternate image colorspace [type]' -xa '(convert -list colorspace)'
    complete -c $argv -o comment -d 'Annotate image with comment [string]'
    complete -c $argv -o compose -d 'Set image composite operator [operator]'
    complete -c $argv -o compress -d 'Type of pixel compression when writing the image [type]' -xa '(convert -list compress)'
    complete -c $argv -o decipher -d 'magick cipher pixels to plain pixels'
    complete -c $argv -o define -d 'Define one or more image format options [format:option]'
    complete -c $argv -o delay -d 'Display the next image after pausing [value]'
    complete -c $argv -o density -d 'Horizontal and vertical density of the image [geometry]'
    complete -c $argv -o depth -d 'Image depth [value]'
    complete -c $argv -o direction -d 'Render text right-to-left or left-to-right [type]' -xa '(convert -list direction)'
    complete -c $argv -o display -d 'Get image or font from this X server [server]'
    complete -c $argv -o dispose -d 'Layer disposal method [method]' -xa '(convert -list dispose)'
    complete -c $argv -o dither -d 'Apply error diffusion to image [method]' -xa '(convert -list dither)'
    complete -c $argv -o encipher -d 'magick plain pixels to cipher pixels'
    complete -c $argv -o encoding -d 'Encoding type [type text]' -xa '(__fish_print_encodings)'
    complete -c $argv -o endian -d 'Endianness (MSB or LSB) of the image [type]' -xa '(convert -list endian)'
    complete -c $argv -o family -d 'Render text with this font family [name]' -xa '(__fish_complete_convert_options family)'
    complete -c $argv -o fill -d 'Color to use when filling a graphic primitive [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o filter -d 'Use this filter when resizing an image [type]' -xa '(convert -list filter)'
    complete -c $argv -o flatten -d 'flatten a sequence of images'
    complete -c $argv -o font -d 'Render text with this font [name]' -xa '(__fish_complete_convert_options font)'
    complete -c $argv -o format -d 'Output formatted image characteristics ["string"]'
    complete -c $argv -o fuzz -d 'Colors within this distance are considered equal [distance]'
    complete -c $argv -o gravity -d 'Horizontal and vertical text placement [type]' -xa '(convert -list gravity)'
    complete -c $argv -o green-primary -d 'Chromaticity green primary point [point]'
    complete -c $argv -o intent -d 'Type of rendering intent when managing the image color [type]' -xa '(convert -list intent)'
    complete -c $argv -o interlace -d 'Type of image interlacing scheme [type]' -xa '(convert -list interlace)'
    complete -c $argv -o interpolate -d 'Pixel color interpolation method [method]' -xa '(convert -list interpolate)'
    complete -c $argv -o kerning -d 'Set the space between two letters [value]'
    complete -c $argv -o label -d 'Assign a label to an image [string]'
    complete -c $argv -o limit -d 'Pixel cache resource limit [type value]' -x
    complete -c $argv -o loop -d 'Add Netscape loop extension to your GIF animation [iterations]'
    complete -c $argv -o mask -d 'Associate a mask with the image [filename]' -r
    complete -c $argv -o matte -d 'store matte channel if the image has one'
    complete -c $argv -o mattecolor -d 'Frame color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o monitor -d 'Monitor progress'
    complete -c $argv -o orient -d 'Image orientation [type]' -xa '(convert -list orientation)'
    complete -c $argv -o origin -d 'image origin'
    complete -c $argv -o page -d 'Size and location of an image canvas (setting) [geometry]'
    complete -c $argv -o ping -d 'Efficiently determine image attributes'
    complete -c $argv -o pointsize -d 'Font point size [value]'
    complete -c $argv -o preview -d 'Image preview type [type]' -xa '(convert -list preview)'
    complete -c $argv -o quality -d 'JPEG/MIFF/PNG compression level [value]'
    complete -c $argv -o quiet -d 'Suppress all warning messages'
    complete -c $argv -o red-primary -d 'Chromaticity red primary point [point]'
    complete -c $argv -o regard-warnings -d 'Pay attention to warning messages'
    complete -c $argv -o repage -d 'size and location of an image canvas'
    complete -c $argv -o sampling-factor -d 'Horizontal and vertical sampling factor [geometry]'
    complete -c $argv -o scene -d 'Image scene number [value]'
    complete -c $argv -o seed -d 'Seed a new sequence of pseudo-random numbers [value]'
    complete -c $argv -o size -d 'Width and height of image [geometry]'
    complete -c $argv -o statistic -d 'replace pixels with corresponding stats from the neighborhood'
    complete -c $argv -o stretch -d 'Render text with this font stretch [type]' -xa '(convert -list stretch)'
    complete -c $argv -o stroke -d 'Graphic primitive stroke color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o strokewidth -d 'Graphic primitive stroke width [value]'
    complete -c $argv -o style -d 'Render text with this font style [type]' -xa '(convert -list style)'
    complete -c $argv -o support -d 'resize support: > 1.0 blurry, < 1.0 sharp'
    complete -c $argv -o synchronize -d 'Synchronize image to storage device'
    complete -c $argv -o taint -d 'Declare the image as modified'
    complete -c $argv -o texture -d 'Name of texture to tile onto the image background [filename]' -r
    complete -c $argv -o tile-offset -d 'Tile offset [geometry]'
    complete -c $argv -o treedepth -d 'Color tree depth [value]'
    complete -c $argv -o transparent-color -d 'Transparent color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o undercolor -d 'Annotation bounding box color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o units -d 'The units of image resolution [type]' -xa '(convert -list units)'
    complete -c $argv -o verbose -d 'Print detailed information about the image'
    complete -c $argv -o view -d 'FlashPix viewing transforms'
    complete -c $argv -o virtual-pixel -d 'Virtual pixel access method [method]' -xa '(convert -list virtual-pixel)'
    complete -c $argv -o weight -d 'Render text with this font weight [type]' -x
    complete -c $argv -o white-point -d 'Chromaticity white point [point]'
    complete -c $argv -o adaptive-blur -d 'Adaptively blur pixels; decrease effect near edges [geometry]'
    complete -c $argv -o adaptive-resize -d "Adaptively resize image using 'mesh' interpolation [geometry]"
    complete -c $argv -o adaptive-sharpen -d 'Adaptively sharpen pixels; increase effect near edges [geometry]'
    complete -c $argv -o annotate -d 'Annotate the image with text [geometry text]'
    complete -c $argv -o auto-orient -d 'Automagically orient (rotate) image'
    complete -c $argv -o bilateral-blur -d 'non-linear, edge-preserving, and noise-reducing smoothing filter'
    complete -c $argv -o black-threshold -d 'Force all pixels below the threshold into black [value]'
    complete -c $argv -o blue-shift -d 'Simulate a scene at nighttime in the moonlight [factor]'
    complete -c $argv -o blur -d 'Reduce image noise and reduce detail levels [geometry]'
    complete -c $argv -o border -d 'Surround image with a border of color [geometry]'
    complete -c $argv -o channel -d 'set the image channel mask'
    complete -c $argv -o charcoal -d 'Simulate a charcoal drawing [radius]'
    complete -c $argv -o chop -d 'Remove pixels from the image interior [geometry]'
    complete -c $argv -o clip -d 'Clip along the first path from the 8BIM profile'
    complete -c $argv -o clip-mask -d 'Associate a clip mask with the image [filename]' -r
    complete -c $argv -o clip-path -d 'Clip along a named path from the 8BIM profile [id]'
    complete -c $argv -o colorize -d 'Colorize the image with the fill color [value]'
    complete -c $argv -o color-matrix -d 'Apply color correction to the image [matrix]'
    complete -c $argv -o contrast -d 'Enhance or reduce the image contrast'
    complete -c $argv -o contrast-stretch -d 'Improve contrast by stretching the intensity range [geometry]'
    complete -c $argv -o convolve -d 'Apply a convolution kernel to the image [coefficients]'
    complete -c $argv -o cycle -d 'Cycle the image colormap [amount]'
    complete -c $argv -o despeckle -d 'Reduce the speckles within an image'
    complete -c $argv -o draw -d 'Annotate the image with a graphic primitive [string]'
    complete -c $argv -o edge -d 'Apply a filter to detect edges in the image [radius]'
    complete -c $argv -o emboss -d 'Emboss an image [radius]'
    complete -c $argv -o enhance -d 'Apply a digital filter to enhance a noisy image'
    complete -c $argv -o equalize -d 'Perform histogram equalization to an image'
    complete -c $argv -o evaluate -d 'Alter channel pixels based on expression [operator]'
    complete -c $argv -o extent -d 'Set the image size [geometry]'
    complete -c $argv -o extract -d 'Extract area from image [geometry]'
    complete -c $argv -o fft -d 'Implements the discrete Fourier transform (DFT)'
    complete -c $argv -o flip -d 'Flip image vertically'
    complete -c $argv -o floodfill -d 'Color floodfill the image with color [geometry]'
    complete -c $argv -o flop -d 'Flop image horizontally'
    complete -c $argv -o frame -d 'Surround image with an ornamental border [geometry]'
    complete -c $argv -o function -d 'Apply function over image values [name parameters]' -xa '(convert -list function)'
    complete -c $argv -o gamma -d 'Level of gamma correction [value]'
    complete -c $argv -o gaussian-blur -d 'Reduce image noise and reduce detail levels [geometry]'
    complete -c $argv -o geometry -d 'Preferred size or location of the image [geometry]'
    complete -c $argv -o identify -d 'Identify the format and characteristics of the image'
    complete -c $argv -o ift -d 'Implements the inverse discrete Fourier transform (DFT)'
    complete -c $argv -o implode -d 'Implode image pixels about the center [amount]'
    complete -c $argv -o integral -d 'calculate the sum of values (pixel values) in the image'
    complete -c $argv -o lat -d 'Local adaptive thresholding [geometry]'
    complete -c $argv -o layers -d 'Optimize, merge,  or compare image layers [method]' -xa '(convert -list layers)'
    complete -c $argv -o level -d 'Adjust the level of image contrast [value]'
    complete -c $argv -o linear-stretch -d 'Improve contrast by stretching with saturation [geometry]'
    complete -c $argv -o median -d 'Apply a median filter to the image [geometry]'
    complete -c $argv -o mode -d 'Make each pixel the predominant color of the neighborhood [geometry]'
    complete -c $argv -o modulate -d 'Vary the brightness, saturation, and hue [value]'
    complete -c $argv -o monochrome -d 'Transform image to black and white'
    complete -c $argv -o morphology -d 'Apply a morphology method to the image [method kernel]' -xa '(convert -list morphology)'
    complete -c $argv -o motion-blur -d 'Simulate motion blur [geometry]'
    complete -c $argv -o negate -d 'Replace every pixel with its complementary color '
    complete -c $argv -o noise -d 'Add or reduce noise in an image [geometry]'
    complete -c $argv -o normalize -d 'Transform image to span the full range of colors'
    complete -c $argv -o opaque -d 'Change this color to the fill color [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o ordered-dither -d 'Add a noise pattern to the image with specific amplitudes  [NxN]'
    complete -c $argv -o paint -d 'Simulate an oil painting [radius]'
    complete -c $argv -o polaroid -d 'Simulate a Polaroid picture [angle]'
    complete -c $argv -o posterize -d 'Reduce the image to a limited number of color levels [levels]'
    complete -c $argv -o profile -d 'Add, delete, or apply an image profile [filename]' -r
    complete -c $argv -o quantize -d 'Reduce colors in this colorspace [colorspace]' -xa '(convert -list colorspace)'
    complete -c $argv -o radial-blur -d 'Radial blur the image [angle]'
    complete -c $argv -o raise -d 'Lighten/darken image edges to create a 3-D effect [value]'
    complete -c $argv -o random-threshold -d 'Random threshold the image [low,high]'
    complete -c $argv -o region -d 'Apply options to a portion of the image [geometry]'
    complete -c $argv -o render -d 'Render vector graphics'
    complete -c $argv -o resample -d 'Change the resolution of an image [geometry]'
    complete -c $argv -o resize -d 'Resize the image [geometry]'
    complete -c $argv -o roll -d 'Roll an image vertically or horizontally [geometry]'
    complete -c $argv -o rotate -d 'Apply Paeth rotation to the image [degrees]'
    complete -c $argv -o sample -d 'Scale image with pixel sampling [geometry]'
    complete -c $argv -o scale -d 'Scale the image [geometry]'
    complete -c $argv -o segment -d 'Segment an image [values]'
    complete -c $argv -o selective-blur -d 'Selectively blur pixels within a contrast threshold [geometry]'
    complete -c $argv -o sepia-tone -d 'Simulate a sepia-toned photo [threshold]'
    complete -c $argv -o set -d 'Set an image property [property value]'
    complete -c $argv -o shade -d 'Shade the image using a distant light source [degrees]'
    complete -c $argv -o shadow -d 'Simulate an image shadow [geometry]'
    complete -c $argv -o sharpen -d 'Sharpen the image [geometry]'
    complete -c $argv -o shave -d 'Shave pixels from the image edges [geometry]'
    complete -c $argv -o shear -d 'Slide one edge of the image along the X or Y axis [geometry]'
    complete -c $argv -o sigmoidal-contrast -d 'Lightness rescaling using sigmoidal contrast enhancement [geometry]'
    complete -c $argv -o sketch -d 'Simulate a pencil sketch [geometry]'
    complete -c $argv -o solarize -d 'Negate all pixels above the threshold level [threshold]'
    complete -c $argv -o sort-pixels -d 'sort each scanline in ascending order of intensity'
    complete -c $argv -o splice -d 'Splice the background color into the image [geometry]'
    complete -c $argv -o spread -d 'Displace image pixels by a random amount [radius]'
    complete -c $argv -o strip -d 'Strip image of all profiles and comments'
    complete -c $argv -o swirl -d 'Swirl image pixels about the center [degrees]'
    complete -c $argv -o threshold -d 'Threshold the image [value]'
    complete -c $argv -o thumbnail -d 'Create a thumbnail of the image [geometry]'
    complete -c $argv -o tile -d 'Tile image when filling a graphic primitive [filename]' -r
    complete -c $argv -o tint -d 'Tint the image with the fill color [value]'
    complete -c $argv -o transform -d 'Affine transform image'
    complete -c $argv -o transparent -d 'Make this color transparent within the image [color]' -xa '(__fish_complete_convert_options color)'
    complete -c $argv -o transpose -d 'Flip image vertically and rotate 90 degrees'
    complete -c $argv -o transverse -d 'Flop image horizontally and rotate 270 degrees'
    complete -c $argv -o trim -d 'Trim image edges'
    complete -c $argv -o type -d 'Image type [type]' -xa '(convert -list type)'
    complete -c $argv -o unique-colors -d 'Discard all but one of any pixel color'
    complete -c $argv -o unsharp -d 'Sharpen the image [geometry]'
    complete -c $argv -o vignette -d 'Soften the edges of the image in vignette style [geometry]'
    complete -c $argv -o wave -d 'Alter an image along a sine wave [geometry]'
    complete -c $argv -o white-threshold -d 'Force all pixels above the threshold into white [value]'
    complete -c $argv -o channel-extract -d 'extract the channels in order'
    complete -c $argv -o channel-inject -d 'inject the channels in order'
    complete -c $argv -o channel-swap -d 'swap the channels'
    complete -c $argv -o affinity -d 'transform image colors to match this set of colors'
    complete -c $argv -o append -d 'Append an image sequence'
    complete -c $argv -o clut -d 'Apply a color lookup table to the image'
    complete -c $argv -o coalesce -d 'Merge a sequence of images'
    complete -c $argv -o combine -d 'Combine a sequence of images'
    complete -c $argv -o composite -d 'Composite image'
    complete -c $argv -o crop -d 'Cut out a rectangular region of the image [geometry]'
    complete -c $argv -o deconstruct -d 'Break down an image sequence into constituent parts'
    complete -c $argv -o evaluate-sequence -d 'Alter channel pixels based on expression [operator]'
    complete -c $argv -o flatten -d 'Flatten a sequence of images'
    complete -c $argv -o fx -d 'Apply mathematical expression to an image channel(s) [expression]'
    complete -c $argv -o hald-clut -d 'Apply a Hald color lookup table to the image'
    complete -c $argv -o morph -d 'Morph an image sequence [value]'
    complete -c $argv -o mosaic -d 'Create a mosaic from an image sequence'
    complete -c $argv -o process -d 'Process the image with a custom image filter [arguments]' -xa '(convert -list filter)'
    complete -c $argv -o separate -d 'Separate an image channel into a grayscale image'
    complete -c $argv -o smush -d 'Smush an image sequence together [geometry]'
    complete -c $argv -o write -d 'Write images to this file [filename]' -r
    complete -c $argv -o clone -d 'Clone an image [indexes]'
    complete -c $argv -o delete -d 'Delete the image from the image sequence [indexes]'
    complete -c $argv -o duplicate -d 'Duplicate an image one or more times [count,indexes]'
    complete -c $argv -o insert -d 'Insert last image into the image sequence [index]'
    complete -c $argv -o swap -d 'Swap two images in the image sequence [indexes]'
    complete -c $argv -o debug -d 'Display copious debugging information [events]' -xa '(convert -list debug)'
    complete -c $argv -o help -d 'Print program options'
    complete -c $argv -o log -d 'Format of debugging information [format]' -xa '(__fish_complete_convert_options format)'
    complete -c $argv -o list -d 'Print a list of supported option arguments [type]' -xa '(convert -list list)'
    complete -c $argv -o version -d 'Print version information'
end
