// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file key_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "key_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "key_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ImportantStruct_type_identifier(
        TypeIdentifierPair& type_ids_ImportantStruct)
{

    ReturnCode_t return_code_ImportantStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ImportantStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ImportantStruct", type_ids_ImportantStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ImportantStruct)
    {
        StructTypeFlag struct_flags_ImportantStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ImportantStruct = "ImportantStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ImportantStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ImportantStruct;
        AppliedAnnotationSeq tmp_ann_custom_ImportantStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_ImportantStruct;
        if (!tmp_ann_custom_ImportantStruct.empty())
        {
            ann_custom_ImportantStruct = tmp_ann_custom_ImportantStruct;
        }

        CompleteTypeDetail detail_ImportantStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ImportantStruct, ann_custom_ImportantStruct, type_name_ImportantStruct.to_string());
        CompleteStructHeader header_ImportantStruct;
        header_ImportantStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ImportantStruct);
        CompleteStructMemberSeq member_seq_ImportantStruct;
        {
            TypeIdentifierPair type_ids_my_first_value;
            ReturnCode_t return_code_my_first_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_first_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_first_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_first_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_first_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_first_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_my_first_value = 0x00000000;
            bool common_my_first_value_ec {false};
            CommonStructMember common_my_first_value {TypeObjectUtils::build_common_struct_member(member_id_my_first_value, member_flags_my_first_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_first_value, common_my_first_value_ec))};
            if (!common_my_first_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_first_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_first_value = "my_first_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_first_value;
            ann_custom_ImportantStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_my_first_value;
            eprosima::fastcdr::optional<std::string> unit_my_first_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_my_first_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_my_first_value;
            eprosima::fastcdr::optional<std::string> hash_id_my_first_value;
            if (unit_my_first_value.has_value() || min_my_first_value.has_value() || max_my_first_value.has_value() || hash_id_my_first_value.has_value())
            {
                member_ann_builtin_my_first_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_my_first_value, min_my_first_value, max_my_first_value, hash_id_my_first_value);
            }
            if (!tmp_ann_custom_my_first_value.empty())
            {
                ann_custom_ImportantStruct = tmp_ann_custom_my_first_value;
            }
            CompleteMemberDetail detail_my_first_value = TypeObjectUtils::build_complete_member_detail(name_my_first_value, member_ann_builtin_my_first_value, ann_custom_ImportantStruct);
            CompleteStructMember member_my_first_value = TypeObjectUtils::build_complete_struct_member(common_my_first_value, detail_my_first_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ImportantStruct, member_my_first_value);
        }
        {
            TypeIdentifierPair type_ids_my_second_value;
            ReturnCode_t return_code_my_second_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_second_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_second_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_second_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_second_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_second_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_second_value = 0x00000001;
            bool common_my_second_value_ec {false};
            CommonStructMember common_my_second_value {TypeObjectUtils::build_common_struct_member(member_id_my_second_value, member_flags_my_second_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_second_value, common_my_second_value_ec))};
            if (!common_my_second_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_second_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_second_value = "my_second_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_second_value;
            ann_custom_ImportantStruct.reset();
            CompleteMemberDetail detail_my_second_value = TypeObjectUtils::build_complete_member_detail(name_my_second_value, member_ann_builtin_my_second_value, ann_custom_ImportantStruct);
            CompleteStructMember member_my_second_value = TypeObjectUtils::build_complete_struct_member(common_my_second_value, detail_my_second_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ImportantStruct, member_my_second_value);
        }
        {
            TypeIdentifierPair type_ids_my_third_value;
            ReturnCode_t return_code_my_third_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_third_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_third_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_third_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_third_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_third_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_my_third_value = 0x00000002;
            bool common_my_third_value_ec {false};
            CommonStructMember common_my_third_value {TypeObjectUtils::build_common_struct_member(member_id_my_third_value, member_flags_my_third_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_third_value, common_my_third_value_ec))};
            if (!common_my_third_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_third_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_third_value = "my_third_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_third_value;
            ann_custom_ImportantStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_my_third_value;
            eprosima::fastcdr::optional<std::string> unit_my_third_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_my_third_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_my_third_value;
            eprosima::fastcdr::optional<std::string> hash_id_my_third_value;
            if (unit_my_third_value.has_value() || min_my_third_value.has_value() || max_my_third_value.has_value() || hash_id_my_third_value.has_value())
            {
                member_ann_builtin_my_third_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_my_third_value, min_my_third_value, max_my_third_value, hash_id_my_third_value);
            }
            if (!tmp_ann_custom_my_third_value.empty())
            {
                ann_custom_ImportantStruct = tmp_ann_custom_my_third_value;
            }
            CompleteMemberDetail detail_my_third_value = TypeObjectUtils::build_complete_member_detail(name_my_third_value, member_ann_builtin_my_third_value, ann_custom_ImportantStruct);
            CompleteStructMember member_my_third_value = TypeObjectUtils::build_complete_struct_member(common_my_third_value, detail_my_third_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ImportantStruct, member_my_third_value);
        }
        CompleteStructType struct_type_ImportantStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ImportantStruct, header_ImportantStruct, member_seq_ImportantStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ImportantStruct, type_name_ImportantStruct.to_string(), type_ids_ImportantStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ImportantStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyStruct)
{

    ReturnCode_t return_code_KeyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyStruct", type_ids_KeyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyStruct)
    {
        StructTypeFlag struct_flags_KeyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyStruct = "KeyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyStruct;
        AppliedAnnotationSeq tmp_ann_custom_KeyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_KeyStruct;
        if (!tmp_ann_custom_KeyStruct.empty())
        {
            ann_custom_KeyStruct = tmp_ann_custom_KeyStruct;
        }

        CompleteTypeDetail detail_KeyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyStruct, ann_custom_KeyStruct, type_name_KeyStruct.to_string());
        CompleteStructHeader header_KeyStruct;
        header_KeyStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyStruct);
        CompleteStructMemberSeq member_seq_KeyStruct;
        {
            TypeIdentifierPair type_ids_my_short;
            ReturnCode_t return_code_my_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_my_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_short = 0x00000000;
            bool common_my_short_ec {false};
            CommonStructMember common_my_short {TypeObjectUtils::build_common_struct_member(member_id_my_short, member_flags_my_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_short, common_my_short_ec))};
            if (!common_my_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_short = "my_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_short;
            ann_custom_KeyStruct.reset();
            CompleteMemberDetail detail_my_short = TypeObjectUtils::build_complete_member_detail(name_my_short, member_ann_builtin_my_short, ann_custom_KeyStruct);
            CompleteStructMember member_my_short = TypeObjectUtils::build_complete_struct_member(common_my_short, detail_my_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyStruct, member_my_short);
        }
        {
            TypeIdentifierPair type_ids_my_long;
            ReturnCode_t return_code_my_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_my_long = 0x00000001;
            bool common_my_long_ec {false};
            CommonStructMember common_my_long {TypeObjectUtils::build_common_struct_member(member_id_my_long, member_flags_my_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_long, common_my_long_ec))};
            if (!common_my_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_long = "my_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_long;
            ann_custom_KeyStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_my_long;
            eprosima::fastcdr::optional<std::string> unit_my_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_my_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_my_long;
            eprosima::fastcdr::optional<std::string> hash_id_my_long;
            if (unit_my_long.has_value() || min_my_long.has_value() || max_my_long.has_value() || hash_id_my_long.has_value())
            {
                member_ann_builtin_my_long = TypeObjectUtils::build_applied_builtin_member_annotations(unit_my_long, min_my_long, max_my_long, hash_id_my_long);
            }
            if (!tmp_ann_custom_my_long.empty())
            {
                ann_custom_KeyStruct = tmp_ann_custom_my_long;
            }
            CompleteMemberDetail detail_my_long = TypeObjectUtils::build_complete_member_detail(name_my_long, member_ann_builtin_my_long, ann_custom_KeyStruct);
            CompleteStructMember member_my_long = TypeObjectUtils::build_complete_struct_member(common_my_long, detail_my_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyStruct, member_my_long);
        }
        {
            TypeIdentifierPair type_ids_my_string;
            ReturnCode_t return_code_my_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_my_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_my_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_my_string = 0x00000002;
            bool common_my_string_ec {false};
            CommonStructMember common_my_string {TypeObjectUtils::build_common_struct_member(member_id_my_string, member_flags_my_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_string, common_my_string_ec))};
            if (!common_my_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_string = "my_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_string;
            ann_custom_KeyStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_my_string;
            eprosima::fastcdr::optional<std::string> unit_my_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_my_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_my_string;
            eprosima::fastcdr::optional<std::string> hash_id_my_string;
            if (unit_my_string.has_value() || min_my_string.has_value() || max_my_string.has_value() || hash_id_my_string.has_value())
            {
                member_ann_builtin_my_string = TypeObjectUtils::build_applied_builtin_member_annotations(unit_my_string, min_my_string, max_my_string, hash_id_my_string);
            }
            if (!tmp_ann_custom_my_string.empty())
            {
                ann_custom_KeyStruct = tmp_ann_custom_my_string;
            }
            CompleteMemberDetail detail_my_string = TypeObjectUtils::build_complete_member_detail(name_my_string, member_ann_builtin_my_string, ann_custom_KeyStruct);
            CompleteStructMember member_my_string = TypeObjectUtils::build_complete_struct_member(common_my_string, detail_my_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyStruct, member_my_string);
        }
        {
            TypeIdentifierPair type_ids_my_important_struct;
            ReturnCode_t return_code_my_important_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_important_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "ImportantStruct", type_ids_my_important_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_important_struct)
            {
            ::register_ImportantStruct_type_identifier(type_ids_my_important_struct);
            }
            StructMemberFlag member_flags_my_important_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_my_important_struct = 0x00000003;
            bool common_my_important_struct_ec {false};
            CommonStructMember common_my_important_struct {TypeObjectUtils::build_common_struct_member(member_id_my_important_struct, member_flags_my_important_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_important_struct, common_my_important_struct_ec))};
            if (!common_my_important_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_important_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_important_struct = "my_important_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_important_struct;
            ann_custom_KeyStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_my_important_struct;
            eprosima::fastcdr::optional<std::string> unit_my_important_struct;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_my_important_struct;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_my_important_struct;
            eprosima::fastcdr::optional<std::string> hash_id_my_important_struct;
            if (unit_my_important_struct.has_value() || min_my_important_struct.has_value() || max_my_important_struct.has_value() || hash_id_my_important_struct.has_value())
            {
                member_ann_builtin_my_important_struct = TypeObjectUtils::build_applied_builtin_member_annotations(unit_my_important_struct, min_my_important_struct, max_my_important_struct, hash_id_my_important_struct);
            }
            if (!tmp_ann_custom_my_important_struct.empty())
            {
                ann_custom_KeyStruct = tmp_ann_custom_my_important_struct;
            }
            CompleteMemberDetail detail_my_important_struct = TypeObjectUtils::build_complete_member_detail(name_my_important_struct, member_ann_builtin_my_important_struct, ann_custom_KeyStruct);
            CompleteStructMember member_my_important_struct = TypeObjectUtils::build_complete_struct_member(common_my_important_struct, detail_my_important_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyStruct, member_my_important_struct);
        }
        CompleteStructType struct_type_KeyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyStruct, header_KeyStruct, member_seq_KeyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyStruct, type_name_KeyStruct.to_string(), type_ids_KeyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
