/*
 * Copyright(C) 1999-2020 National Technology & Engineering Solutions
 * of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
 * NTESS, the U.S. Government retains certain rights in this software.
 *
 * See packages/seacas/LICENSE for details
 */
#include <string.h>

#if defined ADDC_
#define INITSTICK initstick_
#define INITSERIF initserif_
#define INITROMAN initroman_
#else
#define INITSTICK initstick
#define INITSERIF initserif
#define INITROMAN initroman
#endif

#if defined(Build64)
#define real double
#else
#define real float
#endif

static real stick_data[] = {
    -99.000, -99.000, -99.000, 4.000,   0.000,   2.213,   -1.077,  2.170,   0.603,   2.170,
    0.000,   2.213,   0.603,   1.077,   0.603,   2.170,   2.043,   1.077,   0.603,   1.077,
    2.170,   0.127,   2.043,   1.077,   2.043,   -1.553,  2.170,   0.127,   1.567,   -1.680,
    2.043,   -1.553,  1.680,   -0.713,  1.567,   -1.680,  1.317,   -0.713,  1.680,   -0.713,
    1.203,   0.127,   1.317,   -0.713,  0.603,   0.127,   1.203,   0.127,   0.713,   -2.407,
    0.603,   0.127,   -0.713,  -2.407,  0.713,   -2.407,  -0.603,  0.127,   -0.713,  -2.407,
    -1.203,  0.127,   -0.603,  0.127,   -1.317,  -0.713,  -1.203,  0.127,   -1.680,  -0.713,
    -1.317,  -0.713,  -1.567,  -1.680,  -1.680,  -0.713,  -2.043,  -1.567,  -1.567,  -1.680,
    -2.170,  0.127,   -2.043,  -1.567,  -2.043,  1.077,   -2.170,  0.127,   -0.603,  1.077,
    -2.043,  1.077,   -0.603,  1.680,   -0.603,  1.077,   -1.077,  1.667,   -0.603,  1.680,
    -1.077,  2.170,   -1.077,  1.667,   1.077,   -2.773,  0.000,   -2.773,  2.043,   -2.647,
    1.077,   -2.773,  2.407,   -2.533,  2.043,   -2.647,  2.533,   -2.407,  2.407,   -2.533,
    2.647,   -2.043,  2.533,   -2.407,  2.773,   -1.077,  2.647,   -2.043,  2.773,   0.000,
    2.773,   -1.077,  1.077,   2.773,   0.000,   2.773,   2.043,   2.647,   1.077,   2.773,
    2.407,   2.520,   2.043,   2.647,   2.533,   2.407,   2.407,   2.520,   2.647,   2.043,
    2.533,   2.407,   2.773,   1.077,   2.647,   2.043,   2.773,   0.000,   2.773,   1.077,
    -1.077,  2.773,   0.000,   2.773,   -2.043,  2.647,   -1.077,  2.773,   -2.407,  2.520,
    -2.043,  2.647,   -2.533,  2.407,   -2.407,  2.520,   -2.647,  2.043,   -2.533,  2.407,
    -2.773,  1.077,   -2.647,  2.043,   -2.773,  0.000,   -2.773,  1.077,   -1.077,  -2.773,
    0.000,   -2.773,  -2.043,  -2.647,  -1.077,  -2.773,  -2.407,  -2.533,  -2.043,  -2.647,
    -2.533,  -2.407,  -2.407,  -2.533,  -2.647,  -2.043,  -2.533,  -2.407,  -2.773,  -1.077,
    -2.647,  -2.043,  -2.773,  0.000,   -2.773,  -1.077,  1.203,   -3.500,  0.000,   -3.500,
    2.283,   -3.373,  1.203,   -3.500,  2.773,   -3.247,  2.283,   -3.373,  3.010,   -3.137,
    2.773,   -3.247,  3.137,   -3.010,  3.010,   -3.137,  3.247,   -2.773,  3.137,   -3.010,
    3.373,   -2.283,  3.247,   -2.773,  3.500,   -1.203,  3.373,   -2.283,  3.500,   0.000,
    3.500,   -1.203,  1.203,   3.487,   0.000,   3.487,   2.283,   3.373,   1.203,   3.487,
    2.773,   3.247,   2.283,   3.373,   3.010,   3.137,   2.773,   3.247,   3.137,   3.010,
    3.010,   3.137,   3.247,   2.773,   3.137,   3.010,   3.373,   2.283,   3.247,   2.773,
    3.500,   1.203,   3.373,   2.283,   3.500,   0.000,   3.500,   1.203,   -1.203,  3.487,
    0.000,   3.487,   -2.283,  3.373,   -1.203,  3.487,   -2.773,  3.247,   -2.283,  3.373,
    -3.010,  3.137,   -2.773,  3.247,   -3.137,  3.010,   -3.010,  3.137,   -3.247,  2.773,
    -3.137,  3.010,   -3.373,  2.283,   -3.247,  2.773,   -3.500,  1.203,   -3.373,  2.283,
    -3.500,  0.000,   -3.500,  1.203,   -1.203,  -3.500,  0.000,   -3.500,  -2.283,  -3.373,
    -1.203,  -3.500,  -2.773,  -3.247,  -2.283,  -3.373,  -3.010,  -3.137,  -2.773,  -3.247,
    -3.137,  -3.010,  -3.010,  -3.137,  -3.247,  -2.773,  -3.137,  -3.010,  -3.373,  -2.283,
    -3.247,  -2.773,  -3.500,  -1.203,  -3.373,  -2.283,  -3.500,  0.000,   -3.500,  -1.203,
    -99.000, -99.000, -99.000, 5.000,   -3.500,  -3.500,  3.500,   -3.500,  3.500,   -3.500,
    3.500,   3.500,   3.500,   3.500,   -3.500,  3.500,   -3.500,  3.500,   -3.500,  -3.500,
    -99.000, -99.000, -99.000, 6.000,   0.000,   -3.500,  3.500,   0.000,   3.500,   0.000,
    0.000,   3.500,   0.000,   3.500,   -3.500,  0.000,   -3.500,  0.000,   0.000,   -3.500,
    -99.000, -99.000, -99.000, 7.000,   0.000,   -3.500,  0.000,   3.500,   -3.500,  0.000,
    3.500,   0.000,   -99.000, -99.000, -99.000, 8.000,   -3.500,  -3.500,  3.500,   3.500,
    -3.500,  3.500,   3.500,   -3.500,  -99.000, -99.000, -99.000, 9.000,   -3.500,  -2.500,
    0.000,   4.500,   0.000,   4.500,   3.500,   -2.500,  3.500,   -2.500,  -3.500,  -2.500,
    -99.000, -99.000, -99.000, 10.000,  3.500,   0.000,   3.330,   1.080,   3.330,   1.080,
    2.830,   2.057,   2.830,   2.057,   2.057,   2.830,   2.057,   2.830,   1.080,   3.330,
    1.080,   3.330,   0.000,   3.500,   0.000,   3.500,   -1.080,  3.330,   -1.080,  3.330,
    -2.057,  2.830,   -2.057,  2.830,   -2.830,  2.057,   -2.830,  2.057,   -3.330,  1.080,
    -3.330,  1.080,   -3.500,  0.000,   -3.500,  0.000,   -3.330,  -1.080,  -3.330,  -1.080,
    -2.830,  -2.057,  -2.830,  -2.057,  -2.057,  -2.830,  -2.057,  -2.830,  -1.080,  -3.330,
    -1.080,  -3.330,  0.000,   -3.500,  0.000,   -3.500,  1.080,   -3.330,  1.080,   -3.330,
    2.057,   -2.830,  2.057,   -2.830,  2.830,   -2.057,  2.830,   -2.057,  3.330,   -1.080,
    3.330,   -1.080,  3.500,   0.000,   -99.000, -99.000, -99.000, 11.000,  -0.667,  0.000,
    0.667,   0.000,   0.000,   0.667,   0.000,   -0.667,  0.470,   0.470,   -0.470,  -0.470,
    -0.470,  0.470,   0.470,   -0.470,  -99.000, -99.000, -99.000, 12.000,  3.500,   5.713,
    2.423,   5.670,   4.103,   5.670,   3.500,   5.713,   4.103,   4.577,   4.103,   5.670,
    5.543,   4.577,   4.103,   4.577,   5.670,   3.627,   5.543,   4.577,   5.543,   1.947,
    5.670,   3.627,   5.067,   1.820,   5.543,   1.947,   5.180,   2.787,   5.067,   1.820,
    4.817,   2.787,   5.180,   2.787,   4.703,   3.627,   4.817,   2.787,   4.103,   3.627,
    4.703,   3.627,   4.213,   1.093,   4.103,   3.627,   2.787,   1.093,   4.213,   1.093,
    2.897,   3.627,   2.787,   1.093,   2.297,   3.627,   2.897,   3.627,   2.183,   2.787,
    2.297,   3.627,   1.820,   2.787,   2.183,   2.787,   1.933,   1.820,   1.820,   2.787,
    1.457,   1.933,   1.933,   1.820,   1.330,   3.627,   1.457,   1.933,   1.457,   4.577,
    1.330,   3.627,   2.897,   4.577,   1.457,   4.577,   2.897,   5.180,   2.897,   4.577,
    2.423,   5.167,   2.897,   5.180,   2.423,   5.670,   2.423,   5.167,   4.577,   0.727,
    3.500,   0.727,   5.543,   0.853,   4.577,   0.727,   5.907,   0.967,   5.543,   0.853,
    6.033,   1.093,   5.907,   0.967,   6.147,   1.457,   6.033,   1.093,   6.273,   2.423,
    6.147,   1.457,   6.273,   3.500,   6.273,   2.423,   4.577,   6.273,   3.500,   6.273,
    5.543,   6.147,   4.577,   6.273,   5.907,   6.020,   5.543,   6.147,   6.033,   5.907,
    5.907,   6.020,   6.147,   5.543,   6.033,   5.907,   6.273,   4.577,   6.147,   5.543,
    6.273,   3.500,   6.273,   4.577,   2.423,   6.273,   3.500,   6.273,   1.457,   6.147,
    2.423,   6.273,   1.093,   6.020,   1.457,   6.147,   0.967,   5.907,   1.093,   6.020,
    0.853,   5.543,   0.967,   5.907,   0.727,   4.577,   0.853,   5.543,   0.727,   3.500,
    0.727,   4.577,   2.423,   0.727,   3.500,   0.727,   1.457,   0.853,   2.423,   0.727,
    1.093,   0.967,   1.457,   0.853,   0.967,   1.093,   1.093,   0.967,   0.853,   1.457,
    0.967,   1.093,   0.727,   2.423,   0.853,   1.457,   0.727,   3.500,   0.727,   2.423,
    4.703,   0.000,   3.500,   0.000,   5.783,   0.127,   4.703,   0.000,   6.273,   0.253,
    5.783,   0.127,   6.510,   0.363,   6.273,   0.253,   6.637,   0.490,   6.510,   0.363,
    6.747,   0.727,   6.637,   0.490,   6.873,   1.217,   6.747,   0.727,   7.000,   2.297,
    6.873,   1.217,   7.000,   3.500,   7.000,   2.297,   4.703,   6.987,   3.500,   6.987,
    5.783,   6.873,   4.703,   6.987,   6.273,   6.747,   5.783,   6.873,   6.510,   6.637,
    6.273,   6.747,   6.637,   6.510,   6.510,   6.637,   6.747,   6.273,   6.637,   6.510,
    6.873,   5.783,   6.747,   6.273,   7.000,   4.703,   6.873,   5.783,   7.000,   3.500,
    7.000,   4.703,   2.297,   6.987,   3.500,   6.987,   1.217,   6.873,   2.297,   6.987,
    0.727,   6.747,   1.217,   6.873,   0.490,   6.637,   0.727,   6.747,   0.363,   6.510,
    0.490,   6.637,   0.253,   6.273,   0.363,   6.510,   0.127,   5.783,   0.253,   6.273,
    0.000,   4.703,   0.127,   5.783,   0.000,   3.500,   0.000,   4.703,   2.297,   0.000,
    3.500,   0.000,   1.217,   0.127,   2.297,   0.000,   0.727,   0.253,   1.217,   0.127,
    0.490,   0.363,   0.727,   0.253,   0.363,   0.490,   0.490,   0.363,   0.253,   0.727,
    0.363,   0.490,   0.127,   1.217,   0.253,   0.727,   0.000,   2.297,   0.127,   1.217,
    0.000,   3.500,   0.000,   2.297,   -99.000, -99.000, -99.000, 13.000,  0.000,   0.000,
    7.000,   0.000,   7.000,   0.000,   7.000,   7.000,   7.000,   7.000,   0.000,   7.000,
    0.000,   7.000,   0.000,   0.000,   -99.000, -99.000, -99.000, 14.000,  3.500,   0.000,
    7.000,   3.500,   7.000,   3.500,   3.500,   7.000,   3.500,   7.000,   0.000,   3.500,
    0.000,   3.500,   3.500,   0.000,   -99.000, -99.000, -99.000, 15.000,  3.500,   0.000,
    3.500,   7.000,   0.000,   3.500,   7.000,   3.500,   -99.000, -99.000, -99.000, 16.000,
    0.000,   0.000,   7.000,   7.000,   0.000,   7.000,   7.000,   0.000,   -99.000, -99.000,
    -99.000, 17.000,  0.000,   0.000,   3.500,   7.000,   3.500,   7.000,   7.000,   0.000,
    7.000,   0.000,   0.000,   0.000,   -99.000, -99.000, -99.000, 18.000,  7.000,   3.500,
    6.830,   4.580,   6.830,   4.580,   6.330,   5.557,   6.330,   5.557,   5.557,   6.330,
    5.557,   6.330,   4.580,   6.830,   4.580,   6.830,   3.500,   7.000,   3.500,   7.000,
    2.420,   6.830,   2.420,   6.830,   1.443,   6.330,   1.443,   6.330,   0.670,   5.557,
    0.670,   5.557,   0.170,   4.580,   0.170,   4.580,   0.000,   3.500,   0.000,   3.500,
    0.170,   2.420,   0.170,   2.420,   0.670,   1.443,   0.670,   1.443,   1.443,   0.670,
    1.443,   0.670,   2.420,   0.170,   2.420,   0.170,   3.500,   0.000,   3.500,   0.000,
    4.580,   0.170,   4.580,   0.170,   5.557,   0.670,   5.557,   0.670,   6.330,   1.443,
    6.330,   1.443,   6.830,   2.420,   6.830,   2.420,   7.000,   3.500,   -99.000, -99.000,
    -99.000, 19.000,  2.833,   3.500,   4.167,   3.500,   3.500,   4.167,   3.500,   2.833,
    3.970,   3.970,   3.030,   3.030,   3.030,   3.970,   3.970,   3.030,   -99.000, -99.000,
    -99.000, 20.000,  3.000,   6.000,   3.000,   2.000,   1.000,   4.000,   5.000,   4.000,
    1.000,   0.000,   5.000,   0.000,   -99.000, -99.000, -99.000, 21.000,  4.000,   1.000,
    0.000,   3.000,   0.000,   3.000,   4.000,   5.000,   0.000,   0.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 22.000,  0.000,   1.000,   4.000,   3.000,   4.000,   3.000,
    0.000,   5.000,   0.000,   0.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 23.000,
    0.000,   4.000,   4.000,   4.000,   0.000,   2.000,   4.000,   2.000,   1.000,   0.000,
    3.000,   6.000,   -99.000, -99.000, -99.000, 24.000,  1.000,   6.500,   2.000,   7.500,
    -99.000, -99.000, -99.000, 25.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,
    4.000,   5.000,   0.000,   0.000,   4.000,   0.000,   1.000,   -1.000,  3.000,   6.500,
    -99.000, -99.000, -99.000, 26.000,  0.000,   1.000,   4.000,   3.000,   4.000,   3.000,
    0.000,   5.000,   0.000,   0.000,   4.000,   0.000,   1.000,   -1.000,  3.000,   6.500,
    -99.000, -99.000, -99.000, 27.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,
    4.000,   5.000,   6.000,   1.000,   2.000,   3.000,   2.000,   3.000,   6.000,   5.000,
    -99.000, -99.000, -99.000, 28.000,  1.000,   1.000,   5.000,   3.000,   5.000,   3.000,
    1.000,   5.000,   3.000,   1.000,   7.000,   3.000,   7.000,   3.000,   3.000,   5.000,
    -99.000, -99.000, -99.000, 29.000,  5.000,   1.000,   4.000,   0.000,   4.000,   0.000,
    0.000,   0.000,   0.000,   0.000,   2.000,   3.500,   2.000,   3.500,   0.000,   7.000,
    0.000,   7.000,   4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   -99.000, -99.000,
    -99.000, 30.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,   4.000,   5.000,
    1.000,   0.000,   3.000,   6.000,   -99.000, -99.000, -99.000, 31.000,  0.000,   1.000,
    4.000,   3.000,   4.000,   3.000,   0.000,   5.000,   1.000,   0.000,   3.000,   6.000,
    -99.000, -99.000, -99.000, 32.000,  0.000,   0.000,   3.500,   0.000,   -99.000, -99.000,
    -99.000, 33.000,  1.500,   7.000,   1.500,   2.000,   2.000,   1.000,   2.000,   0.000,
    2.000,   0.000,   1.000,   0.000,   1.000,   0.000,   1.000,   1.000,   1.000,   1.000,
    2.000,   1.000,   -99.000, -99.000, -99.000, 34.000,  2.000,   6.000,   1.000,   5.000,
    3.000,   6.000,   2.000,   5.000,   -99.000, -99.000, -99.000, 35.000,  1.000,   5.000,
    1.000,   1.000,   3.000,   1.000,   3.000,   5.000,   4.000,   4.000,   0.000,   4.000,
    0.000,   2.000,   4.000,   2.000,   -99.000, -99.000, -99.000, 36.000,  0.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   1.000,   4.000,   3.000,   4.000,   3.000,   3.000,   4.000,   3.000,   4.000,
    1.000,   4.000,   1.000,   4.000,   0.000,   5.000,   0.000,   5.000,   0.000,   6.000,
    0.000,   6.000,   1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,
    4.000,   6.000,   2.000,   0.000,   2.000,   7.000,   -99.000, -99.000, -99.000, 37.000,
    0.000,   7.000,   1.000,   7.000,   1.000,   7.000,   1.000,   6.000,   1.000,   6.000,
    0.000,   6.000,   0.000,   6.000,   0.000,   7.000,   4.000,   7.000,   0.000,   0.000,
    3.000,   0.000,   4.000,   0.000,   4.000,   0.000,   4.000,   1.000,   4.000,   1.000,
    3.000,   1.000,   3.000,   1.000,   3.000,   0.000,   -99.000, -99.000, -99.000, 38.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,
    0.000,   1.000,   0.000,   1.000,   3.000,   6.000,   3.000,   6.000,   2.000,   7.000,
    2.000,   7.000,   1.000,   6.000,   1.000,   6.000,   1.000,   5.000,   1.000,   5.000,
    4.000,   0.000,   -99.000, -99.000, -99.000, 39.000,  2.000,   6.000,   1.000,   5.000,
    -99.000, -99.000, -99.000, 40.000,  3.000,   0.000,   2.000,   1.000,   2.000,   1.000,
    2.000,   6.000,   2.000,   6.000,   3.000,   7.000,   -99.000, -99.000, -99.000, 41.000,
    1.000,   0.000,   2.000,   1.000,   2.000,   1.000,   2.000,   6.000,   2.000,   6.000,
    1.000,   7.000,   -99.000, -99.000, -99.000, 42.000,  0.000,   1.000,   4.000,   5.000,
    0.000,   3.000,   4.000,   3.000,   0.000,   5.000,   4.000,   1.000,   2.000,   1.000,
    2.000,   5.000,   -99.000, -99.000, -99.000, 43.000,  3.000,   5.000,   3.000,   1.000,
    1.000,   3.000,   5.000,   3.000,   -99.000, -99.000, -99.000, 44.000,  2.000,   0.000,
    1.000,   0.000,   1.000,   0.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,
    2.000,   1.000,   2.000,   0.000,   2.000,   0.000,   0.000,   -2.000,  -99.000, -99.000,
    -99.000, 45.000,  1.000,   4.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 46.000,
    1.000,   0.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,   2.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   1.000,   0.000,   -99.000, -99.000, -99.000, 47.000,
    0.000,   0.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 48.000,  1.000,   1.000,
    1.000,   6.000,   1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   5.000,   6.000,   5.000,   6.000,   5.000,   1.000,   5.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    -99.000, -99.000, -99.000, 49.000,  2.500,   6.000,   3.500,   7.000,   3.500,   7.000,
    3.500,   0.000,   2.500,   0.000,   4.500,   0.000,   -99.000, -99.000, -99.000, 50.000,
    1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,
    5.000,   6.000,   5.000,   6.000,   5.000,   4.000,   5.000,   4.000,   1.000,   1.000,
    1.000,   1.000,   1.000,   0.000,   1.000,   0.000,   5.000,   0.000,   5.000,   0.000,
    5.000,   1.000,   -99.000, -99.000, -99.000, 51.000,  1.000,   6.000,   1.000,   7.000,
    1.000,   7.000,   5.000,   7.000,   5.000,   7.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,
    5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,
    1.000,   1.000,   -99.000, -99.000, -99.000, 52.000,  4.000,   0.000,   4.000,   7.000,
    4.000,   7.000,   1.000,   3.000,   1.000,   3.000,   5.000,   3.000,   3.000,   0.000,
    5.000,   0.000,   -99.000, -99.000, -99.000, 53.000,  1.000,   1.000,   2.000,   0.000,
    2.000,   0.000,   4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   1.000,
    5.000,   3.000,   5.000,   3.000,   4.000,   4.000,   4.000,   4.000,   1.000,   4.000,
    1.000,   4.000,   1.000,   7.000,   1.000,   7.000,   5.000,   7.000,   -99.000, -99.000,
    -99.000, 54.000,  1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   4.000,   4.000,
    4.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   5.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    1.000,   1.000,   1.000,   6.000,   1.000,   6.000,   2.000,   7.000,   2.000,   7.000,
    4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   -99.000, -99.000, -99.000, 55.000,
    1.000,   0.000,   5.000,   7.000,   5.000,   7.000,   1.000,   7.000,   1.000,   7.000,
    1.000,   6.000,   -99.000, -99.000, -99.000, 56.000,  2.000,   4.000,   1.000,   5.000,
    1.000,   5.000,   1.000,   6.000,   1.000,   6.000,   2.000,   7.000,   2.000,   7.000,
    4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   5.000,   6.000,   5.000,   5.000,
    5.000,   5.000,   4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   5.000,   3.000,
    5.000,   1.000,   5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   2.000,   0.000,
    2.000,   0.000,   1.000,   1.000,   1.000,   1.000,   1.000,   3.000,   1.000,   3.000,
    2.000,   4.000,   2.000,   4.000,   4.000,   4.000,   -99.000, -99.000, -99.000, 57.000,
    1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   4.000,   0.000,   4.000,   0.000,
    5.000,   1.000,   5.000,   1.000,   5.000,   6.000,   5.000,   6.000,   4.000,   7.000,
    4.000,   7.000,   2.000,   7.000,   2.000,   7.000,   1.000,   6.000,   1.000,   6.000,
    1.000,   4.000,   1.000,   4.000,   2.000,   3.000,   2.000,   3.000,   4.000,   3.000,
    4.000,   3.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 58.000,  2.000,   4.000,
    1.000,   4.000,   1.000,   4.000,   1.000,   5.000,   1.000,   5.000,   2.000,   5.000,
    2.000,   5.000,   2.000,   4.000,   2.000,   1.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   2.000,   1.000,   2.000,   2.000,   2.000,   2.000,   2.000,   2.000,   1.000,
    -99.000, -99.000, -99.000, 59.000,  2.000,   4.000,   1.000,   4.000,   1.000,   4.000,
    1.000,   5.000,   1.000,   5.000,   2.000,   5.000,   2.000,   5.000,   2.000,   4.000,
    2.000,   1.000,   1.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,   2.000,
    2.000,   2.000,   2.000,   2.000,   2.000,   1.000,   2.000,   1.000,   0.000,   -1.000,
    -99.000, -99.000, -99.000, 60.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,
    4.000,   5.000,   -99.000, -99.000, -99.000, 61.000,  0.000,   4.000,   4.000,   4.000,
    0.000,   2.000,   4.000,   2.000,   -99.000, -99.000, -99.000, 62.000,  0.000,   1.000,
    4.000,   3.000,   4.000,   3.000,   0.000,   5.000,   -99.000, -99.000, -99.000, 63.000,
    0.000,   6.000,   1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,
    4.000,   6.000,   4.000,   6.000,   4.000,   5.000,   4.000,   5.000,   3.000,   4.000,
    3.000,   4.000,   2.000,   4.000,   2.000,   4.000,   2.000,   2.000,   1.500,   0.000,
    1.500,   1.000,   1.500,   1.000,   2.500,   1.000,   2.500,   1.000,   2.500,   0.000,
    2.500,   0.000,   1.500,   0.000,   -99.000, -99.000, -99.000, 64.000,  4.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,
    0.000,   1.000,   0.000,   6.000,   0.000,   6.000,   1.000,   7.000,   1.000,   7.000,
    3.000,   7.000,   3.000,   7.000,   4.000,   6.000,   4.000,   6.000,   4.000,   3.000,
    4.000,   3.000,   3.000,   2.000,   3.000,   2.000,   2.000,   2.000,   2.000,   2.000,
    1.000,   3.000,   1.000,   3.000,   1.000,   4.000,   1.000,   4.000,   2.000,   5.000,
    2.000,   5.000,   3.000,   4.000,   3.000,   4.000,   3.000,   3.000,   3.000,   3.000,
    2.000,   2.000,   -99.000, -99.000, -99.000, 65.000,  0.000,   0.000,   0.000,   6.000,
    0.000,   6.000,   1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,
    4.000,   6.000,   4.000,   6.000,   4.000,   0.000,   0.000,   4.000,   4.000,   4.000,
    -99.000, -99.000, -99.000, 66.000,  0.000,   0.000,   0.000,   7.000,   0.000,   7.000,
    3.000,   7.000,   3.000,   7.000,   4.000,   6.000,   4.000,   6.000,   4.000,   5.000,
    4.000,   5.000,   3.000,   4.000,   3.000,   4.000,   0.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   0.000,   0.000,   -99.000, -99.000, -99.000, 67.000,  4.000,   2.000,
    4.000,   1.000,   4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,
    1.000,   0.000,   0.000,   1.000,   0.000,   1.000,   0.000,   6.000,   0.000,   6.000,
    1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,
    4.000,   6.000,   4.000,   5.000,   -99.000, -99.000, -99.000, 68.000,  0.000,   0.000,
    0.000,   7.000,   0.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,
    4.000,   6.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,   3.000,   0.000,
    0.000,   0.000,   -99.000, -99.000, -99.000, 69.000,  0.000,   0.000,   0.000,   7.000,
    0.000,   7.000,   4.000,   7.000,   4.000,   7.000,   4.000,   6.000,   0.000,   4.000,
    2.000,   4.000,   0.000,   0.000,   4.000,   0.000,   4.000,   0.000,   4.000,   1.000,
    -99.000, -99.000, -99.000, 70.000,  0.000,   0.000,   0.000,   7.000,   0.000,   7.000,
    4.000,   7.000,   4.000,   7.000,   4.000,   6.000,   0.000,   4.000,   2.000,   4.000,
    -99.000, -99.000, -99.000, 71.000,  2.000,   2.000,   2.000,   3.000,   2.000,   3.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   2.000,   4.000,   2.000,   4.000,   1.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,
    0.000,   1.000,   0.000,   1.000,   0.000,   6.000,   0.000,   6.000,   1.000,   7.000,
    1.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,   4.000,   6.000,
    4.000,   5.000,   -99.000, -99.000, -99.000, 72.000,  0.000,   0.000,   0.000,   7.000,
    4.000,   7.000,   4.000,   0.000,   0.000,   4.000,   4.000,   4.000,   -99.000, -99.000,
    -99.000, 73.000,  1.000,   0.000,   3.000,   0.000,   2.000,   0.000,   2.000,   7.000,
    1.000,   7.000,   3.000,   7.000,   -99.000, -99.000, -99.000, 74.000,  0.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   1.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 75.000,  0.000,   0.000,
    0.000,   7.000,   0.000,   3.000,   4.000,   7.000,   1.000,   4.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 76.000,  0.000,   7.000,   0.000,   0.000,   0.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   4.000,   1.000,   -99.000, -99.000, -99.000, 77.000,
    0.000,   0.000,   0.000,   7.000,   0.000,   7.000,   2.000,   4.000,   2.000,   4.000,
    4.000,   7.000,   4.000,   7.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 78.000,
    0.000,   0.000,   0.000,   7.000,   0.000,   7.000,   4.000,   0.000,   4.000,   0.000,
    4.000,   7.000,   -99.000, -99.000, -99.000, 79.000,  0.000,   1.000,   0.000,   6.000,
    0.000,   6.000,   1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,
    4.000,   6.000,   4.000,   6.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   -99.000, -99.000,
    -99.000, 80.000,  0.000,   0.000,   0.000,   7.000,   0.000,   7.000,   3.000,   7.000,
    3.000,   7.000,   4.000,   6.000,   4.000,   6.000,   4.000,   5.000,   4.000,   5.000,
    3.000,   4.000,   3.000,   4.000,   0.000,   4.000,   -99.000, -99.000, -99.000, 81.000,
    0.000,   1.000,   0.000,   6.000,   0.000,   6.000,   1.000,   7.000,   1.000,   7.000,
    3.000,   7.000,   3.000,   7.000,   4.000,   6.000,   4.000,   6.000,   4.000,   1.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,
    0.000,   1.000,   3.000,   1.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 82.000,
    0.000,   0.000,   0.000,   7.000,   0.000,   7.000,   3.000,   7.000,   3.000,   7.000,
    4.000,   6.000,   4.000,   6.000,   4.000,   5.000,   4.000,   5.000,   3.000,   4.000,
    3.000,   4.000,   0.000,   4.000,   2.000,   4.000,   4.000,   0.000,   -99.000, -99.000,
    -99.000, 83.000,  0.000,   1.000,   1.000,   0.000,   1.000,   0.000,   3.000,   0.000,
    3.000,   0.000,   4.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,   3.000,
    3.000,   4.000,   3.000,   4.000,   1.000,   4.000,   1.000,   4.000,   0.000,   5.000,
    0.000,   5.000,   0.000,   6.000,   0.000,   6.000,   1.000,   7.000,   1.000,   7.000,
    3.000,   7.000,   3.000,   7.000,   4.000,   6.000,   -99.000, -99.000, -99.000, 84.000,
    0.000,   6.000,   0.000,   7.000,   0.000,   7.000,   4.000,   7.000,   4.000,   7.000,
    4.000,   6.000,   1.000,   0.000,   3.000,   0.000,   2.000,   0.000,   2.000,   7.000,
    -99.000, -99.000, -99.000, 85.000,  0.000,   7.000,   0.000,   1.000,   0.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   1.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 86.000,  0.000,   7.000,
    2.000,   0.000,   2.000,   0.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 87.000,
    0.000,   7.000,   0.000,   0.000,   0.000,   0.000,   2.000,   4.000,   2.000,   4.000,
    4.000,   0.000,   4.000,   0.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 88.000,
    0.000,   0.000,   4.000,   7.000,   0.000,   7.000,   4.000,   0.000,   -99.000, -99.000,
    -99.000, 89.000,  1.000,   0.000,   3.000,   0.000,   2.000,   0.000,   2.000,   4.000,
    2.000,   4.000,   0.000,   7.000,   2.000,   4.000,   4.000,   7.000,   -99.000, -99.000,
    -99.000, 90.000,  0.000,   6.000,   0.000,   7.000,   0.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   0.000,   0.000,   0.000,   0.000,   4.000,   0.000,   4.000,   0.000,
    4.000,   1.000,   -99.000, -99.000, -99.000, 91.000,  3.000,   0.000,   2.000,   0.000,
    2.000,   0.000,   2.000,   7.000,   2.000,   7.000,   3.000,   7.000,   -99.000, -99.000,
    -99.000, 92.000,  0.000,   7.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 93.000,
    2.000,   0.000,   3.000,   0.000,   3.000,   0.000,   3.000,   7.000,   3.000,   7.000,
    2.000,   7.000,   -99.000, -99.000, -99.000, 94.000,  1.000,   4.000,   3.000,   7.000,
    3.000,   7.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 95.000,  0.000,   0.000,
    5.000,   0.000,   -99.000, -99.000, -99.000, 96.000,  1.000,   6.000,   2.000,   5.000,
    -99.000, -99.000, -99.000, 97.000,  4.000,   1.000,   3.000,   0.000,   3.000,   0.000,
    1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   0.000,   1.000,   0.000,   3.000,
    0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   4.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 98.000,
    0.000,   0.000,   0.000,   7.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,
    3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   4.000,   3.000,   4.000,   1.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,
    0.000,   1.000,   -99.000, -99.000, -99.000, 99.000,  4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   0.000,   1.000,
    0.000,   3.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,
    3.000,   4.000,   4.000,   3.000,   -99.000, -99.000, -99.000, 100.000, 4.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,
    0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,
    3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   4.000,   7.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 101.000, 4.000,   1.000,   3.000,   0.000,   3.000,   0.000,
    1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   0.000,   1.000,   0.000,   3.000,
    0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   2.000,   4.000,   2.000,   0.000,   2.000,
    -99.000, -99.000, -99.000, 102.000, 1.000,   0.000,   1.000,   6.000,   1.000,   6.000,
    2.000,   7.000,   2.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,
    0.000,   4.000,   2.000,   4.000,   -99.000, -99.000, -99.000, 103.000, 4.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,
    0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,
    3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   4.000,   4.000,   4.000,   -2.000,
    4.000,   -2.000,  3.000,   -3.000,  3.000,   -3.000,  1.000,   -3.000,  1.000,   -3.000,
    0.000,   -2.000,  -99.000, -99.000, -99.000, 104.000, 0.000,   0.000,   0.000,   7.000,
    0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 105.000,
    1.000,   6.000,   1.000,   7.000,   1.000,   4.000,   1.000,   1.000,   1.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    -99.000, -99.000, -99.000, 106.000, 4.000,   6.000,   4.000,   7.000,   4.000,   4.000,
    4.000,   -2.000,  4.000,   -2.000,  3.000,   -3.000,  3.000,   -3.000,  1.000,   -3.000,
    1.000,   -3.000,  0.000,   -2.000,  -99.000, -99.000, -99.000, 107.000, 0.000,   0.000,
    0.000,   7.000,   4.000,   4.000,   0.000,   2.000,   0.000,   2.000,   2.000,   3.000,
    2.000,   3.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 108.000, 1.000,   7.000,
    1.000,   1.000,   1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   3.000,   0.000,
    3.000,   0.000,   4.000,   1.000,   -99.000, -99.000, -99.000, 109.000, 0.000,   0.000,
    0.000,   4.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   2.000,   3.000,
    2.000,   3.000,   2.000,   0.000,   2.000,   3.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 110.000,
    0.000,   0.000,   0.000,   4.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,
    3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   4.000,   3.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 111.000, 0.000,   1.000,   0.000,   3.000,   0.000,   3.000,
    1.000,   4.000,   1.000,   4.000,   3.000,   4.000,   3.000,   4.000,   4.000,   3.000,
    4.000,   3.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,   3.000,   0.000,
    1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   -99.000, -99.000, -99.000, 112.000,
    0.000,   -3.000,  0.000,   4.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,
    3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   4.000,   3.000,   4.000,   1.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,
    0.000,   1.000,   -99.000, -99.000, -99.000, 113.000, 4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   0.000,   1.000,
    0.000,   3.000,   0.000,   3.000,   1.000,   4.000,   1.000,   4.000,   3.000,   4.000,
    3.000,   4.000,   4.000,   3.000,   4.000,   4.000,   4.000,   -3.000,  -99.000, -99.000,
    -99.000, 114.000, 0.000,   0.000,   0.000,   4.000,   0.000,   3.000,   1.000,   4.000,
    1.000,   4.000,   3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   -99.000, -99.000,
    -99.000, 115.000, 0.000,   1.000,   1.000,   0.000,   1.000,   0.000,   3.000,   0.000,
    3.000,   0.000,   4.000,   1.000,   4.000,   1.000,   3.000,   2.000,   3.000,   2.000,
    1.000,   2.000,   1.000,   2.000,   0.000,   3.000,   0.000,   3.000,   1.000,   4.000,
    1.000,   4.000,   3.000,   4.000,   3.000,   4.000,   4.000,   3.000,   -99.000, -99.000,
    -99.000, 116.000, 0.000,   4.000,   2.000,   4.000,   1.000,   6.000,   1.000,   1.000,
    1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   3.000,   0.000,   3.000,   0.000,
    4.000,   1.000,   -99.000, -99.000, -99.000, 117.000, 1.000,   4.000,   1.000,   1.000,
    1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   3.000,   0.000,   3.000,   0.000,
    4.000,   1.000,   4.000,   4.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 118.000,
    0.000,   4.000,   2.000,   0.000,   2.000,   0.000,   4.000,   4.000,   -99.000, -99.000,
    -99.000, 119.000, 0.000,   4.000,   1.000,   0.000,   1.000,   0.000,   2.000,   2.000,
    2.000,   2.000,   3.000,   0.000,   3.000,   0.000,   4.000,   4.000,   -99.000, -99.000,
    -99.000, 120.000, 0.000,   0.000,   4.000,   4.000,   0.000,   4.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 121.000, 1.000,   4.000,   1.000,   1.000,   1.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   4.000,   4.000,   -2.000,  4.000,   -2.000,  3.000,   -3.000,  3.000,   -3.000,
    1.000,   -3.000,  1.000,   -3.000,  0.000,   -2.000,  -99.000, -99.000, -99.000, 122.000,
    0.000,   4.000,   4.000,   4.000,   4.000,   4.000,   0.000,   0.000,   0.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   0.000,   0.000,   -99.000, -99.000, -99.000, 123.000,
    3.000,   0.000,   2.000,   1.000,   2.000,   1.000,   2.000,   3.000,   2.000,   3.000,
    1.000,   3.500,   1.000,   3.500,   2.000,   4.000,   2.000,   4.000,   2.000,   6.000,
    2.000,   6.000,   3.000,   7.000,   -99.000, -99.000, -99.000, 124.000, 2.000,   0.000,
    2.000,   7.000,   -99.000, -99.000, -99.000, 125.000, 1.000,   0.000,   2.000,   1.000,
    2.000,   1.000,   2.000,   3.000,   2.000,   3.000,   3.000,   3.500,   3.000,   3.500,
    2.000,   4.000,   2.000,   4.000,   2.000,   6.000,   2.000,   6.000,   1.000,   7.000,
    -99.000, -99.000, -99.000, 126.000, 0.000,   3.500,   1.000,   4.500,   1.000,   4.500,
    3.000,   2.500,   3.000,   2.500,   4.000,   3.500,   -99.000, -99.000, -99.000, 127.000,
    0.000,   4.000,   1.000,   5.000,   1.000,   5.000,   3.000,   3.000,   3.000,   3.000,
    4.000,   4.000,   0.000,   2.000,   1.000,   3.000,   1.000,   3.000,   3.000,   1.000,
    3.000,   1.000,   4.000,   2.000,   -99.000, -99.000, -99.000, 999.000, -99.000, -99.000,
    -99.000, 4.000,   0.000,   2.213,   -1.077,  2.170,   0.603,   2.170,   0.000,   2.213,
    0.603,   1.077,   0.603,   2.170,   2.043,   1.077,   0.603,   1.077,   2.170,   0.127,
    2.043,   1.077,   2.043,   -1.553,  2.170,   0.127,   1.567,   -1.680,  2.043,   -1.553,
    1.680,   -0.713,  1.567,   -1.680,  1.317,   -0.713,  1.680,   -0.713,  1.203,   0.127,
    1.317,   -0.713,  0.603,   0.127,   1.203,   0.127,   0.713,   -2.407,  0.603,   0.127,
    -0.713,  -2.407,  0.713,   -2.407,  -0.603,  0.127,   -0.713,  -2.407,  -1.203,  0.127,
    -0.603,  0.127,   -1.317,  -0.713,  -1.203,  0.127,   -1.680,  -0.713,  -1.317,  -0.713,
    -1.567,  -1.680,  -1.680,  -0.713,  -2.043,  -1.567,  -1.567,  -1.680,  -2.170,  0.127,
    -2.043,  -1.567,  -2.043,  1.077,   -2.170,  0.127,   -0.603,  1.077,   -2.043,  1.077,
    -0.603,  1.680,   -0.603,  1.077,   -1.077,  1.667,   -0.603,  1.680,   -1.077,  2.170,
    -1.077,  1.667,   1.077,   -2.773,  0.000,   -2.773,  2.043,   -2.647,  1.077,   -2.773,
    2.407,   -2.533,  2.043,   -2.647,  2.533,   -2.407,  2.407,   -2.533,  2.647,   -2.043,
    2.533,   -2.407,  2.773,   -1.077,  2.647,   -2.043,  2.773,   0.000,   2.773,   -1.077,
    1.077,   2.773,   0.000,   2.773,   2.043,   2.647,   1.077,   2.773,   2.407,   2.520,
    2.043,   2.647,   2.533,   2.407,   2.407,   2.520,   2.647,   2.043,   2.533,   2.407,
    2.773,   1.077,   2.647,   2.043,   2.773,   0.000,   2.773,   1.077,   -1.077,  2.773,
    0.000,   2.773,   -2.043,  2.647,   -1.077,  2.773,   -2.407,  2.520,   -2.043,  2.647,
    -2.533,  2.407,   -2.407,  2.520,   -2.647,  2.043,   -2.533,  2.407,   -2.773,  1.077,
    -2.647,  2.043,   -2.773,  0.000,   -2.773,  1.077,   -1.077,  -2.773,  0.000,   -2.773,
    -2.043,  -2.647,  -1.077,  -2.773,  -2.407,  -2.533,  -2.043,  -2.647,  -2.533,  -2.407,
    -2.407,  -2.533,  -2.647,  -2.043,  -2.533,  -2.407,  -2.773,  -1.077,  -2.647,  -2.043,
    -2.773,  0.000,   -2.773,  -1.077,  1.203,   -3.500,  0.000,   -3.500,  2.283,   -3.373,
    1.203,   -3.500,  2.773,   -3.247,  2.283,   -3.373,  3.010,   -3.137,  2.773,   -3.247,
    3.137,   -3.010,  3.010,   -3.137,  3.247,   -2.773,  3.137,   -3.010,  3.373,   -2.283,
    3.247,   -2.773,  3.500,   -1.203,  3.373,   -2.283,  3.500,   0.000,   3.500,   -1.203,
    1.203,   3.487,   0.000,   3.487,   2.283,   3.373,   1.203,   3.487,   2.773,   3.247,
    2.283,   3.373,   3.010,   3.137,   2.773,   3.247,   3.137,   3.010,   3.010,   3.137,
    3.247,   2.773,   3.137,   3.010,   3.373,   2.283,   3.247,   2.773,   3.500,   1.203,
    3.373,   2.283,   3.500,   0.000,   3.500,   1.203,   -1.203,  3.487,   0.000,   3.487,
    -2.283,  3.373,   -1.203,  3.487,   -2.773,  3.247,   -2.283,  3.373,   -3.010,  3.137,
    -2.773,  3.247,   -3.137,  3.010,   -3.010,  3.137,   -3.247,  2.773,   -3.137,  3.010,
    -3.373,  2.283,   -3.247,  2.773,   -3.500,  1.203,   -3.373,  2.283,   -3.500,  0.000,
    -3.500,  1.203,   -1.203,  -3.500,  0.000,   -3.500,  -2.283,  -3.373,  -1.203,  -3.500,
    -2.773,  -3.247,  -2.283,  -3.373,  -3.010,  -3.137,  -2.773,  -3.247,  -3.137,  -3.010,
    -3.010,  -3.137,  -3.247,  -2.773,  -3.137,  -3.010,  -3.373,  -2.283,  -3.247,  -2.773,
    -3.500,  -1.203,  -3.373,  -2.283,  -3.500,  0.000,   -3.500,  -1.203,  -99.000, -99.000,
    -99.000, 5.000,   -3.500,  -3.500,  3.500,   -3.500,  3.500,   -3.500,  3.500,   3.500,
    3.500,   3.500,   -3.500,  3.500,   -3.500,  3.500,   -3.500,  -3.500,  -99.000, -99.000,
    -99.000, 6.000,   0.000,   -3.500,  3.500,   0.000,   3.500,   0.000,   0.000,   3.500,
    0.000,   3.500,   -3.500,  0.000,   -3.500,  0.000,   0.000,   -3.500,  -99.000, -99.000,
    -99.000, 7.000,   0.000,   -3.500,  0.000,   3.500,   -3.500,  0.000,   3.500,   0.000,
    -99.000, -99.000, -99.000, 8.000,   -3.500,  -3.500,  3.500,   3.500,   -3.500,  3.500,
    3.500,   -3.500,  -99.000, -99.000, -99.000, 9.000,   -3.500,  -2.500,  0.000,   4.500,
    0.000,   4.500,   3.500,   -2.500,  3.500,   -2.500,  -3.500,  -2.500,  -99.000, -99.000,
    -99.000, 10.000,  3.500,   0.000,   3.330,   1.080,   3.330,   1.080,   2.830,   2.057,
    2.830,   2.057,   2.057,   2.830,   2.057,   2.830,   1.080,   3.330,   1.080,   3.330,
    0.000,   3.500,   0.000,   3.500,   -1.080,  3.330,   -1.080,  3.330,   -2.057,  2.830,
    -2.057,  2.830,   -2.830,  2.057,   -2.830,  2.057,   -3.330,  1.080,   -3.330,  1.080,
    -3.500,  0.000,   -3.500,  0.000,   -3.330,  -1.080,  -3.330,  -1.080,  -2.830,  -2.057,
    -2.830,  -2.057,  -2.057,  -2.830,  -2.057,  -2.830,  -1.080,  -3.330,  -1.080,  -3.330,
    0.000,   -3.500,  0.000,   -3.500,  1.080,   -3.330,  1.080,   -3.330,  2.057,   -2.830,
    2.057,   -2.830,  2.830,   -2.057,  2.830,   -2.057,  3.330,   -1.080,  3.330,   -1.080,
    3.500,   0.000,   -99.000, -99.000, -99.000, 11.000,  -0.667,  0.000,   0.667,   0.000,
    0.000,   0.667,   0.000,   -0.667,  0.470,   0.470,   -0.470,  -0.470,  -0.470,  0.470,
    0.470,   -0.470,  -99.000, -99.000, -99.000, 12.000,  3.500,   5.713,   2.423,   5.670,
    4.103,   5.670,   3.500,   5.713,   4.103,   4.577,   4.103,   5.670,   5.543,   4.577,
    4.103,   4.577,   5.670,   3.627,   5.543,   4.577,   5.543,   1.947,   5.670,   3.627,
    5.067,   1.820,   5.543,   1.947,   5.180,   2.787,   5.067,   1.820,   4.817,   2.787,
    5.180,   2.787,   4.703,   3.627,   4.817,   2.787,   4.103,   3.627,   4.703,   3.627,
    4.213,   1.093,   4.103,   3.627,   2.787,   1.093,   4.213,   1.093,   2.897,   3.627,
    2.787,   1.093,   2.297,   3.627,   2.897,   3.627,   2.183,   2.787,   2.297,   3.627,
    1.820,   2.787,   2.183,   2.787,   1.933,   1.820,   1.820,   2.787,   1.457,   1.933,
    1.933,   1.820,   1.330,   3.627,   1.457,   1.933,   1.457,   4.577,   1.330,   3.627,
    2.897,   4.577,   1.457,   4.577,   2.897,   5.180,   2.897,   4.577,   2.423,   5.167,
    2.897,   5.180,   2.423,   5.670,   2.423,   5.167,   4.577,   0.727,   3.500,   0.727,
    5.543,   0.853,   4.577,   0.727,   5.907,   0.967,   5.543,   0.853,   6.033,   1.093,
    5.907,   0.967,   6.147,   1.457,   6.033,   1.093,   6.273,   2.423,   6.147,   1.457,
    6.273,   3.500,   6.273,   2.423,   4.577,   6.273,   3.500,   6.273,   5.543,   6.147,
    4.577,   6.273,   5.907,   6.020,   5.543,   6.147,   6.033,   5.907,   5.907,   6.020,
    6.147,   5.543,   6.033,   5.907,   6.273,   4.577,   6.147,   5.543,   6.273,   3.500,
    6.273,   4.577,   2.423,   6.273,   3.500,   6.273,   1.457,   6.147,   2.423,   6.273,
    1.093,   6.020,   1.457,   6.147,   0.967,   5.907,   1.093,   6.020,   0.853,   5.543,
    0.967,   5.907,   0.727,   4.577,   0.853,   5.543,   0.727,   3.500,   0.727,   4.577,
    2.423,   0.727,   3.500,   0.727,   1.457,   0.853,   2.423,   0.727,   1.093,   0.967,
    1.457,   0.853,   0.967,   1.093,   1.093,   0.967,   0.853,   1.457,   0.967,   1.093,
    0.727,   2.423,   0.853,   1.457,   0.727,   3.500,   0.727,   2.423,   4.703,   0.000,
    3.500,   0.000,   5.783,   0.127,   4.703,   0.000,   6.273,   0.253,   5.783,   0.127,
    6.510,   0.363,   6.273,   0.253,   6.637,   0.490,   6.510,   0.363,   6.747,   0.727,
    6.637,   0.490,   6.873,   1.217,   6.747,   0.727,   7.000,   2.297,   6.873,   1.217,
    7.000,   3.500,   7.000,   2.297,   4.703,   6.987,   3.500,   6.987,   5.783,   6.873,
    4.703,   6.987,   6.273,   6.747,   5.783,   6.873,   6.510,   6.637,   6.273,   6.747,
    6.637,   6.510,   6.510,   6.637,   6.747,   6.273,   6.637,   6.510,   6.873,   5.783,
    6.747,   6.273,   7.000,   4.703,   6.873,   5.783,   7.000,   3.500,   7.000,   4.703,
    2.297,   6.987,   3.500,   6.987,   1.217,   6.873,   2.297,   6.987,   0.727,   6.747,
    1.217,   6.873,   0.490,   6.637,   0.727,   6.747,   0.363,   6.510,   0.490,   6.637,
    0.253,   6.273,   0.363,   6.510,   0.127,   5.783,   0.253,   6.273,   0.000,   4.703,
    0.127,   5.783,   0.000,   3.500,   0.000,   4.703,   2.297,   0.000,   3.500,   0.000,
    1.217,   0.127,   2.297,   0.000,   0.727,   0.253,   1.217,   0.127,   0.490,   0.363,
    0.727,   0.253,   0.363,   0.490,   0.490,   0.363,   0.253,   0.727,   0.363,   0.490,
    0.127,   1.217,   0.253,   0.727,   0.000,   2.297,   0.127,   1.217,   0.000,   3.500,
    0.000,   2.297,   -99.000, -99.000, -99.000, 13.000,  0.000,   0.000,   7.000,   0.000,
    7.000,   0.000,   7.000,   7.000,   7.000,   7.000,   0.000,   7.000,   0.000,   7.000,
    0.000,   0.000,   -99.000, -99.000, -99.000, 14.000,  3.500,   0.000,   7.000,   3.500,
    7.000,   3.500,   3.500,   7.000,   3.500,   7.000,   0.000,   3.500,   0.000,   3.500,
    3.500,   0.000,   -99.000, -99.000, -99.000, 15.000,  3.500,   0.000,   3.500,   7.000,
    0.000,   3.500,   7.000,   3.500,   -99.000, -99.000, -99.000, 16.000,  0.000,   0.000,
    7.000,   7.000,   0.000,   7.000,   7.000,   0.000,   -99.000, -99.000, -99.000, 17.000,
    0.000,   0.000,   3.500,   7.000,   3.500,   7.000,   7.000,   0.000,   7.000,   0.000,
    0.000,   0.000,   -99.000, -99.000, -99.000, 18.000,  7.000,   3.500,   6.830,   4.580,
    6.830,   4.580,   6.330,   5.557,   6.330,   5.557,   5.557,   6.330,   5.557,   6.330,
    4.580,   6.830,   4.580,   6.830,   3.500,   7.000,   3.500,   7.000,   2.420,   6.830,
    2.420,   6.830,   1.443,   6.330,   1.443,   6.330,   0.670,   5.557,   0.670,   5.557,
    0.170,   4.580,   0.170,   4.580,   0.000,   3.500,   0.000,   3.500,   0.170,   2.420,
    0.170,   2.420,   0.670,   1.443,   0.670,   1.443,   1.443,   0.670,   1.443,   0.670,
    2.420,   0.170,   2.420,   0.170,   3.500,   0.000,   3.500,   0.000,   4.580,   0.170,
    4.580,   0.170,   5.557,   0.670,   5.557,   0.670,   6.330,   1.443,   6.330,   1.443,
    6.830,   2.420,   6.830,   2.420,   7.000,   3.500,   -99.000, -99.000, -99.000, 19.000,
    2.833,   3.500,   4.167,   3.500,   3.500,   4.167,   3.500,   2.833,   3.970,   3.970,
    3.030,   3.030,   3.030,   3.970,   3.970,   3.030,   -99.000, -99.000, -99.000, 20.000,
    3.000,   6.000,   3.000,   2.000,   1.000,   4.000,   5.000,   4.000,   1.000,   0.000,
    5.000,   0.000,   -99.000, -99.000, -99.000, 21.000,  4.000,   1.000,   0.000,   3.000,
    0.000,   3.000,   4.000,   5.000,   0.000,   0.000,   4.000,   0.000,   -99.000, -99.000,
    -99.000, 22.000,  0.000,   1.000,   4.000,   3.000,   4.000,   3.000,   0.000,   5.000,
    0.000,   0.000,   4.000,   0.000,   -99.000, -99.000, -99.000, 23.000,  0.000,   4.000,
    4.000,   4.000,   0.000,   2.000,   4.000,   2.000,   1.000,   0.000,   3.000,   6.000,
    -99.000, -99.000, -99.000, 24.000,  1.000,   6.500,   2.000,   7.500,   -99.000, -99.000,
    -99.000, 25.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,   4.000,   5.000,
    0.000,   0.000,   4.000,   0.000,   1.000,   -1.000,  3.000,   6.500,   -99.000, -99.000,
    -99.000, 26.000,  0.000,   1.000,   4.000,   3.000,   4.000,   3.000,   0.000,   5.000,
    0.000,   0.000,   4.000,   0.000,   1.000,   -1.000,  3.000,   6.500,   -99.000, -99.000,
    -99.000, 27.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,   4.000,   5.000,
    6.000,   1.000,   2.000,   3.000,   2.000,   3.000,   6.000,   5.000,   -99.000, -99.000,
    -99.000, 28.000,  1.000,   1.000,   5.000,   3.000,   5.000,   3.000,   1.000,   5.000,
    3.000,   1.000,   7.000,   3.000,   7.000,   3.000,   3.000,   5.000,   -99.000, -99.000,
    -99.000, 29.000,  5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   0.000,   0.000,
    0.000,   0.000,   2.000,   3.500,   2.000,   3.500,   0.000,   7.000,   0.000,   7.000,
    4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   -99.000, -99.000, -99.000, 30.000,
    4.000,   1.000,   0.000,   3.000,   0.000,   3.000,   4.000,   5.000,   1.000,   0.000,
    3.000,   6.000,   -99.000, -99.000, -99.000, 31.000,  0.000,   1.000,   4.000,   3.000,
    4.000,   3.000,   0.000,   5.000,   1.000,   0.000,   3.000,   6.000,   -99.000, -99.000,
    -99.000, 32.000,  0.000,   0.000,   3.500,   0.000,   -99.000, -99.000, -99.000, 33.000,
    1.500,   7.000,   1.500,   2.000,   2.000,   1.000,   2.000,   0.000,   2.000,   0.000,
    1.000,   0.000,   1.000,   0.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,
    -99.000, -99.000, -99.000, 34.000,  2.000,   6.000,   1.000,   5.000,   3.000,   6.000,
    2.000,   5.000,   -99.000, -99.000, -99.000, 35.000,  1.000,   5.000,   1.000,   1.000,
    3.000,   1.000,   3.000,   5.000,   4.000,   4.000,   0.000,   4.000,   0.000,   2.000,
    4.000,   2.000,   -99.000, -99.000, -99.000, 36.000,  0.000,   1.000,   1.000,   0.000,
    1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,   4.000,   1.000,
    4.000,   3.000,   4.000,   3.000,   3.000,   4.000,   3.000,   4.000,   1.000,   4.000,
    1.000,   4.000,   0.000,   5.000,   0.000,   5.000,   0.000,   6.000,   0.000,   6.000,
    1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,
    2.000,   0.000,   2.000,   7.000,   -99.000, -99.000, -99.000, 37.000,  0.000,   7.000,
    1.000,   7.000,   1.000,   7.000,   1.000,   6.000,   1.000,   6.000,   0.000,   6.000,
    0.000,   6.000,   0.000,   7.000,   4.000,   7.000,   0.000,   0.000,   3.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   4.000,   1.000,   4.000,   1.000,   3.000,   1.000,
    3.000,   1.000,   3.000,   0.000,   -99.000, -99.000, -99.000, 38.000,  4.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,
    0.000,   1.000,   3.000,   6.000,   3.000,   6.000,   2.000,   7.000,   2.000,   7.000,
    1.000,   6.000,   1.000,   6.000,   1.000,   5.000,   1.000,   5.000,   4.000,   0.000,
    -99.000, -99.000, -99.000, 39.000,  2.000,   6.000,   1.000,   5.000,   -99.000, -99.000,
    -99.000, 40.000,  3.000,   0.000,   2.000,   1.000,   2.000,   1.000,   2.000,   6.000,
    2.000,   6.000,   3.000,   7.000,   -99.000, -99.000, -99.000, 41.000,  1.000,   0.000,
    2.000,   1.000,   2.000,   1.000,   2.000,   6.000,   2.000,   6.000,   1.000,   7.000,
    -99.000, -99.000, -99.000, 42.000,  0.000,   1.000,   4.000,   5.000,   0.000,   3.000,
    4.000,   3.000,   0.000,   5.000,   4.000,   1.000,   2.000,   1.000,   2.000,   5.000,
    -99.000, -99.000, -99.000, 43.000,  3.000,   5.000,   3.000,   1.000,   1.000,   3.000,
    5.000,   3.000,   -99.000, -99.000, -99.000, 44.000,  2.000,   0.000,   1.000,   0.000,
    1.000,   0.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,   2.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   0.000,   -2.000,  -99.000, -99.000, -99.000, 45.000,
    1.000,   4.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 46.000,  1.000,   0.000,
    1.000,   1.000,   1.000,   1.000,   2.000,   1.000,   2.000,   1.000,   2.000,   0.000,
    2.000,   0.000,   1.000,   0.000,   -99.000, -99.000, -99.000, 47.000,  0.000,   0.000,
    4.000,   7.000,   -99.000, -99.000, -99.000, 48.000,  1.000,   1.000,   1.000,   6.000,
    1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,
    5.000,   6.000,   5.000,   6.000,   5.000,   1.000,   5.000,   1.000,   4.000,   0.000,
    4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   -99.000, -99.000,
    -99.000, 49.000,  2.500,   6.000,   3.500,   7.000,   3.500,   7.000,   3.500,   0.000,
    2.500,   0.000,   4.500,   0.000,   -99.000, -99.000, -99.000, 50.000,  1.000,   6.000,
    2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,   5.000,   6.000,
    5.000,   6.000,   5.000,   4.000,   5.000,   4.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   5.000,   0.000,   5.000,   0.000,   5.000,   1.000,
    -99.000, -99.000, -99.000, 51.000,  1.000,   6.000,   1.000,   7.000,   1.000,   7.000,
    5.000,   7.000,   5.000,   7.000,   3.000,   4.000,   3.000,   4.000,   4.000,   4.000,
    4.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   5.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    -99.000, -99.000, -99.000, 52.000,  4.000,   0.000,   4.000,   7.000,   4.000,   7.000,
    1.000,   3.000,   1.000,   3.000,   5.000,   3.000,   3.000,   0.000,   5.000,   0.000,
    -99.000, -99.000, -99.000, 53.000,  1.000,   1.000,   2.000,   0.000,   2.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   1.000,   5.000,   3.000,
    5.000,   3.000,   4.000,   4.000,   4.000,   4.000,   1.000,   4.000,   1.000,   4.000,
    1.000,   7.000,   1.000,   7.000,   5.000,   7.000,   -99.000, -99.000, -99.000, 54.000,
    1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   4.000,   4.000,   4.000,   4.000,
    5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   5.000,   1.000,   4.000,   0.000,
    4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   6.000,   1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   5.000,   6.000,   -99.000, -99.000, -99.000, 55.000,  1.000,   0.000,
    5.000,   7.000,   5.000,   7.000,   1.000,   7.000,   1.000,   7.000,   1.000,   6.000,
    -99.000, -99.000, -99.000, 56.000,  2.000,   4.000,   1.000,   5.000,   1.000,   5.000,
    1.000,   6.000,   1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   5.000,   6.000,   5.000,   6.000,   5.000,   5.000,   5.000,   5.000,
    4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,
    5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,
    1.000,   1.000,   1.000,   1.000,   1.000,   3.000,   1.000,   3.000,   2.000,   4.000,
    2.000,   4.000,   4.000,   4.000,   -99.000, -99.000, -99.000, 57.000,  1.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   4.000,   0.000,   4.000,   0.000,   5.000,   1.000,
    5.000,   1.000,   5.000,   6.000,   5.000,   6.000,   4.000,   7.000,   4.000,   7.000,
    2.000,   7.000,   2.000,   7.000,   1.000,   6.000,   1.000,   6.000,   1.000,   4.000,
    1.000,   4.000,   2.000,   3.000,   2.000,   3.000,   4.000,   3.000,   4.000,   3.000,
    5.000,   4.000,   -99.000, -99.000, -99.000, 58.000,  2.000,   4.000,   1.000,   4.000,
    1.000,   4.000,   1.000,   5.000,   1.000,   5.000,   2.000,   5.000,   2.000,   5.000,
    2.000,   4.000,   2.000,   1.000,   1.000,   1.000,   1.000,   1.000,   1.000,   2.000,
    1.000,   2.000,   2.000,   2.000,   2.000,   2.000,   2.000,   1.000,   -99.000, -99.000,
    -99.000, 59.000,  2.000,   4.000,   1.000,   4.000,   1.000,   4.000,   1.000,   5.000,
    1.000,   5.000,   2.000,   5.000,   2.000,   5.000,   2.000,   4.000,   2.000,   1.000,
    1.000,   1.000,   1.000,   1.000,   1.000,   2.000,   1.000,   2.000,   2.000,   2.000,
    2.000,   2.000,   2.000,   1.000,   2.000,   1.000,   0.000,   -1.000,  -99.000, -99.000,
    -99.000, 60.000,  4.000,   1.000,   0.000,   3.000,   0.000,   3.000,   4.000,   5.000,
    -99.000, -99.000, -99.000, 61.000,  0.000,   4.000,   4.000,   4.000,   0.000,   3.000,
    4.000,   3.000,   -99.000, -99.000, -99.000, 62.000,  0.000,   1.000,   4.000,   3.000,
    4.000,   3.000,   0.000,   5.000,   -99.000, -99.000, -99.000, 63.000,  0.000,   6.000,
    1.000,   7.000,   1.000,   7.000,   3.000,   7.000,   3.000,   7.000,   4.000,   6.000,
    4.000,   6.000,   4.000,   5.000,   4.000,   5.000,   3.000,   4.000,   3.000,   4.000,
    2.000,   4.000,   2.000,   4.000,   2.000,   2.000,   1.500,   0.000,   1.500,   1.000,
    1.500,   1.000,   2.500,   1.000,   2.500,   1.000,   2.500,   0.000,   2.500,   0.000,
    1.500,   0.000,   -99.000, -99.000, -99.000, 64.000,  4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   1.000,   0.000,   1.000,   0.000,   0.000,   1.000,   0.000,   1.000,
    0.000,   6.000,   0.000,   6.000,   1.000,   7.000,   1.000,   7.000,   3.000,   7.000,
    3.000,   7.000,   4.000,   6.000,   4.000,   6.000,   4.000,   3.000,   4.000,   3.000,
    3.000,   2.000,   3.000,   2.000,   2.000,   2.000,   2.000,   2.000,   1.000,   3.000,
    1.000,   3.000,   1.000,   4.000,   1.000,   4.000,   2.000,   5.000,   2.000,   5.000,
    3.000,   4.000,   3.000,   4.000,   3.000,   3.000,   3.000,   3.000,   2.000,   2.000,
    -99.000, -99.000, -99.000, 65.000,  1.000,   0.000,   1.000,   6.000,   1.000,   6.000,
    2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,   5.000,   6.000,
    5.000,   6.000,   5.000,   0.000,   1.000,   4.000,   5.000,   4.000,   -99.000, -99.000,
    -99.000, 66.000,  1.000,   0.000,   1.000,   7.000,   1.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   5.000,   6.000,   5.000,   6.000,   5.000,   5.000,   5.000,   5.000,
    4.000,   4.000,   4.000,   4.000,   1.000,   4.000,   4.000,   4.000,   5.000,   3.000,
    5.000,   3.000,   5.000,   1.000,   5.000,   1.000,   4.000,   0.000,   4.000,   0.000,
    1.000,   0.000,   -99.000, -99.000, -99.000, 67.000,  1.000,   0.000,   1.000,   7.000,
    5.000,   7.000,   5.000,   0.000,   1.000,   4.000,   5.000,   4.000,   -99.000, -99.000,
    -99.000, 68.000,  1.000,   0.000,   3.000,   7.000,   3.000,   7.000,   5.000,   0.000,
    5.000,   0.000,   1.000,   0.000,   -99.000, -99.000, -99.000, 69.000,  1.000,   0.000,
    1.000,   7.000,   1.000,   7.000,   5.000,   7.000,   5.000,   7.000,   5.000,   6.000,
    1.000,   4.000,   3.000,   4.000,   1.000,   0.000,   5.000,   0.000,   5.000,   0.000,
    5.000,   1.000,   -99.000, -99.000, -99.000, 70.000,  2.000,   0.000,   4.000,   0.000,
    3.000,   0.000,   3.000,   7.000,   2.000,   7.000,   4.000,   7.000,   1.000,   4.500,
    1.000,   2.500,   1.000,   2.500,   2.000,   1.500,   2.000,   1.500,   4.000,   1.500,
    4.000,   1.500,   5.000,   2.500,   5.000,   2.500,   5.000,   4.500,   5.000,   4.500,
    4.000,   5.500,   4.000,   5.500,   2.000,   5.500,   2.000,   5.500,   1.000,   4.500,
    -99.000, -99.000, -99.000, 71.000,  1.000,   7.000,   5.000,   7.000,   5.000,   7.000,
    5.000,   6.000,   2.000,   7.000,   2.000,   0.000,   -99.000, -99.000, -99.000, 72.000,
    1.000,   0.000,   5.000,   7.000,   1.000,   7.000,   5.000,   0.000,   -99.000, -99.000,
    -99.000, 73.000,  2.000,   0.000,   4.000,   0.000,   3.000,   0.000,   3.000,   7.000,
    2.000,   7.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 74.000,  0.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   1.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 75.000,  1.000,   0.000,
    1.000,   7.000,   1.000,   3.000,   5.000,   7.000,   2.000,   4.000,   5.000,   0.000,
    -99.000, -99.000, -99.000, 76.000,  1.000,   0.000,   3.000,   7.000,   3.000,   7.000,
    5.000,   0.000,   -99.000, -99.000, -99.000, 77.000,  1.000,   0.000,   1.000,   7.000,
    1.000,   7.000,   3.000,   4.000,   3.000,   4.000,   5.000,   7.000,   5.000,   7.000,
    5.000,   0.000,   -99.000, -99.000, -99.000, 78.000,  1.000,   0.000,   1.000,   7.000,
    1.000,   7.000,   5.000,   0.000,   5.000,   0.000,   5.000,   7.000,   -99.000, -99.000,
    -99.000, 79.000,  1.000,   1.000,   1.000,   6.000,   1.000,   6.000,   2.000,   7.000,
    2.000,   7.000,   4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   5.000,   6.000,
    5.000,   1.000,   5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   2.000,   0.000,
    2.000,   0.000,   1.000,   1.000,   -99.000, -99.000, -99.000, 80.000,  4.000,   0.000,
    4.000,   7.000,   1.000,   7.000,   5.000,   7.000,   2.000,   7.000,   2.000,   0.000,
    -99.000, -99.000, -99.000, 81.000,  2.000,   3.500,   4.000,   3.500,   2.000,   2.500,
    2.000,   4.500,   4.000,   2.500,   4.000,   4.500,   1.000,   1.000,   1.000,   6.000,
    1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,
    5.000,   6.000,   5.000,   6.000,   5.000,   1.000,   5.000,   1.000,   4.000,   0.000,
    4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   -99.000, -99.000,
    -99.000, 82.000,  1.000,   0.000,   1.000,   7.000,   1.000,   7.000,   4.000,   7.000,
    4.000,   7.000,   5.000,   6.000,   5.000,   6.000,   5.000,   5.000,   5.000,   5.000,
    4.000,   4.000,   4.000,   4.000,   1.000,   4.000,   -99.000, -99.000, -99.000, 83.000,
    5.000,   6.000,   5.000,   7.000,   5.000,   7.000,   1.000,   7.000,   1.000,   7.000,
    3.000,   4.000,   3.000,   4.000,   1.000,   0.000,   1.000,   0.000,   5.000,   0.000,
    5.000,   0.000,   5.000,   1.000,   -99.000, -99.000, -99.000, 84.000,  1.000,   6.000,
    1.000,   7.000,   1.000,   7.000,   5.000,   7.000,   5.000,   7.000,   5.000,   6.000,
    2.000,   0.000,   4.000,   0.000,   3.000,   0.000,   3.000,   7.000,   -99.000, -99.000,
    -99.000, 85.000,  1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   3.000,   6.000,
    3.000,   6.000,   4.000,   7.000,   4.000,   7.000,   5.000,   6.000,   3.000,   0.000,
    3.000,   6.000,   -99.000, -99.000, -99.000, 86.000,  0.000,   7.000,   2.000,   0.000,
    2.000,   0.000,   4.000,   7.000,   -99.000, -99.000, -99.000, 87.000,  1.000,   0.000,
    2.000,   0.000,   2.000,   0.000,   1.000,   4.000,   1.000,   4.000,   1.000,   6.000,
    1.000,   6.000,   2.000,   7.000,   2.000,   7.000,   4.000,   7.000,   4.000,   7.000,
    5.000,   6.000,   5.000,   6.000,   5.000,   4.000,   5.000,   4.000,   4.000,   0.000,
    4.000,   0.000,   5.000,   0.000,   -99.000, -99.000, -99.000, 88.000,  1.000,   5.000,
    1.000,   7.000,   1.000,   6.000,   5.000,   6.000,   5.000,   7.000,   5.000,   5.000,
    2.000,   4.500,   2.000,   2.500,   2.000,   3.500,   4.000,   3.500,   4.000,   4.500,
    4.000,   2.500,   5.000,   2.000,   5.000,   0.000,   5.000,   1.000,   1.000,   1.000,
    1.000,   2.000,   1.000,   0.000,   -99.000, -99.000, -99.000, 89.000,  2.000,   0.000,
    4.000,   0.000,   3.000,   0.000,   3.000,   7.000,   2.000,   7.000,   4.000,   7.000,
    1.000,   5.500,   1.000,   3.500,   1.000,   3.500,   2.000,   2.500,   2.000,   2.500,
    4.000,   2.500,   4.000,   2.500,   5.000,   3.500,   5.000,   3.500,   5.000,   5.500,
    -99.000, -99.000, -99.000, 90.000,  1.000,   6.000,   1.000,   7.000,   1.000,   7.000,
    5.000,   7.000,   5.000,   7.000,   1.000,   0.000,   1.000,   0.000,   5.000,   0.000,
    5.000,   0.000,   5.000,   1.000,   -99.000, -99.000, -99.000, 91.000,  3.000,   0.000,
    2.000,   0.000,   2.000,   0.000,   2.000,   7.000,   2.000,   7.000,   3.000,   7.000,
    -99.000, -99.000, -99.000, 92.000,  0.000,   7.000,   4.000,   0.000,   -99.000, -99.000,
    -99.000, 93.000,  2.000,   0.000,   3.000,   0.000,   3.000,   0.000,   3.000,   7.000,
    3.000,   7.000,   2.000,   7.000,   -99.000, -99.000, -99.000, 94.000,  1.000,   4.000,
    3.000,   7.000,   3.000,   7.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 95.000,
    0.000,   0.000,   5.000,   0.000,   -99.000, -99.000, -99.000, 96.000,  1.000,   6.000,
    2.000,   5.000,   -99.000, -99.000, -99.000, 97.000,  5.000,   3.000,   3.000,   0.000,
    3.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   3.000,   1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   3.000,   4.000,
    3.000,   4.000,   5.000,   0.000,   -99.000, -99.000, -99.000, 98.000,  1.000,   -2.000,
    2.000,   5.000,   2.000,   5.000,   3.000,   6.000,   3.000,   6.000,   4.000,   6.000,
    4.000,   6.000,   5.000,   5.000,   5.000,   5.000,   5.000,   4.000,   5.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   2.000,   3.000,   2.000,   3.000,   4.000,   3.000,
    4.000,   3.000,   5.000,   2.000,   5.000,   2.000,   5.000,   1.000,   5.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    -99.000, -99.000, -99.000, 99.000,  1.000,   4.000,   2.000,   3.000,   2.000,   3.000,
    2.000,   1.000,   2.000,   1.000,   2.000,   3.000,   2.000,   3.000,   3.000,   4.000,
    3.000,   4.000,   4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   5.000,   3.000,
    4.000,   -1.000,  -99.000, -99.000, -99.000, 100.000, 4.000,   4.000,   3.000,   5.000,
    3.000,   5.000,   2.000,   5.000,   2.000,   5.000,   1.000,   4.000,   1.000,   4.000,
    4.000,   1.000,   4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   2.000,   0.000,
    2.000,   0.000,   1.000,   1.000,   1.000,   1.000,   2.000,   2.000,   2.000,   2.000,
    3.000,   2.000,   -99.000, -99.000, -99.000, 101.000, 5.000,   1.000,   4.000,   0.000,
    4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   1.000,   1.000,
    2.000,   2.000,   2.000,   2.000,   1.000,   3.000,   1.000,   3.000,   2.000,   4.000,
    2.000,   4.000,   4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   2.000,   2.000,
    3.000,   2.000,   -99.000, -99.000, -99.000, 102.000, 2.000,   3.000,   1.000,   2.000,
    1.000,   2.000,   1.000,   1.000,   1.000,   1.000,   2.000,   0.000,   2.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   1.000,   5.000,   3.000,
    5.000,   3.000,   4.000,   4.000,   4.000,   4.000,   2.000,   -1.000,  -99.000, -99.000,
    -99.000, 103.000, 1.000,   4.000,   2.000,   5.000,   2.000,   5.000,   3.000,   4.000,
    3.000,   4.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,   3.000,   0.000,
    2.000,   1.000,   2.000,   1.000,   2.000,   3.000,   2.000,   3.000,   4.000,   5.000,
    -99.000, -99.000, -99.000, 104.000, 1.000,   0.000,   5.000,   4.000,   5.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   4.000,   2.000,   4.000,   1.000,   4.000,
    -99.000, -99.000, -99.000, 105.000, 2.000,   4.000,   2.000,   1.000,   2.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   4.000,   1.000,   -99.000, -99.000, -99.000, 106.000,
    5.000,   1.000,   4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,
    1.000,   1.000,   1.000,   1.000,   1.000,   3.000,   1.000,   3.000,   2.000,   4.000,
    2.000,   4.000,   4.000,   4.000,   4.000,   4.000,   5.000,   3.000,   1.000,   2.000,
    3.000,   2.000,   -99.000, -99.000, -99.000, 107.000, 4.000,   4.000,   1.000,   2.000,
    1.000,   2.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,   1.000,   0.000,
    1.000,   4.000,   -99.000, -99.000, -99.000, 108.000, 1.000,   0.000,   3.000,   2.000,
    1.000,   5.000,   3.000,   2.000,   3.000,   2.000,   4.000,   0.000,   -99.000, -99.000,
    -99.000, 109.000, 1.000,   4.000,   1.000,   1.000,   1.000,   1.000,   2.000,   0.000,
    2.000,   0.000,   4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   4.000,
    5.000,   0.000,   1.000,   1.000,   1.000,   -2.000,  -99.000, -99.000, -99.000, 110.000,
    1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   2.000,   1.000,   2.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   4.000,   1.000,   4.000,   1.000,   5.000,   2.000,
    5.000,   2.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 111.000, 1.000,   1.000,
    1.000,   3.000,   1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   4.000,   4.000,
    4.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   5.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    -99.000, -99.000, -99.000, 112.000, 2.000,   0.000,   2.000,   4.000,   4.000,   0.000,
    4.000,   4.000,   1.000,   4.000,   5.000,   4.000,   -99.000, -99.000, -99.000, 113.000,
    1.000,   3.000,   2.000,   4.000,   2.000,   4.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   3.000,   4.000,   3.000,   4.000,   1.000,   4.000,   1.000,   3.000,   0.000,
    3.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   3.000,   1.000,   2.000,   4.000,   2.000,   -99.000, -99.000, -99.000, 114.000,
    1.000,   -2.000,  1.000,   2.000,   1.000,   2.000,   2.000,   3.000,   2.000,   3.000,
    3.000,   3.000,   3.000,   3.000,   4.000,   2.000,   4.000,   2.000,   4.000,   1.000,
    4.000,   1.000,   3.000,   0.000,   3.000,   0.000,   2.000,   0.000,   2.000,   0.000,
    1.000,   1.000,   -99.000, -99.000, -99.000, 115.000, 5.000,   3.000,   2.000,   3.000,
    2.000,   3.000,   1.000,   2.000,   1.000,   2.000,   1.000,   1.000,   1.000,   1.000,
    2.000,   0.000,   2.000,   0.000,   3.000,   0.000,   3.000,   0.000,   4.000,   1.000,
    4.000,   1.000,   4.000,   2.000,   4.000,   2.000,   3.000,   3.000,   -99.000, -99.000,
    -99.000, 116.000, 3.000,   4.000,   3.000,   1.000,   3.000,   1.000,   4.000,   0.000,
    4.000,   0.000,   5.000,   1.000,   1.000,   3.000,   2.000,   4.000,   2.000,   4.000,
    4.000,   4.000,   4.000,   4.000,   5.000,   5.000,   -99.000, -99.000, -99.000, 117.000,
    1.000,   4.000,   1.000,   1.000,   1.000,   1.000,   2.000,   0.000,   2.000,   0.000,
    4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   1.000,   5.000,   4.000,
    -99.000, -99.000, -99.000, 118.000, 1.000,   1.000,   1.000,   3.000,   1.000,   3.000,
    2.000,   4.000,   2.000,   4.000,   4.000,   4.000,   4.000,   4.000,   5.000,   3.000,
    5.000,   3.000,   5.000,   1.000,   5.000,   1.000,   4.000,   0.000,   4.000,   0.000,
    2.000,   0.000,   2.000,   0.000,   1.000,   1.000,   4.000,   5.000,   2.000,   -1.000,
    -99.000, -99.000, -99.000, 119.000, 2.000,   3.000,   1.000,   2.000,   1.000,   2.000,
    1.000,   1.000,   1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   3.000,   1.000,
    3.000,   1.000,   3.000,   2.000,   3.000,   2.000,   3.000,   1.000,   3.000,   1.000,
    4.000,   0.000,   4.000,   0.000,   5.000,   1.000,   5.000,   1.000,   5.000,   2.000,
    5.000,   2.000,   4.000,   3.000,   -99.000, -99.000, -99.000, 120.000, 1.000,   5.000,
    2.000,   4.000,   2.000,   4.000,   3.000,   4.000,   3.000,   4.000,   4.000,   5.000,
    4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   3.000,   1.000,   3.000,
    1.000,   2.000,   1.000,   2.000,   3.000,   2.000,   3.000,   2.000,   4.000,   3.000,
    4.000,   3.000,   3.000,   3.000,   3.000,   3.000,   1.000,   1.000,   1.000,   1.000,
    1.000,   0.000,   1.000,   0.000,   3.000,   0.000,   3.000,   0.000,   2.000,   -1.000,
    -99.000, -99.000, -99.000, 121.000, 0.000,   4.000,   1.000,   3.000,   1.000,   3.000,
    1.000,   1.000,   1.000,   1.000,   2.000,   0.000,   2.000,   0.000,   3.000,   0.000,
    3.000,   0.000,   4.000,   1.000,   4.000,   1.000,   4.000,   2.000,   4.000,   2.000,
    5.000,   4.000,   3.000,   5.000,   1.000,   -2.000,  -99.000, -99.000, -99.000, 122.000,
    1.000,   5.000,   2.000,   4.000,   2.000,   4.000,   3.000,   4.000,   3.000,   4.000,
    4.000,   5.000,   4.000,   5.000,   3.000,   5.000,   3.000,   5.000,   1.000,   3.000,
    1.000,   3.000,   1.000,   2.000,   1.000,   2.000,   3.000,   1.000,   3.000,   1.000,
    3.000,   0.000,   3.000,   0.000,   2.000,   0.000,   2.000,   0.000,   1.000,   1.000,
    1.000,   1.000,   0.000,   0.000,   0.000,   0.000,   0.000,   0.000,   0.000,   0.000,
    0.000,   0.000,   -99.000, -99.000, -99.000, 123.000, 3.000,   0.000,   2.000,   1.000,
    2.000,   1.000,   2.000,   3.000,   2.000,   3.000,   1.000,   3.500,   1.000,   3.500,
    2.000,   4.000,   2.000,   4.000,   2.000,   6.000,   2.000,   6.000,   3.000,   7.000,
    -99.000, -99.000, -99.000, 124.000, 2.000,   0.000,   2.000,   7.000,   -99.000, -99.000,
    -99.000, 125.000, 1.000,   0.000,   2.000,   1.000,   2.000,   1.000,   2.000,   3.000,
    2.000,   3.000,   3.000,   3.500,   3.000,   3.500,   2.000,   4.000,   2.000,   4.000,
    2.000,   6.000,   2.000,   6.000,   1.000,   7.000,   -99.000, -99.000, -99.000, 126.000,
    0.000,   3.500,   1.000,   4.500,   1.000,   4.500,   3.000,   2.500,   3.000,   2.500,
    4.000,   3.500,   -99.000, -99.000, -99.000, 127.000, 0.000,   4.000,   1.000,   5.000,
    1.000,   5.000,   3.000,   3.000,   3.000,   3.000,   4.000,   4.000,   0.000,   2.000,
    1.000,   3.000,   1.000,   3.000,   3.000,   1.000,   3.000,   1.000,   4.000,   2.000,
    -99.000, -99.000, -99.000, 999.000};

static real serif_data[] = {
    -99.00,    -99.00,    -99.00,    4.00,      0.00,      6.64,      -3.23,     6.51,
    1.81,      6.51,      0.00,      6.64,      1.81,      3.23,      1.81,      6.51,
    6.13,      3.23,      1.81,      3.23,      6.51,      0.38,      6.13,      3.23,
    6.13,      -4.66,     6.51,      0.38,      4.70,      -5.04,     6.13,      -4.66,
    5.04,      -2.14,     4.70,      -5.04,     3.95,      -2.14,     5.04,      -2.14,
    3.61,      0.38,      3.95,      -2.14,     1.81,      0.38,      3.61,      0.38,
    2.14,      -7.22,     1.81,      0.38,      -2.14,     -7.22,     2.14,      -7.22,
    -1.81,     0.38,      -2.14,     -7.22,     -3.61,     0.38,      -1.81,     0.38,
    -3.95,     -2.14,     -3.61,     0.38,      -5.04,     -2.14,     -3.95,     -2.14,
    -4.70,     -5.04,     -5.04,     -2.14,     -6.13,     -4.70,     -4.70,     -5.04,
    -6.51,     0.38,      -6.13,     -4.70,     -6.13,     3.23,      -6.51,     0.38,
    -1.81,     3.23,      -6.13,     3.23,      -1.81,     5.04,      -1.81,     3.23,
    -3.23,     5.00,      -1.81,     5.04,      -3.23,     6.51,      -3.23,     5.00,
    3.23,      -8.32,     0.00,      -8.32,     6.13,      -7.94,     3.23,      -8.32,
    7.22,      -7.60,     6.13,      -7.94,     7.60,      -7.22,     7.22,      -7.60,
    7.94,      -6.13,     7.60,      -7.22,     8.32,      -3.23,     7.94,      -6.13,
    8.32,      0.00,      8.32,      -3.23,     3.23,      8.32,      0.00,      8.32,
    6.13,      7.94,      3.23,      8.32,      7.22,      7.56,      6.13,      7.94,
    7.60,      7.22,      7.22,      7.56,      7.94,      6.13,      7.60,      7.22,
    8.32,      3.23,      7.94,      6.13,      8.32,      0.00,      8.32,      3.23,
    -3.23,     8.32,      0.00,      8.32,      -6.13,     7.94,      -3.23,     8.32,
    -7.22,     7.56,      -6.13,     7.94,      -7.60,     7.22,      -7.22,     7.56,
    -7.94,     6.13,      -7.60,     7.22,      -8.32,     3.23,      -7.94,     6.13,
    -8.32,     0.00,      -8.32,     3.23,      -3.23,     -8.32,     0.00,      -8.32,
    -6.13,     -7.94,     -3.23,     -8.32,     -7.22,     -7.60,     -6.13,     -7.94,
    -7.60,     -7.22,     -7.22,     -7.60,     -7.94,     -6.13,     -7.60,     -7.22,
    -8.32,     -3.23,     -7.94,     -6.13,     -8.32,     0.00,      -8.32,     -3.23,
    3.61,      -10.50,    0.00,      -10.50,    6.85,      -10.12,    3.61,      -10.50,
    8.32,      -9.74,     6.85,      -10.12,    9.03,      -9.41,     8.32,      -9.74,
    9.41,      -9.03,     9.03,      -9.41,     9.74,      -8.32,     9.41,      -9.03,
    10.12,     -6.85,     9.74,      -8.32,     10.50,     -3.61,     10.12,     -6.85,
    10.50,     0.00,      10.50,     -3.61,     3.61,      10.46,     0.00,      10.46,
    6.85,      10.12,     3.61,      10.46,     8.32,      9.74,      6.85,      10.12,
    9.03,      9.41,      8.32,      9.74,      9.41,      9.03,      9.03,      9.41,
    9.74,      8.32,      9.41,      9.03,      10.12,     6.85,      9.74,      8.32,
    10.50,     3.61,      10.12,     6.85,      10.50,     0.00,      10.50,     3.61,
    -3.61,     10.46,     0.00,      10.46,     -6.85,     10.12,     -3.61,     10.46,
    -8.32,     9.74,      -6.85,     10.12,     -9.03,     9.41,      -8.32,     9.74,
    -9.41,     9.03,      -9.03,     9.41,      -9.74,     8.32,      -9.41,     9.03,
    -10.12,    6.85,      -9.74,     8.32,      -10.50,    3.61,      -10.12,    6.85,
    -10.50,    0.00,      -10.50,    3.61,      -3.61,     -10.50,    0.00,      -10.50,
    -6.85,     -10.12,    -3.61,     -10.50,    -8.32,     -9.74,     -6.85,     -10.12,
    -9.03,     -9.41,     -8.32,     -9.74,     -9.41,     -9.03,     -9.03,     -9.41,
    -9.74,     -8.32,     -9.41,     -9.03,     -10.12,    -6.85,     -9.74,     -8.32,
    -10.50,    -3.61,     -10.12,    -6.85,     -10.50,    0.00,      -10.50,    -3.61,
    -99.00,    -99.00,    -99.00,    5.00,      -10.50,    -10.50,    10.50,     -10.50,
    10.50,     -10.50,    10.50,     10.50,     10.50,     10.50,     -10.50,    10.50,
    -10.50,    10.50,     -10.50,    -10.50,    -99.00,    -99.00,    -99.00,    6.00,
    0.00,      -10.50,    10.50,     0.00,      10.50,     0.00,      0.00,      10.50,
    0.00,      10.50,     -10.50,    0.00,      -10.50,    0.00,      0.00,      -10.50,
    -99.00,    -99.00,    -99.00,    7.00,      0.00,      -10.50,    0.00,      10.50,
    -10.50,    0.00,      10.50,     0.00,      -99.00,    -99.00,    -99.00,    8.00,
    -10.50,    -10.50,    10.50,     10.50,     -10.50,    10.50,     10.50,     -10.50,
    -99.00,    -99.00,    -99.00,    9.00,      -10.50,    -7.50,     0.00,      13.50,
    0.00,      13.50,     10.50,     -7.50,     10.50,     -7.50,     -10.50,    -7.50,
    -99.00,    -99.00,    -99.00,    10.00,     10.50,     0.00,      9.99,      3.24,
    9.99,      3.24,      8.49,      6.17,      8.49,      6.17,      6.17,      8.49,
    6.17,      8.49,      3.24,      9.99,      3.24,      9.99,      0.00,      10.50,
    0.00,      10.50,     -3.24,     9.99,      -3.24,     9.99,      -6.17,     8.49,
    -6.17,     8.49,      -8.49,     6.17,      -8.49,     6.17,      -9.99,     3.24,
    -9.99,     3.24,      -10.50,    0.00,      -10.50,    0.00,      -9.99,     -3.24,
    -9.99,     -3.24,     -8.49,     -6.17,     -8.49,     -6.17,     -6.17,     -8.49,
    -6.17,     -8.49,     -3.24,     -9.99,     -3.24,     -9.99,     0.00,      -10.50,
    0.00,      -10.50,    3.24,      -9.99,     3.24,      -9.99,     6.17,      -8.49,
    6.17,      -8.49,     8.49,      -6.17,     8.49,      -6.17,     9.99,      -3.24,
    9.99,      -3.24,     10.50,     0.00,      -99.00,    -99.00,    -99.00,    11.00,
    -2.00,     0.00,      2.00,      0.00,      0.00,      2.00,      0.00,      -2.00,
    1.41,      1.41,      -1.41,     -1.41,     -1.41,     1.41,      1.41,      -1.41,
    -99.00000, -99.00000, -99.00000, 12.000000, 10.50000,  17.14000,  7.270000,  17.01000,
    12.31000,  17.01000,  10.50000,  17.14000,  12.31000,  13.73000,  12.31000,  17.01000,
    16.63000,  13.73000,  12.31000,  13.73000,  17.01000,  10.88000,  16.63000,  13.73000,
    16.63000,  5.840000,  17.01000,  10.88000,  15.20000,  5.460000,  16.63000,  5.840000,
    15.54000,  8.360000,  15.20000,  5.460000,  14.45000,  8.360000,  15.54000,  8.360000,
    14.11000,  10.88000,  14.45000,  8.360000,  12.31000,  10.88000,  14.11000,  10.88000,
    12.64000,  3.280000,  12.31000,  10.88000,  8.360000,  3.280000,  12.64000,  3.280000,
    8.690001,  10.88000,  8.360000,  3.280000,  6.890000,  10.88000,  8.690001,  10.88000,
    6.550000,  8.360000,  6.890000,  10.88000,  5.460000,  8.360000,  6.550000,  8.360000,
    5.800000,  5.460000,  5.460000,  8.360000,  4.370000,  5.800000,  5.800000,  5.460000,
    3.990000,  10.88000,  4.370000,  5.800000,  4.370000,  13.73000,  3.990000,  10.88000,
    8.690001,  13.73000,  4.370000,  13.73000,  8.690001,  15.54000,  8.690001,  13.73000,
    7.270000,  15.50000,  8.690001,  15.54000,  7.270000,  17.01000,  7.270000,  15.50000,
    13.73000,  2.180000,  10.50000,  2.180000,  16.63000,  2.560000,  13.73000,  2.180000,
    17.72000,  2.900000,  16.63000,  2.560000,  18.10000,  3.280000,  17.72000,  2.900000,
    18.44000,  4.370000,  18.10000,  3.280000,  18.82000,  7.270000,  18.44000,  4.370000,
    18.82000,  10.50000,  18.82000,  7.270000,  13.73000,  18.82000,  10.50000,  18.82000,
    16.63000,  18.44000,  13.73000,  18.82000,  17.72000,  18.06000,  16.63000,  18.44000,
    18.10000,  17.72000,  17.72000,  18.06000,  18.44000,  16.63000,  18.10000,  17.72000,
    18.82000,  13.73000,  18.44000,  16.63000,  18.82000,  10.50000,  18.82000,  13.73000,
    7.270000,  18.82000,  10.50000,  18.82000,  4.370000,  18.44000,  7.270000,  18.82000,
    3.280000,  18.06000,  4.370000,  18.44000,  2.900000,  17.72000,  3.280000,  18.06000,
    2.560000,  16.63000,  2.900000,  17.72000,  2.180000,  13.73000,  2.560000,  16.63000,
    2.180000,  10.50000,  2.180000,  13.73000,  7.270000,  2.180000,  10.50000,  2.180000,
    4.370000,  2.560000,  7.270000,  2.180000,  3.280000,  2.900000,  4.370000,  2.560000,
    2.900000,  3.280000,  3.280000,  2.900000,  2.560000,  4.370000,  2.900000,  3.280000,
    2.180000,  7.270000,  2.560000,  4.370000,  2.180000,  10.50000,  2.180000,  7.270000,
    14.11000,  0.0000000, 10.50000,  0.0000000, 17.35000,  0.3800001, 14.11000,  0.0000000,
    18.82000,  0.7600002, 17.35000,  0.3800001, 19.53000,  1.090000,  18.82000,  0.7600002,
    19.91000,  1.470000,  19.53000,  1.090000,  20.24000,  2.180000,  19.91000,  1.470000,
    20.62000,  3.650000,  20.24000,  2.180000,  21.00000,  6.890000,  20.62000,  3.650000,
    21.00000,  10.50000,  21.00000,  6.890000,  14.11000,  20.96000,  10.50000,  20.96000,
    17.35000,  20.62000,  14.11000,  20.96000,  18.82000,  20.24000,  17.35000,  20.62000,
    19.53000,  19.91000,  18.82000,  20.24000,  19.91000,  19.53000,  19.53000,  19.91000,
    20.24000,  18.82000,  19.91000,  19.53000,  20.62000,  17.35000,  20.24000,  18.82000,
    21.00000,  14.11000,  20.62000,  17.35000,  21.00000,  10.50000,  21.00000,  14.11000,
    6.890000,  20.96000,  10.50000,  20.96000,  3.650000,  20.62000,  6.890000,  20.96000,
    2.180000,  20.24000,  3.650000,  20.62000,  1.470000,  19.91000,  2.180000,  20.24000,
    1.090000,  19.53000,  1.470000,  19.91000,  0.7600002, 18.82000,  1.090000,  19.53000,
    0.3800001, 17.35000,  0.7600002, 18.82000,  0.0000000, 14.11000,  0.3800001, 17.35000,
    0.0000000, 10.50000,  0.0000000, 14.11000,  6.890000,  0.0000000, 10.50000,  0.0000000,
    3.650000,  0.3800001, 6.890000,  0.0000000, 2.180000,  0.7600002, 3.650000,  0.3800001,
    1.470000,  1.090000,  2.180000,  0.7600002, 1.090000,  1.470000,  1.470000,  1.090000,
    0.7600002, 2.180000,  1.090000,  1.470000,  0.3800001, 3.650000,  0.7600002, 2.180000,
    0.0000000, 6.890000,  0.3800001, 3.650000,  0.0000000, 10.50000,  0.0000000, 6.890000,
    -99.00000, -99.00000, -99.00000, 13.000000, 0.0000000, 0.0000000, 21.00000,  0.0000000,
    21.00000,  0.0000000, 21.00000,  21.00000,  21.00000,  21.00000,  0.0000000, 21.00000,
    0.0000000, 21.00000,  0.0000000, 0.0000000, -99.00000, -99.00000, -99.00000, 14.000000,
    10.50000,  0.0000000, 21.00000,  10.50000,  21.00000,  10.50000,  10.50000,  21.00000,
    10.50000,  21.00000,  0.0000000, 10.50000,  0.0000000, 10.50000,  10.50000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 15.000000, 10.50000,  0.0000000, 10.50000,  21.00000,
    0.0000000, 10.50000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 16.000000,
    0.0000000, 0.0000000, 21.00000,  21.00000,  0.0000000, 21.00000,  21.00000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 17.000000, 0.0000000, 0.000000,  10.50000,  21.00000,
    10.50000,  21.00000,  21.00000,  0.000000,  21.00000,  0.000000,  0.0000000, 0.000000,
    -99.00000, -99.00000, -99.00000, 18.00000,  21.00000,  10.50000,  20.49000,  13.74000,
    20.49000,  13.74000,  18.99000,  16.67000,  18.99000,  16.67000,  16.67000,  18.99000,
    16.67000,  18.99000,  13.74000,  20.49000,  13.74000,  20.49000,  10.50000,  21.00000,
    10.50000,  21.00000,  7.260000,  20.49000,  7.260000,  20.49000,  4.330000,  18.99000,
    4.330000,  18.99000,  2.010000,  16.67000,  2.010000,  16.67000,  0.5100002, 13.74000,
    0.5100002, 13.74000,  0.0000000, 10.50000,  0.0000000, 10.50000,  0.5100002, 7.260000,
    0.5100002, 7.260000,  2.010000,  4.330000,  2.010000,  4.330000,  4.330000,  2.010000,
    4.330000,  2.010000,  7.260000,  0.5100002, 7.260000,  0.5100002, 10.50000,  0.0000000,
    10.50000,  0.0000000, 13.74000,  0.5100002, 13.74000,  0.5100002, 16.67000,  2.010000,
    16.67000,  2.010000,  18.99000,  4.330000,  18.99000,  4.330000,  20.49000,  7.260000,
    20.49000,  7.260000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 19.00000,
    8.500000,  10.50000,  12.50000,  10.50000,  10.50000,  12.50000,  10.50000,  8.500000,
    11.91000,  11.91000,  9.090000,  9.090000,  9.090000,  11.91000,  11.91000,  9.090000,
    -99.00,    -99.00,    -99.00,    20.00,     10.50,     21.00,     10.50,     3.00,
    1.50,      12.00,     19.50,     12.00,     1.50,      0.00,      19.50,     0.00,
    -99.00,    -99.00,    -99.00,    21.00,     16.00,     21.00,     0.00,      12.00,
    0.00,      12.00,     16.00,     3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    22.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    23.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      4.00,      -2.00,     14.00,     20.00,
    -99.00,    -99.00,    -99.00,    24.00,     3.00,      19.00,     4.00,      24.00,
    4.00,      24.00,     5.00,      25.00,     5.00,      25.00,     6.00,      24.00,
    6.00,      24.00,     3.00,      19.00,     -99.00,    -99.00,    -99.00,    25.00,
    16.00,     21.00,     0.00,      12.00,     0.00,      12.00,     16.00,     3.00,
    0.00,      0.00,      16.00,     0.00,      11.00,     24.00,     6.00,      -4.00,
    -99.00,    -99.00,    -99.00,    26.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      16.00,     0.00,      0.00,      0.00,
    9.00,      23.00,     4.00,      -4.00,     -99.00,    -99.00,    -99.00,    27.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    24.00,     18.00,     8.00,      9.00,      8.00,      9.00,      24.00,     0.00,
    -99.00,    -99.00,    -99.00,    28.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      8.00,      18.00,     24.00,     9.00,
    24.00,     9.00,      8.00,      0.00,      -99.00,    -99.00,    -99.00,    29.00,
    16.00,     2.00,      15.00,     0.00,      15.00,     0.00,      0.00,      0.00,
    4.00,      0.00,      12.00,     1.00,      12.00,     1.00,      16.00,     2.00,
    0.00,      0.00,      8.00,      10.50,     8.00,      10.50,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     16.00,     19.00,
    16.00,     19.00,     12.00,     20.00,     12.00,     20.00,     4.00,      21.00,
    2.00,      20.00,     9.00,      10.50,     9.00,      10.50,     2.00,      1.00,
    -99.00,    -99.00,    -99.00,    30.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      11.00,     23.00,     6.00,      -3.00,
    -99.00,    -99.00,    -99.00,    31.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      9.00,      23.00,     4.00,      -4.00,
    -99.00,    -99.00,    -99.00,    32.00,     10.50,     0.00,      10.50,     0.00,
    -99.00,    -99.00,    -99.00,    33.00,     2.00,      7.00,      1.00,      7.00,
    1.00,      7.00,      1.00,      21.00,     1.00,      21.00,     2.00,      21.00,
    2.00,      21.00,     2.00,      7.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      -99.00,    -99.00,    -99.00,    34.00,
    10.00,     20.00,     9.00,      14.00,     9.00,      14.00,     9.00,      20.00,
    9.00,      20.00,     10.00,     21.00,     10.00,     21.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      14.00,     1.00,      20.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      20.00,     0.00,      20.00,     1.00,      21.00,
    1.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      14.00,
    -99.00,    -99.00,    -99.00,    35.00,     8.00,      21.00,     1.00,      -7.00,
    14.00,     21.00,     7.00,      -7.00,     1.00,      10.00,     15.00,     10.00,
    0.00,      4.00,      14.00,     4.00,      -99.00,    -99.00,    -99.00,    36.00,
    2.00,      3.00,      3.00,      2.00,      3.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    11.00,     2.00,      12.00,     4.00,      12.00,     4.00,      12.00,     6.00,
    12.00,     6.00,      11.00,     8.00,      11.00,     8.00,      10.00,     9.00,
    10.00,     9.00,      2.00,      13.00,     2.00,      13.00,     1.00,      14.00,
    1.00,      14.00,     0.00,      16.00,     0.00,      16.00,     0.00,      18.00,
    0.00,      18.00,     2.00,      20.00,     2.00,      20.00,     5.00,      21.00,
    5.00,      21.00,     8.00,      21.00,     8.00,      21.00,     11.00,     20.00,
    11.00,     20.00,     13.00,     18.00,     13.00,     18.00,     11.00,     18.00,
    11.00,     18.00,     10.00,     19.00,     10.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     5.00,      20.00,     5.00,      20.00,     2.00,      19.00,
    2.00,      19.00,     1.00,      18.00,     1.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      14.00,     2.00,      14.00,     10.00,     10.00,
    10.00,     10.00,     12.00,     8.00,      12.00,     8.00,      13.00,     6.00,
    13.00,     6.00,      13.00,     4.00,      13.00,     4.00,      12.00,     2.00,
    12.00,     2.00,      11.00,     1.00,      11.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      0.00,      3.00,      0.00,      3.00,      2.00,      3.00,
    7.00,      -4.00,     6.00,      -4.00,     6.00,      -4.00,     6.00,      25.00,
    6.00,      25.00,     7.00,      25.00,     7.00,      25.00,     7.00,      -4.00,
    12.00,     3.00,      9.00,      1.00,      -99.00,    -99.00,    -99.00,    37.00,
    0.00,      0.00,      18.00,     21.00,     18.00,     21.00,     16.00,     20.00,
    16.00,     20.00,     13.00,     19.00,     13.00,     19.00,     10.00,     19.00,
    10.00,     19.00,     7.00,      20.00,     7.00,      20.00,     5.00,      21.00,
    5.00,      21.00,     3.00,      21.00,     3.00,      21.00,     1.00,      20.00,
    1.00,      20.00,     0.00,      18.00,     0.00,      18.00,     0.00,      16.00,
    0.00,      16.00,     2.00,      14.00,     2.00,      14.00,     4.00,      14.00,
    4.00,      14.00,     6.00,      15.00,     6.00,      15.00,     7.00,      17.00,
    7.00,      17.00,     7.00,      19.00,     7.00,      19.00,     5.00,      21.00,
    14.00,     7.00,      12.00,     6.00,      12.00,     6.00,      11.00,     4.00,
    11.00,     4.00,      11.00,     2.00,      11.00,     2.00,      13.00,     0.00,
    13.00,     0.00,      15.00,     0.00,      15.00,     0.00,      17.00,     1.00,
    17.00,     1.00,      18.00,     3.00,      18.00,     3.00,      18.00,     5.00,
    18.00,     5.00,      16.00,     7.00,      16.00,     7.00,      14.00,     7.00,
    -99.00,    -99.00,    -99.00,    38.00,     15.00,     12.00,     17.00,     13.00,
    17.00,     13.00,     19.00,     13.00,     19.00,     13.00,     19.00,     14.00,
    19.00,     14.00,     17.00,     14.00,     17.00,     14.00,     15.00,     13.00,
    15.00,     13.00,     14.00,     11.00,     14.00,     11.00,     12.00,     5.00,
    12.00,     5.00,      11.00,     3.00,      11.00,     3.00,      10.00,     2.00,
    10.00,     2.00,      8.00,      1.00,      8.00,      1.00,      4.00,      1.00,
    4.00,      1.00,      2.00,      2.00,      2.00,      2.00,      1.00,      4.00,
    1.00,      4.00,      1.00,      6.00,      1.00,      6.00,      2.00,      8.00,
    2.00,      8.00,      3.00,      9.00,      3.00,      9.00,      8.00,      12.00,
    8.00,      12.00,     10.00,     14.00,     10.00,     14.00,     11.00,     16.00,
    11.00,     16.00,     11.00,     18.00,     11.00,     18.00,     10.00,     20.00,
    10.00,     20.00,     8.00,      21.00,     8.00,      21.00,     7.00,      21.00,
    7.00,      21.00,     5.00,      20.00,     5.00,      20.00,     4.00,      18.00,
    4.00,      18.00,     4.00,      16.00,     4.00,      16.00,     5.00,      13.00,
    5.00,      13.00,     7.00,      10.00,     7.00,      10.00,     12.00,     4.00,
    12.00,     4.00,      15.00,     1.00,      15.00,     1.00,      17.00,     0.00,
    17.00,     0.00,      19.00,     0.00,      19.00,     0.00,      19.00,     1.00,
    19.00,     1.00,      17.00,     1.00,      17.00,     1.00,      15.00,     2.00,
    15.00,     2.00,      13.00,     4.00,      13.00,     4.00,      8.00,      10.00,
    8.00,      10.00,     6.00,      13.00,     6.00,      13.00,     5.00,      16.00,
    5.00,      16.00,     5.00,      18.00,     5.00,      18.00,     6.00,      20.00,
    16.00,     13.00,     15.00,     11.00,     15.00,     11.00,     13.00,     5.00,
    13.00,     5.00,      12.00,     3.00,      12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      8.00,      1.00,      8.00,      3.00,      10.00,
    3.00,      10.00,     8.00,      13.00,     8.00,      13.00,     9.00,      14.00,
    9.00,      14.00,     10.00,     16.00,     10.00,     16.00,     10.00,     18.00,
    10.00,     18.00,     9.00,      20.00,     10.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     7.00,      20.00,     7.00,      20.00,     5.00,      19.00,
    -99.00,    -99.00,    -99.00,    39.00,     1.00,      20.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      20.00,     0.00,      20.00,     1.00,      21.00,
    1.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      14.00,
    -99.00,    -99.00,    -99.00,    40.00,     8.00,      -7.00,     7.00,      -7.00,
    7.00,      -7.00,     5.00,      -5.00,     5.00,      -5.00,     3.00,      -2.00,
    3.00,      -2.00,     1.00,      2.00,      1.00,      2.00,      0.00,      7.00,
    0.00,      7.00,      0.00,      11.00,     0.00,      11.00,     1.00,      16.00,
    1.00,      16.00,     3.00,      20.00,     3.00,      20.00,     5.00,      23.00,
    5.00,      23.00,     7.00,      25.00,     7.00,      25.00,     8.00,      25.00,
    8.00,      25.00,     6.00,      23.00,     6.00,      23.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      16.00,     2.00,      16.00,     1.00,      11.00,
    1.00,      11.00,     1.00,      7.00,      1.00,      7.00,      2.00,      2.00,
    2.00,      2.00,      4.00,      -2.00,     4.00,      -2.00,     6.00,      -5.00,
    6.00,      -5.00,     8.00,      -7.00,     -99.00,    -99.00,    -99.00,    41.00,
    1.00,      -7.00,     0.00,      -7.00,     0.00,      -7.00,     2.00,      -5.00,
    2.00,      -5.00,     4.00,      -2.00,     4.00,      -2.00,     6.00,      2.00,
    6.00,      2.00,      7.00,      7.00,      7.00,      7.00,      7.00,      11.00,
    7.00,      11.00,     6.00,      16.00,     6.00,      16.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      23.00,     2.00,      23.00,     0.00,      25.00,
    0.00,      25.00,     1.00,      25.00,     1.00,      25.00,     3.00,      23.00,
    3.00,      23.00,     5.00,      20.00,     5.00,      20.00,     7.00,      16.00,
    7.00,      16.00,     8.00,      11.00,     8.00,      11.00,     8.00,      7.00,
    8.00,      7.00,      7.00,      2.00,      7.00,      2.00,      5.00,      -2.00,
    5.00,      -2.00,     3.00,      -5.00,     3.00,      -5.00,     1.00,      -7.00,
    -99.00,    -99.00,    -99.00,    42.00,     0.00,      8.00,      10.00,     14.00,
    10.00,     14.00,     9.00,      14.00,     9.00,      14.00,     1.00,      8.00,
    1.00,      8.00,      0.00,      8.00,      0.00,      8.00,      0.00,      9.00,
    0.00,      9.00,      10.00,     13.00,     10.00,     13.00,     10.00,     14.00,
    10.00,     8.00,      0.00,      14.00,     0.00,      14.00,     1.00,      14.00,
    1.00,      14.00,     9.00,      8.00,      9.00,      8.00,      10.00,     8.00,
    10.00,     8.00,      10.00,     9.00,      10.00,     9.00,      0.00,      13.00,
    0.00,      13.00,     0.00,      14.00,     5.00,      5.00,      5.00,      17.00,
    5.00,      17.00,     4.00,      16.00,     4.00,      16.00,     6.00,      6.00,
    6.00,      6.00,      5.00,      5.00,      5.00,      5.00,      4.00,      6.00,
    4.00,      6.00,      6.00,      16.00,     6.00,      16.00,     5.00,      17.00,
    -99.00,    -99.00,    -99.00,    43.00,     17.00,     9.00,      17.00,     10.00,
    17.00,     10.00,     0.00,      10.00,     0.00,      10.00,     0.00,      9.00,
    0.00,      9.00,      17.00,     9.00,      9.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      8.00,      18.00,     8.00,      18.00,     9.00,      18.00,
    9.00,      18.00,     9.00,      1.00,      -99.00,    -99.00,    -99.00,    44.00,
    0.00,      -4.00,     2.00,      -3.00,     2.00,      -3.00,     3.00,      -1.00,
    3.00,      -1.00,     3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      2.00,      -3.00,     1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      2.00,      0.00,      3.00,      -1.00,
    -99.00,    -99.00,    -99.00,    45.00,     17.00,     9.00,      17.00,     10.00,
    17.00,     10.00,     0.00,      10.00,     0.00,      10.00,     0.00,      9.00,
    0.00,      9.00,      17.00,     9.00,      -99.00,    -99.00,    -99.00,    46.00,
    1.00,      3.00,      0.00,      2.00,      0.00,      2.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      0.00,      1.00,      0.00,      2.00,      0.00,
    2.00,      0.00,      3.00,      1.00,      3.00,      1.00,      3.00,      2.00,
    3.00,      2.00,      2.00,      3.00,      2.00,      3.00,      1.00,      3.00,
    1.00,      2.00,      1.00,      1.00,      1.00,      1.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      2.00,      2.00,      2.00,      1.00,      2.00,
    -99.00,    -99.00,    -99.00,    47.00,     1.00,      -7.00,     0.00,      -7.00,
    0.00,      -7.00,     18.00,     25.00,     18.00,     25.00,     19.00,     25.00,
    19.00,     25.00,     1.00,      -7.00,     -99.00,    -99.00,    -99.00,    48.00,
    6.00,      21.00,     3.00,      20.00,     3.00,      20.00,     1.00,      17.00,
    1.00,      17.00,     0.00,      12.00,     0.00,      12.00,     0.00,      9.00,
    0.00,      9.00,      1.00,      4.00,      1.00,      4.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      8.00,      0.00,
    8.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     4.00,
    13.00,     4.00,      14.00,     9.00,      14.00,     9.00,      14.00,     12.00,
    14.00,     12.00,     13.00,     17.00,     13.00,     17.00,     11.00,     20.00,
    11.00,     20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    4.00,      20.00,     2.00,      17.00,     2.00,      17.00,     1.00,      12.00,
    1.00,      12.00,     1.00,      9.00,      1.00,      9.00,      2.00,      4.00,
    2.00,      4.00,      4.00,      1.00,      3.00,      2.00,      6.00,      1.00,
    6.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    10.00,     1.00,      12.00,     4.00,      12.00,     4.00,      13.00,     9.00,
    13.00,     9.00,      13.00,     12.00,     13.00,     12.00,     12.00,     17.00,
    12.00,     17.00,     10.00,     20.00,     11.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     6.00,      20.00,     6.00,      20.00,     3.00,      19.00,
    -99.00,    -99.00,    -99.00,    49.00,     11.00,     0.00,      11.00,     21.00,
    11.00,     21.00,     8.00,      18.00,     8.00,      18.00,     6.00,      17.00,
    6.00,      17.00,     6.00,      16.00,     6.00,      16.00,     8.00,      17.00,
    8.00,      17.00,     10.00,     19.00,     10.00,     19.00,     10.00,     0.00,
    10.00,     0.00,      11.00,     0.00,      -99.00,    -99.00,    -99.00,    50.00,
    1.00,      0.00,      10.00,     10.00,     10.00,     10.00,     12.00,     13.00,
    12.00,     13.00,     13.00,     15.00,     13.00,     15.00,     13.00,     17.00,
    13.00,     17.00,     12.00,     19.00,     12.00,     19.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     9.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     3.00,      20.00,     3.00,      20.00,     2.00,      19.00,
    2.00,      19.00,     1.00,      17.00,     1.00,      17.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      16.00,     2.00,      16.00,     2.00,      17.00,
    2.00,      17.00,     3.00,      19.00,     3.00,      19.00,     5.00,      20.00,
    5.00,      20.00,     9.00,      20.00,     9.00,      20.00,     11.00,     19.00,
    11.00,     19.00,     12.00,     17.00,     12.00,     17.00,     12.00,     15.00,
    12.00,     15.00,     11.00,     13.00,     11.00,     13.00,     9.00,      10.00,
    9.00,      10.00,     0.00,      0.00,      0.00,      0.00,      14.00,     0.00,
    14.00,     0.00,      14.00,     1.00,      14.00,     1.00,      1.00,      1.00,
    -99.00,    -99.00,    -99.00,    51.00,     6.00,      13.00,     8.00,      13.00,
    8.00,      13.00,     11.00,     12.00,     11.00,     12.00,     13.00,     10.00,
    13.00,     10.00,     14.00,     7.00,      14.00,     7.00,      14.00,     6.00,
    14.00,     6.00,      13.00,     3.00,      13.00,     3.00,      11.00,     1.00,
    11.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      1.00,      4.00,
    1.00,      4.00,      2.00,      2.00,      2.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    11.00,     2.00,      13.00,     5.00,      12.00,     21.00,     5.00,      12.00,
    5.00,      12.00,     8.00,      12.00,     8.00,      12.00,     11.00,     11.00,
    11.00,     11.00,     13.00,     8.00,      6.00,      12.00,     13.00,     21.00,
    13.00,     21.00,     2.00,      21.00,     2.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     12.00,     20.00,     9.00,      12.00,     12.00,     10.00,
    12.00,     10.00,     13.00,     7.00,      13.00,     7.00,      13.00,     6.00,
    13.00,     6.00,      12.00,     3.00,      12.00,     3.00,      9.00,      1.00,
    4.00,      1.00,      1.00,      3.00,      -99.00,    -99.00,    -99.00,    52.00,
    1.00,      5.00,      10.00,     18.00,     10.00,     18.00,     10.00,     0.00,
    10.00,     0.00,      11.00,     0.00,      11.00,     0.00,      11.00,     21.00,
    11.00,     21.00,     0.00,      5.00,      0.00,      5.00,      15.00,     5.00,
    15.00,     5.00,      15.00,     6.00,      15.00,     6.00,      1.00,      6.00,
    -99.00,    -99.00,    -99.00,    53.00,     13.00,     9.00,      11.00,     12.00,
    11.00,     12.00,     8.00,      13.00,     8.00,      13.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      12.00,     2.00,      12.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      21.00,     2.00,      21.00,     12.00,     21.00,
    12.00,     21.00,     12.00,     20.00,     12.00,     20.00,     3.00,      20.00,
    3.00,      20.00,     2.00,      13.00,     2.00,      13.00,     5.00,      14.00,
    5.00,      14.00,     8.00,      14.00,     8.00,      14.00,     11.00,     13.00,
    11.00,     13.00,     13.00,     11.00,     13.00,     11.00,     14.00,     8.00,
    14.00,     8.00,      14.00,     6.00,      14.00,     6.00,      13.00,     3.00,
    13.00,     3.00,      11.00,     1.00,      11.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      2.00,      1.00,      2.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      4.00,      1.00,      4.00,      2.00,      2.00,
    2.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      11.00,     2.00,      11.00,     2.00,      13.00,     5.00,
    9.00,      13.00,     12.00,     11.00,     12.00,     11.00,     13.00,     8.00,
    13.00,     8.00,      13.00,     6.00,      13.00,     6.00,      12.00,     3.00,
    12.00,     3.00,      9.00,      1.00,      4.00,      1.00,      1.00,      3.00,
    -99.00,    -99.00,    -99.00,    54.00,     10.00,     20.00,     11.00,     18.00,
    11.00,     18.00,     12.00,     18.00,     12.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    6.00,      21.00,     3.00,      20.00,     3.00,      20.00,     1.00,      17.00,
    1.00,      17.00,     0.00,      12.00,     0.00,      12.00,     0.00,      7.00,
    0.00,      7.00,      1.00,      3.00,      1.00,      3.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      10.00,     1.00,      10.00,     1.00,      12.00,     3.00,
    12.00,     3.00,      13.00,     6.00,      13.00,     6.00,      13.00,     7.00,
    13.00,     7.00,      12.00,     10.00,     12.00,     10.00,     10.00,     12.00,
    10.00,     12.00,     7.00,      13.00,     7.00,      13.00,     6.00,      13.00,
    6.00,      13.00,     3.00,      12.00,     3.00,      12.00,     1.00,      10.00,
    11.00,     19.00,     8.00,      20.00,     8.00,      20.00,     6.00,      20.00,
    6.00,      20.00,     3.00,      19.00,     4.00,      20.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      12.00,     1.00,      12.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      3.00,      2.00,      3.00,      5.00,      1.00,
    1.00,      5.00,      3.00,      2.00,      3.00,      2.00,      6.00,      1.00,
    6.00,      1.00,      7.00,      1.00,      7.00,      1.00,      10.00,     2.00,
    10.00,     2.00,      12.00,     5.00,      8.00,      1.00,      11.00,     3.00,
    11.00,     3.00,      12.00,     6.00,      12.00,     6.00,      12.00,     7.00,
    12.00,     7.00,      11.00,     10.00,     11.00,     10.00,     8.00,      12.00,
    12.00,     8.00,      10.00,     11.00,     10.00,     11.00,     7.00,      12.00,
    7.00,      12.00,     6.00,      12.00,     6.00,      12.00,     3.00,      11.00,
    3.00,      11.00,     1.00,      8.00,      5.00,      12.00,     2.00,      10.00,
    2.00,      10.00,     1.00,      7.00,      -99.00,    -99.00,    -99.00,    55.00,
    13.00,     20.00,     0.00,      20.00,     0.00,      20.00,     0.00,      21.00,
    0.00,      21.00,     14.00,     21.00,     14.00,     21.00,     4.00,      0.00,
    4.00,      0.00,      3.00,      0.00,      3.00,      0.00,      13.00,     21.00,
    -99.00,    -99.00,    -99.00,    56.00,     5.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     1.00,      18.00,     1.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      14.00,     2.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      12.00,     5.00,      12.00,     9.00,      11.00,
    9.00,      11.00,     11.00,     10.00,     11.00,     10.00,     12.00,     9.00,
    12.00,     9.00,      13.00,     7.00,      13.00,     7.00,      13.00,     4.00,
    13.00,     4.00,      12.00,     2.00,      12.00,     2.00,      9.00,      1.00,
    9.00,      1.00,      5.00,      1.00,      5.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      4.00,      1.00,      4.00,      1.00,      7.00,
    1.00,      7.00,      2.00,      9.00,      2.00,      9.00,      3.00,      10.00,
    3.00,      10.00,     5.00,      11.00,     5.00,      11.00,     9.00,      12.00,
    9.00,      12.00,     11.00,     13.00,     11.00,     13.00,     12.00,     14.00,
    12.00,     14.00,     13.00,     16.00,     13.00,     16.00,     13.00,     18.00,
    13.00,     18.00,     12.00,     20.00,     12.00,     20.00,     9.00,      21.00,
    9.00,      21.00,     5.00,      21.00,     3.00,      20.00,     2.00,      18.00,
    2.00,      18.00,     2.00,      16.00,     2.00,      16.00,     3.00,      14.00,
    3.00,      14.00,     5.00,      13.00,     5.00,      13.00,     9.00,      12.00,
    9.00,      12.00,     11.00,     11.00,     11.00,     11.00,     13.00,     9.00,
    13.00,     9.00,      14.00,     7.00,      14.00,     7.00,      14.00,     4.00,
    14.00,     4.00,      13.00,     2.00,      13.00,     2.00,      12.00,     1.00,
    12.00,     1.00,      9.00,      0.00,      9.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      7.00,
    0.00,      7.00,      1.00,      9.00,      1.00,      9.00,      3.00,      11.00,
    3.00,      11.00,     5.00,      12.00,     5.00,      12.00,     9.00,      13.00,
    9.00,      13.00,     11.00,     14.00,     11.00,     14.00,     12.00,     16.00,
    12.00,     16.00,     12.00,     18.00,     12.00,     18.00,     11.00,     20.00,
    12.00,     19.00,     9.00,      20.00,     9.00,      20.00,     5.00,      20.00,
    5.00,      20.00,     2.00,      19.00,     1.00,      3.00,      4.00,      1.00,
    10.00,     1.00,      13.00,     3.00,      -99.00,    -99.00,    -99.00,    57.00,
    12.00,     11.00,     10.00,     9.00,      10.00,     9.00,      7.00,      8.00,
    7.00,      8.00,      6.00,      8.00,      6.00,      8.00,      3.00,      9.00,
    3.00,      9.00,      1.00,      11.00,     1.00,      11.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      15.00,     0.00,      15.00,     1.00,      18.00,
    1.00,      18.00,     3.00,      20.00,     3.00,      20.00,     6.00,      21.00,
    6.00,      21.00,     7.00,      21.00,     7.00,      21.00,     10.00,     20.00,
    10.00,     20.00,     12.00,     18.00,     12.00,     18.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     9.00,      13.00,     9.00,      12.00,     4.00,
    12.00,     4.00,      10.00,     1.00,      10.00,     1.00,      7.00,      0.00,
    7.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      3.00,      1.00,      3.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      1.00,      12.00,     14.00,     11.00,     11.00,
    11.00,     11.00,     8.00,      9.00,      12.00,     13.00,     10.00,     10.00,
    10.00,     10.00,     7.00,      9.00,      7.00,      9.00,      6.00,      9.00,
    6.00,      9.00,      3.00,      10.00,     3.00,      10.00,     1.00,      13.00,
    5.00,      9.00,      2.00,      11.00,     2.00,      11.00,     1.00,      14.00,
    1.00,      14.00,     1.00,      15.00,     1.00,      15.00,     2.00,      18.00,
    2.00,      18.00,     5.00,      20.00,     1.00,      16.00,     3.00,      19.00,
    3.00,      19.00,     6.00,      20.00,     6.00,      20.00,     7.00,      20.00,
    7.00,      20.00,     10.00,     19.00,     10.00,     19.00,     12.00,     16.00,
    8.00,      20.00,     11.00,     18.00,     11.00,     18.00,     12.00,     14.00,
    12.00,     14.00,     12.00,     9.00,      12.00,     9.00,      11.00,     4.00,
    11.00,     4.00,      9.00,      1.00,      10.00,     2.00,      7.00,      1.00,
    7.00,      1.00,      5.00,      1.00,      5.00,      1.00,      2.00,      2.00,
    -99.00,    -99.00,    -99.00,    58.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      12.00,     0.00,      12.00,     1.00,      11.00,
    1.00,      11.00,     2.00,      11.00,     2.00,      11.00,     3.00,      12.00,
    3.00,      12.00,     3.00,      13.00,     3.00,      13.00,     2.00,      14.00,
    2.00,      14.00,     1.00,      14.00,     1.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      12.00,     2.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      13.00,     1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      -99.00,    -99.00,    -99.00,    59.00,
    0.00,      -4.00,     2.00,      -3.00,     2.00,      -3.00,     3.00,      -1.00,
    3.00,      -1.00,     3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      2.00,      -3.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      12.00,     0.00,      12.00,     1.00,      11.00,
    1.00,      11.00,     2.00,      11.00,     2.00,      11.00,     3.00,      12.00,
    3.00,      12.00,     3.00,      13.00,     3.00,      13.00,     2.00,      14.00,
    2.00,      14.00,     1.00,      14.00,     1.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      12.00,     2.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      13.00,     1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      2.00,      0.00,      3.00,      -1.00,
    -99.00,    -99.00,    -99.00,    60.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      -99.00,    -99.00,    -99.00,    61.00,
    17.00,     5.00,      17.00,     6.00,      17.00,     6.00,      0.00,      6.00,
    0.00,      6.00,      0.00,      5.00,      0.00,      5.00,      17.00,     5.00,
    17.00,     13.00,     17.00,     14.00,     17.00,     14.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      13.00,     0.00,      13.00,     17.00,     13.00,
    -99.00,    -99.00,    -99.00,    62.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      -99.00,    -99.00,    -99.00,    63.00,
    6.00,      10.00,     9.00,      11.00,     9.00,      11.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     13.00,     12.00,     13.00,     13.00,     15.00,
    13.00,     15.00,     13.00,     17.00,     13.00,     17.00,     12.00,     19.00,
    12.00,     19.00,     11.00,     20.00,     11.00,     20.00,     8.00,      21.00,
    8.00,      21.00,     5.00,      21.00,     5.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     1.00,      19.00,     1.00,      19.00,     0.00,      17.00,
    0.00,      17.00,     0.00,      16.00,     0.00,      16.00,     1.00,      16.00,
    1.00,      16.00,     1.00,      17.00,     1.00,      17.00,     2.00,      19.00,
    2.00,      19.00,     5.00,      20.00,     5.00,      20.00,     8.00,      20.00,
    8.00,      20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     15.00,     12.00,     15.00,     11.00,     13.00,
    11.00,     13.00,     9.00,      12.00,     9.00,      12.00,     6.00,      11.00,
    6.00,      11.00,     6.00,      7.00,      6.00,      7.00,      7.00,      7.00,
    7.00,      7.00,      7.00,      11.00,     1.00,      18.00,     4.00,      20.00,
    9.00,      20.00,     12.00,     18.00,     12.00,     14.00,     8.00,      11.00,
    6.00,      3.00,      5.00,      2.00,      5.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      8.00,      1.00,      8.00,      1.00,      8.00,      2.00,
    8.00,      2.00,      7.00,      3.00,      7.00,      3.00,      6.00,      3.00,
    6.00,      2.00,      6.00,      1.00,      6.00,      1.00,      7.00,      1.00,
    7.00,      1.00,      7.00,      2.00,      7.00,      2.00,      6.00,      2.00,
    -99.00,    -99.00,    -99.00,    64.00,     15.00,     13.00,     14.00,     15.00,
    14.00,     15.00,     12.00,     16.00,     12.00,     16.00,     9.00,      16.00,
    9.00,      16.00,     7.00,      15.00,     7.00,      15.00,     6.00,      14.00,
    6.00,      14.00,     5.00,      11.00,     5.00,      11.00,     5.00,      8.00,
    5.00,      8.00,      6.00,      6.00,      6.00,      6.00,      8.00,      5.00,
    8.00,      5.00,      11.00,     5.00,      11.00,     5.00,      13.00,     6.00,
    13.00,     6.00,      14.00,     8.00,      9.00,      16.00,     7.00,      14.00,
    7.00,      14.00,     6.00,      11.00,     6.00,      11.00,     6.00,      8.00,
    6.00,      8.00,      7.00,      6.00,      7.00,      6.00,      8.00,      5.00,
    15.00,     16.00,     14.00,     8.00,      14.00,     8.00,      14.00,     6.00,
    14.00,     6.00,      16.00,     5.00,      16.00,     5.00,      18.00,     5.00,
    18.00,     5.00,      20.00,     7.00,      20.00,     7.00,      21.00,     10.00,
    21.00,     10.00,     21.00,     12.00,     21.00,     12.00,     20.00,     15.00,
    20.00,     15.00,     19.00,     17.00,     19.00,     17.00,     17.00,     19.00,
    17.00,     19.00,     15.00,     20.00,     15.00,     20.00,     12.00,     21.00,
    12.00,     21.00,     9.00,      21.00,     9.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      15.00,     1.00,      15.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      9.00,      0.00,      9.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      4.00,      2.00,      4.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     0.00,      12.00,     0.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     2.00,      17.00,     2.00,      18.00,     3.00,
    16.00,     16.00,     15.00,     8.00,      15.00,     8.00,      15.00,     6.00,
    15.00,     6.00,      16.00,     5.00,      -99.00,    -99.00,    -99.00,    65.00,
    16.00,     0.00,      15.00,     0.00,      15.00,     0.00,      8.00,      18.00,
    8.00,      18.00,     1.00,      0.00,      1.00,      0.00,      0.00,      0.00,
    0.00,      0.00,      8.00,      21.00,     8.00,      21.00,     16.00,     0.00,
    3.00,      6.00,      13.00,     6.00,      2.00,      5.00,      14.00,     5.00,
    -99.00,    -99.00,    -99.00,    66.00,     8.00,      11.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     14.00,     12.00,     14.00,     12.00,     17.00,
    12.00,     17.00,     11.00,     19.00,     11.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     1.00,      20.00,     1.00,      20.00,     1.00,      1.00,
    1.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    11.00,     2.00,      12.00,     4.00,      12.00,     4.00,      12.00,     7.00,
    12.00,     7.00,      11.00,     9.00,      11.00,     9.00,      8.00,      10.00,
    8.00,      10.00,     1.00,      10.00,     8.00,      10.00,     11.00,     11.00,
    11.00,     11.00,     12.00,     12.00,     12.00,     12.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     17.00,     13.00,     17.00,     12.00,     19.00,
    12.00,     19.00,     11.00,     20.00,     11.00,     20.00,     8.00,      21.00,
    8.00,      21.00,     0.00,      21.00,     0.00,      21.00,     0.00,      0.00,
    0.00,      0.00,      8.00,      0.00,      8.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      12.00,     2.00,      12.00,     2.00,      13.00,     4.00,
    13.00,     4.00,      13.00,     7.00,      13.00,     7.00,      12.00,     9.00,
    12.00,     9.00,      11.00,     10.00,     11.00,     10.00,     8.00,      11.00,
    8.00,      11.00,     1.00,      11.00,     -99.00,    -99.00,    -99.00,    67.00,
    15.00,     5.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      10.00,     0.00,      10.00,     0.00,      6.00,      0.00,
    6.00,      0.00,      4.00,      1.00,      4.00,      1.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      5.00,      1.00,      5.00,      0.00,      8.00,
    0.00,      8.00,      0.00,      13.00,     0.00,      13.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      18.00,     2.00,      18.00,     4.00,      20.00,
    4.00,      20.00,     6.00,      21.00,     6.00,      21.00,     10.00,     21.00,
    10.00,     21.00,     12.00,     20.00,     12.00,     20.00,     14.00,     18.00,
    14.00,     18.00,     15.00,     16.00,     15.00,     16.00,     14.00,     16.00,
    14.00,     16.00,     13.00,     18.00,     13.00,     18.00,     12.00,     19.00,
    12.00,     19.00,     10.00,     20.00,     10.00,     20.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      13.00,     1.00,      13.00,     1.00,      8.00,
    1.00,      8.00,      2.00,      5.00,      2.00,      5.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     2.00,      12.00,     2.00,      13.00,     3.00,
    13.00,     3.00,      14.00,     5.00,      14.00,     5.00,      15.00,     5.00,
    -99.00,    -99.00,    -99.00,    68.00,     1.00,      1.00,      1.00,      20.00,
    1.00,      20.00,     7.00,      20.00,     7.00,      20.00,     10.00,     19.00,
    10.00,     19.00,     11.00,     18.00,     11.00,     18.00,     12.00,     16.00,
    12.00,     16.00,     13.00,     13.00,     13.00,     13.00,     13.00,     8.00,
    13.00,     8.00,      12.00,     5.00,      12.00,     5.00,      11.00,     3.00,
    11.00,     3.00,      10.00,     2.00,      10.00,     2.00,      7.00,      1.00,
    7.00,      1.00,      1.00,      1.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     7.00,      21.00,     7.00,      21.00,     10.00,     20.00,
    10.00,     20.00,     12.00,     18.00,     12.00,     18.00,     13.00,     16.00,
    13.00,     16.00,     14.00,     13.00,     14.00,     13.00,     14.00,     8.00,
    14.00,     8.00,      13.00,     5.00,      13.00,     5.00,      12.00,     3.00,
    12.00,     3.00,      10.00,     1.00,      10.00,     1.00,      7.00,      0.00,
    7.00,      0.00,      0.00,      0.00,      -99.00,    -99.00,    -99.00,    69.00,
    1.00,      11.00,     7.00,      11.00,     7.00,      11.00,     7.00,      10.00,
    7.00,      10.00,     1.00,      10.00,     12.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      1.00,      1.00,      1.00,      1.00,      1.00,      20.00,
    1.00,      20.00,     12.00,     20.00,     12.00,     20.00,     12.00,     21.00,
    12.00,     21.00,     0.00,      21.00,     0.00,      21.00,     0.00,      0.00,
    0.00,      0.00,      12.00,     0.00,      -99.00,    -99.00,    -99.00,    70.00,
    1.00,      11.00,     7.00,      11.00,     7.00,      11.00,     7.00,      10.00,
    7.00,      10.00,     1.00,      10.00,     12.00,     21.00,     0.00,      21.00,
    0.00,      21.00,     0.00,      0.00,      0.00,      0.00,      1.00,      0.00,
    1.00,      0.00,      1.00,      20.00,     1.00,      20.00,     12.00,     20.00,
    12.00,     20.00,     12.00,     21.00,     -99.00,    -99.00,    -99.00,    71.00,
    10.00,     9.00,      15.00,     9.00,      15.00,     9.00,      15.00,     5.00,
    15.00,     5.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      10.00,     0.00,      10.00,     0.00,      6.00,      0.00,
    6.00,      0.00,      4.00,      1.00,      4.00,      1.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      5.00,      1.00,      5.00,      0.00,      8.00,
    0.00,      8.00,      0.00,      13.00,     0.00,      13.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      18.00,     2.00,      18.00,     4.00,      20.00,
    4.00,      20.00,     6.00,      21.00,     6.00,      21.00,     10.00,     21.00,
    10.00,     21.00,     12.00,     20.00,     12.00,     20.00,     14.00,     18.00,
    14.00,     18.00,     15.00,     16.00,     15.00,     16.00,     14.00,     16.00,
    14.00,     16.00,     13.00,     18.00,     13.00,     18.00,     12.00,     19.00,
    12.00,     19.00,     10.00,     20.00,     10.00,     20.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     3.00,      18.00,
    3.00,      18.00,     2.00,      16.00,     2.00,      16.00,     1.00,      13.00,
    1.00,      13.00,     1.00,      8.00,      1.00,      8.00,      2.00,      5.00,
    2.00,      5.00,      3.00,      3.00,      3.00,      3.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     2.00,      12.00,     2.00,      13.00,     3.00,
    13.00,     3.00,      14.00,     5.00,      14.00,     5.00,      14.00,     8.00,
    14.00,     8.00,      10.00,     8.00,      10.00,     8.00,      10.00,     9.00,
    -99.00,    -99.00,    -99.00,    72.00,     14.00,     0.00,      13.00,     0.00,
    13.00,     0.00,      13.00,     21.00,     13.00,     21.00,     14.00,     21.00,
    14.00,     21.00,     14.00,     0.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      0.00,
    1.00,      0.00,      0.00,      0.00,      1.00,      11.00,     13.00,     11.00,
    1.00,      10.00,     13.00,     10.00,     -99.00,    -99.00,    -99.00,    73.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    74.00,     0.00,      5.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      2.00,      2.00,      2.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      1.00,      6.00,      1.00,      8.00,      2.00,
    8.00,      2.00,      9.00,      5.00,      9.00,      5.00,      9.00,      21.00,
    9.00,      21.00,     10.00,     21.00,     10.00,     21.00,     10.00,     5.00,
    10.00,     5.00,      9.00,      2.00,      9.00,      2.00,      8.00,      1.00,
    8.00,      1.00,      6.00,      0.00,      6.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      5.00,      -99.00,    -99.00,    -99.00,    75.00,
    4.00,      12.00,     13.00,     0.00,      13.00,     0.00,      14.00,     0.00,
    14.00,     0.00,      5.00,      12.00,     1.00,      9.00,      13.00,     21.00,
    13.00,     21.00,     14.00,     21.00,     14.00,     21.00,     1.00,      8.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    76.00,     12.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      1.00,      1.00,      1.00,      1.00,      1.00,      21.00,
    1.00,      21.00,     0.00,      21.00,     0.00,      21.00,     0.00,      0.00,
    0.00,      0.00,      12.00,     0.00,      -99.00,    -99.00,    -99.00,    77.00,
    16.00,     0.00,      15.00,     0.00,      15.00,     0.00,      15.00,     16.00,
    15.00,     16.00,     8.00,      0.00,      8.00,      0.00,      1.00,      16.00,
    1.00,      16.00,     1.00,      0.00,      1.00,      0.00,      0.00,      0.00,
    0.00,      0.00,      0.00,      21.00,     0.00,      21.00,     8.00,      3.00,
    8.00,      3.00,      16.00,     21.00,     16.00,     21.00,     16.00,     0.00,
    -99.00,    -99.00,    -99.00,    78.00,     13.00,     21.00,     13.00,     3.00,
    13.00,     3.00,      0.00,      21.00,     0.00,      21.00,     0.00,      0.00,
    0.00,      0.00,      1.00,      0.00,      1.00,      0.00,      1.00,      18.00,
    1.00,      18.00,     14.00,     0.00,      14.00,     0.00,      14.00,     21.00,
    14.00,     21.00,     13.00,     21.00,     -99.00,    -99.00,    -99.00,    79.00,
    6.00,      21.00,     4.00,      20.00,     4.00,      20.00,     2.00,      18.00,
    2.00,      18.00,     1.00,      16.00,     1.00,      16.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      8.00,      0.00,      8.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      0.00,      6.00,      0.00,      10.00,     0.00,
    10.00,     0.00,      12.00,     1.00,      12.00,     1.00,      14.00,     3.00,
    14.00,     3.00,      15.00,     5.00,      15.00,     5.00,      16.00,     8.00,
    16.00,     8.00,      16.00,     13.00,     16.00,     13.00,     15.00,     16.00,
    15.00,     16.00,     14.00,     18.00,     14.00,     18.00,     12.00,     20.00,
    12.00,     20.00,     10.00,     21.00,     10.00,     21.00,     6.00,      21.00,
    7.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      13.00,     1.00,      13.00,     1.00,      8.00,
    1.00,      8.00,      2.00,      5.00,      2.00,      5.00,      4.00,      2.00,
    4.00,      2.00,      7.00,      1.00,      7.00,      1.00,      9.00,      1.00,
    9.00,      1.00,      12.00,     2.00,      12.00,     2.00,      14.00,     5.00,
    14.00,     5.00,      15.00,     8.00,      15.00,     8.00,      15.00,     13.00,
    15.00,     13.00,     14.00,     16.00,     14.00,     16.00,     12.00,     19.00,
    12.00,     19.00,     9.00,      20.00,     9.00,      20.00,     7.00,      20.00,
    -99.00,    -99.00,    -99.00,    80.00,     1.00,      10.00,     9.00,      10.00,
    9.00,      10.00,     11.00,     11.00,     11.00,     11.00,     12.00,     12.00,
    12.00,     12.00,     13.00,     14.00,     13.00,     14.00,     13.00,     17.00,
    13.00,     17.00,     12.00,     19.00,     12.00,     19.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     9.00,      21.00,     0.00,      21.00,
    0.00,      21.00,     0.00,      0.00,      0.00,      0.00,      1.00,      0.00,
    1.00,      0.00,      1.00,      20.00,     1.00,      20.00,     9.00,      20.00,
    9.00,      20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     14.00,     12.00,     14.00,     11.00,     12.00,
    11.00,     12.00,     9.00,      11.00,     9.00,      11.00,     1.00,      11.00,
    -99.00,    -99.00,    -99.00,    81.00,     15.00,     -2.00,     14.00,     -2.00,
    14.00,     -2.00,     9.00,      3.00,      9.00,      3.00,      10.00,     3.00,
    10.00,     3.00,      15.00,     -2.00,     6.00,      21.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      18.00,     2.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     0.00,      13.00,     0.00,      13.00,     0.00,      8.00,
    0.00,      8.00,      1.00,      5.00,      1.00,      5.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      10.00,     0.00,      10.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     3.00,      14.00,     3.00,      15.00,     5.00,
    15.00,     5.00,      16.00,     8.00,      16.00,     8.00,      16.00,     13.00,
    16.00,     13.00,     15.00,     16.00,     15.00,     16.00,     14.00,     18.00,
    14.00,     18.00,     12.00,     20.00,     12.00,     20.00,     10.00,     21.00,
    10.00,     21.00,     6.00,      21.00,     7.00,      20.00,     4.00,      19.00,
    4.00,      19.00,     2.00,      16.00,     2.00,      16.00,     1.00,      13.00,
    1.00,      13.00,     1.00,      8.00,      1.00,      8.00,      2.00,      5.00,
    2.00,      5.00,      4.00,      2.00,      4.00,      2.00,      7.00,      1.00,
    7.00,      1.00,      9.00,      1.00,      9.00,      1.00,      12.00,     2.00,
    12.00,     2.00,      14.00,     5.00,      14.00,     5.00,      15.00,     8.00,
    15.00,     8.00,      15.00,     13.00,     15.00,     13.00,     14.00,     16.00,
    14.00,     16.00,     12.00,     19.00,     12.00,     19.00,     9.00,      20.00,
    9.00,      20.00,     7.00,      20.00,     -99.00,    -99.00,    -99.00,    82.00,
    6.00,      10.00,     12.00,     0.00,      12.00,     0.00,      13.00,     0.00,
    13.00,     0.00,      7.00,      10.00,     1.00,      10.00,     8.00,      10.00,
    8.00,      10.00,     11.00,     11.00,     11.00,     11.00,     12.00,     12.00,
    12.00,     12.00,     13.00,     14.00,     13.00,     14.00,     13.00,     17.00,
    13.00,     17.00,     12.00,     19.00,     12.00,     19.00,     11.00,     20.00,
    11.00,     20.00,     8.00,      21.00,     8.00,      21.00,     0.00,      21.00,
    0.00,      21.00,     0.00,      0.00,      0.00,      0.00,      1.00,      0.00,
    1.00,      0.00,      1.00,      20.00,     1.00,      20.00,     8.00,      20.00,
    8.00,      20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     14.00,     12.00,     14.00,     11.00,     12.00,
    11.00,     12.00,     8.00,      11.00,     8.00,      11.00,     1.00,      11.00,
    -99.00,    -99.00,    -99.00,    83.00,     0.00,      3.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      2.00,      3.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      9.00,      1.00,      9.00,      1.00,      12.00,     2.00,
    12.00,     2.00,      13.00,     3.00,      13.00,     3.00,      13.00,     6.00,
    13.00,     6.00,      12.00,     8.00,      12.00,     8.00,      11.00,     9.00,
    11.00,     9.00,      9.00,      10.00,     9.00,      10.00,     4.00,      12.00,
    4.00,      12.00,     2.00,      13.00,     2.00,      13.00,     1.00,      14.00,
    1.00,      14.00,     0.00,      16.00,     0.00,      16.00,     0.00,      18.00,
    0.00,      18.00,     2.00,      20.00,     2.00,      20.00,     5.00,      21.00,
    5.00,      21.00,     9.00,      21.00,     9.00,      21.00,     12.00,     20.00,
    12.00,     20.00,     14.00,     18.00,     14.00,     18.00,     12.00,     18.00,
    12.00,     18.00,     11.00,     19.00,     11.00,     19.00,     9.00,      20.00,
    9.00,      20.00,     5.00,      20.00,     5.00,      20.00,     2.00,      19.00,
    2.00,      19.00,     1.00,      18.00,     1.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      14.00,     2.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     9.00,      11.00,     9.00,      11.00,     11.00,     10.00,
    11.00,     10.00,     13.00,     8.00,      13.00,     8.00,      14.00,     6.00,
    14.00,     6.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      9.00,      0.00,      9.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      2.00,      1.00,      2.00,      1.00,      0.00,      3.00,
    -99.00,    -99.00,    -99.00,    84.00,     13.00,     20.00,     13.00,     21.00,
    13.00,     21.00,     0.00,      21.00,     0.00,      21.00,     0.00,      20.00,
    0.00,      20.00,     13.00,     20.00,     6.00,      20.00,     6.00,      0.00,
    6.00,      0.00,      7.00,      0.00,      7.00,      0.00,      7.00,      20.00,
    -99.00,    -99.00,    -99.00,    85.00,     14.00,     21.00,     14.00,     6.00,
    14.00,     6.00,      13.00,     3.00,      13.00,     3.00,      11.00,     1.00,
    11.00,     1.00,      8.00,      0.00,      8.00,      0.00,      6.00,      0.00,
    6.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      3.00,      2.00,
    3.00,      2.00,      6.00,      1.00,      6.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      11.00,     2.00,      11.00,     2.00,      12.00,     3.00,
    12.00,     3.00,      13.00,     6.00,      13.00,     6.00,      13.00,     21.00,
    13.00,     21.00,     14.00,     21.00,     -99.00,    -99.00,    -99.00,    86.00,
    16.00,     21.00,     15.00,     21.00,     15.00,     21.00,     8.00,      3.00,
    8.00,      3.00,      1.00,      21.00,     1.00,      21.00,     0.00,      21.00,
    0.00,      21.00,     8.00,      0.00,      8.00,      0.00,      16.00,     21.00,
    -99.00,    -99.00,    -99.00,    87.00,     22.00,     21.00,     21.00,     21.00,
    21.00,     21.00,     16.00,     3.00,      16.00,     3.00,      11.00,     21.00,
    11.00,     21.00,     6.00,      3.00,      6.00,      3.00,      1.00,      21.00,
    1.00,      21.00,     0.00,      21.00,     0.00,      21.00,     6.00,      0.00,
    6.00,      0.00,      11.00,     18.00,     11.00,     18.00,     16.00,     0.00,
    16.00,     0.00,      22.00,     21.00,     -99.00,    -99.00,    -99.00,    88.00,
    0.00,      0.00,      13.00,     21.00,     13.00,     21.00,     14.00,     21.00,
    14.00,     21.00,     1.00,      0.00,      1.00,      0.00,      0.00,      0.00,
    14.00,     0.00,      13.00,     0.00,      13.00,     0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     14.00,     0.00,
    -99.00,    -99.00,    -99.00,    89.00,     8.00,      11.00,     1.00,      21.00,
    1.00,      21.00,     0.00,      21.00,     0.00,      21.00,     7.00,      11.00,
    7.00,      11.00,     7.00,      0.00,      7.00,      0.00,      8.00,      0.00,
    8.00,      0.00,      8.00,      11.00,     8.00,      11.00,     15.00,     21.00,
    15.00,     21.00,     14.00,     21.00,     14.00,     21.00,     7.00,      11.00,
    -99.00,    -99.00,    -99.00,    90.00,     1.00,      0.00,      14.00,     21.00,
    14.00,     21.00,     0.00,      21.00,     0.00,      21.00,     0.00,      20.00,
    0.00,      20.00,     13.00,     20.00,     13.00,     21.00,     0.00,      0.00,
    0.00,      0.00,      14.00,     0.00,      14.00,     0.00,      14.00,     1.00,
    14.00,     1.00,      1.00,      1.00,      -99.00,    -99.00,    -99.00,    91.00,
    7.00,      25.00,     0.00,      25.00,     0.00,      25.00,     0.00,      -7.00,
    0.00,      -7.00,     7.00,      -7.00,     1.00,      25.00,     1.00,      -7.00,
    -99.00,    -99.00,    -99.00,    92.00,     20.00,     -3.00,     19.00,     -4.00,
    19.00,     -4.00,     0.00,      28.00,     0.00,      28.00,     1.00,      29.00,
    1.00,      29.00,     20.00,     -3.00,     -99.00,    -99.00,    -99.00,    93.00,
    0.00,      25.00,     7.00,      25.00,     7.00,      25.00,     7.00,      -7.00,
    7.00,      -7.00,     0.00,      -7.00,     6.00,      25.00,     6.00,      -7.00,
    -99.00,    -99.00,    -99.00,    94.00,     0.00,      16.00,     8.00,      21.00,
    8.00,      21.00,     16.00,     16.00,     16.00,     16.00,     8.00,      20.00,
    8.00,      20.00,     0.00,      16.00,     -99.00,    -99.00,    -99.00,    95.00,
    17.00,     -2.00,     17.00,     -1.00,     17.00,     -1.00,     0.00,      -1.00,
    0.00,      -1.00,     0.00,      -2.00,     0.00,      -2.00,     17.00,     -2.00,
    -99.00,    -99.00,    -99.00,    96.00,     6.00,      15.00,     1.00,      21.00,
    1.00,      21.00,     0.00,      20.00,     0.00,      20.00,     6.00,      15.00,
    -99.00,    -99.00,    -99.00,    97.00,     12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      8.00,
    0.00,      8.00,      1.00,      11.00,     1.00,      11.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      14.00,     5.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     12.00,     11.00,
    12.00,     11.00,     8.00,      13.00,     8.00,      13.00,     5.00,      13.00,
    5.00,      13.00,     3.00,      12.00,     3.00,      12.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      3.00,      2.00,
    3.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      12.00,     3.00,      13.00,     0.00,      12.00,     0.00,
    12.00,     0.00,      12.00,     14.00,     12.00,     14.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     0.00,      -99.00,    -99.00,    -99.00,    98.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     3.00,      12.00,     3.00,      13.00,     6.00,
    13.00,     6.00,      13.00,     8.00,      13.00,     8.00,      12.00,     11.00,
    12.00,     11.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     5.00,      14.00,     5.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     5.00,      13.00,
    5.00,      13.00,     8.00,      13.00,     8.00,      13.00,     10.00,     12.00,
    10.00,     12.00,     11.00,     11.00,     11.00,     11.00,     12.00,     8.00,
    12.00,     8.00,      12.00,     6.00,      12.00,     6.00,      11.00,     3.00,
    11.00,     3.00,      10.00,     2.00,      10.00,     2.00,      8.00,      1.00,
    8.00,      1.00,      5.00,      1.00,      5.00,      1.00,      1.00,      3.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    99.00,     12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      8.00,
    0.00,      8.00,      1.00,      11.00,     1.00,      11.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      14.00,     5.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     12.00,     11.00,
    12.00,     11.00,     11.00,     10.00,     11.00,     10.00,     10.00,     12.00,
    10.00,     12.00,     8.00,      13.00,     8.00,      13.00,     5.00,      13.00,
    5.00,      13.00,     3.00,      12.00,     3.00,      12.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      3.00,      2.00,
    3.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      10.00,     2.00,      10.00,     2.00,      11.00,     4.00,
    11.00,     4.00,      12.00,     3.00,      -99.00,    -99.00,    -99.00,    100.00,
    12.00,     3.00,      10.00,     1.00,      10.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      5.00,      0.00,      5.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      1.00,      3.00,      1.00,      3.00,      0.00,      6.00,
    0.00,      6.00,      0.00,      8.00,      0.00,      8.00,      1.00,      11.00,
    1.00,      11.00,     3.00,      13.00,     3.00,      13.00,     5.00,      14.00,
    5.00,      14.00,     8.00,      14.00,     8.00,      14.00,     10.00,     13.00,
    10.00,     13.00,     12.00,     11.00,     12.00,     11.00,     8.00,      13.00,
    8.00,      13.00,     5.00,      13.00,     5.00,      13.00,     3.00,      12.00,
    3.00,      12.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      1.00,      6.00,      1.00,      6.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      2.00,      3.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      12.00,     3.00,
    13.00,     0.00,      12.00,     0.00,      12.00,     0.00,      12.00,     21.00,
    12.00,     21.00,     13.00,     21.00,     13.00,     21.00,     13.00,     0.00,
    -99.00,    -99.00,    -99.00,    101.00,    1.00,      7.00,      12.00,     7.00,
    12.00,     7.00,      12.00,     10.00,     12.00,     10.00,     11.00,     12.00,
    11.00,     12.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     5.00,      14.00,     5.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      6.00,      0.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     3.00,      12.00,     3.00,      11.00,     4.00,
    11.00,     4.00,      10.00,     2.00,      10.00,     2.00,      8.00,      1.00,
    8.00,      1.00,      5.00,      1.00,      5.00,      1.00,      3.00,      2.00,
    3.00,      2.00,      2.00,      3.00,      2.00,      3.00,      1.00,      6.00,
    1.00,      6.00,      1.00,      8.00,      1.00,      8.00,      2.00,      11.00,
    2.00,      11.00,     3.00,      12.00,     3.00,      12.00,     5.00,      13.00,
    5.00,      13.00,     8.00,      13.00,     8.00,      13.00,     10.00,     12.00,
    10.00,     12.00,     11.00,     10.00,     11.00,     10.00,     11.00,     8.00,
    11.00,     8.00,      1.00,      8.00,      -99.00,    -99.00,    -99.00,    102.00,
    7.00,      13.00,     7.00,      14.00,     7.00,      14.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      13.00,     0.00,      13.00,     7.00,      13.00,
    4.00,      19.00,     6.00,      20.00,     6.00,      20.00,     8.00,      20.00,
    8.00,      20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    6.00,      21.00,     4.00,      20.00,     4.00,      20.00,     3.00,      17.00,
    3.00,      17.00,     3.00,      0.00,      3.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      4.00,      17.00,     4.00,      17.00,     5.00,      20.00,
    -99.00,    -99.00,    -99.00,    103.00,    12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      8.00,
    0.00,      8.00,      1.00,      11.00,     1.00,      11.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      14.00,     5.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     12.00,     11.00,
    12.00,     11.00,     8.00,      13.00,     8.00,      13.00,     5.00,      13.00,
    5.00,      13.00,     3.00,      12.00,     3.00,      12.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      3.00,      2.00,
    3.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      12.00,     3.00,      1.00,      -4.00,     3.00,      -4.00,
    3.00,      -4.00,     4.00,      -5.00,     4.00,      -5.00,     6.00,      -6.00,
    6.00,      -6.00,     8.00,      -6.00,     8.00,      -6.00,     10.00,     -5.00,
    10.00,     -5.00,     11.00,     -4.00,     11.00,     -4.00,     12.00,     -1.00,
    12.00,     -1.00,     12.00,     14.00,     12.00,     14.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     -1.00,     13.00,     -1.00,     12.00,     -4.00,
    12.00,     -4.00,     10.00,     -6.00,     10.00,     -6.00,     8.00,      -7.00,
    8.00,      -7.00,     5.00,      -7.00,     5.00,      -7.00,     3.00,      -6.00,
    3.00,      -6.00,     1.00,      -4.00,     -99.00,    -99.00,    -99.00,    104.00,
    12.00,     0.00,      12.00,     10.00,     12.00,     10.00,     11.00,     13.00,
    11.00,     13.00,     9.00,      14.00,     9.00,      14.00,     6.00,      14.00,
    6.00,      14.00,     4.00,      13.00,     4.00,      13.00,     1.00,      10.00,
    1.00,      10.00,     4.00,      12.00,     4.00,      12.00,     6.00,      13.00,
    6.00,      13.00,     8.00,      13.00,     8.00,      13.00,     10.00,     12.00,
    10.00,     12.00,     11.00,     10.00,     11.00,     10.00,     11.00,     0.00,
    11.00,     0.00,      12.00,     0.00,      1.00,      0.00,      0.00,      0.00,
    0.00,      0.00,      0.00,      21.00,     0.00,      21.00,     1.00,      21.00,
    1.00,      21.00,     1.00,      0.00,      -99.00,    -99.00,    -99.00,    105.00,
    2.00,      0.00,      1.00,      0.00,      1.00,      0.00,      1.00,      14.00,
    1.00,      14.00,     2.00,      14.00,     2.00,      14.00,     2.00,      0.00,
    1.00,      21.00,     0.00,      20.00,     0.00,      20.00,     0.00,      19.00,
    0.00,      19.00,     1.00,      18.00,     1.00,      18.00,     2.00,      18.00,
    2.00,      18.00,     3.00,      19.00,     3.00,      19.00,     3.00,      20.00,
    3.00,      20.00,     2.00,      21.00,     2.00,      21.00,     1.00,      21.00,
    1.00,      20.00,     1.00,      19.00,     1.00,      19.00,     2.00,      19.00,
    2.00,      19.00,     2.00,      20.00,     2.00,      20.00,     1.00,      20.00,
    -99.00,    -99.00,    -99.00,    106.00,    2.00,      -7.00,     1.00,      -7.00,
    1.00,      -7.00,     1.00,      14.00,     1.00,      14.00,     2.00,      14.00,
    2.00,      14.00,     2.00,      -7.00,     1.00,      21.00,     0.00,      20.00,
    0.00,      20.00,     0.00,      19.00,     0.00,      19.00,     1.00,      18.00,
    1.00,      18.00,     2.00,      18.00,     2.00,      18.00,     3.00,      19.00,
    3.00,      19.00,     3.00,      20.00,     3.00,      20.00,     2.00,      21.00,
    2.00,      21.00,     1.00,      21.00,     1.00,      20.00,     1.00,      19.00,
    1.00,      19.00,     2.00,      19.00,     2.00,      19.00,     2.00,      20.00,
    2.00,      20.00,     1.00,      20.00,     -99.00,    -99.00,    -99.00,    107.00,
    4.00,      7.00,      10.00,     0.00,      10.00,     0.00,      12.00,     0.00,
    12.00,     0.00,      5.00,      8.00,      1.00,      4.00,      11.00,     14.00,
    11.00,     14.00,     12.00,     14.00,     12.00,     14.00,     1.00,      3.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      21.00,
    0.00,      21.00,     1.00,      21.00,     1.00,      21.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    108.00,    1.00,      0.00,      0.00,      0.00,
    0.00,      0.00,      0.00,      21.00,     0.00,      21.00,     1.00,      21.00,
    1.00,      21.00,     1.00,      0.00,      -99.00,    -99.00,    -99.00,    109.00,
    22.00,     0.00,      23.00,     0.00,      23.00,     0.00,      23.00,     10.00,
    23.00,     10.00,     22.00,     13.00,     22.00,     13.00,     20.00,     14.00,
    20.00,     14.00,     17.00,     14.00,     17.00,     14.00,     15.00,     13.00,
    15.00,     13.00,     12.00,     10.00,     12.00,     10.00,     15.00,     12.00,
    15.00,     12.00,     17.00,     13.00,     17.00,     13.00,     19.00,     13.00,
    19.00,     13.00,     21.00,     12.00,     21.00,     12.00,     22.00,     10.00,
    22.00,     10.00,     22.00,     0.00,      12.00,     0.00,      12.00,     10.00,
    12.00,     10.00,     11.00,     13.00,     11.00,     13.00,     9.00,      14.00,
    9.00,      14.00,     6.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     1.00,      10.00,     1.00,      10.00,     4.00,      12.00,
    4.00,      12.00,     6.00,      13.00,     6.00,      13.00,     8.00,      13.00,
    8.00,      13.00,     10.00,     12.00,     10.00,     12.00,     11.00,     10.00,
    11.00,     10.00,     11.00,     0.00,      11.00,     0.00,      12.00,     0.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    110.00,    12.00,     0.00,      12.00,     10.00,
    12.00,     10.00,     11.00,     13.00,     11.00,     13.00,     9.00,      14.00,
    9.00,      14.00,     6.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     1.00,      10.00,     1.00,      10.00,     4.00,      12.00,
    4.00,      12.00,     6.00,      13.00,     6.00,      13.00,     8.00,      13.00,
    8.00,      13.00,     10.00,     12.00,     10.00,     12.00,     11.00,     10.00,
    11.00,     10.00,     11.00,     0.00,      11.00,     0.00,      12.00,     0.00,
    1.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     1.00,      0.00,
    -99.00,    -99.00,    -99.00,    111.00,    5.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      6.00,      0.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     3.00,      12.00,     3.00,      13.00,     6.00,
    13.00,     6.00,      13.00,     8.00,      13.00,     8.00,      12.00,     11.00,
    12.00,     11.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     5.00,      14.00,     5.00,      13.00,     3.00,      12.00,
    3.00,      12.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      1.00,      6.00,      1.00,      6.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      2.00,      3.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      10.00,     2.00,
    10.00,     2.00,      11.00,     3.00,      11.00,     3.00,      12.00,     6.00,
    12.00,     6.00,      12.00,     8.00,      12.00,     8.00,      11.00,     11.00,
    11.00,     11.00,     10.00,     12.00,     10.00,     12.00,     8.00,      13.00,
    8.00,      13.00,     5.00,      13.00,     -99.00,    -99.00,    -99.00,    112.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     3.00,      12.00,     3.00,      13.00,     6.00,
    13.00,     6.00,      13.00,     8.00,      13.00,     8.00,      12.00,     11.00,
    12.00,     11.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     5.00,      14.00,     5.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     5.00,      13.00,
    5.00,      13.00,     8.00,      13.00,     8.00,      13.00,     10.00,     12.00,
    10.00,     12.00,     11.00,     11.00,     11.00,     11.00,     12.00,     8.00,
    12.00,     8.00,      12.00,     6.00,      12.00,     6.00,      11.00,     3.00,
    11.00,     3.00,      10.00,     2.00,      10.00,     2.00,      8.00,      1.00,
    8.00,      1.00,      5.00,      1.00,      5.00,      1.00,      1.00,      3.00,
    1.00,      -7.00,     0.00,      -7.00,     0.00,      -7.00,     0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     1.00,      -7.00,
    -99.00,    -99.00,    -99.00,    113.00,    12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      8.00,
    0.00,      8.00,      1.00,      11.00,     1.00,      11.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      14.00,     5.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     12.00,     11.00,
    12.00,     11.00,     8.00,      13.00,     8.00,      13.00,     5.00,      13.00,
    5.00,      13.00,     3.00,      12.00,     3.00,      12.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      3.00,      2.00,
    3.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      12.00,     3.00,      13.00,     -7.00,     12.00,     -7.00,
    12.00,     -7.00,     12.00,     14.00,     12.00,     14.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     -7.00,     -99.00,    -99.00,    -99.00,    114.00,
    9.00,      14.00,     6.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      2.00,      10.00,     2.00,      10.00,     4.00,      12.00,
    4.00,      12.00,     6.00,      13.00,     6.00,      13.00,     9.00,      13.00,
    9.00,      13.00,     9.00,      14.00,     1.00,      0.00,      0.00,      0.00,
    0.00,      0.00,      0.00,      14.00,     0.00,      14.00,     1.00,      14.00,
    1.00,      14.00,     1.00,      0.00,      -99.00,    -99.00,    -99.00,    115.00,
    2.00,      1.00,      1.00,      3.00,      1.00,      3.00,      0.00,      3.00,
    0.00,      3.00,      1.00,      1.00,      1.00,      1.00,      4.00,      0.00,
    4.00,      0.00,      7.00,      0.00,      7.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      11.00,     3.00,      11.00,     3.00,      11.00,     4.00,
    11.00,     4.00,      10.00,     6.00,      10.00,     6.00,      8.00,      7.00,
    8.00,      7.00,      3.00,      9.00,      3.00,      9.00,      1.00,      10.00,
    10.00,     5.00,      8.00,      6.00,      8.00,      6.00,      3.00,      8.00,
    3.00,      8.00,      1.00,      9.00,      1.00,      9.00,      0.00,      11.00,
    0.00,      11.00,     1.00,      13.00,     1.00,      13.00,     4.00,      14.00,
    4.00,      14.00,     7.00,      14.00,     7.00,      14.00,     10.00,     13.00,
    10.00,     13.00,     11.00,     11.00,     11.00,     11.00,     10.00,     11.00,
    10.00,     11.00,     9.00,      13.00,     9.00,      6.00,      10.00,     4.00,
    10.00,     4.00,      10.00,     3.00,      10.00,     3.00,      9.00,      1.00,
    10.00,     2.00,      7.00,      1.00,      7.00,      1.00,      4.00,      1.00,
    4.00,      1.00,      1.00,      2.00,      10.00,     12.00,     7.00,      13.00,
    7.00,      13.00,     4.00,      13.00,     4.00,      13.00,     1.00,      12.00,
    2.00,      13.00,     1.00,      11.00,     1.00,      11.00,     2.00,      9.00,
    -99.00,    -99.00,    -99.00,    116.00,    7.00,      13.00,     7.00,      14.00,
    7.00,      14.00,     0.00,      14.00,     0.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     7.00,      13.00,     4.00,      0.00,      3.00,      0.00,
    3.00,      0.00,      3.00,      21.00,     3.00,      21.00,     4.00,      21.00,
    4.00,      21.00,     4.00,      0.00,      -99.00,    -99.00,    -99.00,    117.00,
    12.00,     0.00,      11.00,     0.00,      11.00,     0.00,      11.00,     14.00,
    11.00,     14.00,     12.00,     14.00,     12.00,     14.00,     12.00,     0.00,
    11.00,     4.00,      8.00,      1.00,      8.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      3.00,      0.00,      3.00,      0.00,      1.00,      1.00,
    1.00,      1.00,      0.00,      4.00,      0.00,      4.00,      0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     1.00,      4.00,
    1.00,      4.00,      2.00,      2.00,      2.00,      2.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      1.00,      6.00,      1.00,      8.00,      2.00,
    8.00,      2.00,      11.00,     4.00,      -99.00,    -99.00,    -99.00,    118.00,
    12.00,     14.00,     11.00,     14.00,     11.00,     14.00,     6.00,      2.00,
    6.00,      2.00,      1.00,      14.00,     1.00,      14.00,     0.00,      14.00,
    0.00,      14.00,     6.00,      0.00,      6.00,      0.00,      12.00,     14.00,
    -99.00,    -99.00,    -99.00,    119.00,    18.00,     14.00,     17.00,     14.00,
    17.00,     14.00,     13.00,     3.00,      13.00,     3.00,      9.00,      14.00,
    9.00,      14.00,     5.00,      3.00,      5.00,      3.00,      1.00,      14.00,
    1.00,      14.00,     0.00,      14.00,     0.00,      14.00,     5.00,      0.00,
    5.00,      0.00,      9.00,      11.00,     9.00,      11.00,     13.00,     0.00,
    13.00,     0.00,      18.00,     14.00,     -99.00,    -99.00,    -99.00,    120.00,
    0.00,      0.00,      11.00,     14.00,     11.00,     14.00,     12.00,     14.00,
    12.00,     14.00,     1.00,      0.00,      1.00,      0.00,      0.00,      0.00,
    12.00,     0.00,      11.00,     0.00,      11.00,     0.00,      0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     12.00,     0.00,
    -99.00,    -99.00,    -99.00,    121.00,    2.00,      -7.00,     6.00,      2.00,
    6.00,      2.00,      11.00,     14.00,     11.00,     14.00,     12.00,     14.00,
    12.00,     14.00,     6.00,      0.00,      6.00,      0.00,      3.00,      -7.00,
    3.00,      -7.00,     2.00,      -7.00,     6.00,      0.00,      0.00,      14.00,
    0.00,      14.00,     1.00,      14.00,     1.00,      14.00,     6.00,      2.00,
    -99.00,    -99.00,    -99.00,    122.00,    12.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      2.00,      1.00,      2.00,      1.00,      12.00,     14.00,
    12.00,     14.00,     0.00,      14.00,     0.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     10.00,     13.00,     10.00,     13.00,     0.00,      0.00,
    0.00,      0.00,      12.00,     0.00,      -99.00,    -99.00,    -99.00,    123.00,
    2.00,      23.00,     1.00,      20.00,     1.00,      20.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      13.00,     2.00,      5.00,      1.00,      2.00,
    1.00,      2.00,      1.00,      -2.00,     1.00,      -2.00,     2.00,      -5.00,
    4.00,      25.00,     1.00,      22.00,     1.00,      22.00,     0.00,      19.00,
    0.00,      19.00,     0.00,      17.00,     0.00,      17.00,     1.00,      14.00,
    1.00,      14.00,     4.00,      11.00,     4.00,      11.00,     1.00,      9.00,
    1.00,      9.00,      4.00,      7.00,      4.00,      7.00,      1.00,      4.00,
    1.00,      4.00,      0.00,      1.00,      0.00,      1.00,      0.00,      -1.00,
    0.00,      -1.00,     1.00,      -4.00,     1.00,      -4.00,     4.00,      -7.00,
    -99.00,    -99.00,    -99.00,    124.00,    3.00,      25.00,     3.00,      -7.00,
    -99.00,    -99.00,    -99.00,    125.00,    2.00,      23.00,     3.00,      20.00,
    3.00,      20.00,     3.00,      16.00,     3.00,      16.00,     2.00,      13.00,
    2.00,      5.00,      3.00,      2.00,      3.00,      2.00,      3.00,      -2.00,
    3.00,      -2.00,     2.00,      -5.00,     0.00,      25.00,     3.00,      22.00,
    3.00,      22.00,     4.00,      19.00,     4.00,      19.00,     4.00,      17.00,
    4.00,      17.00,     3.00,      14.00,     3.00,      14.00,     0.00,      11.00,
    0.00,      11.00,     3.00,      9.00,      3.00,      9.00,      0.00,      7.00,
    0.00,      7.00,      3.00,      4.00,      3.00,      4.00,      4.00,      1.00,
    4.00,      1.00,      4.00,      -1.00,     4.00,      -1.00,     3.00,      -4.00,
    3.00,      -4.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    126.00,
    0.00,      6.00,      0.00,      8.00,      0.00,      8.00,      1.00,      11.00,
    1.00,      11.00,     3.00,      12.00,     3.00,      12.00,     5.00,      12.00,
    5.00,      12.00,     7.00,      11.00,     7.00,      11.00,     11.00,     8.00,
    11.00,     8.00,      13.00,     7.00,      13.00,     7.00,      15.00,     7.00,
    15.00,     7.00,      17.00,     8.00,      17.00,     8.00,      18.00,     10.00,
    0.00,      8.00,      1.00,      10.00,     1.00,      10.00,     3.00,      11.00,
    3.00,      11.00,     5.00,      11.00,     5.00,      11.00,     7.00,      10.00,
    7.00,      10.00,     11.00,     7.00,      11.00,     7.00,      13.00,     6.00,
    13.00,     6.00,      15.00,     6.00,      15.00,     6.00,      17.00,     7.00,
    17.00,     7.00,      18.00,     10.00,     18.00,     10.00,     18.00,     12.00,
    -99.00,    -99.00,    -99.00,    127.00,    0.00,      12.00,     1.00,      13.00,
    1.00,      13.00,     3.00,      14.00,     3.00,      14.00,     4.50,      14.50,
    4.50,      14.50,     6.00,      14.00,     6.00,      14.00,     8.00,      13.00,
    8.00,      13.00,     10.00,     11.00,     10.00,     11.00,     12.00,     10.00,
    12.00,     10.00,     13.50,     9.50,      13.50,     9.50,      15.00,     10.00,
    15.00,     10.00,     17.00,     11.00,     17.00,     11.00,     18.00,     12.00,
    0.00,      6.00,      1.00,      7.00,      1.00,      7.00,      3.00,      8.00,
    3.00,      8.00,      4.50,      8.50,      4.50,      8.50,      6.00,      8.00,
    6.00,      8.00,      8.00,      7.00,      8.00,      7.00,      10.00,     5.00,
    10.00,     5.00,      12.00,     4.00,      12.00,     4.00,      13.50,     3.50,
    13.50,     3.50,      15.00,     4.00,      15.00,     4.00,      17.00,     5.00,
    17.00,     5.00,      18.00,     6.00,      -99.00,    -99.00,    -99.00,    999.00,
    -99.00,    -99.00,    -99.00,    4.00,      0.00,      6.64,      -3.23,     6.51,
    1.81,      6.51,      0.00,      6.64,      1.81,      3.23,      1.81,      6.51,
    6.13,      3.23,      1.81,      3.23,      6.51,      0.38,      6.13,      3.23,
    6.13,      -4.66,     6.51,      0.38,      4.70,      -5.04,     6.13,      -4.66,
    5.04,      -2.14,     4.70,      -5.04,     3.95,      -2.14,     5.04,      -2.14,
    3.61,      0.38,      3.95,      -2.14,     1.81,      0.38,      3.61,      0.38,
    2.14,      -7.22,     1.81,      0.38,      -2.14,     -7.22,     2.14,      -7.22,
    -1.81,     0.38,      -2.14,     -7.22,     -3.61,     0.38,      -1.81,     0.38,
    -3.95,     -2.14,     -3.61,     0.38,      -5.04,     -2.14,     -3.95,     -2.14,
    -4.70,     -5.04,     -5.04,     -2.14,     -6.13,     -4.70,     -4.70,     -5.04,
    -6.51,     0.38,      -6.13,     -4.70,     -6.13,     3.23,      -6.51,     0.38,
    -1.81,     3.23,      -6.13,     3.23,      -1.81,     5.04,      -1.81,     3.23,
    -3.23,     5.00,      -1.81,     5.04,      -3.23,     6.51,      -3.23,     5.00,
    3.23,      -8.32,     0.00,      -8.32,     6.13,      -7.94,     3.23,      -8.32,
    7.22,      -7.60,     6.13,      -7.94,     7.60,      -7.22,     7.22,      -7.60,
    7.94,      -6.13,     7.60,      -7.22,     8.32,      -3.23,     7.94,      -6.13,
    8.32,      0.00,      8.32,      -3.23,     3.23,      8.32,      0.00,      8.32,
    6.13,      7.94,      3.23,      8.32,      7.22,      7.56,      6.13,      7.94,
    7.60,      7.22,      7.22,      7.56,      7.94,      6.13,      7.60,      7.22,
    8.32,      3.23,      7.94,      6.13,      8.32,      0.00,      8.32,      3.23,
    -3.23,     8.32,      0.00,      8.32,      -6.13,     7.94,      -3.23,     8.32,
    -7.22,     7.56,      -6.13,     7.94,      -7.60,     7.22,      -7.22,     7.56,
    -7.94,     6.13,      -7.60,     7.22,      -8.32,     3.23,      -7.94,     6.13,
    -8.32,     0.00,      -8.32,     3.23,      -3.23,     -8.32,     0.00,      -8.32,
    -6.13,     -7.94,     -3.23,     -8.32,     -7.22,     -7.60,     -6.13,     -7.94,
    -7.60,     -7.22,     -7.22,     -7.60,     -7.94,     -6.13,     -7.60,     -7.22,
    -8.32,     -3.23,     -7.94,     -6.13,     -8.32,     0.00,      -8.32,     -3.23,
    3.61,      -10.50,    0.00,      -10.50,    6.85,      -10.12,    3.61,      -10.50,
    8.32,      -9.74,     6.85,      -10.12,    9.03,      -9.41,     8.32,      -9.74,
    9.41,      -9.03,     9.03,      -9.41,     9.74,      -8.32,     9.41,      -9.03,
    10.12,     -6.85,     9.74,      -8.32,     10.50,     -3.61,     10.12,     -6.85,
    10.50,     0.00,      10.50,     -3.61,     3.61,      10.46,     0.00,      10.46,
    6.85,      10.12,     3.61,      10.46,     8.32,      9.74,      6.85,      10.12,
    9.03,      9.41,      8.32,      9.74,      9.41,      9.03,      9.03,      9.41,
    9.74,      8.32,      9.41,      9.03,      10.12,     6.85,      9.74,      8.32,
    10.50,     3.61,      10.12,     6.85,      10.50,     0.00,      10.50,     3.61,
    -3.61,     10.46,     0.00,      10.46,     -6.85,     10.12,     -3.61,     10.46,
    -8.32,     9.74,      -6.85,     10.12,     -9.03,     9.41,      -8.32,     9.74,
    -9.41,     9.03,      -9.03,     9.41,      -9.74,     8.32,      -9.41,     9.03,
    -10.12,    6.85,      -9.74,     8.32,      -10.50,    3.61,      -10.12,    6.85,
    -10.50,    0.00,      -10.50,    3.61,      -3.61,     -10.50,    0.00,      -10.50,
    -6.85,     -10.12,    -3.61,     -10.50,    -8.32,     -9.74,     -6.85,     -10.12,
    -9.03,     -9.41,     -8.32,     -9.74,     -9.41,     -9.03,     -9.03,     -9.41,
    -9.74,     -8.32,     -9.41,     -9.03,     -10.12,    -6.85,     -9.74,     -8.32,
    -10.50,    -3.61,     -10.12,    -6.85,     -10.50,    0.00,      -10.50,    -3.61,
    -99.00,    -99.00,    -99.00,    5.00,      -10.50,    -10.50,    10.50,     -10.50,
    10.50,     -10.50,    10.50,     10.50,     10.50,     10.50,     -10.50,    10.50,
    -10.50,    10.50,     -10.50,    -10.50,    -99.00,    -99.00,    -99.00,    6.00,
    0.00,      -10.50,    10.50,     0.00,      10.50,     0.00,      0.00,      10.50,
    0.00,      10.50,     -10.50,    0.00,      -10.50,    0.00,      0.00,      -10.50,
    -99.00,    -99.00,    -99.00,    7.00,      0.00,      -10.50,    0.00,      10.50,
    -10.50,    0.00,      10.50,     0.00,      -99.00,    -99.00,    -99.00,    8.00,
    -10.50,    -10.50,    10.50,     10.50,     -10.50,    10.50,     10.50,     -10.50,
    -99.00,    -99.00,    -99.00,    9.00,      -10.50,    -7.50,     0.00,      13.50,
    0.00,      13.50,     10.50,     -7.50,     10.50,     -7.50,     -10.50,    -7.50,
    -99.00,    -99.00,    -99.00,    10.00,     10.50,     0.00,      9.99,      3.24,
    9.99,      3.24,      8.49,      6.17,      8.49,      6.17,      6.17,      8.49,
    6.17,      8.49,      3.24,      9.99,      3.24,      9.99,      0.00,      10.50,
    0.00,      10.50,     -3.24,     9.99,      -3.24,     9.99,      -6.17,     8.49,
    -6.17,     8.49,      -8.49,     6.17,      -8.49,     6.17,      -9.99,     3.24,
    -9.99,     3.24,      -10.50,    0.00,      -10.50,    0.00,      -9.99,     -3.24,
    -9.99,     -3.24,     -8.49,     -6.17,     -8.49,     -6.17,     -6.17,     -8.49,
    -6.17,     -8.49,     -3.24,     -9.99,     -3.24,     -9.99,     0.00,      -10.50,
    0.00,      -10.50,    3.24,      -9.99,     3.24,      -9.99,     6.17,      -8.49,
    6.17,      -8.49,     8.49,      -6.17,     8.49,      -6.17,     9.99,      -3.24,
    9.99,      -3.24,     10.50,     0.00,      -99.00,    -99.00,    -99.00,    11.00,
    -2.00,     0.00,      2.00,      0.00,      0.00,      2.00,      0.00,      -2.00,
    1.41,      1.41,      -1.41,     -1.41,     -1.41,     1.41,      1.41,      -1.41,
    -99.00000, -99.00000, -99.00000, 12.000000, 10.50000,  17.14000,  7.270000,  17.01000,
    12.31000,  17.01000,  10.50000,  17.14000,  12.31000,  13.73000,  12.31000,  17.01000,
    16.63000,  13.73000,  12.31000,  13.73000,  17.01000,  10.88000,  16.63000,  13.73000,
    16.63000,  5.840000,  17.01000,  10.88000,  15.20000,  5.460000,  16.63000,  5.840000,
    15.54000,  8.360000,  15.20000,  5.460000,  14.45000,  8.360000,  15.54000,  8.360000,
    14.11000,  10.88000,  14.45000,  8.360000,  12.31000,  10.88000,  14.11000,  10.88000,
    12.64000,  3.280000,  12.31000,  10.88000,  8.360000,  3.280000,  12.64000,  3.280000,
    8.690001,  10.88000,  8.360000,  3.280000,  6.890000,  10.88000,  8.690001,  10.88000,
    6.550000,  8.360000,  6.890000,  10.88000,  5.460000,  8.360000,  6.550000,  8.360000,
    5.800000,  5.460000,  5.460000,  8.360000,  4.370000,  5.800000,  5.800000,  5.460000,
    3.990000,  10.88000,  4.370000,  5.800000,  4.370000,  13.73000,  3.990000,  10.88000,
    8.690001,  13.73000,  4.370000,  13.73000,  8.690001,  15.54000,  8.690001,  13.73000,
    7.270000,  15.50000,  8.690001,  15.54000,  7.270000,  17.01000,  7.270000,  15.50000,
    13.73000,  2.180000,  10.50000,  2.180000,  16.63000,  2.560000,  13.73000,  2.180000,
    17.72000,  2.900000,  16.63000,  2.560000,  18.10000,  3.280000,  17.72000,  2.900000,
    18.44000,  4.370000,  18.10000,  3.280000,  18.82000,  7.270000,  18.44000,  4.370000,
    18.82000,  10.50000,  18.82000,  7.270000,  13.73000,  18.82000,  10.50000,  18.82000,
    16.63000,  18.44000,  13.73000,  18.82000,  17.72000,  18.06000,  16.63000,  18.44000,
    18.10000,  17.72000,  17.72000,  18.06000,  18.44000,  16.63000,  18.10000,  17.72000,
    18.82000,  13.73000,  18.44000,  16.63000,  18.82000,  10.50000,  18.82000,  13.73000,
    7.270000,  18.82000,  10.50000,  18.82000,  4.370000,  18.44000,  7.270000,  18.82000,
    3.280000,  18.06000,  4.370000,  18.44000,  2.900000,  17.72000,  3.280000,  18.06000,
    2.560000,  16.63000,  2.900000,  17.72000,  2.180000,  13.73000,  2.560000,  16.63000,
    2.180000,  10.50000,  2.180000,  13.73000,  7.270000,  2.180000,  10.50000,  2.180000,
    4.370000,  2.560000,  7.270000,  2.180000,  3.280000,  2.900000,  4.370000,  2.560000,
    2.900000,  3.280000,  3.280000,  2.900000,  2.560000,  4.370000,  2.900000,  3.280000,
    2.180000,  7.270000,  2.560000,  4.370000,  2.180000,  10.50000,  2.180000,  7.270000,
    14.11000,  0.0000000, 10.50000,  0.0000000, 17.35000,  0.3800001, 14.11000,  0.0000000,
    18.82000,  0.7600002, 17.35000,  0.3800001, 19.53000,  1.090000,  18.82000,  0.7600002,
    19.91000,  1.470000,  19.53000,  1.090000,  20.24000,  2.180000,  19.91000,  1.470000,
    20.62000,  3.650000,  20.24000,  2.180000,  21.00000,  6.890000,  20.62000,  3.650000,
    21.00000,  10.50000,  21.00000,  6.890000,  14.11000,  20.96000,  10.50000,  20.96000,
    17.35000,  20.62000,  14.11000,  20.96000,  18.82000,  20.24000,  17.35000,  20.62000,
    19.53000,  19.91000,  18.82000,  20.24000,  19.91000,  19.53000,  19.53000,  19.91000,
    20.24000,  18.82000,  19.91000,  19.53000,  20.62000,  17.35000,  20.24000,  18.82000,
    21.00000,  14.11000,  20.62000,  17.35000,  21.00000,  10.50000,  21.00000,  14.11000,
    6.890000,  20.96000,  10.50000,  20.96000,  3.650000,  20.62000,  6.890000,  20.96000,
    2.180000,  20.24000,  3.650000,  20.62000,  1.470000,  19.91000,  2.180000,  20.24000,
    1.090000,  19.53000,  1.470000,  19.91000,  0.7600002, 18.82000,  1.090000,  19.53000,
    0.3800001, 17.35000,  0.7600002, 18.82000,  0.0000000, 14.11000,  0.3800001, 17.35000,
    0.0000000, 10.50000,  0.0000000, 14.11000,  6.890000,  0.0000000, 10.50000,  0.0000000,
    3.650000,  0.3800001, 6.890000,  0.0000000, 2.180000,  0.7600002, 3.650000,  0.3800001,
    1.470000,  1.090000,  2.180000,  0.7600002, 1.090000,  1.470000,  1.470000,  1.090000,
    0.7600002, 2.180000,  1.090000,  1.470000,  0.3800001, 3.650000,  0.7600002, 2.180000,
    0.0000000, 6.890000,  0.3800001, 3.650000,  0.0000000, 10.50000,  0.0000000, 6.890000,
    -99.00000, -99.00000, -99.00000, 13.000000, 0.0000000, 0.0000000, 21.00000,  0.0000000,
    21.00000,  0.0000000, 21.00000,  21.00000,  21.00000,  21.00000,  0.0000000, 21.00000,
    0.0000000, 21.00000,  0.0000000, 0.0000000, -99.00000, -99.00000, -99.00000, 14.000000,
    10.50000,  0.0000000, 21.00000,  10.50000,  21.00000,  10.50000,  10.50000,  21.00000,
    10.50000,  21.00000,  0.0000000, 10.50000,  0.0000000, 10.50000,  10.50000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 15.000000, 10.50000,  0.0000000, 10.50000,  21.00000,
    0.0000000, 10.50000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 16.000000,
    0.0000000, 0.0000000, 21.00000,  21.00000,  0.0000000, 21.00000,  21.00000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 17.000000, 0.0000000, 0.000000,  10.50000,  21.00000,
    10.50000,  21.00000,  21.00000,  0.000000,  21.00000,  0.000000,  0.0000000, 0.000000,
    -99.00000, -99.00000, -99.00000, 18.00000,  21.00000,  10.50000,  20.49000,  13.74000,
    20.49000,  13.74000,  18.99000,  16.67000,  18.99000,  16.67000,  16.67000,  18.99000,
    16.67000,  18.99000,  13.74000,  20.49000,  13.74000,  20.49000,  10.50000,  21.00000,
    10.50000,  21.00000,  7.260000,  20.49000,  7.260000,  20.49000,  4.330000,  18.99000,
    4.330000,  18.99000,  2.010000,  16.67000,  2.010000,  16.67000,  0.5100002, 13.74000,
    0.5100002, 13.74000,  0.0000000, 10.50000,  0.0000000, 10.50000,  0.5100002, 7.260000,
    0.5100002, 7.260000,  2.010000,  4.330000,  2.010000,  4.330000,  4.330000,  2.010000,
    4.330000,  2.010000,  7.260000,  0.5100002, 7.260000,  0.5100002, 10.50000,  0.0000000,
    10.50000,  0.0000000, 13.74000,  0.5100002, 13.74000,  0.5100002, 16.67000,  2.010000,
    16.67000,  2.010000,  18.99000,  4.330000,  18.99000,  4.330000,  20.49000,  7.260000,
    20.49000,  7.260000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 19.00000,
    8.500000,  10.50000,  12.50000,  10.50000,  10.50000,  12.50000,  10.50000,  8.500000,
    11.91000,  11.91000,  9.090000,  9.090000,  9.090000,  11.91000,  11.91000,  9.090000,
    -99.00,    -99.00,    -99.00,    20.00,     10.50,     21.00,     10.50,     3.00,
    1.50,      12.00,     19.50,     12.00,     1.50,      0.00,      19.50,     0.00,
    -99.00,    -99.00,    -99.00,    21.00,     16.00,     21.00,     0.00,      12.00,
    0.00,      12.00,     16.00,     3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    22.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    23.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      4.00,      -2.00,     14.00,     20.00,
    -99.00,    -99.00,    -99.00,    24.00,     3.00,      19.00,     4.00,      24.00,
    4.00,      24.00,     5.00,      25.00,     5.00,      25.00,     6.00,      24.00,
    6.00,      24.00,     3.00,      19.00,     -99.00,    -99.00,    -99.00,    25.00,
    16.00,     21.00,     0.00,      12.00,     0.00,      12.00,     16.00,     3.00,
    0.00,      0.00,      16.00,     0.00,      11.00,     24.00,     6.00,      -4.00,
    -99.00,    -99.00,    -99.00,    26.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      16.00,     0.00,      0.00,      0.00,
    9.00,      23.00,     4.00,      -4.00,     -99.00,    -99.00,    -99.00,    27.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    24.00,     18.00,     8.00,      9.00,      8.00,      9.00,      24.00,     0.00,
    -99.00,    -99.00,    -99.00,    28.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      8.00,      18.00,     24.00,     9.00,
    24.00,     9.00,      8.00,      0.00,      -99.00,    -99.00,    -99.00,    29.00,
    16.00,     2.00,      15.00,     0.00,      15.00,     0.00,      0.00,      0.00,
    4.00,      0.00,      12.00,     1.00,      12.00,     1.00,      16.00,     2.00,
    0.00,      0.00,      8.00,      10.50,     8.00,      10.50,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     16.00,     19.00,
    16.00,     19.00,     12.00,     20.00,     12.00,     20.00,     4.00,      21.00,
    2.00,      20.00,     9.00,      10.50,     9.00,      10.50,     2.00,      1.00,
    -99.00,    -99.00,    -99.00,    30.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      11.00,     23.00,     6.00,      -3.00,
    -99.00,    -99.00,    -99.00,    31.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      9.00,      23.00,     4.00,      -4.00,
    -99.00,    -99.00,    -99.00,    32.00,     10.50,     0.00,      10.50,     0.00,
    -99.00,    -99.00,    -99.00,    33.00,     2.00,      7.00,      1.00,      7.00,
    1.00,      7.00,      1.00,      21.00,     1.00,      21.00,     2.00,      21.00,
    2.00,      21.00,     2.00,      7.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      -99.00,    -99.00,    -99.00,    34.00,
    10.00,     20.00,     9.00,      14.00,     9.00,      14.00,     9.00,      20.00,
    9.00,      20.00,     10.00,     21.00,     10.00,     21.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      14.00,     1.00,      20.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      20.00,     0.00,      20.00,     1.00,      21.00,
    1.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      14.00,
    -99.00,    -99.00,    -99.00,    35.00,     8.00,      21.00,     1.00,      -7.00,
    14.00,     21.00,     7.00,      -7.00,     1.00,      10.00,     15.00,     10.00,
    0.00,      4.00,      14.00,     4.00,      -99.00,    -99.00,    -99.00,    36.00,
    2.00,      3.00,      3.00,      2.00,      3.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    11.00,     2.00,      12.00,     4.00,      12.00,     4.00,      12.00,     6.00,
    12.00,     6.00,      11.00,     8.00,      11.00,     8.00,      10.00,     9.00,
    10.00,     9.00,      2.00,      13.00,     2.00,      13.00,     1.00,      14.00,
    1.00,      14.00,     0.00,      16.00,     0.00,      16.00,     0.00,      18.00,
    0.00,      18.00,     2.00,      20.00,     2.00,      20.00,     5.00,      21.00,
    5.00,      21.00,     8.00,      21.00,     8.00,      21.00,     11.00,     20.00,
    11.00,     20.00,     13.00,     18.00,     13.00,     18.00,     11.00,     18.00,
    11.00,     18.00,     10.00,     19.00,     10.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     5.00,      20.00,     5.00,      20.00,     2.00,      19.00,
    2.00,      19.00,     1.00,      18.00,     1.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      14.00,     2.00,      14.00,     10.00,     10.00,
    10.00,     10.00,     12.00,     8.00,      12.00,     8.00,      13.00,     6.00,
    13.00,     6.00,      13.00,     4.00,      13.00,     4.00,      12.00,     2.00,
    12.00,     2.00,      11.00,     1.00,      11.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      0.00,      3.00,      0.00,      3.00,      2.00,      3.00,
    7.00,      -4.00,     6.00,      -4.00,     6.00,      -4.00,     6.00,      25.00,
    6.00,      25.00,     7.00,      25.00,     7.00,      25.00,     7.00,      -4.00,
    12.00,     3.00,      9.00,      1.00,      -99.00,    -99.00,    -99.00,    37.00,
    0.00,      0.00,      18.00,     21.00,     18.00,     21.00,     16.00,     20.00,
    16.00,     20.00,     13.00,     19.00,     13.00,     19.00,     10.00,     19.00,
    10.00,     19.00,     7.00,      20.00,     7.00,      20.00,     5.00,      21.00,
    5.00,      21.00,     3.00,      21.00,     3.00,      21.00,     1.00,      20.00,
    1.00,      20.00,     0.00,      18.00,     0.00,      18.00,     0.00,      16.00,
    0.00,      16.00,     2.00,      14.00,     2.00,      14.00,     4.00,      14.00,
    4.00,      14.00,     6.00,      15.00,     6.00,      15.00,     7.00,      17.00,
    7.00,      17.00,     7.00,      19.00,     7.00,      19.00,     5.00,      21.00,
    14.00,     7.00,      12.00,     6.00,      12.00,     6.00,      11.00,     4.00,
    11.00,     4.00,      11.00,     2.00,      11.00,     2.00,      13.00,     0.00,
    13.00,     0.00,      15.00,     0.00,      15.00,     0.00,      17.00,     1.00,
    17.00,     1.00,      18.00,     3.00,      18.00,     3.00,      18.00,     5.00,
    18.00,     5.00,      16.00,     7.00,      16.00,     7.00,      14.00,     7.00,
    -99.00,    -99.00,    -99.00,    38.00,     15.00,     12.00,     17.00,     13.00,
    17.00,     13.00,     19.00,     13.00,     19.00,     13.00,     19.00,     14.00,
    19.00,     14.00,     17.00,     14.00,     17.00,     14.00,     15.00,     13.00,
    15.00,     13.00,     14.00,     11.00,     14.00,     11.00,     12.00,     5.00,
    12.00,     5.00,      11.00,     3.00,      11.00,     3.00,      10.00,     2.00,
    10.00,     2.00,      8.00,      1.00,      8.00,      1.00,      4.00,      1.00,
    4.00,      1.00,      2.00,      2.00,      2.00,      2.00,      1.00,      4.00,
    1.00,      4.00,      1.00,      6.00,      1.00,      6.00,      2.00,      8.00,
    2.00,      8.00,      3.00,      9.00,      3.00,      9.00,      8.00,      12.00,
    8.00,      12.00,     10.00,     14.00,     10.00,     14.00,     11.00,     16.00,
    11.00,     16.00,     11.00,     18.00,     11.00,     18.00,     10.00,     20.00,
    10.00,     20.00,     8.00,      21.00,     8.00,      21.00,     7.00,      21.00,
    7.00,      21.00,     5.00,      20.00,     5.00,      20.00,     4.00,      18.00,
    4.00,      18.00,     4.00,      16.00,     4.00,      16.00,     5.00,      13.00,
    5.00,      13.00,     7.00,      10.00,     7.00,      10.00,     12.00,     4.00,
    12.00,     4.00,      15.00,     1.00,      15.00,     1.00,      17.00,     0.00,
    17.00,     0.00,      19.00,     0.00,      19.00,     0.00,      19.00,     1.00,
    19.00,     1.00,      17.00,     1.00,      17.00,     1.00,      15.00,     2.00,
    15.00,     2.00,      13.00,     4.00,      13.00,     4.00,      8.00,      10.00,
    8.00,      10.00,     6.00,      13.00,     6.00,      13.00,     5.00,      16.00,
    5.00,      16.00,     5.00,      18.00,     5.00,      18.00,     6.00,      20.00,
    16.00,     13.00,     15.00,     11.00,     15.00,     11.00,     13.00,     5.00,
    13.00,     5.00,      12.00,     3.00,      12.00,     3.00,      10.00,     1.00,
    10.00,     1.00,      8.00,      0.00,      8.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      8.00,      1.00,      8.00,      3.00,      10.00,
    3.00,      10.00,     8.00,      13.00,     8.00,      13.00,     9.00,      14.00,
    9.00,      14.00,     10.00,     16.00,     10.00,     16.00,     10.00,     18.00,
    10.00,     18.00,     9.00,      20.00,     10.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     7.00,      20.00,     7.00,      20.00,     5.00,      19.00,
    -99.00,    -99.00,    -99.00,    39.00,     1.00,      20.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      20.00,     0.00,      20.00,     1.00,      21.00,
    1.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      14.00,
    -99.00,    -99.00,    -99.00,    40.00,     8.00,      -7.00,     7.00,      -7.00,
    7.00,      -7.00,     5.00,      -5.00,     5.00,      -5.00,     3.00,      -2.00,
    3.00,      -2.00,     1.00,      2.00,      1.00,      2.00,      0.00,      7.00,
    0.00,      7.00,      0.00,      11.00,     0.00,      11.00,     1.00,      16.00,
    1.00,      16.00,     3.00,      20.00,     3.00,      20.00,     5.00,      23.00,
    5.00,      23.00,     7.00,      25.00,     7.00,      25.00,     8.00,      25.00,
    8.00,      25.00,     6.00,      23.00,     6.00,      23.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      16.00,     2.00,      16.00,     1.00,      11.00,
    1.00,      11.00,     1.00,      7.00,      1.00,      7.00,      2.00,      2.00,
    2.00,      2.00,      4.00,      -2.00,     4.00,      -2.00,     6.00,      -5.00,
    6.00,      -5.00,     8.00,      -7.00,     -99.00,    -99.00,    -99.00,    41.00,
    1.00,      -7.00,     0.00,      -7.00,     0.00,      -7.00,     2.00,      -5.00,
    2.00,      -5.00,     4.00,      -2.00,     4.00,      -2.00,     6.00,      2.00,
    6.00,      2.00,      7.00,      7.00,      7.00,      7.00,      7.00,      11.00,
    7.00,      11.00,     6.00,      16.00,     6.00,      16.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      23.00,     2.00,      23.00,     0.00,      25.00,
    0.00,      25.00,     1.00,      25.00,     1.00,      25.00,     3.00,      23.00,
    3.00,      23.00,     5.00,      20.00,     5.00,      20.00,     7.00,      16.00,
    7.00,      16.00,     8.00,      11.00,     8.00,      11.00,     8.00,      7.00,
    8.00,      7.00,      7.00,      2.00,      7.00,      2.00,      5.00,      -2.00,
    5.00,      -2.00,     3.00,      -5.00,     3.00,      -5.00,     1.00,      -7.00,
    -99.00,    -99.00,    -99.00,    42.00,     0.00,      8.00,      10.00,     14.00,
    10.00,     14.00,     9.00,      14.00,     9.00,      14.00,     1.00,      8.00,
    1.00,      8.00,      0.00,      8.00,      0.00,      8.00,      0.00,      9.00,
    0.00,      9.00,      10.00,     13.00,     10.00,     13.00,     10.00,     14.00,
    10.00,     8.00,      0.00,      14.00,     0.00,      14.00,     1.00,      14.00,
    1.00,      14.00,     9.00,      8.00,      9.00,      8.00,      10.00,     8.00,
    10.00,     8.00,      10.00,     9.00,      10.00,     9.00,      0.00,      13.00,
    0.00,      13.00,     0.00,      14.00,     5.00,      5.00,      5.00,      17.00,
    5.00,      17.00,     4.00,      16.00,     4.00,      16.00,     6.00,      6.00,
    6.00,      6.00,      5.00,      5.00,      5.00,      5.00,      4.00,      6.00,
    4.00,      6.00,      6.00,      16.00,     6.00,      16.00,     5.00,      17.00,
    -99.00,    -99.00,    -99.00,    43.00,     17.00,     9.00,      17.00,     10.00,
    17.00,     10.00,     0.00,      10.00,     0.00,      10.00,     0.00,      9.00,
    0.00,      9.00,      17.00,     9.00,      9.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      8.00,      18.00,     8.00,      18.00,     9.00,      18.00,
    9.00,      18.00,     9.00,      1.00,      -99.00,    -99.00,    -99.00,    44.00,
    0.00,      -4.00,     2.00,      -3.00,     2.00,      -3.00,     3.00,      -1.00,
    3.00,      -1.00,     3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      2.00,      -3.00,     1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      2.00,      0.00,      3.00,      -1.00,
    -99.00,    -99.00,    -99.00,    45.00,     17.00,     9.00,      17.00,     10.00,
    17.00,     10.00,     0.00,      10.00,     0.00,      10.00,     0.00,      9.00,
    0.00,      9.00,      17.00,     9.00,      -99.00,    -99.00,    -99.00,    46.00,
    1.00,      3.00,      0.00,      2.00,      0.00,      2.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      0.00,      1.00,      0.00,      2.00,      0.00,
    2.00,      0.00,      3.00,      1.00,      3.00,      1.00,      3.00,      2.00,
    3.00,      2.00,      2.00,      3.00,      2.00,      3.00,      1.00,      3.00,
    1.00,      2.00,      1.00,      1.00,      1.00,      1.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      2.00,      2.00,      2.00,      1.00,      2.00,
    -99.00,    -99.00,    -99.00,    47.00,     1.00,      -7.00,     0.00,      -7.00,
    0.00,      -7.00,     18.00,     25.00,     18.00,     25.00,     19.00,     25.00,
    19.00,     25.00,     1.00,      -7.00,     -99.00,    -99.00,    -99.00,    48.00,
    6.00,      21.00,     3.00,      20.00,     3.00,      20.00,     1.00,      17.00,
    1.00,      17.00,     0.00,      12.00,     0.00,      12.00,     0.00,      9.00,
    0.00,      9.00,      1.00,      4.00,      1.00,      4.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      8.00,      0.00,
    8.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     4.00,
    13.00,     4.00,      14.00,     9.00,      14.00,     9.00,      14.00,     12.00,
    14.00,     12.00,     13.00,     17.00,     13.00,     17.00,     11.00,     20.00,
    11.00,     20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    4.00,      20.00,     2.00,      17.00,     2.00,      17.00,     1.00,      12.00,
    1.00,      12.00,     1.00,      9.00,      1.00,      9.00,      2.00,      4.00,
    2.00,      4.00,      4.00,      1.00,      3.00,      2.00,      6.00,      1.00,
    6.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    10.00,     1.00,      12.00,     4.00,      12.00,     4.00,      13.00,     9.00,
    13.00,     9.00,      13.00,     12.00,     13.00,     12.00,     12.00,     17.00,
    12.00,     17.00,     10.00,     20.00,     11.00,     19.00,     8.00,      20.00,
    8.00,      20.00,     6.00,      20.00,     6.00,      20.00,     3.00,      19.00,
    -99.00,    -99.00,    -99.00,    49.00,     11.00,     0.00,      11.00,     21.00,
    11.00,     21.00,     8.00,      18.00,     8.00,      18.00,     6.00,      17.00,
    6.00,      17.00,     6.00,      16.00,     6.00,      16.00,     8.00,      17.00,
    8.00,      17.00,     10.00,     19.00,     10.00,     19.00,     10.00,     0.00,
    10.00,     0.00,      11.00,     0.00,      -99.00,    -99.00,    -99.00,    50.00,
    1.00,      0.00,      10.00,     10.00,     10.00,     10.00,     12.00,     13.00,
    12.00,     13.00,     13.00,     15.00,     13.00,     15.00,     13.00,     17.00,
    13.00,     17.00,     12.00,     19.00,     12.00,     19.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     9.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     3.00,      20.00,     3.00,      20.00,     2.00,      19.00,
    2.00,      19.00,     1.00,      17.00,     1.00,      17.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      16.00,     2.00,      16.00,     2.00,      17.00,
    2.00,      17.00,     3.00,      19.00,     3.00,      19.00,     5.00,      20.00,
    5.00,      20.00,     9.00,      20.00,     9.00,      20.00,     11.00,     19.00,
    11.00,     19.00,     12.00,     17.00,     12.00,     17.00,     12.00,     15.00,
    12.00,     15.00,     11.00,     13.00,     11.00,     13.00,     9.00,      10.00,
    9.00,      10.00,     0.00,      0.00,      0.00,      0.00,      14.00,     0.00,
    14.00,     0.00,      14.00,     1.00,      14.00,     1.00,      1.00,      1.00,
    -99.00,    -99.00,    -99.00,    51.00,     6.00,      13.00,     8.00,      13.00,
    8.00,      13.00,     11.00,     12.00,     11.00,     12.00,     13.00,     10.00,
    13.00,     10.00,     14.00,     7.00,      14.00,     7.00,      14.00,     6.00,
    14.00,     6.00,      13.00,     3.00,      13.00,     3.00,      11.00,     1.00,
    11.00,     1.00,      8.00,      0.00,      8.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      1.00,      4.00,
    1.00,      4.00,      2.00,      2.00,      2.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      8.00,      1.00,      8.00,      1.00,      11.00,     2.00,
    11.00,     2.00,      13.00,     5.00,      12.00,     21.00,     5.00,      12.00,
    5.00,      12.00,     8.00,      12.00,     8.00,      12.00,     11.00,     11.00,
    11.00,     11.00,     13.00,     8.00,      6.00,      12.00,     13.00,     21.00,
    13.00,     21.00,     2.00,      21.00,     2.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     12.00,     20.00,     9.00,      12.00,     12.00,     10.00,
    12.00,     10.00,     13.00,     7.00,      13.00,     7.00,      13.00,     6.00,
    13.00,     6.00,      12.00,     3.00,      12.00,     3.00,      9.00,      1.00,
    4.00,      1.00,      1.00,      3.00,      -99.00,    -99.00,    -99.00,    52.00,
    1.00,      5.00,      10.00,     18.00,     10.00,     18.00,     10.00,     0.00,
    10.00,     0.00,      11.00,     0.00,      11.00,     0.00,      11.00,     21.00,
    11.00,     21.00,     0.00,      5.00,      0.00,      5.00,      15.00,     5.00,
    15.00,     5.00,      15.00,     6.00,      15.00,     6.00,      1.00,      6.00,
    -99.00,    -99.00,    -99.00,    53.00,     13.00,     9.00,      11.00,     12.00,
    11.00,     12.00,     8.00,      13.00,     8.00,      13.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      12.00,     2.00,      12.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      21.00,     2.00,      21.00,     12.00,     21.00,
    12.00,     21.00,     12.00,     20.00,     12.00,     20.00,     3.00,      20.00,
    3.00,      20.00,     2.00,      13.00,     2.00,      13.00,     5.00,      14.00,
    5.00,      14.00,     8.00,      14.00,     8.00,      14.00,     11.00,     13.00,
    11.00,     13.00,     13.00,     11.00,     13.00,     11.00,     14.00,     8.00,
    14.00,     8.00,      14.00,     6.00,      14.00,     6.00,      13.00,     3.00,
    13.00,     3.00,      11.00,     1.00,      11.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      2.00,      1.00,      2.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      4.00,      1.00,      4.00,      2.00,      2.00,
    2.00,      2.00,      5.00,      1.00,      5.00,      1.00,      8.00,      1.00,
    8.00,      1.00,      11.00,     2.00,      11.00,     2.00,      13.00,     5.00,
    9.00,      13.00,     12.00,     11.00,     12.00,     11.00,     13.00,     8.00,
    13.00,     8.00,      13.00,     6.00,      13.00,     6.00,      12.00,     3.00,
    12.00,     3.00,      9.00,      1.00,      4.00,      1.00,      1.00,      3.00,
    -99.00,    -99.00,    -99.00,    54.00,     10.00,     20.00,     11.00,     18.00,
    11.00,     18.00,     12.00,     18.00,     12.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    6.00,      21.00,     3.00,      20.00,     3.00,      20.00,     1.00,      17.00,
    1.00,      17.00,     0.00,      12.00,     0.00,      12.00,     0.00,      7.00,
    0.00,      7.00,      1.00,      3.00,      1.00,      3.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      10.00,     1.00,      10.00,     1.00,      12.00,     3.00,
    12.00,     3.00,      13.00,     6.00,      13.00,     6.00,      13.00,     7.00,
    13.00,     7.00,      12.00,     10.00,     12.00,     10.00,     10.00,     12.00,
    10.00,     12.00,     7.00,      13.00,     7.00,      13.00,     6.00,      13.00,
    6.00,      13.00,     3.00,      12.00,     3.00,      12.00,     1.00,      10.00,
    11.00,     19.00,     8.00,      20.00,     8.00,      20.00,     6.00,      20.00,
    6.00,      20.00,     3.00,      19.00,     4.00,      20.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      12.00,     1.00,      12.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      3.00,      2.00,      3.00,      5.00,      1.00,
    1.00,      5.00,      3.00,      2.00,      3.00,      2.00,      6.00,      1.00,
    6.00,      1.00,      7.00,      1.00,      7.00,      1.00,      10.00,     2.00,
    10.00,     2.00,      12.00,     5.00,      8.00,      1.00,      11.00,     3.00,
    11.00,     3.00,      12.00,     6.00,      12.00,     6.00,      12.00,     7.00,
    12.00,     7.00,      11.00,     10.00,     11.00,     10.00,     8.00,      12.00,
    12.00,     8.00,      10.00,     11.00,     10.00,     11.00,     7.00,      12.00,
    7.00,      12.00,     6.00,      12.00,     6.00,      12.00,     3.00,      11.00,
    3.00,      11.00,     1.00,      8.00,      5.00,      12.00,     2.00,      10.00,
    2.00,      10.00,     1.00,      7.00,      -99.00,    -99.00,    -99.00,    55.00,
    13.00,     20.00,     0.00,      20.00,     0.00,      20.00,     0.00,      21.00,
    0.00,      21.00,     14.00,     21.00,     14.00,     21.00,     4.00,      0.00,
    4.00,      0.00,      3.00,      0.00,      3.00,      0.00,      13.00,     21.00,
    -99.00,    -99.00,    -99.00,    56.00,     5.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     1.00,      18.00,     1.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      14.00,     2.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     5.00,      12.00,     5.00,      12.00,     9.00,      11.00,
    9.00,      11.00,     11.00,     10.00,     11.00,     10.00,     12.00,     9.00,
    12.00,     9.00,      13.00,     7.00,      13.00,     7.00,      13.00,     4.00,
    13.00,     4.00,      12.00,     2.00,      12.00,     2.00,      9.00,      1.00,
    9.00,      1.00,      5.00,      1.00,      5.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      4.00,      1.00,      4.00,      1.00,      7.00,
    1.00,      7.00,      2.00,      9.00,      2.00,      9.00,      3.00,      10.00,
    3.00,      10.00,     5.00,      11.00,     5.00,      11.00,     9.00,      12.00,
    9.00,      12.00,     11.00,     13.00,     11.00,     13.00,     12.00,     14.00,
    12.00,     14.00,     13.00,     16.00,     13.00,     16.00,     13.00,     18.00,
    13.00,     18.00,     12.00,     20.00,     12.00,     20.00,     9.00,      21.00,
    9.00,      21.00,     5.00,      21.00,     3.00,      20.00,     2.00,      18.00,
    2.00,      18.00,     2.00,      16.00,     2.00,      16.00,     3.00,      14.00,
    3.00,      14.00,     5.00,      13.00,     5.00,      13.00,     9.00,      12.00,
    9.00,      12.00,     11.00,     11.00,     11.00,     11.00,     13.00,     9.00,
    13.00,     9.00,      14.00,     7.00,      14.00,     7.00,      14.00,     4.00,
    14.00,     4.00,      13.00,     2.00,      13.00,     2.00,      12.00,     1.00,
    12.00,     1.00,      9.00,      0.00,      9.00,      0.00,      5.00,      0.00,
    5.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      7.00,
    0.00,      7.00,      1.00,      9.00,      1.00,      9.00,      3.00,      11.00,
    3.00,      11.00,     5.00,      12.00,     5.00,      12.00,     9.00,      13.00,
    9.00,      13.00,     11.00,     14.00,     11.00,     14.00,     12.00,     16.00,
    12.00,     16.00,     12.00,     18.00,     12.00,     18.00,     11.00,     20.00,
    12.00,     19.00,     9.00,      20.00,     9.00,      20.00,     5.00,      20.00,
    5.00,      20.00,     2.00,      19.00,     1.00,      3.00,      4.00,      1.00,
    10.00,     1.00,      13.00,     3.00,      -99.00,    -99.00,    -99.00,    57.00,
    12.00,     11.00,     10.00,     9.00,      10.00,     9.00,      7.00,      8.00,
    7.00,      8.00,      6.00,      8.00,      6.00,      8.00,      3.00,      9.00,
    3.00,      9.00,      1.00,      11.00,     1.00,      11.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      15.00,     0.00,      15.00,     1.00,      18.00,
    1.00,      18.00,     3.00,      20.00,     3.00,      20.00,     6.00,      21.00,
    6.00,      21.00,     7.00,      21.00,     7.00,      21.00,     10.00,     20.00,
    10.00,     20.00,     12.00,     18.00,     12.00,     18.00,     13.00,     14.00,
    13.00,     14.00,     13.00,     9.00,      13.00,     9.00,      12.00,     4.00,
    12.00,     4.00,      10.00,     1.00,      10.00,     1.00,      7.00,      0.00,
    7.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      3.00,      1.00,      3.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      1.00,      12.00,     14.00,     11.00,     11.00,
    11.00,     11.00,     8.00,      9.00,      12.00,     13.00,     10.00,     10.00,
    10.00,     10.00,     7.00,      9.00,      7.00,      9.00,      6.00,      9.00,
    6.00,      9.00,      3.00,      10.00,     3.00,      10.00,     1.00,      13.00,
    5.00,      9.00,      2.00,      11.00,     2.00,      11.00,     1.00,      14.00,
    1.00,      14.00,     1.00,      15.00,     1.00,      15.00,     2.00,      18.00,
    2.00,      18.00,     5.00,      20.00,     1.00,      16.00,     3.00,      19.00,
    3.00,      19.00,     6.00,      20.00,     6.00,      20.00,     7.00,      20.00,
    7.00,      20.00,     10.00,     19.00,     10.00,     19.00,     12.00,     16.00,
    8.00,      20.00,     11.00,     18.00,     11.00,     18.00,     12.00,     14.00,
    12.00,     14.00,     12.00,     9.00,      12.00,     9.00,      11.00,     4.00,
    11.00,     4.00,      9.00,      1.00,      10.00,     2.00,      7.00,      1.00,
    7.00,      1.00,      5.00,      1.00,      5.00,      1.00,      2.00,      2.00,
    -99.00,    -99.00,    -99.00,    58.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      12.00,     0.00,      12.00,     1.00,      11.00,
    1.00,      11.00,     2.00,      11.00,     2.00,      11.00,     3.00,      12.00,
    3.00,      12.00,     3.00,      13.00,     3.00,      13.00,     2.00,      14.00,
    2.00,      14.00,     1.00,      14.00,     1.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      12.00,     2.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      13.00,     1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      -99.00,    -99.00,    -99.00,    59.00,
    0.00,      -4.00,     2.00,      -3.00,     2.00,      -3.00,     3.00,      -1.00,
    3.00,      -1.00,     3.00,      2.00,      3.00,      2.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      3.00,      1.00,      3.00,      0.00,      2.00,
    0.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      0.00,      2.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      2.00,      -3.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      12.00,     0.00,      12.00,     1.00,      11.00,
    1.00,      11.00,     2.00,      11.00,     2.00,      11.00,     3.00,      12.00,
    3.00,      12.00,     3.00,      13.00,     3.00,      13.00,     2.00,      14.00,
    2.00,      14.00,     1.00,      14.00,     1.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      12.00,     2.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      13.00,     1.00,      2.00,      1.00,      1.00,
    1.00,      1.00,      2.00,      1.00,      2.00,      1.00,      2.00,      2.00,
    2.00,      2.00,      1.00,      2.00,      2.00,      0.00,      3.00,      -1.00,
    -99.00,    -99.00,    -99.00,    60.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      -99.00,    -99.00,    -99.00,    61.00,
    17.00,     5.00,      17.00,     6.00,      17.00,     6.00,      0.00,      6.00,
    0.00,      6.00,      0.00,      5.00,      0.00,      5.00,      17.00,     5.00,
    17.00,     13.00,     17.00,     14.00,     17.00,     14.00,     0.00,      14.00,
    0.00,      14.00,     0.00,      13.00,     0.00,      13.00,     17.00,     13.00,
    -99.00,    -99.00,    -99.00,    62.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      -99.00,    -99.00,    -99.00,    63.00,
    6.00,      10.00,     9.00,      11.00,     9.00,      11.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     13.00,     12.00,     13.00,     13.00,     15.00,
    13.00,     15.00,     13.00,     17.00,     13.00,     17.00,     12.00,     19.00,
    12.00,     19.00,     11.00,     20.00,     11.00,     20.00,     8.00,      21.00,
    8.00,      21.00,     5.00,      21.00,     5.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     1.00,      19.00,     1.00,      19.00,     0.00,      17.00,
    0.00,      17.00,     0.00,      16.00,     0.00,      16.00,     1.00,      16.00,
    1.00,      16.00,     1.00,      17.00,     1.00,      17.00,     2.00,      19.00,
    2.00,      19.00,     5.00,      20.00,     5.00,      20.00,     8.00,      20.00,
    8.00,      20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     15.00,     12.00,     15.00,     11.00,     13.00,
    11.00,     13.00,     9.00,      12.00,     9.00,      12.00,     6.00,      11.00,
    6.00,      11.00,     6.00,      7.00,      6.00,      7.00,      7.00,      7.00,
    7.00,      7.00,      7.00,      11.00,     1.00,      18.00,     4.00,      20.00,
    9.00,      20.00,     12.00,     18.00,     12.00,     14.00,     8.00,      11.00,
    6.00,      3.00,      5.00,      2.00,      5.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      8.00,      1.00,      8.00,      1.00,      8.00,      2.00,
    8.00,      2.00,      7.00,      3.00,      7.00,      3.00,      6.00,      3.00,
    6.00,      2.00,      6.00,      1.00,      6.00,      1.00,      7.00,      1.00,
    7.00,      1.00,      7.00,      2.00,      7.00,      2.00,      6.00,      2.00,
    -99.00,    -99.00,    -99.00,    64.00,     15.00,     13.00,     14.00,     15.00,
    14.00,     15.00,     12.00,     16.00,     12.00,     16.00,     9.00,      16.00,
    9.00,      16.00,     7.00,      15.00,     7.00,      15.00,     6.00,      14.00,
    6.00,      14.00,     5.00,      11.00,     5.00,      11.00,     5.00,      8.00,
    5.00,      8.00,      6.00,      6.00,      6.00,      6.00,      8.00,      5.00,
    8.00,      5.00,      11.00,     5.00,      11.00,     5.00,      13.00,     6.00,
    13.00,     6.00,      14.00,     8.00,      9.00,      16.00,     7.00,      14.00,
    7.00,      14.00,     6.00,      11.00,     6.00,      11.00,     6.00,      8.00,
    6.00,      8.00,      7.00,      6.00,      7.00,      6.00,      8.00,      5.00,
    15.00,     16.00,     14.00,     8.00,      14.00,     8.00,      14.00,     6.00,
    14.00,     6.00,      16.00,     5.00,      16.00,     5.00,      18.00,     5.00,
    18.00,     5.00,      20.00,     7.00,      20.00,     7.00,      21.00,     10.00,
    21.00,     10.00,     21.00,     12.00,     21.00,     12.00,     20.00,     15.00,
    20.00,     15.00,     19.00,     17.00,     19.00,     17.00,     17.00,     19.00,
    17.00,     19.00,     15.00,     20.00,     15.00,     20.00,     12.00,     21.00,
    12.00,     21.00,     9.00,      21.00,     9.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      15.00,     1.00,      15.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      9.00,      0.00,      9.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      4.00,      2.00,      4.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     0.00,      12.00,     0.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     2.00,      17.00,     2.00,      18.00,     3.00,
    16.00,     16.00,     15.00,     8.00,      15.00,     8.00,      15.00,     6.00,
    15.00,     6.00,      16.00,     5.00,      -99.00,    -99.00,    -99.00,    65.00,
    2.00,      0.00,      9.00,      21.00,     9.00,      21.00,     16.00,     0.00,
    9.00,      18.00,     15.00,     0.00,      4.00,      6.00,      13.00,     6.00,
    0.00,      0.00,      6.00,      0.00,      12.00,     0.00,      18.00,     0.00,
    -99.00,    -99.00,    -99.00,    66.00,     0.00,      21.00,     12.00,     21.00,
    12.00,     21.00,     15.00,     20.00,     15.00,     20.00,     16.00,     19.00,
    16.00,     19.00,     17.00,     17.00,     17.00,     17.00,     17.00,     15.00,
    17.00,     15.00,     16.00,     13.00,     16.00,     13.00,     15.00,     12.00,
    15.00,     12.00,     12.00,     11.00,     12.00,     11.00,     14.00,     12.00,
    14.00,     12.00,     15.00,     13.00,     15.00,     13.00,     16.00,     15.00,
    16.00,     15.00,     16.00,     17.00,     16.00,     17.00,     15.00,     19.00,
    15.00,     19.00,     14.00,     20.00,     14.00,     20.00,     12.00,     21.00,
    3.00,      21.00,     3.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    4.00,      11.00,     12.00,     11.00,     12.00,     11.00,     15.00,     10.00,
    15.00,     10.00,     16.00,     9.00,      16.00,     9.00,      17.00,     7.00,
    17.00,     7.00,      17.00,     4.00,      17.00,     4.00,      16.00,     2.00,
    16.00,     2.00,      15.00,     1.00,      15.00,     1.00,      12.00,     0.00,
    12.00,     0.00,      0.00,      0.00,      12.00,     11.00,     14.00,     10.00,
    14.00,     10.00,     15.00,     9.00,      15.00,     9.00,      16.00,     7.00,
    16.00,     7.00,      16.00,     4.00,      16.00,     4.00,      15.00,     2.00,
    15.00,     2.00,      14.00,     1.00,      14.00,     1.00,      12.00,     0.00,
    -99.00,    -99.00,    -99.00,    67.00,     3.00,      21.00,     3.00,      0.00,
    4.00,      21.00,     4.00,      0.00,      16.00,     21.00,     16.00,     0.00,
    17.00,     21.00,     17.00,     0.00,      0.00,      21.00,     7.00,      21.00,
    13.00,     21.00,     20.00,     21.00,     4.00,      11.00,     16.00,     11.00,
    0.00,      0.00,      7.00,      0.00,      13.00,     0.00,      20.00,     0.00,
    -99.00,    -99.00,    -99.00,    68.00,     16.00,     0.00,      8.00,      21.00,
    8.00,      21.00,     0.00,      0.00,      0.00,      0.00,      16.00,     0.00,
    8.00,      18.00,     15.00,     0.00,      1.00,      1.00,      15.00,     1.00,
    -99.00,    -99.00,    -99.00,    69.00,     3.00,      21.00,     3.00,      0.00,
    4.00,      21.00,     4.00,      0.00,      10.00,     15.00,     10.00,     7.00,
    0.00,      21.00,     16.00,     21.00,     16.00,     21.00,     16.00,     15.00,
    16.00,     15.00,     15.00,     21.00,     4.00,      11.00,     10.00,     11.00,
    0.00,      0.00,      16.00,     0.00,      16.00,     0.00,      16.00,     6.00,
    16.00,     6.00,      15.00,     0.00,      -99.00,    -99.00,    -99.00,    70.00,
    5.00,      16.00,     10.00,     16.00,     10.00,     16.00,     13.00,     15.00,
    13.00,     15.00,     14.00,     14.00,     14.00,     14.00,     15.00,     12.00,
    15.00,     12.00,     15.00,     9.00,      15.00,     9.00,      14.00,     7.00,
    14.00,     7.00,      13.00,     6.00,      13.00,     6.00,      10.00,     5.00,
    10.00,     5.00,      5.00,      5.00,      5.00,      5.00,      2.00,      6.00,
    2.00,      6.00,      1.00,      7.00,      1.00,      7.00,      0.00,      9.00,
    0.00,      9.00,      0.00,      12.00,     0.00,      12.00,     1.00,      14.00,
    1.00,      14.00,     2.00,      15.00,     2.00,      15.00,     5.00,      16.00,
    5.00,      16.00,     3.00,      15.00,     3.00,      15.00,     2.00,      14.00,
    2.00,      14.00,     1.00,      12.00,     1.00,      12.00,     1.00,      9.00,
    1.00,      9.00,      2.00,      7.00,      2.00,      7.00,      3.00,      6.00,
    3.00,      6.00,      5.00,      5.00,      7.00,      21.00,     7.00,      0.00,
    8.00,      21.00,     8.00,      0.00,      10.00,     5.00,      12.00,     6.00,
    12.00,     6.00,      13.00,     7.00,      13.00,     7.00,      14.00,     9.00,
    14.00,     9.00,      14.00,     12.00,     14.00,     12.00,     13.00,     14.00,
    13.00,     14.00,     12.00,     15.00,     12.00,     15.00,     10.00,     16.00,
    4.00,      21.00,     11.00,     21.00,     4.00,      0.00,      11.00,     0.00,
    -99.00,    -99.00,    -99.00,    71.00,     3.00,      21.00,     3.00,      0.00,
    4.00,      21.00,     4.00,      0.00,      0.00,      21.00,     15.00,     21.00,
    15.00,     21.00,     15.00,     15.00,     15.00,     15.00,     14.00,     21.00,
    0.00,      0.00,      7.00,      0.00,      -99.00,    -99.00,    -99.00,    72.00,
    2.00,      21.00,     15.00,     0.00,      3.00,      21.00,     16.00,     0.00,
    16.00,     21.00,     2.00,      0.00,      0.00,      21.00,     6.00,      21.00,
    12.00,     21.00,     18.00,     21.00,     0.00,      0.00,      6.00,      0.00,
    12.00,     0.00,      18.00,     0.00,      -99.00,    -99.00,    -99.00,    73.00,
    3.00,      21.00,     3.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    0.00,      21.00,     7.00,      21.00,     0.00,      0.00,      7.00,      0.00,
    -99.00,    -99.00,    -99.00,    74.00,     8.00,      21.00,     8.00,      4.00,
    8.00,      4.00,      7.00,      1.00,      7.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      0.00,      3.00,      0.00,      1.00,      1.00,
    1.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      5.00,
    0.00,      5.00,      1.00,      6.00,      1.00,      6.00,      2.00,      5.00,
    2.00,      5.00,      1.00,      4.00,      7.00,      21.00,     7.00,      4.00,
    7.00,      4.00,      6.00,      1.00,      6.00,      1.00,      5.00,      0.00,
    4.00,      21.00,     11.00,     21.00,     -99.00,    -99.00,    -99.00,    75.00,
    3.00,      21.00,     3.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    17.00,     21.00,     4.00,      8.00,      9.00,      12.00,     17.00,     0.00,
    8.00,      12.00,     16.00,     0.00,      0.00,      21.00,     7.00,      21.00,
    13.00,     21.00,     19.00,     21.00,     0.00,      0.00,      7.00,      0.00,
    13.00,     0.00,      19.00,     0.00,      -99.00,    -99.00,    -99.00,    76.00,
    2.00,      0.00,      9.00,      21.00,     9.00,      21.00,     16.00,     0.00,
    9.00,      18.00,     15.00,     0.00,      0.00,      0.00,      6.00,      0.00,
    12.00,     0.00,      18.00,     0.00,      -99.00,    -99.00,    -99.00,    77.00,
    10.00,     3.00,      4.00,      21.00,     4.00,      21.00,     0.00,      21.00,
    3.00,      0.00,      3.00,      21.00,     3.00,      21.00,     10.00,     0.00,
    10.00,     0.00,      17.00,     21.00,     17.00,     21.00,     17.00,     0.00,
    18.00,     21.00,     18.00,     0.00,      17.00,     21.00,     21.00,     21.00,
    0.00,      0.00,      6.00,      0.00,      14.00,     0.00,      21.00,     0.00,
    -99.00,    -99.00,    -99.00,    78.00,     4.00,      19.00,     16.00,     0.00,
    16.00,     0.00,      16.00,     21.00,     16.00,     2.00,      4.00,      21.00,
    4.00,      21.00,     0.00,      21.00,     3.00,      21.00,     3.00,      0.00,
    13.00,     21.00,     19.00,     21.00,     0.00,      0.00,      6.00,      0.00,
    -99.00,    -99.00,    -99.00,    79.00,     7.00,      21.00,     9.00,      21.00,
    9.00,      21.00,     12.00,     20.00,     12.00,     20.00,     14.00,     18.00,
    14.00,     18.00,     15.00,     16.00,     15.00,     16.00,     16.00,     12.00,
    16.00,     12.00,     16.00,     9.00,      16.00,     9.00,      15.00,     5.00,
    15.00,     5.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      9.00,      0.00,      9.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      4.00,      1.00,      4.00,      1.00,      2.00,      3.00,
    2.00,      3.00,      1.00,      5.00,      1.00,      5.00,      0.00,      9.00,
    0.00,      9.00,      0.00,      12.00,     0.00,      12.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      18.00,     2.00,      18.00,     4.00,      20.00,
    4.00,      20.00,     7.00,      21.00,     7.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     3.00,      18.00,     3.00,      18.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      12.00,     1.00,      12.00,     1.00,      9.00,
    1.00,      9.00,      2.00,      5.00,      2.00,      5.00,      3.00,      3.00,
    3.00,      3.00,      5.00,      1.00,      5.00,      1.00,      7.00,      0.00,
    9.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     3.00,
    13.00,     3.00,      14.00,     5.00,      14.00,     5.00,      15.00,     9.00,
    15.00,     9.00,      15.00,     12.00,     15.00,     12.00,     14.00,     16.00,
    14.00,     16.00,     13.00,     18.00,     13.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     -99.00,    -99.00,    -99.00,    80.00,
    3.00,      21.00,     3.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    16.00,     21.00,     16.00,     0.00,      17.00,     21.00,     17.00,     0.00,
    0.00,      21.00,     20.00,     21.00,     0.00,      0.00,      7.00,      0.00,
    13.00,     0.00,      20.00,     0.00,      -99.00,    -99.00,    -99.00,    81.00,
    7.00,      21.00,     9.00,      21.00,     9.00,      21.00,     12.00,     20.00,
    12.00,     20.00,     14.00,     18.00,     14.00,     18.00,     15.00,     16.00,
    15.00,     16.00,     16.00,     12.00,     16.00,     12.00,     16.00,     9.00,
    16.00,     9.00,      15.00,     5.00,      15.00,     5.00,      14.00,     3.00,
    14.00,     3.00,      12.00,     1.00,      12.00,     1.00,      9.00,      0.00,
    9.00,      0.00,      7.00,      0.00,      7.00,      0.00,      4.00,      1.00,
    4.00,      1.00,      2.00,      3.00,      2.00,      3.00,      1.00,      5.00,
    1.00,      5.00,      0.00,      9.00,      0.00,      9.00,      0.00,      12.00,
    0.00,      12.00,     1.00,      16.00,     1.00,      16.00,     2.00,      18.00,
    2.00,      18.00,     4.00,      20.00,     4.00,      20.00,     7.00,      21.00,
    7.00,      21.00,     5.00,      20.00,     5.00,      20.00,     3.00,      18.00,
    3.00,      18.00,     2.00,      16.00,     2.00,      16.00,     1.00,      12.00,
    1.00,      12.00,     1.00,      9.00,      1.00,      9.00,      2.00,      5.00,
    2.00,      5.00,      3.00,      3.00,      3.00,      3.00,      5.00,      1.00,
    5.00,      1.00,      7.00,      0.00,      9.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      13.00,     3.00,      13.00,     3.00,      14.00,     5.00,
    14.00,     5.00,      15.00,     9.00,      15.00,     9.00,      15.00,     12.00,
    15.00,     12.00,     14.00,     16.00,     14.00,     16.00,     13.00,     18.00,
    13.00,     18.00,     11.00,     20.00,     11.00,     20.00,     9.00,      21.00,
    5.00,      14.00,     5.00,      7.00,      11.00,     14.00,     11.00,     7.00,
    5.00,      11.00,     11.00,     11.00,     5.00,      10.00,     11.00,     10.00,
    -99.00,    -99.00,    -99.00,    82.00,     3.00,      21.00,     3.00,      0.00,
    4.00,      21.00,     4.00,      0.00,      0.00,      21.00,     12.00,     21.00,
    12.00,     21.00,     15.00,     20.00,     15.00,     20.00,     16.00,     19.00,
    16.00,     19.00,     17.00,     17.00,     17.00,     17.00,     17.00,     14.00,
    17.00,     14.00,     16.00,     12.00,     16.00,     12.00,     15.00,     11.00,
    15.00,     11.00,     12.00,     10.00,     12.00,     10.00,     4.00,      10.00,
    12.00,     21.00,     14.00,     20.00,     14.00,     20.00,     15.00,     19.00,
    15.00,     19.00,     16.00,     17.00,     16.00,     17.00,     16.00,     14.00,
    16.00,     14.00,     15.00,     12.00,     15.00,     12.00,     14.00,     11.00,
    14.00,     11.00,     12.00,     10.00,     0.00,      0.00,      7.00,      0.00,
    -99.00,    -99.00,    -99.00,    83.00,     7.00,      11.00,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     16.00,     15.00,
    16.00,     15.00,     14.00,     21.00,     1.00,      21.00,     8.00,      11.00,
    8.00,      11.00,     0.00,      0.00,      0.00,      0.00,      15.00,     0.00,
    15.00,     0.00,      16.00,     6.00,      16.00,     6.00,      14.00,     0.00,
    1.00,      1.00,      14.00,     1.00,      -99.00,    -99.00,    -99.00,    84.00,
    7.00,      21.00,     7.00,      0.00,      8.00,      21.00,     8.00,      0.00,
    1.00,      21.00,     0.00,      15.00,     0.00,      15.00,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     15.00,     15.00,
    15.00,     15.00,     14.00,     21.00,     4.00,      0.00,      11.00,     0.00,
    -99.00,    -99.00,    -99.00,    85.00,     0.00,      16.00,     0.00,      18.00,
    0.00,      18.00,     1.00,      20.00,     1.00,      20.00,     2.00,      21.00,
    2.00,      21.00,     4.00,      21.00,     4.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     6.00,      18.00,     6.00,      18.00,     7.00,      14.00,
    7.00,      14.00,     7.00,      0.00,      0.00,      18.00,     2.00,      20.00,
    2.00,      20.00,     4.00,      20.00,     4.00,      20.00,     6.00,      18.00,
    15.00,     16.00,     15.00,     18.00,     15.00,     18.00,     14.00,     20.00,
    14.00,     20.00,     13.00,     21.00,     13.00,     21.00,     11.00,     21.00,
    11.00,     21.00,     10.00,     20.00,     10.00,     20.00,     9.00,      18.00,
    9.00,      18.00,     8.00,      14.00,     8.00,      14.00,     8.00,      0.00,
    15.00,     18.00,     13.00,     20.00,     13.00,     20.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      18.00,     4.00,      0.00,      11.00,     0.00,
    -99.00,    -99.00,    -99.00,    86.00,     2.00,      21.00,     9.00,      0.00,
    9.00,      0.00,      16.00,     21.00,     3.00,      21.00,     9.00,      3.00,
    0.00,      21.00,     6.00,      21.00,     12.00,     21.00,     18.00,     21.00,
    -99.00,    -99.00,    -99.00,    87.00,     0.00,      3.00,      1.00,      0.00,
    1.00,      0.00,      5.00,      0.00,      5.00,      0.00,      3.00,      4.00,
    3.00,      4.00,      1.00,      8.00,      1.00,      8.00,      0.00,      11.00,
    0.00,      11.00,     0.00,      15.00,     0.00,      15.00,     1.00,      18.00,
    1.00,      18.00,     3.00,      20.00,     3.00,      20.00,     6.00,      21.00,
    6.00,      21.00,     10.00,     21.00,     10.00,     21.00,     13.00,     20.00,
    13.00,     20.00,     15.00,     18.00,     15.00,     18.00,     16.00,     15.00,
    16.00,     15.00,     16.00,     11.00,     16.00,     11.00,     15.00,     8.00,
    15.00,     8.00,      13.00,     4.00,      13.00,     4.00,      11.00,     0.00,
    11.00,     0.00,      15.00,     0.00,      15.00,     0.00,      16.00,     3.00,
    3.00,      4.00,      2.00,      7.00,      2.00,      7.00,      1.00,      11.00,
    1.00,      11.00,     1.00,      15.00,     1.00,      15.00,     2.00,      18.00,
    2.00,      18.00,     4.00,      20.00,     4.00,      20.00,     6.00,      21.00,
    10.00,     21.00,     12.00,     20.00,     12.00,     20.00,     14.00,     18.00,
    14.00,     18.00,     15.00,     15.00,     15.00,     15.00,     15.00,     11.00,
    15.00,     11.00,     14.00,     7.00,      14.00,     7.00,      13.00,     4.00,
    1.00,      1.00,      4.00,      1.00,      12.00,     1.00,      15.00,     1.00,
    -99.00,    -99.00,    -99.00,    88.00,     1.00,      22.00,     0.00,      17.00,
    16.00,     22.00,     15.00,     17.00,     5.00,      13.00,     4.00,      8.00,
    12.00,     13.00,     11.00,     8.00,      1.00,      4.00,      0.00,      -1.00,
    16.00,     4.00,      15.00,     -1.00,     1.00,      20.00,     15.00,     20.00,
    1.00,      19.00,     15.00,     19.00,     5.00,      11.00,     11.00,     11.00,
    5.00,      10.00,     11.00,     10.00,     1.00,      2.00,      15.00,     2.00,
    1.00,      1.00,      15.00,     1.00,      -99.00,    -99.00,    -99.00,    89.00,
    9.00,      21.00,     9.00,      0.00,      10.00,     21.00,     10.00,     0.00,
    0.00,      14.00,     1.00,      15.00,     1.00,      15.00,     3.00,      14.00,
    3.00,      14.00,     4.00,      10.00,     4.00,      10.00,     5.00,      8.00,
    5.00,      8.00,      6.00,      7.00,      6.00,      7.00,      8.00,      6.00,
    1.00,      15.00,     2.00,      14.00,     2.00,      14.00,     3.00,      10.00,
    3.00,      10.00,     4.00,      8.00,      4.00,      8.00,      5.00,      7.00,
    5.00,      7.00,      8.00,      6.00,      8.00,      6.00,      11.00,     6.00,
    11.00,     6.00,      14.00,     7.00,      14.00,     7.00,      15.00,     8.00,
    15.00,     8.00,      16.00,     10.00,     16.00,     10.00,     17.00,     14.00,
    17.00,     14.00,     18.00,     15.00,     11.00,     6.00,      13.00,     7.00,
    13.00,     7.00,      14.00,     8.00,      14.00,     8.00,      15.00,     10.00,
    15.00,     10.00,     16.00,     14.00,     16.00,     14.00,     18.00,     15.00,
    18.00,     15.00,     19.00,     14.00,     6.00,      21.00,     13.00,     21.00,
    6.00,      0.00,      13.00,     0.00,      -99.00,    -99.00,    -99.00,    90.00,
    1.00,      0.00,      14.00,     21.00,     14.00,     21.00,     0.00,      21.00,
    0.00,      21.00,     0.00,      15.00,     0.00,      15.00,     1.00,      21.00,
    13.00,     21.00,     0.00,      0.00,      0.00,      0.00,      14.00,     0.00,
    14.00,     0.00,      14.00,     6.00,      14.00,     6.00,      13.00,     0.00,
    -99.00,    -99.00,    -99.00,    91.00,     7.00,      25.00,     0.00,      25.00,
    0.00,      25.00,     0.00,      -7.00,     0.00,      -7.00,     7.00,      -7.00,
    1.00,      25.00,     1.00,      -7.00,     -99.00,    -99.00,    -99.00,    92.00,
    20.00,     -3.00,     19.00,     -4.00,     19.00,     -4.00,     0.00,      28.00,
    0.00,      28.00,     1.00,      29.00,     1.00,      29.00,     20.00,     -3.00,
    -99.00,    -99.00,    -99.00,    93.00,     0.00,      25.00,     7.00,      25.00,
    7.00,      25.00,     7.00,      -7.00,     7.00,      -7.00,     0.00,      -7.00,
    6.00,      25.00,     6.00,      -7.00,     -99.00,    -99.00,    -99.00,    94.00,
    0.00,      16.00,     8.00,      21.00,     8.00,      21.00,     16.00,     16.00,
    16.00,     16.00,     8.00,      20.00,     8.00,      20.00,     0.00,      16.00,
    -99.00,    -99.00,    -99.00,    95.00,     17.00,     -2.00,     17.00,     -1.00,
    17.00,     -1.00,     0.00,      -1.00,     0.00,      -1.00,     0.00,      -2.00,
    0.00,      -2.00,     17.00,     -2.00,     -99.00,    -99.00,    -99.00,    96.00,
    6.00,      15.00,     1.00,      21.00,     1.00,      21.00,     0.00,      20.00,
    0.00,      20.00,     6.00,      15.00,     -99.00,    -99.00,    -99.00,    97.00,
    16.00,     14.00,     15.00,     11.00,     15.00,     11.00,     13.00,     7.00,
    13.00,     7.00,      11.00,     4.00,      11.00,     4.00,      8.00,      1.00,
    8.00,      1.00,      6.00,      0.00,      6.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      1.00,      1.00,      1.00,      1.00,      0.00,      3.00,
    0.00,      3.00,      0.00,      6.00,      0.00,      6.00,      1.00,      9.00,
    1.00,      9.00,      2.00,      11.00,     2.00,      11.00,     4.00,      13.00,
    4.00,      13.00,     7.00,      14.00,     7.00,      14.00,     5.00,      13.00,
    5.00,      13.00,     3.00,      11.00,     3.00,      11.00,     2.00,      9.00,
    2.00,      9.00,      1.00,      6.00,      1.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      2.00,      1.00,      2.00,      1.00,      4.00,      0.00,
    7.00,      14.00,     9.00,      14.00,     9.00,      14.00,     11.00,     13.00,
    11.00,     13.00,     12.00,     11.00,     12.00,     11.00,     14.00,     3.00,
    14.00,     3.00,      15.00,     1.00,      15.00,     1.00,      16.00,     0.00,
    9.00,      14.00,     10.00,     13.00,     10.00,     13.00,     11.00,     11.00,
    11.00,     11.00,     13.00,     3.00,      13.00,     3.00,      14.00,     1.00,
    14.00,     1.00,      16.00,     0.00,      16.00,     0.00,      17.00,     0.00,
    -99.00,    -99.00,    -99.00,    98.00,     11.00,     21.00,     13.00,     21.00,
    13.00,     21.00,     15.00,     20.00,     15.00,     20.00,     16.00,     19.00,
    16.00,     19.00,     16.00,     16.00,     16.00,     16.00,     15.00,     14.00,
    15.00,     14.00,     14.00,     13.00,     14.00,     13.00,     11.00,     12.00,
    11.00,     12.00,     7.00,      12.00,     7.00,      12.00,     11.00,     11.00,
    11.00,     11.00,     13.00,     9.00,      13.00,     9.00,      14.00,     7.00,
    14.00,     7.00,      14.00,     4.00,      14.00,     4.00,      13.00,     2.00,
    13.00,     2.00,      12.00,     1.00,      12.00,     1.00,      9.00,      0.00,
    9.00,      0.00,      7.00,      0.00,      7.00,      0.00,      5.00,      1.00,
    5.00,      1.00,      4.00,      2.00,      4.00,      2.00,      3.00,      5.00,
    0.00,      -7.00,     1.00,      1.00,      1.00,      1.00,      2.00,      7.00,
    2.00,      7.00,      3.00,      11.00,     3.00,      11.00,     4.00,      14.00,
    4.00,      14.00,     6.00,      18.00,     6.00,      18.00,     8.00,      20.00,
    8.00,      20.00,     11.00,     21.00,     11.00,     21.00,     9.00,      20.00,
    9.00,      20.00,     7.00,      18.00,     7.00,      18.00,     5.00,      14.00,
    5.00,      14.00,     4.00,      11.00,     4.00,      11.00,     3.00,      7.00,
    3.00,      7.00,      2.00,      1.00,      2.00,      1.00,      1.00,      -7.00,
    13.00,     21.00,     15.00,     19.00,     15.00,     19.00,     15.00,     16.00,
    15.00,     16.00,     14.00,     14.00,     14.00,     14.00,     13.00,     13.00,
    13.00,     13.00,     11.00,     12.00,     7.00,      12.00,     10.00,     11.00,
    10.00,     11.00,     12.00,     9.00,      12.00,     9.00,      13.00,     7.00,
    13.00,     7.00,      13.00,     4.00,      13.00,     4.00,      12.00,     2.00,
    12.00,     2.00,      11.00,     1.00,      11.00,     1.00,      9.00,      0.00,
    -99.00,    -99.00,    -99.00,    99.00,     0.00,      10.00,     1.00,      12.00,
    1.00,      12.00,     3.00,      14.00,     3.00,      14.00,     6.00,      14.00,
    6.00,      14.00,     7.00,      13.00,     7.00,      13.00,     7.00,      11.00,
    7.00,      11.00,     6.00,      7.00,      6.00,      7.00,      4.00,      0.00,
    5.00,      14.00,     6.00,      13.00,     6.00,      13.00,     6.00,      11.00,
    6.00,      11.00,     5.00,      7.00,      5.00,      7.00,      3.00,      0.00,
    6.00,      7.00,      8.00,      11.00,     8.00,      11.00,     10.00,     13.00,
    10.00,     13.00,     12.00,     14.00,     12.00,     14.00,     14.00,     14.00,
    14.00,     14.00,     16.00,     13.00,     16.00,     13.00,     17.00,     12.00,
    17.00,     12.00,     17.00,     9.00,      17.00,     9.00,      16.00,     4.00,
    16.00,     4.00,      13.00,     -7.00,     14.00,     14.00,     16.00,     12.00,
    16.00,     12.00,     16.00,     9.00,      16.00,     9.00,      15.00,     4.00,
    15.00,     4.00,      12.00,     -7.00,     -99.00,    -99.00,    -99.00,    100.00,
    10.00,     13.00,     8.00,      14.00,     8.00,      14.00,     6.00,      14.00,
    6.00,      14.00,     3.00,      13.00,     3.00,      13.00,     1.00,      10.00,
    1.00,      10.00,     0.00,      7.00,      0.00,      7.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      4.00,      0.00,      4.00,      0.00,      6.00,      0.00,
    6.00,      0.00,      9.00,      1.00,      9.00,      1.00,      11.00,     4.00,
    11.00,     4.00,      12.00,     7.00,      12.00,     7.00,      12.00,     10.00,
    12.00,     10.00,     11.00,     12.00,     11.00,     12.00,     7.00,      17.00,
    7.00,      17.00,     6.00,      19.00,     6.00,      19.00,     6.00,      21.00,
    6.00,      21.00,     7.00,      22.00,     7.00,      22.00,     9.00,      22.00,
    9.00,      22.00,     11.00,     21.00,     11.00,     21.00,     13.00,     19.00,
    13.00,     19.00,     10.00,     21.00,     10.00,     21.00,     8.00,      21.00,
    8.00,      21.00,     7.00,      20.00,     7.00,      20.00,     7.00,      18.00,
    7.00,      18.00,     8.00,      16.00,     8.00,      16.00,     10.00,     13.00,
    10.00,     13.00,     11.00,     11.00,     11.00,     11.00,     11.00,     7.00,
    11.00,     7.00,      10.00,     4.00,      10.00,     4.00,      8.00,      1.00,
    8.00,      1.00,      6.00,      0.00,      6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      10.00,     2.00,      10.00,     1.00,      7.00,
    1.00,      7.00,      1.00,      3.00,      1.00,      3.00,      2.00,      1.00,
    -99.00,    -99.00,    -99.00,    101.00,    11.00,     3.00,      9.00,      1.00,
    9.00,      1.00,      7.00,      0.00,      7.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      1.00,      1.00,      1.00,      1.00,      0.00,      3.00,
    0.00,      3.00,      0.00,      5.00,      0.00,      5.00,      2.00,      7.00,
    2.00,      7.00,      7.00,      8.00,      7.00,      8.00,      3.00,      7.00,
    3.00,      7.00,      1.00,      5.00,      1.00,      5.00,      1.00,      3.00,
    1.00,      3.00,      2.00,      1.00,      2.00,      1.00,      4.00,      0.00,
    12.00,     11.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     4.00,      14.00,     4.00,      14.00,     2.00,      13.00,
    2.00,      13.00,     2.00,      11.00,     2.00,      11.00,     4.00,      9.00,
    4.00,      9.00,      7.00,      8.00,      7.00,      8.00,      5.00,      9.00,
    5.00,      9.00,      3.00,      11.00,     3.00,      11.00,     3.00,      13.00,
    3.00,      13.00,     4.00,      14.00,     -99.00,    -99.00,    -99.00,    102.00,
    5.00,      13.00,     3.00,      12.00,     3.00,      12.00,     1.00,      10.00,
    1.00,      10.00,     0.00,      7.00,      0.00,      7.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      4.00,      0.00,      4.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      10.00,     1.00,      10.00,     1.00,      13.00,     3.00,
    13.00,     3.00,      15.00,     6.00,      15.00,     6.00,      16.00,     9.00,
    16.00,     9.00,      16.00,     12.00,     16.00,     12.00,     14.00,     14.00,
    14.00,     14.00,     12.00,     14.00,     12.00,     14.00,     10.00,     12.00,
    10.00,     12.00,     8.00,      8.00,      8.00,      8.00,      6.00,      3.00,
    6.00,      3.00,      3.00,      -7.00,     0.00,      4.00,      2.00,      2.00,
    2.00,      2.00,      4.00,      1.00,      4.00,      1.00,      7.00,      1.00,
    7.00,      1.00,      10.00,     2.00,      10.00,     2.00,      13.00,     4.00,
    13.00,     4.00,      15.00,     6.00,      16.00,     12.00,     14.00,     13.00,
    14.00,     13.00,     12.00,     13.00,     12.00,     13.00,     10.00,     11.00,
    10.00,     11.00,     8.00,      8.00,      8.00,      8.00,      6.00,      2.00,
    6.00,      2.00,      4.00,      -7.00,     -99.00,    -99.00,    -99.00,    103.00,
    0.00,      11.00,     2.00,      13.00,     2.00,      13.00,     4.00,      14.00,
    4.00,      14.00,     6.00,      14.00,     6.00,      14.00,     8.00,      13.00,
    8.00,      13.00,     9.00,      12.00,     9.00,      12.00,     10.00,     9.00,
    10.00,     9.00,      10.00,     5.00,      10.00,     5.00,      9.00,      1.00,
    9.00,      1.00,      6.00,      -7.00,     1.00,      12.00,     3.00,      13.00,
    3.00,      13.00,     7.00,      13.00,     7.00,      13.00,     9.00,      12.00,
    17.00,     14.00,     16.00,     11.00,     16.00,     11.00,     15.00,     9.00,
    15.00,     9.00,      10.00,     2.00,      10.00,     2.00,      7.00,      -3.00,
    7.00,      -3.00,     5.00,      -7.00,     16.00,     14.00,     15.00,     11.00,
    15.00,     11.00,     14.00,     9.00,      14.00,     9.00,      10.00,     2.00,
    -99.00,    -99.00,    -99.00,    104.00,    1.00,      14.00,     3.00,      14.00,
    3.00,      14.00,     5.00,      13.00,     5.00,      13.00,     6.00,      11.00,
    6.00,      11.00,     11.00,     -4.00,     11.00,     -4.00,     12.00,     -6.00,
    12.00,     -6.00,     13.00,     -7.00,     3.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     5.00,      11.00,     5.00,      11.00,     10.00,     -4.00,
    10.00,     -4.00,     11.00,     -6.00,     11.00,     -6.00,     13.00,     -7.00,
    13.00,     -7.00,     15.00,     -7.00,     16.00,     14.00,     15.00,     12.00,
    15.00,     12.00,     13.00,     9.00,      13.00,     9.00,      3.00,      -2.00,
    3.00,      -2.00,     1.00,      -5.00,     1.00,      -5.00,     0.00,      -7.00,
    -99.00,    -99.00,    -99.00,    105.00,    3.00,      14.00,     1.00,      7.00,
    1.00,      7.00,      0.00,      3.00,      0.00,      3.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      0.00,      1.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      6.00,      2.00,      6.00,      2.00,      7.00,      4.00,
    4.00,      14.00,     2.00,      7.00,      2.00,      7.00,      1.00,      3.00,
    1.00,      3.00,      1.00,      1.00,      1.00,      1.00,      2.00,      0.00,
    -99.00,    -99.00,    -99.00,    106.00,    11.00,     13.00,     9.00,      14.00,
    9.00,      14.00,     6.00,      14.00,     6.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      5.00,      0.00,      5.00,      1.00,      2.00,
    1.00,      2.00,      2.00,      1.00,      2.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    6.00,      14.00,     4.00,      13.00,     4.00,      13.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      2.00,      2.00,      2.00,      3.00,      1.00,
    3.00,      1.00,      5.00,      0.00,      1.00,      7.00,      9.00,      7.00,
    -99.00,    -99.00,    -99.00,    107.00,    10.00,     0.00,      9.00,      1.00,
    9.00,      1.00,      7.00,      7.00,      7.00,      7.00,      5.00,      8.00,
    5.00,      8.00,      6.00,      7.00,      6.00,      7.00,      8.00,      1.00,
    8.00,      1.00,      9.00,      0.00,      9.00,      0.00,      11.00,     0.00,
    11.00,     0.00,      13.00,     1.00,      13.00,     1.00,      15.00,     4.00,
    4.00,      14.00,     0.00,      0.00,      5.00,      14.00,     1.00,      0.00,
    14.00,     14.00,     15.00,     13.00,     15.00,     13.00,     16.00,     13.00,
    16.00,     13.00,     15.00,     14.00,     15.00,     14.00,     13.00,     14.00,
    13.00,     14.00,     11.00,     13.00,     11.00,     13.00,     7.00,      9.00,
    7.00,      9.00,      5.00,      8.00,      5.00,      8.00,      3.00,      8.00,
    -99.00,    -99.00,    -99.00,    108.00,    0.00,      0.00,      8.00,      14.00,
    8.00,      14.00,     1.00,      0.00,      1.00,      21.00,     3.00,      21.00,
    3.00,      21.00,     5.00,      20.00,     5.00,      20.00,     6.00,      19.00,
    6.00,      19.00,     7.00,      17.00,     7.00,      17.00,     13.00,     3.00,
    13.00,     3.00,      14.00,     1.00,      14.00,     1.00,      15.00,     0.00,
    3.00,      21.00,     5.00,      19.00,     5.00,      19.00,     6.00,      17.00,
    6.00,      17.00,     12.00,     3.00,      12.00,     3.00,      13.00,     1.00,
    13.00,     1.00,      15.00,     0.00,      15.00,     0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    109.00,    6.00,      14.00,     0.00,      -7.00,
    7.00,      14.00,     1.00,      -7.00,     6.00,      11.00,     5.00,      5.00,
    5.00,      5.00,      5.00,      2.00,      5.00,      2.00,      7.00,      0.00,
    7.00,      0.00,      9.00,      0.00,      9.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      13.00,     3.00,      13.00,     3.00,      15.00,     6.00,
    17.00,     14.00,     14.00,     3.00,      14.00,     3.00,      14.00,     1.00,
    14.00,     1.00,      15.00,     0.00,      15.00,     0.00,      18.00,     0.00,
    18.00,     0.00,      20.00,     2.00,      20.00,     2.00,      21.00,     4.00,
    18.00,     14.00,     15.00,     3.00,      15.00,     3.00,      15.00,     1.00,
    15.00,     1.00,      16.00,     0.00,      -99.00,    -99.00,    -99.00,    110.00,
    3.00,      14.00,     1.00,      0.00,      1.00,      0.00,      2.00,      3.00,
    2.00,      3.00,      3.00,      8.00,      3.00,      8.00,      4.00,      14.00,
    4.00,      14.00,     0.00,      14.00,     14.00,     14.00,     13.00,     10.00,
    13.00,     10.00,     11.00,     6.00,      15.00,     14.00,     14.00,     11.00,
    14.00,     11.00,     13.00,     9.00,      13.00,     9.00,      11.00,     6.00,
    11.00,     6.00,      9.00,      4.00,      9.00,      4.00,      6.00,      2.00,
    6.00,      2.00,      4.00,      1.00,      4.00,      1.00,      1.00,      0.00,
    -99.00,    -99.00,    -99.00,    111.00,    6.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     10.00,     12.00,     10.00,     12.00,     7.00,
    12.00,     7.00,      11.00,     4.00,      11.00,     4.00,      9.00,      1.00,
    9.00,      1.00,      6.00,      0.00,      6.00,      0.00,      4.00,      0.00,
    4.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      7.00,
    0.00,      7.00,      1.00,      10.00,     1.00,      10.00,     3.00,      13.00,
    3.00,      13.00,     6.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      10.00,     2.00,      10.00,     1.00,      7.00,
    1.00,      7.00,      1.00,      3.00,      1.00,      3.00,      2.00,      1.00,
    6.00,      0.00,      8.00,      1.00,      8.00,      1.00,      10.00,     4.00,
    10.00,     4.00,      11.00,     7.00,      11.00,     7.00,      11.00,     11.00,
    11.00,     11.00,     10.00,     13.00,     -99.00,    -99.00,    -99.00,    112.00,
    18.00,     14.00,     5.00,      14.00,     5.00,      14.00,     2.00,      13.00,
    2.00,      13.00,     0.00,      11.00,     0.00,      11.00,     2.00,      12.00,
    2.00,      12.00,     5.00,      13.00,     5.00,      13.00,     18.00,     13.00,
    13.00,     0.00,      13.00,     13.00,     13.00,     13.00,     14.00,     0.00,
    3.00,      0.00,      7.00,      13.00,     7.00,      13.00,     4.00,      0.00,
    -99.00,    -99.00,    -99.00,    113.00,    8.00,      21.00,     10.00,     21.00,
    10.00,     21.00,     12.00,     20.00,     12.00,     20.00,     13.00,     18.00,
    13.00,     18.00,     13.00,     14.00,     13.00,     14.00,     12.00,     9.00,
    12.00,     9.00,      11.00,     6.00,      11.00,     6.00,      10.00,     4.00,
    10.00,     4.00,      8.00,      1.00,      8.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      3.00,      0.00,      3.00,      0.00,      1.00,      1.00,
    1.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      7.00,
    0.00,      7.00,      1.00,      12.00,     1.00,      12.00,     2.00,      15.00,
    2.00,      15.00,     3.00,      17.00,     3.00,      17.00,     5.00,      20.00,
    5.00,      20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      17.00,     4.00,      17.00,     3.00,      15.00,
    3.00,      15.00,     2.00,      12.00,     2.00,      12.00,     1.00,      7.00,
    1.00,      7.00,      1.00,      3.00,      1.00,      3.00,      2.00,      1.00,
    2.00,      1.00,      3.00,      0.00,      5.00,      0.00,      7.00,      1.00,
    7.00,      1.00,      9.00,      4.00,      9.00,      4.00,      10.00,     6.00,
    10.00,     6.00,      11.00,     9.00,      11.00,     9.00,      12.00,     14.00,
    12.00,     14.00,     12.00,     18.00,     12.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     10.00,     21.00,     2.00,      11.00,     11.00,     11.00,
    -99.00,    -99.00,    -99.00,    114.00,    4.00,      5.00,      5.00,      2.00,
    5.00,      2.00,      6.00,      1.00,      6.00,      1.00,      8.00,      0.00,
    8.00,      0.00,      10.00,     0.00,      10.00,     0.00,      13.00,     1.00,
    13.00,     1.00,      15.00,     4.00,      15.00,     4.00,      16.00,     7.00,
    16.00,     7.00,      16.00,     10.00,     16.00,     10.00,     15.00,     12.00,
    15.00,     12.00,     14.00,     13.00,     14.00,     13.00,     12.00,     14.00,
    12.00,     14.00,     10.00,     14.00,     10.00,     14.00,     7.00,      13.00,
    7.00,      13.00,     5.00,      10.00,     5.00,      10.00,     4.00,      7.00,
    4.00,      7.00,      0.00,      -7.00,     10.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     4.00,      14.00,     4.00,      15.00,     7.00,
    15.00,     7.00,      15.00,     11.00,     15.00,     11.00,     14.00,     13.00,
    10.00,     14.00,     8.00,      13.00,     8.00,      13.00,     6.00,      10.00,
    6.00,      10.00,     5.00,      7.00,      5.00,      7.00,      1.00,      -7.00,
    -99.00,    -99.00,    -99.00,    115.00,    6.00,      0.00,      8.00,      1.00,
    8.00,      1.00,      10.00,     4.00,      10.00,     4.00,      11.00,     7.00,
    11.00,     7.00,      11.00,     11.00,     11.00,     11.00,     10.00,     13.00,
    10.00,     13.00,     16.00,     13.00,     16.00,     14.00,     6.00,      14.00,
    6.00,      14.00,     3.00,      13.00,     3.00,      13.00,     1.00,      10.00,
    1.00,      10.00,     0.00,      7.00,      0.00,      7.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      4.00,      0.00,      4.00,      0.00,      6.00,      0.00,
    6.00,      0.00,      9.00,      1.00,      9.00,      1.00,      11.00,     4.00,
    11.00,     4.00,      12.00,     7.00,      12.00,     7.00,      12.00,     10.00,
    12.00,     10.00,     11.00,     12.00,     11.00,     12.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      10.00,     2.00,      10.00,     1.00,      7.00,
    1.00,      7.00,      1.00,      3.00,      1.00,      3.00,      2.00,      1.00,
    -99.00,    -99.00,    -99.00,    116.00,    16.00,     14.00,     5.00,      14.00,
    5.00,      14.00,     2.00,      13.00,     2.00,      13.00,     0.00,      11.00,
    0.00,      11.00,     2.00,      12.00,     2.00,      12.00,     5.00,      13.00,
    5.00,      13.00,     16.00,     13.00,     6.00,      0.00,      9.00,      13.00,
    9.00,      13.00,     7.00,      0.00,      -99.00,    -99.00,    -99.00,    117.00,
    0.00,      10.00,     1.00,      12.00,     1.00,      12.00,     3.00,      14.00,
    3.00,      14.00,     6.00,      14.00,     6.00,      14.00,     7.00,      13.00,
    7.00,      13.00,     7.00,      11.00,     7.00,      11.00,     5.00,      5.00,
    5.00,      5.00,      5.00,      2.00,      5.00,      2.00,      7.00,      0.00,
    5.00,      14.00,     6.00,      13.00,     6.00,      13.00,     6.00,      11.00,
    6.00,      11.00,     4.00,      5.00,      4.00,      5.00,      4.00,      2.00,
    4.00,      2.00,      5.00,      1.00,      5.00,      1.00,      7.00,      0.00,
    7.00,      0.00,      8.00,      0.00,      8.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      13.00,     3.00,      13.00,     3.00,      15.00,     6.00,
    15.00,     6.00,      16.00,     9.00,      16.00,     9.00,      16.00,     12.00,
    16.00,     12.00,     15.00,     14.00,     15.00,     14.00,     14.00,     13.00,
    14.00,     13.00,     15.00,     12.00,     15.00,     12.00,     16.00,     9.00,
    15.00,     6.00,      16.00,     12.00,     -99.00,    -99.00,    -99.00,    118.00,
    7.00,      14.00,     10.00,     14.00,     10.00,     14.00,     13.00,     13.00,
    13.00,     13.00,     15.00,     11.00,     15.00,     11.00,     16.00,     9.00,
    16.00,     9.00,      16.00,     6.00,      16.00,     6.00,      15.00,     3.00,
    15.00,     3.00,      13.00,     1.00,      13.00,     1.00,      9.00,      0.00,
    9.00,      0.00,      6.00,      0.00,      6.00,      0.00,      3.00,      1.00,
    3.00,      1.00,      1.00,      3.00,      1.00,      3.00,      0.00,      5.00,
    0.00,      5.00,      0.00,      8.00,      0.00,      8.00,      1.00,      11.00,
    1.00,      11.00,     3.00,      13.00,     3.00,      13.00,     7.00,      14.00,
    7.00,      14.00,     4.00,      13.00,     4.00,      13.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      0.00,      11.00,     21.00,     5.00,      -7.00,
    12.00,     21.00,     4.00,      -7.00,     9.00,      0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     3.00,      14.00,     3.00,      15.00,     6.00,
    15.00,     6.00,      15.00,     9.00,      15.00,     9.00,      14.00,     11.00,
    14.00,     11.00,     12.00,     13.00,     12.00,     13.00,     10.00,     14.00,
    -99.00,    -99.00,    -99.00,    119.00,    0.00,      4.00,      1.00,      2.00,
    1.00,      2.00,      2.00,      1.00,      2.00,      1.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      2.00,      6.00,      2.00,      8.00,      4.00,
    8.00,      4.00,      9.00,      2.00,      9.00,      2.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     1.00,      12.00,     1.00,      14.00,     2.00,
    14.00,     2.00,      16.00,     4.00,      1.00,      10.00,     3.00,      12.00,
    3.00,      12.00,     6.00,      13.00,     6.00,      13.00,     5.00,      14.00,
    5.00,      14.00,     3.00,      13.00,     3.00,      13.00,     1.00,      10.00,
    1.00,      10.00,     0.00,      7.00,      0.00,      7.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      1.00,      1.00,      1.00,      2.00,      0.00,
    2.00,      0.00,      4.00,      0.00,      4.00,      0.00,      6.00,      1.00,
    6.00,      1.00,      8.00,      4.00,      8.00,      4.00,      9.00,      7.00,
    8.00,      7.00,      8.00,      4.00,      8.00,      4.00,      9.00,      1.00,
    9.00,      1.00,      10.00,     0.00,      10.00,     0.00,      12.00,     0.00,
    12.00,     0.00,      14.00,     1.00,      14.00,     1.00,      16.00,     4.00,
    16.00,     4.00,      17.00,     7.00,      17.00,     7.00,      17.00,     10.00,
    17.00,     10.00,     16.00,     13.00,     16.00,     13.00,     15.00,     14.00,
    15.00,     14.00,     14.00,     13.00,     14.00,     13.00,     16.00,     12.00,
    16.00,     12.00,     17.00,     10.00,     -99.00,    -99.00,    -99.00,    120.00,
    10.00,     7.00,      7.00,      7.00,      7.00,      7.00,      4.00,      8.00,
    4.00,      8.00,      2.00,      10.00,     2.00,      10.00,     2.00,      12.00,
    2.00,      12.00,     3.00,      14.00,     3.00,      14.00,     5.00,      15.00,
    5.00,      15.00,     9.00,      16.00,     9.00,      16.00,     6.00,      15.00,
    6.00,      15.00,     4.00,      14.00,     4.00,      14.00,     3.00,      12.00,
    3.00,      12.00,     3.00,      10.00,     3.00,      10.00,     5.00,      8.00,
    5.00,      8.00,      7.00,      7.00,      7.00,      7.00,      3.00,      6.00,
    3.00,      6.00,      1.00,      5.00,      1.00,      5.00,      0.00,      3.00,
    0.00,      3.00,      0.00,      1.00,      0.00,      1.00,      2.00,      -1.00,
    2.00,      -1.00,     7.00,      -3.00,     7.00,      -3.00,     8.00,      -4.00,
    8.00,      -4.00,     8.00,      -6.00,     8.00,      -6.00,     6.00,      -7.00,
    6.00,      -7.00,     4.00,      -7.00,     8.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     5.00,      19.00,     5.00,      19.00,     5.00,      18.00,
    5.00,      18.00,     6.00,      17.00,     6.00,      17.00,     9.00,      16.00,
    9.00,      16.00,     12.00,     16.00,     7.00,      7.00,      4.00,      6.00,
    4.00,      6.00,      2.00,      5.00,      2.00,      5.00,      1.00,      3.00,
    1.00,      3.00,      1.00,      1.00,      1.00,      1.00,      3.00,      -1.00,
    3.00,      -1.00,     7.00,      -3.00,     -99.00,    -99.00,    -99.00,    121.00,
    14.00,     21.00,     8.00,      -7.00,     15.00,     21.00,     7.00,      -7.00,
    0.00,      10.00,     1.00,      12.00,     1.00,      12.00,     3.00,      14.00,
    3.00,      14.00,     6.00,      14.00,     6.00,      14.00,     7.00,      13.00,
    7.00,      13.00,     7.00,      11.00,     7.00,      11.00,     6.00,      6.00,
    6.00,      6.00,      6.00,      3.00,      6.00,      3.00,      8.00,      1.00,
    8.00,      1.00,      11.00,     1.00,      11.00,     1.00,      13.00,     2.00,
    13.00,     2.00,      16.00,     5.00,      16.00,     5.00,      18.00,     8.00,
    5.00,      14.00,     6.00,      13.00,     6.00,      13.00,     6.00,      11.00,
    6.00,      11.00,     5.00,      6.00,      5.00,      6.00,      5.00,      3.00,
    5.00,      3.00,      6.00,      1.00,      6.00,      1.00,      8.00,      0.00,
    8.00,      0.00,      11.00,     0.00,      11.00,     0.00,      13.00,     1.00,
    13.00,     1.00,      15.00,     3.00,      15.00,     3.00,      17.00,     6.00,
    17.00,     6.00,      18.00,     8.00,      18.00,     8.00,      20.00,     14.00,
    -99.00,    -99.00,    -99.00,    122.00,    8.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     5.00,      19.00,     5.00,      19.00,     5.00,      18.00,
    5.00,      18.00,     6.00,      17.00,     6.00,      17.00,     9.00,      16.00,
    9.00,      16.00,     14.00,     16.00,     14.00,     16.00,     14.00,     17.00,
    14.00,     17.00,     11.00,     16.00,     11.00,     16.00,     7.00,      14.00,
    7.00,      14.00,     4.00,      12.00,     4.00,      12.00,     1.00,      9.00,
    1.00,      9.00,      0.00,      6.00,      0.00,      6.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      2.00,      1.00,      2.00,      4.00,      0.00,
    4.00,      0.00,      7.00,      -2.00,     7.00,      -2.00,     8.00,      -4.00,
    8.00,      -4.00,     8.00,      -6.00,     8.00,      -6.00,     7.00,      -7.00,
    7.00,      -7.00,     5.00,      -7.00,     5.00,      -7.00,     4.00,      -6.00,
    9.00,      15.00,     5.00,      12.00,     5.00,      12.00,     2.00,      9.00,
    2.00,      9.00,      1.00,      6.00,      1.00,      6.00,      1.00,      4.00,
    1.00,      4.00,      2.00,      2.00,      2.00,      2.00,      4.00,      0.00,
    4.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,      0.00,
    -99.00,    -99.00,    -99.00,    123.00,    2.00,      23.00,     1.00,      20.00,
    1.00,      20.00,     1.00,      16.00,     1.00,      16.00,     2.00,      13.00,
    2.00,      5.00,      1.00,      2.00,      1.00,      2.00,      1.00,      -2.00,
    1.00,      -2.00,     2.00,      -5.00,     4.00,      25.00,     1.00,      22.00,
    1.00,      22.00,     0.00,      19.00,     0.00,      19.00,     0.00,      17.00,
    0.00,      17.00,     1.00,      14.00,     1.00,      14.00,     4.00,      11.00,
    4.00,      11.00,     1.00,      9.00,      1.00,      9.00,      4.00,      7.00,
    4.00,      7.00,      1.00,      4.00,      1.00,      4.00,      0.00,      1.00,
    0.00,      1.00,      0.00,      -1.00,     0.00,      -1.00,     1.00,      -4.00,
    1.00,      -4.00,     4.00,      -7.00,     -99.00,    -99.00,    -99.00,    124.00,
    3.00,      25.00,     3.00,      -7.00,     -99.00,    -99.00,    -99.00,    125.00,
    2.00,      23.00,     3.00,      20.00,     3.00,      20.00,     3.00,      16.00,
    3.00,      16.00,     2.00,      13.00,     2.00,      5.00,      3.00,      2.00,
    3.00,      2.00,      3.00,      -2.00,     3.00,      -2.00,     2.00,      -5.00,
    0.00,      25.00,     3.00,      22.00,     3.00,      22.00,     4.00,      19.00,
    4.00,      19.00,     4.00,      17.00,     4.00,      17.00,     3.00,      14.00,
    3.00,      14.00,     0.00,      11.00,     0.00,      11.00,     3.00,      9.00,
    3.00,      9.00,      0.00,      7.00,      0.00,      7.00,      3.00,      4.00,
    3.00,      4.00,      4.00,      1.00,      4.00,      1.00,      4.00,      -1.00,
    4.00,      -1.00,     3.00,      -4.00,     3.00,      -4.00,     0.00,      -7.00,
    -99.00,    -99.00,    -99.00,    126.00,    0.00,      6.00,      0.00,      8.00,
    0.00,      8.00,      1.00,      11.00,     1.00,      11.00,     3.00,      12.00,
    3.00,      12.00,     5.00,      12.00,     5.00,      12.00,     7.00,      11.00,
    7.00,      11.00,     11.00,     8.00,      11.00,     8.00,      13.00,     7.00,
    13.00,     7.00,      15.00,     7.00,      15.00,     7.00,      17.00,     8.00,
    17.00,     8.00,      18.00,     10.00,     0.00,      8.00,      1.00,      10.00,
    1.00,      10.00,     3.00,      11.00,     3.00,      11.00,     5.00,      11.00,
    5.00,      11.00,     7.00,      10.00,     7.00,      10.00,     11.00,     7.00,
    11.00,     7.00,      13.00,     6.00,      13.00,     6.00,      15.00,     6.00,
    15.00,     6.00,      17.00,     7.00,      17.00,     7.00,      18.00,     10.00,
    18.00,     10.00,     18.00,     12.00,     -99.00,    -99.00,    -99.00,    127.00,
    0.00,      12.00,     1.00,      13.00,     1.00,      13.00,     3.00,      14.00,
    3.00,      14.00,     4.50,      14.50,     4.50,      14.50,     6.00,      14.00,
    6.00,      14.00,     8.00,      13.00,     8.00,      13.00,     10.00,     11.00,
    10.00,     11.00,     12.00,     10.00,     12.00,     10.00,     13.50,     9.50,
    13.50,     9.50,      15.00,     10.00,     15.00,     10.00,     17.00,     11.00,
    17.00,     11.00,     18.00,     12.00,     0.00,      6.00,      1.00,      7.00,
    1.00,      7.00,      3.00,      8.00,      3.00,      8.00,      4.50,      8.50,
    4.50,      8.50,      6.00,      8.00,      6.00,      8.00,      8.00,      7.00,
    8.00,      7.00,      10.00,     5.00,      10.00,     5.00,      12.00,     4.00,
    12.00,     4.00,      13.50,     3.50,      13.50,     3.50,      15.00,     4.00,
    15.00,     4.00,      17.00,     5.00,      17.00,     5.00,      18.00,     6.00,
    -99.00,    -99.00,    -99.00,    999.00};

static real roman_data[] = {
    -99.00,    -99.00,    -99.00,    4.00,      0.00,      6.64,      -3.23,     6.51,
    1.81,      6.51,      0.00,      6.64,      1.81,      3.23,      1.81,      6.51,
    6.13,      3.23,      1.81,      3.23,      6.51,      0.38,      6.13,      3.23,
    6.13,      -4.66,     6.51,      0.38,      4.70,      -5.04,     6.13,      -4.66,
    5.04,      -2.14,     4.70,      -5.04,     3.95,      -2.14,     5.04,      -2.14,
    3.61,      0.38,      3.95,      -2.14,     1.81,      0.38,      3.61,      0.38,
    2.14,      -7.22,     1.81,      0.38,      -2.14,     -7.22,     2.14,      -7.22,
    -1.81,     0.38,      -2.14,     -7.22,     -3.61,     0.38,      -1.81,     0.38,
    -3.95,     -2.14,     -3.61,     0.38,      -5.04,     -2.14,     -3.95,     -2.14,
    -4.70,     -5.04,     -5.04,     -2.14,     -6.13,     -4.70,     -4.70,     -5.04,
    -6.51,     0.38,      -6.13,     -4.70,     -6.13,     3.23,      -6.51,     0.38,
    -1.81,     3.23,      -6.13,     3.23,      -1.81,     5.04,      -1.81,     3.23,
    -3.23,     5.00,      -1.81,     5.04,      -3.23,     6.51,      -3.23,     5.00,
    3.23,      -8.32,     0.00,      -8.32,     6.13,      -7.94,     3.23,      -8.32,
    7.22,      -7.60,     6.13,      -7.94,     7.60,      -7.22,     7.22,      -7.60,
    7.94,      -6.13,     7.60,      -7.22,     8.32,      -3.23,     7.94,      -6.13,
    8.32,      0.00,      8.32,      -3.23,     3.23,      8.32,      0.00,      8.32,
    6.13,      7.94,      3.23,      8.32,      7.22,      7.56,      6.13,      7.94,
    7.60,      7.22,      7.22,      7.56,      7.94,      6.13,      7.60,      7.22,
    8.32,      3.23,      7.94,      6.13,      8.32,      0.00,      8.32,      3.23,
    -3.23,     8.32,      0.00,      8.32,      -6.13,     7.94,      -3.23,     8.32,
    -7.22,     7.56,      -6.13,     7.94,      -7.60,     7.22,      -7.22,     7.56,
    -7.94,     6.13,      -7.60,     7.22,      -8.32,     3.23,      -7.94,     6.13,
    -8.32,     0.00,      -8.32,     3.23,      -3.23,     -8.32,     0.00,      -8.32,
    -6.13,     -7.94,     -3.23,     -8.32,     -7.22,     -7.60,     -6.13,     -7.94,
    -7.60,     -7.22,     -7.22,     -7.60,     -7.94,     -6.13,     -7.60,     -7.22,
    -8.32,     -3.23,     -7.94,     -6.13,     -8.32,     0.00,      -8.32,     -3.23,
    3.61,      -10.50,    0.00,      -10.50,    6.85,      -10.12,    3.61,      -10.50,
    8.32,      -9.74,     6.85,      -10.12,    9.03,      -9.41,     8.32,      -9.74,
    9.41,      -9.03,     9.03,      -9.41,     9.74,      -8.32,     9.41,      -9.03,
    10.12,     -6.85,     9.74,      -8.32,     10.50,     -3.61,     10.12,     -6.85,
    10.50,     0.00,      10.50,     -3.61,     3.61,      10.46,     0.00,      10.46,
    6.85,      10.12,     3.61,      10.46,     8.32,      9.74,      6.85,      10.12,
    9.03,      9.41,      8.32,      9.74,      9.41,      9.03,      9.03,      9.41,
    9.74,      8.32,      9.41,      9.03,      10.12,     6.85,      9.74,      8.32,
    10.50,     3.61,      10.12,     6.85,      10.50,     0.00,      10.50,     3.61,
    -3.61,     10.46,     0.00,      10.46,     -6.85,     10.12,     -3.61,     10.46,
    -8.32,     9.74,      -6.85,     10.12,     -9.03,     9.41,      -8.32,     9.74,
    -9.41,     9.03,      -9.03,     9.41,      -9.74,     8.32,      -9.41,     9.03,
    -10.12,    6.85,      -9.74,     8.32,      -10.50,    3.61,      -10.12,    6.85,
    -10.50,    0.00,      -10.50,    3.61,      -3.61,     -10.50,    0.00,      -10.50,
    -6.85,     -10.12,    -3.61,     -10.50,    -8.32,     -9.74,     -6.85,     -10.12,
    -9.03,     -9.41,     -8.32,     -9.74,     -9.41,     -9.03,     -9.03,     -9.41,
    -9.74,     -8.32,     -9.41,     -9.03,     -10.12,    -6.85,     -9.74,     -8.32,
    -10.50,    -3.61,     -10.12,    -6.85,     -10.50,    0.00,      -10.50,    -3.61,
    -99.00,    -99.00,    -99.00,    5.00,      -10.50,    -10.50,    10.50,     -10.50,
    10.50,     -10.50,    10.50,     10.50,     10.50,     10.50,     -10.50,    10.50,
    -10.50,    10.50,     -10.50,    -10.50,    -99.00,    -99.00,    -99.00,    6.00,
    0.00,      -10.50,    10.50,     0.00,      10.50,     0.00,      0.00,      10.50,
    0.00,      10.50,     -10.50,    0.00,      -10.50,    0.00,      0.00,      -10.50,
    -99.00,    -99.00,    -99.00,    7.00,      0.00,      -10.50,    0.00,      10.50,
    -10.50,    0.00,      10.50,     0.00,      -99.00,    -99.00,    -99.00,    8.00,
    -10.50,    -10.50,    10.50,     10.50,     -10.50,    10.50,     10.50,     -10.50,
    -99.00,    -99.00,    -99.00,    9.00,      -10.50,    -7.50,     0.00,      13.50,
    0.00,      13.50,     10.50,     -7.50,     10.50,     -7.50,     -10.50,    -7.50,
    -99.00,    -99.00,    -99.00,    10.00,     10.50,     0.00,      9.99,      3.24,
    9.99,      3.24,      8.49,      6.17,      8.49,      6.17,      6.17,      8.49,
    6.17,      8.49,      3.24,      9.99,      3.24,      9.99,      0.00,      10.50,
    0.00,      10.50,     -3.24,     9.99,      -3.24,     9.99,      -6.17,     8.49,
    -6.17,     8.49,      -8.49,     6.17,      -8.49,     6.17,      -9.99,     3.24,
    -9.99,     3.24,      -10.50,    0.00,      -10.50,    0.00,      -9.99,     -3.24,
    -9.99,     -3.24,     -8.49,     -6.17,     -8.49,     -6.17,     -6.17,     -8.49,
    -6.17,     -8.49,     -3.24,     -9.99,     -3.24,     -9.99,     0.00,      -10.50,
    0.00,      -10.50,    3.24,      -9.99,     3.24,      -9.99,     6.17,      -8.49,
    6.17,      -8.49,     8.49,      -6.17,     8.49,      -6.17,     9.99,      -3.24,
    9.99,      -3.24,     10.50,     0.00,      -99.00,    -99.00,    -99.00,    11.00,
    -2.00,     0.00,      2.00,      0.00,      0.00,      2.00,      0.00,      -2.00,
    1.41,      1.41,      -1.41,     -1.41,     -1.41,     1.41,      1.41,      -1.41,
    -99.00000, -99.00000, -99.00000, 12.000000, 10.50000,  17.14000,  7.270000,  17.01000,
    12.31000,  17.01000,  10.50000,  17.14000,  12.31000,  13.73000,  12.31000,  17.01000,
    16.63000,  13.73000,  12.31000,  13.73000,  17.01000,  10.88000,  16.63000,  13.73000,
    16.63000,  5.840000,  17.01000,  10.88000,  15.20000,  5.460000,  16.63000,  5.840000,
    15.54000,  8.360000,  15.20000,  5.460000,  14.45000,  8.360000,  15.54000,  8.360000,
    14.11000,  10.88000,  14.45000,  8.360000,  12.31000,  10.88000,  14.11000,  10.88000,
    12.64000,  3.280000,  12.31000,  10.88000,  8.360000,  3.280000,  12.64000,  3.280000,
    8.690001,  10.88000,  8.360000,  3.280000,  6.890000,  10.88000,  8.690001,  10.88000,
    6.550000,  8.360000,  6.890000,  10.88000,  5.460000,  8.360000,  6.550000,  8.360000,
    5.800000,  5.460000,  5.460000,  8.360000,  4.370000,  5.800000,  5.800000,  5.460000,
    3.990000,  10.88000,  4.370000,  5.800000,  4.370000,  13.73000,  3.990000,  10.88000,
    8.690001,  13.73000,  4.370000,  13.73000,  8.690001,  15.54000,  8.690001,  13.73000,
    7.270000,  15.50000,  8.690001,  15.54000,  7.270000,  17.01000,  7.270000,  15.50000,
    13.73000,  2.180000,  10.50000,  2.180000,  16.63000,  2.560000,  13.73000,  2.180000,
    17.72000,  2.900000,  16.63000,  2.560000,  18.10000,  3.280000,  17.72000,  2.900000,
    18.44000,  4.370000,  18.10000,  3.280000,  18.82000,  7.270000,  18.44000,  4.370000,
    18.82000,  10.50000,  18.82000,  7.270000,  13.73000,  18.82000,  10.50000,  18.82000,
    16.63000,  18.44000,  13.73000,  18.82000,  17.72000,  18.06000,  16.63000,  18.44000,
    18.10000,  17.72000,  17.72000,  18.06000,  18.44000,  16.63000,  18.10000,  17.72000,
    18.82000,  13.73000,  18.44000,  16.63000,  18.82000,  10.50000,  18.82000,  13.73000,
    7.270000,  18.82000,  10.50000,  18.82000,  4.370000,  18.44000,  7.270000,  18.82000,
    3.280000,  18.06000,  4.370000,  18.44000,  2.900000,  17.72000,  3.280000,  18.06000,
    2.560000,  16.63000,  2.900000,  17.72000,  2.180000,  13.73000,  2.560000,  16.63000,
    2.180000,  10.50000,  2.180000,  13.73000,  7.270000,  2.180000,  10.50000,  2.180000,
    4.370000,  2.560000,  7.270000,  2.180000,  3.280000,  2.900000,  4.370000,  2.560000,
    2.900000,  3.280000,  3.280000,  2.900000,  2.560000,  4.370000,  2.900000,  3.280000,
    2.180000,  7.270000,  2.560000,  4.370000,  2.180000,  10.50000,  2.180000,  7.270000,
    14.11000,  0.0000000, 10.50000,  0.0000000, 17.35000,  0.3800001, 14.11000,  0.0000000,
    18.82000,  0.7600002, 17.35000,  0.3800001, 19.53000,  1.090000,  18.82000,  0.7600002,
    19.91000,  1.470000,  19.53000,  1.090000,  20.24000,  2.180000,  19.91000,  1.470000,
    20.62000,  3.650000,  20.24000,  2.180000,  21.00000,  6.890000,  20.62000,  3.650000,
    21.00000,  10.50000,  21.00000,  6.890000,  14.11000,  20.96000,  10.50000,  20.96000,
    17.35000,  20.62000,  14.11000,  20.96000,  18.82000,  20.24000,  17.35000,  20.62000,
    19.53000,  19.91000,  18.82000,  20.24000,  19.91000,  19.53000,  19.53000,  19.91000,
    20.24000,  18.82000,  19.91000,  19.53000,  20.62000,  17.35000,  20.24000,  18.82000,
    21.00000,  14.11000,  20.62000,  17.35000,  21.00000,  10.50000,  21.00000,  14.11000,
    6.890000,  20.96000,  10.50000,  20.96000,  3.650000,  20.62000,  6.890000,  20.96000,
    2.180000,  20.24000,  3.650000,  20.62000,  1.470000,  19.91000,  2.180000,  20.24000,
    1.090000,  19.53000,  1.470000,  19.91000,  0.7600002, 18.82000,  1.090000,  19.53000,
    0.3800001, 17.35000,  0.7600002, 18.82000,  0.0000000, 14.11000,  0.3800001, 17.35000,
    0.0000000, 10.50000,  0.0000000, 14.11000,  6.890000,  0.0000000, 10.50000,  0.0000000,
    3.650000,  0.3800001, 6.890000,  0.0000000, 2.180000,  0.7600002, 3.650000,  0.3800001,
    1.470000,  1.090000,  2.180000,  0.7600002, 1.090000,  1.470000,  1.470000,  1.090000,
    0.7600002, 2.180000,  1.090000,  1.470000,  0.3800001, 3.650000,  0.7600002, 2.180000,
    0.0000000, 6.890000,  0.3800001, 3.650000,  0.0000000, 10.50000,  0.0000000, 6.890000,
    -99.00000, -99.00000, -99.00000, 13.000000, 0.0000000, 0.0000000, 21.00000,  0.0000000,
    21.00000,  0.0000000, 21.00000,  21.00000,  21.00000,  21.00000,  0.0000000, 21.00000,
    0.0000000, 21.00000,  0.0000000, 0.0000000, -99.00000, -99.00000, -99.00000, 14.000000,
    10.50000,  0.0000000, 21.00000,  10.50000,  21.00000,  10.50000,  10.50000,  21.00000,
    10.50000,  21.00000,  0.0000000, 10.50000,  0.0000000, 10.50000,  10.50000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 15.000000, 10.50000,  0.0000000, 10.50000,  21.00000,
    0.0000000, 10.50000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 16.000000,
    0.0000000, 0.0000000, 21.00000,  21.00000,  0.0000000, 21.00000,  21.00000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 17.000000, 0.0000000, 0.000000,  10.50000,  21.00000,
    10.50000,  21.00000,  21.00000,  0.000000,  21.00000,  0.000000,  0.0000000, 0.000000,
    -99.00000, -99.00000, -99.00000, 18.00000,  21.00000,  10.50000,  20.49000,  13.74000,
    20.49000,  13.74000,  18.99000,  16.67000,  18.99000,  16.67000,  16.67000,  18.99000,
    16.67000,  18.99000,  13.74000,  20.49000,  13.74000,  20.49000,  10.50000,  21.00000,
    10.50000,  21.00000,  7.260000,  20.49000,  7.260000,  20.49000,  4.330000,  18.99000,
    4.330000,  18.99000,  2.010000,  16.67000,  2.010000,  16.67000,  0.5100002, 13.74000,
    0.5100002, 13.74000,  0.0000000, 10.50000,  0.0000000, 10.50000,  0.5100002, 7.260000,
    0.5100002, 7.260000,  2.010000,  4.330000,  2.010000,  4.330000,  4.330000,  2.010000,
    4.330000,  2.010000,  7.260000,  0.5100002, 7.260000,  0.5100002, 10.50000,  0.0000000,
    10.50000,  0.0000000, 13.74000,  0.5100002, 13.74000,  0.5100002, 16.67000,  2.010000,
    16.67000,  2.010000,  18.99000,  4.330000,  18.99000,  4.330000,  20.49000,  7.260000,
    20.49000,  7.260000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 19.00000,
    8.500000,  10.50000,  12.50000,  10.50000,  10.50000,  12.50000,  10.50000,  8.500000,
    11.91000,  11.91000,  9.090000,  9.090000,  9.090000,  11.91000,  11.91000,  9.090000,
    -99.00,    -99.00,    -99.00,    20.00,     10.50,     21.00,     10.50,     3.00,
    1.50,      12.00,     19.50,     12.00,     1.50,      0.00,      19.50,     0.00,
    -99.00,    -99.00,    -99.00,    21.00,     16.00,     21.00,     0.00,      12.00,
    0.00,      12.00,     16.00,     3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    22.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    23.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      4.00,      -2.00,     14.00,     20.00,
    -99.00,    -99.00,    -99.00,    24.00,     3.00,      19.00,     4.00,      24.00,
    4.00,      24.00,     5.00,      25.00,     5.00,      25.00,     6.00,      24.00,
    6.00,      24.00,     3.00,      19.00,     -99.00,    -99.00,    -99.00,    25.00,
    16.00,     21.00,     0.00,      12.00,     0.00,      12.00,     16.00,     3.00,
    0.00,      0.00,      16.00,     0.00,      11.00,     24.00,     6.00,      -4.00,
    -99.00,    -99.00,    -99.00,    26.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      16.00,     0.00,      0.00,      0.00,
    9.00,      23.00,     4.00,      -4.00,     -99.00,    -99.00,    -99.00,    27.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    24.00,     18.00,     8.00,      9.00,      8.00,      9.00,      24.00,     0.00,
    -99.00,    -99.00,    -99.00,    28.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      8.00,      18.00,     24.00,     9.00,
    24.00,     9.00,      8.00,      0.00,      -99.00,    -99.00,    -99.00,    29.00,
    16.00,     2.00,      15.00,     0.00,      15.00,     0.00,      0.00,      0.00,
    4.00,      0.00,      12.00,     1.00,      12.00,     1.00,      16.00,     2.00,
    0.00,      0.00,      8.00,      10.50,     8.00,      10.50,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     16.00,     19.00,
    16.00,     19.00,     12.00,     20.00,     12.00,     20.00,     4.00,      21.00,
    2.00,      20.00,     9.00,      10.50,     9.00,      10.50,     2.00,      1.00,
    -99.00,    -99.00,    -99.00,    30.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      11.00,     23.00,     6.00,      -3.00,
    -99.00,    -99.00,    -99.00,    31.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      9.00,      23.00,     4.00,      -4.00,
    -99.00,    -99.00,    -99.00,    32.00,     10.50,     0.00,      10.50,     0.00,
    -99.00,    -99.00,    -99.00,    33.00,     1.00,      19.00,     1.00,      13.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      21.00,     0.00,      19.00,     0.00,      19.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      19.00,     2.00,      19.00,     1.00,      21.00,
    -99.00,    -99.00,    -99.00,    34.00,     1.00,      21.00,     0.00,      14.00,
    0.00,      14.00,     2.00,      21.00,     9.00,      21.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     21.00,     -99.00,    -99.00,    -99.00,    35.00,
    8.00,      21.00,     1.00,      -7.00,     14.00,     21.00,     7.00,      -7.00,
    1.00,      10.00,     15.00,     10.00,     0.00,      4.00,      14.00,     4.00,
    -99.00,    -99.00,    -99.00,    36.00,     5.00,      25.00,     5.00,      -4.00,
    9.00,      25.00,     9.00,      -4.00,     0.00,      16.00,     2.00,      14.00,
    2.00,      14.00,     4.00,      13.00,     4.00,      13.00,     10.00,     11.00,
    10.00,     11.00,     12.00,     10.00,     12.00,     10.00,     13.00,     9.00,
    13.00,     9.00,      14.00,     7.00,      14.00,     7.00,      14.00,     3.00,
    14.00,     3.00,      12.00,     1.00,      12.00,     1.00,      9.00,      0.00,
    9.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      5.00,      1.00,      5.00,      2.00,      4.00,
    2.00,      4.00,      1.00,      3.00,      13.00,     18.00,     12.00,     17.00,
    12.00,     17.00,     13.00,     16.00,     13.00,     16.00,     14.00,     17.00,
    14.00,     17.00,     14.00,     18.00,     14.00,     18.00,     12.00,     20.00,
    12.00,     20.00,     9.00,      21.00,     9.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      18.00,
    0.00,      18.00,     0.00,      16.00,     0.00,      16.00,     1.00,      14.00,
    1.00,      14.00,     2.00,      13.00,     2.00,      13.00,     4.00,      12.00,
    4.00,      12.00,     10.00,     10.00,     10.00,     10.00,     12.00,     9.00,
    12.00,     9.00,      14.00,     7.00,      -99.00,    -99.00,    -99.00,    37.00,
    14.00,     7.00,      12.00,     6.00,      12.00,     6.00,      11.00,     4.00,
    11.00,     4.00,      11.00,     2.00,      11.00,     2.00,      13.00,     0.00,
    13.00,     0.00,      15.00,     0.00,      15.00,     0.00,      17.00,     1.00,
    17.00,     1.00,      18.00,     3.00,      18.00,     3.00,      18.00,     5.00,
    18.00,     5.00,      16.00,     7.00,      16.00,     7.00,      14.00,     7.00,
    5.00,      21.00,     7.00,      19.00,     7.00,      19.00,     7.00,      17.00,
    7.00,      17.00,     6.00,      15.00,     6.00,      15.00,     4.00,      14.00,
    4.00,      14.00,     2.00,      14.00,     2.00,      14.00,     0.00,      16.00,
    0.00,      16.00,     0.00,      18.00,     0.00,      18.00,     1.00,      20.00,
    1.00,      20.00,     3.00,      21.00,     3.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     7.00,      20.00,     7.00,      20.00,     10.00,     19.00,
    10.00,     19.00,     13.00,     19.00,     13.00,     19.00,     16.00,     20.00,
    16.00,     20.00,     18.00,     21.00,     18.00,     21.00,     0.00,      0.00,
    -99.00,    -99.00,    -99.00,    38.00,     4.00,      16.00,     5.00,      14.00,
    5.00,      14.00,     13.00,     3.00,      13.00,     3.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     0.00,      4.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      3.00,      1.00,      3.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      8.00,      2.00,      8.00,      4.00,      10.00,
    18.00,     13.00,     17.00,     12.00,     17.00,     12.00,     18.00,     11.00,
    18.00,     11.00,     19.00,     12.00,     19.00,     12.00,     19.00,     13.00,
    19.00,     13.00,     18.00,     14.00,     18.00,     14.00,     17.00,     14.00,
    17.00,     14.00,     16.00,     13.00,     16.00,     13.00,     15.00,     11.00,
    15.00,     11.00,     13.00,     6.00,      13.00,     6.00,      11.00,     3.00,
    11.00,     3.00,      9.00,      1.00,      9.00,      1.00,      7.00,      0.00,
    7.00,      0.00,      4.00,      0.00,      4.00,      0.00,      1.00,      1.00,
    1.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      8.00,      1.00,      8.00,      7.00,      12.00,
    7.00,      12.00,     9.00,      14.00,     9.00,      14.00,     10.00,     16.00,
    10.00,     16.00,     10.00,     18.00,     10.00,     18.00,     9.00,      20.00,
    9.00,      20.00,     7.00,      21.00,     7.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     4.00,      18.00,     4.00,      18.00,     4.00,      16.00,
    4.00,      16.00,     5.00,      13.00,     5.00,      13.00,     7.00,      10.00,
    7.00,      10.00,     12.00,     3.00,      12.00,     3.00,      14.00,     1.00,
    14.00,     1.00,      17.00,     0.00,      17.00,     0.00,      18.00,     0.00,
    18.00,     0.00,      19.00,     1.00,      19.00,     1.00,      19.00,     2.00,
    -99.00,    -99.00,    -99.00,    39.00,     1.00,      21.00,     0.00,      14.00,
    0.00,      14.00,     2.00,      21.00,     -99.00,    -99.00,    -99.00,    40.00,
    5.00,      23.00,     3.00,      19.00,     3.00,      19.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      11.00,     1.00,      11.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      2.00,      2.00,      2.00,      3.00,      -1.00,
    3.00,      -1.00,     5.00,      -5.00,     7.00,      25.00,     5.00,      23.00,
    5.00,      23.00,     3.00,      20.00,     3.00,      20.00,     1.00,      16.00,
    1.00,      16.00,     0.00,      11.00,     0.00,      11.00,     0.00,      7.00,
    0.00,      7.00,      1.00,      2.00,      1.00,      2.00,      3.00,      -2.00,
    3.00,      -2.00,     5.00,      -5.00,     5.00,      -5.00,     7.00,      -7.00,
    -99.00,    -99.00,    -99.00,    41.00,     2.00,      23.00,     4.00,      19.00,
    4.00,      19.00,     5.00,      16.00,     5.00,      16.00,     6.00,      11.00,
    6.00,      11.00,     6.00,      7.00,      6.00,      7.00,      5.00,      2.00,
    5.00,      2.00,      4.00,      -1.00,     4.00,      -1.00,     2.00,      -5.00,
    0.00,      25.00,     2.00,      23.00,     2.00,      23.00,     4.00,      20.00,
    4.00,      20.00,     6.00,      16.00,     6.00,      16.00,     7.00,      11.00,
    7.00,      11.00,     7.00,      7.00,      7.00,      7.00,      6.00,      2.00,
    6.00,      2.00,      4.00,      -2.00,     4.00,      -2.00,     2.00,      -5.00,
    2.00,      -5.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    42.00,
    5.00,      17.00,     5.00,      5.00,      0.00,      14.00,     10.00,     8.00,
    10.00,     14.00,     0.00,      8.00,      -99.00,    -99.00,    -99.00,    43.00,
    10.50,     18.00,     10.50,     0.00,      1.50,      9.00,      19.50,     9.00,
    -99.00,    -99.00,    -99.00,    44.00,     1.00,      0.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      -1.00,     2.00,      -1.00,     1.00,      -3.00,
    1.00,      -3.00,     0.00,      -4.00,     -99.00,    -99.00,    -99.00,    45.00,
    1.50,      9.00,      19.50,     9.00,      -99.00,    -99.00,    -99.00,    46.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    -99.00,    -99.00,    -99.00,    47.00,     18.00,     25.00,     0.00,      -7.00,
    -99.000,   -99.000,   -99.000,   48.000,    11.500,    0.000,     13.500,    1.000,
    13.500,    1.000,     14.500,    2.000,     14.500,    2.000,     15.500,    4.000,
    15.500,    4.000,     16.500,    9.000,     16.500,    9.000,     16.500,    12.000,
    16.500,    12.000,    15.500,    17.000,    15.500,    17.000,    14.500,    19.000,
    14.500,    19.000,    13.500,    20.000,    13.500,    20.000,    11.500,    21.000,
    9.500,     21.000,    6.500,     20.000,    6.500,     20.000,    4.500,     17.000,
    4.500,     17.000,    3.500,     12.000,    3.500,     12.000,    3.500,     9.000,
    3.500,     9.000,     4.500,     4.000,     4.500,     4.000,     6.500,     1.000,
    6.500,     1.000,     9.500,     0.000,     9.500,     0.000,     11.500,    0.000,
    11.500,    0.000,     14.500,    1.000,     14.500,    1.000,     16.500,    4.000,
    16.500,    4.000,     17.500,    9.000,     17.500,    9.000,     17.500,    12.000,
    17.500,    12.000,    16.500,    17.000,    16.500,    17.000,    14.500,    20.000,
    14.500,    20.000,    11.500,    21.000,    11.500,    21.000,    9.500,     21.000,
    9.500,     21.000,    7.500,     20.000,    7.500,     20.000,    6.500,     19.000,
    6.500,     19.000,    5.500,     17.000,    5.500,     17.000,    4.500,     12.000,
    4.500,     12.000,    4.500,     9.000,     4.500,     9.000,     5.500,     4.000,
    5.500,     4.000,     6.500,     2.000,     6.500,     2.000,     7.500,     1.000,
    7.500,     1.000,     9.500,     0.000,     -99.000,   -99.000,   -99.000,   49.000,
    10.000,    20.000,    10.000,    0.000,     6.000,     0.000,     15.000,    0.000,
    6.000,     17.000,    8.000,     18.000,    8.000,     18.000,    11.000,    21.000,
    11.000,    21.000,    11.000,    0.000,     -99.000,   -99.000,   -99.000,   50.000,
    6.500,     3.000,     11.500,    0.000,     11.500,    0.000,     15.500,    0.000,
    15.500,    0.000,     16.500,    1.000,     16.500,    1.000,     17.500,    3.000,
    17.500,    3.000,     17.500,    5.000,     3.500,     2.000,     4.500,     3.000,
    4.500,     3.000,     6.500,     3.000,     6.500,     3.000,     11.500,    1.000,
    11.500,    1.000,     14.500,    1.000,     14.500,    1.000,     16.500,    2.000,
    16.500,    2.000,     17.500,    3.000,     12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    19.000,    15.500,    19.000,    16.500,    17.000,
    16.500,    17.000,    16.500,    15.000,    16.500,    15.000,    15.500,    13.000,
    15.500,    13.000,    12.500,    11.000,    12.500,    11.000,    8.500,     9.000,
    4.500,     17.000,    5.500,     16.000,    5.500,     16.000,    4.500,     15.000,
    4.500,     15.000,    3.500,     16.000,    3.500,     16.000,    3.500,     17.000,
    3.500,     17.000,    4.500,     19.000,    4.500,     19.000,    5.500,     20.000,
    5.500,     20.000,    8.500,     21.000,    8.500,     21.000,    12.500,    21.000,
    12.500,    21.000,    15.500,    20.000,    15.500,    20.000,    16.500,    19.000,
    16.500,    19.000,    17.500,    17.000,    17.500,    17.000,    17.500,    15.000,
    17.500,    15.000,    16.500,    13.000,    16.500,    13.000,    13.500,    11.000,
    13.500,    11.000,    8.500,     9.000,     8.500,     9.000,     6.500,     8.000,
    6.500,     8.000,     4.500,     6.000,     4.500,     6.000,     3.500,     3.000,
    3.500,     3.000,     3.500,     0.000,     -99.000,   -99.000,   -99.000,   51.000,
    4.500,     17.000,    5.500,     16.000,    5.500,     16.000,    4.500,     15.000,
    4.500,     15.000,    3.500,     16.000,    3.500,     16.000,    3.500,     17.000,
    3.500,     17.000,    4.500,     19.000,    4.500,     19.000,    5.500,     20.000,
    5.500,     20.000,    8.500,     21.000,    8.500,     21.000,    12.500,    21.000,
    12.500,    21.000,    15.500,    20.000,    15.500,    20.000,    16.500,    18.000,
    16.500,    18.000,    16.500,    15.000,    16.500,    15.000,    15.500,    13.000,
    15.500,    13.000,    12.500,    12.000,    12.500,    12.000,    9.500,     12.000,
    15.500,    10.000,    16.500,    7.000,     16.500,    7.000,     16.500,    4.000,
    16.500,    4.000,     15.500,    2.000,     15.500,    2.000,     14.500,    1.000,
    14.500,    1.000,     12.500,    0.000,     12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    18.000,    15.500,    18.000,    15.500,    15.000,
    15.500,    15.000,    14.500,    13.000,    14.500,    13.000,    12.500,    12.000,
    12.500,    12.000,    14.500,    11.000,    14.500,    11.000,    16.500,    9.000,
    16.500,    9.000,     17.500,    7.000,     17.500,    7.000,     17.500,    4.000,
    17.500,    4.000,     16.500,    2.000,     16.500,    2.000,     15.500,    1.000,
    15.500,    1.000,     12.500,    0.000,     12.500,    0.000,     8.500,     0.000,
    8.500,     0.000,     5.500,     1.000,     5.500,     1.000,     4.500,     2.000,
    4.500,     2.000,     3.500,     4.000,     3.500,     4.000,     3.500,     5.000,
    3.500,     5.000,     4.500,     6.000,     4.500,     6.000,     5.500,     5.000,
    5.500,     5.000,     4.500,     4.000,     -99.000,   -99.000,   -99.000,   52.000,
    12.500,    19.000,    12.500,    0.000,     9.500,     0.000,     16.500,    0.000,
    18.500,    6.000,     2.500,     6.000,     2.500,     6.000,     13.500,    21.000,
    13.500,    21.000,    13.500,    0.000,     -99.000,   -99.000,   -99.000,   53.000,
    5.500,     20.000,    10.500,    20.000,    10.500,    20.000,    15.500,    21.000,
    15.500,    21.000,    5.500,     21.000,    5.500,     21.000,    3.500,     11.000,
    3.500,     11.000,    5.500,     13.000,    5.500,     13.000,    8.500,     14.000,
    8.500,     14.000,    11.500,    14.000,    11.500,    14.000,    14.500,    13.000,
    14.500,    13.000,    16.500,    11.000,    16.500,    11.000,    17.500,    8.000,
    17.500,    8.000,     17.500,    6.000,     17.500,    6.000,     16.500,    3.000,
    16.500,    3.000,     14.500,    1.000,     14.500,    1.000,     11.500,    0.000,
    11.500,    0.000,     8.500,     0.000,     8.500,     0.000,     5.500,     1.000,
    5.500,     1.000,     4.500,     2.000,     4.500,     2.000,     3.500,     4.000,
    3.500,     4.000,     3.500,     5.000,     3.500,     5.000,     4.500,     6.000,
    4.500,     6.000,     5.500,     5.000,     5.500,     5.000,     4.500,     4.000,
    11.500,    0.000,     13.500,    1.000,     13.500,    1.000,     15.500,    3.000,
    15.500,    3.000,     16.500,    6.000,     16.500,    6.000,     16.500,    8.000,
    16.500,    8.000,     15.500,    11.000,    15.500,    11.000,    13.500,    13.000,
    13.500,    13.000,    11.500,    14.000,    -99.000,   -99.000,   -99.000,   54.000,
    15.500,    18.000,    14.500,    17.000,    14.500,    17.000,    15.500,    16.000,
    15.500,    16.000,    16.500,    17.000,    16.500,    17.000,    16.500,    18.000,
    16.500,    18.000,    15.500,    20.000,    15.500,    20.000,    13.500,    21.000,
    13.500,    21.000,    10.500,    21.000,    10.500,    21.000,    7.500,     20.000,
    7.500,     20.000,    5.500,     18.000,    5.500,     18.000,    4.500,     16.000,
    4.500,     16.000,    3.500,     12.000,    3.500,     12.000,    3.500,     6.000,
    3.500,     6.000,     4.500,     3.000,     4.500,     3.000,     6.500,     1.000,
    6.500,     1.000,     9.500,     0.000,     9.500,     0.000,     11.500,    0.000,
    11.500,    0.000,     14.500,    1.000,     14.500,    1.000,     16.500,    3.000,
    16.500,    3.000,     17.500,    6.000,     17.500,    6.000,     17.500,    7.000,
    17.500,    7.000,     16.500,    10.000,    16.500,    10.000,    14.500,    12.000,
    14.500,    12.000,    11.500,    13.000,    11.500,    13.000,    10.500,    13.000,
    10.500,    13.000,    7.500,     12.000,    7.500,     12.000,    5.500,     10.000,
    5.500,     10.000,    4.500,     7.000,     11.500,    0.000,     13.500,    1.000,
    13.500,    1.000,     15.500,    3.000,     15.500,    3.000,     16.500,    6.000,
    16.500,    6.000,     16.500,    7.000,     16.500,    7.000,     15.500,    10.000,
    15.500,    10.000,    13.500,    12.000,    13.500,    12.000,    11.500,    13.000,
    10.500,    21.000,    8.500,     20.000,    8.500,     20.000,    6.500,     18.000,
    6.500,     18.000,    5.500,     16.000,    5.500,     16.000,    4.500,     12.000,
    4.500,     12.000,    4.500,     6.000,     4.500,     6.000,     5.500,     3.000,
    5.500,     3.000,     7.500,     1.000,     7.500,     1.000,     9.500,     0.000,
    -99.000,   -99.000,   -99.000,   55.000,    3.500,     21.000,    3.500,     15.000,
    4.500,     19.000,    6.500,     20.000,    6.500,     20.000,    8.500,     20.000,
    8.500,     20.000,    13.500,    18.000,    16.500,    15.000,    11.500,    10.000,
    11.500,    10.000,    10.500,    8.000,     10.500,    8.000,     9.500,     5.000,
    9.500,     5.000,     9.500,     0.000,     3.500,     17.000,    4.500,     19.000,
    4.500,     19.000,    6.500,     21.000,    6.500,     21.000,    8.500,     21.000,
    8.500,     21.000,    13.500,    18.000,    13.500,    18.000,    15.500,    18.000,
    15.500,    18.000,    16.500,    19.000,    16.500,    19.000,    17.500,    21.000,
    17.500,    21.000,    17.500,    18.000,    17.500,    18.000,    16.500,    15.000,
    16.500,    15.000,    12.500,    10.000,    12.500,    10.000,    11.500,    8.000,
    11.500,    8.000,     10.500,    5.000,     10.500,    5.000,     10.500,    0.000,
    -99.000,   -99.000,   -99.000,   56.000,    12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    18.000,    15.500,    18.000,    15.500,    15.000,
    15.500,    15.000,    14.500,    13.000,    14.500,    13.000,    12.500,    12.000,
    8.500,     12.000,    6.500,     11.000,    6.500,     11.000,    5.500,     10.000,
    5.500,     10.000,    4.500,     8.000,     4.500,     8.000,     4.500,     4.000,
    4.500,     4.000,     5.500,     2.000,     5.500,     2.000,     6.500,     1.000,
    6.500,     1.000,     8.500,     0.000,     8.500,     21.000,    5.500,     20.000,
    5.500,     20.000,    4.500,     18.000,    4.500,     18.000,    4.500,     15.000,
    4.500,     15.000,    5.500,     13.000,    5.500,     13.000,    8.500,     12.000,
    8.500,     12.000,    12.500,    12.000,    12.500,    12.000,    15.500,    13.000,
    15.500,    13.000,    16.500,    15.000,    16.500,    15.000,    16.500,    18.000,
    16.500,    18.000,    15.500,    20.000,    15.500,    20.000,    12.500,    21.000,
    12.500,    21.000,    8.500,     21.000,    8.500,     21.000,    6.500,     20.000,
    6.500,     20.000,    5.500,     18.000,    5.500,     18.000,    5.500,     15.000,
    5.500,     15.000,    6.500,     13.000,    6.500,     13.000,    8.500,     12.000,
    8.500,     12.000,    5.500,     11.000,    5.500,     11.000,    4.500,     10.000,
    4.500,     10.000,    3.500,     8.000,     3.500,     8.000,     3.500,     4.000,
    3.500,     4.000,     4.500,     2.000,     4.500,     2.000,     5.500,     1.000,
    5.500,     1.000,     8.500,     0.000,     8.500,     0.000,     12.500,    0.000,
    12.500,    0.000,     15.500,    1.000,     15.500,    1.000,     16.500,    2.000,
    16.500,    2.000,     17.500,    4.000,     17.500,    4.000,     17.500,    8.000,
    17.500,    8.000,     16.500,    10.000,    16.500,    10.000,    15.500,    11.000,
    15.500,    11.000,    12.500,    12.000,    12.500,    12.000,    14.500,    11.000,
    14.500,    11.000,    15.500,    10.000,    15.500,    10.000,    16.500,    8.000,
    16.500,    8.000,     16.500,    4.000,     16.500,    4.000,     15.500,    2.000,
    15.500,    2.000,     14.500,    1.000,     14.500,    1.000,     12.500,    0.000,
    -99.000,   -99.000,   -99.000,   57.000,    9.500,     8.000,     7.500,     9.000,
    7.500,     9.000,     5.500,     11.000,    5.500,     11.000,    4.500,     14.000,
    4.500,     14.000,    4.500,     15.000,    4.500,     15.000,    5.500,     18.000,
    5.500,     18.000,    7.500,     20.000,    7.500,     20.000,    9.500,     21.000,
    11.500,    21.000,    13.500,    20.000,    13.500,    20.000,    15.500,    18.000,
    15.500,    18.000,    16.500,    15.000,    16.500,    15.000,    16.500,    9.000,
    16.500,    9.000,     15.500,    5.000,     15.500,    5.000,     14.500,    3.000,
    14.500,    3.000,     12.500,    1.000,     12.500,    1.000,     10.500,    0.000,
    16.500,    14.000,    15.500,    11.000,    15.500,    11.000,    13.500,    9.000,
    13.500,    9.000,     10.500,    8.000,     10.500,    8.000,     9.500,     8.000,
    9.500,     8.000,     6.500,     9.000,     6.500,     9.000,     4.500,     11.000,
    4.500,     11.000,    3.500,     14.000,    3.500,     14.000,    3.500,     15.000,
    3.500,     15.000,    4.500,     18.000,    4.500,     18.000,    6.500,     20.000,
    6.500,     20.000,    9.500,     21.000,    9.500,     21.000,    11.500,    21.000,
    11.500,    21.000,    14.500,    20.000,    14.500,    20.000,    16.500,    18.000,
    16.500,    18.000,    17.500,    15.000,    17.500,    15.000,    17.500,    9.000,
    17.500,    9.000,     16.500,    5.000,     16.500,    5.000,     15.500,    3.000,
    15.500,    3.000,     13.500,    1.000,     13.500,    1.000,     10.500,    0.000,
    10.500,    0.000,     7.500,     0.000,     7.500,     0.000,     5.500,     1.000,
    5.500,     1.000,     4.500,     3.000,     4.500,     3.000,     4.500,     4.000,
    4.500,     4.000,     5.500,     5.000,     5.500,     5.000,     6.500,     4.000,
    6.500,     4.000,     5.500,     3.000,     -99.00,    -99.00,    -99.00,    58.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      14.00,     0.00,      13.00,     0.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      13.00,     2.00,      13.00,     1.00,      14.00,
    -99.00,    -99.00,    -99.00,    59.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     1.00,      12.00,     1.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      14.00,     1.00,      0.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      -1.00,     2.00,      -1.00,     1.00,      -3.00,
    1.00,      -3.00,     0.00,      -4.00,     -99.00,    -99.00,    -99.00,    60.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    61.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      -99.00,    -99.00,    -99.00,    62.00,
    0.00,      18.00,     16.00,     9.00,      16.00,     9.00,      0.00,      0.00,
    -99.00,    -99.00,    -99.00,    63.00,     6.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      1.00,
    7.00,      1.00,      6.00,      2.00,      7.00,      21.00,     9.00,      20.00,
    9.00,      20.00,     10.00,     19.00,     10.00,     19.00,     11.00,     17.00,
    11.00,     17.00,     11.00,     15.00,     11.00,     15.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      11.00,     1.00,      17.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      15.00,     1.00,      15.00,     0.00,      16.00,
    0.00,      16.00,     0.00,      17.00,     0.00,      17.00,     1.00,      19.00,
    1.00,      19.00,     2.00,      20.00,     2.00,      20.00,     4.00,      21.00,
    4.00,      21.00,     7.00,      21.00,     7.00,      21.00,     10.00,     20.00,
    10.00,     20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     15.00,     12.00,     15.00,     11.00,     13.00,
    11.00,     13.00,     10.00,     12.00,     10.00,     12.00,     6.00,      10.00,
    6.00,      10.00,     6.00,      7.00,      -99.00,    -99.00,    -99.00,    64.00,
    16.00,     16.00,     15.00,     8.00,      15.00,     8.00,      15.00,     6.00,
    15.00,     6.00,      16.00,     5.00,      9.00,      16.00,     7.00,      14.00,
    7.00,      14.00,     6.00,      11.00,     6.00,      11.00,     6.00,      8.00,
    6.00,      8.00,      7.00,      6.00,      7.00,      6.00,      8.00,      5.00,
    15.00,     13.00,     14.00,     15.00,     14.00,     15.00,     12.00,     16.00,
    12.00,     16.00,     9.00,      16.00,     9.00,      16.00,     7.00,      15.00,
    7.00,      15.00,     6.00,      14.00,     6.00,      14.00,     5.00,      11.00,
    5.00,      11.00,     5.00,      8.00,      5.00,      8.00,      6.00,      6.00,
    6.00,      6.00,      8.00,      5.00,      8.00,      5.00,      11.00,     5.00,
    11.00,     5.00,      13.00,     6.00,      13.00,     6.00,      14.00,     8.00,
    15.00,     16.00,     14.00,     8.00,      14.00,     8.00,      14.00,     6.00,
    14.00,     6.00,      16.00,     5.00,      16.00,     5.00,      18.00,     5.00,
    18.00,     5.00,      20.00,     7.00,      20.00,     7.00,      21.00,     10.00,
    21.00,     10.00,     21.00,     12.00,     21.00,     12.00,     20.00,     15.00,
    20.00,     15.00,     19.00,     17.00,     19.00,     17.00,     17.00,     19.00,
    17.00,     19.00,     15.00,     20.00,     15.00,     20.00,     12.00,     21.00,
    12.00,     21.00,     9.00,      21.00,     9.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      15.00,     1.00,      15.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      9.00,      0.00,      9.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      4.00,      2.00,      4.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     0.00,      12.00,     0.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     2.00,      17.00,     2.00,      18.00,     3.00,
    -99.00,    -99.00,    -99.00,    65.00,     9.00,      18.00,     15.00,     0.00,
    0.00,      0.00,      6.00,      0.00,      12.00,     0.00,      18.00,     0.00,
    4.00,      6.00,      13.00,     6.00,      16.00,     0.00,      9.00,      21.00,
    9.00,      21.00,     2.00,      0.00,      -99.00,    -99.00,    -99.00,    66.00,
    4.00,      21.00,     4.00,      0.00,      3.00,      21.00,     3.00,      0.00,
    12.00,     11.00,     14.00,     10.00,     14.00,     10.00,     15.00,     9.00,
    15.00,     9.00,      16.00,     7.00,      16.00,     7.00,      16.00,     4.00,
    16.00,     4.00,      15.00,     2.00,      15.00,     2.00,      14.00,     1.00,
    14.00,     1.00,      12.00,     0.00,      4.00,      11.00,     12.00,     11.00,
    12.00,     11.00,     15.00,     10.00,     15.00,     10.00,     16.00,     9.00,
    16.00,     9.00,      17.00,     7.00,      17.00,     7.00,      17.00,     4.00,
    17.00,     4.00,      16.00,     2.00,      16.00,     2.00,      15.00,     1.00,
    15.00,     1.00,      12.00,     0.00,      12.00,     0.00,      0.00,      0.00,
    0.00,      21.00,     12.00,     21.00,     12.00,     21.00,     15.00,     20.00,
    15.00,     20.00,     16.00,     19.00,     16.00,     19.00,     17.00,     17.00,
    17.00,     17.00,     17.00,     15.00,     17.00,     15.00,     16.00,     13.00,
    16.00,     13.00,     15.00,     12.00,     15.00,     12.00,     12.00,     11.00,
    12.00,     11.00,     14.00,     12.00,     14.00,     12.00,     15.00,     13.00,
    15.00,     13.00,     16.00,     15.00,     16.00,     15.00,     16.00,     17.00,
    16.00,     17.00,     15.00,     19.00,     15.00,     19.00,     14.00,     20.00,
    14.00,     20.00,     12.00,     21.00,     -99.00,    -99.00,    -99.00,    67.00,
    7.00,      21.00,     5.00,      20.00,     5.00,      20.00,     3.00,      18.00,
    3.00,      18.00,     2.00,      16.00,     2.00,      16.00,     1.00,      13.00,
    1.00,      13.00,     1.00,      8.00,      1.00,      8.00,      2.00,      5.00,
    2.00,      5.00,      3.00,      3.00,      3.00,      3.00,      5.00,      1.00,
    5.00,      1.00,      7.00,      0.00,      14.00,     18.00,     15.00,     15.00,
    15.00,     15.00,     15.00,     21.00,     15.00,     21.00,     14.00,     18.00,
    14.00,     18.00,     12.00,     20.00,     12.00,     20.00,     9.00,      21.00,
    9.00,      21.00,     7.00,      21.00,     7.00,      21.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      18.00,     2.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     0.00,      13.00,     0.00,      13.00,     0.00,      8.00,
    0.00,      8.00,      1.00,      5.00,      1.00,      5.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      7.00,      0.00,
    7.00,      0.00,      9.00,      0.00,      9.00,      0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     3.00,      14.00,     3.00,      15.00,     5.00,
    -99.00,    -99.00,    -99.00,    68.00,     4.00,      21.00,     4.00,      0.00,
    3.00,      21.00,     3.00,      0.00,      0.00,      21.00,     10.00,     21.00,
    10.00,     21.00,     13.00,     20.00,     13.00,     20.00,     15.00,     18.00,
    15.00,     18.00,     16.00,     16.00,     16.00,     16.00,     17.00,     13.00,
    17.00,     13.00,     17.00,     8.00,      17.00,     8.00,      16.00,     5.00,
    16.00,     5.00,      15.00,     3.00,      15.00,     3.00,      13.00,     1.00,
    13.00,     1.00,      10.00,     0.00,      10.00,     0.00,      0.00,      0.00,
    10.00,     21.00,     12.00,     20.00,     12.00,     20.00,     14.00,     18.00,
    14.00,     18.00,     15.00,     16.00,     15.00,     16.00,     16.00,     13.00,
    16.00,     13.00,     16.00,     8.00,      16.00,     8.00,      15.00,     5.00,
    15.00,     5.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      10.00,     0.00,      -99.00,    -99.00,    -99.00,    69.00,
    4.00,      21.00,     4.00,      0.00,      10.00,     15.00,     10.00,     7.00,
    4.00,      11.00,     10.00,     11.00,     3.00,      21.00,     3.00,      0.00,
    0.00,      21.00,     16.00,     21.00,     16.00,     21.00,     16.00,     15.00,
    16.00,     15.00,     15.00,     21.00,     0.00,      0.00,      16.00,     0.00,
    16.00,     0.00,      16.00,     6.00,      16.00,     6.00,      15.00,     0.00,
    -99.00,    -99.00,    -99.00,    70.00,     4.00,      21.00,     4.00,      0.00,
    10.00,     15.00,     10.00,     7.00,      4.00,      11.00,     10.00,     11.00,
    3.00,      21.00,     3.00,      0.00,      0.00,      0.00,      7.00,      0.00,
    0.00,      21.00,     16.00,     21.00,     16.00,     21.00,     16.00,     15.00,
    16.00,     15.00,     15.00,     21.00,     -99.00,    -99.00,    -99.00,    71.00,
    14.00,     8.00,      14.00,     0.00,      15.00,     8.00,      15.00,     0.00,
    11.00,     8.00,      18.00,     8.00,      7.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     3.00,      18.00,     3.00,      18.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      13.00,     1.00,      13.00,     1.00,      8.00,
    1.00,      8.00,      2.00,      5.00,      2.00,      5.00,      3.00,      3.00,
    3.00,      3.00,      5.00,      1.00,      5.00,      1.00,      7.00,      0.00,
    14.00,     18.00,     15.00,     15.00,     15.00,     15.00,     15.00,     21.00,
    15.00,     21.00,     14.00,     18.00,     14.00,     18.00,     12.00,     20.00,
    12.00,     20.00,     9.00,      21.00,     9.00,      21.00,     7.00,      21.00,
    7.00,      21.00,     4.00,      20.00,     4.00,      20.00,     2.00,      18.00,
    2.00,      18.00,     1.00,      16.00,     1.00,      16.00,     0.00,      13.00,
    0.00,      13.00,     0.00,      8.00,      0.00,      8.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      7.00,      0.00,      7.00,      0.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     1.00,      12.00,     1.00,      14.00,     3.00,
    -99.00,    -99.00,    -99.00,    72.00,     17.00,     0.00,      17.00,     21.00,
    3.00,      21.00,     3.00,      0.00,      16.00,     21.00,     16.00,     0.00,
    4.00,      11.00,     16.00,     11.00,     0.00,      21.00,     7.00,      21.00,
    13.00,     21.00,     20.00,     21.00,     0.00,      0.00,      7.00,      0.00,
    4.00,      21.00,     4.00,      0.00,      13.00,     0.00,      20.00,     0.00,
    -99.00,    -99.00,    -99.00,    73.00,     4.00,      21.00,     4.00,      0.00,
    3.00,      21.00,     3.00,      0.00,      0.00,      21.00,     7.00,      21.00,
    0.00,      0.00,      7.00,      0.00,      -99.00,    -99.00,    -99.00,    74.00,
    4.00,      21.00,     11.00,     21.00,     7.00,      21.00,     7.00,      4.00,
    7.00,      4.00,      6.00,      1.00,      6.00,      1.00,      5.00,      0.00,
    8.00,      21.00,     8.00,      4.00,      8.00,      4.00,      7.00,      1.00,
    7.00,      1.00,      5.00,      0.00,      5.00,      0.00,      3.00,      0.00,
    3.00,      0.00,      1.00,      1.00,      1.00,      1.00,      0.00,      3.00,
    0.00,      3.00,      0.00,      5.00,      0.00,      5.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      5.00,      2.00,      5.00,      1.00,      4.00,
    -99.00,    -99.00,    -99.00,    75.00,     3.00,      21.00,     3.00,      0.00,
    13.00,     0.00,      19.00,     0.00,      17.00,     21.00,     4.00,      8.00,
    9.00,      12.00,     17.00,     0.00,      8.00,      12.00,     16.00,     0.00,
    13.00,     21.00,     19.00,     21.00,     0.00,      21.00,     7.00,      21.00,
    0.00,      0.00,      7.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    -99.00,    -99.00,    -99.00,    76.00,     0.00,      21.00,     7.00,      21.00,
    3.00,      21.00,     3.00,      0.00,      4.00,      21.00,     4.00,      0.00,
    0.00,      0.00,      15.00,     0.00,      15.00,     0.00,      15.00,     6.00,
    15.00,     6.00,      14.00,     0.00,      -99.00,    -99.00,    -99.00,    77.00,
    18.00,     21.00,     18.00,     0.00,      17.00,     21.00,     21.00,     21.00,
    0.00,      0.00,      6.00,      0.00,      14.00,     0.00,      21.00,     0.00,
    0.00,      21.00,     4.00,      21.00,     4.00,      21.00,     10.00,     3.00,
    17.00,     0.00,      17.00,     21.00,     17.00,     21.00,     10.00,     0.00,
    10.00,     0.00,      3.00,      21.00,     3.00,      21.00,     3.00,      0.00,
    -99.00,    -99.00,    -99.00,    78.00,     0.00,      0.00,      6.00,      0.00,
    13.00,     21.00,     19.00,     21.00,     3.00,      21.00,     3.00,      0.00,
    4.00,      19.00,     16.00,     0.00,      16.00,     0.00,      16.00,     21.00,
    0.00,      21.00,     4.00,      21.00,     4.00,      21.00,     16.00,     2.00,
    -99.00,    -99.00,    -99.00,    79.00,     7.00,      21.00,     4.00,      20.00,
    4.00,      20.00,     2.00,      18.00,     2.00,      18.00,     1.00,      16.00,
    1.00,      16.00,     0.00,      12.00,     0.00,      12.00,     0.00,      9.00,
    0.00,      9.00,      1.00,      5.00,      1.00,      5.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      7.00,      0.00,
    7.00,      0.00,      9.00,      0.00,      9.00,      0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     3.00,      14.00,     3.00,      15.00,     5.00,
    15.00,     5.00,      16.00,     9.00,      16.00,     9.00,      16.00,     12.00,
    16.00,     12.00,     15.00,     16.00,     15.00,     16.00,     14.00,     18.00,
    14.00,     18.00,     12.00,     20.00,     12.00,     20.00,     9.00,      21.00,
    9.00,      21.00,     7.00,      21.00,     7.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     3.00,      18.00,     3.00,      18.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      12.00,     1.00,      12.00,     1.00,      9.00,
    1.00,      9.00,      2.00,      5.00,      2.00,      5.00,      3.00,      3.00,
    3.00,      3.00,      5.00,      1.00,      5.00,      1.00,      7.00,      0.00,
    9.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     3.00,
    13.00,     3.00,      14.00,     5.00,      14.00,     5.00,      15.00,     9.00,
    15.00,     9.00,      15.00,     12.00,     15.00,     12.00,     14.00,     16.00,
    14.00,     16.00,     13.00,     18.00,     13.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     -99.00,    -99.00,    -99.00,    80.00,
    4.00,      21.00,     4.00,      0.00,      3.00,      21.00,     3.00,      0.00,
    0.00,      0.00,      7.00,      0.00,      12.00,     21.00,     14.00,     20.00,
    14.00,     20.00,     15.00,     19.00,     15.00,     19.00,     16.00,     17.00,
    16.00,     17.00,     16.00,     14.00,     16.00,     14.00,     15.00,     12.00,
    15.00,     12.00,     14.00,     11.00,     14.00,     11.00,     12.00,     10.00,
    0.00,      21.00,     12.00,     21.00,     12.00,     21.00,     15.00,     20.00,
    15.00,     20.00,     16.00,     19.00,     16.00,     19.00,     17.00,     17.00,
    17.00,     17.00,     17.00,     14.00,     17.00,     14.00,     16.00,     12.00,
    16.00,     12.00,     15.00,     11.00,     15.00,     11.00,     12.00,     10.00,
    12.00,     10.00,     4.00,      10.00,     -99.00,    -99.00,    -99.00,    81.00,
    7.00,      21.00,     4.00,      20.00,     4.00,      20.00,     2.00,      18.00,
    2.00,      18.00,     1.00,      16.00,     1.00,      16.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      9.00,      0.00,      9.00,      1.00,      5.00,
    1.00,      5.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      7.00,      0.00,      7.00,      0.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     1.00,      12.00,     1.00,      14.00,     3.00,
    14.00,     3.00,      15.00,     5.00,      15.00,     5.00,      16.00,     9.00,
    16.00,     9.00,      16.00,     12.00,     16.00,     12.00,     15.00,     16.00,
    15.00,     16.00,     14.00,     18.00,     14.00,     18.00,     12.00,     20.00,
    12.00,     20.00,     9.00,      21.00,     9.00,      21.00,     7.00,      21.00,
    7.00,      21.00,     5.00,      20.00,     5.00,      20.00,     3.00,      18.00,
    3.00,      18.00,     2.00,      16.00,     2.00,      16.00,     1.00,      12.00,
    1.00,      12.00,     1.00,      9.00,      1.00,      9.00,      2.00,      5.00,
    2.00,      5.00,      3.00,      3.00,      3.00,      3.00,      5.00,      1.00,
    5.00,      1.00,      7.00,      0.00,      11.00,     3.00,      12.00,     -1.00,
    12.00,     -1.00,     13.00,     -3.00,     13.00,     -3.00,     14.00,     -4.00,
    14.00,     -4.00,     15.00,     -4.00,     15.00,     -4.00,     16.00,     -3.00,
    9.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     3.00,
    13.00,     3.00,      14.00,     5.00,      14.00,     5.00,      15.00,     9.00,
    15.00,     9.00,      15.00,     12.00,     15.00,     12.00,     14.00,     16.00,
    14.00,     16.00,     13.00,     18.00,     13.00,     18.00,     11.00,     20.00,
    11.00,     20.00,     9.00,      21.00,     4.00,      2.00,      4.00,      3.00,
    4.00,      3.00,      5.00,      5.00,      5.00,      5.00,      7.00,      6.00,
    7.00,      6.00,      8.00,      6.00,      8.00,      6.00,      10.00,     5.00,
    10.00,     5.00,      11.00,     3.00,      11.00,     3.00,      12.00,     -4.00,
    12.00,     -4.00,     13.00,     -5.00,     13.00,     -5.00,     15.00,     -5.00,
    15.00,     -5.00,     16.00,     -3.00,     16.00,     -3.00,     16.00,     -2.00,
    -99.00,    -99.00,    -99.00,    82.00,     4.00,      21.00,     4.00,      0.00,
    3.00,      21.00,     3.00,      0.00,      0.00,      0.00,      7.00,      0.00,
    0.00,      21.00,     12.00,     21.00,     12.00,     21.00,     15.00,     20.00,
    15.00,     20.00,     16.00,     19.00,     16.00,     19.00,     17.00,     17.00,
    17.00,     17.00,     17.00,     15.00,     17.00,     15.00,     16.00,     13.00,
    16.00,     13.00,     15.00,     12.00,     15.00,     12.00,     12.00,     11.00,
    12.00,     11.00,     4.00,      11.00,     9.00,      11.00,     11.00,     10.00,
    11.00,     10.00,     12.00,     9.00,      12.00,     9.00,      15.00,     2.00,
    15.00,     2.00,      16.00,     1.00,      16.00,     1.00,      17.00,     1.00,
    17.00,     1.00,      18.00,     2.00,      11.00,     10.00,     12.00,     8.00,
    12.00,     8.00,      14.00,     1.00,      14.00,     1.00,      15.00,     0.00,
    15.00,     0.00,      17.00,     0.00,      17.00,     0.00,      18.00,     2.00,
    18.00,     2.00,      18.00,     3.00,      12.00,     11.00,     14.00,     12.00,
    14.00,     12.00,     15.00,     13.00,     15.00,     13.00,     16.00,     15.00,
    16.00,     15.00,     16.00,     17.00,     16.00,     17.00,     15.00,     19.00,
    15.00,     19.00,     14.00,     20.00,     14.00,     20.00,     12.00,     21.00,
    -99.00,    -99.00,    -99.00,    83.00,     13.00,     18.00,     14.00,     21.00,
    14.00,     21.00,     14.00,     15.00,     14.00,     15.00,     13.00,     18.00,
    13.00,     18.00,     11.00,     20.00,     11.00,     20.00,     8.00,      21.00,
    8.00,      21.00,     5.00,      21.00,     5.00,      21.00,     2.00,      20.00,
    2.00,      20.00,     0.00,      18.00,     0.00,      18.00,     0.00,      16.00,
    0.00,      16.00,     1.00,      14.00,     1.00,      14.00,     2.00,      13.00,
    2.00,      13.00,     4.00,      12.00,     4.00,      12.00,     10.00,     10.00,
    10.00,     10.00,     12.00,     9.00,      12.00,     9.00,      14.00,     7.00,
    0.00,      16.00,     2.00,      14.00,     2.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     10.00,     11.00,     10.00,     11.00,     12.00,     10.00,
    12.00,     10.00,     13.00,     9.00,      13.00,     9.00,      14.00,     7.00,
    14.00,     7.00,      14.00,     3.00,      14.00,     3.00,      12.00,     1.00,
    12.00,     1.00,      9.00,      0.00,      9.00,      0.00,      6.00,      0.00,
    6.00,      0.00,      3.00,      1.00,      3.00,      1.00,      1.00,      3.00,
    1.00,      3.00,      0.00,      6.00,      0.00,      6.00,      0.00,      0.00,
    0.00,      0.00,      1.00,      3.00,      -99.00,    -99.00,    -99.00,    84.00,
    8.00,      21.00,     8.00,      0.00,      7.00,      21.00,     7.00,      0.00,
    4.00,      0.00,      11.00,     0.00,      1.00,      21.00,     0.00,      15.00,
    0.00,      15.00,     0.00,      21.00,     0.00,      21.00,     15.00,     21.00,
    15.00,     21.00,     15.00,     15.00,     15.00,     15.00,     14.00,     21.00,
    -99.00,    -99.00,    -99.00,    85.00,     14.00,     21.00,     20.00,     21.00,
    0.00,      21.00,     7.00,      21.00,     3.00,      21.00,     3.00,      6.00,
    3.00,      6.00,      4.00,      3.00,      4.00,      3.00,      6.00,      1.00,
    6.00,      1.00,      9.00,      0.00,      9.00,      0.00,      11.00,     0.00,
    11.00,     0.00,      14.00,     1.00,      14.00,     1.00,      16.00,     3.00,
    16.00,     3.00,      17.00,     6.00,      17.00,     6.00,      17.00,     21.00,
    4.00,      21.00,     4.00,      6.00,      4.00,      6.00,      5.00,      3.00,
    5.00,      3.00,      7.00,      1.00,      7.00,      1.00,      9.00,      0.00,
    -99.00,    -99.00,    -99.00,    86.00,     3.00,      21.00,     9.00,      3.00,
    0.00,      21.00,     6.00,      21.00,     12.00,     21.00,     18.00,     21.00,
    16.00,     21.00,     9.00,      0.00,      9.00,      0.00,      2.00,      21.00,
    -99.00,    -99.00,    -99.00,    87.00,     4.00,      21.00,     7.00,      5.00,
    12.00,     21.00,     15.00,     5.00,      0.00,      21.00,     7.00,      21.00,
    16.00,     21.00,     22.00,     21.00,     3.00,      21.00,     7.00,      0.00,
    7.00,      0.00,      11.00,     21.00,     11.00,     21.00,     15.00,     0.00,
    15.00,     0.00,      19.00,     21.00,     -99.00,    -99.00,    -99.00,    88.00,
    2.00,      21.00,     15.00,     0.00,      3.00,      21.00,     16.00,     0.00,
    16.00,     21.00,     2.00,      0.00,      0.00,      21.00,     6.00,      21.00,
    0.00,      0.00,      6.00,      0.00,      12.00,     0.00,      18.00,     0.00,
    12.00,     21.00,     18.00,     21.00,     -99.00,    -99.00,    -99.00,    89.00,
    17.00,     21.00,     10.00,     10.00,     0.00,      21.00,     6.00,      21.00,
    13.00,     21.00,     19.00,     21.00,     6.00,      0.00,      13.00,     0.00,
    2.00,      21.00,     9.00,      10.00,     9.00,      10.00,     9.00,      0.00,
    3.00,      21.00,     10.00,     10.00,     10.00,     10.00,     10.00,     0.00,
    -99.00,    -99.00,    -99.00,    90.00,     13.00,     21.00,     0.00,      0.00,
    0.00,      0.00,      14.00,     0.00,      14.00,     0.00,      14.00,     6.00,
    14.00,     6.00,      13.00,     0.00,      1.00,      21.00,     0.00,      15.00,
    0.00,      15.00,     0.00,      21.00,     0.00,      21.00,     14.00,     21.00,
    14.00,     21.00,     1.00,      0.00,      -99.00,    -99.00,    -99.00,    91.00,
    1.00,      25.00,     1.00,      -7.00,     7.00,      25.00,     0.00,      25.00,
    0.00,      25.00,     0.00,      -7.00,     0.00,      -7.00,     7.00,      -7.00,
    -99.00,    -99.00,    -99.00,    92.00,     3.00,      25.00,     21.00,     -7.00,
    -99.00,    -99.00,    -99.00,    93.00,     6.00,      25.00,     6.00,      -7.00,
    0.00,      25.00,     7.00,      25.00,     7.00,      25.00,     7.00,      -7.00,
    7.00,      -7.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    94.00,
    0.00,      16.00,     8.00,      21.00,     8.00,      21.00,     16.00,     16.00,
    16.00,     16.00,     8.00,      20.00,     8.00,      20.00,     0.00,      16.00,
    -99.00,    -99.00,    -99.00,    95.00,     21.00,     0.00,      0.00,      0.00,
    -99.00,    -99.00,    -99.00,    96.00,     12.00,     21.00,     17.00,     15.00,
    17.00,     15.00,     11.00,     20.00,     11.00,     20.00,     12.00,     21.00,
    -99.00,    -99.00,    -99.00,    97.00,     11.00,     12.00,     11.00,     3.00,
    11.00,     3.00,      12.00,     1.00,      12.00,     1.00,      14.00,     0.00,
    14.00,     0.00,      15.00,     0.00,      4.00,      8.00,      2.00,      7.00,
    2.00,      7.00,      1.00,      5.00,      1.00,      5.00,      1.00,      3.00,
    1.00,      3.00,      2.00,      1.00,      2.00,      1.00,      4.00,      0.00,
    11.00,     10.00,     10.00,     9.00,      10.00,     9.00,      4.00,      8.00,
    4.00,      8.00,      1.00,      7.00,      1.00,      7.00,      0.00,      5.00,
    0.00,      5.00,      0.00,      3.00,      0.00,      3.00,      1.00,      1.00,
    1.00,      1.00,      4.00,      0.00,      4.00,      0.00,      7.00,      0.00,
    7.00,      0.00,      9.00,      1.00,      9.00,      1.00,      11.00,     3.00,
    2.00,      12.00,     2.00,      11.00,     2.00,      11.00,     1.00,      11.00,
    1.00,      11.00,     1.00,      12.00,     1.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     4.00,      14.00,     4.00,      14.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     13.00,     10.00,     13.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     10.00,     12.00,     10.00,     12.00,     3.00,
    12.00,     3.00,      13.00,     1.00,      13.00,     1.00,      14.00,     0.00,
    -99.00,    -99.00,    -99.00,    98.00,     3.00,      21.00,     3.00,      0.00,
    0.00,      21.00,     4.00,      21.00,     4.00,      21.00,     4.00,      0.00,
    10.00,     0.00,      12.00,     1.00,      12.00,     1.00,      14.00,     3.00,
    14.00,     3.00,      15.00,     6.00,      15.00,     6.00,      15.00,     8.00,
    15.00,     8.00,      14.00,     11.00,     14.00,     11.00,     12.00,     13.00,
    12.00,     13.00,     10.00,     14.00,     4.00,      11.00,     6.00,      13.00,
    6.00,      13.00,     8.00,      14.00,     8.00,      14.00,     10.00,     14.00,
    10.00,     14.00,     13.00,     13.00,     13.00,     13.00,     15.00,     11.00,
    15.00,     11.00,     16.00,     8.00,      16.00,     8.00,      16.00,     6.00,
    16.00,     6.00,      15.00,     3.00,      15.00,     3.00,      13.00,     1.00,
    13.00,     1.00,      10.00,     0.00,      10.00,     0.00,      8.00,      0.00,
    8.00,      0.00,      6.00,      1.00,      6.00,      1.00,      4.00,      3.00,
    -99.00,    -99.00,    -99.00,    99.00,     12.00,     11.00,     11.00,     10.00,
    11.00,     10.00,     12.00,     9.00,      12.00,     9.00,      13.00,     10.00,
    13.00,     10.00,     13.00,     11.00,     13.00,     11.00,     11.00,     13.00,
    11.00,     13.00,     9.00,      14.00,     9.00,      14.00,     6.00,      14.00,
    6.00,      14.00,     3.00,      13.00,     3.00,      13.00,     1.00,      11.00,
    1.00,      11.00,     0.00,      8.00,      0.00,      8.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      3.00,      1.00,      3.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      8.00,      0.00,
    8.00,      0.00,      11.00,     1.00,      11.00,     1.00,      13.00,     3.00,
    6.00,      14.00,     4.00,      13.00,     4.00,      13.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      0.00,      -99.00,    -99.00,    -99.00,    100.00,
    12.00,     21.00,     12.00,     0.00,      12.00,     0.00,      16.00,     0.00,
    9.00,      21.00,     13.00,     21.00,     13.00,     21.00,     13.00,     0.00,
    12.00,     11.00,     10.00,     13.00,     10.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     6.00,      14.00,     6.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      6.00,      0.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      12.00,     3.00,      6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      1.00,      6.00,      1.00,      6.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      6.00,      0.00,
    -99.00,    -99.00,    -99.00,    101.00,    1.00,      8.00,      13.00,     8.00,
    13.00,     8.00,      13.00,     10.00,     13.00,     10.00,     12.00,     12.00,
    12.00,     12.00,     11.00,     13.00,     11.00,     13.00,     9.00,      14.00,
    9.00,      14.00,     6.00,      14.00,     6.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      6.00,      0.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      8.00,      0.00,      8.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      13.00,     3.00,      12.00,     8.00,      12.00,     11.00,
    12.00,     11.00,     11.00,     13.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      1.00,      6.00,      1.00,      6.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      6.00,      0.00,
    -99.00,    -99.00,    -99.00,    102.00,    0.00,      0.00,      7.00,      0.00,
    0.00,      14.00,     8.00,      14.00,     6.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     4.00,      18.00,     4.00,      18.00,     4.00,      0.00,
    8.00,      20.00,     7.00,      19.00,     7.00,      19.00,     8.00,      18.00,
    8.00,      18.00,     9.00,      19.00,     9.00,      19.00,     9.00,      20.00,
    9.00,      20.00,     8.00,      21.00,     8.00,      21.00,     6.00,      21.00,
    6.00,      21.00,     4.00,      20.00,     4.00,      20.00,     3.00,      18.00,
    3.00,      18.00,     3.00,      0.00,      -99.00,    -99.00,    -99.00,    103.00,
    4.00,      13.00,     3.00,      11.00,     3.00,      11.00,     3.00,      7.00,
    3.00,      7.00,      4.00,      5.00,      10.00,     5.00,      11.00,     7.00,
    11.00,     7.00,      11.00,     11.00,     11.00,     11.00,     10.00,     13.00,
    11.00,     12.00,     12.00,     13.00,     12.00,     13.00,     14.00,     14.00,
    14.00,     14.00,     14.00,     13.00,     14.00,     13.00,     12.00,     13.00,
    3.00,      6.00,      2.00,      5.00,      2.00,      5.00,      1.00,      3.00,
    1.00,      3.00,      1.00,      2.00,      1.00,      2.00,      2.00,      0.00,
    2.00,      0.00,      5.00,      -1.00,     5.00,      -1.00,     10.00,     -1.00,
    10.00,     -1.00,     13.00,     -2.00,     13.00,     -2.00,     14.00,     -3.00,
    1.00,      2.00,      2.00,      1.00,      2.00,      1.00,      5.00,      0.00,
    5.00,      0.00,      10.00,     0.00,      10.00,     0.00,      13.00,     -1.00,
    13.00,     -1.00,     14.00,     -3.00,     14.00,     -3.00,     14.00,     -4.00,
    14.00,     -4.00,     13.00,     -6.00,     13.00,     -6.00,     10.00,     -7.00,
    10.00,     -7.00,     4.00,      -7.00,     4.00,      -7.00,     1.00,      -6.00,
    1.00,      -6.00,     0.00,      -4.00,     0.00,      -4.00,     0.00,      -3.00,
    0.00,      -3.00,     1.00,      -1.00,     1.00,      -1.00,     4.00,      0.00,
    6.00,      14.00,     4.00,      13.00,     4.00,      13.00,     3.00,      12.00,
    3.00,      12.00,     2.00,      10.00,     2.00,      10.00,     2.00,      8.00,
    2.00,      8.00,      3.00,      6.00,      3.00,      6.00,      4.00,      5.00,
    4.00,      5.00,      6.00,      4.00,      6.00,      4.00,      8.00,      4.00,
    8.00,      4.00,      10.00,     5.00,      10.00,     5.00,      11.00,     6.00,
    11.00,     6.00,      12.00,     8.00,      12.00,     8.00,      12.00,     10.00,
    12.00,     10.00,     11.00,     12.00,     11.00,     12.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      14.00,     8.00,      14.00,     6.00,      14.00,
    -99.00,    -99.00,    -99.00,    104.00,    11.00,     0.00,      18.00,     0.00,
    3.00,      21.00,     3.00,      0.00,      0.00,      0.00,      7.00,      0.00,
    0.00,      21.00,     4.00,      21.00,     4.00,      21.00,     4.00,      0.00,
    11.00,     14.00,     13.00,     13.00,     13.00,     13.00,     14.00,     11.00,
    14.00,     11.00,     14.00,     0.00,      4.00,      11.00,     6.00,      13.00,
    6.00,      13.00,     9.00,      14.00,     9.00,      14.00,     11.00,     14.00,
    11.00,     14.00,     14.00,     13.00,     14.00,     13.00,     15.00,     11.00,
    15.00,     11.00,     15.00,     0.00,      -99.00,    -99.00,    -99.00,    105.00,
    3.00,      14.00,     3.00,      0.00,      0.00,      0.00,      7.00,      0.00,
    0.00,      14.00,     4.00,      14.00,     4.00,      14.00,     4.00,      0.00,
    3.00,      21.00,     2.00,      20.00,     2.00,      20.00,     3.00,      19.00,
    3.00,      19.00,     4.00,      20.00,     4.00,      20.00,     3.00,      21.00,
    -99.00,    -99.00,    -99.00,    106.00,    5.00,      14.00,     5.00,      -4.00,
    5.00,      -4.00,     4.00,      -6.00,     4.00,      -6.00,     3.00,      -7.00,
    5.00,      21.00,     4.00,      20.00,     4.00,      20.00,     5.00,      19.00,
    5.00,      19.00,     6.00,      20.00,     6.00,      20.00,     5.00,      21.00,
    2.00,      14.00,     6.00,      14.00,     6.00,      14.00,     6.00,      -4.00,
    6.00,      -4.00,     5.00,      -6.00,     5.00,      -6.00,     3.00,      -7.00,
    3.00,      -7.00,     1.00,      -7.00,     1.00,      -7.00,     0.00,      -6.00,
    0.00,      -6.00,     0.00,      -5.00,     0.00,      -5.00,     1.00,      -4.00,
    1.00,      -4.00,     2.00,      -5.00,     2.00,      -5.00,     1.00,      -6.00,
    -99.00,    -99.00,    -99.00,    107.00,    14.00,     14.00,     4.00,      4.00,
    9.00,      8.00,      15.00,     0.00,      8.00,      8.00,      14.00,     0.00,
    11.00,     0.00,      17.00,     0.00,      3.00,      21.00,     3.00,      0.00,
    0.00,      0.00,      7.00,      0.00,      11.00,     14.00,     17.00,     14.00,
    0.00,      21.00,     4.00,      21.00,     4.00,      21.00,     4.00,      0.00,
    -99.00,    -99.00,    -99.00,    108.00,    3.00,      21.00,     3.00,      0.00,
    0.00,      0.00,      7.00,      0.00,      0.00,      21.00,     4.00,      21.00,
    4.00,      21.00,     4.00,      0.00,      -99.00,    -99.00,    -99.00,    109.00,
    3.00,      14.00,     3.00,      0.00,      0.00,      0.00,      7.00,      0.00,
    22.00,     0.00,      29.00,     0.00,      11.00,     0.00,      18.00,     0.00,
    0.00,      14.00,     4.00,      14.00,     4.00,      14.00,     4.00,      0.00,
    11.00,     14.00,     13.00,     13.00,     13.00,     13.00,     14.00,     11.00,
    14.00,     11.00,     14.00,     0.00,      22.00,     14.00,     24.00,     13.00,
    24.00,     13.00,     25.00,     11.00,     25.00,     11.00,     25.00,     0.00,
    4.00,      11.00,     6.00,      13.00,     6.00,      13.00,     9.00,      14.00,
    9.00,      14.00,     11.00,     14.00,     11.00,     14.00,     14.00,     13.00,
    14.00,     13.00,     15.00,     11.00,     15.00,     11.00,     15.00,     0.00,
    15.00,     11.00,     17.00,     13.00,     17.00,     13.00,     20.00,     14.00,
    20.00,     14.00,     22.00,     14.00,     22.00,     14.00,     25.00,     13.00,
    25.00,     13.00,     26.00,     11.00,     26.00,     11.00,     26.00,     0.00,
    -99.00,    -99.00,    -99.00,    110.00,    3.00,      14.00,     3.00,      0.00,
    11.00,     0.00,      18.00,     0.00,      0.00,      0.00,      7.00,      0.00,
    0.00,      14.00,     4.00,      14.00,     4.00,      14.00,     4.00,      0.00,
    11.00,     14.00,     13.00,     13.00,     13.00,     13.00,     14.00,     11.00,
    14.00,     11.00,     14.00,     0.00,      4.00,      11.00,     6.00,      13.00,
    6.00,      13.00,     9.00,      14.00,     9.00,      14.00,     11.00,     14.00,
    11.00,     14.00,     14.00,     13.00,     14.00,     13.00,     15.00,     11.00,
    15.00,     11.00,     15.00,     0.00,      -99.00,    -99.00,    -99.00,    111.00,
    8.00,      0.00,      10.00,     1.00,      10.00,     1.00,      12.00,     3.00,
    12.00,     3.00,      13.00,     6.00,      13.00,     6.00,      13.00,     8.00,
    13.00,     8.00,      12.00,     11.00,     12.00,     11.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      14.00,     6.00,      14.00,     3.00,      13.00,
    3.00,      13.00,     1.00,      11.00,     1.00,      11.00,     0.00,      8.00,
    0.00,      8.00,      0.00,      6.00,      0.00,      6.00,      1.00,      3.00,
    1.00,      3.00,      3.00,      1.00,      3.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      8.00,      0.00,      8.00,      0.00,      11.00,     1.00,
    11.00,     1.00,      13.00,     3.00,      13.00,     3.00,      14.00,     6.00,
    14.00,     6.00,      14.00,     8.00,      14.00,     8.00,      13.00,     11.00,
    13.00,     11.00,     11.00,     13.00,     11.00,     13.00,     8.00,      14.00,
    8.00,      14.00,     6.00,      14.00,     6.00,      14.00,     4.00,      13.00,
    4.00,      13.00,     2.00,      11.00,     2.00,      11.00,     1.00,      8.00,
    1.00,      8.00,      1.00,      6.00,      1.00,      6.00,      2.00,      3.00,
    2.00,      3.00,      4.00,      1.00,      4.00,      1.00,      6.00,      0.00,
    -99.00,    -99.00,    -99.00,    112.00,    3.00,      14.00,     3.00,      -7.00,
    0.00,      -7.00,     7.00,      -7.00,     0.00,      14.00,     4.00,      14.00,
    4.00,      14.00,     4.00,      -7.00,     10.00,     0.00,      12.00,     1.00,
    12.00,     1.00,      14.00,     3.00,      14.00,     3.00,      15.00,     6.00,
    15.00,     6.00,      15.00,     8.00,      15.00,     8.00,      14.00,     11.00,
    14.00,     11.00,     12.00,     13.00,     12.00,     13.00,     10.00,     14.00,
    4.00,      11.00,     6.00,      13.00,     6.00,      13.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     14.00,     10.00,     14.00,     13.00,     13.00,
    13.00,     13.00,     15.00,     11.00,     15.00,     11.00,     16.00,     8.00,
    16.00,     8.00,      16.00,     6.00,      16.00,     6.00,      15.00,     3.00,
    15.00,     3.00,      13.00,     1.00,      13.00,     1.00,      10.00,     0.00,
    10.00,     0.00,      8.00,      0.00,      8.00,      0.00,      6.00,      1.00,
    6.00,      1.00,      4.00,      3.00,      -99.00,    -99.00,    -99.00,    113.00,
    12.00,     14.00,     12.00,     -7.00,     13.00,     14.00,     13.00,     -7.00,
    9.00,      -7.00,     16.00,     -7.00,     12.00,     11.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      14.00,     8.00,      14.00,     6.00,      14.00,
    6.00,      14.00,     3.00,      13.00,     3.00,      13.00,     1.00,      11.00,
    1.00,      11.00,     0.00,      8.00,      0.00,      8.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      3.00,      1.00,      3.00,      3.00,      1.00,
    3.00,      1.00,      6.00,      0.00,      6.00,      0.00,      8.00,      0.00,
    8.00,      0.00,      10.00,     1.00,      10.00,     1.00,      12.00,     3.00,
    6.00,      14.00,     4.00,      13.00,     4.00,      13.00,     2.00,      11.00,
    2.00,      11.00,     1.00,      8.00,      1.00,      8.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      3.00,      2.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      6.00,      0.00,      -99.00,    -99.00,    -99.00,    114.00,
    0.00,      0.00,      7.00,      0.00,      3.00,      14.00,     3.00,      0.00,
    0.00,      14.00,     4.00,      14.00,     4.00,      14.00,     4.00,      0.00,
    4.00,      8.00,      5.00,      11.00,     5.00,      11.00,     7.00,      13.00,
    7.00,      13.00,     9.00,      14.00,     9.00,      14.00,     12.00,     14.00,
    12.00,     14.00,     13.00,     13.00,     13.00,     13.00,     13.00,     12.00,
    13.00,     12.00,     12.00,     11.00,     12.00,     11.00,     11.00,     12.00,
    11.00,     12.00,     12.00,     13.00,     -99.00,    -99.00,    -99.00,    115.00,
    10.00,     12.00,     11.00,     14.00,     11.00,     14.00,     11.00,     10.00,
    11.00,     10.00,     10.00,     12.00,     10.00,     12.00,     9.00,      13.00,
    9.00,      13.00,     7.00,      14.00,     7.00,      14.00,     3.00,      14.00,
    3.00,      14.00,     1.00,      13.00,     1.00,      13.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      10.00,     0.00,      10.00,     1.00,      9.00,
    1.00,      9.00,      3.00,      8.00,      3.00,      8.00,      8.00,      6.00,
    8.00,      6.00,      10.00,     5.00,      10.00,     5.00,      11.00,     4.00,
    0.00,      11.00,     1.00,      10.00,     1.00,      10.00,     3.00,      9.00,
    3.00,      9.00,      8.00,      7.00,      8.00,      7.00,      10.00,     6.00,
    10.00,     6.00,      11.00,     5.00,      11.00,     5.00,      11.00,     2.00,
    11.00,     2.00,      10.00,     1.00,      10.00,     1.00,      8.00,      0.00,
    8.00,      0.00,      4.00,      0.00,      4.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      2.00,      1.00,      2.00,      0.00,      4.00,
    0.00,      4.00,      0.00,      0.00,      0.00,      0.00,      1.00,      2.00,
    -99.00,    -99.00,    -99.00,    116.00,    0.00,      14.00,     8.00,      14.00,
    4.00,      21.00,     4.00,      4.00,      4.00,      4.00,      5.00,      1.00,
    5.00,      1.00,      6.00,      0.00,      3.00,      21.00,     3.00,      4.00,
    3.00,      4.00,      4.00,      1.00,      4.00,      1.00,      6.00,      0.00,
    6.00,      0.00,      8.00,      0.00,      8.00,      0.00,      10.00,     1.00,
    10.00,     1.00,      11.00,     3.00,      -99.00,    -99.00,    -99.00,    117.00,
    14.00,     14.00,     14.00,     0.00,      14.00,     0.00,      18.00,     0.00,
    11.00,     14.00,     15.00,     14.00,     15.00,     14.00,     15.00,     0.00,
    0.00,      14.00,     4.00,      14.00,     4.00,      14.00,     4.00,      3.00,
    4.00,      3.00,      5.00,      1.00,      5.00,      1.00,      7.00,      0.00,
    3.00,      14.00,     3.00,      3.00,      3.00,      3.00,      4.00,      1.00,
    4.00,      1.00,      7.00,      0.00,      7.00,      0.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     1.00,      12.00,     1.00,      14.00,     3.00,
    -99.00,    -99.00,    -99.00,    118.00,    3.00,      14.00,     8.00,      2.00,
    0.00,      14.00,     6.00,      14.00,     10.00,     14.00,     16.00,     14.00,
    14.00,     14.00,     8.00,      0.00,      8.00,      0.00,      2.00,      14.00,
    -99.00,    -99.00,    -99.00,    119.00,    4.00,      14.00,     7.00,      3.00,
    12.00,     14.00,     15.00,     3.00,      16.00,     14.00,     22.00,     14.00,
    0.00,      14.00,     7.00,      14.00,     3.00,      14.00,     7.00,      0.00,
    7.00,      0.00,      11.00,     14.00,     11.00,     14.00,     15.00,     0.00,
    15.00,     0.00,      19.00,     14.00,     -99.00,    -99.00,    -99.00,    120.00,
    10.00,     0.00,      16.00,     0.00,      2.00,      14.00,     13.00,     0.00,
    3.00,      14.00,     14.00,     0.00,      14.00,     14.00,     2.00,      0.00,
    0.00,      0.00,      6.00,      0.00,      0.00,      14.00,     6.00,      14.00,
    10.00,     14.00,     16.00,     14.00,     -99.00,    -99.00,    -99.00,    121.00,
    8.00,      0.00,      2.00,      14.00,     3.00,      14.00,     8.00,      2.00,
    0.00,      14.00,     6.00,      14.00,     10.00,     14.00,     16.00,     14.00,
    14.00,     14.00,     8.00,      0.00,      8.00,      0.00,      6.00,      -4.00,
    6.00,      -4.00,     4.00,      -6.00,     4.00,      -6.00,     2.00,      -7.00,
    2.00,      -7.00,     1.00,      -7.00,     1.00,      -7.00,     0.00,      -6.00,
    0.00,      -6.00,     1.00,      -5.00,     1.00,      -5.00,     2.00,      -6.00,
    -99.00,    -99.00,    -99.00,    122.00,    11.00,     14.00,     0.00,      0.00,
    0.00,      0.00,      12.00,     0.00,      12.00,     0.00,      12.00,     4.00,
    12.00,     4.00,      11.00,     0.00,      1.00,      14.00,     0.00,      10.00,
    0.00,      10.00,     0.00,      14.00,     0.00,      14.00,     12.00,     14.00,
    12.00,     14.00,     1.00,      0.00,      -99.00,    -99.00,    -99.00,    123.00,
    2.00,      23.00,     1.00,      20.00,     1.00,      20.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      13.00,     2.00,      5.00,      1.00,      2.00,
    1.00,      2.00,      1.00,      -2.00,     1.00,      -2.00,     2.00,      -5.00,
    4.00,      25.00,     1.00,      22.00,     1.00,      22.00,     0.00,      19.00,
    0.00,      19.00,     0.00,      17.00,     0.00,      17.00,     1.00,      14.00,
    1.00,      14.00,     4.00,      11.00,     4.00,      11.00,     1.00,      9.00,
    1.00,      9.00,      4.00,      7.00,      4.00,      7.00,      1.00,      4.00,
    1.00,      4.00,      0.00,      1.00,      0.00,      1.00,      0.00,      -1.00,
    0.00,      -1.00,     1.00,      -4.00,     1.00,      -4.00,     4.00,      -7.00,
    -99.00,    -99.00,    -99.00,    124.00,    3.00,      25.00,     3.00,      -7.00,
    -99.00,    -99.00,    -99.00,    125.00,    2.00,      23.00,     3.00,      20.00,
    3.00,      20.00,     3.00,      16.00,     3.00,      16.00,     2.00,      13.00,
    2.00,      5.00,      3.00,      2.00,      3.00,      2.00,      3.00,      -2.00,
    3.00,      -2.00,     2.00,      -5.00,     0.00,      25.00,     3.00,      22.00,
    3.00,      22.00,     4.00,      19.00,     4.00,      19.00,     4.00,      17.00,
    4.00,      17.00,     3.00,      14.00,     3.00,      14.00,     0.00,      11.00,
    0.00,      11.00,     3.00,      9.00,      3.00,      9.00,      0.00,      7.00,
    0.00,      7.00,      3.00,      4.00,      3.00,      4.00,      4.00,      1.00,
    4.00,      1.00,      4.00,      -1.00,     4.00,      -1.00,     3.00,      -4.00,
    3.00,      -4.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    126.00,
    0.00,      6.00,      0.00,      8.00,      0.00,      8.00,      1.00,      11.00,
    1.00,      11.00,     3.00,      12.00,     3.00,      12.00,     5.00,      12.00,
    5.00,      12.00,     7.00,      11.00,     7.00,      11.00,     11.00,     8.00,
    11.00,     8.00,      13.00,     7.00,      13.00,     7.00,      15.00,     7.00,
    15.00,     7.00,      17.00,     8.00,      17.00,     8.00,      18.00,     10.00,
    0.00,      8.00,      1.00,      10.00,     1.00,      10.00,     3.00,      11.00,
    3.00,      11.00,     5.00,      11.00,     5.00,      11.00,     7.00,      10.00,
    7.00,      10.00,     11.00,     7.00,      11.00,     7.00,      13.00,     6.00,
    13.00,     6.00,      15.00,     6.00,      15.00,     6.00,      17.00,     7.00,
    17.00,     7.00,      18.00,     10.00,     18.00,     10.00,     18.00,     12.00,
    -99.00,    -99.00,    -99.00,    127.00,    0.00,      12.00,     1.00,      13.00,
    1.00,      13.00,     3.00,      14.00,     3.00,      14.00,     4.50,      14.50,
    4.50,      14.50,     6.00,      14.00,     6.00,      14.00,     8.00,      13.00,
    8.00,      13.00,     10.00,     11.00,     10.00,     11.00,     12.00,     10.00,
    12.00,     10.00,     13.50,     9.50,      13.50,     9.50,      15.00,     10.00,
    15.00,     10.00,     17.00,     11.00,     17.00,     11.00,     18.00,     12.00,
    0.00,      6.00,      1.00,      7.00,      1.00,      7.00,      3.00,      8.00,
    3.00,      8.00,      4.50,      8.50,      4.50,      8.50,      6.00,      8.00,
    6.00,      8.00,      8.00,      7.00,      8.00,      7.00,      10.00,     5.00,
    10.00,     5.00,      12.00,     4.00,      12.00,     4.00,      13.50,     3.50,
    13.50,     3.50,      15.00,     4.00,      15.00,     4.00,      17.00,     5.00,
    17.00,     5.00,      18.00,     6.00,      -99.00,    -99.00,    -99.00,    999.00,
    -99.00,    -99.00,    -99.00,    4.00,      0.00,      6.64,      -3.23,     6.51,
    1.81,      6.51,      0.00,      6.64,      1.81,      3.23,      1.81,      6.51,
    6.13,      3.23,      1.81,      3.23,      6.51,      0.38,      6.13,      3.23,
    6.13,      -4.66,     6.51,      0.38,      4.70,      -5.04,     6.13,      -4.66,
    5.04,      -2.14,     4.70,      -5.04,     3.95,      -2.14,     5.04,      -2.14,
    3.61,      0.38,      3.95,      -2.14,     1.81,      0.38,      3.61,      0.38,
    2.14,      -7.22,     1.81,      0.38,      -2.14,     -7.22,     2.14,      -7.22,
    -1.81,     0.38,      -2.14,     -7.22,     -3.61,     0.38,      -1.81,     0.38,
    -3.95,     -2.14,     -3.61,     0.38,      -5.04,     -2.14,     -3.95,     -2.14,
    -4.70,     -5.04,     -5.04,     -2.14,     -6.13,     -4.70,     -4.70,     -5.04,
    -6.51,     0.38,      -6.13,     -4.70,     -6.13,     3.23,      -6.51,     0.38,
    -1.81,     3.23,      -6.13,     3.23,      -1.81,     5.04,      -1.81,     3.23,
    -3.23,     5.00,      -1.81,     5.04,      -3.23,     6.51,      -3.23,     5.00,
    3.23,      -8.32,     0.00,      -8.32,     6.13,      -7.94,     3.23,      -8.32,
    7.22,      -7.60,     6.13,      -7.94,     7.60,      -7.22,     7.22,      -7.60,
    7.94,      -6.13,     7.60,      -7.22,     8.32,      -3.23,     7.94,      -6.13,
    8.32,      0.00,      8.32,      -3.23,     3.23,      8.32,      0.00,      8.32,
    6.13,      7.94,      3.23,      8.32,      7.22,      7.56,      6.13,      7.94,
    7.60,      7.22,      7.22,      7.56,      7.94,      6.13,      7.60,      7.22,
    8.32,      3.23,      7.94,      6.13,      8.32,      0.00,      8.32,      3.23,
    -3.23,     8.32,      0.00,      8.32,      -6.13,     7.94,      -3.23,     8.32,
    -7.22,     7.56,      -6.13,     7.94,      -7.60,     7.22,      -7.22,     7.56,
    -7.94,     6.13,      -7.60,     7.22,      -8.32,     3.23,      -7.94,     6.13,
    -8.32,     0.00,      -8.32,     3.23,      -3.23,     -8.32,     0.00,      -8.32,
    -6.13,     -7.94,     -3.23,     -8.32,     -7.22,     -7.60,     -6.13,     -7.94,
    -7.60,     -7.22,     -7.22,     -7.60,     -7.94,     -6.13,     -7.60,     -7.22,
    -8.32,     -3.23,     -7.94,     -6.13,     -8.32,     0.00,      -8.32,     -3.23,
    3.61,      -10.50,    0.00,      -10.50,    6.85,      -10.12,    3.61,      -10.50,
    8.32,      -9.74,     6.85,      -10.12,    9.03,      -9.41,     8.32,      -9.74,
    9.41,      -9.03,     9.03,      -9.41,     9.74,      -8.32,     9.41,      -9.03,
    10.12,     -6.85,     9.74,      -8.32,     10.50,     -3.61,     10.12,     -6.85,
    10.50,     0.00,      10.50,     -3.61,     3.61,      10.46,     0.00,      10.46,
    6.85,      10.12,     3.61,      10.46,     8.32,      9.74,      6.85,      10.12,
    9.03,      9.41,      8.32,      9.74,      9.41,      9.03,      9.03,      9.41,
    9.74,      8.32,      9.41,      9.03,      10.12,     6.85,      9.74,      8.32,
    10.50,     3.61,      10.12,     6.85,      10.50,     0.00,      10.50,     3.61,
    -3.61,     10.46,     0.00,      10.46,     -6.85,     10.12,     -3.61,     10.46,
    -8.32,     9.74,      -6.85,     10.12,     -9.03,     9.41,      -8.32,     9.74,
    -9.41,     9.03,      -9.03,     9.41,      -9.74,     8.32,      -9.41,     9.03,
    -10.12,    6.85,      -9.74,     8.32,      -10.50,    3.61,      -10.12,    6.85,
    -10.50,    0.00,      -10.50,    3.61,      -3.61,     -10.50,    0.00,      -10.50,
    -6.85,     -10.12,    -3.61,     -10.50,    -8.32,     -9.74,     -6.85,     -10.12,
    -9.03,     -9.41,     -8.32,     -9.74,     -9.41,     -9.03,     -9.03,     -9.41,
    -9.74,     -8.32,     -9.41,     -9.03,     -10.12,    -6.85,     -9.74,     -8.32,
    -10.50,    -3.61,     -10.12,    -6.85,     -10.50,    0.00,      -10.50,    -3.61,
    -99.00,    -99.00,    -99.00,    5.00,      -10.50,    -10.50,    10.50,     -10.50,
    10.50,     -10.50,    10.50,     10.50,     10.50,     10.50,     -10.50,    10.50,
    -10.50,    10.50,     -10.50,    -10.50,    -99.00,    -99.00,    -99.00,    6.00,
    0.00,      -10.50,    10.50,     0.00,      10.50,     0.00,      0.00,      10.50,
    0.00,      10.50,     -10.50,    0.00,      -10.50,    0.00,      0.00,      -10.50,
    -99.00,    -99.00,    -99.00,    7.00,      0.00,      -10.50,    0.00,      10.50,
    -10.50,    0.00,      10.50,     0.00,      -99.00,    -99.00,    -99.00,    8.00,
    -10.50,    -10.50,    10.50,     10.50,     -10.50,    10.50,     10.50,     -10.50,
    -99.00,    -99.00,    -99.00,    9.00,      -10.50,    -7.50,     0.00,      13.50,
    0.00,      13.50,     10.50,     -7.50,     10.50,     -7.50,     -10.50,    -7.50,
    -99.00,    -99.00,    -99.00,    10.00,     10.50,     0.00,      9.99,      3.24,
    9.99,      3.24,      8.49,      6.17,      8.49,      6.17,      6.17,      8.49,
    6.17,      8.49,      3.24,      9.99,      3.24,      9.99,      0.00,      10.50,
    0.00,      10.50,     -3.24,     9.99,      -3.24,     9.99,      -6.17,     8.49,
    -6.17,     8.49,      -8.49,     6.17,      -8.49,     6.17,      -9.99,     3.24,
    -9.99,     3.24,      -10.50,    0.00,      -10.50,    0.00,      -9.99,     -3.24,
    -9.99,     -3.24,     -8.49,     -6.17,     -8.49,     -6.17,     -6.17,     -8.49,
    -6.17,     -8.49,     -3.24,     -9.99,     -3.24,     -9.99,     0.00,      -10.50,
    0.00,      -10.50,    3.24,      -9.99,     3.24,      -9.99,     6.17,      -8.49,
    6.17,      -8.49,     8.49,      -6.17,     8.49,      -6.17,     9.99,      -3.24,
    9.99,      -3.24,     10.50,     0.00,      -99.00,    -99.00,    -99.00,    11.00,
    -2.00,     0.00,      2.00,      0.00,      0.00,      2.00,      0.00,      -2.00,
    1.41,      1.41,      -1.41,     -1.41,     -1.41,     1.41,      1.41,      -1.41,
    -99.00000, -99.00000, -99.00000, 12.000000, 10.50000,  17.14000,  7.270000,  17.01000,
    12.31000,  17.01000,  10.50000,  17.14000,  12.31000,  13.73000,  12.31000,  17.01000,
    16.63000,  13.73000,  12.31000,  13.73000,  17.01000,  10.88000,  16.63000,  13.73000,
    16.63000,  5.840000,  17.01000,  10.88000,  15.20000,  5.460000,  16.63000,  5.840000,
    15.54000,  8.360000,  15.20000,  5.460000,  14.45000,  8.360000,  15.54000,  8.360000,
    14.11000,  10.88000,  14.45000,  8.360000,  12.31000,  10.88000,  14.11000,  10.88000,
    12.64000,  3.280000,  12.31000,  10.88000,  8.360000,  3.280000,  12.64000,  3.280000,
    8.690001,  10.88000,  8.360000,  3.280000,  6.890000,  10.88000,  8.690001,  10.88000,
    6.550000,  8.360000,  6.890000,  10.88000,  5.460000,  8.360000,  6.550000,  8.360000,
    5.800000,  5.460000,  5.460000,  8.360000,  4.370000,  5.800000,  5.800000,  5.460000,
    3.990000,  10.88000,  4.370000,  5.800000,  4.370000,  13.73000,  3.990000,  10.88000,
    8.690001,  13.73000,  4.370000,  13.73000,  8.690001,  15.54000,  8.690001,  13.73000,
    7.270000,  15.50000,  8.690001,  15.54000,  7.270000,  17.01000,  7.270000,  15.50000,
    13.73000,  2.180000,  10.50000,  2.180000,  16.63000,  2.560000,  13.73000,  2.180000,
    17.72000,  2.900000,  16.63000,  2.560000,  18.10000,  3.280000,  17.72000,  2.900000,
    18.44000,  4.370000,  18.10000,  3.280000,  18.82000,  7.270000,  18.44000,  4.370000,
    18.82000,  10.50000,  18.82000,  7.270000,  13.73000,  18.82000,  10.50000,  18.82000,
    16.63000,  18.44000,  13.73000,  18.82000,  17.72000,  18.06000,  16.63000,  18.44000,
    18.10000,  17.72000,  17.72000,  18.06000,  18.44000,  16.63000,  18.10000,  17.72000,
    18.82000,  13.73000,  18.44000,  16.63000,  18.82000,  10.50000,  18.82000,  13.73000,
    7.270000,  18.82000,  10.50000,  18.82000,  4.370000,  18.44000,  7.270000,  18.82000,
    3.280000,  18.06000,  4.370000,  18.44000,  2.900000,  17.72000,  3.280000,  18.06000,
    2.560000,  16.63000,  2.900000,  17.72000,  2.180000,  13.73000,  2.560000,  16.63000,
    2.180000,  10.50000,  2.180000,  13.73000,  7.270000,  2.180000,  10.50000,  2.180000,
    4.370000,  2.560000,  7.270000,  2.180000,  3.280000,  2.900000,  4.370000,  2.560000,
    2.900000,  3.280000,  3.280000,  2.900000,  2.560000,  4.370000,  2.900000,  3.280000,
    2.180000,  7.270000,  2.560000,  4.370000,  2.180000,  10.50000,  2.180000,  7.270000,
    14.11000,  0.0000000, 10.50000,  0.0000000, 17.35000,  0.3800001, 14.11000,  0.0000000,
    18.82000,  0.7600002, 17.35000,  0.3800001, 19.53000,  1.090000,  18.82000,  0.7600002,
    19.91000,  1.470000,  19.53000,  1.090000,  20.24000,  2.180000,  19.91000,  1.470000,
    20.62000,  3.650000,  20.24000,  2.180000,  21.00000,  6.890000,  20.62000,  3.650000,
    21.00000,  10.50000,  21.00000,  6.890000,  14.11000,  20.96000,  10.50000,  20.96000,
    17.35000,  20.62000,  14.11000,  20.96000,  18.82000,  20.24000,  17.35000,  20.62000,
    19.53000,  19.91000,  18.82000,  20.24000,  19.91000,  19.53000,  19.53000,  19.91000,
    20.24000,  18.82000,  19.91000,  19.53000,  20.62000,  17.35000,  20.24000,  18.82000,
    21.00000,  14.11000,  20.62000,  17.35000,  21.00000,  10.50000,  21.00000,  14.11000,
    6.890000,  20.96000,  10.50000,  20.96000,  3.650000,  20.62000,  6.890000,  20.96000,
    2.180000,  20.24000,  3.650000,  20.62000,  1.470000,  19.91000,  2.180000,  20.24000,
    1.090000,  19.53000,  1.470000,  19.91000,  0.7600002, 18.82000,  1.090000,  19.53000,
    0.3800001, 17.35000,  0.7600002, 18.82000,  0.0000000, 14.11000,  0.3800001, 17.35000,
    0.0000000, 10.50000,  0.0000000, 14.11000,  6.890000,  0.0000000, 10.50000,  0.0000000,
    3.650000,  0.3800001, 6.890000,  0.0000000, 2.180000,  0.7600002, 3.650000,  0.3800001,
    1.470000,  1.090000,  2.180000,  0.7600002, 1.090000,  1.470000,  1.470000,  1.090000,
    0.7600002, 2.180000,  1.090000,  1.470000,  0.3800001, 3.650000,  0.7600002, 2.180000,
    0.0000000, 6.890000,  0.3800001, 3.650000,  0.0000000, 10.50000,  0.0000000, 6.890000,
    -99.00000, -99.00000, -99.00000, 13.000000, 0.0000000, 0.0000000, 21.00000,  0.0000000,
    21.00000,  0.0000000, 21.00000,  21.00000,  21.00000,  21.00000,  0.0000000, 21.00000,
    0.0000000, 21.00000,  0.0000000, 0.0000000, -99.00000, -99.00000, -99.00000, 14.000000,
    10.50000,  0.0000000, 21.00000,  10.50000,  21.00000,  10.50000,  10.50000,  21.00000,
    10.50000,  21.00000,  0.0000000, 10.50000,  0.0000000, 10.50000,  10.50000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 15.000000, 10.50000,  0.0000000, 10.50000,  21.00000,
    0.0000000, 10.50000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 16.000000,
    0.0000000, 0.0000000, 21.00000,  21.00000,  0.0000000, 21.00000,  21.00000,  0.0000000,
    -99.00000, -99.00000, -99.00000, 17.000000, 0.0000000, 0.000000,  10.50000,  21.00000,
    10.50000,  21.00000,  21.00000,  0.000000,  21.00000,  0.000000,  0.0000000, 0.000000,
    -99.00000, -99.00000, -99.00000, 18.00000,  21.00000,  10.50000,  20.49000,  13.74000,
    20.49000,  13.74000,  18.99000,  16.67000,  18.99000,  16.67000,  16.67000,  18.99000,
    16.67000,  18.99000,  13.74000,  20.49000,  13.74000,  20.49000,  10.50000,  21.00000,
    10.50000,  21.00000,  7.260000,  20.49000,  7.260000,  20.49000,  4.330000,  18.99000,
    4.330000,  18.99000,  2.010000,  16.67000,  2.010000,  16.67000,  0.5100002, 13.74000,
    0.5100002, 13.74000,  0.0000000, 10.50000,  0.0000000, 10.50000,  0.5100002, 7.260000,
    0.5100002, 7.260000,  2.010000,  4.330000,  2.010000,  4.330000,  4.330000,  2.010000,
    4.330000,  2.010000,  7.260000,  0.5100002, 7.260000,  0.5100002, 10.50000,  0.0000000,
    10.50000,  0.0000000, 13.74000,  0.5100002, 13.74000,  0.5100002, 16.67000,  2.010000,
    16.67000,  2.010000,  18.99000,  4.330000,  18.99000,  4.330000,  20.49000,  7.260000,
    20.49000,  7.260000,  21.00000,  10.50000,  -99.00000, -99.00000, -99.00000, 19.00000,
    8.500000,  10.50000,  12.50000,  10.50000,  10.50000,  12.50000,  10.50000,  8.500000,
    11.91000,  11.91000,  9.090000,  9.090000,  9.090000,  11.91000,  11.91000,  9.090000,
    -99.00,    -99.00,    -99.00,    20.00,     10.50,     21.00,     10.50,     3.00,
    1.50,      12.00,     19.50,     12.00,     1.50,      0.00,      19.50,     0.00,
    -99.00,    -99.00,    -99.00,    21.00,     16.00,     21.00,     0.00,      12.00,
    0.00,      12.00,     16.00,     3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    22.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      0.00,      0.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    23.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      4.00,      -2.00,     14.00,     20.00,
    -99.00,    -99.00,    -99.00,    24.00,     3.00,      19.00,     4.00,      24.00,
    4.00,      24.00,     5.00,      25.00,     5.00,      25.00,     6.00,      24.00,
    6.00,      24.00,     3.00,      19.00,     -99.00,    -99.00,    -99.00,    25.00,
    16.00,     21.00,     0.00,      12.00,     0.00,      12.00,     16.00,     3.00,
    0.00,      0.00,      16.00,     0.00,      11.00,     24.00,     6.00,      -4.00,
    -99.00,    -99.00,    -99.00,    26.00,     0.00,      21.00,     16.00,     12.00,
    16.00,     12.00,     0.00,      3.00,      16.00,     0.00,      0.00,      0.00,
    9.00,      23.00,     4.00,      -4.00,     -99.00,    -99.00,    -99.00,    27.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    24.00,     18.00,     8.00,      9.00,      8.00,      9.00,      24.00,     0.00,
    -99.00,    -99.00,    -99.00,    28.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      8.00,      18.00,     24.00,     9.00,
    24.00,     9.00,      8.00,      0.00,      -99.00,    -99.00,    -99.00,    29.00,
    16.00,     2.00,      15.00,     0.00,      15.00,     0.00,      0.00,      0.00,
    4.00,      0.00,      12.00,     1.00,      12.00,     1.00,      16.00,     2.00,
    0.00,      0.00,      8.00,      10.50,     8.00,      10.50,     0.00,      21.00,
    0.00,      21.00,     15.00,     21.00,     15.00,     21.00,     16.00,     19.00,
    16.00,     19.00,     12.00,     20.00,     12.00,     20.00,     4.00,      21.00,
    2.00,      20.00,     9.00,      10.50,     9.00,      10.50,     2.00,      1.00,
    -99.00,    -99.00,    -99.00,    30.00,     16.00,     18.00,     0.00,      9.00,
    0.00,      9.00,      16.00,     0.00,      11.00,     23.00,     6.00,      -3.00,
    -99.00,    -99.00,    -99.00,    31.00,     0.00,      18.00,     16.00,     9.00,
    16.00,     9.00,      0.00,      0.00,      9.00,      23.00,     4.00,      -4.00,
    -99.00,    -99.00,    -99.00,    32.00,     10.50,     0.00,      10.50,     0.00,
    -99.00,    -99.00,    -99.00,    33.00,     1.00,      19.00,     1.00,      13.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      21.00,     0.00,      19.00,     0.00,      19.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      19.00,     2.00,      19.00,     1.00,      21.00,
    -99.00,    -99.00,    -99.00,    34.00,     1.00,      21.00,     0.00,      14.00,
    0.00,      14.00,     2.00,      21.00,     9.00,      21.00,     8.00,      14.00,
    8.00,      14.00,     10.00,     21.00,     -99.00,    -99.00,    -99.00,    35.00,
    8.00,      21.00,     1.00,      -7.00,     14.00,     21.00,     7.00,      -7.00,
    1.00,      10.00,     15.00,     10.00,     0.00,      4.00,      14.00,     4.00,
    -99.00,    -99.00,    -99.00,    36.00,     5.00,      25.00,     5.00,      -4.00,
    9.00,      25.00,     9.00,      -4.00,     0.00,      16.00,     2.00,      14.00,
    2.00,      14.00,     4.00,      13.00,     4.00,      13.00,     10.00,     11.00,
    10.00,     11.00,     12.00,     10.00,     12.00,     10.00,     13.00,     9.00,
    13.00,     9.00,      14.00,     7.00,      14.00,     7.00,      14.00,     3.00,
    14.00,     3.00,      12.00,     1.00,      12.00,     1.00,      9.00,      0.00,
    9.00,      0.00,      5.00,      0.00,      5.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      4.00,
    0.00,      4.00,      1.00,      5.00,      1.00,      5.00,      2.00,      4.00,
    2.00,      4.00,      1.00,      3.00,      13.00,     18.00,     12.00,     17.00,
    12.00,     17.00,     13.00,     16.00,     13.00,     16.00,     14.00,     17.00,
    14.00,     17.00,     14.00,     18.00,     14.00,     18.00,     12.00,     20.00,
    12.00,     20.00,     9.00,      21.00,     9.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     2.00,      20.00,     2.00,      20.00,     0.00,      18.00,
    0.00,      18.00,     0.00,      16.00,     0.00,      16.00,     1.00,      14.00,
    1.00,      14.00,     2.00,      13.00,     2.00,      13.00,     4.00,      12.00,
    4.00,      12.00,     10.00,     10.00,     10.00,     10.00,     12.00,     9.00,
    12.00,     9.00,      14.00,     7.00,      -99.00,    -99.00,    -99.00,    37.00,
    14.00,     7.00,      12.00,     6.00,      12.00,     6.00,      11.00,     4.00,
    11.00,     4.00,      11.00,     2.00,      11.00,     2.00,      13.00,     0.00,
    13.00,     0.00,      15.00,     0.00,      15.00,     0.00,      17.00,     1.00,
    17.00,     1.00,      18.00,     3.00,      18.00,     3.00,      18.00,     5.00,
    18.00,     5.00,      16.00,     7.00,      16.00,     7.00,      14.00,     7.00,
    5.00,      21.00,     7.00,      19.00,     7.00,      19.00,     7.00,      17.00,
    7.00,      17.00,     6.00,      15.00,     6.00,      15.00,     4.00,      14.00,
    4.00,      14.00,     2.00,      14.00,     2.00,      14.00,     0.00,      16.00,
    0.00,      16.00,     0.00,      18.00,     0.00,      18.00,     1.00,      20.00,
    1.00,      20.00,     3.00,      21.00,     3.00,      21.00,     5.00,      21.00,
    5.00,      21.00,     7.00,      20.00,     7.00,      20.00,     10.00,     19.00,
    10.00,     19.00,     13.00,     19.00,     13.00,     19.00,     16.00,     20.00,
    16.00,     20.00,     18.00,     21.00,     18.00,     21.00,     0.00,      0.00,
    -99.00,    -99.00,    -99.00,    38.00,     4.00,      16.00,     5.00,      14.00,
    5.00,      14.00,     13.00,     3.00,      13.00,     3.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     0.00,      4.00,      0.00,      2.00,      1.00,
    2.00,      1.00,      1.00,      3.00,      1.00,      3.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      8.00,      2.00,      8.00,      4.00,      10.00,
    18.00,     13.00,     17.00,     12.00,     17.00,     12.00,     18.00,     11.00,
    18.00,     11.00,     19.00,     12.00,     19.00,     12.00,     19.00,     13.00,
    19.00,     13.00,     18.00,     14.00,     18.00,     14.00,     17.00,     14.00,
    17.00,     14.00,     16.00,     13.00,     16.00,     13.00,     15.00,     11.00,
    15.00,     11.00,     13.00,     6.00,      13.00,     6.00,      11.00,     3.00,
    11.00,     3.00,      9.00,      1.00,      9.00,      1.00,      7.00,      0.00,
    7.00,      0.00,      4.00,      0.00,      4.00,      0.00,      1.00,      1.00,
    1.00,      1.00,      0.00,      3.00,      0.00,      3.00,      0.00,      6.00,
    0.00,      6.00,      1.00,      8.00,      1.00,      8.00,      7.00,      12.00,
    7.00,      12.00,     9.00,      14.00,     9.00,      14.00,     10.00,     16.00,
    10.00,     16.00,     10.00,     18.00,     10.00,     18.00,     9.00,      20.00,
    9.00,      20.00,     7.00,      21.00,     7.00,      21.00,     5.00,      20.00,
    5.00,      20.00,     4.00,      18.00,     4.00,      18.00,     4.00,      16.00,
    4.00,      16.00,     5.00,      13.00,     5.00,      13.00,     7.00,      10.00,
    7.00,      10.00,     12.00,     3.00,      12.00,     3.00,      14.00,     1.00,
    14.00,     1.00,      17.00,     0.00,      17.00,     0.00,      18.00,     0.00,
    18.00,     0.00,      19.00,     1.00,      19.00,     1.00,      19.00,     2.00,
    -99.00,    -99.00,    -99.00,    39.00,     1.00,      21.00,     0.00,      14.00,
    0.00,      14.00,     2.00,      21.00,     -99.00,    -99.00,    -99.00,    40.00,
    5.00,      23.00,     3.00,      19.00,     3.00,      19.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      11.00,     1.00,      11.00,     1.00,      7.00,
    1.00,      7.00,      2.00,      2.00,      2.00,      2.00,      3.00,      -1.00,
    3.00,      -1.00,     5.00,      -5.00,     7.00,      25.00,     5.00,      23.00,
    5.00,      23.00,     3.00,      20.00,     3.00,      20.00,     1.00,      16.00,
    1.00,      16.00,     0.00,      11.00,     0.00,      11.00,     0.00,      7.00,
    0.00,      7.00,      1.00,      2.00,      1.00,      2.00,      3.00,      -2.00,
    3.00,      -2.00,     5.00,      -5.00,     5.00,      -5.00,     7.00,      -7.00,
    -99.00,    -99.00,    -99.00,    41.00,     2.00,      23.00,     4.00,      19.00,
    4.00,      19.00,     5.00,      16.00,     5.00,      16.00,     6.00,      11.00,
    6.00,      11.00,     6.00,      7.00,      6.00,      7.00,      5.00,      2.00,
    5.00,      2.00,      4.00,      -1.00,     4.00,      -1.00,     2.00,      -5.00,
    0.00,      25.00,     2.00,      23.00,     2.00,      23.00,     4.00,      20.00,
    4.00,      20.00,     6.00,      16.00,     6.00,      16.00,     7.00,      11.00,
    7.00,      11.00,     7.00,      7.00,      7.00,      7.00,      6.00,      2.00,
    6.00,      2.00,      4.00,      -2.00,     4.00,      -2.00,     2.00,      -5.00,
    2.00,      -5.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    42.00,
    5.00,      17.00,     5.00,      5.00,      0.00,      14.00,     10.00,     8.00,
    10.00,     14.00,     0.00,      8.00,      -99.00,    -99.00,    -99.00,    43.00,
    10.50,     18.00,     10.50,     0.00,      1.50,      9.00,      19.50,     9.00,
    -99.00,    -99.00,    -99.00,    44.00,     1.00,      0.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      -1.00,     2.00,      -1.00,     1.00,      -3.00,
    1.00,      -3.00,     0.00,      -4.00,     -99.00,    -99.00,    -99.00,    45.00,
    1.50,      9.00,      19.50,     9.00,      -99.00,    -99.00,    -99.00,    46.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    -99.00,    -99.00,    -99.00,    47.00,     18.00,     25.00,     0.00,      -7.00,
    -99.000,   -99.000,   -99.000,   48.000,    11.500,    0.000,     13.500,    1.000,
    13.500,    1.000,     14.500,    2.000,     14.500,    2.000,     15.500,    4.000,
    15.500,    4.000,     16.500,    9.000,     16.500,    9.000,     16.500,    12.000,
    16.500,    12.000,    15.500,    17.000,    15.500,    17.000,    14.500,    19.000,
    14.500,    19.000,    13.500,    20.000,    13.500,    20.000,    11.500,    21.000,
    9.500,     21.000,    6.500,     20.000,    6.500,     20.000,    4.500,     17.000,
    4.500,     17.000,    3.500,     12.000,    3.500,     12.000,    3.500,     9.000,
    3.500,     9.000,     4.500,     4.000,     4.500,     4.000,     6.500,     1.000,
    6.500,     1.000,     9.500,     0.000,     9.500,     0.000,     11.500,    0.000,
    11.500,    0.000,     14.500,    1.000,     14.500,    1.000,     16.500,    4.000,
    16.500,    4.000,     17.500,    9.000,     17.500,    9.000,     17.500,    12.000,
    17.500,    12.000,    16.500,    17.000,    16.500,    17.000,    14.500,    20.000,
    14.500,    20.000,    11.500,    21.000,    11.500,    21.000,    9.500,     21.000,
    9.500,     21.000,    7.500,     20.000,    7.500,     20.000,    6.500,     19.000,
    6.500,     19.000,    5.500,     17.000,    5.500,     17.000,    4.500,     12.000,
    4.500,     12.000,    4.500,     9.000,     4.500,     9.000,     5.500,     4.000,
    5.500,     4.000,     6.500,     2.000,     6.500,     2.000,     7.500,     1.000,
    7.500,     1.000,     9.500,     0.000,     -99.000,   -99.000,   -99.000,   49.000,
    10.000,    20.000,    10.000,    0.000,     6.000,     0.000,     15.000,    0.000,
    6.000,     17.000,    8.000,     18.000,    8.000,     18.000,    11.000,    21.000,
    11.000,    21.000,    11.000,    0.000,     -99.000,   -99.000,   -99.000,   50.000,
    6.500,     3.000,     11.500,    0.000,     11.500,    0.000,     15.500,    0.000,
    15.500,    0.000,     16.500,    1.000,     16.500,    1.000,     17.500,    3.000,
    17.500,    3.000,     17.500,    5.000,     3.500,     2.000,     4.500,     3.000,
    4.500,     3.000,     6.500,     3.000,     6.500,     3.000,     11.500,    1.000,
    11.500,    1.000,     14.500,    1.000,     14.500,    1.000,     16.500,    2.000,
    16.500,    2.000,     17.500,    3.000,     12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    19.000,    15.500,    19.000,    16.500,    17.000,
    16.500,    17.000,    16.500,    15.000,    16.500,    15.000,    15.500,    13.000,
    15.500,    13.000,    12.500,    11.000,    12.500,    11.000,    8.500,     9.000,
    4.500,     17.000,    5.500,     16.000,    5.500,     16.000,    4.500,     15.000,
    4.500,     15.000,    3.500,     16.000,    3.500,     16.000,    3.500,     17.000,
    3.500,     17.000,    4.500,     19.000,    4.500,     19.000,    5.500,     20.000,
    5.500,     20.000,    8.500,     21.000,    8.500,     21.000,    12.500,    21.000,
    12.500,    21.000,    15.500,    20.000,    15.500,    20.000,    16.500,    19.000,
    16.500,    19.000,    17.500,    17.000,    17.500,    17.000,    17.500,    15.000,
    17.500,    15.000,    16.500,    13.000,    16.500,    13.000,    13.500,    11.000,
    13.500,    11.000,    8.500,     9.000,     8.500,     9.000,     6.500,     8.000,
    6.500,     8.000,     4.500,     6.000,     4.500,     6.000,     3.500,     3.000,
    3.500,     3.000,     3.500,     0.000,     -99.000,   -99.000,   -99.000,   51.000,
    4.500,     17.000,    5.500,     16.000,    5.500,     16.000,    4.500,     15.000,
    4.500,     15.000,    3.500,     16.000,    3.500,     16.000,    3.500,     17.000,
    3.500,     17.000,    4.500,     19.000,    4.500,     19.000,    5.500,     20.000,
    5.500,     20.000,    8.500,     21.000,    8.500,     21.000,    12.500,    21.000,
    12.500,    21.000,    15.500,    20.000,    15.500,    20.000,    16.500,    18.000,
    16.500,    18.000,    16.500,    15.000,    16.500,    15.000,    15.500,    13.000,
    15.500,    13.000,    12.500,    12.000,    12.500,    12.000,    9.500,     12.000,
    15.500,    10.000,    16.500,    7.000,     16.500,    7.000,     16.500,    4.000,
    16.500,    4.000,     15.500,    2.000,     15.500,    2.000,     14.500,    1.000,
    14.500,    1.000,     12.500,    0.000,     12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    18.000,    15.500,    18.000,    15.500,    15.000,
    15.500,    15.000,    14.500,    13.000,    14.500,    13.000,    12.500,    12.000,
    12.500,    12.000,    14.500,    11.000,    14.500,    11.000,    16.500,    9.000,
    16.500,    9.000,     17.500,    7.000,     17.500,    7.000,     17.500,    4.000,
    17.500,    4.000,     16.500,    2.000,     16.500,    2.000,     15.500,    1.000,
    15.500,    1.000,     12.500,    0.000,     12.500,    0.000,     8.500,     0.000,
    8.500,     0.000,     5.500,     1.000,     5.500,     1.000,     4.500,     2.000,
    4.500,     2.000,     3.500,     4.000,     3.500,     4.000,     3.500,     5.000,
    3.500,     5.000,     4.500,     6.000,     4.500,     6.000,     5.500,     5.000,
    5.500,     5.000,     4.500,     4.000,     -99.000,   -99.000,   -99.000,   52.000,
    12.500,    19.000,    12.500,    0.000,     9.500,     0.000,     16.500,    0.000,
    18.500,    6.000,     2.500,     6.000,     2.500,     6.000,     13.500,    21.000,
    13.500,    21.000,    13.500,    0.000,     -99.000,   -99.000,   -99.000,   53.000,
    5.500,     20.000,    10.500,    20.000,    10.500,    20.000,    15.500,    21.000,
    15.500,    21.000,    5.500,     21.000,    5.500,     21.000,    3.500,     11.000,
    3.500,     11.000,    5.500,     13.000,    5.500,     13.000,    8.500,     14.000,
    8.500,     14.000,    11.500,    14.000,    11.500,    14.000,    14.500,    13.000,
    14.500,    13.000,    16.500,    11.000,    16.500,    11.000,    17.500,    8.000,
    17.500,    8.000,     17.500,    6.000,     17.500,    6.000,     16.500,    3.000,
    16.500,    3.000,     14.500,    1.000,     14.500,    1.000,     11.500,    0.000,
    11.500,    0.000,     8.500,     0.000,     8.500,     0.000,     5.500,     1.000,
    5.500,     1.000,     4.500,     2.000,     4.500,     2.000,     3.500,     4.000,
    3.500,     4.000,     3.500,     5.000,     3.500,     5.000,     4.500,     6.000,
    4.500,     6.000,     5.500,     5.000,     5.500,     5.000,     4.500,     4.000,
    11.500,    0.000,     13.500,    1.000,     13.500,    1.000,     15.500,    3.000,
    15.500,    3.000,     16.500,    6.000,     16.500,    6.000,     16.500,    8.000,
    16.500,    8.000,     15.500,    11.000,    15.500,    11.000,    13.500,    13.000,
    13.500,    13.000,    11.500,    14.000,    -99.000,   -99.000,   -99.000,   54.000,
    15.500,    18.000,    14.500,    17.000,    14.500,    17.000,    15.500,    16.000,
    15.500,    16.000,    16.500,    17.000,    16.500,    17.000,    16.500,    18.000,
    16.500,    18.000,    15.500,    20.000,    15.500,    20.000,    13.500,    21.000,
    13.500,    21.000,    10.500,    21.000,    10.500,    21.000,    7.500,     20.000,
    7.500,     20.000,    5.500,     18.000,    5.500,     18.000,    4.500,     16.000,
    4.500,     16.000,    3.500,     12.000,    3.500,     12.000,    3.500,     6.000,
    3.500,     6.000,     4.500,     3.000,     4.500,     3.000,     6.500,     1.000,
    6.500,     1.000,     9.500,     0.000,     9.500,     0.000,     11.500,    0.000,
    11.500,    0.000,     14.500,    1.000,     14.500,    1.000,     16.500,    3.000,
    16.500,    3.000,     17.500,    6.000,     17.500,    6.000,     17.500,    7.000,
    17.500,    7.000,     16.500,    10.000,    16.500,    10.000,    14.500,    12.000,
    14.500,    12.000,    11.500,    13.000,    11.500,    13.000,    10.500,    13.000,
    10.500,    13.000,    7.500,     12.000,    7.500,     12.000,    5.500,     10.000,
    5.500,     10.000,    4.500,     7.000,     11.500,    0.000,     13.500,    1.000,
    13.500,    1.000,     15.500,    3.000,     15.500,    3.000,     16.500,    6.000,
    16.500,    6.000,     16.500,    7.000,     16.500,    7.000,     15.500,    10.000,
    15.500,    10.000,    13.500,    12.000,    13.500,    12.000,    11.500,    13.000,
    10.500,    21.000,    8.500,     20.000,    8.500,     20.000,    6.500,     18.000,
    6.500,     18.000,    5.500,     16.000,    5.500,     16.000,    4.500,     12.000,
    4.500,     12.000,    4.500,     6.000,     4.500,     6.000,     5.500,     3.000,
    5.500,     3.000,     7.500,     1.000,     7.500,     1.000,     9.500,     0.000,
    -99.000,   -99.000,   -99.000,   55.000,    3.500,     21.000,    3.500,     15.000,
    4.500,     19.000,    6.500,     20.000,    6.500,     20.000,    8.500,     20.000,
    8.500,     20.000,    13.500,    18.000,    16.500,    15.000,    11.500,    10.000,
    11.500,    10.000,    10.500,    8.000,     10.500,    8.000,     9.500,     5.000,
    9.500,     5.000,     9.500,     0.000,     3.500,     17.000,    4.500,     19.000,
    4.500,     19.000,    6.500,     21.000,    6.500,     21.000,    8.500,     21.000,
    8.500,     21.000,    13.500,    18.000,    13.500,    18.000,    15.500,    18.000,
    15.500,    18.000,    16.500,    19.000,    16.500,    19.000,    17.500,    21.000,
    17.500,    21.000,    17.500,    18.000,    17.500,    18.000,    16.500,    15.000,
    16.500,    15.000,    12.500,    10.000,    12.500,    10.000,    11.500,    8.000,
    11.500,    8.000,     10.500,    5.000,     10.500,    5.000,     10.500,    0.000,
    -99.000,   -99.000,   -99.000,   56.000,    12.500,    21.000,    14.500,    20.000,
    14.500,    20.000,    15.500,    18.000,    15.500,    18.000,    15.500,    15.000,
    15.500,    15.000,    14.500,    13.000,    14.500,    13.000,    12.500,    12.000,
    8.500,     12.000,    6.500,     11.000,    6.500,     11.000,    5.500,     10.000,
    5.500,     10.000,    4.500,     8.000,     4.500,     8.000,     4.500,     4.000,
    4.500,     4.000,     5.500,     2.000,     5.500,     2.000,     6.500,     1.000,
    6.500,     1.000,     8.500,     0.000,     8.500,     21.000,    5.500,     20.000,
    5.500,     20.000,    4.500,     18.000,    4.500,     18.000,    4.500,     15.000,
    4.500,     15.000,    5.500,     13.000,    5.500,     13.000,    8.500,     12.000,
    8.500,     12.000,    12.500,    12.000,    12.500,    12.000,    15.500,    13.000,
    15.500,    13.000,    16.500,    15.000,    16.500,    15.000,    16.500,    18.000,
    16.500,    18.000,    15.500,    20.000,    15.500,    20.000,    12.500,    21.000,
    12.500,    21.000,    8.500,     21.000,    8.500,     21.000,    6.500,     20.000,
    6.500,     20.000,    5.500,     18.000,    5.500,     18.000,    5.500,     15.000,
    5.500,     15.000,    6.500,     13.000,    6.500,     13.000,    8.500,     12.000,
    8.500,     12.000,    5.500,     11.000,    5.500,     11.000,    4.500,     10.000,
    4.500,     10.000,    3.500,     8.000,     3.500,     8.000,     3.500,     4.000,
    3.500,     4.000,     4.500,     2.000,     4.500,     2.000,     5.500,     1.000,
    5.500,     1.000,     8.500,     0.000,     8.500,     0.000,     12.500,    0.000,
    12.500,    0.000,     15.500,    1.000,     15.500,    1.000,     16.500,    2.000,
    16.500,    2.000,     17.500,    4.000,     17.500,    4.000,     17.500,    8.000,
    17.500,    8.000,     16.500,    10.000,    16.500,    10.000,    15.500,    11.000,
    15.500,    11.000,    12.500,    12.000,    12.500,    12.000,    14.500,    11.000,
    14.500,    11.000,    15.500,    10.000,    15.500,    10.000,    16.500,    8.000,
    16.500,    8.000,     16.500,    4.000,     16.500,    4.000,     15.500,    2.000,
    15.500,    2.000,     14.500,    1.000,     14.500,    1.000,     12.500,    0.000,
    -99.000,   -99.000,   -99.000,   57.000,    9.500,     8.000,     7.500,     9.000,
    7.500,     9.000,     5.500,     11.000,    5.500,     11.000,    4.500,     14.000,
    4.500,     14.000,    4.500,     15.000,    4.500,     15.000,    5.500,     18.000,
    5.500,     18.000,    7.500,     20.000,    7.500,     20.000,    9.500,     21.000,
    11.500,    21.000,    13.500,    20.000,    13.500,    20.000,    15.500,    18.000,
    15.500,    18.000,    16.500,    15.000,    16.500,    15.000,    16.500,    9.000,
    16.500,    9.000,     15.500,    5.000,     15.500,    5.000,     14.500,    3.000,
    14.500,    3.000,     12.500,    1.000,     12.500,    1.000,     10.500,    0.000,
    16.500,    14.000,    15.500,    11.000,    15.500,    11.000,    13.500,    9.000,
    13.500,    9.000,     10.500,    8.000,     10.500,    8.000,     9.500,     8.000,
    9.500,     8.000,     6.500,     9.000,     6.500,     9.000,     4.500,     11.000,
    4.500,     11.000,    3.500,     14.000,    3.500,     14.000,    3.500,     15.000,
    3.500,     15.000,    4.500,     18.000,    4.500,     18.000,    6.500,     20.000,
    6.500,     20.000,    9.500,     21.000,    9.500,     21.000,    11.500,    21.000,
    11.500,    21.000,    14.500,    20.000,    14.500,    20.000,    16.500,    18.000,
    16.500,    18.000,    17.500,    15.000,    17.500,    15.000,    17.500,    9.000,
    17.500,    9.000,     16.500,    5.000,     16.500,    5.000,     15.500,    3.000,
    15.500,    3.000,     13.500,    1.000,     13.500,    1.000,     10.500,    0.000,
    10.500,    0.000,     7.500,     0.000,     7.500,     0.000,     5.500,     1.000,
    5.500,     1.000,     4.500,     3.000,     4.500,     3.000,     4.500,     4.000,
    4.500,     4.000,     5.500,     5.000,     5.500,     5.000,     6.500,     4.000,
    6.500,     4.000,     5.500,     3.000,     -99.00,    -99.00,    -99.00,    58.00,
    1.00,      2.00,      0.00,      1.00,      0.00,      1.00,      1.00,      0.00,
    1.00,      0.00,      2.00,      1.00,      2.00,      1.00,      1.00,      2.00,
    1.00,      14.00,     0.00,      13.00,     0.00,      13.00,     1.00,      12.00,
    1.00,      12.00,     2.00,      13.00,     2.00,      13.00,     1.00,      14.00,
    -99.00,    -99.00,    -99.00,    59.00,     1.00,      14.00,     0.00,      13.00,
    0.00,      13.00,     1.00,      12.00,     1.00,      12.00,     2.00,      13.00,
    2.00,      13.00,     1.00,      14.00,     1.00,      0.00,      0.00,      1.00,
    0.00,      1.00,      1.00,      2.00,      1.00,      2.00,      2.00,      1.00,
    2.00,      1.00,      2.00,      -1.00,     2.00,      -1.00,     1.00,      -3.00,
    1.00,      -3.00,     0.00,      -4.00,     -99.00,    -99.00,    -99.00,    60.00,
    16.00,     18.00,     0.00,      9.00,      0.00,      9.00,      16.00,     0.00,
    -99.00,    -99.00,    -99.00,    61.00,     0.00,      12.00,     18.00,     12.00,
    0.00,      6.00,      18.00,     6.00,      -99.00,    -99.00,    -99.00,    62.00,
    0.00,      18.00,     16.00,     9.00,      16.00,     9.00,      0.00,      0.00,
    -99.00,    -99.00,    -99.00,    63.00,     6.00,      2.00,      5.00,      1.00,
    5.00,      1.00,      6.00,      0.00,      6.00,      0.00,      7.00,      1.00,
    7.00,      1.00,      6.00,      2.00,      7.00,      21.00,     9.00,      20.00,
    9.00,      20.00,     10.00,     19.00,     10.00,     19.00,     11.00,     17.00,
    11.00,     17.00,     11.00,     15.00,     11.00,     15.00,     10.00,     13.00,
    10.00,     13.00,     8.00,      11.00,     1.00,      17.00,     2.00,      16.00,
    2.00,      16.00,     1.00,      15.00,     1.00,      15.00,     0.00,      16.00,
    0.00,      16.00,     0.00,      17.00,     0.00,      17.00,     1.00,      19.00,
    1.00,      19.00,     2.00,      20.00,     2.00,      20.00,     4.00,      21.00,
    4.00,      21.00,     7.00,      21.00,     7.00,      21.00,     10.00,     20.00,
    10.00,     20.00,     11.00,     19.00,     11.00,     19.00,     12.00,     17.00,
    12.00,     17.00,     12.00,     15.00,     12.00,     15.00,     11.00,     13.00,
    11.00,     13.00,     10.00,     12.00,     10.00,     12.00,     6.00,      10.00,
    6.00,      10.00,     6.00,      7.00,      -99.00,    -99.00,    -99.00,    64.00,
    16.00,     16.00,     15.00,     8.00,      15.00,     8.00,      15.00,     6.00,
    15.00,     6.00,      16.00,     5.00,      9.00,      16.00,     7.00,      14.00,
    7.00,      14.00,     6.00,      11.00,     6.00,      11.00,     6.00,      8.00,
    6.00,      8.00,      7.00,      6.00,      7.00,      6.00,      8.00,      5.00,
    15.00,     13.00,     14.00,     15.00,     14.00,     15.00,     12.00,     16.00,
    12.00,     16.00,     9.00,      16.00,     9.00,      16.00,     7.00,      15.00,
    7.00,      15.00,     6.00,      14.00,     6.00,      14.00,     5.00,      11.00,
    5.00,      11.00,     5.00,      8.00,      5.00,      8.00,      6.00,      6.00,
    6.00,      6.00,      8.00,      5.00,      8.00,      5.00,      11.00,     5.00,
    11.00,     5.00,      13.00,     6.00,      13.00,     6.00,      14.00,     8.00,
    15.00,     16.00,     14.00,     8.00,      14.00,     8.00,      14.00,     6.00,
    14.00,     6.00,      16.00,     5.00,      16.00,     5.00,      18.00,     5.00,
    18.00,     5.00,      20.00,     7.00,      20.00,     7.00,      21.00,     10.00,
    21.00,     10.00,     21.00,     12.00,     21.00,     12.00,     20.00,     15.00,
    20.00,     15.00,     19.00,     17.00,     19.00,     17.00,     17.00,     19.00,
    17.00,     19.00,     15.00,     20.00,     15.00,     20.00,     12.00,     21.00,
    12.00,     21.00,     9.00,      21.00,     9.00,      21.00,     6.00,      20.00,
    6.00,      20.00,     4.00,      19.00,     4.00,      19.00,     2.00,      17.00,
    2.00,      17.00,     1.00,      15.00,     1.00,      15.00,     0.00,      12.00,
    0.00,      12.00,     0.00,      9.00,      0.00,      9.00,      1.00,      6.00,
    1.00,      6.00,      2.00,      4.00,      2.00,      4.00,      4.00,      2.00,
    4.00,      2.00,      6.00,      1.00,      6.00,      1.00,      9.00,      0.00,
    9.00,      0.00,      12.00,     0.00,      12.00,     0.00,      15.00,     1.00,
    15.00,     1.00,      17.00,     2.00,      17.00,     2.00,      18.00,     3.00,
    -99.000,   -99.000,   -99.000,   65.000,    2.000,     0.000,     9.000,     21.000,
    9.000,     21.000,    16.000,    0.000,     9.000,     18.000,    15.000,    0.000,
    4.000,     6.000,     13.000,    6.000,     0.000,     0.000,     6.000,     0.000,
    12.000,    0.000,     18.000,    0.000,     -99.000,   -99.000,   -99.000,   66.000,
    0.000,     21.000,    12.000,    21.000,    12.000,    21.000,    15.000,    20.000,
    15.000,    20.000,    16.000,    19.000,    16.000,    19.000,    17.000,    17.000,
    17.000,    17.000,    17.000,    15.000,    17.000,    15.000,    16.000,    13.000,
    16.000,    13.000,    15.000,    12.000,    15.000,    12.000,    12.000,    11.000,
    12.000,    11.000,    14.000,    12.000,    14.000,    12.000,    15.000,    13.000,
    15.000,    13.000,    16.000,    15.000,    16.000,    15.000,    16.000,    17.000,
    16.000,    17.000,    15.000,    19.000,    15.000,    19.000,    14.000,    20.000,
    14.000,    20.000,    12.000,    21.000,    3.000,     21.000,    3.000,     0.000,
    4.000,     21.000,    4.000,     0.000,     4.000,     11.000,    12.000,    11.000,
    12.000,    11.000,    15.000,    10.000,    15.000,    10.000,    16.000,    9.000,
    16.000,    9.000,     17.000,    7.000,     17.000,    7.000,     17.000,    4.000,
    17.000,    4.000,     16.000,    2.000,     16.000,    2.000,     15.000,    1.000,
    15.000,    1.000,     12.000,    0.000,     12.000,    0.000,     0.000,     0.000,
    12.000,    11.000,    14.000,    10.000,    14.000,    10.000,    15.000,    9.000,
    15.000,    9.000,     16.000,    7.000,     16.000,    7.000,     16.000,    4.000,
    16.000,    4.000,     15.000,    2.000,     15.000,    2.000,     14.000,    1.000,
    14.000,    1.000,     12.000,    0.000,     -99.000,   -99.000,   -99.000,   67.000,
    3.000,     21.000,    3.000,     0.000,     4.000,     21.000,    4.000,     0.000,
    16.000,    21.000,    16.000,    0.000,     17.000,    21.000,    17.000,    0.000,
    0.000,     21.000,    7.000,     21.000,    13.000,    21.000,    20.000,    21.000,
    4.000,     11.000,    16.000,    11.000,    0.000,     0.000,     7.000,     0.000,
    13.000,    0.000,     20.000,    0.000,     -99.000,   -99.000,   -99.000,   68.000,
    16.000,    0.000,     8.000,     21.000,    8.000,     21.000,    0.000,     0.000,
    0.000,     0.000,     16.000,    0.000,     8.000,     18.000,    15.000,    0.000,
    1.000,     1.000,     15.000,    1.000,     -99.000,   -99.000,   -99.000,   69.000,
    3.000,     21.000,    3.000,     0.000,     4.000,     21.000,    4.000,     0.000,
    10.000,    15.000,    10.000,    7.000,     0.000,     21.000,    16.000,    21.000,
    16.000,    21.000,    16.000,    15.000,    16.000,    15.000,    15.000,    21.000,
    4.000,     11.000,    10.000,    11.000,    0.000,     0.000,     16.000,    0.000,
    16.000,    0.000,     16.000,    6.000,     16.000,    6.000,     15.000,    0.000,
    -99.000,   -99.000,   -99.000,   70.000,    5.000,     16.000,    10.000,    16.000,
    10.000,    16.000,    13.000,    15.000,    13.000,    15.000,    14.000,    14.000,
    14.000,    14.000,    15.000,    12.000,    15.000,    12.000,    15.000,    9.000,
    15.000,    9.000,     14.000,    7.000,     14.000,    7.000,     13.000,    6.000,
    13.000,    6.000,     10.000,    5.000,     10.000,    5.000,     5.000,     5.000,
    5.000,     5.000,     2.000,     6.000,     2.000,     6.000,     1.000,     7.000,
    1.000,     7.000,     0.000,     9.000,     0.000,     9.000,     0.000,     12.000,
    0.000,     12.000,    1.000,     14.000,    1.000,     14.000,    2.000,     15.000,
    2.000,     15.000,    5.000,     16.000,    5.000,     16.000,    3.000,     15.000,
    3.000,     15.000,    2.000,     14.000,    2.000,     14.000,    1.000,     12.000,
    1.000,     12.000,    1.000,     9.000,     1.000,     9.000,     2.000,     7.000,
    2.000,     7.000,     3.000,     6.000,     3.000,     6.000,     5.000,     5.000,
    7.000,     21.000,    7.000,     0.000,     8.000,     21.000,    8.000,     0.000,
    10.000,    5.000,     12.000,    6.000,     12.000,    6.000,     13.000,    7.000,
    13.000,    7.000,     14.000,    9.000,     14.000,    9.000,     14.000,    12.000,
    14.000,    12.000,    13.000,    14.000,    13.000,    14.000,    12.000,    15.000,
    12.000,    15.000,    10.000,    16.000,    4.000,     21.000,    11.000,    21.000,
    4.000,     0.000,     11.000,    0.000,     -99.000,   -99.000,   -99.000,   71.000,
    3.000,     21.000,    3.000,     0.000,     4.000,     21.000,    4.000,     0.000,
    0.000,     21.000,    15.000,    21.000,    15.000,    21.000,    15.000,    15.000,
    15.000,    15.000,    14.000,    21.000,    0.000,     0.000,     7.000,     0.000,
    -99.000,   -99.000,   -99.000,   72.000,    2.000,     21.000,    15.000,    0.000,
    3.000,     21.000,    16.000,    0.000,     16.000,    21.000,    2.000,     0.000,
    0.000,     21.000,    6.000,     21.000,    12.000,    21.000,    18.000,    21.000,
    0.000,     0.000,     6.000,     0.000,     12.000,    0.000,     18.000,    0.000,
    -99.000,   -99.000,   -99.000,   73.000,    3.000,     21.000,    3.000,     0.000,
    4.000,     21.000,    4.000,     0.000,     0.000,     21.000,    7.000,     21.000,
    0.000,     0.000,     7.000,     0.000,     -99.000,   -99.000,   -99.000,   74.000,
    8.000,     21.000,    8.000,     4.000,     8.000,     4.000,     7.000,     1.000,
    7.000,     1.000,     5.000,     0.000,     5.000,     0.000,     3.000,     0.000,
    3.000,     0.000,     1.000,     1.000,     1.000,     1.000,     0.000,     3.000,
    0.000,     3.000,     0.000,     5.000,     0.000,     5.000,     1.000,     6.000,
    1.000,     6.000,     2.000,     5.000,     2.000,     5.000,     1.000,     4.000,
    7.000,     21.000,    7.000,     4.000,     7.000,     4.000,     6.000,     1.000,
    6.000,     1.000,     5.000,     0.000,     4.000,     21.000,    11.000,    21.000,
    -99.000,   -99.000,   -99.000,   75.000,    3.000,     21.000,    3.000,     0.000,
    4.000,     21.000,    4.000,     0.000,     17.000,    21.000,    4.000,     8.000,
    9.000,     12.000,    17.000,    0.000,     8.000,     12.000,    16.000,    0.000,
    0.000,     21.000,    7.000,     21.000,    13.000,    21.000,    19.000,    21.000,
    0.000,     0.000,     7.000,     0.000,     13.000,    0.000,     19.000,    0.000,
    -99.000,   -99.000,   -99.000,   76.000,    2.000,     0.000,     9.000,     21.000,
    9.000,     21.000,    16.000,    0.000,     9.000,     18.000,    15.000,    0.000,
    0.000,     0.000,     6.000,     0.000,     12.000,    0.000,     18.000,    0.000,
    -99.000,   -99.000,   -99.000,   77.000,    10.000,    3.000,     4.000,     21.000,
    4.000,     21.000,    0.000,     21.000,    3.000,     0.000,     3.000,     21.000,
    3.000,     21.000,    10.000,    0.000,     10.000,    0.000,     17.000,    21.000,
    17.000,    21.000,    17.000,    0.000,     18.000,    21.000,    18.000,    0.000,
    17.000,    21.000,    21.000,    21.000,    0.000,     0.000,     6.000,     0.000,
    14.000,    0.000,     21.000,    0.000,     -99.000,   -99.000,   -99.000,   78.000,
    4.000,     19.000,    16.000,    0.000,     16.000,    0.000,     16.000,    21.000,
    16.000,    2.000,     4.000,     21.000,    4.000,     21.000,    0.000,     21.000,
    3.000,     21.000,    3.000,     0.000,     13.000,    21.000,    19.000,    21.000,
    0.000,     0.000,     6.000,     0.000,     -99.000,   -99.000,   -99.000,   79.000,
    7.000,     21.000,    9.000,     21.000,    9.000,     21.000,    12.000,    20.000,
    12.000,    20.000,    14.000,    18.000,    14.000,    18.000,    15.000,    16.000,
    15.000,    16.000,    16.000,    12.000,    16.000,    12.000,    16.000,    9.000,
    16.000,    9.000,     15.000,    5.000,     15.000,    5.000,     14.000,    3.000,
    14.000,    3.000,     12.000,    1.000,     12.000,    1.000,     9.000,     0.000,
    9.000,     0.000,     7.000,     0.000,     7.000,     0.000,     4.000,     1.000,
    4.000,     1.000,     2.000,     3.000,     2.000,     3.000,     1.000,     5.000,
    1.000,     5.000,     0.000,     9.000,     0.000,     9.000,     0.000,     12.000,
    0.000,     12.000,    1.000,     16.000,    1.000,     16.000,    2.000,     18.000,
    2.000,     18.000,    4.000,     20.000,    4.000,     20.000,    7.000,     21.000,
    7.000,     21.000,    5.000,     20.000,    5.000,     20.000,    3.000,     18.000,
    3.000,     18.000,    2.000,     16.000,    2.000,     16.000,    1.000,     12.000,
    1.000,     12.000,    1.000,     9.000,     1.000,     9.000,     2.000,     5.000,
    2.000,     5.000,     3.000,     3.000,     3.000,     3.000,     5.000,     1.000,
    5.000,     1.000,     7.000,     0.000,     9.000,     0.000,     11.000,    1.000,
    11.000,    1.000,     13.000,    3.000,     13.000,    3.000,     14.000,    5.000,
    14.000,    5.000,     15.000,    9.000,     15.000,    9.000,     15.000,    12.000,
    15.000,    12.000,    14.000,    16.000,    14.000,    16.000,    13.000,    18.000,
    13.000,    18.000,    11.000,    20.000,    11.000,    20.000,    9.000,     21.000,
    -99.000,   -99.000,   -99.000,   80.000,    3.000,     21.000,    3.000,     0.000,
    4.000,     21.000,    4.000,     0.000,     16.000,    21.000,    16.000,    0.000,
    17.000,    21.000,    17.000,    0.000,     0.000,     21.000,    20.000,    21.000,
    0.000,     0.000,     7.000,     0.000,     13.000,    0.000,     20.000,    0.000,
    -99.000,   -99.000,   -99.000,   81.000,    7.000,     21.000,    9.000,     21.000,
    9.000,     21.000,    12.000,    20.000,    12.000,    20.000,    14.000,    18.000,
    14.000,    18.000,    15.000,    16.000,    15.000,    16.000,    16.000,    12.000,
    16.000,    12.000,    16.000,    9.000,     16.000,    9.000,     15.000,    5.000,
    15.000,    5.000,     14.000,    3.000,     14.000,    3.000,     12.000,    1.000,
    12.000,    1.000,     9.000,     0.000,     9.000,     0.000,     7.000,     0.000,
    7.000,     0.000,     4.000,     1.000,     4.000,     1.000,     2.000,     3.000,
    2.000,     3.000,     1.000,     5.000,     1.000,     5.000,     0.000,     9.000,
    0.000,     9.000,     0.000,     12.000,    0.000,     12.000,    1.000,     16.000,
    1.000,     16.000,    2.000,     18.000,    2.000,     18.000,    4.000,     20.000,
    4.000,     20.000,    7.000,     21.000,    7.000,     21.000,    5.000,     20.000,
    5.000,     20.000,    3.000,     18.000,    3.000,     18.000,    2.000,     16.000,
    2.000,     16.000,    1.000,     12.000,    1.000,     12.000,    1.000,     9.000,
    1.000,     9.000,     2.000,     5.000,     2.000,     5.000,     3.000,     3.000,
    3.000,     3.000,     5.000,     1.000,     5.000,     1.000,     7.000,     0.000,
    9.000,     0.000,     11.000,    1.000,     11.000,    1.000,     13.000,    3.000,
    13.000,    3.000,     14.000,    5.000,     14.000,    5.000,     15.000,    9.000,
    15.000,    9.000,     15.000,    12.000,    15.000,    12.000,    14.000,    16.000,
    14.000,    16.000,    13.000,    18.000,    13.000,    18.000,    11.000,    20.000,
    11.000,    20.000,    9.000,     21.000,    5.000,     14.000,    5.000,     7.000,
    11.000,    14.000,    11.000,    7.000,     5.000,     11.000,    11.000,    11.000,
    5.000,     10.000,    11.000,    10.000,    -99.000,   -99.000,   -99.000,   82.000,
    3.000,     21.000,    3.000,     0.000,     4.000,     21.000,    4.000,     0.000,
    0.000,     21.000,    12.000,    21.000,    12.000,    21.000,    15.000,    20.000,
    15.000,    20.000,    16.000,    19.000,    16.000,    19.000,    17.000,    17.000,
    17.000,    17.000,    17.000,    14.000,    17.000,    14.000,    16.000,    12.000,
    16.000,    12.000,    15.000,    11.000,    15.000,    11.000,    12.000,    10.000,
    12.000,    10.000,    4.000,     10.000,    12.000,    21.000,    14.000,    20.000,
    14.000,    20.000,    15.000,    19.000,    15.000,    19.000,    16.000,    17.000,
    16.000,    17.000,    16.000,    14.000,    16.000,    14.000,    15.000,    12.000,
    15.000,    12.000,    14.000,    11.000,    14.000,    11.000,    12.000,    10.000,
    0.000,     0.000,     7.000,     0.000,     -99.000,   -99.000,   -99.000,   83.000,
    7.000,     11.000,    0.000,     21.000,    0.000,     21.000,    15.000,    21.000,
    15.000,    21.000,    16.000,    15.000,    16.000,    15.000,    14.000,    21.000,
    1.000,     21.000,    8.000,     11.000,    8.000,     11.000,    0.000,     0.000,
    0.000,     0.000,     15.000,    0.000,     15.000,    0.000,     16.000,    6.000,
    16.000,    6.000,     14.000,    0.000,     1.000,     1.000,     14.000,    1.000,
    -99.000,   -99.000,   -99.000,   84.000,    7.000,     21.000,    7.000,     0.000,
    8.000,     21.000,    8.000,     0.000,     1.000,     21.000,    0.000,     15.000,
    0.000,     15.000,    0.000,     21.000,    0.000,     21.000,    15.000,    21.000,
    15.000,    21.000,    15.000,    15.000,    15.000,    15.000,    14.000,    21.000,
    4.000,     0.000,     11.000,    0.000,     -99.000,   -99.000,   -99.000,   85.000,
    0.000,     16.000,    0.000,     18.000,    0.000,     18.000,    1.000,     20.000,
    1.000,     20.000,    2.000,     21.000,    2.000,     21.000,    4.000,     21.000,
    4.000,     21.000,    5.000,     20.000,    5.000,     20.000,    6.000,     18.000,
    6.000,     18.000,    7.000,     14.000,    7.000,     14.000,    7.000,     0.000,
    0.000,     18.000,    2.000,     20.000,    2.000,     20.000,    4.000,     20.000,
    4.000,     20.000,    6.000,     18.000,    15.000,    16.000,    15.000,    18.000,
    15.000,    18.000,    14.000,    20.000,    14.000,    20.000,    13.000,    21.000,
    13.000,    21.000,    11.000,    21.000,    11.000,    21.000,    10.000,    20.000,
    10.000,    20.000,    9.000,     18.000,    9.000,     18.000,    8.000,     14.000,
    8.000,     14.000,    8.000,     0.000,     15.000,    18.000,    13.000,    20.000,
    13.000,    20.000,    11.000,    20.000,    11.000,    20.000,    9.000,     18.000,
    4.000,     0.000,     11.000,    0.000,     -99.000,   -99.000,   -99.000,   86.000,
    2.000,     21.000,    9.000,     0.000,     9.000,     0.000,     16.000,    21.000,
    3.000,     21.000,    9.000,     3.000,     0.000,     21.000,    6.000,     21.000,
    12.000,    21.000,    18.000,    21.000,    -99.000,   -99.000,   -99.000,   87.000,
    0.000,     3.000,     1.000,     0.000,     1.000,     0.000,     5.000,     0.000,
    5.000,     0.000,     3.000,     4.000,     3.000,     4.000,     1.000,     8.000,
    1.000,     8.000,     0.000,     11.000,    0.000,     11.000,    0.000,     15.000,
    0.000,     15.000,    1.000,     18.000,    1.000,     18.000,    3.000,     20.000,
    3.000,     20.000,    6.000,     21.000,    6.000,     21.000,    10.000,    21.000,
    10.000,    21.000,    13.000,    20.000,    13.000,    20.000,    15.000,    18.000,
    15.000,    18.000,    16.000,    15.000,    16.000,    15.000,    16.000,    11.000,
    16.000,    11.000,    15.000,    8.000,     15.000,    8.000,     13.000,    4.000,
    13.000,    4.000,     11.000,    0.000,     11.000,    0.000,     15.000,    0.000,
    15.000,    0.000,     16.000,    3.000,     3.000,     4.000,     2.000,     7.000,
    2.000,     7.000,     1.000,     11.000,    1.000,     11.000,    1.000,     15.000,
    1.000,     15.000,    2.000,     18.000,    2.000,     18.000,    4.000,     20.000,
    4.000,     20.000,    6.000,     21.000,    10.000,    21.000,    12.000,    20.000,
    12.000,    20.000,    14.000,    18.000,    14.000,    18.000,    15.000,    15.000,
    15.000,    15.000,    15.000,    11.000,    15.000,    11.000,    14.000,    7.000,
    14.000,    7.000,     13.000,    4.000,     1.000,     1.000,     4.000,     1.000,
    12.000,    1.000,     15.000,    1.000,     -99.000,   -99.000,   -99.000,   88.000,
    1.000,     22.000,    0.000,     17.000,    16.000,    22.000,    15.000,    17.000,
    5.000,     13.000,    4.000,     8.000,     12.000,    13.000,    11.000,    8.000,
    1.000,     4.000,     0.000,     -1.000,    16.000,    4.000,     15.000,    -1.000,
    1.000,     20.000,    15.000,    20.000,    1.000,     19.000,    15.000,    19.000,
    5.000,     11.000,    11.000,    11.000,    5.000,     10.000,    11.000,    10.000,
    1.000,     2.000,     15.000,    2.000,     1.000,     1.000,     15.000,    1.000,
    -99.000,   -99.000,   -99.000,   89.000,    9.000,     21.000,    9.000,     0.000,
    10.000,    21.000,    10.000,    0.000,     0.000,     14.000,    1.000,     15.000,
    1.000,     15.000,    3.000,     14.000,    3.000,     14.000,    4.000,     10.000,
    4.000,     10.000,    5.000,     8.000,     5.000,     8.000,     6.000,     7.000,
    6.000,     7.000,     8.000,     6.000,     1.000,     15.000,    2.000,     14.000,
    2.000,     14.000,    3.000,     10.000,    3.000,     10.000,    4.000,     8.000,
    4.000,     8.000,     5.000,     7.000,     5.000,     7.000,     8.000,     6.000,
    8.000,     6.000,     11.000,    6.000,     11.000,    6.000,     14.000,    7.000,
    14.000,    7.000,     15.000,    8.000,     15.000,    8.000,     16.000,    10.000,
    16.000,    10.000,    17.000,    14.000,    17.000,    14.000,    18.000,    15.000,
    11.000,    6.000,     13.000,    7.000,     13.000,    7.000,     14.000,    8.000,
    14.000,    8.000,     15.000,    10.000,    15.000,    10.000,    16.000,    14.000,
    16.000,    14.000,    18.000,    15.000,    18.000,    15.000,    19.000,    14.000,
    6.000,     21.000,    13.000,    21.000,    6.000,     0.000,     13.000,    0.000,
    -99.000,   -99.000,   -99.000,   90.000,    1.000,     0.000,     14.000,    21.000,
    14.000,    21.000,    0.000,     21.000,    0.000,     21.000,    0.000,     15.000,
    0.000,     15.000,    1.000,     21.000,    13.000,    21.000,    0.000,     0.000,
    0.000,     0.000,     14.000,    0.000,     14.000,    0.000,     14.000,    6.000,
    14.000,    6.000,     13.000,    0.000,     -99.00,    -99.00,    -99.00,    91.00,
    1.00,      25.00,     1.00,      -7.00,     7.00,      25.00,     0.00,      25.00,
    0.00,      25.00,     0.00,      -7.00,     0.00,      -7.00,     7.00,      -7.00,
    -99.00,    -99.00,    -99.00,    92.00,     3.00,      25.00,     21.00,     -7.00,
    -99.00,    -99.00,    -99.00,    93.00,     6.00,      25.00,     6.00,      -7.00,
    0.00,      25.00,     7.00,      25.00,     7.00,      25.00,     7.00,      -7.00,
    7.00,      -7.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    94.00,
    0.00,      16.00,     8.00,      21.00,     8.00,      21.00,     16.00,     16.00,
    16.00,     16.00,     8.00,      20.00,     8.00,      20.00,     0.00,      16.00,
    -99.00,    -99.00,    -99.00,    95.00,     21.00,     0.00,      0.00,      0.00,
    -99.00,    -99.00,    -99.00,    96.00,     12.00,     21.00,     17.00,     15.00,
    17.00,     15.00,     11.00,     20.00,     11.00,     20.00,     12.00,     21.00,
    -99.000,   -99.000,   -99.000,   97.000,    16.000,    14.000,    15.000,    11.000,
    15.000,    11.000,    13.000,    7.000,     13.000,    7.000,     11.000,    4.000,
    11.000,    4.000,     8.000,     1.000,     8.000,     1.000,     6.000,     0.000,
    6.000,     0.000,     4.000,     0.000,     4.000,     0.000,     1.000,     1.000,
    1.000,     1.000,     0.000,     3.000,     0.000,     3.000,     0.000,     6.000,
    0.000,     6.000,     1.000,     9.000,     1.000,     9.000,     2.000,     11.000,
    2.000,     11.000,    4.000,     13.000,    4.000,     13.000,    7.000,     14.000,
    7.000,     14.000,    5.000,     13.000,    5.000,     13.000,    3.000,     11.000,
    3.000,     11.000,    2.000,     9.000,     2.000,     9.000,     1.000,     6.000,
    1.000,     6.000,     1.000,     3.000,     1.000,     3.000,     2.000,     1.000,
    2.000,     1.000,     4.000,     0.000,     7.000,     14.000,    9.000,     14.000,
    9.000,     14.000,    11.000,    13.000,    11.000,    13.000,    12.000,    11.000,
    12.000,    11.000,    14.000,    3.000,     14.000,    3.000,     15.000,    1.000,
    15.000,    1.000,     16.000,    0.000,     9.000,     14.000,    10.000,    13.000,
    10.000,    13.000,    11.000,    11.000,    11.000,    11.000,    13.000,    3.000,
    13.000,    3.000,     14.000,    1.000,     14.000,    1.000,     16.000,    0.000,
    16.000,    0.000,     17.000,    0.000,     -99.000,   -99.000,   -99.000,   98.000,
    11.000,    21.000,    13.000,    21.000,    13.000,    21.000,    15.000,    20.000,
    15.000,    20.000,    16.000,    19.000,    16.000,    19.000,    16.000,    16.000,
    16.000,    16.000,    15.000,    14.000,    15.000,    14.000,    14.000,    13.000,
    14.000,    13.000,    11.000,    12.000,    11.000,    12.000,    7.000,     12.000,
    7.000,     12.000,    11.000,    11.000,    11.000,    11.000,    13.000,    9.000,
    13.000,    9.000,     14.000,    7.000,     14.000,    7.000,     14.000,    4.000,
    14.000,    4.000,     13.000,    2.000,     13.000,    2.000,     12.000,    1.000,
    12.000,    1.000,     9.000,     0.000,     9.000,     0.000,     7.000,     0.000,
    7.000,     0.000,     5.000,     1.000,     5.000,     1.000,     4.000,     2.000,
    4.000,     2.000,     3.000,     5.000,     0.000,     -7.000,    1.000,     1.000,
    1.000,     1.000,     2.000,     7.000,     2.000,     7.000,     3.000,     11.000,
    3.000,     11.000,    4.000,     14.000,    4.000,     14.000,    6.000,     18.000,
    6.000,     18.000,    8.000,     20.000,    8.000,     20.000,    11.000,    21.000,
    11.000,    21.000,    9.000,     20.000,    9.000,     20.000,    7.000,     18.000,
    7.000,     18.000,    5.000,     14.000,    5.000,     14.000,    4.000,     11.000,
    4.000,     11.000,    3.000,     7.000,     3.000,     7.000,     2.000,     1.000,
    2.000,     1.000,     1.000,     -7.000,    13.000,    21.000,    15.000,    19.000,
    15.000,    19.000,    15.000,    16.000,    15.000,    16.000,    14.000,    14.000,
    14.000,    14.000,    13.000,    13.000,    13.000,    13.000,    11.000,    12.000,
    7.000,     12.000,    10.000,    11.000,    10.000,    11.000,    12.000,    9.000,
    12.000,    9.000,     13.000,    7.000,     13.000,    7.000,     13.000,    4.000,
    13.000,    4.000,     12.000,    2.000,     12.000,    2.000,     11.000,    1.000,
    11.000,    1.000,     9.000,     0.000,     -99.000,   -99.000,   -99.000,   99.000,
    0.000,     10.000,    1.000,     12.000,    1.000,     12.000,    3.000,     14.000,
    3.000,     14.000,    6.000,     14.000,    6.000,     14.000,    7.000,     13.000,
    7.000,     13.000,    7.000,     11.000,    7.000,     11.000,    6.000,     7.000,
    6.000,     7.000,     4.000,     0.000,     5.000,     14.000,    6.000,     13.000,
    6.000,     13.000,    6.000,     11.000,    6.000,     11.000,    5.000,     7.000,
    5.000,     7.000,     3.000,     0.000,     6.000,     7.000,     8.000,     11.000,
    8.000,     11.000,    10.000,    13.000,    10.000,    13.000,    12.000,    14.000,
    12.000,    14.000,    14.000,    14.000,    14.000,    14.000,    16.000,    13.000,
    16.000,    13.000,    17.000,    12.000,    17.000,    12.000,    17.000,    9.000,
    17.000,    9.000,     16.000,    4.000,     16.000,    4.000,     13.000,    -7.000,
    14.000,    14.000,    16.000,    12.000,    16.000,    12.000,    16.000,    9.000,
    16.000,    9.000,     15.000,    4.000,     15.000,    4.000,     12.000,    -7.000,
    -99.000,   -99.000,   -99.000,   100.000,   10.000,    13.000,    8.000,     14.000,
    8.000,     14.000,    6.000,     14.000,    6.000,     14.000,    3.000,     13.000,
    3.000,     13.000,    1.000,     10.000,    1.000,     10.000,    0.000,     7.000,
    0.000,     7.000,     0.000,     4.000,     0.000,     4.000,     1.000,     2.000,
    1.000,     2.000,     2.000,     1.000,     2.000,     1.000,     4.000,     0.000,
    4.000,     0.000,     6.000,     0.000,     6.000,     0.000,     9.000,     1.000,
    9.000,     1.000,     11.000,    4.000,     11.000,    4.000,     12.000,    7.000,
    12.000,    7.000,     12.000,    10.000,    12.000,    10.000,    11.000,    12.000,
    11.000,    12.000,    7.000,     17.000,    7.000,     17.000,    6.000,     19.000,
    6.000,     19.000,    6.000,     21.000,    6.000,     21.000,    7.000,     22.000,
    7.000,     22.000,    9.000,     22.000,    9.000,     22.000,    11.000,    21.000,
    11.000,    21.000,    13.000,    19.000,    13.000,    19.000,    10.000,    21.000,
    10.000,    21.000,    8.000,     21.000,    8.000,     21.000,    7.000,     20.000,
    7.000,     20.000,    7.000,     18.000,    7.000,     18.000,    8.000,     16.000,
    8.000,     16.000,    10.000,    13.000,    10.000,    13.000,    11.000,    11.000,
    11.000,    11.000,    11.000,    7.000,     11.000,    7.000,     10.000,    4.000,
    10.000,    4.000,     8.000,     1.000,     8.000,     1.000,     6.000,     0.000,
    6.000,     14.000,    4.000,     13.000,    4.000,     13.000,    2.000,     10.000,
    2.000,     10.000,    1.000,     7.000,     1.000,     7.000,     1.000,     3.000,
    1.000,     3.000,     2.000,     1.000,     -99.000,   -99.000,   -99.000,   101.000,
    11.000,    3.000,     9.000,     1.000,     9.000,     1.000,     7.000,     0.000,
    7.000,     0.000,     4.000,     0.000,     4.000,     0.000,     1.000,     1.000,
    1.000,     1.000,     0.000,     3.000,     0.000,     3.000,     0.000,     5.000,
    0.000,     5.000,     2.000,     7.000,     2.000,     7.000,     7.000,     8.000,
    7.000,     8.000,     3.000,     7.000,     3.000,     7.000,     1.000,     5.000,
    1.000,     5.000,     1.000,     3.000,     1.000,     3.000,     2.000,     1.000,
    2.000,     1.000,     4.000,     0.000,     12.000,    11.000,    10.000,    13.000,
    10.000,    13.000,    8.000,     14.000,    8.000,     14.000,    4.000,     14.000,
    4.000,     14.000,    2.000,     13.000,    2.000,     13.000,    2.000,     11.000,
    2.000,     11.000,    4.000,     9.000,     4.000,     9.000,     7.000,     8.000,
    7.000,     8.000,     5.000,     9.000,     5.000,     9.000,     3.000,     11.000,
    3.000,     11.000,    3.000,     13.000,    3.000,     13.000,    4.000,     14.000,
    -99.000,   -99.000,   -99.000,   102.000,   5.000,     13.000,    3.000,     12.000,
    3.000,     12.000,    1.000,     10.000,    1.000,     10.000,    0.000,     7.000,
    0.000,     7.000,     0.000,     4.000,     0.000,     4.000,     1.000,     2.000,
    1.000,     2.000,     2.000,     1.000,     2.000,     1.000,     4.000,     0.000,
    4.000,     0.000,     7.000,     0.000,     7.000,     0.000,     10.000,    1.000,
    10.000,    1.000,     13.000,    3.000,     13.000,    3.000,     15.000,    6.000,
    15.000,    6.000,     16.000,    9.000,     16.000,    9.000,     16.000,    12.000,
    16.000,    12.000,    14.000,    14.000,    14.000,    14.000,    12.000,    14.000,
    12.000,    14.000,    10.000,    12.000,    10.000,    12.000,    8.000,     8.000,
    8.000,     8.000,     6.000,     3.000,     6.000,     3.000,     3.000,     -7.000,
    0.000,     4.000,     2.000,     2.000,     2.000,     2.000,     4.000,     1.000,
    4.000,     1.000,     7.000,     1.000,     7.000,     1.000,     10.000,    2.000,
    10.000,    2.000,     13.000,    4.000,     13.000,    4.000,     15.000,    6.000,
    16.000,    12.000,    14.000,    13.000,    14.000,    13.000,    12.000,    13.000,
    12.000,    13.000,    10.000,    11.000,    10.000,    11.000,    8.000,     8.000,
    8.000,     8.000,     6.000,     2.000,     6.000,     2.000,     4.000,     -7.000,
    -99.000,   -99.000,   -99.000,   103.000,   0.000,     11.000,    2.000,     13.000,
    2.000,     13.000,    4.000,     14.000,    4.000,     14.000,    6.000,     14.000,
    6.000,     14.000,    8.000,     13.000,    8.000,     13.000,    9.000,     12.000,
    9.000,     12.000,    10.000,    9.000,     10.000,    9.000,     10.000,    5.000,
    10.000,    5.000,     9.000,     1.000,     9.000,     1.000,     6.000,     -7.000,
    1.000,     12.000,    3.000,     13.000,    3.000,     13.000,    7.000,     13.000,
    7.000,     13.000,    9.000,     12.000,    17.000,    14.000,    16.000,    11.000,
    16.000,    11.000,    15.000,    9.000,     15.000,    9.000,     10.000,    2.000,
    10.000,    2.000,     7.000,     -3.000,    7.000,     -3.000,    5.000,     -7.000,
    16.000,    14.000,    15.000,    11.000,    15.000,    11.000,    14.000,    9.000,
    14.000,    9.000,     10.000,    2.000,     -99.000,   -99.000,   -99.000,   104.000,
    1.000,     14.000,    3.000,     14.000,    3.000,     14.000,    5.000,     13.000,
    5.000,     13.000,    6.000,     11.000,    6.000,     11.000,    11.000,    -4.000,
    11.000,    -4.000,    12.000,    -6.000,    12.000,    -6.000,    13.000,    -7.000,
    3.000,     14.000,    4.000,     13.000,    4.000,     13.000,    5.000,     11.000,
    5.000,     11.000,    10.000,    -4.000,    10.000,    -4.000,    11.000,    -6.000,
    11.000,    -6.000,    13.000,    -7.000,    13.000,    -7.000,    15.000,    -7.000,
    16.000,    14.000,    15.000,    12.000,    15.000,    12.000,    13.000,    9.000,
    13.000,    9.000,     3.000,     -2.000,    3.000,     -2.000,    1.000,     -5.000,
    1.000,     -5.000,    0.000,     -7.000,    -99.000,   -99.000,   -99.000,   105.000,
    3.000,     14.000,    1.000,     7.000,     1.000,     7.000,     0.000,     3.000,
    0.000,     3.000,     0.000,     1.000,     0.000,     1.000,     1.000,     0.000,
    1.000,     0.000,     4.000,     0.000,     4.000,     0.000,     6.000,     2.000,
    6.000,     2.000,     7.000,     4.000,     4.000,     14.000,    2.000,     7.000,
    2.000,     7.000,     1.000,     3.000,     1.000,     3.000,     1.000,     1.000,
    1.000,     1.000,     2.000,     0.000,     -99.000,   -99.000,   -99.000,   106.000,
    11.000,    13.000,    9.000,     14.000,    9.000,     14.000,    6.000,     14.000,
    6.000,     14.000,    3.000,     13.000,    3.000,     13.000,    1.000,     11.000,
    1.000,     11.000,    0.000,     8.000,     0.000,     8.000,     0.000,     5.000,
    0.000,     5.000,     1.000,     2.000,     1.000,     2.000,     2.000,     1.000,
    2.000,     1.000,     5.000,     0.000,     5.000,     0.000,     8.000,     0.000,
    8.000,     0.000,     10.000,    1.000,     6.000,     14.000,    4.000,     13.000,
    4.000,     13.000,    2.000,     11.000,    2.000,     11.000,    1.000,     8.000,
    1.000,     8.000,     1.000,     5.000,     1.000,     5.000,     2.000,     2.000,
    2.000,     2.000,     3.000,     1.000,     3.000,     1.000,     5.000,     0.000,
    1.000,     7.000,     9.000,     7.000,     -99.000,   -99.000,   -99.000,   107.000,
    10.000,    0.000,     9.000,     1.000,     9.000,     1.000,     7.000,     7.000,
    7.000,     7.000,     5.000,     8.000,     5.000,     8.000,     6.000,     7.000,
    6.000,     7.000,     8.000,     1.000,     8.000,     1.000,     9.000,     0.000,
    9.000,     0.000,     11.000,    0.000,     11.000,    0.000,     13.000,    1.000,
    13.000,    1.000,     15.000,    4.000,     4.000,     14.000,    0.000,     0.000,
    5.000,     14.000,    1.000,     0.000,     14.000,    14.000,    15.000,    13.000,
    15.000,    13.000,    16.000,    13.000,    16.000,    13.000,    15.000,    14.000,
    15.000,    14.000,    13.000,    14.000,    13.000,    14.000,    11.000,    13.000,
    11.000,    13.000,    7.000,     9.000,     7.000,     9.000,     5.000,     8.000,
    5.000,     8.000,     3.000,     8.000,     -99.000,   -99.000,   -99.000,   108.000,
    0.000,     0.000,     8.000,     14.000,    8.000,     14.000,    1.000,     0.000,
    1.000,     21.000,    3.000,     21.000,    3.000,     21.000,    5.000,     20.000,
    5.000,     20.000,    6.000,     19.000,    6.000,     19.000,    7.000,     17.000,
    7.000,     17.000,    13.000,    3.000,     13.000,    3.000,     14.000,    1.000,
    14.000,    1.000,     15.000,    0.000,     3.000,     21.000,    5.000,     19.000,
    5.000,     19.000,    6.000,     17.000,    6.000,     17.000,    12.000,    3.000,
    12.000,    3.000,     13.000,    1.000,     13.000,    1.000,     15.000,    0.000,
    15.000,    0.000,     16.000,    0.000,     -99.000,   -99.000,   -99.000,   109.000,
    6.000,     14.000,    0.000,     -7.000,    7.000,     14.000,    1.000,     -7.000,
    6.000,     11.000,    5.000,     5.000,     5.000,     5.000,     5.000,     2.000,
    5.000,     2.000,     7.000,     0.000,     7.000,     0.000,     9.000,     0.000,
    9.000,     0.000,     11.000,    1.000,     11.000,    1.000,     13.000,    3.000,
    13.000,    3.000,     15.000,    6.000,     17.000,    14.000,    14.000,    3.000,
    14.000,    3.000,     14.000,    1.000,     14.000,    1.000,     15.000,    0.000,
    15.000,    0.000,     18.000,    0.000,     18.000,    0.000,     20.000,    2.000,
    20.000,    2.000,     21.000,    4.000,     18.000,    14.000,    15.000,    3.000,
    15.000,    3.000,     15.000,    1.000,     15.000,    1.000,     16.000,    0.000,
    -99.000,   -99.000,   -99.000,   110.000,   3.000,     14.000,    1.000,     0.000,
    1.000,     0.000,     2.000,     3.000,     2.000,     3.000,     3.000,     8.000,
    3.000,     8.000,     4.000,     14.000,    4.000,     14.000,    0.000,     14.000,
    14.000,    14.000,    13.000,    10.000,    13.000,    10.000,    11.000,    6.000,
    15.000,    14.000,    14.000,    11.000,    14.000,    11.000,    13.000,    9.000,
    13.000,    9.000,     11.000,    6.000,     11.000,    6.000,     9.000,     4.000,
    9.000,     4.000,     6.000,     2.000,     6.000,     2.000,     4.000,     1.000,
    4.000,     1.000,     1.000,     0.000,     -99.000,   -99.000,   -99.000,   111.000,
    6.000,     14.000,    8.000,     14.000,    8.000,     14.000,    10.000,    13.000,
    10.000,    13.000,    11.000,    12.000,    11.000,    12.000,    12.000,    10.000,
    12.000,    10.000,    12.000,    7.000,     12.000,    7.000,     11.000,    4.000,
    11.000,    4.000,     9.000,     1.000,     9.000,     1.000,     6.000,     0.000,
    6.000,     0.000,     4.000,     0.000,     4.000,     0.000,     2.000,     1.000,
    2.000,     1.000,     1.000,     2.000,     1.000,     2.000,     0.000,     4.000,
    0.000,     4.000,     0.000,     7.000,     0.000,     7.000,     1.000,     10.000,
    1.000,     10.000,    3.000,     13.000,    3.000,     13.000,    6.000,     14.000,
    6.000,     14.000,    4.000,     13.000,    4.000,     13.000,    2.000,     10.000,
    2.000,     10.000,    1.000,     7.000,     1.000,     7.000,     1.000,     3.000,
    1.000,     3.000,     2.000,     1.000,     6.000,     0.000,     8.000,     1.000,
    8.000,     1.000,     10.000,    4.000,     10.000,    4.000,     11.000,    7.000,
    11.000,    7.000,     11.000,    11.000,    11.000,    11.000,    10.000,    13.000,
    -99.000,   -99.000,   -99.000,   112.000,   18.000,    14.000,    5.000,     14.000,
    5.000,     14.000,    2.000,     13.000,    2.000,     13.000,    0.000,     11.000,
    0.000,     11.000,    2.000,     12.000,    2.000,     12.000,    5.000,     13.000,
    5.000,     13.000,    18.000,    13.000,    13.000,    0.000,     13.000,    13.000,
    13.000,    13.000,    14.000,    0.000,     3.000,     0.000,     7.000,     13.000,
    7.000,     13.000,    4.000,     0.000,     -99.000,   -99.000,   -99.000,   113.000,
    8.000,     21.000,    10.000,    21.000,    10.000,    21.000,    12.000,    20.000,
    12.000,    20.000,    13.000,    18.000,    13.000,    18.000,    13.000,    14.000,
    13.000,    14.000,    12.000,    9.000,     12.000,    9.000,     11.000,    6.000,
    11.000,    6.000,     10.000,    4.000,     10.000,    4.000,     8.000,     1.000,
    8.000,     1.000,     5.000,     0.000,     5.000,     0.000,     3.000,     0.000,
    3.000,     0.000,     1.000,     1.000,     1.000,     1.000,     0.000,     3.000,
    0.000,     3.000,     0.000,     7.000,     0.000,     7.000,     1.000,     12.000,
    1.000,     12.000,    2.000,     15.000,    2.000,     15.000,    3.000,     17.000,
    3.000,     17.000,    5.000,     20.000,    5.000,     20.000,    8.000,     21.000,
    8.000,     21.000,    6.000,     20.000,    6.000,     20.000,    4.000,     17.000,
    4.000,     17.000,    3.000,     15.000,    3.000,     15.000,    2.000,     12.000,
    2.000,     12.000,    1.000,     7.000,     1.000,     7.000,     1.000,     3.000,
    1.000,     3.000,     2.000,     1.000,     2.000,     1.000,     3.000,     0.000,
    5.000,     0.000,     7.000,     1.000,     7.000,     1.000,     9.000,     4.000,
    9.000,     4.000,     10.000,    6.000,     10.000,    6.000,     11.000,    9.000,
    11.000,    9.000,     12.000,    14.000,    12.000,    14.000,    12.000,    18.000,
    12.000,    18.000,    11.000,    20.000,    11.000,    20.000,    10.000,    21.000,
    2.000,     11.000,    11.000,    11.000,    -99.000,   -99.000,   -99.000,   114.000,
    4.000,     5.000,     5.000,     2.000,     5.000,     2.000,     6.000,     1.000,
    6.000,     1.000,     8.000,     0.000,     8.000,     0.000,     10.000,    0.000,
    10.000,    0.000,     13.000,    1.000,     13.000,    1.000,     15.000,    4.000,
    15.000,    4.000,     16.000,    7.000,     16.000,    7.000,     16.000,    10.000,
    16.000,    10.000,    15.000,    12.000,    15.000,    12.000,    14.000,    13.000,
    14.000,    13.000,    12.000,    14.000,    12.000,    14.000,    10.000,    14.000,
    10.000,    14.000,    7.000,     13.000,    7.000,     13.000,    5.000,     10.000,
    5.000,     10.000,    4.000,     7.000,     4.000,     7.000,     0.000,     -7.000,
    10.000,    0.000,     12.000,    1.000,     12.000,    1.000,     14.000,    4.000,
    14.000,    4.000,     15.000,    7.000,     15.000,    7.000,     15.000,    11.000,
    15.000,    11.000,    14.000,    13.000,    10.000,    14.000,    8.000,     13.000,
    8.000,     13.000,    6.000,     10.000,    6.000,     10.000,    5.000,     7.000,
    5.000,     7.000,     1.000,     -7.000,    -99.000,   -99.000,   -99.000,   115.000,
    6.000,     0.000,     8.000,     1.000,     8.000,     1.000,     10.000,    4.000,
    10.000,    4.000,     11.000,    7.000,     11.000,    7.000,     11.000,    11.000,
    11.000,    11.000,    10.000,    13.000,    10.000,    13.000,    16.000,    13.000,
    16.000,    14.000,    6.000,     14.000,    6.000,     14.000,    3.000,     13.000,
    3.000,     13.000,    1.000,     10.000,    1.000,     10.000,    0.000,     7.000,
    0.000,     7.000,     0.000,     4.000,     0.000,     4.000,     1.000,     2.000,
    1.000,     2.000,     2.000,     1.000,     2.000,     1.000,     4.000,     0.000,
    4.000,     0.000,     6.000,     0.000,     6.000,     0.000,     9.000,     1.000,
    9.000,     1.000,     11.000,    4.000,     11.000,    4.000,     12.000,    7.000,
    12.000,    7.000,     12.000,    10.000,    12.000,    10.000,    11.000,    12.000,
    11.000,    12.000,    10.000,    13.000,    10.000,    13.000,    8.000,     14.000,
    6.000,     14.000,    4.000,     13.000,    4.000,     13.000,    2.000,     10.000,
    2.000,     10.000,    1.000,     7.000,     1.000,     7.000,     1.000,     3.000,
    1.000,     3.000,     2.000,     1.000,     -99.000,   -99.000,   -99.000,   116.000,
    16.000,    14.000,    5.000,     14.000,    5.000,     14.000,    2.000,     13.000,
    2.000,     13.000,    0.000,     11.000,    0.000,     11.000,    2.000,     12.000,
    2.000,     12.000,    5.000,     13.000,    5.000,     13.000,    16.000,    13.000,
    6.000,     0.000,     9.000,     13.000,    9.000,     13.000,    7.000,     0.000,
    -99.000,   -99.000,   -99.000,   117.000,   0.000,     10.000,    1.000,     12.000,
    1.000,     12.000,    3.000,     14.000,    3.000,     14.000,    6.000,     14.000,
    6.000,     14.000,    7.000,     13.000,    7.000,     13.000,    7.000,     11.000,
    7.000,     11.000,    5.000,     5.000,     5.000,     5.000,     5.000,     2.000,
    5.000,     2.000,     7.000,     0.000,     5.000,     14.000,    6.000,     13.000,
    6.000,     13.000,    6.000,     11.000,    6.000,     11.000,    4.000,     5.000,
    4.000,     5.000,     4.000,     2.000,     4.000,     2.000,     5.000,     1.000,
    5.000,     1.000,     7.000,     0.000,     7.000,     0.000,     8.000,     0.000,
    8.000,     0.000,     11.000,    1.000,     11.000,    1.000,     13.000,    3.000,
    13.000,    3.000,     15.000,    6.000,     15.000,    6.000,     16.000,    9.000,
    16.000,    9.000,     16.000,    12.000,    16.000,    12.000,    15.000,    14.000,
    15.000,    14.000,    14.000,    13.000,    14.000,    13.000,    15.000,    12.000,
    15.000,    12.000,    16.000,    9.000,     15.000,    6.000,     16.000,    12.000,
    -99.000,   -99.000,   -99.000,   118.000,   7.000,     14.000,    10.000,    14.000,
    10.000,    14.000,    13.000,    13.000,    13.000,    13.000,    15.000,    11.000,
    15.000,    11.000,    16.000,    9.000,     16.000,    9.000,     16.000,    6.000,
    16.000,    6.000,     15.000,    3.000,     15.000,    3.000,     13.000,    1.000,
    13.000,    1.000,     9.000,     0.000,     9.000,     0.000,     6.000,     0.000,
    6.000,     0.000,     3.000,     1.000,     3.000,     1.000,     1.000,     3.000,
    1.000,     3.000,     0.000,     5.000,     0.000,     5.000,     0.000,     8.000,
    0.000,     8.000,     1.000,     11.000,    1.000,     11.000,    3.000,     13.000,
    3.000,     13.000,    7.000,     14.000,    7.000,     14.000,    4.000,     13.000,
    4.000,     13.000,    2.000,     11.000,    2.000,     11.000,    1.000,     8.000,
    1.000,     8.000,     1.000,     5.000,     1.000,     5.000,     2.000,     3.000,
    2.000,     3.000,     4.000,     1.000,     4.000,     1.000,     6.000,     0.000,
    11.000,    21.000,    5.000,     -7.000,    12.000,    21.000,    4.000,     -7.000,
    9.000,     0.000,     12.000,    1.000,     12.000,    1.000,     14.000,    3.000,
    14.000,    3.000,     15.000,    6.000,     15.000,    6.000,     15.000,    9.000,
    15.000,    9.000,     14.000,    11.000,    14.000,    11.000,    12.000,    13.000,
    12.000,    13.000,    10.000,    14.000,    -99.000,   -99.000,   -99.000,   119.000,
    0.000,     4.000,     1.000,     2.000,     1.000,     2.000,     2.000,     1.000,
    2.000,     1.000,     4.000,     1.000,     4.000,     1.000,     6.000,     2.000,
    6.000,     2.000,     8.000,     4.000,     8.000,     4.000,     9.000,     2.000,
    9.000,     2.000,     10.000,    1.000,     10.000,    1.000,     12.000,    1.000,
    12.000,    1.000,     14.000,    2.000,     14.000,    2.000,     16.000,    4.000,
    1.000,     10.000,    3.000,     12.000,    3.000,     12.000,    6.000,     13.000,
    6.000,     13.000,    5.000,     14.000,    5.000,     14.000,    3.000,     13.000,
    3.000,     13.000,    1.000,     10.000,    1.000,     10.000,    0.000,     7.000,
    0.000,     7.000,     0.000,     4.000,     0.000,     4.000,     1.000,     1.000,
    1.000,     1.000,     2.000,     0.000,     2.000,     0.000,     4.000,     0.000,
    4.000,     0.000,     6.000,     1.000,     6.000,     1.000,     8.000,     4.000,
    8.000,     4.000,     9.000,     7.000,     8.000,     7.000,     8.000,     4.000,
    8.000,     4.000,     9.000,     1.000,     9.000,     1.000,     10.000,    0.000,
    10.000,    0.000,     12.000,    0.000,     12.000,    0.000,     14.000,    1.000,
    14.000,    1.000,     16.000,    4.000,     16.000,    4.000,     17.000,    7.000,
    17.000,    7.000,     17.000,    10.000,    17.000,    10.000,    16.000,    13.000,
    16.000,    13.000,    15.000,    14.000,    15.000,    14.000,    14.000,    13.000,
    14.000,    13.000,    16.000,    12.000,    16.000,    12.000,    17.000,    10.000,
    -99.000,   -99.000,   -99.000,   120.000,   10.000,    7.000,     7.000,     7.000,
    7.000,     7.000,     4.000,     8.000,     4.000,     8.000,     2.000,     10.000,
    2.000,     10.000,    2.000,     12.000,    2.000,     12.000,    3.000,     14.000,
    3.000,     14.000,    5.000,     15.000,    5.000,     15.000,    9.000,     16.000,
    9.000,     16.000,    6.000,     15.000,    6.000,     15.000,    4.000,     14.000,
    4.000,     14.000,    3.000,     12.000,    3.000,     12.000,    3.000,     10.000,
    3.000,     10.000,    5.000,     8.000,     5.000,     8.000,     7.000,     7.000,
    7.000,     7.000,     3.000,     6.000,     3.000,     6.000,     1.000,     5.000,
    1.000,     5.000,     0.000,     3.000,     0.000,     3.000,     0.000,     1.000,
    0.000,     1.000,     2.000,     -1.000,    2.000,     -1.000,    7.000,     -3.000,
    7.000,     -3.000,    8.000,     -4.000,    8.000,     -4.000,    8.000,     -6.000,
    8.000,     -6.000,    6.000,     -7.000,    6.000,     -7.000,    4.000,     -7.000,
    8.000,     21.000,    6.000,     20.000,    6.000,     20.000,    5.000,     19.000,
    5.000,     19.000,    5.000,     18.000,    5.000,     18.000,    6.000,     17.000,
    6.000,     17.000,    9.000,     16.000,    9.000,     16.000,    12.000,    16.000,
    7.000,     7.000,     4.000,     6.000,     4.000,     6.000,     2.000,     5.000,
    2.000,     5.000,     1.000,     3.000,     1.000,     3.000,     1.000,     1.000,
    1.000,     1.000,     3.000,     -1.000,    3.000,     -1.000,    7.000,     -3.000,
    -99.000,   -99.000,   -99.000,   121.000,   14.000,    21.000,    8.000,     -7.000,
    15.000,    21.000,    7.000,     -7.000,    0.000,     10.000,    1.000,     12.000,
    1.000,     12.000,    3.000,     14.000,    3.000,     14.000,    6.000,     14.000,
    6.000,     14.000,    7.000,     13.000,    7.000,     13.000,    7.000,     11.000,
    7.000,     11.000,    6.000,     6.000,     6.000,     6.000,     6.000,     3.000,
    6.000,     3.000,     8.000,     1.000,     8.000,     1.000,     11.000,    1.000,
    11.000,    1.000,     13.000,    2.000,     13.000,    2.000,     16.000,    5.000,
    16.000,    5.000,     18.000,    8.000,     5.000,     14.000,    6.000,     13.000,
    6.000,     13.000,    6.000,     11.000,    6.000,     11.000,    5.000,     6.000,
    5.000,     6.000,     5.000,     3.000,     5.000,     3.000,     6.000,     1.000,
    6.000,     1.000,     8.000,     0.000,     8.000,     0.000,     11.000,    0.000,
    11.000,    0.000,     13.000,    1.000,     13.000,    1.000,     15.000,    3.000,
    15.000,    3.000,     17.000,    6.000,     17.000,    6.000,     18.000,    8.000,
    18.000,    8.000,     20.000,    14.000,    -99.000,   -99.000,   -99.000,   122.000,
    8.000,     21.000,    6.000,     20.000,    6.000,     20.000,    5.000,     19.000,
    5.000,     19.000,    5.000,     18.000,    5.000,     18.000,    6.000,     17.000,
    6.000,     17.000,    9.000,     16.000,    9.000,     16.000,    14.000,    16.000,
    14.000,    16.000,    14.000,    17.000,    14.000,    17.000,    11.000,    16.000,
    11.000,    16.000,    7.000,     14.000,    7.000,     14.000,    4.000,     12.000,
    4.000,     12.000,    1.000,     9.000,     1.000,     9.000,     0.000,     6.000,
    0.000,     6.000,     0.000,     4.000,     0.000,     4.000,     1.000,     2.000,
    1.000,     2.000,     4.000,     0.000,     4.000,     0.000,     7.000,     -2.000,
    7.000,     -2.000,    8.000,     -4.000,    8.000,     -4.000,    8.000,     -6.000,
    8.000,     -6.000,    7.000,     -7.000,    7.000,     -7.000,    5.000,     -7.000,
    5.000,     -7.000,    4.000,     -6.000,    9.000,     15.000,    5.000,     12.000,
    5.000,     12.000,    2.000,     9.000,     2.000,     9.000,     1.000,     6.000,
    1.000,     6.000,     1.000,     4.000,     1.000,     4.000,     2.000,     2.000,
    2.000,     2.000,     4.000,     0.000,     -99.00,    -99.00,    -99.00,    123.00,
    2.00,      23.00,     1.00,      20.00,     1.00,      20.00,     1.00,      16.00,
    1.00,      16.00,     2.00,      13.00,     2.00,      5.00,      1.00,      2.00,
    1.00,      2.00,      1.00,      -2.00,     1.00,      -2.00,     2.00,      -5.00,
    4.00,      25.00,     1.00,      22.00,     1.00,      22.00,     0.00,      19.00,
    0.00,      19.00,     0.00,      17.00,     0.00,      17.00,     1.00,      14.00,
    1.00,      14.00,     4.00,      11.00,     4.00,      11.00,     1.00,      9.00,
    1.00,      9.00,      4.00,      7.00,      4.00,      7.00,      1.00,      4.00,
    1.00,      4.00,      0.00,      1.00,      0.00,      1.00,      0.00,      -1.00,
    0.00,      -1.00,     1.00,      -4.00,     1.00,      -4.00,     4.00,      -7.00,
    -99.00,    -99.00,    -99.00,    124.00,    3.00,      25.00,     3.00,      -7.00,
    -99.00,    -99.00,    -99.00,    125.00,    2.00,      23.00,     3.00,      20.00,
    3.00,      20.00,     3.00,      16.00,     3.00,      16.00,     2.00,      13.00,
    2.00,      5.00,      3.00,      2.00,      3.00,      2.00,      3.00,      -2.00,
    3.00,      -2.00,     2.00,      -5.00,     0.00,      25.00,     3.00,      22.00,
    3.00,      22.00,     4.00,      19.00,     4.00,      19.00,     4.00,      17.00,
    4.00,      17.00,     3.00,      14.00,     3.00,      14.00,     0.00,      11.00,
    0.00,      11.00,     3.00,      9.00,      3.00,      9.00,      0.00,      7.00,
    0.00,      7.00,      3.00,      4.00,      3.00,      4.00,      4.00,      1.00,
    4.00,      1.00,      4.00,      -1.00,     4.00,      -1.00,     3.00,      -4.00,
    3.00,      -4.00,     0.00,      -7.00,     -99.00,    -99.00,    -99.00,    126.00,
    0.00,      6.00,      0.00,      8.00,      0.00,      8.00,      1.00,      11.00,
    1.00,      11.00,     3.00,      12.00,     3.00,      12.00,     5.00,      12.00,
    5.00,      12.00,     7.00,      11.00,     7.00,      11.00,     11.00,     8.00,
    11.00,     8.00,      13.00,     7.00,      13.00,     7.00,      15.00,     7.00,
    15.00,     7.00,      17.00,     8.00,      17.00,     8.00,      18.00,     10.00,
    0.00,      8.00,      1.00,      10.00,     1.00,      10.00,     3.00,      11.00,
    3.00,      11.00,     5.00,      11.00,     5.00,      11.00,     7.00,      10.00,
    7.00,      10.00,     11.00,     7.00,      11.00,     7.00,      13.00,     6.00,
    13.00,     6.00,      15.00,     6.00,      15.00,     6.00,      17.00,     7.00,
    17.00,     7.00,      18.00,     10.00,     18.00,     10.00,     18.00,     12.00,
    -99.00,    -99.00,    -99.00,    127.00,    0.00,      12.00,     1.00,      13.00,
    1.00,      13.00,     3.00,      14.00,     3.00,      14.00,     4.50,      14.50,
    4.50,      14.50,     6.00,      14.00,     6.00,      14.00,     8.00,      13.00,
    8.00,      13.00,     10.00,     11.00,     10.00,     11.00,     12.00,     10.00,
    12.00,     10.00,     13.50,     9.50,      13.50,     9.50,      15.00,     10.00,
    15.00,     10.00,     17.00,     11.00,     17.00,     11.00,     18.00,     12.00,
    0.00,      6.00,      1.00,      7.00,      1.00,      7.00,      3.00,      8.00,
    3.00,      8.00,      4.50,      8.50,      4.50,      8.50,      6.00,      8.00,
    6.00,      8.00,      8.00,      7.00,      8.00,      7.00,      10.00,     5.00,
    10.00,     5.00,      12.00,     4.00,      12.00,     4.00,      13.50,     3.50,
    13.50,     3.50,      15.00,     4.00,      15.00,     4.00,      17.00,     5.00,
    17.00,     5.00,      18.00,     6.00,      -99.00,    -99.00,    -99.00,    999.00};

void INITSTICK(real *data) { memcpy(data, stick_data, sizeof(stick_data)); }

void INITSERIF(real *data) { memcpy(data, serif_data, sizeof(serif_data)); }

void INITROMAN(real *data) { memcpy(data, roman_data, sizeof(roman_data)); }
