use progvis:lang:cpp:ptr;
use progvis:lang:cpp:util;
use core:asm;

Int strlen(ConstPtr<Byte> src) {
	cStrLength(src).int;
}

Ptr<Byte> strcpy(ConstPtr<Byte> src) {
	// Old version, for compatibility.
	strdup(src);
}

Ptr<Byte> strdup(ConstPtr<Byte> src) {
	Int len = strlen(src);

	Ptr<Byte> result = Ptr<Byte>:allocArray(len.nat + 1);
	Nat offset = src.offset - sPtr.current * 2;
	for (Int i = 0; i < len; i++) {
		result.base.markWriteByte(i.nat, src.base.markReadByte(offset + i.nat));
	}
	result.base.markWriteByte(len.nat, 0);

	result;
}

Int strcmp(ConstPtr<Byte> a, ConstPtr<Byte> b) {
	checkPtr(a.base);
	checkPtr(b.base);

	Nat aOffset = a.offset - sPtr.current * 2;
	Nat bOffset = b.offset - sPtr.current * 2;
	Nat aSize = a.base.readSize * a.base.readCount;
	Nat bSize = b.base.readSize * b.base.readCount;

	while (aOffset < aSize & bOffset < bSize) {
		Byte aCh = a.base.markReadByte(aOffset);
		Byte bCh = b.base.markReadByte(bOffset);

		if (aCh != bCh) {
			if (aCh < bCh)
				return -1;
			else
				return 1;
		}

		if (aCh == 0)
			return 0;

		aOffset++;
		bOffset++;
	}

	0;
}
