ITK 5.0.0 Release Notes
=======================

We are happy to announce the Insight Toolkit (ITK) 5.0.0! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.0.0 is a major release that features an incredible number of improvements: This includes major enhancement in the development process, major code refactoring, addition of important features, improvement of ITK Python wrapping, and more.

**Python Packages**

ITK Python packages can be installed by running:

```
pip install itk
```

or to install the conda package, run:

```
conda install -c conda-forge itk
```

**Software Guide**

- [Book 1](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightSoftwareGuide-Book1-5.0.0.pdf)
- [Book 2](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightSoftwareGuide-Book2-5.0.0.pdf)

**Library Sources**

- [InsightToolkit-5.0.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightToolkit-5.0.0.tar.gz)
- [InsightToolkit-5.0.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightToolkit-5.0.0.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.0.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightData-5.0.0.tar.gz)
- [InsightData-5.0.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/InsightData-5.0.0.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0.0/SHA512SUMS)



**ITK on GitHub**

An important step has been taken to faciliate participation of the community in the development of ITK: The official repository was moved to GitHub! This move includes [ITK's main repository](https://github.com/InsightSoftwareConsortium/ITK), as well as many other ITK projects such as the [ITKExamples](https://github.com/InsightSoftwareConsortium/ITKExamples), and many [ITK remote modules](https://github.com/InsightSoftwareConsortium). It is now very easy for anyone to participate in the development of the library. This has already been a success with many new authors getting involved and submitting patches through the GitHub pull-request mechanism. This change also includes moving the issue tracker to the [GitHub issue tracker](https://github.com/InsightSoftwareConsortium/ITK/issues) where any problem encountered with ITK should be reported. ITK's GitHub migration was explained in more detail in [ITK 5.0 Beta 3: GitHub](https://discourse.itk.org/t/itk-5-0-beta-3-github/1504). Finally, moving ITK to GitHub made it straightforward to use Microsoft Azure Pipeline Continuous Integration platform: Each pull-request is tested on all 3 major platforms (Windows, Linux, MacOS) and Python builds can be requested to ensure that a patch can be integrated.

**C++11**

Major C++ code refactoring brought dramatic improvements to ITK's API and performance (see [ITK 5.0 Alpha 1: Modern C++](https://discourse.itk.org/t/itk-5-0-alpha-1-modern-c/843) for more details). ITK now uses the C\++11 standard allowing the developers full access to its new powerful features such as range-based loops, constexpr, lambda expressions, and uniform initialization syntax. Using C++ 11 also removes the necessity of many ITK macros (e.g. `ITK_NULLPTR`, `ITK_DELETED_FUNCTION`) which have equivalents in the new standard. This also leads to changes in style to match the C++ 11 best practices. This includes replacing `typedef` calls with the `using` keyword to improve source code readability. ITK's C++ code is easier to read, understand, and maintain!

**Thread Pool**

This new release of ITK also integrates big performance improvements thanks to the refactoring of the multithreading infrastructure with a thread pool available by default, and the possible usage of the Intel Threading Building Blocks (TBB) threading backend (see [ITK 5.0 Alpha 2: Performance](https://discourse.itk.org/t/itk-5-0-alpha-2-performance/959) for benchmarks).

**Spatial Objects**

Additionally, a major upgrade of the ITK Spatial Object framework, which provides a representation of objects and the mechanism to specify their spatial relationship relative to other objects in a scene, was integrated in this new version of ITK. The new code improves consistency in the programming interface and simplifies implementation and usage (more details in [ITK 5.0 Release Candidate 2: Spatial Object’s](https://blog.kitware.com/itk-5-0-release-candidate-2-spatial-objects).

**Ranges**

ITK 5.0 has a new [Experimental namespace](https://docs.itk.org/projects/doxygen/en/stable/namespaceitk_1_1Experimental.html). This namespace includes three _range_ class templates, `ShapedImageNeighborhoodRange`, `IndexRange`, and `ImageBufferRange`, to iterate efficiently over a neighborhood of pixels, the indices of an image region, and the pixels of an image buffer, respectively. These ranges can be used in a C++11 range-base for-loop. Their `begin()` and `end()` can be passed directly to an `std` algorithm.

**New Features**

Other new features in this ITK release include new algorithms, better mesh support (see [ITK 5.0 Release Candidate 1: Meshes](https://discourse.itk.org/t/itk-5-0-release-candidate-1-meshes/1576)), new global variable model using one singleton, and better streaming capabilities.

**Third Party Libraries**

Eigen, a C++ library for linear algebra, was integrated in ITK and gradual transition from VXL to Eigen for Linear algebra is planned. Many third party libraries were updated: VNL, DCMTK, GDCM, HDF5, KWSys, MetaIO, Zlib, GIFTI, nifti, pygccxml.

**Remote Modules**

Remote modules, which allow easy integration of new image processing algorithm in ITK, were updated and new Python packages compatible with this new release of ITK were created. Four new remote modules were also added to ITK: PhaseSymmetry, IOOpenSlide, Montage, and BSplineGradient (description of the modules in [ITK 5.0 Beta 3: GitHub](https://discourse.itk.org/t/itk-5-0-beta-3-github/1504)).

**Python**

Traditionally, ITK in Python had to be used through an object-oriented interface. In this new release, we have added a functional interface which is more Pythonic and should be more familiar to Python programmers. Examples on how to use this new procedural interface are available in  [ITK 5.0 Beta 1: Pythonic Interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271).

**Congratulations**

Congratulations and thank you to everyone who contributed to this release. Of the 49 authors, we would like to specially recognize the new contributors, Isaiah Norton, maekclena, Rashad Kanavath, Bai Shi, Hui Xie, Martino Pilia, Ally Warner, pierre33, Chao Wu, Gregory C. Sharp, Bryce A Besler, Kwame Kutten, Mihail Isakov, Jerome Schmid, Roman Grothausmann, Alexis Girault, Gabriel A. Devenyi, Marian Klymov, Thomas Janvier, and Forrest Li.

**Migration to ITKv5**

The [ITK 5 Migration Guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md) is available to help transition a code base from ITK 4 to ITK 5. Please discuss your experiences on [Discourse](https://discourse.itk.org).

What's Next
-----------

Join us in the creation of advanced, open source scientific image analysis tools. Get started with the [ITK examples](https://itk.org/ITKExamples/). Take part in the community discussion at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

We have a soft commitment to backwards compatibility to address any potential API or architectual issues until the [next feature release](https://github.com/InsightSoftwareConsortium/ITK/milestone/6). Stay tuned for upcoming announcements on ITK's integration with modern web technologies and improved support for Remote Module development on GitHub.

**Enjoy ITK!**

Changes from 5.0 RC 2 to 5.0.0
------------------------------

```
Alexis Girault @agirault (4):
      ENH: Compare images converted from and to VTK in ITKVtkGlue tests
      ENH: Pass directions in VTKImage import/export classes
      ENH: Throw exception when necessary while importing a vtk image
      BUG: Ignore calls to the direction APIs in VTK if lower than 8.90

Bradley Lowekamp @blowekamp (46):
      COMP: Address const char[] conversation warning
      BUG: Fix leaking PNGIO resources during exception
      BUG: Remove redundent fclose on PNG file pointer
      ENH: Add Valgrind suppression file for Ubuntu 18.04 LTS
      BUG: Update FEM test for new spatial objects
      COMP: Correct continuous index type
      BUG: Address valgrid defects related to the PointSpatialObject
      BUG: Fix ownership of environment variable value
      BUG: Fix leak in SpatialObject InternalClone method
      ENH: Update a couple example to use the resample instead of warp
      BUG: Set all component of 3D points
      BUG: Add named output support to StreamingImageFilter
      ENH: Deprecate VectorResampleImageFilter
      ENH: Consolidating setting compression level interface to ImageIOBase
      ENH: Implement InternalSetCompressor method in ImageIOs
      DOC: Add compression documentation to ImageIOs
      ENH: Use the empty string "" for the default compressor
      ENH: Add compression level support to NRRD IO
      ENH: Improve TIFF ImageIO compression testing
      ENH: Add base class for generic streaming processes
      ENH: Add ImageSink base filter class
      ENH: Use streaming base class for LabelStatisticsImageFilter
      ENH: Use named input in LabelStatisticsImageFilter
      ENH: Add streaming support to StatisticsImageFilter
      ENH: Add testing for streaming with StatisticsImageFilter
      ENH: Remove output image, use standard decorator macros
      ENH: Refactor min/max filter to use ImageSink
      ENH: Add ImageSink::VerifyInputInformation
      ENH: Add KWStyle override for ImageStatistics module
      ENH: Use streaming sink base class for image to histogram filters
      ENH: Deprecate ImageTransformer class
      BUG: Update NormalizeImageFilter with double graft mini-pipeline
      DOC: statistics filter changes for ITKv5
      ENH: Add Python wrapping for streaming base classes
      ENH: Add streaming testing of label statistics filter
      COMP: Move deprecated VectorCastImageFilter wrapping to deprecated
      BUG: Fix path for Brain Web data
      BUG: Correct StreamingProcessObject's progress computation
      STYLE: prefer variable-less catch re-throw
      BUG: Set current request number back to -1 after stream execution
      ENH: Expose streaming methods in MinimumMaximumImageFilter
      ENH: Add streaming testing for min max filter
      ENH: replace RGB adaptor with directly using CastImageFilter
      ENH: Add cast support for per component conversion
      ENH: Mark the Cast functor to be remove with legacy code
      DOC: Update documentation for streaming statistics filters.

Dženan Zukić @dzenanz (25):
      ENH: make ITK_MAX_THREADS configurable
      BUG: fix threading test bugs when ITK_DEFAULT_MAX_THREADS is over 256
      COMP: compile GPU classes with legacies disabled
      COMP: removing extraneous DLL specification from private member
      COMP: follow-up on recent removal of METAIO_STL macro
      COMP: add missing dependent module for ITKv3 examples
      COMP: ResampleImageFilter does not have SetDisplacementField method
      ENH: reduce default compression level for much faster compression
      BUG: compression was accidentally disabled in NrrdImageIO
      COMP: compile in ITK
      STYLE: move ivar default values to header file
      ENH: expose setting compression level in ImageFileWriter
      ENH: expose compression level in MetaImageIO
      BUG: the clang version check was overly strict on Apple platforms
      COMP: fix build failures introduced by c76b193 (#886)
      ENH: cleaning up tests which are almost exact duplicates from MetaIO
      ENH: updating remote modules
      COMP: fix warning: 'return' will never be executed
      COMP: fix export specification of Barrier class
      COMP: follow up to 814419a (bounding box m_CornersContainer removal)
      ENH: LevelSetsv4Visualization has moved to remote module ITKVtkGlue
      ENH: run large image IO tests serially
      ENH: enabling ResampleImage streaming test and updating baselines
      ENH: enabling ResampleImage streaming test and updating baselines
      ENH: exclude Eigen3 from the list of default modules

Francois Budin @fbudin69500 (19):
      ENH: Add `fallback_only` parameter to `imread()` Python function
      ENH: Add suffix to Azure build running gcov to differentiate them
      STYLE: Add display name to checkout step in AzurePipelineBatch.yml
      ENH: Add JUnit test formatter to AzurePipelinesBatch.yml
      STYLE: Add badge for Azure pipeline Linux code coverage build
      ENH: Warning when trying to open in Python an image file that doesn't exist
      BUG: Missing `ci_addons` to convert ctest results to JUnit format
      BUG: Disable itkObjectFactoryBasePrivateDestructor test with -static link flag
      ENH: Add Python function to print Python class name corresponding to C++ class
      ENH: Python ImageFileReader error message improvement
      ENH: Warning when trying to open in Python an image file that doesn't exist
      ENH: Follow up commit to fix itkBoundingBox with LEGACY support
      ENH: Follow up commit to fix itkBoundingBox with LEGACY support
      BUG: std::list of `LineSpatialObject` needs to be wrapped
      BUG: ITK could not find Eigen3::Eigen target when using system Eigen
      BUG: Revert changing call to `Initialize()` with `clear()`
      BUG: Corner positions were inserted at the end of a list that was initialized
      BUG: Enforces consistent types
      BUG: Remote modules Python files (*.so, *.py) were built in the wrong folder

GDCM Upstream (1):
      GDCM 2019-05-16 (e405908e)

Hans J. Johnson @hjmjohnson (20):
      BUG: Usage name did not match file name.
      STYLE: Minor indentation improvements.
      ENH: Enable ITKV3_COMPATIBILITY option
      STYLE: Remove outdated python examples
      STYLE: Syncronize changes between RegistrationITKv[34]
      STYLE: Remove RegistrationITKv3 duplicate examples
      ENH: Remove ITKV3_COMPATIBILITY support from ITKv5.0
      STYLE: Move deprecated Examples/RegistrationITKv3 to test
      BUG: Explicit RegisterRequiredFactories needed as test
      STYLE: Remove Software Guide tags from ITKv3 testing
      DOC: Make use of checkboxes consistent with github
      ENH: Add cmake override for GIT_TAG of remote modules
      STYLE: Remove custom environmental override for WikiExamples
      DOC: Fix spelling errors
      ENH: Identify histogram min/max for UseSampledPointSet
      BUG: itkConfigure.h defines ITK_DEFAULT_MAX_THREADS
      COMP: Remove unused static variable warning
      DOC: Remove documentation references to VectorResampleImageFilter
      DOC: Remove VectorCastImage documentation references
      ENH: Changes required for ITKv5 compatibility

Jon Haitz Legarreta Gorroño @jhlegarreta (4):
      STYLE: Remove tab.
      DOC: Improve remote modules' maintenance scripts documentation
      ENH: Add a script to apply another script to all remotes
      DOC: Modify the CoC breach reporting procedure

Mathieu Malaterre @malaterre (3):
      STYLE: Teach git about GDCM oversize file
      BUG: Do not include COPYING from a non existing directory
      DOC: Fix old reference to Image Number

Matthew McCormick @thewtex (23):
      COMP: Wrap functions for WindowedSincInterpolateImageFunction
      COMP: Wrapping windowed sinc function includes
      COMP: Update for changes to VTK target names
      DOC: Improve ease of release note command execution
      DOC: Document generation of MD5SUMS and SHA512SUMS files for releases
      DOC: Add More Information section to CONTRIBUTING
      DOC: Add ITK 5.0 RC 2 release notes
      BUG: PythonFindEmptyClasses test for windowed-sinc functions
      BUG: Prevent ITKMesh README.md from installation as header
      BUG: Fix identification of Clang major version
      COMP: ImageMaskSpatialObjectGTest array initialization
      COMP: ImageMaskSpatialObjectGTest add braces for initialization
      ENH: Expand ResampleImageFilter requested region by interpolator domain
      STYLE: Use typename instead of class in ImageSink
      STYLE: override methods should not be marked virtual
      BUG: ImageSink defines UpdateLargestPossibleRegion
      STYLE: StreamingProcessingObject passing void with no arguments
      BUG: {MinimumMaximum,StatisticsImageFilter} set PrimaryOutputName
      BUG: Remove MinimumMaximumImageFilter from module2module test pipeline
      BUG: InterpolateImageFunction::GetRadius hidden in ITKV4_COMPATIBILITY
      BUG: Condition Eigen export code on ITK_BINARY_DIR
      BUG: Fix ITKv3 registration test names for property setting
      BUG: Remove CTEST_TEST_TIME debug message

MetaIO Maintainers (5):
      MetaIO 2019-05-03 (7e16abe1)
      MetaIO 2019-05-08 (dd5089a2)
      MetaIO 2019-05-15 (bffb2ef1)
      MetaIO 2019-05-16 (5010ab63)
      MetaIO 2019-05-21 (368213e5)

Niels Dekker @N-Dekker (21):
      ENH: Add std style reverse iterators to FixedArray
      ENH: Add ImageMaskSpatialObject::ComputeMyBoundingBoxInIndexSpace()
      STYLE: SpatialObject() = default, const BoundingBox, Transform members
      ENH: Added tests for ImageMaskSpatialObject::IsInside
      ENH: Test ImageMaskSpatialObject::IsInside independent of distant pixels
      BUG: Fix issue #785 removing BoundingBox check from ImageMask IsInside
      PERF: Overload SpatialObject IsInsideInObjectSpace without name argument
      BUG: Half a pixel margin ImageMaskSpatialObject::ComputeMyBoundingBox()
      STYLE: Deprecated FixedArray member functions rBegin() and rEnd()
      STYLE: Replace std::swap_ranges by C++11 std::swap of m_InternalArray
      DOC: Use the term "object space" for ObjectSpace based member functions
      STYLE: Replace unsigned short by unsigned int as FixedArray index type
      STYLE: Explicitly defaulted default-constructors Vector Accessor classes
      STYLE: Ensure that ContinuousIndex TCoordRep is a floating point type
      ENH: Convenience overloads for ImageBase Transform member functions
      ENH: Add NumberOfCorners and ComputeCorners() to BoundingBox
      STYLE: Remove (deprecate) BoundingBox::GetCorners() + m_CornersContainer
      COMP: Fixed GCC4 missing-field-initializers warning on `{}` in GTest
      DOC: Fixed Doxygen description BoundingBox Get member functions
      DOC: Fixed Doxygen description BoundingBox Get member functions
      STYLE: Rename ITK macro EXPECT_VECTOR_NEAR to ITK_EXPECT_VECTOR_NEAR

Roman Grothausmann @romangrothausmann (1):
      ENH: Bump remote module ParabolicMorphology

Simon Rit @SimonRit (4):
      COMP: remove MSVC 14 C4800 (performance) warnings with FFTW
      COMP: remove unused parameter warning with GCC 4.8.5
      COMP: fix wrong GDCM library names for open jpeg
      ENH: update RTK remote file with release tag v2.0.1

VXL Maintainers (1):
      VNL 2019-05-08 (99697e67)

@maekclena (8):
      ENH: Update compiler macros (#810)
      BUG: Remove error prone test case
      BUG: Fix reverse iterator increment return type
      ENH: Add iterator increment operator return value test
      BUG: Minor python wrapping fixes
      ENH: Remove duplicate code
      ENH: Use ResampleImageFilter for vectors
      ENH: Deprecate VectorCastImageFilter (#870)
```
