import { MetricBasic, MetricVariance, OtGlyph } from "@ot-builder/ot-glyphs";
import { Fvar, Head, MetricHead } from "@ot-builder/ot-metadata";
import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
export declare class HmtxStat implements OtGlyph.Stat.Sink {
    private hhea;
    private head;
    private readonly outer?;
    hmtx: MetricBasic.Table;
    hvar: Data.Maybe<MetricVariance.Table>;
    minLeftSideBearing: number;
    minRightSideBearing: number;
    xMaxExtent: number;
    xMaxAdvance: number;
    hOrgStartAtZero: boolean;
    constructor(hhea: MetricHead.Table, head: Head.Table, fvar?: Data.Maybe<Fvar.Table>, outer?: Data.Maybe<OtGlyph.Stat.Sink>);
    setNumGlyphs(count: number): void;
    setMetric(gid: number, horizontal: OtGlyph.Metric, vertical: OtGlyph.Metric, extent: OtGlyph.Stat.BoundingBox): void;
    simpleGlyphStat(st: OtGlyph.Stat.SimpleGlyphStat): void;
    complexGlyphStat(st: OtGlyph.Stat.ComplexGlyphStat): void;
    instructionsStat(size: number): void;
    settle(): void;
}
export declare function statLongMetricCount(hea: MetricHead.Table, mtx: MetricBasic.Table): void;
export declare class HmtxCoStat implements OtGlyph.CoStat.Source {
    private alwaysStartAtZero;
    private hmtx;
    private hvar?;
    private outer?;
    constructor(alwaysStartAtZero: boolean, hmtx: MetricBasic.Table, hvar?: Data.Maybe<MetricVariance.Table>, outer?: Data.Maybe<OtGlyph.CoStat.Source>);
    getHMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): {
        start: OtVar.Value;
        end: OtVar.Value;
    };
    getVMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): Data.Maybe<import("@ot-builder/ot-glyphs/lib/general-glyph/metric").T<OtVar.Value>>;
}
//# sourceMappingURL=hmtx.d.ts.map