"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyFvarTable = void 0;
const Ot = require("@ot-builder/ot");
function rectifyFvarTable(rec, fvar) {
    const axes = rectifyAxesImpl(rec, fvar);
    const instances = rectifyInstances(rec, rec.addedAxes, fvar);
    return new Ot.Fvar.Table(axes, instances);
}
exports.rectifyFvarTable = rectifyFvarTable;
function rectifyAxesImpl(rectify, fvar) {
    const axesRectifyResults = new Map();
    for (const a of fvar.axes) {
        const a1 = rectify.axis(a);
        if (a1)
            axesRectifyResults.set(a, a1);
    }
    const axes = [...axesRectifyResults.values(), ...rectify.addedAxes];
    return axes;
}
function rectifyInstances(rec, addedAxes, fvar) {
    const newInstances = [];
    for (const instance of fvar.instances) {
        const coordinates = instance.coordinates;
        const coordinates1 = rectifyCoordinates(coordinates, rec, addedAxes);
        newInstances.push(new Ot.Fvar.Instance(instance.subfamilyNameID, instance.flags, coordinates1, instance.postScriptNameID));
    }
    return newInstances;
}
function rectifyCoordinates(coordinates, rec, addedAxes) {
    if (!coordinates)
        return coordinates;
    const coordinates1 = new Map();
    for (const [d, val] of coordinates) {
        const mapped = rec.dim(d);
        if (mapped)
            coordinates1.set(mapped, val);
    }
    for (const axis of addedAxes)
        coordinates1.set(axis.dim, 0);
    return coordinates1;
}
//# sourceMappingURL=fvar.js.map