# Generated by Django 4.0.4 on 2022-05-27 21:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import oauth2_provider.generators
import oauth2_provider.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        migrations.swappable_dependency(settings.OAUTH2_PROVIDER_ID_TOKEN_MODEL),
        ('tests', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='basetestapplication',
            name='algorithm',
            field=models.CharField(blank=True, choices=[('', 'No OIDC support'), ('RS256', 'RSA with SHA-2 256'), ('HS256', 'HMAC with SHA-2 256')], default='', max_length=5),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='allowed_schemes',
            field=models.TextField(blank=True),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='authorization_grant_type',
            field=models.CharField(choices=[('authorization-code', 'Authorization code'), ('implicit', 'Implicit'), ('password', 'Resource owner password-based'), ('client-credentials', 'Client credentials'), ('openid-hybrid', 'OpenID connect hybrid')], max_length=32),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='client_id',
            field=models.CharField(db_index=True, default=oauth2_provider.generators.generate_client_id, max_length=100, unique=True),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='client_secret',
            field=oauth2_provider.models.ClientSecretField(blank=True, db_index=True, default=oauth2_provider.generators.generate_client_secret, help_text='Hashed on Save. Copy it now if this is a new secret.', max_length=255),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='client_type',
            field=models.CharField(choices=[('confidential', 'Confidential'), ('public', 'Public')], max_length=32),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='name',
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='redirect_uris',
            field=models.TextField(blank=True, help_text='Allowed URIs list, space separated'),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='skip_authorization',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='basetestapplication',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='application',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='custom_field',
            field=models.CharField(max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='expires',
            field=models.DateTimeField(),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='id_token',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='access_token', to=settings.OAUTH2_PROVIDER_ID_TOKEN_MODEL),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='scope',
            field=models.TextField(blank=True),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='source_refresh_token',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='s_refreshed_access_token', to=settings.OAUTH2_PROVIDER_REFRESH_TOKEN_MODEL),
        ),
        migrations.AddField(
            model_name="sampleaccesstoken",
            name="token",
            field=models.TextField(),
        ),
        migrations.AddField(
            model_name="sampleaccesstoken",
            name="token_checksum",
            field=models.CharField(max_length=64, unique=True, db_index=True),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='sampleaccesstoken',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='algorithm',
            field=models.CharField(blank=True, choices=[('', 'No OIDC support'), ('RS256', 'RSA with SHA-2 256'), ('HS256', 'HMAC with SHA-2 256')], default='', max_length=5),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='authorization_grant_type',
            field=models.CharField(choices=[('authorization-code', 'Authorization code'), ('implicit', 'Implicit'), ('password', 'Resource owner password-based'), ('client-credentials', 'Client credentials'), ('openid-hybrid', 'OpenID connect hybrid')], max_length=32),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='client_id',
            field=models.CharField(db_index=True, default=oauth2_provider.generators.generate_client_id, max_length=100, unique=True),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='client_secret',
            field=oauth2_provider.models.ClientSecretField(blank=True, db_index=True, default=oauth2_provider.generators.generate_client_secret, help_text='Hashed on Save. Copy it now if this is a new secret.', max_length=255),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='client_type',
            field=models.CharField(choices=[('confidential', 'Confidential'), ('public', 'Public')], max_length=32),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='custom_field',
            field=models.CharField(max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='name',
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='redirect_uris',
            field=models.TextField(blank=True, help_text='Allowed URIs list, space separated'),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='skip_authorization',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='sampleapplication',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='application',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='claims',
            field=models.TextField(blank=True),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='code',
            field=models.CharField(max_length=255, unique=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='code_challenge',
            field=models.CharField(blank=True, default='', max_length=128),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='code_challenge_method',
            field=models.CharField(blank=True, choices=[('plain', 'plain'), ('S256', 'S256')], default='', max_length=10),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='custom_field',
            field=models.CharField(max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='expires',
            field=models.DateTimeField(),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='nonce',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='redirect_uri',
            field=models.TextField(),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='scope',
            field=models.TextField(blank=True),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='samplegrant',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='access_token',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='s_refresh_token', to=settings.OAUTH2_PROVIDER_ACCESS_TOKEN_MODEL),
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='application',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='custom_field',
            field=models.CharField(max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='revoked',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='token',
            field=models.CharField(default=1, max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='samplerefreshtoken',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='basetestapplication',
            name='id',
            field=models.BigAutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name='sampleaccesstoken',
            name='id',
            field=models.BigAutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name='sampleapplication',
            name='id',
            field=models.BigAutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name='samplegrant',
            name='id',
            field=models.BigAutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name='samplerefreshtoken',
            name='id',
            field=models.BigAutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterUniqueTogether(
            name='samplerefreshtoken',
            unique_together={('token', 'revoked')},
        ),
    ]
