# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Unit tests for the Debusine exceptions."""

from typing import Any
from unittest import TestCase

from debusine.client.exceptions import DebusineError


class DebusineErrorTests(TestCase):
    """Tests for DebusineError exception."""

    def test_asdict(self) -> None:
        """Test asdict() returns the dictionary."""
        data: dict[str, Any] = {
            "title": "The title of the error",
            "detail": "The detail of the error",
            "status_code": 418,
        }
        debusine_error = DebusineError(**data)

        self.assertEqual(debusine_error.asdict(), data)

    def test_str(self) -> None:
        for exc, expected in (
            (DebusineError(title="title"), "title"),
            (DebusineError(title="title", status_code=418), "418 title"),
            (DebusineError(title="title", detail="desc"), "title: desc"),
            (
                DebusineError(title="title", detail="desc", status_code=418),
                "418 title: desc",
            ),
        ):
            with self.subTest(exc=exc.asdict()):
                self.assertEqual(str(exc), expected)
